(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_transfer-out-list_transfer-out-list_module_ts"],{

/***/ 7427:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/transfer-out-list/transfer-out-list-routing.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TransferOutListPageRoutingModule: () => (/* binding */ TransferOutListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _transfer_out_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transfer-out-list.page */ 71621);




const routes = [{
  path: '',
  component: _transfer_out_list_page__WEBPACK_IMPORTED_MODULE_0__.TransferOutListPage
}];
let TransferOutListPageRoutingModule = class TransferOutListPageRoutingModule {};
TransferOutListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], TransferOutListPageRoutingModule);


/***/ }),

/***/ 46018:
/*!*********************************************************************!*\
  !*** ./src/app/pages/transfer-out-list/transfer-out-list.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TransferOutListPageModule: () => (/* binding */ TransferOutListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _transfer_out_list_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transfer-out-list-routing.module */ 7427);
/* harmony import */ var _transfer_out_list_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./transfer-out-list.page */ 71621);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let TransferOutListPageModule = class TransferOutListPageModule {};
TransferOutListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule, _transfer_out_list_routing_module__WEBPACK_IMPORTED_MODULE_0__.TransferOutListPageRoutingModule],
  declarations: [_transfer_out_list_page__WEBPACK_IMPORTED_MODULE_1__.TransferOutListPage]
})], TransferOutListPageModule);


/***/ }),

/***/ 71621:
/*!*******************************************************************!*\
  !*** ./src/app/pages/transfer-out-list/transfer-out-list.page.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TransferOutListPage: () => (/* binding */ TransferOutListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _transfer_out_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./transfer-out-list.page.html?ngResource */ 93943);
/* harmony import */ var _transfer_out_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./transfer-out-list.page.scss?ngResource */ 4139);
/* harmony import */ var _transfer_out_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_transfer_out_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_plw_transfer_out_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/plw_transfer_out_api.service */ 58455);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _TransferOutListPage;



/* eslint-disable @typescript-eslint/naming-convention */






let TransferOutListPage = (_TransferOutListPage = class TransferOutListPage {
  constructor(transferOutApi, alertController, b, change, router) {
    this.transferOutApi = transferOutApi;
    this.alertController = alertController;
    this.b = b;
    this.change = change;
    this.router = router;
    this.allTransfers = [];
    this.isLoading = true;
    // Filters
    this.filterStatus = '';
    this.filterSyncStatus = '';
    this.filterDirection = '';
    // Pagination
    this.currentPage = 1;
    this.itemsPerPage = 10;
    this.totalItems = 0;
    this.totalPages = 0;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__.ICONS;
  }
  ngOnInit() {
    this.currentUser = this.b.getCurrentUser();
    this.loadTransferOuts();
  }
  loadTransferOuts(event) {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.isLoading = true;
      _this.change.markForCheck();
      try {
        const filters = {
          page: _this.currentPage,
          per_page: _this.itemsPerPage
        };
        if (_this.filterStatus) {
          filters.status = _this.filterStatus;
        }
        if (_this.filterSyncStatus) {
          filters.sync_status = _this.filterSyncStatus;
        }
        if (_this.filterDirection) {
          filters.direction = _this.filterDirection;
        }
        const result = yield _this.transferOutApi.getTransferOutList(filters);
        if (result.success && result.data) {
          _this.allTransfers = result.data.transfers || [];
          _this.currentInfId = result.data.current_inf_id;
          // Set pagination info
          if (result.data.pagination) {
            _this.totalItems = result.data.pagination.total;
            _this.totalPages = result.data.pagination.last_page;
            _this.currentPage = result.data.pagination.current_page;
          }
        } else {
          _this.allTransfers = [];
          _this.totalItems = 0;
          _this.totalPages = 0;
        }
      } catch (error) {
        _this.b.errorToast('Failed to load transfer requests');
        _this.allTransfers = [];
        _this.totalItems = 0;
        _this.totalPages = 0;
      } finally {
        _this.isLoading = false;
        if (event) {
          event.target.complete();
        }
        _this.change.markForCheck();
      }
    })();
  }
  // Apply filters and reset to page 1
  applyFilters() {
    this.currentPage = 1;
    this.loadTransferOuts();
  }
  // Clear all filters
  clearFilters() {
    this.filterStatus = '';
    this.filterSyncStatus = '';
    this.filterDirection = '';
    this.currentPage = 1;
    this.loadTransferOuts();
  }
  // Items per page change handler
  onItemsPerPageChange() {
    this.currentPage = 1;
    this.loadTransferOuts();
  }
  // Pagination methods
  nextPage() {
    if (this.currentPage < this.totalPages) {
      this.currentPage++;
      this.loadTransferOuts();
    }
  }
  previousPage() {
    if (this.currentPage > 1) {
      this.currentPage--;
      this.loadTransferOuts();
    }
  }
  goToPage(page) {
    if (page >= 1 && page <= this.totalPages) {
      this.currentPage = page;
      this.loadTransferOuts();
    }
  }
  getTransferStatusColor(status) {
    switch (status) {
      case 'Pending':
        return 'warning';
      case 'Received':
        return 'success';
      case 'Reject':
        return 'danger';
      default:
        return 'medium';
    }
  }
  getSyncStatusColor(syncStatus) {
    switch (syncStatus) {
      case 'synced':
        return 'success';
      case 'created':
        return 'primary';
      case 'updated':
        return 'warning';
      case 'deleted':
        return 'danger';
      default:
        return 'medium';
    }
  }
  deleteTransfer(transfer) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Only allow deletion for pending and unsynced transfers
      if (transfer.status !== 'Pending') {
        _this2.b.toast('Only pending transfers can be deleted');
        return;
      }
      const alert = yield _this2.alertController.create({
        header: 'Confirm Delete',
        message: 'Are you sure you want to delete this transfer request?',
        buttons: [{
          text: 'Cancel',
          role: 'cancel'
        }, {
          text: 'Delete',
          role: 'destructive',
          handler: function () {
            var _ref = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
              try {
                const result = yield _this2.transferOutApi.deleteTransferOut(transfer.id);
                _this2.b.responseToast(result);
                if (result.success) {
                  _this2.loadTransferOuts();
                }
              } catch (error) {
                _this2.b.errorToast('Error deleting transfer request');
              }
            });
            return function handler() {
              return _ref.apply(this, arguments);
            };
          }()
        }]
      });
      yield alert.present();
    })();
  }
  editTransfer(transfer) {
    if (transfer !== null && transfer !== void 0 && transfer.plw_id) {
      // Navigate to PLW transfer out create/edit page
      this.router.navigate(['/plw-transfer-out-create', transfer.plw_id]);
    } else {
      this.b.errorToast('Unable to edit this transfer');
    }
  }
  viewBeneficiary(transfer) {
    if (transfer !== null && transfer !== void 0 && transfer.plw_id) {
      this.router.navigate(['/woman-detail', transfer.plw_id]);
    } else {
      this.b.errorToast('Unable to view beneficiary');
    }
  }
  formatDate(dateString) {
    if (!dateString) return '';
    const date = new Date(dateString);
    if (isNaN(date.getTime())) return '';
    return date.toLocaleDateString('en-US', {
      year: 'numeric',
      month: 'short',
      day: 'numeric'
    });
  }
  // Check if transfer is IN or OUT
  isTransferOut(transfer) {
    return transfer.from_inf === this.currentInfId;
  }
  isTransferIn(transfer) {
    return transfer.to_inf === this.currentInfId;
  }
  // Check if user can edit/delete
  canEditTransfer(transfer) {
    return this.isTransferOut(transfer) && transfer.status === 'Pending' && transfer.sync_status !== 'synced';
  }
  // Check if view button should show for transfer out
  canViewTransferOut(transfer) {
    return transfer.status === 'Pending' || transfer.status === 'Reject';
  }
}, _TransferOutListPage.ctorParameters = () => [{
  type: src_app_services_plw_transfer_out_api_service__WEBPACK_IMPORTED_MODULE_4__.PlwTransferOutAPIService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.AlertController
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectorRef
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.Router
}], _TransferOutListPage);
TransferOutListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-transfer-out-list',
  template: _transfer_out_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectionStrategy.OnPush,
  styles: [(_transfer_out_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], TransferOutListPage);


/***/ }),

/***/ 58455:
/*!**********************************************************!*\
  !*** ./src/app/services/plw_transfer_out_api.service.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlwTransferOutAPIService: () => (/* binding */ PlwTransferOutAPIService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 61318);

/* eslint-disable max-len */
/* eslint-disable @typescript-eslint/naming-convention */




let PlwTransferOutAPIService = class PlwTransferOutAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_0__.APIBaseService {
  constructor() {
    super(...arguments);
    this.namespace = '/plw-transfer-out';
  }
  /**
   * Get prerequisite data for creating/editing a transfer out
   * Returns existing unsynced transfer if exists
   */
  getTransferOutPreqData(plwId) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}-create/${plwId}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  /**
   * Create or update a transfer out request
   */
  transferOutStore(body) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/store`;
    return this.http.post(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  /**
   * Get list of all transfer outs from current INF
   * Supports filtering by status, sync_status, direction, and pagination
   */
  getTransferOutList(filters) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}`;
    const params = [];
    if (filters) {
      if (filters.status) {
        params.push(`status=${filters.status}`);
      }
      if (filters.sync_status) {
        params.push(`sync_status=${filters.sync_status}`);
      }
      if (filters.direction) {
        params.push(`direction=${filters.direction}`);
      }
      if (filters.page) {
        params.push(`page=${filters.page}`);
      }
      if (filters.per_page) {
        params.push(`per_page=${filters.per_page}`);
      }
    }
    if (params.length > 0) {
      url += `?${params.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  /**
   * Delete a transfer out request
   */
  deleteTransferOut(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
};
PlwTransferOutAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], PlwTransferOutAPIService);


/***/ }),

/***/ 4139:
/*!********************************************************************************!*\
  !*** ./src/app/pages/transfer-out-list/transfer-out-list.page.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `ion-icon {
  margin-inline-end: 0.75em !important;
}

:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 0;
  padding: 16px 20px;
  gap: 16px;
  flex-wrap: wrap;
  background: linear-gradient(135deg, rgba(73, 144, 226, 0.05) 0%, rgba(109, 90, 230, 0.05) 100%);
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}

.section-title {
  display: flex;
  align-items: center;
  gap: 12px;
  font-size: 18px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1;
}
.section-title ion-icon {
  font-size: 22px;
  flex-shrink: 0;
}

.compact-summary {
  background: linear-gradient(135deg, rgba(73, 144, 226, 0.03) 0%, rgba(109, 90, 230, 0.03) 100%);
  border-radius: 8px;
  padding: 12px 8px;
  margin-bottom: 16px;
  border: 1px solid rgba(73, 144, 226, 0.1);
}
.compact-summary ion-row {
  margin: 0;
}
.compact-summary ion-col {
  padding: 4px 8px;
}

.compact-summary-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 8px;
  gap: 4px;
  text-align: center;
}
.compact-summary-item .compact-label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  margin-bottom: 2px;
}
.compact-summary-item .compact-value {
  font-size: 20px;
  font-weight: 700;
  color: var(--ion-color-primary);
  line-height: 1;
}
.compact-summary-item .compact-badge {
  font-size: 14px;
  font-weight: 700;
  padding: 4px 10px;
  border-radius: 6px;
}

.nutrition-breakdown-grid {
  padding: 0;
  margin: 0;
}
.nutrition-breakdown-grid ion-row {
  margin: 0;
}
.nutrition-breakdown-grid ion-col {
  padding: 0 4px;
}

.nutrition-status-item {
  background: white;
  border-radius: 6px;
  padding: 6px;
  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
  border: 1px solid rgba(0, 0, 0, 0.06);
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 0;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 100%;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 12px 8px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: normal;
  word-wrap: break-word;
}
.measurements-table td {
  padding: 12px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table td.name-cell {
  text-align: left;
  padding-left: 12px;
}
.measurements-table td.date-cell {
  font-weight: 500;
  color: var(--ion-color-dark);
  white-space: nowrap;
}
.measurements-table td.children-cell {
  max-width: 200px;
  text-align: left;
  padding-left: 12px;
}
.measurements-table td.actions-cell {
  white-space: nowrap;
  width: 120px;
  padding: 10px 8px;
}
.measurements-table td.actions-cell ion-button {
  margin: 0 2px;
  --padding-start: 6px;
  --padding-end: 6px;
}
.measurements-table td.actions-cell .disabled-text {
  color: var(--ion-color-medium);
  font-size: 0.9rem;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: rgba(73, 144, 226, 0.03);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

.beneficiary-info {
  display: flex;
  flex-direction: column;
  gap: 4px;
  align-items: flex-start;
}

.beneficiary-name {
  font-weight: 600;
  color: var(--ion-color-primary);
  font-size: 0.9rem;
}

.beneficiary-fcn {
  font-size: 11px;
  color: var(--ion-color-medium);
  font-weight: 500;
}

.children-list {
  display: flex;
  flex-direction: column;
  gap: 4px;
}

.child-item {
  display: flex;
  gap: 4px;
  font-size: 0.85rem;
  line-height: 1.3;
}
.child-item .child-name {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.child-item .child-gender {
  font-size: 0.8rem;
  color: var(--ion-color-medium);
  font-weight: 500;
}

.filter-item {
  --background: rgba(73, 144, 226, 0.02);
  --border-radius: 8px;
  margin-bottom: 12px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.filter-item ion-label {
  font-size: 12px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin-bottom: 4px;
}

.filter-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  margin-top: 8px;
}
.filter-btn ion-icon {
  font-size: 18px;
}

.items-per-page {
  display: flex;
  align-items: center;
  gap: 8px;
}
.items-per-page ion-label {
  font-size: 13px;
  font-weight: 500;
  color: var(--ion-color-medium);
  white-space: nowrap;
}
.items-per-page ion-select {
  font-size: 14px;
  font-weight: 600;
  min-width: 70px;
  --padding-start: 8px;
  --padding-end: 8px;
}

.table-card-content {
  padding: 0 !important;
}
.table-card-content .table-container {
  border-radius: 0;
  border: none;
  margin: 0;
}

.pagination-container {
  display: flex;
  flex-direction: column;
  gap: 12px;
  padding: 16px 0;
  margin-top: 16px;
  border-top: 1px solid var(--ion-color-light);
}

.pagination-info {
  text-align: center;
  font-size: 0.85rem;
  color: var(--ion-color-medium);
  font-weight: 500;
}

.pagination-controls {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  flex-wrap: wrap;
}
.pagination-controls ion-button {
  --padding-start: 12px;
  --padding-end: 12px;
  height: 36px;
  font-size: 0.85rem;
  font-weight: 500;
}
.pagination-controls ion-button:disabled {
  opacity: 0.4;
}

.page-numbers {
  display: flex;
  gap: 4px;
  align-items: center;
}
.page-numbers ion-button {
  --padding-start: 8px;
  --padding-end: 8px;
  min-width: 36px;
  height: 36px;
  font-weight: 600;
}
.page-numbers ion-button.active-page {
  --background: var(--ion-color-primary);
  --color: white;
  font-weight: 700;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 80px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 64px;
  margin-bottom: 20px;
}
.empty-state h3 {
  font-size: 20px;
  font-weight: 600;
  margin: 0 0 10px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 350px;
}

@media (max-width: 768px) {
  .pagination-container {
    padding: 12px 0;
    gap: 8px;
  }
  .pagination-info {
    font-size: 0.8rem;
  }
  .pagination-controls {
    gap: 6px;
  }
  .pagination-controls ion-button {
    height: 32px;
    font-size: 0.8rem;
    --padding-start: 8px;
    --padding-end: 8px;
  }
  .page-numbers {
    gap: 2px;
  }
  .page-numbers ion-button {
    min-width: 32px;
    height: 32px;
    --padding-start: 6px;
    --padding-end: 6px;
  }
}
@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header {
    padding: 14px 16px;
  }
  .section-title {
    font-size: 16px;
  }
  .section-title ion-icon {
    font-size: 20px;
  }
  .compact-summary {
    padding: 10px 6px;
  }
  .compact-summary-item {
    padding: 6px;
  }
  .compact-summary-item .compact-label {
    font-size: 10px;
  }
  .compact-summary-item .compact-value {
    font-size: 18px;
  }
  .compact-summary-item .compact-badge {
    font-size: 12px;
    padding: 3px 8px;
  }
  .measurements-table {
    min-width: 100%;
  }
  .measurements-table th {
    padding: 10px 6px;
    font-size: 0.8rem;
  }
  .measurements-table td {
    padding: 10px 6px;
    font-size: 0.8rem;
  }
  .measurements-table td.name-cell {
    padding-left: 10px;
  }
  .beneficiary-name {
    font-size: 0.85rem;
  }
  .beneficiary-fcn {
    font-size: 10px;
  }
  .child-item {
    font-size: 0.8rem;
  }
  .child-item .child-name {
    font-size: 0.8rem;
  }
  .child-item .child-gender {
    font-size: 0.75rem;
  }
  .filter-item {
    margin-bottom: 8px;
  }
  .filter-item ion-label {
    font-size: 11px;
  }
  .filter-btn {
    height: 40px;
    font-size: 13px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .pagination-container {
    padding: 10px 0;
    gap: 6px;
  }
  .pagination-info {
    font-size: 0.75rem;
  }
  .pagination-controls {
    gap: 4px;
  }
  .pagination-controls ion-button {
    height: 28px;
    font-size: 0.75rem;
    --padding-start: 6px;
    --padding-end: 6px;
  }
  .page-numbers {
    gap: 2px;
  }
  .page-numbers ion-button {
    min-width: 28px;
    height: 28px;
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .section-header {
    padding: 12px 12px;
  }
  .section-title {
    font-size: 15px;
  }
  .section-title ion-icon {
    font-size: 18px;
  }
  .compact-summary {
    padding: 8px 4px;
    margin-bottom: 12px;
  }
  .compact-summary-item {
    padding: 4px;
  }
  .compact-summary-item .compact-label {
    font-size: 9px;
  }
  .compact-summary-item .compact-value {
    font-size: 16px;
  }
  .compact-summary-item .compact-badge {
    font-size: 11px;
    padding: 2px 6px;
  }
  .measurements-table {
    min-width: 100%;
  }
  .measurements-table th {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .measurements-table td.name-cell {
    padding-left: 8px;
  }
  .measurements-table td.actions-cell {
    padding: 8px 4px;
  }
  .measurements-table td.actions-cell ion-button {
    margin: 0 1px;
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .beneficiary-name {
    font-size: 0.8rem;
  }
  .beneficiary-fcn {
    font-size: 9px;
  }
  .child-item {
    font-size: 0.75rem;
  }
  .child-item .child-name {
    font-size: 0.75rem;
  }
  .child-item .child-gender {
    font-size: 0.7rem;
  }
  .empty-state {
    padding: 60px 16px;
  }
  .empty-state ion-icon {
    font-size: 48px;
    margin-bottom: 16px;
  }
  .empty-state h3 {
    font-size: 18px;
  }
  .empty-state p {
    font-size: 13px;
  }
  .filter-item {
    margin-bottom: 6px;
  }
  .filter-item ion-label {
    font-size: 10px;
  }
  .filter-btn {
    height: 38px;
    font-size: 12px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/transfer-out-list/transfer-out-list.page.scss"],"names":[],"mappings":"AACA;EACE,oCAAA;AAAF;;AAGA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AADF;;AAIA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AADF;AAGE;EACE,eAAA;EACA,cAAA;AADJ;;AAMA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AAHF;;AAMA;EACE,gBAAA;EACA,wBAAA;AAHF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,gBAAA;EACA,kBAAA;EACA,SAAA;EACA,eAAA;EACA,+FAAA;EACA,4CAAA;AAJF;;AAQA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,OAAA;AALF;AAOE;EACE,eAAA;EACA,cAAA;AALJ;;AAUA;EACE,+FAAA;EACA,kBAAA;EACA,iBAAA;EACA,mBAAA;EACA,yCAAA;AAPF;AASE;EACE,SAAA;AAPJ;AAUE;EACE,gBAAA;AARJ;;AAYA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,YAAA;EACA,QAAA;EACA,kBAAA;AATF;AAWE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,kBAAA;AATJ;AAYE;EACE,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,cAAA;AAVJ;AAaE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;AAXJ;;AAeA;EACE,UAAA;EACA,SAAA;AAZF;AAcE;EACE,SAAA;AAZJ;AAeE;EACE,cAAA;AAbJ;;AAiBA;EACE,iBAAA;EACA,kBAAA;EACA,YAAA;EACA,yCAAA;EACA,qCAAA;AAdF;;AAkBA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,aAAA;AAfF;;AAkBA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;AAfF;AAiBE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;EACA,qBAAA;AAfJ;AAkBE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAhBJ;AAkBI;EACE,gBAAA;EACA,kBAAA;AAhBN;AAmBI;EACE,gBAAA;EACA,4BAAA;EACA,mBAAA;AAjBN;AAoBI;EACE,gBAAA;EACA,gBAAA;EACA,kBAAA;AAlBN;AAqBI;EACE,mBAAA;EACA,YAAA;EACA,iBAAA;AAnBN;AAqBM;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AAnBR;AAsBM;EACE,8BAAA;EACA,iBAAA;AApBR;AAyBE;EACE,yBAAA;AAvBJ;AAyBI;EACE,0CAAA;AAvBN;AA2BE;EACE,mBAAA;AAzBJ;;AA8BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,uBAAA;AA3BF;;AA8BA;EACE,gBAAA;EACA,+BAAA;EACA,iBAAA;AA3BF;;AA8BA;EACE,eAAA;EACA,8BAAA;EACA,gBAAA;AA3BF;;AA+BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AA5BF;;AA+BA;EACE,aAAA;EACA,QAAA;EACA,kBAAA;EACA,gBAAA;AA5BF;AA8BE;EACE,gBAAA;EACA,4BAAA;AA5BJ;AA+BE;EACE,iBAAA;EACA,8BAAA;EACA,gBAAA;AA7BJ;;AAkCA;EACE,sCAAA;EACA,oBAAA;EACA,mBAAA;EACA,qCAAA;AA/BF;AAiCE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AA/BJ;;AAmCA;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,eAAA;AAhCF;AAkCE;EACE,eAAA;AAhCJ;;AAqCA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;AAlCF;AAoCE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,mBAAA;AAlCJ;AAqCE;EACE,eAAA;EACA,gBAAA;EACA,eAAA;EACA,oBAAA;EACA,kBAAA;AAnCJ;;AAwCA;EACE,qBAAA;AArCF;AAuCE;EACE,gBAAA;EACA,YAAA;EACA,SAAA;AArCJ;;AA0CA;EACE,aAAA;EACA,sBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,4CAAA;AAvCF;;AA0CA;EACE,kBAAA;EACA,kBAAA;EACA,8BAAA;EACA,gBAAA;AAvCF;;AA0CA;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,QAAA;EACA,eAAA;AAvCF;AAyCE;EACE,qBAAA;EACA,mBAAA;EACA,YAAA;EACA,kBAAA;EACA,gBAAA;AAvCJ;AAyCI;EACE,YAAA;AAvCN;;AA4CA;EACE,aAAA;EACA,QAAA;EACA,mBAAA;AAzCF;AA2CE;EACE,oBAAA;EACA,kBAAA;EACA,eAAA;EACA,YAAA;EACA,gBAAA;AAzCJ;AA2CI;EACE,sCAAA;EACA,cAAA;EACA,gBAAA;AAzCN;;AA+CA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA5CF;AA8CE;EACE,eAAA;EACA,mBAAA;AA5CJ;AA+CE;EACE,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;AA7CJ;AAgDE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AA9CJ;;AAmDA;EACE;IACE,eAAA;IACA,QAAA;EAhDF;EAmDA;IACE,iBAAA;EAjDF;EAoDA;IACE,QAAA;EAlDF;EAoDE;IACE,YAAA;IACA,iBAAA;IACA,oBAAA;IACA,kBAAA;EAlDJ;EAsDA;IACE,QAAA;EApDF;EAsDE;IACE,eAAA;IACA,YAAA;IACA,oBAAA;IACA,kBAAA;EApDJ;AACF;AAyDA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EAvDF;EA0DA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EAxDF;EA2DA;IACE,eAAA;IACA,WAAA;EAzDF;EA2DE;IACE,eAAA;EAzDJ;EA6DA;IACE,mBAAA;EA3DF;EA8DA;IACE,kBAAA;EA5DF;EA+DA;IACE,eAAA;EA7DF;EA+DE;IACE,eAAA;EA7DJ;EAiEA;IACE,iBAAA;EA/DF;EAkEA;IACE,YAAA;EAhEF;EAkEE;IACE,eAAA;EAhEJ;EAmEE;IACE,eAAA;EAjEJ;EAoEE;IACE,eAAA;IACA,gBAAA;EAlEJ;EAsEA;IACE,eAAA;EApEF;EAsEE;IACE,iBAAA;IACA,iBAAA;EApEJ;EAuEE;IACE,iBAAA;IACA,iBAAA;EArEJ;EAuEI;IACE,kBAAA;EArEN;EA0EA;IACE,kBAAA;EAxEF;EA2EA;IACE,eAAA;EAzEF;EA4EA;IACE,iBAAA;EA1EF;EA4EE;IACE,iBAAA;EA1EJ;EA6EE;IACE,kBAAA;EA3EJ;EA+EA;IACE,kBAAA;EA7EF;EA+EE;IACE,eAAA;EA7EJ;EAiFA;IACE,YAAA;IACA,eAAA;EA/EF;AACF;AAkFA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EAhFF;EAmFA;IACE,mBAAA;EAjFF;EAoFA;IACE,eAAA;EAlFF;EAoFE;IACE,eAAA;EAlFJ;EAsFA;IACE,mBAAA;EApFF;EAuFA;IACE,eAAA;IACA,QAAA;EArFF;EAwFA;IACE,kBAAA;EAtFF;EAyFA;IACE,QAAA;EAvFF;EAyFE;IACE,YAAA;IACA,kBAAA;IACA,oBAAA;IACA,kBAAA;EAvFJ;EA2FA;IACE,QAAA;EAzFF;EA2FE;IACE,eAAA;IACA,YAAA;IACA,oBAAA;IACA,kBAAA;EAzFJ;EA6FA;IACE,kBAAA;EA3FF;EA8FA;IACE,eAAA;EA5FF;EA8FE;IACE,eAAA;EA5FJ;EAgGA;IACE,gBAAA;IACA,mBAAA;EA9FF;EAiGA;IACE,YAAA;EA/FF;EAiGE;IACE,cAAA;EA/FJ;EAkGE;IACE,eAAA;EAhGJ;EAmGE;IACE,eAAA;IACA,gBAAA;EAjGJ;EAqGA;IACE,eAAA;EAnGF;EAqGE;IACE,gBAAA;IACA,kBAAA;EAnGJ;EAsGE;IACE,gBAAA;IACA,kBAAA;EApGJ;EAsGI;IACE,iBAAA;EApGN;EAuGI;IACE,gBAAA;EArGN;EAuGM;IACE,aAAA;IACA,oBAAA;IACA,kBAAA;EArGR;EA2GA;IACE,iBAAA;EAzGF;EA4GA;IACE,cAAA;EA1GF;EA6GA;IACE,kBAAA;EA3GF;EA6GE;IACE,kBAAA;EA3GJ;EA8GE;IACE,iBAAA;EA5GJ;EAgHA;IACE,kBAAA;EA9GF;EAgHE;IACE,eAAA;IACA,mBAAA;EA9GJ;EAiHE;IACE,eAAA;EA/GJ;EAkHE;IACE,eAAA;EAhHJ;EAoHA;IACE,kBAAA;EAlHF;EAoHE;IACE,eAAA;EAlHJ;EAsHA;IACE,YAAA;IACA,eAAA;EApHF;AACF","sourcesContent":["// Import styles consistent with child-detail page\nion-icon {\n  margin-inline-end: .75em !important;\n}\n\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main Section Header (title on left, buttons on right)\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Section Header for Collapsible Cards\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 0;\n  padding: 16px 20px;\n  gap: 16px;\n  flex-wrap: wrap;\n  background: linear-gradient(135deg, rgba(73, 144, 226, 0.05) 0%, rgba(109, 90, 230, 0.05) 100%);\n  border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n}\n\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n  font-size: 18px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1;\n\n  ion-icon {\n    font-size: 22px;\n    flex-shrink: 0;\n  }\n}\n\n// Compact Summary (matching child-detail)\n.compact-summary {\n  background: linear-gradient(135deg, rgba(73, 144, 226, 0.03) 0%, rgba(109, 90, 230, 0.03) 100%);\n  border-radius: 8px;\n  padding: 12px 8px;\n  margin-bottom: 16px;\n  border: 1px solid rgba(73, 144, 226, 0.1);\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 4px 8px;\n  }\n}\n\n.compact-summary-item {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 8px;\n  gap: 4px;\n  text-align: center;\n\n  .compact-label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    margin-bottom: 2px;\n  }\n\n  .compact-value {\n    font-size: 20px;\n    font-weight: 700;\n    color: var(--ion-color-primary);\n    line-height: 1;\n  }\n\n  .compact-badge {\n    font-size: 14px;\n    font-weight: 700;\n    padding: 4px 10px;\n    border-radius: 6px;\n  }\n}\n\n.nutrition-breakdown-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 4px;\n  }\n}\n\n.nutrition-status-item {\n  background: white;\n  border-radius: 6px;\n  padding: 6px;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);\n  border: 1px solid rgba(0, 0, 0, 0.06);\n}\n\n// Measurements Table Styles\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 0;\n}\n\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 100%; // Changed from 700px to fit viewport\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 12px 8px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: normal; // Changed from nowrap to allow text wrapping\n    word-wrap: break-word;\n  }\n\n  td {\n    padding: 12px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n\n    &.name-cell {\n      text-align: left;\n      padding-left: 12px;\n    }\n\n    &.date-cell {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n      white-space: nowrap;\n    }\n\n    &.children-cell {\n      max-width: 200px;\n      text-align: left;\n      padding-left: 12px;\n    }\n\n    &.actions-cell {\n      white-space: nowrap;\n      width: 120px;\n      padding: 10px 8px;\n\n      ion-button {\n        margin: 0 2px;\n        --padding-start: 6px;\n        --padding-end: 6px;\n      }\n\n      .disabled-text {\n        color: var(--ion-color-medium);\n        font-size: 0.9rem;\n      }\n    }\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: rgba(73, 144, 226, 0.03);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n// Beneficiary Info Styles\n.beneficiary-info {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n  align-items: flex-start;\n}\n\n.beneficiary-name {\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  font-size: 0.9rem;\n}\n\n.beneficiary-fcn {\n  font-size: 11px;\n  color: var(--ion-color-medium);\n  font-weight: 500;\n}\n\n// Children List Styles\n.children-list {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n}\n\n.child-item {\n  display: flex;\n  gap: 4px;\n  font-size: 0.85rem;\n  line-height: 1.3;\n\n  .child-name {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n  }\n\n  .child-gender {\n    font-size: 0.8rem;\n    color: var(--ion-color-medium);\n    font-weight: 500;\n  }\n}\n\n// Filter Styles (matching supply transaction)\n.filter-item {\n  --background: rgba(73, 144, 226, 0.02);\n  --border-radius: 8px;\n  margin-bottom: 12px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n\n  ion-label {\n    font-size: 12px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    margin-bottom: 4px;\n  }\n}\n\n.filter-btn {\n  --border-radius: 12px;\n  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n  height: 44px;\n  font-size: 14px;\n  font-weight: 600;\n  text-transform: none;\n  margin-top: 8px;\n\n  ion-icon {\n    font-size: 18px;\n  }\n}\n\n// Items per page selector\n.items-per-page {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n\n  ion-label {\n    font-size: 13px;\n    font-weight: 500;\n    color: var(--ion-color-medium);\n    white-space: nowrap;\n  }\n\n  ion-select {\n    font-size: 14px;\n    font-weight: 600;\n    min-width: 70px;\n    --padding-start: 8px;\n    --padding-end: 8px;\n  }\n}\n\n// Table Card Content\n.table-card-content {\n  padding: 0 !important;\n\n  .table-container {\n    border-radius: 0;\n    border: none;\n    margin: 0;\n  }\n}\n\n// Pagination (matching child-detail)\n.pagination-container {\n  display: flex;\n  flex-direction: column;\n  gap: 12px;\n  padding: 16px 0;\n  margin-top: 16px;\n  border-top: 1px solid var(--ion-color-light);\n}\n\n.pagination-info {\n  text-align: center;\n  font-size: 0.85rem;\n  color: var(--ion-color-medium);\n  font-weight: 500;\n}\n\n.pagination-controls {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  gap: 8px;\n  flex-wrap: wrap;\n\n  ion-button {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    height: 36px;\n    font-size: 0.85rem;\n    font-weight: 500;\n\n    &:disabled {\n      opacity: 0.4;\n    }\n  }\n}\n\n.page-numbers {\n  display: flex;\n  gap: 4px;\n  align-items: center;\n\n  ion-button {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    min-width: 36px;\n    height: 36px;\n    font-weight: 600;\n\n    &.active-page {\n      --background: var(--ion-color-primary);\n      --color: white;\n      font-weight: 700;\n    }\n  }\n}\n\n// Empty State\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 80px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 64px;\n    margin-bottom: 20px;\n  }\n\n  h3 {\n    font-size: 20px;\n    font-weight: 600;\n    margin: 0 0 10px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 350px;\n  }\n}\n\n// Responsive adjustments\n@media (max-width: 768px) {\n  .pagination-container {\n    padding: 12px 0;\n    gap: 8px;\n  }\n\n  .pagination-info {\n    font-size: 0.8rem;\n  }\n\n  .pagination-controls {\n    gap: 6px;\n\n    ion-button {\n      height: 32px;\n      font-size: 0.8rem;\n      --padding-start: 8px;\n      --padding-end: 8px;\n    }\n  }\n\n  .page-numbers {\n    gap: 2px;\n\n    ion-button {\n      min-width: 32px;\n      height: 32px;\n      --padding-start: 6px;\n      --padding-end: 6px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header {\n    padding: 14px 16px;\n  }\n\n  .section-title {\n    font-size: 16px;\n\n    ion-icon {\n      font-size: 20px;\n    }\n  }\n\n  .compact-summary {\n    padding: 10px 6px;\n  }\n\n  .compact-summary-item {\n    padding: 6px;\n\n    .compact-label {\n      font-size: 10px;\n    }\n\n    .compact-value {\n      font-size: 18px;\n    }\n\n    .compact-badge {\n      font-size: 12px;\n      padding: 3px 8px;\n    }\n  }\n\n  .measurements-table {\n    min-width: 100%; // Changed from 650px to fit viewport\n\n    th {\n      padding: 10px 6px;\n      font-size: 0.8rem;\n    }\n\n    td {\n      padding: 10px 6px;\n      font-size: 0.8rem;\n\n      &.name-cell {\n        padding-left: 10px;\n      }\n    }\n  }\n\n  .beneficiary-name {\n    font-size: 0.85rem;\n  }\n\n  .beneficiary-fcn {\n    font-size: 10px;\n  }\n\n  .child-item {\n    font-size: 0.8rem;\n\n    .child-name {\n      font-size: 0.8rem;\n    }\n\n    .child-gender {\n      font-size: 0.75rem;\n    }\n  }\n\n  .filter-item {\n    margin-bottom: 8px;\n\n    ion-label {\n      font-size: 11px;\n    }\n  }\n\n  .filter-btn {\n    height: 40px;\n    font-size: 13px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .pagination-container {\n    padding: 10px 0;\n    gap: 6px;\n  }\n\n  .pagination-info {\n    font-size: 0.75rem;\n  }\n\n  .pagination-controls {\n    gap: 4px;\n\n    ion-button {\n      height: 28px;\n      font-size: 0.75rem;\n      --padding-start: 6px;\n      --padding-end: 6px;\n    }\n  }\n\n  .page-numbers {\n    gap: 2px;\n\n    ion-button {\n      min-width: 28px;\n      height: 28px;\n      --padding-start: 4px;\n      --padding-end: 4px;\n    }\n  }\n\n  .section-header {\n    padding: 12px 12px;\n  }\n\n  .section-title {\n    font-size: 15px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .compact-summary {\n    padding: 8px 4px;\n    margin-bottom: 12px;\n  }\n\n  .compact-summary-item {\n    padding: 4px;\n\n    .compact-label {\n      font-size: 9px;\n    }\n\n    .compact-value {\n      font-size: 16px;\n    }\n\n    .compact-badge {\n      font-size: 11px;\n      padding: 2px 6px;\n    }\n  }\n\n  .measurements-table {\n    min-width: 100%; // Changed from 600px to fit viewport\n\n    th {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n\n    td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n\n      &.name-cell {\n        padding-left: 8px;\n      }\n\n      &.actions-cell {\n        padding: 8px 4px;\n\n        ion-button {\n          margin: 0 1px;\n          --padding-start: 4px;\n          --padding-end: 4px;\n        }\n      }\n    }\n  }\n\n  .beneficiary-name {\n    font-size: 0.8rem;\n  }\n\n  .beneficiary-fcn {\n    font-size: 9px;\n  }\n\n  .child-item {\n    font-size: 0.75rem;\n\n    .child-name {\n      font-size: 0.75rem;\n    }\n\n    .child-gender {\n      font-size: 0.7rem;\n    }\n  }\n\n  .empty-state {\n    padding: 60px 16px;\n\n    ion-icon {\n      font-size: 48px;\n      margin-bottom: 16px;\n    }\n\n    h3 {\n      font-size: 18px;\n    }\n\n    p {\n      font-size: 13px;\n    }\n  }\n\n  .filter-item {\n    margin-bottom: 6px;\n\n    ion-label {\n      font-size: 10px;\n    }\n  }\n\n  .filter-btn {\n    height: 38px;\n    font-size: 12px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 93943:
/*!********************************************************************************!*\
  !*** ./src/app/pages/transfer-out-list/transfer-out-list.page.html?ngResource ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button defaultHref=\"/home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>Transfer Management</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"loadTransferOuts($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n  <ng-container *ngIf=\"!isLoading; else skeleton\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"icons.SWAP_HORIZONTAL\" color=\"primary\"></ion-icon>\n        Transfer Requests\n      </h2>\n    </div>\n\n    <!-- Filter Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <ion-grid>\n            <ion-row>\n              <ion-col size=\"12\" size-md=\"4\">\n                <ion-item lines=\"none\" class=\"filter-item\">\n                  <ion-label position=\"stacked\">Direction</ion-label>\n                  <ion-select [(ngModel)]=\"filterDirection\" interface=\"action-sheet\" placeholder=\"All\">\n                    <ion-select-option value=\"\">All</ion-select-option>\n                    <ion-select-option value=\"out\">OUT</ion-select-option>\n                    <ion-select-option value=\"in\">IN</ion-select-option>\n                  </ion-select>\n                </ion-item>\n              </ion-col>\n              <ion-col size=\"12\" size-md=\"4\">\n                <ion-item lines=\"none\" class=\"filter-item\">\n                  <ion-label position=\"stacked\">Status</ion-label>\n                  <ion-select [(ngModel)]=\"filterStatus\" interface=\"action-sheet\" placeholder=\"All\">\n                    <ion-select-option value=\"\">All</ion-select-option>\n                    <ion-select-option value=\"Pending\">Pending</ion-select-option>\n                    <ion-select-option value=\"Received\">Received</ion-select-option>\n                    <ion-select-option value=\"Reject\">Reject</ion-select-option>\n                  </ion-select>\n                </ion-item>\n              </ion-col>\n              <ion-col size=\"12\" size-md=\"4\">\n                <ion-item lines=\"none\" class=\"filter-item\">\n                  <ion-label position=\"stacked\">Sync Status</ion-label>\n                  <ion-select [(ngModel)]=\"filterSyncStatus\" interface=\"action-sheet\" placeholder=\"All\">\n                    <ion-select-option value=\"\">All</ion-select-option>\n                    <ion-select-option value=\"created\">Created</ion-select-option>\n                    <ion-select-option value=\"updated\">Updated</ion-select-option>\n                    <ion-select-option value=\"synced\">Synced</ion-select-option>\n                    <ion-select-option value=\"deleted\">Deleted</ion-select-option>\n                  </ion-select>\n                </ion-item>\n              </ion-col>\n            </ion-row>\n            <ion-row>\n              <ion-col size=\"12\">\n                <ion-button expand=\"block\" (click)=\"applyFilters()\" color=\"primary\" class=\"filter-btn\">\n                  <ion-icon [name]=\"icons.FILTER\" slot=\"start\"></ion-icon>\n                  Apply Filter\n                </ion-button>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Transfers Table -->\n    <div class=\"card-container\" *ngIf=\"allTransfers && allTransfers.length > 0; else noTransfers\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n            Transfer Records ({{ totalItems }})\n          </h2>\n          <div class=\"items-per-page\">\n            <ion-label>Items per page:</ion-label>\n            <ion-select [(ngModel)]=\"itemsPerPage\" (ionChange)=\"onItemsPerPageChange()\" interface=\"popover\">\n              <ion-select-option [value]=\"10\">10</ion-select-option>\n              <ion-select-option [value]=\"25\">25</ion-select-option>\n              <ion-select-option [value]=\"50\">50</ion-select-option>\n            </ion-select>\n          </div>\n        </div>\n        <ion-card-content class=\"table-card-content\">\n          <div class=\"table-container\">\n            <table class=\"measurements-table\">\n              <thead>\n                <tr>\n                  <th>Direction</th>\n                  <th>Beneficiary</th>\n                  <th>Children</th>\n                  <th>Transfer Date</th>\n                  <th>From/To INF</th>\n                  <th>Status</th>\n                  <th>Sync Status</th>\n                  <th>Actions</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr *ngFor=\"let transfer of allTransfers\">\n                  <td>\n                    <ion-badge [color]=\"isTransferOut(transfer) ? 'primary' : 'secondary'\">\n                      {{ isTransferOut(transfer) ? 'OUT' : 'IN' }}\n                    </ion-badge>\n                  </td>\n                  <td class=\"name-cell\">\n                    <div class=\"beneficiary-info\">\n                      <span class=\"beneficiary-name\">{{ transfer?.plw?.name || '-' }}</span>\n                      <span class=\"beneficiary-fcn\">FCN: {{ transfer?.plw?.fcn || '-' }}</span>\n                    </div>\n                  </td>\n                  <td class=\"children-cell\">\n                    <div *ngIf=\"transfer?.plw?.childrens && transfer.plw.childrens.length > 0\" class=\"children-list\">\n                      <div *ngFor=\"let child of transfer.plw.childrens\" class=\"child-item\">\n                        <span class=\"child-name\">{{ child.name }}</span>\n                        <span class=\"child-gender\">({{ child.gender }})</span>\n                      </div>\n                    </div>\n                    <span *ngIf=\"!transfer?.plw?.childrens || transfer.plw.childrens.length === 0\">\n                      -\n                    </span>\n                  </td>\n                  <td class=\"date-cell\">{{ formatDate(transfer?.created_at) }}</td>\n                  <td>\n                    <span *ngIf=\"isTransferOut(transfer)\">{{ transfer?.transfer_in_to?.title || '-' }}</span>\n                    <span *ngIf=\"isTransferIn(transfer)\">{{ transfer?.transfer_out_from?.title || '-' }}</span>\n                  </td>\n                  <td>\n                    <ion-badge [color]=\"getTransferStatusColor(transfer.status)\">\n                      {{ transfer.status }}\n                    </ion-badge>\n                  </td>\n                  <td>\n                    <ion-badge [color]=\"getSyncStatusColor(transfer.sync_status)\">\n                      {{ transfer.sync_status || '-' }}\n                    </ion-badge>\n                  </td>\n                  <td class=\"actions-cell\">\n                    <!-- For Transfer OUT -->\n                    <ng-container *ngIf=\"isTransferOut(transfer)\">\n                      <!-- View button: only for Pending and Reject -->\n                      <ion-button\n                        *ngIf=\"canViewTransferOut(transfer)\"\n                        fill=\"clear\"\n                        size=\"small\"\n                        color=\"primary\"\n                        (click)=\"viewBeneficiary(transfer)\"\n                        title=\"View Beneficiary\">\n                        <ion-icon [name]=\"icons.EYE\" slot=\"icon-only\"></ion-icon>\n                      </ion-button>\n                      <!-- Edit button: only for Pending and unsynced -->\n                      <ion-button\n                        *ngIf=\"canEditTransfer(transfer)\"\n                        fill=\"clear\"\n                        size=\"small\"\n                        color=\"warning\"\n                        (click)=\"editTransfer(transfer)\"\n                        title=\"Edit Transfer\">\n                        <ion-icon [name]=\"icons.EDIT\" slot=\"icon-only\"></ion-icon>\n                      </ion-button>\n                      <!-- Delete button: only for Pending and unsynced -->\n                      <ion-button\n                        *ngIf=\"canEditTransfer(transfer)\"\n                        fill=\"clear\"\n                        size=\"small\"\n                        color=\"danger\"\n                        (click)=\"deleteTransfer(transfer)\"\n                        title=\"Delete Transfer\">\n                        <ion-icon [name]=\"icons.DELETE\" slot=\"icon-only\"></ion-icon>\n                      </ion-button>\n                      <!-- No actions for Received -->\n                      <span *ngIf=\"transfer.status === 'Received'\" class=\"disabled-text\">-</span>\n                    </ng-container>\n\n                    <!-- For Transfer IN: only view button -->\n                    <ng-container *ngIf=\"isTransferIn(transfer)\">\n                      <ion-button\n                        fill=\"clear\"\n                        size=\"small\"\n                        color=\"primary\"\n                        (click)=\"viewBeneficiary(transfer)\"\n                        title=\"View Beneficiary\">\n                        <ion-icon [name]=\"icons.EYE\" slot=\"icon-only\"></ion-icon>\n                      </ion-button>\n                    </ng-container>\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n\n          <!-- Pagination Controls -->\n          <div class=\"pagination-container\" *ngIf=\"totalPages > 1\">\n            <div class=\"pagination-info\">\n              Showing {{ ((currentPage - 1) * itemsPerPage) + 1 }} to {{ currentPage * itemsPerPage > totalItems ? totalItems : currentPage * itemsPerPage }} of {{ totalItems }} records\n            </div>\n            <div class=\"pagination-controls\">\n              <ion-button fill=\"clear\" size=\"small\" (click)=\"previousPage()\" [disabled]=\"currentPage === 1\">\n                <ion-icon [name]=\"icons.CHEVRON_BACK\"></ion-icon>\n                Previous\n              </ion-button>\n\n              <div class=\"page-numbers\">\n                <ion-button *ngFor=\"let page of [].constructor(totalPages); let i = index\"\n                            fill=\"clear\"\n                            size=\"small\"\n                            [color]=\"currentPage === i + 1 ? 'primary' : 'medium'\"\n                            [class.active-page]=\"currentPage === i + 1\"\n                            (click)=\"goToPage(i + 1)\">\n                  {{ i + 1 }}\n                </ion-button>\n              </div>\n\n              <ion-button fill=\"clear\" size=\"small\" (click)=\"nextPage()\" [disabled]=\"currentPage === totalPages\">\n                Next\n                <ion-icon [name]=\"icons.CHEVRON_FORWARD\"></ion-icon>\n              </ion-button>\n            </div>\n          </div>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <ng-template #noTransfers>\n      <div class=\"empty-state\">\n        <ion-icon [name]=\"icons.SWAP_HORIZONTAL\" color=\"medium\"></ion-icon>\n        <h3>No Transfer Requests</h3>\n        <p>No transfer requests match your filters.</p>\n      </div>\n    </ng-template>\n  </ng-container>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_transfer-out-list_transfer-out-list_module_ts.js.map