(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_supply-detail_supply-detail_module_ts"],{

/***/ 73791:
/*!*********************************************************************!*\
  !*** ./src/app/pages/supply-detail/supply-detail-routing.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyDetailPageRoutingModule: () => (/* binding */ SupplyDetailPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _supply_detail_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-detail.page */ 13009);




const routes = [{
  path: '',
  component: _supply_detail_page__WEBPACK_IMPORTED_MODULE_0__.SupplyDetailPage
}];
let SupplyDetailPageRoutingModule = class SupplyDetailPageRoutingModule {};
SupplyDetailPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SupplyDetailPageRoutingModule);


/***/ }),

/***/ 65774:
/*!*************************************************************!*\
  !*** ./src/app/pages/supply-detail/supply-detail.module.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyDetailPageModule: () => (/* binding */ SupplyDetailPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _supply_detail_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-detail-routing.module */ 73791);
/* harmony import */ var _supply_detail_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-detail.page */ 13009);
/* harmony import */ var _components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/shared.module */ 47774);








let SupplyDetailPageModule = class SupplyDetailPageModule {};
SupplyDetailPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _supply_detail_routing_module__WEBPACK_IMPORTED_MODULE_0__.SupplyDetailPageRoutingModule, _components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule],
  declarations: [_supply_detail_page__WEBPACK_IMPORTED_MODULE_1__.SupplyDetailPage]
})], SupplyDetailPageModule);


/***/ }),

/***/ 13009:
/*!***********************************************************!*\
  !*** ./src/app/pages/supply-detail/supply-detail.page.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyDetailPage: () => (/* binding */ SupplyDetailPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _supply_detail_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-detail.page.html?ngResource */ 9283);
/* harmony import */ var _supply_detail_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-detail.page.scss?ngResource */ 85359);
/* harmony import */ var _supply_detail_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_supply_detail_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/supply_api.service */ 78982);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _SupplyDetailPage;








let SupplyDetailPage = (_SupplyDetailPage = class SupplyDetailPage {
  constructor(route, router, api, b, change) {
    this.route = route;
    this.router = router;
    this.api = api;
    this.b = b;
    this.change = change;
    this.loading = true;
    this.fromRequisitionMode = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__.ICONS;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.supplyId = _this.route.snapshot.paramMap.get('id');
      // Check if we came from requisition mode
      _this.route.queryParams.subscribe(params => {
        _this.fromRequisitionMode = params['fromRequisition'] === 'true';
      });
      if (_this.supplyId) {
        yield _this.loadSupplyDetail();
      } else {
        _this.b.errorToast('Invalid supply ID');
        _this.router.navigate(['/home']);
      }
    })();
  }
  loadSupplyDetail() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this2.loading = true;
        const response = yield _this2.api.getSupplyItemDetail(+_this2.supplyId);
        if (response.success && response.data) {
          _this2.supplyDetail = response.data;
        } else {
          _this2.b.errorToast('Failed to load supply details');
          _this2.router.navigate(['/home']);
        }
      } catch (error) {
        _this2.b.errorToast('Error loading supply details');
        _this2.router.navigate(['/home']);
      } finally {
        _this2.loading = false;
        _this2.change.markForCheck();
      }
    })();
  }
  goBack() {
    var _this$supplyDetail;
    // Navigate back based on the transaction type
    const listType = ((_this$supplyDetail = this.supplyDetail) === null || _this$supplyDetail === void 0 ? void 0 : _this$supplyDetail.transaction_type) === 'Out' ? 'out' : 'in';
    // Preserve requisition mode if we came from it
    if (this.fromRequisitionMode) {
      this.router.navigate(['/manage-supplylist', listType], {
        queryParams: {
          mode: 'requisition'
        }
      });
    } else {
      this.router.navigate(['/manage-supplylist', listType]);
    }
  }
  getStatusColor(status) {
    switch (status === null || status === void 0 ? void 0 : status.toLowerCase()) {
      case 'pending':
        return 'warning';
      case 'approved':
        return 'success';
      case 'rejected':
        return 'danger';
      case 'draft':
        return 'secondary';
      case 'locked':
        return 'tertiary';
      default:
        return 'medium';
    }
  }
  getStatusIcon(status) {
    switch (status === null || status === void 0 ? void 0 : status.toLowerCase()) {
      case 'pending':
        return 'time-outline';
      case 'approved':
        return 'checkmark-circle-outline';
      case 'rejected':
        return 'close-circle-outline';
      case 'draft':
        return 'document-outline';
      case 'locked':
        return 'lock-closed-outline';
      default:
        return 'information-circle-outline';
    }
  }
  getTransactionDefLabel(transactionDef) {
    switch (transactionDef) {
      case 'wh_to_inf':
        return 'Warehouse to INF';
      case 'inf_to_inf':
        return 'INF to INF';
      case 'inf_to_wh':
        return 'INF to Warehouse';
      default:
        return transactionDef || 'N/A';
    }
  }
  isTransactionEditable(status) {
    // Can only edit draft and pending transactions
    const editableStatuses = ['draft', 'pending'];
    return editableStatuses.includes(status === null || status === void 0 ? void 0 : status.toLowerCase());
  }
  approveTransaction() {
    var _this3 = this;
    this.b.loadAlert('Approve Supply Transaction', 'Are you sure you want to approve this supply transaction?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const result = yield _this3.api.approveSupplyStatus(+_this3.supplyId);
        _this3.b.toast(result.message || 'Supply transaction approved successfully');
        if (result.success) {
          yield _this3.loadSupplyDetail();
        }
      } catch (error) {
        _this3.b.errorToast('Error approving supply transaction');
      }
    }));
  }
  formatDateDDMMYYYY(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${day}/${month}/${year}`;
  }
  formatDateTimeToString(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    let hours = date.getHours();
    const minutes = date.getMinutes().toString().padStart(2, '0');
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    const hoursStr = hours.toString().padStart(2, '0');
    return `${day}/${month}/${year} ${hoursStr}:${minutes} ${ampm}`;
  }
  deleteTransaction() {
    var _this4 = this;
    this.b.loadAlert('Delete Supply Transaction', 'Are you sure you want to delete this supply transaction? This action cannot be undone.', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const result = yield _this4.api.deleteSupplyItem(+_this4.supplyId);
        _this4.b.toast(result.message || 'Supply transaction deleted successfully');
        if (result.success) {
          // Navigate back to the list page
          _this4.goBack();
        }
      } catch (error) {
        _this4.b.errorToast('Error deleting supply transaction');
      }
    }));
  }
  isFacilitySupervisor() {
    var _user$user;
    const user = this.b.getCurrentUser();
    return (user === null || user === void 0 || (_user$user = user.user) === null || _user$user === void 0 ? void 0 : _user$user.user_type) === 'Facility Supervisor';
  }
}, _SupplyDetailPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.ActivatedRoute
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.Router
}, {
  type: src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__.SupplyAPIService
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectorRef
}], _SupplyDetailPage);
SupplyDetailPage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-supply-detail',
  template: _supply_detail_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectionStrategy.OnPush,
  styles: [(_supply_detail_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SupplyDetailPage);


/***/ }),

/***/ 85359:
/*!************************************************************************!*\
  !*** ./src/app/pages/supply-detail/supply-detail.page.scss?ngResource ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.detail-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.action-buttons-group {
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
  flex: 0 1 auto;
}
.action-buttons-group .status-chip {
  height: 36px;
  font-weight: 600;
  font-size: 14px;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.detail-item {
  margin-bottom: 16px;
}
.detail-item strong {
  display: block;
  color: var(--ion-color-primary);
  font-size: 12px;
  font-weight: 600;
  margin-bottom: 4px;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.detail-item p {
  margin: 0;
  color: var(--ion-color-dark);
  font-size: 16px;
  word-wrap: break-word;
  line-height: 1.5;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 100%;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 6px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: normal;
  word-wrap: break-word;
}
.measurements-table td {
  padding: 10px 6px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}
.measurements-table .quantity-cell {
  font-weight: 600;
  color: var(--ion-color-success);
  font-size: 15px;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 300px;
}

.approve-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 48px;
  font-size: 16px;
  font-weight: 600;
  text-transform: none;
  margin-top: 8px;
  transition: all 0.3s ease;
}
.approve-btn ion-icon {
  font-size: 20px;
}
.approve-btn:hover {
  transform: translateY(-2px);
  --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);
}
.approve-btn:active {
  transform: translateY(0);
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .action-buttons-group {
    width: 100%;
    justify-content: stretch;
  }
  .action-buttons-group .status-chip {
    height: 32px;
    font-size: 13px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .measurements-table {
    font-size: 0.75rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .detail-item {
    margin-bottom: 12px;
  }
  .detail-item strong {
    font-size: 11px;
  }
  .detail-item p {
    font-size: 14px;
  }
  .approve-btn {
    height: 44px;
    font-size: 14px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .action-buttons-group {
    flex-direction: column;
    gap: 8px;
  }
  .action-buttons-group .status-chip {
    width: 100%;
    justify-content: center;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .measurements-table {
    font-size: 0.7rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 6px 3px;
    font-size: 0.7rem;
  }
  .detail-item {
    margin-bottom: 10px;
  }
  .detail-item strong {
    font-size: 10px;
  }
  .detail-item p {
    font-size: 13px;
  }
  .approve-btn {
    height: 42px;
    font-size: 14px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/supply-detail/supply-detail.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,gBAAA;EACA,cAAA;AADF;;AAIA;EACE,gBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAMA;EACE,aAAA;EACA,SAAA;EACA,eAAA;EACA,mBAAA;EACA,cAAA;AAHF;AAKE;EACE,YAAA;EACA,gBAAA;EACA,eAAA;AAHJ;;AAQA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AALF;;AAQA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AALF;AAOE;EACE,eAAA;EACA,cAAA;AALJ;;AAUA;EACE,mBAAA;AAPF;AASE;EACE,cAAA;EACA,+BAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,yBAAA;EACA,qBAAA;AAPJ;AAUE;EACE,SAAA;EACA,4BAAA;EACA,eAAA;EACA,qBAAA;EACA,gBAAA;AARJ;;AAaA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AAVF;;AAcA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;AAXF;AAaE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;EACA,qBAAA;AAXJ;AAcE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAZJ;AAeE;EACE,yBAAA;AAbJ;AAeI;EACE,6CAAA;AAbN;AAiBE;EACE,mBAAA;AAfJ;AAkBE;EACE,gBAAA;EACA,+BAAA;EACA,eAAA;AAhBJ;;AAqBA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAlBF;AAoBE;EACE,eAAA;EACA,mBAAA;AAlBJ;AAqBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AAnBJ;AAsBE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AApBJ;;AAyBA;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,eAAA;EACA,yBAAA;AAtBF;AAwBE;EACE,eAAA;AAtBJ;AAyBE;EACE,2BAAA;EACA,4CAAA;AAvBJ;AA0BE;EACE,wBAAA;AAxBJ;;AA6BA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EA1BF;EA6BA;IACE,mBAAA;EA3BF;EA8BA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EA5BF;EA+BA;IACE,eAAA;IACA,WAAA;EA7BF;EA+BE;IACE,eAAA;EA7BJ;EAiCA;IACE,WAAA;IACA,wBAAA;EA/BF;EAiCE;IACE,YAAA;IACA,eAAA;EA/BJ;EAmCA;IACE,cAAA;IACA,SAAA;EAjCF;EAmCE;IACE,eAAA;EAjCJ;EAmCI;IACE,eAAA;EAjCN;EAsCA;IACE,kBAAA;IACA,eAAA;EApCF;EAsCE;IACE,gBAAA;IACA,kBAAA;EApCJ;EAwCA;IACE,mBAAA;EAtCF;EAwCE;IACE,eAAA;EAtCJ;EAyCE;IACE,eAAA;EAvCJ;EA2CA;IACE,YAAA;IACA,eAAA;EAzCF;AACF;AA4CA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EA1CF;EA6CA;IACE,mBAAA;EA3CF;EA8CA;IACE,mBAAA;EA5CF;EA+CA;IACE,eAAA;EA7CF;EA+CE;IACE,eAAA;EA7CJ;EAiDA;IACE,sBAAA;IACA,QAAA;EA/CF;EAiDE;IACE,WAAA;IACA,uBAAA;EA/CJ;EAmDA;IACE,cAAA;IACA,QAAA;EAjDF;EAmDE;IACE,eAAA;EAjDJ;EAmDI;IACE,eAAA;EAjDN;EAsDA;IACE,iBAAA;IACA,eAAA;EApDF;EAsDE;IACE,gBAAA;IACA,iBAAA;EApDJ;EAwDA;IACE,mBAAA;EAtDF;EAwDE;IACE,eAAA;EAtDJ;EAyDE;IACE,eAAA;EAvDJ;EA2DA;IACE,YAAA;IACA,eAAA;EAzDF;AACF","sourcesContent":["// Styles matching child-detail design\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.detail-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header (matching child-detail)\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.action-buttons-group {\n  display: flex;\n  gap: 10px;\n  flex-wrap: wrap;\n  align-items: center;\n  flex: 0 1 auto;\n\n  .status-chip {\n    height: 36px;\n    font-weight: 600;\n    font-size: 14px;\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Detail Item Styles\n.detail-item {\n  margin-bottom: 16px;\n\n  strong {\n    display: block;\n    color: var(--ion-color-primary);\n    font-size: 12px;\n    font-weight: 600;\n    margin-bottom: 4px;\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-dark);\n    font-size: 16px;\n    word-wrap: break-word;\n    line-height: 1.5;\n  }\n}\n\n// Table Container (matching child-detail)\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n// Measurements Table Styles (matching child-detail)\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 100%; // Changed from 700px to fit viewport\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 6px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: normal; // Changed from nowrap to allow text wrapping\n    word-wrap: break-word;\n  }\n\n  td {\n    padding: 10px 6px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n\n  .quantity-cell {\n    font-weight: 600;\n    color: var(--ion-color-success);\n    font-size: 15px;\n  }\n}\n\n// Empty State (matching child-detail)\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 300px;\n  }\n}\n\n// Approve Button\n.approve-btn {\n  --border-radius: 12px;\n  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n  height: 48px;\n  font-size: 16px;\n  font-weight: 600;\n  text-transform: none;\n  margin-top: 8px;\n  transition: all 0.3s ease;\n\n  ion-icon {\n    font-size: 20px;\n  }\n\n  &:hover {\n    transform: translateY(-2px);\n    --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);\n  }\n\n  &:active {\n    transform: translateY(0);\n  }\n}\n\n// Mobile and Tablet Responsive Design (matching child-detail)\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .action-buttons-group {\n    width: 100%;\n    justify-content: stretch;\n\n    .status-chip {\n      height: 32px;\n      font-size: 13px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.75rem;\n    min-width: 100%; // Changed from 600px to fit viewport\n\n    th, td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n  }\n\n  .detail-item {\n    margin-bottom: 12px;\n\n    strong {\n      font-size: 11px;\n    }\n\n    p {\n      font-size: 14px;\n    }\n  }\n\n  .approve-btn {\n    height: 44px;\n    font-size: 14px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .action-buttons-group {\n    flex-direction: column;\n    gap: 8px;\n\n    .status-chip {\n      width: 100%;\n      justify-content: center;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.7rem;\n    min-width: 100%; // Changed from 550px to fit viewport\n\n    th, td {\n      padding: 6px 3px;\n      font-size: 0.7rem;\n    }\n  }\n\n  .detail-item {\n    margin-bottom: 10px;\n\n    strong {\n      font-size: 10px;\n    }\n\n    p {\n      font-size: 13px;\n    }\n  }\n\n  .approve-btn {\n    height: 42px;\n    font-size: 14px;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 9283:
/*!************************************************************************!*\
  !*** ./src/app/pages/supply-detail/supply-detail.page.html?ngResource ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button defaultHref=\"/home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>Supply Transaction Details</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"loading; else detailContent\">\n    <app-skeleton></app-skeleton>\n  </div>\n\n  <ng-template #detailContent>\n    <div *ngIf=\"supplyDetail\" class=\"detail-container\">\n      <!-- Header Section -->\n      <div class=\"section-header-main\">\n        <h2 class=\"section-title-main\">\n          <ion-icon [name]=\"icons.CUBE\" color=\"primary\"></ion-icon>\n          {{ supplyDetail.invoice_no || 'Supply Transaction' }}\n        </h2>\n        <div class=\"action-buttons-group\">\n          <ion-chip [color]=\"getStatusColor(supplyDetail.status)\" class=\"status-chip\">\n            <ion-icon [name]=\"getStatusIcon(supplyDetail.status)\"></ion-icon>\n            <ion-label>{{ supplyDetail.status | titlecase }}</ion-label>\n          </ion-chip>\n          <ion-button *ngIf=\"!isFacilitySupervisor() && isTransactionEditable(supplyDetail?.status) && (supplyDetail?.transaction_type?.toLowerCase() === 'in' || supplyDetail?.transaction_type?.toLowerCase() === 'out')\"\n                      [routerLink]=\"supplyDetail?.transaction_type?.toLowerCase() === 'in' ? b.routesConfig.supplyEditIn + supplyDetail?.id : b.routesConfig.supplyEditOut + supplyDetail?.id\"\n                      fill=\"outline\"\n                      color=\"primary\"\n                      size=\"small\">\n            <ion-icon [name]=\"icons.EDIT\" slot=\"start\"></ion-icon>\n            Edit\n          </ion-button>\n          <ion-button *ngIf=\"!isFacilitySupervisor() && isTransactionEditable(supplyDetail?.status)\"\n                      (click)=\"deleteTransaction()\"\n                      fill=\"outline\"\n                      color=\"danger\"\n                      size=\"small\">\n            <ion-icon [name]=\"icons.DELETE\" slot=\"start\"></ion-icon>\n            Delete\n          </ion-button>\n        </div>\n      </div>\n\n      <!-- Transaction Details Card -->\n      <div class=\"card-container\">\n        <ion-card>\n          <div class=\"section-header\">\n            <h2 class=\"section-title\">\n              <ion-icon [name]=\"icons.INFORMATION_CIRCLE\" color=\"primary\"></ion-icon>\n              Transaction Information\n            </h2>\n          </div>\n          <ion-card-content>\n            <ion-grid>\n              <ion-row>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Transaction Type:</strong>\n                    <p>{{ supplyDetail.transaction_type || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Way Bill:</strong>\n                    <p>{{ supplyDetail.waybill || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n              <ion-row>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Source:</strong>\n                    <p>{{ supplyDetail.source_title || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Destination:</strong>\n                    <p>{{ supplyDetail.destination_title || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n              <ion-row>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Transaction Date:</strong>\n                    <p>{{ formatDateDDMMYYYY(supplyDetail.transaction_date) }}</p>\n                  </div>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Created By:</strong>\n                    <p>{{ supplyDetail.user?.name || supplyDetail.user?.email || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n              <ion-row>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Sync Status:</strong>\n                    <p>{{ (supplyDetail.sync_status | titlecase) || 'N/A' }}</p>\n                  </div>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Created At:</strong>\n                    <p>{{ formatDateTimeToString(supplyDetail.created_at) }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n              <ion-row *ngIf=\"supplyDetail.notes\">\n                <ion-col size=\"12\">\n                  <div class=\"detail-item\">\n                    <strong>Notes:</strong>\n                    <p>{{ supplyDetail.notes }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n              <ion-row *ngIf=\"supplyDetail.approved_at\">\n                <ion-col size=\"12\" size-md=\"6\">\n                  <div class=\"detail-item\">\n                    <strong>Approved At:</strong>\n                    <p>{{ formatDateTimeToString(supplyDetail.approved_at) }}</p>\n                  </div>\n                </ion-col>\n              </ion-row>\n            </ion-grid>\n          </ion-card-content>\n        </ion-card>\n      </div>\n\n      <!-- Supply Items Card -->\n      <div class=\"card-container\">\n        <ion-card *ngIf=\"supplyDetail.supply_transaction_details && supplyDetail.supply_transaction_details.length > 0\">\n          <div class=\"section-header\">\n            <h2 class=\"section-title\">\n              <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n              Supply Items ({{ supplyDetail.supply_transaction_details.length }})\n            </h2>\n          </div>\n          <ion-card-content>\n            <div class=\"table-container\">\n              <table class=\"measurements-table\">\n                <thead>\n                  <tr>\n                    <th>#</th>\n                    <th>Item Name</th>\n                    <th>Quantity</th>\n                    <th>Unit</th>\n                    <th>Lot/Batch No</th>\n                    <th>Expire Date</th>\n                  </tr>\n                </thead>\n                <tbody>\n                  <tr *ngFor=\"let detail of supplyDetail.supply_transaction_details; let i = index\">\n                    <td>{{ i + 1 }}</td>\n                    <td>{{ detail.supply_item.title || 'N/A' }}</td>\n                    <td class=\"quantity-cell\">{{ detail.total_quantity || 'N/A' }}</td>\n                    <td>{{ detail.supply_item.unit?.title || 'N/A' }}</td>\n                    <td>{{ detail.lot_no || 'N/A' }}</td>\n                    <td>{{ formatDateDDMMYYYY(detail.expire_date) }}</td>\n                  </tr>\n                </tbody>\n              </table>\n            </div>\n          </ion-card-content>\n        </ion-card>\n\n        <!-- Empty State for Supply Items -->\n        <ion-card *ngIf=\"!supplyDetail.supply_transaction_details || supplyDetail.supply_transaction_details.length === 0\">\n          <ion-card-content>\n            <div class=\"empty-state\">\n              <ion-icon [name]=\"icons.CUBE\" color=\"medium\"></ion-icon>\n              <h3>No Supply Items</h3>\n              <p>No supply items found for this transaction.</p>\n            </div>\n          </ion-card-content>\n        </ion-card>\n      </div>\n\n      <!-- Action Buttons -->\n      <div class=\"card-container\" *ngIf=\"!isFacilitySupervisor() && (supplyDetail?.status?.toLowerCase() === 'pending' || supplyDetail?.status?.toLowerCase() === 'draft')\">\n        <ion-button (click)=\"approveTransaction()\"\n                    color=\"success\"\n                    expand=\"block\"\n                    class=\"approve-btn\">\n          <ion-icon [name]=\"icons.CHECKMARK_CIRCLE\" slot=\"start\"></ion-icon>\n          Confirm Transaction\n        </ion-button>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_supply-detail_supply-detail_module_ts.js.map