(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_supply-avaiable-items_supply-avaiable-items_module_ts"],{

/***/ 61715:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/supply-avaiable-items/supply-avaiable-items-routing.module.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyAvaiableItemsPageRoutingModule: () => (/* binding */ SupplyAvaiableItemsPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _supply_avaiable_items_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-avaiable-items.page */ 42805);




const routes = [{
  path: '',
  component: _supply_avaiable_items_page__WEBPACK_IMPORTED_MODULE_0__.SupplyAvaiableItemsPage
}];
let SupplyAvaiableItemsPageRoutingModule = class SupplyAvaiableItemsPageRoutingModule {};
SupplyAvaiableItemsPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SupplyAvaiableItemsPageRoutingModule);


/***/ }),

/***/ 73106:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/supply-avaiable-items/supply-avaiable-items.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyAvaiableItemsPageModule: () => (/* binding */ SupplyAvaiableItemsPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _supply_avaiable_items_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-avaiable-items-routing.module */ 61715);
/* harmony import */ var _supply_avaiable_items_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-avaiable-items.page */ 42805);







let SupplyAvaiableItemsPageModule = class SupplyAvaiableItemsPageModule {};
SupplyAvaiableItemsPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _supply_avaiable_items_routing_module__WEBPACK_IMPORTED_MODULE_0__.SupplyAvaiableItemsPageRoutingModule],
  declarations: [_supply_avaiable_items_page__WEBPACK_IMPORTED_MODULE_1__.SupplyAvaiableItemsPage]
})], SupplyAvaiableItemsPageModule);


/***/ }),

/***/ 42805:
/*!***************************************************************************!*\
  !*** ./src/app/pages/supply-avaiable-items/supply-avaiable-items.page.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyAvaiableItemsPage: () => (/* binding */ SupplyAvaiableItemsPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _supply_avaiable_items_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-avaiable-items.page.html?ngResource */ 72844);
/* harmony import */ var _supply_avaiable_items_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-avaiable-items.page.scss?ngResource */ 68467);
/* harmony import */ var _supply_avaiable_items_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_supply_avaiable_items_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/supply_api.service */ 78982);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _SupplyAvaiableItemsPage;



/* eslint-disable @typescript-eslint/naming-convention */




let SupplyAvaiableItemsPage = (_SupplyAvaiableItemsPage = class SupplyAvaiableItemsPage {
  constructor(api, change, modalController) {
    this.api = api;
    this.change = change;
    this.modalController = modalController;
    this.supply_items = [];
    this.loading = true;
    this.showTransactionModal = false;
    this.selectedLotTransactions = [];
    this.selectedLotInfo = null;
    this.loadingTransactions = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_4__.ICONS;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.loadInventoryData();
    })();
  }
  loadInventoryData() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this2.loading = true;
        const result = yield _this2.api.getAvaiableSupplyItemList();
        if (result !== null && result !== void 0 && result.data) {
          const {
            supply_item,
            lot_wise_item
          } = result.data;
          _this2.supply_items = _this2.processSupplyData(supply_item, lot_wise_item);
        } else {
          _this2.supply_items = [];
        }
      } catch (error) {
        _this2.supply_items = [];
      } finally {
        _this2.loading = false;
        _this2.change.markForCheck();
      }
    })();
  }
  processSupplyData(supply_items, lot_wise_items) {
    return supply_items.map(item => {
      const lots = lot_wise_items.filter(lot => lot.supply_item_id === item.id);
      const total_available = lots.reduce((sum, lot) => sum + parseFloat(lot.available_in_store || '0'), 0);
      return {
        ...item,
        total_available,
        lots
      };
    });
  }
  getStockColor(quantity) {
    if (quantity <= 0) return 'danger';
    if (quantity < 5) return 'warning';
    return 'success';
  }
  getStockIcon(quantity) {
    if (quantity <= 0) return 'alert-circle-outline';
    if (quantity < 5) return 'warning-outline';
    return 'checkmark-circle-outline';
  }
  getStockStatus(quantity) {
    if (quantity <= 0) return 'Out of Stock';
    if (quantity < 5) return 'Low Stock';
    return 'In Stock';
  }
  isExpiringSoon(expireDate) {
    if (!expireDate) return false;
    const expire = new Date(expireDate);
    const today = new Date();
    const daysUntilExpiry = Math.ceil((expire.getTime() - today.getTime()) / (1000 * 60 * 60 * 24));
    return daysUntilExpiry <= 60;
  }
  formatDate(dateString) {
    if (!dateString) return '-';
    return new Date(dateString).toLocaleDateString();
  }
  formatDateDDMMYYYY(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${day}/${month}/${year}`;
  }
  isLowStock(availableInStore, suppliedAmount) {
    const available = parseFloat((availableInStore === null || availableInStore === void 0 ? void 0 : availableInStore.toString()) || '0');
    const supplied = parseFloat((suppliedAmount === null || suppliedAmount === void 0 ? void 0 : suppliedAmount.toString()) || '0');
    if (supplied <= 0 || available <= 0) return false;
    const percentage = available / supplied * 100;
    return percentage < 20;
  }
  getLowStockItems() {
    const lowStockItems = [];
    this.supply_items.forEach(item => {
      if (item.lots) {
        item.lots.forEach(lot => {
          if (this.isLowStock(lot.available_in_store, lot.supplied_amount)) {
            lowStockItems.push({
              item,
              lot
            });
          }
        });
      }
    });
    return lowStockItems;
  }
  getLowStockCount() {
    return this.getLowStockItems().length;
  }
  getInStockCount() {
    return this.supply_items.filter(item => item.total_available > 0).length;
  }
  getExpiringSoonItems() {
    const expiringItems = [];
    this.supply_items.forEach(item => {
      if (item.lots) {
        item.lots.forEach(lot => {
          if (this.isExpiringSoon(lot.expire_date)) {
            expiringItems.push({
              item,
              lot
            });
          }
        });
      }
    });
    return expiringItems;
  }
  getExpiringSoonCount() {
    return this.getExpiringSoonItems().length;
  }
  hasLowStockLots(item) {
    if (!item.lots) return false;
    return item.lots.some(lot => this.isLowStock(lot.available_in_store, lot.supplied_amount));
  }
  hasExpiringLots(item) {
    if (!item.lots) return false;
    return item.lots.some(lot => this.isExpiringSoon(lot.expire_date));
  }
  scrollToLowStockItem(itemIndex) {
    const element = document.getElementById(`supply-item-${itemIndex}`);
    if (element) {
      element.scrollIntoView({
        behavior: 'smooth',
        block: 'center'
      });
      element.classList.add('highlight-item');
      setTimeout(() => {
        element.classList.remove('highlight-item');
      }, 2000);
    }
  }
  getAccordionHeaderColor(item) {
    return '';
  }
  getStatusBadgeColor(status) {
    if (!status) return 'medium';
    const statusLower = status.toLowerCase();
    if (statusLower === 'active') return 'success';
    if (statusLower === 'inactive') return 'medium';
    return 'medium';
  }
  getStatusClass(quantity) {
    if (quantity <= 0) return 'status-out';
    if (quantity < 5) return 'status-low';
    return 'status-in';
  }
  getItemStatusText(item) {
    const statuses = [];
    if (this.hasLowStockLots(item)) {
      statuses.push('Low Stock');
    }
    if (this.hasExpiringLots(item)) {
      statuses.push('Expiring Soon');
    }
    if (statuses.length === 0) {
      return this.getStockStatus(item.total_available);
    }
    return statuses.join(', ');
  }
  openLotTransactionModal(item, lot) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        var _item$unit;
        _this3.loadingTransactions = true;
        _this3.selectedLotInfo = {
          itemTitle: item.title,
          lotNo: lot.lot_no,
          unit: ((_item$unit = item.unit) === null || _item$unit === void 0 ? void 0 : _item$unit.title) || '-',
          expireDate: lot.expire_date
        };
        _this3.showTransactionModal = true;
        _this3.change.markForCheck();
        const result = yield _this3.api.getLotTransactionList(item.id, lot.lot_no);
        if (result !== null && result !== void 0 && result.data) {
          _this3.selectedLotTransactions = result.data;
        } else {
          _this3.selectedLotTransactions = [];
        }
      } catch (error) {
        _this3.selectedLotTransactions = [];
      } finally {
        _this3.loadingTransactions = false;
        _this3.change.markForCheck();
      }
    })();
  }
  closeTransactionModal() {
    this.showTransactionModal = false;
    this.selectedLotTransactions = [];
    this.selectedLotInfo = null;
    this.change.markForCheck();
  }
  getTransactionTypeColor(transactionType) {
    if (!transactionType) return 'medium';
    const type = transactionType.toLowerCase();
    if (type === 'in') return 'success';
    if (type === 'out') return 'danger';
    return 'medium';
  }
  getTransactionTypeClass(transactionType) {
    if (!transactionType) return 'default';
    const type = transactionType.toLowerCase();
    if (type === 'in') return 'in';
    if (type === 'out') return 'out';
    return 'default';
  }
  formatDateTimeWithHours(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    let hours = date.getHours();
    const minutes = date.getMinutes().toString().padStart(2, '0');
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    const hoursStr = hours.toString().padStart(2, '0');
    return `${day}/${month}/${year} ${hoursStr}:${minutes} ${ampm}`;
  }
  getTransactionTypeCount(type) {
    if (!this.selectedLotTransactions || this.selectedLotTransactions.length === 0) {
      return 0;
    }
    return this.selectedLotTransactions.filter(transaction => {
      var _transaction$supply_t;
      return ((_transaction$supply_t = transaction.supply_transaction) === null || _transaction$supply_t === void 0 || (_transaction$supply_t = _transaction$supply_t.transaction_type) === null || _transaction$supply_t === void 0 ? void 0 : _transaction$supply_t.toUpperCase()) === type;
    }).reduce((sum, transaction) => sum + (parseFloat(transaction.total_quantity) || 0), 0);
  }
  getTransferTypeSummary() {
    if (!this.selectedLotTransactions || this.selectedLotTransactions.length === 0) {
      return [];
    }
    const transferMap = new Map();
    this.selectedLotTransactions.forEach(transaction => {
      var _transaction$supply_t2;
      const transfer = ((_transaction$supply_t2 = transaction.supply_transaction) === null || _transaction$supply_t2 === void 0 ? void 0 : _transaction$supply_t2.transfer_type) || 'Unknown';
      if (transfer && transfer !== 'Unknown') {
        const quantity = parseFloat(transaction.total_quantity) || 0;
        transferMap.set(transfer, (transferMap.get(transfer) || 0) + quantity);
      }
    });
    return Array.from(transferMap.entries()).map(([type, count]) => ({
      type,
      count
    })).sort((a, b) => b.count - a.count);
  }
  getStatusColor(status) {
    if (!status) return 'medium';
    const statusLower = status.toLowerCase();
    if (statusLower === 'approved') return 'success';
    if (statusLower === 'locked') return 'secondary';
    if (statusLower === 'pending') return 'warning';
    if (statusLower === 'draft') return 'tertiary';
    if (statusLower === 'rejected') return 'danger';
    return 'medium';
  }
}, _SupplyAvaiableItemsPage.ctorParameters = () => [{
  type: src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__.SupplyAPIService
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.ChangeDetectorRef
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController
}], _SupplyAvaiableItemsPage);
SupplyAvaiableItemsPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
  selector: 'app-supply-avaiable-items',
  template: _supply_avaiable_items_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_5__.ChangeDetectionStrategy.OnPush,
  styles: [(_supply_avaiable_items_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SupplyAvaiableItemsPage);


/***/ }),

/***/ 68467:
/*!****************************************************************************************!*\
  !*** ./src/app/pages/supply-avaiable-items/supply-avaiable-items.page.scss?ngResource ***!
  \****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.inventory-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.compact-summary {
  background: rgba(73, 144, 226, 0.04);
  border-radius: 8px;
  padding: 12px 8px;
  margin: 0;
  border: 1px solid rgba(73, 144, 226, 0.1);
}
.compact-summary ion-row {
  margin: 0;
}
.compact-summary ion-col {
  padding: 0 6px;
}

.compact-summary-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-align: center;
  padding: 8px 4px;
  background: white;
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.08);
  min-height: 60px;
  transition: all 0.2s ease;
}
.compact-summary-item:hover {
  transform: translateY(-1px);
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
  border-color: rgba(73, 144, 226, 0.2);
}
.compact-summary-item.warning-item {
  position: relative;
}
.compact-summary-item.warning-item ion-icon {
  font-size: 16px;
  margin-bottom: 2px;
}

.compact-label {
  font-size: 10px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  margin-bottom: 4px;
  line-height: 1.2;
}

.compact-value {
  font-size: 14px;
  font-weight: 700;
  color: var(--ion-color-dark);
  line-height: 1.3;
  word-break: break-word;
}

.compact-badge {
  font-size: 11px !important;
  padding: 3px 8px !important;
  font-weight: 600 !important;
}

.low-stock-warning-card {
  border-left: 4px solid var(--ion-color-danger);
  background-color: rgba(var(--ion-color-danger-rgb), 0.05);
  margin-bottom: 1rem;
}

.expiring-warning-card {
  border-left: 4px solid var(--ion-color-warning);
  background-color: rgba(var(--ion-color-warning-rgb), 0.05);
  margin-bottom: 1rem;
}

.warning-content .warning-header {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  margin-bottom: 0.5rem;
}
.warning-content .warning-header ion-icon {
  font-size: 1.5rem;
}
.warning-content .warning-header h3 {
  color: var(--ion-color-danger);
  font-size: 1.1rem;
  font-weight: 600;
  margin: 0;
}
.warning-content p {
  color: var(--ion-color-dark);
  margin: 0 0 1rem 0;
  font-size: 0.9rem;
}
.warning-content .warning-actions {
  display: flex;
  flex-wrap: wrap;
  gap: 0.5rem;
}
.warning-content .warning-actions ion-button {
  --border-radius: 20px;
  font-size: 0.8rem;
}

ion-accordion-group {
  border-radius: 12px;
  overflow: hidden;
}

.supply-accordion {
  margin-bottom: 8px;
  border-radius: 8px;
  overflow: hidden;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
  transition: all 0.3s ease;
}
.supply-accordion.highlight-item {
  transform: scale(1.02);
  box-shadow: 0 8px 20px rgba(var(--ion-color-danger-rgb), 0.3);
  border: 2px solid var(--ion-color-danger);
}
.supply-accordion:hover {
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.12);
}

.accordion-header {
  --padding-start: 12px;
  --padding-end: 12px;
  --inner-padding-end: 8px;
  --min-height: 60px;
  font-weight: 500;
}
.accordion-header ion-icon {
  font-size: 24px;
  margin-right: 12px;
}
.accordion-header ion-label {
  margin: 8px 0;
}
.accordion-header .accordion-title {
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin: 0 0 4px 0;
  display: flex;
  align-items: center;
  gap: 8px;
  flex-wrap: wrap;
}
.accordion-header .accordion-title .item-name-text {
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.accordion-header .accordion-title .item-amount-badge {
  font-size: 16px;
  font-weight: 700;
  color: var(--ion-color-primary);
  background: rgba(var(--ion-color-primary-rgb), 0.1);
  padding: 4px 12px;
  border-radius: 12px;
  border: 1px solid rgba(var(--ion-color-primary-rgb), 0.3);
}
.accordion-header .accordion-title .warning-icon-inline {
  font-size: 18px;
  margin: 0 !important;
  animation: pulse 2s ease-in-out infinite;
}
@keyframes pulse {
  0%, 100% {
    opacity: 1;
  }
  50% {
    opacity: 0.5;
  }
}
.accordion-header .accordion-subtitle {
  font-size: 13px;
  color: var(--ion-color-medium);
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
  align-items: center;
  margin: 0;
}
.accordion-header .accordion-subtitle .total-available {
  font-weight: 600;
  color: var(--ion-color-primary);
}
.accordion-header .accordion-subtitle .separator {
  color: var(--ion-color-light-shade);
}
.accordion-header .accordion-subtitle .lot-count {
  color: var(--ion-color-medium);
}
.accordion-header .accordion-subtitle .status-out {
  color: var(--ion-color-danger);
  font-weight: 600;
}
.accordion-header .accordion-subtitle .status-low {
  color: var(--ion-color-warning);
  font-weight: 600;
}
.accordion-header .accordion-subtitle .status-in {
  color: var(--ion-color-success);
  font-weight: 600;
}
.accordion-header ion-badge {
  font-size: 11px;
  padding: 4px 10px;
  font-weight: 600;
}

.accordion-content {
  padding: 16px;
  background: rgba(0, 0, 0, 0.01);
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.empty-state {
  text-align: center;
  padding: 3rem 2rem;
}
.empty-state ion-icon {
  font-size: 4rem;
  margin-bottom: 1rem;
}
.empty-state h3 {
  color: var(--ion-color-dark);
  margin-bottom: 0.5rem;
  font-size: 1.25rem;
}
.empty-state p {
  color: var(--ion-color-medium);
  margin: 0;
  font-size: 0.9rem;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 3rem 2rem;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 1rem;
}
.loading-container p {
  color: var(--ion-color-medium);
  margin: 0;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 300px;
}

.lots-section {
  margin-top: 0;
}

.lots-title {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin: 0 0 1rem 0;
}
.lots-title ion-icon {
  font-size: 20px;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 100%;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 6px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: normal;
  word-wrap: break-word;
}
.measurements-table td {
  padding: 10px 6px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table td.lot-number {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: left;
}
.measurements-table td.expire-date .warning-text {
  color: var(--ion-color-warning);
  font-weight: 600;
}
.measurements-table td.available-amount .amount-value {
  font-weight: 600;
  color: var(--ion-color-success);
}
.measurements-table td.available-amount .amount-value.low-stock-text {
  color: var(--ion-color-danger);
  font-weight: 700;
}
.measurements-table td.actions-cell {
  white-space: nowrap;
  width: 80px;
  padding: 10px 2px;
}
.measurements-table td.actions-cell ion-button {
  margin: 0 1px;
  --padding-start: 4px;
  --padding-end: 4px;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr.expired-lot {
  background-color: rgba(var(--ion-color-warning-rgb), 0.05);
  border-left: 3px solid var(--ion-color-warning);
}
.measurements-table tbody tr.low-stock-row {
  background-color: rgba(var(--ion-color-danger-rgb), 0.05);
  border-left: 3px solid var(--ion-color-danger);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

.no-lots {
  text-align: center;
  padding: 2rem;
  color: var(--ion-color-medium);
}
.no-lots ion-icon {
  font-size: 2rem;
  margin-bottom: 0.5rem;
}
.no-lots p {
  margin: 0;
  font-size: 0.9rem;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .compact-summary {
    padding: 10px 6px;
  }
  .compact-summary ion-col {
    padding: 0 4px;
  }
  .compact-summary-item {
    padding: 6px 3px;
    min-height: 55px;
  }
  .compact-summary-item.warning-item ion-icon {
    font-size: 14px;
  }
  .compact-label {
    font-size: 9px;
  }
  .compact-value {
    font-size: 13px;
  }
  .compact-badge {
    font-size: 10px !important;
    padding: 2px 6px !important;
  }
  .warning-actions {
    flex-wrap: wrap;
    gap: 6px;
  }
  .warning-actions ion-button {
    font-size: 12px;
    height: 32px;
  }
  .accordion-header {
    --min-height: 56px;
  }
  .accordion-header ion-icon {
    font-size: 20px;
  }
  .accordion-header .accordion-title {
    font-size: 15px;
  }
  .accordion-header .accordion-title .item-name-text {
    font-size: 15px;
  }
  .accordion-header .accordion-title .item-amount-badge {
    font-size: 15px;
    padding: 3px 10px;
  }
  .accordion-header .accordion-title .warning-icon-inline {
    font-size: 16px;
  }
  .accordion-header .accordion-subtitle {
    font-size: 12px;
  }
  .accordion-header ion-badge {
    font-size: 10px;
    padding: 3px 8px;
  }
  .accordion-content {
    padding: 12px;
  }
  .lots-title {
    font-size: 14px;
    margin-bottom: 0.75rem;
  }
  .lots-title ion-icon {
    font-size: 18px;
  }
  .measurements-table {
    font-size: 0.75rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .compact-summary {
    padding: 8px 4px;
  }
  .compact-summary ion-col {
    padding: 0 3px;
  }
  .compact-summary-item {
    padding: 5px 2px;
    min-height: 50px;
  }
  .compact-summary-item.warning-item ion-icon {
    font-size: 12px;
  }
  .compact-label {
    font-size: 8px;
    margin-bottom: 3px;
  }
  .compact-value {
    font-size: 12px;
  }
  .compact-badge {
    font-size: 9px !important;
    padding: 2px 5px !important;
  }
  .warning-actions {
    flex-direction: column;
    gap: 6px;
  }
  .warning-actions ion-button {
    font-size: 11px;
    height: 30px;
    width: 100%;
  }
  .accordion-header {
    --padding-start: 10px;
    --padding-end: 10px;
    --min-height: 52px;
  }
  .accordion-header ion-icon {
    font-size: 18px;
    margin-right: 8px;
  }
  .accordion-header .accordion-title {
    font-size: 14px;
  }
  .accordion-header .accordion-title .item-name-text {
    font-size: 14px;
  }
  .accordion-header .accordion-title .item-amount-badge {
    font-size: 14px;
    padding: 2px 8px;
  }
  .accordion-header .accordion-title .warning-icon-inline {
    font-size: 14px;
  }
  .accordion-header .accordion-subtitle {
    font-size: 11px;
    gap: 4px;
  }
  .accordion-header ion-badge {
    font-size: 9px;
    padding: 2px 6px;
  }
  .accordion-content {
    padding: 10px;
  }
  .lots-title {
    font-size: 13px;
    margin-bottom: 0.5rem;
  }
  .lots-title ion-icon {
    font-size: 16px;
  }
  .measurements-table {
    font-size: 0.7rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 6px 3px;
    font-size: 0.7rem;
  }
}
ion-modal ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.modal-info-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.lot-info-grid {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 12px;
}
.lot-info-grid .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  transition: all 0.2s ease;
}
.lot-info-grid .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.lot-info-grid .info-item ion-icon {
  font-size: 20px;
  flex-shrink: 0;
  margin-top: 2px;
}
.lot-info-grid .info-item .item-content {
  display: flex;
  flex-direction: column;
  gap: 4px;
  flex: 1;
  min-width: 0;
}
.lot-info-grid .info-item .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.lot-info-grid .info-item .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  word-wrap: break-word;
}
.lot-info-grid .info-item .item-content .value.warning-text {
  color: var(--ion-color-warning);
}

.measurements-table tbody tr.transaction-in {
  background-color: rgba(var(--ion-color-success-rgb), 0.05);
  border-left: 3px solid var(--ion-color-success);
}
.measurements-table tbody tr.transaction-in:hover {
  background-color: rgba(var(--ion-color-success-rgb), 0.1);
}
.measurements-table tbody tr.transaction-out {
  background-color: rgba(var(--ion-color-secondary-rgb), 0.05);
  border-left: 3px solid var(--ion-color-secondary);
}
.measurements-table tbody tr.transaction-out:hover {
  background-color: rgba(var(--ion-color-secondary-rgb), 0.1);
}
.measurements-table .quantity-cell {
  font-weight: 600;
  color: var(--ion-color-primary);
}

@media (max-width: 768px) {
  ion-modal ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .lot-info-grid {
    grid-template-columns: repeat(2, 1fr);
    gap: 10px;
  }
  .lot-info-grid .info-item {
    padding: 10px;
  }
  .lot-info-grid .info-item ion-icon {
    font-size: 18px;
  }
  .lot-info-grid .info-item .item-content .label {
    font-size: 10px;
  }
  .lot-info-grid .info-item .item-content .value {
    font-size: 13px;
  }
}
@media (max-width: 480px) {
  ion-modal ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .lot-info-grid {
    gap: 8px;
  }
  .lot-info-grid .info-item {
    padding: 8px;
    gap: 10px;
  }
  .lot-info-grid .info-item ion-icon {
    font-size: 16px;
  }
  .lot-info-grid .info-item .item-content .label {
    font-size: 9px;
  }
  .lot-info-grid .info-item .item-content .value {
    font-size: 12px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/supply-avaiable-items/supply-avaiable-items.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,gBAAA;EACA,cAAA;AADF;;AAIA;EACE,gBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AAJF;AAME;EACE,eAAA;EACA,cAAA;AAJJ;;AASA;EACE,oCAAA;EACA,kBAAA;EACA,iBAAA;EACA,SAAA;EACA,yCAAA;AANF;AAQE;EACE,SAAA;AANJ;AASE;EACE,cAAA;AAPJ;;AAWA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,qCAAA;EACA,gBAAA;EACA,yBAAA;AARF;AAUE;EACE,2BAAA;EACA,yCAAA;EACA,qCAAA;AARJ;AAWE;EACE,kBAAA;AATJ;AAWI;EACE,eAAA;EACA,kBAAA;AATN;;AAcA;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,kBAAA;EACA,gBAAA;AAXF;;AAcA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,sBAAA;AAXF;;AAcA;EACE,0BAAA;EACA,2BAAA;EACA,2BAAA;AAXF;;AAeA;EACE,8CAAA;EACA,yDAAA;EACA,mBAAA;AAZF;;AAeA;EACE,+CAAA;EACA,0DAAA;EACA,mBAAA;AAZF;;AAgBE;EACE,aAAA;EACA,mBAAA;EACA,WAAA;EACA,qBAAA;AAbJ;AAeI;EACE,iBAAA;AAbN;AAgBI;EACE,8BAAA;EACA,iBAAA;EACA,gBAAA;EACA,SAAA;AAdN;AAkBE;EACE,4BAAA;EACA,kBAAA;EACA,iBAAA;AAhBJ;AAmBE;EACE,aAAA;EACA,eAAA;EACA,WAAA;AAjBJ;AAmBI;EACE,qBAAA;EACA,iBAAA;AAjBN;;AAuBA;EACE,mBAAA;EACA,gBAAA;AApBF;;AAuBA;EACE,kBAAA;EACA,kBAAA;EACA,gBAAA;EACA,yCAAA;EACA,yBAAA;AApBF;AAsBE;EACE,sBAAA;EACA,6DAAA;EACA,yCAAA;AApBJ;AAuBE;EACE,yCAAA;AArBJ;;AAyBA;EACE,qBAAA;EACA,mBAAA;EACA,wBAAA;EACA,kBAAA;EACA,gBAAA;AAtBF;AAwBE;EACE,eAAA;EACA,kBAAA;AAtBJ;AAyBE;EACE,aAAA;AAvBJ;AA0BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,iBAAA;EACA,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;AAxBJ;AA0BI;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAxBN;AA2BI;EACE,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,mDAAA;EACA,iBAAA;EACA,mBAAA;EACA,yDAAA;AAzBN;AA4BI;EACE,eAAA;EACA,oBAAA;EACA,wCAAA;AA1BN;AA8BE;EACE;IACE,UAAA;EA5BJ;EA8BE;IACE,YAAA;EA5BJ;AACF;AA+BE;EACE,eAAA;EACA,8BAAA;EACA,aAAA;EACA,eAAA;EACA,QAAA;EACA,mBAAA;EACA,SAAA;AA7BJ;AA+BI;EACE,gBAAA;EACA,+BAAA;AA7BN;AAgCI;EACE,mCAAA;AA9BN;AAiCI;EACE,8BAAA;AA/BN;AAkCI;EACE,8BAAA;EACA,gBAAA;AAhCN;AAmCI;EACE,+BAAA;EACA,gBAAA;AAjCN;AAoCI;EACE,+BAAA;EACA,gBAAA;AAlCN;AAsCE;EACE,eAAA;EACA,iBAAA;EACA,gBAAA;AApCJ;;AAwCA;EACE,aAAA;EACA,+BAAA;AArCF;;AAyCA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AAtCF;;AAyCA;EACE,kBAAA;EACA,kBAAA;AAtCF;AAwCE;EACE,eAAA;EACA,mBAAA;AAtCJ;AAyCE;EACE,4BAAA;EACA,qBAAA;EACA,kBAAA;AAvCJ;AA0CE;EACE,8BAAA;EACA,SAAA;EACA,iBAAA;AAxCJ;;AA4CA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAzCF;AA2CE;EACE,mBAAA;AAzCJ;AA4CE;EACE,8BAAA;EACA,SAAA;AA1CJ;;AA+CA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA5CF;AA8CE;EACE,eAAA;EACA,mBAAA;AA5CJ;AA+CE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AA7CJ;AAgDE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AA9CJ;;AAmDA;EACE,aAAA;AAhDF;;AAmDA;EACE,aAAA;EACA,mBAAA;EACA,WAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AAhDF;AAkDE;EACE,eAAA;AAhDJ;;AAqDA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;AAlDF;AAoDE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;EACA,qBAAA;AAlDJ;AAqDE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAnDJ;AAqDI;EACE,gBAAA;EACA,+BAAA;EACA,gBAAA;AAnDN;AAuDM;EACE,+BAAA;EACA,gBAAA;AArDR;AA0DM;EACE,gBAAA;EACA,+BAAA;AAxDR;AA0DQ;EACE,8BAAA;EACA,gBAAA;AAxDV;AA6DI;EACE,mBAAA;EACA,WAAA;EACA,iBAAA;AA3DN;AA6DM;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AA3DR;AAgEE;EACE,yBAAA;AA9DJ;AAgEI;EACE,6CAAA;AA9DN;AAiEI;EACE,0DAAA;EACA,+CAAA;AA/DN;AAkEI;EACE,yDAAA;EACA,8CAAA;AAhEN;AAoEE;EACE,mBAAA;AAlEJ;;AAsEA;EACE,kBAAA;EACA,aAAA;EACA,8BAAA;AAnEF;AAqEE;EACE,eAAA;EACA,qBAAA;AAnEJ;AAsEE;EACE,SAAA;EACA,iBAAA;AApEJ;;AAyEA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EAtEF;EAyEA;IACE,mBAAA;EAvEF;EA0EA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EAxEF;EA2EA;IACE,eAAA;IACA,WAAA;EAzEF;EA2EE;IACE,eAAA;EAzEJ;EA6EA;IACE,cAAA;IACA,SAAA;EA3EF;EA6EE;IACE,eAAA;EA3EJ;EA6EI;IACE,eAAA;EA3EN;EAgFA;IACE,iBAAA;EA9EF;EAgFE;IACE,cAAA;EA9EJ;EAkFA;IACE,gBAAA;IACA,gBAAA;EAhFF;EAmFI;IACE,eAAA;EAjFN;EAsFA;IACE,cAAA;EApFF;EAuFA;IACE,eAAA;EArFF;EAwFA;IACE,0BAAA;IACA,2BAAA;EAtFF;EAyFA;IACE,eAAA;IACA,QAAA;EAvFF;EAyFE;IACE,eAAA;IACA,YAAA;EAvFJ;EA2FA;IACE,kBAAA;EAzFF;EA2FE;IACE,eAAA;EAzFJ;EA4FE;IACE,eAAA;EA1FJ;EA4FI;IACE,eAAA;EA1FN;EA6FI;IACE,eAAA;IACA,iBAAA;EA3FN;EA8FI;IACE,eAAA;EA5FN;EAgGE;IACE,eAAA;EA9FJ;EAiGE;IACE,eAAA;IACA,gBAAA;EA/FJ;EAmGA;IACE,aAAA;EAjGF;EAoGA;IACE,eAAA;IACA,sBAAA;EAlGF;EAoGE;IACE,eAAA;EAlGJ;EAsGA;IACE,kBAAA;IACA,eAAA;EApGF;EAsGE;IACE,gBAAA;IACA,kBAAA;EApGJ;AACF;AAwGA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EAtGF;EAyGA;IACE,mBAAA;EAvGF;EA0GA;IACE,mBAAA;EAxGF;EA2GA;IACE,eAAA;EAzGF;EA2GE;IACE,eAAA;EAzGJ;EA6GA;IACE,cAAA;IACA,QAAA;EA3GF;EA6GE;IACE,eAAA;EA3GJ;EA6GI;IACE,eAAA;EA3GN;EAgHA;IACE,gBAAA;EA9GF;EAgHE;IACE,cAAA;EA9GJ;EAkHA;IACE,gBAAA;IACA,gBAAA;EAhHF;EAmHI;IACE,eAAA;EAjHN;EAsHA;IACE,cAAA;IACA,kBAAA;EApHF;EAuHA;IACE,eAAA;EArHF;EAwHA;IACE,yBAAA;IACA,2BAAA;EAtHF;EAyHA;IACE,sBAAA;IACA,QAAA;EAvHF;EAyHE;IACE,eAAA;IACA,YAAA;IACA,WAAA;EAvHJ;EA2HA;IACE,qBAAA;IACA,mBAAA;IACA,kBAAA;EAzHF;EA2HE;IACE,eAAA;IACA,iBAAA;EAzHJ;EA4HE;IACE,eAAA;EA1HJ;EA4HI;IACE,eAAA;EA1HN;EA6HI;IACE,eAAA;IACA,gBAAA;EA3HN;EA8HI;IACE,eAAA;EA5HN;EAgIE;IACE,eAAA;IACA,QAAA;EA9HJ;EAiIE;IACE,cAAA;IACA,gBAAA;EA/HJ;EAmIA;IACE,aAAA;EAjIF;EAoIA;IACE,eAAA;IACA,qBAAA;EAlIF;EAoIE;IACE,eAAA;EAlIJ;EAsIA;IACE,iBAAA;IACA,eAAA;EApIF;EAsIE;IACE,gBAAA;IACA,iBAAA;EApIJ;AACF;AA0IE;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AAxIJ;;AA4IA;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAzIF;;AA4IA;EACE,aAAA;EACA,qCAAA;EACA,SAAA;AAzIF;AA2IE;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,yBAAA;AAzIJ;AA2II;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAzIN;AA4II;EACE,eAAA;EACA,cAAA;EACA,eAAA;AA1IN;AA6II;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;AA3IN;AA6IM;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;AA3IR;AA8IM;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,qBAAA;AA5IR;AA8IQ;EACE,+BAAA;AA5IV;;AAsJI;EACE,0DAAA;EACA,+CAAA;AAnJN;AAqJM;EACE,yDAAA;AAnJR;AAuJI;EACE,4DAAA;EACA,iDAAA;AArJN;AAuJM;EACE,2DAAA;AArJR;AA0JE;EACE,gBAAA;EACA,+BAAA;AAxJJ;;AA4JA;EAEI;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EA1JJ;EA8JA;IACE,qCAAA;IACA,SAAA;EA5JF;EA8JE;IACE,aAAA;EA5JJ;EA8JI;IACE,eAAA;EA5JN;EAgKM;IACE,eAAA;EA9JR;EAiKM;IACE,eAAA;EA/JR;AACF;AAqKA;EAEI;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EApKJ;EAwKA;IACE,QAAA;EAtKF;EAwKE;IACE,YAAA;IACA,SAAA;EAtKJ;EAwKI;IACE,eAAA;EAtKN;EA0KM;IACE,cAAA;EAxKR;EA2KM;IACE,eAAA;EAzKR;AACF","sourcesContent":["// Import color variables\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.inventory-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header (matching child-detail)\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Compact Summary Styles (matching child-detail)\n.compact-summary {\n  background: rgba(73, 144, 226, 0.04);\n  border-radius: 8px;\n  padding: 12px 8px;\n  margin: 0;\n  border: 1px solid rgba(73, 144, 226, 0.1);\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n  }\n}\n\n.compact-summary-item {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  text-align: center;\n  padding: 8px 4px;\n  background: white;\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n  min-height: 60px;\n  transition: all 0.2s ease;\n\n  &:hover {\n    transform: translateY(-1px);\n    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);\n    border-color: rgba(73, 144, 226, 0.2);\n  }\n\n  &.warning-item {\n    position: relative;\n\n    ion-icon {\n      font-size: 16px;\n      margin-bottom: 2px;\n    }\n  }\n}\n\n.compact-label {\n  font-size: 10px;\n  font-weight: 600;\n  color: var(--ion-color-medium);\n  text-transform: uppercase;\n  letter-spacing: 0.5px;\n  margin-bottom: 4px;\n  line-height: 1.2;\n}\n\n.compact-value {\n  font-size: 14px;\n  font-weight: 700;\n  color: var(--ion-color-dark);\n  line-height: 1.3;\n  word-break: break-word;\n}\n\n.compact-badge {\n  font-size: 11px !important;\n  padding: 3px 8px !important;\n  font-weight: 600 !important;\n}\n\n// Warning Cards\n.low-stock-warning-card {\n  border-left: 4px solid var(--ion-color-danger);\n  background-color: rgba(var(--ion-color-danger-rgb), 0.05);\n  margin-bottom: 1rem;\n}\n\n.expiring-warning-card {\n  border-left: 4px solid var(--ion-color-warning);\n  background-color: rgba(var(--ion-color-warning-rgb), 0.05);\n  margin-bottom: 1rem;\n}\n\n.warning-content {\n  .warning-header {\n    display: flex;\n    align-items: center;\n    gap: 0.5rem;\n    margin-bottom: 0.5rem;\n    \n    ion-icon {\n      font-size: 1.5rem;\n    }\n    \n    h3 {\n      color: var(--ion-color-danger);\n      font-size: 1.1rem;\n      font-weight: 600;\n      margin: 0;\n    }\n  }\n  \n  p {\n    color: var(--ion-color-dark);\n    margin: 0 0 1rem 0;\n    font-size: 0.9rem;\n  }\n  \n  .warning-actions {\n    display: flex;\n    flex-wrap: wrap;\n    gap: 0.5rem;\n    \n    ion-button {\n      --border-radius: 20px;\n      font-size: 0.8rem;\n    }\n  }\n}\n\n// Accordion Styles\nion-accordion-group {\n  border-radius: 12px;\n  overflow: hidden;\n}\n\n.supply-accordion {\n  margin-bottom: 8px;\n  border-radius: 8px;\n  overflow: hidden;\n  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);\n  transition: all 0.3s ease;\n\n  &.highlight-item {\n    transform: scale(1.02);\n    box-shadow: 0 8px 20px rgba(var(--ion-color-danger-rgb), 0.3);\n    border: 2px solid var(--ion-color-danger);\n  }\n\n  &:hover {\n    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.12);\n  }\n}\n\n.accordion-header {\n  --padding-start: 12px;\n  --padding-end: 12px;\n  --inner-padding-end: 8px;\n  --min-height: 60px;\n  font-weight: 500;\n\n  ion-icon {\n    font-size: 24px;\n    margin-right: 12px;\n  }\n\n  ion-label {\n    margin: 8px 0;\n  }\n\n  .accordion-title {\n    font-size: 16px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    margin: 0 0 4px 0;\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    flex-wrap: wrap;\n\n    .item-name-text {\n      font-size: 16px;\n      font-weight: 600;\n      color: var(--ion-color-dark);\n    }\n\n    .item-amount-badge {\n      font-size: 16px;\n      font-weight: 700;\n      color: var(--ion-color-primary);\n      background: rgba(var(--ion-color-primary-rgb), 0.1);\n      padding: 4px 12px;\n      border-radius: 12px;\n      border: 1px solid rgba(var(--ion-color-primary-rgb), 0.3);\n    }\n\n    .warning-icon-inline {\n      font-size: 18px;\n      margin: 0 !important;\n      animation: pulse 2s ease-in-out infinite;\n    }\n  }\n\n  @keyframes pulse {\n    0%, 100% {\n      opacity: 1;\n    }\n    50% {\n      opacity: 0.5;\n    }\n  }\n\n  .accordion-subtitle {\n    font-size: 13px;\n    color: var(--ion-color-medium);\n    display: flex;\n    flex-wrap: wrap;\n    gap: 6px;\n    align-items: center;\n    margin: 0;\n\n    .total-available {\n      font-weight: 600;\n      color: var(--ion-color-primary);\n    }\n\n    .separator {\n      color: var(--ion-color-light-shade);\n    }\n\n    .lot-count {\n      color: var(--ion-color-medium);\n    }\n\n    .status-out {\n      color: var(--ion-color-danger);\n      font-weight: 600;\n    }\n\n    .status-low {\n      color: var(--ion-color-warning);\n      font-weight: 600;\n    }\n\n    .status-in {\n      color: var(--ion-color-success);\n      font-weight: 600;\n    }\n  }\n\n  ion-badge {\n    font-size: 11px;\n    padding: 4px 10px;\n    font-weight: 600;\n  }\n}\n\n.accordion-content {\n  padding: 16px;\n  background: rgba(0, 0, 0, 0.01);\n}\n\n// Table Container (matching child-detail)\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n.empty-state {\n  text-align: center;\n  padding: 3rem 2rem;\n  \n  ion-icon {\n    font-size: 4rem;\n    margin-bottom: 1rem;\n  }\n  \n  h3 {\n    color: var(--ion-color-dark);\n    margin-bottom: 0.5rem;\n    font-size: 1.25rem;\n  }\n  \n  p {\n    color: var(--ion-color-medium);\n    margin: 0;\n    font-size: 0.9rem;\n  }\n}\n\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 3rem 2rem;\n  text-align: center;\n  \n  ion-spinner {\n    margin-bottom: 1rem;\n  }\n  \n  p {\n    color: var(--ion-color-medium);\n    margin: 0;\n  }\n}\n\n// Empty State (matching child-detail)\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 300px;\n  }\n}\n\n// Lots Section\n.lots-section {\n  margin-top: 0;\n}\n\n.lots-title {\n  display: flex;\n  align-items: center;\n  gap: 0.5rem;\n  font-size: 16px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  margin: 0 0 1rem 0;\n\n  ion-icon {\n    font-size: 20px;\n  }\n}\n\n// Measurements Table Styles (matching child-detail)\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 100%; // Changed from 600px to fit viewport\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 6px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: normal; // Changed from nowrap to allow text wrapping\n    word-wrap: break-word;\n  }\n\n  td {\n    padding: 10px 6px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n\n    &.lot-number {\n      font-weight: 600;\n      color: var(--ion-color-primary);\n      text-align: left;\n    }\n\n    &.expire-date {\n      .warning-text {\n        color: var(--ion-color-warning);\n        font-weight: 600;\n      }\n    }\n\n    &.available-amount {\n      .amount-value {\n        font-weight: 600;\n        color: var(--ion-color-success);\n\n        &.low-stock-text {\n          color: var(--ion-color-danger);\n          font-weight: 700;\n        }\n      }\n    }\n\n    &.actions-cell {\n      white-space: nowrap;\n      width: 80px;\n      padding: 10px 2px;\n\n      ion-button {\n        margin: 0 1px;\n        --padding-start: 4px;\n        --padding-end: 4px;\n      }\n    }\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n\n    &.expired-lot {\n      background-color: rgba(var(--ion-color-warning-rgb), 0.05);\n      border-left: 3px solid var(--ion-color-warning);\n    }\n\n    &.low-stock-row {\n      background-color: rgba(var(--ion-color-danger-rgb), 0.05);\n      border-left: 3px solid var(--ion-color-danger);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n.no-lots {\n  text-align: center;\n  padding: 2rem;\n  color: var(--ion-color-medium);\n  \n  ion-icon {\n    font-size: 2rem;\n    margin-bottom: 0.5rem;\n  }\n  \n  p {\n    margin: 0;\n    font-size: 0.9rem;\n  }\n}\n\n// Mobile and Tablet Responsive Design (matching child-detail)\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .compact-summary {\n    padding: 10px 6px;\n\n    ion-col {\n      padding: 0 4px;\n    }\n  }\n\n  .compact-summary-item {\n    padding: 6px 3px;\n    min-height: 55px;\n\n    &.warning-item {\n      ion-icon {\n        font-size: 14px;\n      }\n    }\n  }\n\n  .compact-label {\n    font-size: 9px;\n  }\n\n  .compact-value {\n    font-size: 13px;\n  }\n\n  .compact-badge {\n    font-size: 10px !important;\n    padding: 2px 6px !important;\n  }\n\n  .warning-actions {\n    flex-wrap: wrap;\n    gap: 6px;\n\n    ion-button {\n      font-size: 12px;\n      height: 32px;\n    }\n  }\n\n  .accordion-header {\n    --min-height: 56px;\n\n    ion-icon {\n      font-size: 20px;\n    }\n\n    .accordion-title {\n      font-size: 15px;\n\n      .item-name-text {\n        font-size: 15px;\n      }\n\n      .item-amount-badge {\n        font-size: 15px;\n        padding: 3px 10px;\n      }\n\n      .warning-icon-inline {\n        font-size: 16px;\n      }\n    }\n\n    .accordion-subtitle {\n      font-size: 12px;\n    }\n\n    ion-badge {\n      font-size: 10px;\n      padding: 3px 8px;\n    }\n  }\n\n  .accordion-content {\n    padding: 12px;\n  }\n\n  .lots-title {\n    font-size: 14px;\n    margin-bottom: 0.75rem;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.75rem;\n    min-width: 100%; // Changed from 500px to fit viewport\n\n    th, td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .compact-summary {\n    padding: 8px 4px;\n\n    ion-col {\n      padding: 0 3px;\n    }\n  }\n\n  .compact-summary-item {\n    padding: 5px 2px;\n    min-height: 50px;\n\n    &.warning-item {\n      ion-icon {\n        font-size: 12px;\n      }\n    }\n  }\n\n  .compact-label {\n    font-size: 8px;\n    margin-bottom: 3px;\n  }\n\n  .compact-value {\n    font-size: 12px;\n  }\n\n  .compact-badge {\n    font-size: 9px !important;\n    padding: 2px 5px !important;\n  }\n\n  .warning-actions {\n    flex-direction: column;\n    gap: 6px;\n\n    ion-button {\n      font-size: 11px;\n      height: 30px;\n      width: 100%;\n    }\n  }\n\n  .accordion-header {\n    --padding-start: 10px;\n    --padding-end: 10px;\n    --min-height: 52px;\n\n    ion-icon {\n      font-size: 18px;\n      margin-right: 8px;\n    }\n\n    .accordion-title {\n      font-size: 14px;\n\n      .item-name-text {\n        font-size: 14px;\n      }\n\n      .item-amount-badge {\n        font-size: 14px;\n        padding: 2px 8px;\n      }\n\n      .warning-icon-inline {\n        font-size: 14px;\n      }\n    }\n\n    .accordion-subtitle {\n      font-size: 11px;\n      gap: 4px;\n    }\n\n    ion-badge {\n      font-size: 9px;\n      padding: 2px 6px;\n    }\n  }\n\n  .accordion-content {\n    padding: 10px;\n  }\n\n  .lots-title {\n    font-size: 13px;\n    margin-bottom: 0.5rem;\n\n    ion-icon {\n      font-size: 16px;\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.7rem;\n    min-width: 100%; // Changed from 450px to fit viewport\n\n    th, td {\n      padding: 6px 3px;\n      font-size: 0.7rem;\n    }\n  }\n}\n\n// Transaction Modal Styles (matching child-detail)\nion-modal {\n  ion-content {\n    --padding-start: 16px;\n    --padding-end: 16px;\n    --padding-top: 20px;\n    --padding-bottom: 20px;\n  }\n}\n\n.modal-info-card {\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n  overflow: hidden;\n  margin: 0;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n}\n\n.lot-info-grid {\n  display: grid;\n  grid-template-columns: repeat(3, 1fr);\n  gap: 12px;\n\n  .info-item {\n    display: flex;\n    align-items: flex-start;\n    gap: 12px;\n    padding: 12px;\n    background: rgba(255, 255, 255, 0.8);\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.06);\n    transition: all 0.2s ease;\n\n    &:hover {\n      background: rgba(73, 144, 226, 0.04);\n      border-color: rgba(73, 144, 226, 0.2);\n      transform: translateY(-1px);\n      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n    }\n\n    ion-icon {\n      font-size: 20px;\n      flex-shrink: 0;\n      margin-top: 2px;\n    }\n\n    .item-content {\n      display: flex;\n      flex-direction: column;\n      gap: 4px;\n      flex: 1;\n      min-width: 0;\n\n      .label {\n        font-size: 11px;\n        font-weight: 600;\n        color: var(--ion-color-medium);\n        text-transform: uppercase;\n        letter-spacing: 0.5px;\n      }\n\n      .value {\n        font-size: 14px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n        word-wrap: break-word;\n\n        &.warning-text {\n          color: var(--ion-color-warning);\n        }\n      }\n    }\n  }\n}\n\n// Transaction table rows (matching child-detail style)\n.measurements-table {\n  tbody tr {\n    &.transaction-in {\n      background-color: rgba(var(--ion-color-success-rgb), 0.05);\n      border-left: 3px solid var(--ion-color-success);\n\n      &:hover {\n        background-color: rgba(var(--ion-color-success-rgb), 0.1);\n      }\n    }\n\n    &.transaction-out {\n      background-color: rgba(var(--ion-color-secondary-rgb), 0.05);\n      border-left: 3px solid var(--ion-color-secondary);\n\n      &:hover {\n        background-color: rgba(var(--ion-color-secondary-rgb), 0.1);\n      }\n    }\n  }\n\n  .quantity-cell {\n    font-weight: 600;\n    color: var(--ion-color-primary);\n  }\n}\n\n@media (max-width: 768px) {\n  ion-modal {\n    ion-content {\n      --padding-start: 12px;\n      --padding-end: 12px;\n      --padding-top: 16px;\n      --padding-bottom: 16px;\n    }\n  }\n\n  .lot-info-grid {\n    grid-template-columns: repeat(2, 1fr);\n    gap: 10px;\n\n    .info-item {\n      padding: 10px;\n\n      ion-icon {\n        font-size: 18px;\n      }\n\n      .item-content {\n        .label {\n          font-size: 10px;\n        }\n\n        .value {\n          font-size: 13px;\n        }\n      }\n    }\n  }\n}\n\n@media (max-width: 480px) {\n  ion-modal {\n    ion-content {\n      --padding-start: 8px;\n      --padding-end: 8px;\n      --padding-top: 12px;\n      --padding-bottom: 12px;\n    }\n  }\n\n  .lot-info-grid {\n    gap: 8px;\n\n    .info-item {\n      padding: 8px;\n      gap: 10px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n\n      .item-content {\n        .label {\n          font-size: 9px;\n        }\n\n        .value {\n          font-size: 12px;\n        }\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 72844:
/*!****************************************************************************************!*\
  !*** ./src/app/pages/supply-avaiable-items/supply-avaiable-items.page.html?ngResource ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Store</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"!loading; else loadingTemplate\" class=\"inventory-container\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"icons.CUBE\" color=\"primary\"></ion-icon>\n        Current Status\n      </h2>\n    </div>\n\n    <!-- Summary Cards -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <ion-grid class=\"compact-summary\">\n            <ion-row>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"compact-summary-item\">\n                  <span class=\"compact-label\">Total Items</span>\n                  <span class=\"compact-value\">{{ supply_items?.length || 0 }}</span>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"compact-summary-item\">\n                  <span class=\"compact-label\">In Stock</span>\n                  <span class=\"compact-value\">{{ getInStockCount() }}</span>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"compact-summary-item\">\n                  <span class=\"compact-label\">Low Stock</span>\n                  <ion-badge color=\"danger\" class=\"compact-badge\">{{ getLowStockCount() }}</ion-badge>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"compact-summary-item\">\n                  <span class=\"compact-label\">Expiring Soon</span>\n                  <ion-badge color=\"warning\" class=\"compact-badge\">{{ getExpiringSoonCount() }}</ion-badge>\n                </div>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Warnings Section -->\n    <div class=\"card-container\" *ngIf=\"getLowStockCount() > 0 || getExpiringSoonCount() > 0\">\n      <!-- Low Stock Warning -->\n      <ion-card class=\"low-stock-warning-card\" *ngIf=\"getLowStockCount() > 0\">\n        <ion-card-content>\n          <div class=\"warning-content\">\n            <div class=\"warning-header\">\n              <ion-icon [name]=\"icons.WARNING\" color=\"danger\"></ion-icon>\n              <h3>Low Stock Alert</h3>\n            </div>\n            <p>{{ getLowStockCount() }} lot(s) have stock levels below 20% of supplied amount</p>\n            <div class=\"warning-actions\">\n              <ion-button\n                *ngFor=\"let lowStockItem of getLowStockItems(); let i = index\"\n                fill=\"outline\"\n                size=\"small\"\n                color=\"danger\"\n                (click)=\"scrollToLowStockItem(supply_items.indexOf(lowStockItem.item))\">\n                {{ lowStockItem.item.title }} - Lot {{ lowStockItem.lot.lot_no }}\n              </ion-button>\n            </div>\n          </div>\n        </ion-card-content>\n      </ion-card>\n\n      <!-- Expiring Soon Warning -->\n      <ion-card class=\"expiring-warning-card\" *ngIf=\"getExpiringSoonCount() > 0\">\n        <ion-card-content>\n          <div class=\"warning-content\">\n            <div class=\"warning-header\">\n              <ion-icon [name]=\"icons.TIME\" color=\"warning\"></ion-icon>\n              <h3>Expiring Soon Alert</h3>\n            </div>\n            <p>{{ getExpiringSoonCount() }} lot(s) will expire within 60 days</p>\n            <div class=\"warning-actions\">\n              <ion-button\n                *ngFor=\"let expiringItem of getExpiringSoonItems(); let i = index\"\n                fill=\"outline\"\n                size=\"small\"\n                color=\"warning\"\n                (click)=\"scrollToLowStockItem(supply_items.indexOf(expiringItem.item))\">\n                {{ expiringItem.item.title }} - Lot {{ expiringItem.lot.lot_no }} ({{ formatDateDDMMYYYY(expiringItem.lot.expire_date) }})\n              </ion-button>\n            </div>\n          </div>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Inventory Items Accordion -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n            Inventory Items\n          </h2>\n        </div>\n\n        <ion-card-content>\n          <ion-accordion-group *ngIf=\"supply_items && supply_items.length > 0; else emptyState\">\n            <ion-accordion\n              *ngFor=\"let item of supply_items; let i = index\"\n              [value]=\"'item-' + i\"\n              [id]=\"'supply-item-' + i\"\n              class=\"supply-accordion\">\n\n              <!-- Accordion Header -->\n              <ion-item slot=\"header\" [color]=\"getAccordionHeaderColor(item)\" lines=\"none\" class=\"accordion-header\">\n                <ion-icon [name]=\"getStockIcon(item.total_available)\" [color]=\"getStockColor(item.total_available)\" slot=\"start\"></ion-icon>\n                <ion-label>\n                  <h2 class=\"accordion-title\">\n                    <span class=\"item-name-text\">{{ item.title }}</span>\n                    <span class=\"item-amount-badge\">{{ item.total_available }} {{ item.unit.title }}</span>\n                    <ion-icon *ngIf=\"hasLowStockLots(item)\" [name]=\"icons.WARNING\" color=\"danger\" class=\"warning-icon-inline\"></ion-icon>\n                    <ion-icon *ngIf=\"hasExpiringLots(item)\" [name]=\"icons.TIME\" color=\"warning\" class=\"warning-icon-inline\"></ion-icon>\n                  </h2>\n                  <p class=\"accordion-subtitle\">\n                    <span class=\"lot-count\">{{ item.lots?.length || 0 }} lot(s)</span>\n                    <span class=\"separator\">•</span>\n                    <span [ngClass]=\"getStatusClass(item.total_available)\">{{ getItemStatusText(item) }}</span>\n                  </p>\n                </ion-label>\n                <ion-badge [color]=\"getStatusBadgeColor(item.status)\" slot=\"end\">\n                  {{ item.status }}\n                </ion-badge>\n              </ion-item>\n\n              <!-- Accordion Content -->\n              <div slot=\"content\" class=\"accordion-content\">\n                <!-- Lot Details -->\n                <div *ngIf=\"item.lots?.length > 0; else noLots\" class=\"lots-section\">\n                  <h4 class=\"lots-title\">\n                    <ion-icon [name]=\"icons.LAYERS\" color=\"tertiary\"></ion-icon>\n                    Lot Details ({{ item.lots.length }})\n                  </h4>\n\n                  <div class=\"table-container\">\n                    <table class=\"measurements-table\">\n                      <thead>\n                        <tr>\n                          <th>Lot No.</th>\n                          <th>Expire Date</th>\n                          <th>Available</th>\n                          <th>Supplied</th>\n                          <th>Out to DP</th>\n                          <th>Out of INF</th>\n                          <th>Actions</th>\n                        </tr>\n                      </thead>\n                      <tbody>\n                        <tr *ngFor=\"let lot of item.lots\" [ngClass]=\"{'expired-lot': isExpiringSoon(lot.expire_date), 'low-stock-row': isLowStock(lot.available_in_store, lot.supplied_amount)}\">\n                          <td class=\"lot-number\">{{ lot.lot_no }}</td>\n                          <td class=\"expire-date\">\n                            <span [ngClass]=\"{'warning-text': isExpiringSoon(lot.expire_date)}\">\n                              {{ formatDateDDMMYYYY(lot.expire_date) }}\n                            </span>\n                          </td>\n                          <td class=\"available-amount\">\n                            <span class=\"amount-value\" [ngClass]=\"{'low-stock-text': isLowStock(lot.available_in_store, lot.supplied_amount)}\">\n                              {{ lot.available_in_store }}\n                            </span>\n                          </td>\n                          <td class=\"supplied-amount\">{{ lot.supplied_amount }}</td>\n                          <td class=\"provisioned-amount\">{{ lot.provisioned_amount_in_dp }}</td>\n                          <td class=\"other-out-amount\">{{ lot.other_out_amount }}</td>\n                          <td class=\"actions-cell\">\n                            <ion-button\n                              fill=\"clear\"\n                              size=\"small\"\n                              (click)=\"openLotTransactionModal(item, lot)\"\n                              color=\"primary\"\n                              title=\"View lot transaction details\">\n                              <ion-icon [name]=\"icons.EYE\" slot=\"icon-only\"></ion-icon>\n                            </ion-button>\n                          </td>\n                        </tr>\n                      </tbody>\n                    </table>\n                  </div>\n                </div>\n\n                <ng-template #noLots>\n                  <div class=\"no-lots\">\n                    <ion-icon [name]=\"icons.INFORMATION_CIRCLE\" color=\"medium\"></ion-icon>\n                    <p>No lot information available</p>\n                  </div>\n                </ng-template>\n              </div>\n            </ion-accordion>\n          </ion-accordion-group>\n\n          <!-- Empty State -->\n          <ng-template #emptyState>\n            <div class=\"empty-state\">\n              <ion-icon [name]=\"icons.CUBE\" color=\"medium\"></ion-icon>\n              <h3>No Items in Inventory</h3>\n              <p>No supply items are currently available in the inventory.</p>\n            </div>\n          </ng-template>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <!-- Loading Template -->\n  <ng-template #loadingTemplate>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\"></ion-spinner>\n      <p>Loading inventory data...</p>\n    </div>\n  </ng-template>\n\n  <!-- Lot Transaction Modal -->\n  <ion-modal [isOpen]=\"showTransactionModal\" (willDismiss)=\"closeTransactionModal()\">\n    <ng-template>\n      <ion-header>\n        <ion-toolbar>\n          <ion-title>Lot Transaction History</ion-title>\n          <ion-buttons slot=\"end\">\n            <ion-button (click)=\"closeTransactionModal()\">\n              <ion-icon [name]=\"icons.CLOSE\"></ion-icon>\n            </ion-button>\n          </ion-buttons>\n        </ion-toolbar>\n      </ion-header>\n\n      <ion-content class=\"ion-padding\">\n        <!-- Modal Header Info -->\n        <div class=\"card-container\">\n          <ion-card class=\"modal-info-card\">\n            <ion-card-content>\n              <div *ngIf=\"selectedLotInfo\" class=\"lot-info-grid\">\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.CUBE\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Item & Unit</span>\n                    <span class=\"value\">{{ selectedLotInfo.itemTitle }} ({{ selectedLotInfo.unit }})</span>\n                  </div>\n                </div>\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.LAYERS\" color=\"tertiary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Lot Number</span>\n                    <span class=\"value\">{{ selectedLotInfo.lotNo }}</span>\n                  </div>\n                </div>\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.CALENDAR\" [color]=\"isExpiringSoon(selectedLotInfo.expireDate) ? 'warning' : 'success'\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Expire Date</span>\n                    <span class=\"value\" [ngClass]=\"{'warning-text': isExpiringSoon(selectedLotInfo.expireDate)}\">\n                      {{ formatDateDDMMYYYY(selectedLotInfo.expireDate) }}\n                    </span>\n                  </div>\n                </div>\n              </div>\n            </ion-card-content>\n          </ion-card>\n        </div>\n\n        <!-- Transactions Section -->\n        <div class=\"card-container\">\n          <ion-card>\n            <div class=\"section-header\">\n              <h2 class=\"section-title\">\n                <ion-icon [name]=\"icons.SWAP_HORIZONTAL\" color=\"primary\"></ion-icon>\n                Transaction History\n              </h2>\n            </div>\n\n            <ion-card-content>\n              <div *ngIf=\"!loadingTransactions; else loadingTransactionsTemplate\">\n                <div *ngIf=\"selectedLotTransactions?.length > 0; else noTransactions\">\n                  <div class=\"table-container\">\n                    <table class=\"measurements-table\">\n                      <thead>\n                        <tr>\n                          <th>Date</th>\n                          <th>Transfer Type</th>\n                          <th>Type</th>\n                          <th>Status</th>\n                          <th>Source</th>\n                          <th>Destination</th>\n                          <th>Quantity</th>\n                          <th>Created</th>\n                        </tr>\n                      </thead>\n                      <tbody>\n                        <tr *ngFor=\"let transaction of selectedLotTransactions\"\n                            [ngClass]=\"{'transaction-in': getTransactionTypeClass(transaction.supply_transaction?.transaction_type) === 'in', 'transaction-out': getTransactionTypeClass(transaction.supply_transaction?.transaction_type) === 'out'}\">\n                          <td class=\"date-cell\">{{ formatDateDDMMYYYY(transaction.supply_transaction?.transaction_date) }}</td>\n                          <td>{{ transaction.supply_transaction?.transfer_type || '-' }}</td>\n                          <td>\n                            <ion-badge [color]=\"getTransactionTypeColor(transaction.supply_transaction?.transaction_type)\">\n                              {{ transaction.supply_transaction?.transaction_type }}\n                            </ion-badge>\n                          </td>\n                          <td>\n                            <ion-badge [color]=\"getStatusColor(transaction.supply_transaction?.status)\">\n                              {{ transaction.supply_transaction?.status }}\n                            </ion-badge>\n                          </td>\n                          <td>{{ transaction.supply_transaction?.source_title || '-' }}</td>\n                          <td>{{ transaction.supply_transaction?.destination_title || '-' }}</td>\n                          <td class=\"quantity-cell\">{{ transaction.total_quantity }}</td>\n                          <td>{{ formatDateTimeWithHours(transaction.created_at) }}</td>\n                        </tr>\n                      </tbody>\n                    </table>\n                  </div>\n                </div>\n\n                <ng-template #noTransactions>\n                  <div class=\"empty-state\">\n                    <ion-icon [name]=\"icons.DOCUMENT\" color=\"medium\"></ion-icon>\n                    <h3>No Transactions Found</h3>\n                    <p>No transaction history available for this lot.</p>\n                  </div>\n                </ng-template>\n              </div>\n\n              <ng-template #loadingTransactionsTemplate>\n                <div class=\"loading-container\">\n                  <ion-spinner name=\"crescent\"></ion-spinner>\n                  <p>Loading transaction history...</p>\n                </div>\n              </ng-template>\n            </ion-card-content>\n          </ion-card>\n        </div>\n      </ion-content>\n    </ng-template>\n  </ion-modal>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_supply-avaiable-items_supply-avaiable-items_module_ts.js.map