(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_offline-assessment_offline-assessment_module_ts"],{

/***/ 74701:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/offline-assessment/offline-assessment-routing.module.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineAssessmentPageRoutingModule: () => (/* binding */ OfflineAssessmentPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _offline_assessment_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offline-assessment.page */ 91999);




const routes = [{
  path: '',
  component: _offline_assessment_page__WEBPACK_IMPORTED_MODULE_0__.OfflineAssessmentPage
}];
let OfflineAssessmentPageRoutingModule = class OfflineAssessmentPageRoutingModule {};
OfflineAssessmentPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], OfflineAssessmentPageRoutingModule);


/***/ }),

/***/ 83988:
/*!***********************************************************************!*\
  !*** ./src/app/pages/offline-assessment/offline-assessment.module.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineAssessmentPageModule: () => (/* binding */ OfflineAssessmentPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _offline_assessment_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offline-assessment-routing.module */ 74701);
/* harmony import */ var _offline_assessment_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offline-assessment.page */ 91999);







let OfflineAssessmentPageModule = class OfflineAssessmentPageModule {};
OfflineAssessmentPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _offline_assessment_routing_module__WEBPACK_IMPORTED_MODULE_0__.OfflineAssessmentPageRoutingModule],
  declarations: [_offline_assessment_page__WEBPACK_IMPORTED_MODULE_1__.OfflineAssessmentPage]
})], OfflineAssessmentPageModule);


/***/ }),

/***/ 91999:
/*!*********************************************************************!*\
  !*** ./src/app/pages/offline-assessment/offline-assessment.page.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineAssessmentPage: () => (/* binding */ OfflineAssessmentPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _offline_assessment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offline-assessment.page.html?ngResource */ 10913);
/* harmony import */ var _offline_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./offline-assessment.page.scss?ngResource */ 64825);
/* harmony import */ var _offline_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_offline_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/survey_form_api.service */ 55856);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var src_app_state_selectors_user_selector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/state/selectors/user.selector */ 77451);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _OfflineAssessmentPage;












let OfflineAssessmentPage = (_OfflineAssessmentPage = class OfflineAssessmentPage {
  constructor(router, alertController, loadingController, surveyApi, b, store) {
    this.router = router;
    this.alertController = alertController;
    this.loadingController = loadingController;
    this.surveyApi = surveyApi;
    this.b = b;
    this.store = store;
    this.assessments = [];
    this.blocks = [];
    this.subBlocks = [];
    this.allSubBlocks = []; // Store all sub-blocks for filtering
    this.selectedAssessment = null;
    this.selectedBlock = null;
    this.selectedSubBlocks = [];
    this.beneficiaries = [];
    this.filteredBeneficiaries = [];
    this.searchTerm = '';
    this.isLoading = false;
    this.allSelected = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_7__.ICONS;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.loadAssessments();
      yield _this.loadLocationData();
    })();
  }
  loadAssessments() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this2.surveyApi.getAssessmentForms('offline', 'all');
        if (response.success) {
          _this2.assessments = response.data;
        }
      } catch (error) {
        _this2.b.errorToast('Failed to load assessments');
      }
    })();
  }
  loadLocationData() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this3.surveyApi.getLocationData();
        if (response.success) {
          _this3.blocks = response.data.blocks || [];
          // Store all sub-blocks but don't assign to this.subBlocks yet
          _this3.allSubBlocks = response.data.sub_blocks || [];
          _this3.subBlocks = []; // Will be populated when block is selected
        }
      } catch (error) {
        _this3.b.errorToast('Failed to load location data');
      }
    })();
  }
  onBlockChange() {
    this.selectedSubBlocks = [];
    this.beneficiaries = [];
    this.filteredBeneficiaries = [];
    this.searchTerm = '';
    if (this.selectedBlock) {
      this.subBlocks = this.allSubBlocks.filter(sb => sb.block_id === this.selectedBlock.block_id);
    } else {
      this.subBlocks = [];
    }
  }
  onSubBlockChange() {
    this.beneficiaries = [];
    this.filteredBeneficiaries = [];
    this.searchTerm = '';
  }
  loadBeneficiaries() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this4.selectedAssessment || !_this4.selectedBlock) {
        _this4.b.errorToast('Please select assessment and block');
        return;
      }
      const loading = yield _this4.loadingController.create({
        message: 'Loading eligible beneficiaries...'
      });
      yield loading.present();
      try {
        // Convert selected sub-blocks to IDs array, or null if none selected
        const subBlockIds = _this4.selectedSubBlocks.length > 0 ? _this4.selectedSubBlocks.map(sb => sb.id) : null;
        const response = yield _this4.surveyApi.getBeneficiariesByLocation(_this4.selectedBlock.id, subBlockIds, _this4.selectedAssessment.id);
        if (response.success) {
          // Handle the new response structure with eligible beneficiaries
          const beneficiariesData = response.data.beneficiaries || [];
          _this4.beneficiaries = beneficiariesData.map(beneficiary => {
            const identificationData = beneficiary.identification_data || {};
            const prefillData = beneficiary.prefill_data || {};
            return {
              ...beneficiary,
              selected: false,
              // Common identification fields
              displayName: identificationData.name || prefillData.beneficiary_name || 'Unknown',
              fcn: identificationData.fcn || prefillData.fcn || '',
              householdNo: identificationData.household_no || prefillData.household_no || prefillData.hh_no || '',
              subBlockTitle: identificationData.sub_block_title || '',
              // Child-specific fields (only for child beneficiaries)
              ...(beneficiary.type === 'child' && {
                age: identificationData.age_in_months || prefillData.age_in_month || 0,
                fatherName: identificationData.father_name || '',
                motherName: identificationData.mother_name || '',
                gender: identificationData.gender || '',
                disability: identificationData.disability || 'No'
              }),
              // PLW-specific fields (only for PLW beneficiaries)
              ...(beneficiary.type === 'plw' && {
                husbandName: identificationData.husband || prefillData.husband_name || '',
                isPregnant: identificationData.is_pregnant || false,
                isLactating: identificationData.is_lactating || false,
                subBlock: identificationData.sub_block_title || ''
              }),
              // Determine beneficiary type
              beneficiaryType: beneficiary.type || 'child'
            };
          });
          // Initialize filtered list and reset search
          _this4.searchTerm = '';
          _this4.filteredBeneficiaries = [..._this4.beneficiaries];
          _this4.allSelected = false;
          // Show count of eligible beneficiaries
          if (beneficiariesData.length === 0) {
            _this4.b.toast('No eligible beneficiaries found for this assessment in the selected location');
          } else {
            _this4.b.toast(`Found ${beneficiariesData.length} eligible beneficiaries`);
          }
        } else {
          _this4.b.errorToast('Failed to load beneficiaries');
        }
      } catch (error) {
        _this4.b.errorToast('Failed to load beneficiaries');
      } finally {
        yield loading.dismiss();
      }
    })();
  }
  saveForOffline() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const selectedBeneficiaries = _this5.beneficiaries.filter(b => b.selected);
      if (!_this5.selectedAssessment || selectedBeneficiaries.length === 0) {
        _this5.b.errorToast('Please select at least one beneficiary');
        return;
      }
      const loading = yield _this5.loadingController.create({
        message: 'Preparing offline data...'
      });
      yield loading.present();
      try {
        // Validate that the selected assessment has a schema
        if (!_this5.selectedAssessment.schema || !Array.isArray(_this5.selectedAssessment.schema)) {
          throw new Error('Selected assessment is missing form schema');
        }
        // Get survey form data from the latest API response
        // We need to reload the current API response to get the complete survey form data
        const subBlockIds = _this5.selectedSubBlocks.length > 0 ? _this5.selectedSubBlocks.map(sb => sb.id) : null;
        const response = yield _this5.surveyApi.getBeneficiariesByLocation(_this5.selectedBlock.id, subBlockIds, _this5.selectedAssessment.id);
        let surveyFormData = _this5.selectedAssessment;
        if (response.success && response.data.survey_form) {
          // Use the survey form data from API response which has the complete schema
          surveyFormData = response.data.survey_form;
        }
        // Prepare offline data with proper structure for eligible beneficiaries
        const offlineData = {
          assessment: surveyFormData,
          formSchema: {
            id: surveyFormData.id,
            title: surveyFormData.title,
            type: surveyFormData.type,
            description: surveyFormData.description,
            schema: surveyFormData.schema // This is the complete Formly schema array
          },
          beneficiaries: selectedBeneficiaries.map(beneficiary => ({
            ...beneficiary,
            // Ensure both identification_data and prefill_data are preserved
            identification_data: beneficiary.identification_data || {},
            prefill_data: beneficiary.prefill_data || {}
          })),
          block: _this5.selectedBlock,
          subBlocks: _this5.selectedSubBlocks.length > 0 ? _this5.selectedSubBlocks : null,
          savedAt: new Date().toISOString(),
          totalEligible: _this5.beneficiaries.length
        };
        // Save to local storage
        const offlineKey = `offline_assessment_${surveyFormData.id}_${Date.now()}`;
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
          key: offlineKey,
          value: JSON.stringify(offlineData)
        });
        // Keep track of saved offline assessments
        const savedAssessments = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
          key: 'saved_offline_assessments'
        });
        let assessmentsList = [];
        if (savedAssessments.value) {
          assessmentsList = JSON.parse(savedAssessments.value);
        }
        assessmentsList.push({
          key: offlineKey,
          title: surveyFormData.title,
          beneficiariesCount: selectedBeneficiaries.length,
          totalEligible: _this5.beneficiaries.length,
          savedAt: new Date().toISOString(),
          block: _this5.selectedBlock.title,
          subBlocks: _this5.selectedSubBlocks.length > 0 ? _this5.selectedSubBlocks.map(sb => sb.title).join(', ') : 'All Sub-blocks'
        });
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
          key: 'saved_offline_assessments',
          value: JSON.stringify(assessmentsList)
        });
        // Store INF ID for the current user (for INF compatibility checking)
        const user = yield _this5.getCurrentUser();
        if (user) {
          yield _this5.b.storeOfflineAssessmentInfId(user);
        }
        // Notify that offline assessments have changed
        _this5.b.notifyOfflineAssessmentChange();
        yield loading.dismiss();
        const alert = yield _this5.alertController.create({
          header: 'Success',
          message: `Assessment data saved for community assessment - ${selectedBeneficiaries.length} eligible beneficiaries out of ${_this5.beneficiaries.length} total eligible`,
          buttons: [{
            text: 'View Community Assessments',
            handler: () => {
              _this5.clearPageData();
              _this5.router.navigate(['/offline-survey-list']);
            }
          }]
        });
        yield alert.present();
      } catch (error) {
        yield loading.dismiss();
        _this5.b.errorToast('Failed to save offline data: ' + error.message);
      }
    })();
  }
  viewOfflineAssessments() {
    this.router.navigate(['/offline-survey-list']);
  }
  // Checkbox functionality methods
  toggleAllBeneficiaries(event) {
    const checked = event.detail.checked;
    this.filteredBeneficiaries.forEach(beneficiary => {
      beneficiary.selected = checked;
    });
    this.updateAllSelectedState();
  }
  onBeneficiarySelectionChange() {
    this.updateAllSelectedState();
  }
  updateAllSelectedState() {
    const visibleSelectedCount = this.getVisibleSelectedCount();
    const visibleTotalCount = this.filteredBeneficiaries.length;
    this.allSelected = visibleSelectedCount === visibleTotalCount && visibleTotalCount > 0;
  }
  getSelectedCount() {
    return this.beneficiaries.filter(b => b.selected).length;
  }
  getVisibleSelectedCount() {
    return this.filteredBeneficiaries.filter(b => b.selected).length;
  }
  isIndeterminate() {
    const visibleSelectedCount = this.getVisibleSelectedCount();
    const visibleTotalCount = this.filteredBeneficiaries.length;
    return visibleSelectedCount > 0 && visibleSelectedCount < visibleTotalCount;
  }
  // Helper methods for beneficiary type handling
  hasChildBeneficiaries() {
    return this.beneficiaries.some(b => b.beneficiaryType === 'child');
  }
  hasPlwBeneficiaries() {
    return this.beneficiaries.some(b => b.beneficiaryType === 'plw');
  }
  hasMixedBeneficiaryTypes() {
    return this.hasChildBeneficiaries() && this.hasPlwBeneficiaries();
  }
  formatDate(dateString) {
    if (!dateString) return 'N/A';
    try {
      const date = new Date(dateString);
      return date.toLocaleDateString('en-GB'); // DD/MM/YYYY format
    } catch {
      return dateString; // Return original if parsing fails
    }
  }
  formatDisability(disability) {
    if (!disability) return 'No';
    if (typeof disability === 'boolean') return disability ? 'Yes' : 'No';
    if (typeof disability === 'string') {
      const lower = disability.toLowerCase();
      if (lower === 'yes' || lower === 'true' || lower === '1') return 'Yes';
      if (lower === 'no' || lower === 'false' || lower === '0') return 'No';
      return disability;
    }
    return 'No';
  }
  formatPregnancyLactatingStatus(beneficiary) {
    const statuses = [];
    if (beneficiary.isPregnant) {
      statuses.push('P');
    }
    if (beneficiary.isLactating) {
      statuses.push('L');
    }
    return statuses.length > 0 ? statuses.join(', ') : 'N/A';
  }
  // Search functionality
  onSearchChange(event) {
    const searchTerm = event.detail.value.toLowerCase();
    this.searchTerm = searchTerm;
    this.filterBeneficiaries();
  }
  filterBeneficiaries() {
    if (!this.searchTerm) {
      this.filteredBeneficiaries = [...this.beneficiaries];
    } else {
      this.filteredBeneficiaries = this.beneficiaries.filter(beneficiary => {
        const searchableFields = [beneficiary.fcn, beneficiary.displayName, beneficiary.fatherName, beneficiary.motherName, beneficiary.husbandName, beneficiary.householdNo, beneficiary.subBlockTitle, beneficiary.subBlock];
        return searchableFields.some(field => field && field.toString().toLowerCase().includes(this.searchTerm));
      });
    }
    this.updateAllSelectedState();
  }
  clearSearch() {
    this.searchTerm = '';
    this.filteredBeneficiaries = [...this.beneficiaries];
    this.updateAllSelectedState();
  }
  getFilteredChildBeneficiaries() {
    return this.filteredBeneficiaries.filter(b => b.beneficiaryType === 'child');
  }
  getFilteredPlwBeneficiaries() {
    return this.filteredBeneficiaries.filter(b => b.beneficiaryType === 'plw');
  }
  /**
   * Get current user from store
   */
  getCurrentUser() {
    var _this6 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return new Promise(resolve => {
        _this6.store.select(src_app_state_selectors_user_selector__WEBPACK_IMPORTED_MODULE_6__.retrieveUserSelector).subscribe(data => {
          resolve((data === null || data === void 0 ? void 0 : data.user) || null);
        }).unsubscribe();
      });
    })();
  }
  /**
   * Clear all page data and reset form
   */
  clearPageData() {
    this.selectedAssessment = null;
    this.selectedBlock = null;
    this.selectedSubBlocks = [];
    this.beneficiaries = [];
    this.filteredBeneficiaries = [];
    this.searchTerm = '';
    this.allSelected = false;
    this.subBlocks = [];
  }
}, _OfflineAssessmentPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.Router
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.AlertController
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.LoadingController
}, {
  type: src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_3__.SurveyFormAPIService
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_10__.Store
}], _OfflineAssessmentPage);
OfflineAssessmentPage = (0,tslib__WEBPACK_IMPORTED_MODULE_11__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_12__.Component)({
  selector: 'app-offline-assessment',
  template: _offline_assessment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_offline_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], OfflineAssessmentPage);


/***/ }),

/***/ 55856:
/*!*****************************************************!*\
  !*** ./src/app/services/survey_form_api.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveyFormAPIService: () => (/* binding */ SurveyFormAPIService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 61318);

/* eslint-disable @typescript-eslint/naming-convention */




let SurveyFormAPIService = class SurveyFormAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_0__.APIBaseService {
  constructor() {
    super(...arguments);
    this.namespace = '/survey-forms/responses';
    this.formsNamespace = '/survey-forms';
  }
  getSurveyResponseData(id, type) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${type}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  displayForms(id, beneficiaryType, beneficiaryId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.formsNamespace}/${id}`;
    // Add query parameters if provided
    const queryParams = [];
    if (beneficiaryType) {
      queryParams.push(`beneficiary_type=${encodeURIComponent(beneficiaryType)}`);
    }
    if (beneficiaryId) {
      queryParams.push(`beneficiary_id=${encodeURIComponent(beneficiaryId)}`);
    }
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  storeSurvey(body) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}`;
    return this.http.post(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  viewForm(id, assessmentMode) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    // Add query parameter for assessment mode if provided
    if (assessmentMode) {
      url += `?assessment_mode=${encodeURIComponent(assessmentMode)}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteForm(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteSurvey(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  // ===== OFFLINE ASSESSMENT APIs =====
  getAssessmentForms(tags, tagMatch = 'all') {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/survey-forms/list`;
    const queryParams = [];
    if (tags) {
      queryParams.push(`tags=${encodeURIComponent(tags)}`);
    }
    queryParams.push(`tag_match=${encodeURIComponent(tagMatch)}`);
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getLocationData() {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/location-data`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getBeneficiariesByLocation(blockCampId, subBlockIds, assessmentId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/beneficiaries?block_id=${blockCampId}&survey_form_id=${assessmentId}`;
    if (subBlockIds !== null && subBlockIds !== undefined) {
      if (Array.isArray(subBlockIds)) {
        const commaSeparatedIds = subBlockIds.join(',');
        url += `&sub_block_ids=${commaSeparatedIds}`;
      }
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
};
SurveyFormAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], SurveyFormAPIService);


/***/ }),

/***/ 64825:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/offline-assessment/offline-assessment.page.scss?ngResource ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
.assessment-container {
  max-width: 1200px;
  margin: 0 auto;
}

.section-header {
  margin-bottom: 1.5rem;
  text-align: center;
}
.section-header .section-title {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 0.5rem;
  margin: 0;
  font-size: 1.5rem;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.section-header .section-subtitle {
  margin: 0.5rem 0 0 0;
  color: var(--ion-color-medium);
  font-size: 1rem;
}

.form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.form-item ion-select {
  width: 100%;
}

.detail-item {
  margin-bottom: 1rem;
}
.detail-item strong {
  display: block;
  color: var(--ion-color-primary);
  font-size: 0.9rem;
  margin-bottom: 0.25rem;
}
.detail-item p {
  margin: 0;
  color: var(--ion-color-dark);
  font-size: 1rem;
  word-wrap: break-word;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-bottom: 2rem;
}
.table-container .table-header {
  background-color: var(--ion-color-primary);
  color: white;
  padding: 12px 16px;
  margin: 0;
  border-top-left-radius: 8px;
  border-top-right-radius: 8px;
}
.table-container .table-header h4 {
  margin: 0;
  font-size: 1.1rem;
  font-weight: 600;
  display: flex;
  align-items: center;
  gap: 8px;
}
.table-container .table-header::before {
  content: "👶";
  font-size: 1rem;
}
.table-container:has(.table-header h4:contains("PLW")) .table-header::before {
  content: "🤱";
}

.beneficiaries-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 650px;
}
.beneficiaries-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 12px 8px;
  text-align: left;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.9rem;
  white-space: nowrap;
}
.beneficiaries-table th.checkbox-column {
  text-align: center;
  width: 60px;
  padding: 12px 4px;
}
.beneficiaries-table th:nth-child(2) {
  text-align: left;
  width: 120px;
}
.beneficiaries-table td {
  padding: 12px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.9rem;
  text-align: left;
  vertical-align: middle;
}
.beneficiaries-table td.checkbox-column {
  text-align: center;
  width: 60px;
  padding: 12px 4px;
}
.beneficiaries-table td:nth-child(2) {
  font-weight: 600;
  color: var(--ion-color-success);
  text-align: left;
  width: 120px;
}
.beneficiaries-table tbody tr {
  transition: all 0.2s ease;
}
.beneficiaries-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.beneficiaries-table tbody tr.selected-row {
  background-color: rgba(var(--ion-color-primary-rgb), 0.05);
  border-left: 3px solid var(--ion-color-primary);
}
.beneficiaries-table tbody tr.selected-row:hover {
  background-color: rgba(var(--ion-color-primary-rgb), 0.08);
}
.beneficiaries-table tbody tr:last-child td {
  border-bottom: none;
}
.beneficiaries-table .fcn-cell {
  font-weight: 600;
  color: var(--ion-color-success);
}

.status-tag {
  display: inline-block;
  padding: 4px 8px;
  border-radius: 12px;
  font-weight: 500;
  font-size: 0.75rem;
  margin: 2px;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.status-tag.pregnant {
  background-color: rgba(var(--ion-color-warning-rgb), 0.1);
  color: var(--ion-color-warning);
  border: 1px solid var(--ion-color-warning);
}
.status-tag.lactating {
  background-color: rgba(var(--ion-color-secondary-rgb), 0.1);
  color: var(--ion-color-secondary);
  border: 1px solid var(--ion-color-secondary);
}
.status-tag.none {
  background-color: rgba(var(--ion-color-medium-rgb), 0.1);
  color: var(--ion-color-medium);
  border: 1px solid var(--ion-color-medium);
}

.empty-state {
  text-align: center;
  padding: 2rem;
}
.empty-state ion-icon {
  font-size: 4rem;
  margin-bottom: 1rem;
}
.empty-state h3 {
  color: var(--ion-color-dark);
  margin-bottom: 0.5rem;
}
.empty-state p {
  color: var(--ion-color-medium);
  margin: 0;
}

.info-card {
  border: 1px solid var(--ion-color-primary);
}
.info-card ion-card-content {
  display: flex;
  align-items: flex-start;
  gap: 12px;
}
.info-card ion-card-content ion-icon {
  font-size: 24px;
  margin-top: 2px;
}
.info-card ion-card-content div {
  flex: 1;
}
.info-card ion-card-content div p {
  margin: 4px 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-card-title {
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.search-container {
  margin-bottom: 1rem;
}
.search-container .beneficiary-search {
  --background: var(--ion-color-step-50);
  --border-radius: 8px;
  --box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  --color: var(--ion-color-dark);
  --placeholder-color: var(--ion-color-medium);
  --icon-color: var(--ion-color-medium);
  margin: 0;
  font-size: 0.9rem;
}
.search-container .beneficiary-search.searchbar-has-value {
  --background: var(--ion-color-primary-tint);
  --color: var(--ion-color-primary-contrast);
  --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);
  --icon-color: var(--ion-color-primary-contrast);
}

.results-summary {
  margin-bottom: 1rem;
}
.results-summary .search-results {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0.75rem;
  background-color: var(--ion-color-step-100);
  border-radius: 6px;
  margin: 0;
  font-size: 0.9rem;
  color: var(--ion-color-medium);
  font-style: italic;
}
.results-summary .search-results ion-button {
  --color: var(--ion-color-medium);
  font-size: 0.8rem;
}

.no-results {
  text-align: center;
  padding: 2rem;
  background-color: var(--ion-color-step-50);
  border-radius: 8px;
  margin: 1rem 0;
}
.no-results ion-icon {
  font-size: 2.5rem;
  margin-bottom: 0.75rem;
  color: var(--ion-color-medium);
}
.no-results h3 {
  color: var(--ion-color-dark);
  margin-bottom: 0.5rem;
}
.no-results p {
  color: var(--ion-color-medium);
  margin: 0 0 1rem 0;
  font-style: italic;
}
.no-results ion-button {
  --color: var(--ion-color-medium);
  font-size: 0.85rem;
}

.selection-controls {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 1rem;
  margin-bottom: 1rem;
  background-color: var(--ion-color-light-tint);
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
}
.selection-controls .bulk-select-label {
  margin-left: 0.5rem;
  font-weight: 500;
  color: var(--ion-color-dark);
  cursor: pointer;
}
.selection-controls .selection-actions {
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.selected-count {
  color: var(--ion-color-primary);
  font-weight: 600;
  font-size: 0.9rem;
}

.action-buttons {
  margin-top: 1.5rem;
  margin-bottom: 1rem;
}
.action-buttons ion-button[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

@media (max-width: 768px) {
  .beneficiaries-table {
    font-size: 0.8rem;
    min-width: 700px;
  }
  .beneficiaries-table th, .beneficiaries-table td {
    padding: 8px 4px;
  }
  .beneficiaries-table th.checkbox-column, .beneficiaries-table td.checkbox-column {
    padding: 8px 2px;
    width: 40px;
  }
  .beneficiaries-table th:nth-child(2), .beneficiaries-table td:nth-child(2) {
    width: 100px;
  }
  .beneficiaries-table th:nth-child(10),
  .beneficiaries-table td:nth-child(10),
  .beneficiaries-table th:nth-child(9),
  .beneficiaries-table td:nth-child(9) {
    display: none;
  }
  .beneficiaries-table th:nth-child(9),
  .beneficiaries-table td:nth-child(9),
  .beneficiaries-table th:nth-child(8),
  .beneficiaries-table td:nth-child(8) {
    display: none;
  }
  .selection-controls {
    flex-direction: column;
    align-items: flex-start;
    gap: 0.5rem;
    padding: 0.75rem;
  }
  .selection-controls .selection-actions {
    align-self: stretch;
    justify-content: center;
  }
  .detail-item {
    margin-bottom: 0.75rem;
  }
  .detail-item strong {
    font-size: 0.8rem;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/offline-assessment/offline-assessment.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;EACE,iBAAA;EACA,cAAA;AAEF;;AACA;EACE,qBAAA;EACA,kBAAA;AAEF;AAAE;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,WAAA;EACA,SAAA;EACA,iBAAA;EACA,gBAAA;EACA,4BAAA;AAEJ;AACE;EACE,oBAAA;EACA,8BAAA;EACA,eAAA;AACJ;;AAGA;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAAF;AAEE;EACE,gBAAA;EACA,4BAAA;AAAJ;AAGE;EACE,eAAA;EACA,eAAA;AADJ;AAGI;EACE,8BAAA;AADN;AAII;EACE,8BAAA;AAFN;AAME;EACE,WAAA;AAJJ;;AAQA;EACE,mBAAA;AALF;AAOE;EACE,cAAA;EACA,+BAAA;EACA,iBAAA;EACA,sBAAA;AALJ;AAQE;EACE,SAAA;EACA,4BAAA;EACA,eAAA;EACA,qBAAA;AANJ;;AAUA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,mBAAA;AAPF;AASE;EACE,0CAAA;EACA,YAAA;EACA,kBAAA;EACA,SAAA;EACA,2BAAA;EACA,4BAAA;AAPJ;AASI;EACE,SAAA;EACA,iBAAA;EACA,gBAAA;EACA,aAAA;EACA,mBAAA;EACA,QAAA;AAPN;AAUI;EACE,aAAA;EACA,eAAA;AARN;AAYE;EACE,aAAA;AAVJ;;AAcA;EACE,WAAA;EACA,yBAAA;EACA,gBAAA;AAXF;AAaE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,gBAAA;EACA,gDAAA;EACA,iBAAA;EACA,mBAAA;AAXJ;AAaI;EACE,kBAAA;EACA,WAAA;EACA,iBAAA;AAXN;AAcI;EACE,gBAAA;EACA,YAAA;AAZN;AAgBE;EACE,iBAAA;EACA,+CAAA;EACA,iBAAA;EACA,gBAAA;EACA,sBAAA;AAdJ;AAgBI;EACE,kBAAA;EACA,WAAA;EACA,iBAAA;AAdN;AAiBI;EACE,gBAAA;EACA,+BAAA;EACA,gBAAA;EACA,YAAA;AAfN;AAmBE;EACE,yBAAA;AAjBJ;AAmBI;EACE,6CAAA;AAjBN;AAoBI;EACE,0DAAA;EACA,+CAAA;AAlBN;AAoBM;EACE,0DAAA;AAlBR;AAuBE;EACE,mBAAA;AArBJ;AAwBE;EACE,gBAAA;EACA,+BAAA;AAtBJ;;AA0BA;EACE,qBAAA;EACA,gBAAA;EACA,mBAAA;EACA,gBAAA;EACA,kBAAA;EACA,WAAA;EACA,yBAAA;EACA,qBAAA;AAvBF;AAyBE;EACE,yDAAA;EACA,+BAAA;EACA,0CAAA;AAvBJ;AA0BE;EACE,2DAAA;EACA,iCAAA;EACA,4CAAA;AAxBJ;AA2BE;EACE,wDAAA;EACA,8BAAA;EACA,yCAAA;AAzBJ;;AA6BA;EACE,kBAAA;EACA,aAAA;AA1BF;AA4BE;EACE,eAAA;EACA,mBAAA;AA1BJ;AA6BE;EACE,4BAAA;EACA,qBAAA;AA3BJ;AA8BE;EACE,8BAAA;EACA,SAAA;AA5BJ;;AAgCA;EACE,0CAAA;AA7BF;AA+BE;EACE,aAAA;EACA,uBAAA;EACA,SAAA;AA7BJ;AA+BI;EACE,eAAA;EACA,eAAA;AA7BN;AAgCI;EACE,OAAA;AA9BN;AAgCM;EACE,aAAA;EACA,8BAAA;EACA,eAAA;AA9BR;;AAoCA;EACE,aAAA;EACA,mBAAA;EACA,WAAA;AAjCF;;AAoCA;EACE,mBAAA;AAjCF;AAmCE;EACE,sCAAA;EACA,oBAAA;EACA,uCAAA;EACA,8BAAA;EACA,4CAAA;EACA,qCAAA;EACA,SAAA;EACA,iBAAA;AAjCJ;AAmCI;EACE,2CAAA;EACA,0CAAA;EACA,qEAAA;EACA,+CAAA;AAjCN;;AAsCA;EACE,mBAAA;AAnCF;AAqCE;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,gBAAA;EACA,2CAAA;EACA,kBAAA;EACA,SAAA;EACA,iBAAA;EACA,8BAAA;EACA,kBAAA;AAnCJ;AAqCI;EACE,gCAAA;EACA,iBAAA;AAnCN;;AAwCA;EACE,kBAAA;EACA,aAAA;EACA,0CAAA;EACA,kBAAA;EACA,cAAA;AArCF;AAuCE;EACE,iBAAA;EACA,sBAAA;EACA,8BAAA;AArCJ;AAwCE;EACE,4BAAA;EACA,qBAAA;AAtCJ;AAyCE;EACE,8BAAA;EACA,kBAAA;EACA,kBAAA;AAvCJ;AA0CE;EACE,gCAAA;EACA,kBAAA;AAxCJ;;AA4CA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,aAAA;EACA,mBAAA;EACA,6CAAA;EACA,kBAAA;EACA,wCAAA;AAzCF;AA2CE;EACE,mBAAA;EACA,gBAAA;EACA,4BAAA;EACA,eAAA;AAzCJ;AA4CE;EACE,aAAA;EACA,mBAAA;EACA,WAAA;AA1CJ;;AA8CA;EACE,+BAAA;EACA,gBAAA;EACA,iBAAA;AA3CF;;AA8CA;EACE,kBAAA;EACA,mBAAA;AA3CF;AA6CE;EACE,YAAA;EACA,mBAAA;AA3CJ;;AA+CA;EACE;IACE,iBAAA;IACA,gBAAA;EA5CF;EA8CE;IACE,gBAAA;EA5CJ;EA8CI;IACE,gBAAA;IACA,WAAA;EA5CN;EA+CI;IACE,YAAA;EA7CN;EAkDE;;;;IAIE,aAAA;EAhDJ;EAoDE;;;;IAIE,aAAA;EAlDJ;EAsDA;IACE,sBAAA;IACA,uBAAA;IACA,WAAA;IACA,gBAAA;EApDF;EAsDE;IACE,mBAAA;IACA,uBAAA;EApDJ;EAwDA;IACE,sBAAA;EAtDF;EAwDE;IACE,iBAAA;EAtDJ;AACF","sourcesContent":[".assessment-container {\n  max-width: 1200px;\n  margin: 0 auto;\n}\n\n.section-header {\n  margin-bottom: 1.5rem;\n  text-align: center;\n\n  .section-title {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    gap: 0.5rem;\n    margin: 0;\n    font-size: 1.5rem;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n  }\n\n  .section-subtitle {\n    margin: 0.5rem 0 0 0;\n    color: var(--ion-color-medium);\n    font-size: 1rem;\n  }\n}\n\n.form-item {\n  margin-bottom: 16px;\n  border-radius: 8px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n  \n  ion-label {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n  }\n  \n  ion-note {\n    font-size: 12px;\n    margin-top: 4px;\n    \n    &[slot=\"helper\"] {\n      color: var(--ion-color-medium);\n    }\n    \n    &[slot=\"error\"] {\n      color: var(--ion-color-danger);\n    }\n  }\n\n  ion-select {\n    width: 100%;\n  }\n}\n\n.detail-item {\n  margin-bottom: 1rem;\n  \n  strong {\n    display: block;\n    color: var(--ion-color-primary);\n    font-size: 0.9rem;\n    margin-bottom: 0.25rem;\n  }\n  \n  p {\n    margin: 0;\n    color: var(--ion-color-dark);\n    font-size: 1rem;\n    word-wrap: break-word;\n  }\n}\n\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-bottom: 2rem;\n\n  .table-header {\n    background-color: var(--ion-color-primary);\n    color: white;\n    padding: 12px 16px;\n    margin: 0;\n    border-top-left-radius: 8px;\n    border-top-right-radius: 8px;\n\n    h4 {\n      margin: 0;\n      font-size: 1.1rem;\n      font-weight: 600;\n      display: flex;\n      align-items: center;\n      gap: 8px;\n    }\n\n    &::before {\n      content: \"👶\";\n      font-size: 1rem;\n    }\n  }\n\n  &:has(.table-header h4:contains(\"PLW\")) .table-header::before {\n    content: \"🤱\";\n  }\n}\n\n.beneficiaries-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 650px;\n  \n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 12px 8px;\n    text-align: left;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.9rem;\n    white-space: nowrap;\n    \n    &.checkbox-column {\n      text-align: center;\n      width: 60px;\n      padding: 12px 4px;\n    }\n    \n    &:nth-child(2) {\n      text-align: left;\n      width: 120px;\n    }\n  }\n  \n  td {\n    padding: 12px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.9rem;\n    text-align: left;\n    vertical-align: middle;\n    \n    &.checkbox-column {\n      text-align: center;\n      width: 60px;\n      padding: 12px 4px;\n    }\n    \n    &:nth-child(2) {\n      font-weight: 600;\n      color: var(--ion-color-success);\n      text-align: left;\n      width: 120px;\n    }\n  }\n  \n  tbody tr {\n    transition: all 0.2s ease;\n    \n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n    \n    &.selected-row {\n      background-color: rgba(var(--ion-color-primary-rgb), 0.05);\n      border-left: 3px solid var(--ion-color-primary);\n      \n      &:hover {\n        background-color: rgba(var(--ion-color-primary-rgb), 0.08);\n      }\n    }\n  }\n  \n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n  \n  .fcn-cell {\n    font-weight: 600;\n    color: var(--ion-color-success);\n  }\n}\n\n.status-tag {\n  display: inline-block;\n  padding: 4px 8px;\n  border-radius: 12px;\n  font-weight: 500;\n  font-size: 0.75rem;\n  margin: 2px;\n  text-transform: uppercase;\n  letter-spacing: 0.5px;\n\n  &.pregnant {\n    background-color: rgba(var(--ion-color-warning-rgb), 0.1);\n    color: var(--ion-color-warning);\n    border: 1px solid var(--ion-color-warning);\n  }\n\n  &.lactating {\n    background-color: rgba(var(--ion-color-secondary-rgb), 0.1);\n    color: var(--ion-color-secondary);\n    border: 1px solid var(--ion-color-secondary);\n  }\n\n  &.none {\n    background-color: rgba(var(--ion-color-medium-rgb), 0.1);\n    color: var(--ion-color-medium);\n    border: 1px solid var(--ion-color-medium);\n  }\n}\n\n.empty-state {\n  text-align: center;\n  padding: 2rem;\n  \n  ion-icon {\n    font-size: 4rem;\n    margin-bottom: 1rem;\n  }\n  \n  h3 {\n    color: var(--ion-color-dark);\n    margin-bottom: 0.5rem;\n  }\n  \n  p {\n    color: var(--ion-color-medium);\n    margin: 0;\n  }\n}\n\n.info-card {\n  border: 1px solid var(--ion-color-primary);\n  \n  ion-card-content {\n    display: flex;\n    align-items: flex-start;\n    gap: 12px;\n    \n    ion-icon {\n      font-size: 24px;\n      margin-top: 2px;\n    }\n    \n    div {\n      flex: 1;\n      \n      p {\n        margin: 4px 0;\n        color: var(--ion-color-medium);\n        font-size: 14px;\n      }\n    }\n  }\n}\n\nion-card-title {\n  display: flex;\n  align-items: center;\n  gap: 0.5rem;\n}\n\n.search-container {\n  margin-bottom: 1rem;\n\n  .beneficiary-search {\n    --background: var(--ion-color-step-50);\n    --border-radius: 8px;\n    --box-shadow: 0 2px 4px rgba(0,0,0,0.1);\n    --color: var(--ion-color-dark);\n    --placeholder-color: var(--ion-color-medium);\n    --icon-color: var(--ion-color-medium);\n    margin: 0;\n    font-size: 0.9rem;\n\n    &.searchbar-has-value {\n      --background: var(--ion-color-primary-tint);\n      --color: var(--ion-color-primary-contrast);\n      --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);\n      --icon-color: var(--ion-color-primary-contrast);\n    }\n  }\n}\n\n.results-summary {\n  margin-bottom: 1rem;\n\n  .search-results {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    padding: 0.75rem;\n    background-color: var(--ion-color-step-100);\n    border-radius: 6px;\n    margin: 0;\n    font-size: 0.9rem;\n    color: var(--ion-color-medium);\n    font-style: italic;\n\n    ion-button {\n      --color: var(--ion-color-medium);\n      font-size: 0.8rem;\n    }\n  }\n}\n\n.no-results {\n  text-align: center;\n  padding: 2rem;\n  background-color: var(--ion-color-step-50);\n  border-radius: 8px;\n  margin: 1rem 0;\n\n  ion-icon {\n    font-size: 2.5rem;\n    margin-bottom: 0.75rem;\n    color: var(--ion-color-medium);\n  }\n\n  h3 {\n    color: var(--ion-color-dark);\n    margin-bottom: 0.5rem;\n  }\n\n  p {\n    color: var(--ion-color-medium);\n    margin: 0 0 1rem 0;\n    font-style: italic;\n  }\n\n  ion-button {\n    --color: var(--ion-color-medium);\n    font-size: 0.85rem;\n  }\n}\n\n.selection-controls {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1rem;\n  margin-bottom: 1rem;\n  background-color: var(--ion-color-light-tint);\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n\n  .bulk-select-label {\n    margin-left: 0.5rem;\n    font-weight: 500;\n    color: var(--ion-color-dark);\n    cursor: pointer;\n  }\n\n  .selection-actions {\n    display: flex;\n    align-items: center;\n    gap: 0.5rem;\n  }\n}\n\n.selected-count {\n  color: var(--ion-color-primary);\n  font-weight: 600;\n  font-size: 0.9rem;\n}\n\n.action-buttons {\n  margin-top: 1.5rem;\n  margin-bottom: 1rem;\n  \n  ion-button[disabled] {\n    opacity: 0.5;\n    cursor: not-allowed;\n  }\n}\n\n@media (max-width: 768px) {\n  .beneficiaries-table {\n    font-size: 0.8rem;\n    min-width: 700px;\n\n    th, td {\n      padding: 8px 4px;\n\n      &.checkbox-column {\n        padding: 8px 2px;\n        width: 40px;\n      }\n\n      &:nth-child(2) {\n        width: 100px;\n      }\n    }\n\n    // Hide less important columns on mobile\n    th:nth-child(10), // HH No for child table (now 10th column with FCN)\n    td:nth-child(10),\n    th:nth-child(9), // HH No for PLW table (now 9th column with FCN)\n    td:nth-child(9) {\n      display: none;\n    }\n\n    // Hide disability column on smaller screens\n    th:nth-child(9), // Disability for child table (now 9th column with FCN)\n    td:nth-child(9),\n    th:nth-child(8), // Disability for PLW table (now 8th column with FCN)\n    td:nth-child(8) {\n      display: none;\n    }\n  }\n\n  .selection-controls {\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 0.5rem;\n    padding: 0.75rem;\n    \n    .selection-actions {\n      align-self: stretch;\n      justify-content: center;\n    }\n  }\n  \n  .detail-item {\n    margin-bottom: 0.75rem;\n    \n    strong {\n      font-size: 0.8rem;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 10913:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/offline-assessment/offline-assessment.page.html?ngResource ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header [translucent]=\"true\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n        <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Community Assessment Setup</ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button fill=\"clear\" (click)=\"viewOfflineAssessments()\">\n        <ion-icon [name]=\"icons.LIST\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content [fullscreen]=\"true\">\n  <div class=\"ion-padding assessment-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon [name]=\"icons.CLIPBOARD\" color=\"primary\"></ion-icon>\n        Community Assessment Setup\n      </h2>\n      <p class=\"section-subtitle\">Configure assessment parameters for offline data collection</p>\n    </div>\n\n    <!-- Setup Card -->\n    <ion-card>\n      <ion-card-header>\n        <ion-card-title>\n          <ion-icon [name]=\"icons.SETTINGS\" color=\"primary\"></ion-icon>\n          Assessment Configuration\n        </ion-card-title>\n        <ion-card-subtitle>Select assessment type and target location</ion-card-subtitle>\n      </ion-card-header>\n\n      <ion-card-content>\n        <!-- Assessment Type Selection -->\n        <ion-item class=\"form-item\">\n          <ion-icon slot=\"start\" [name]=\"icons.CLIPBOARD\" color=\"primary\"></ion-icon>\n          <ion-label position=\"stacked\">Assessment Type *</ion-label>\n          <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedAssessment\" placeholder=\"Choose assessment\">\n            <ion-select-option *ngFor=\"let assessment of assessments\" [value]=\"assessment\">\n              {{ assessment.title }}\n            </ion-select-option>\n          </ion-select>\n          <ion-note slot=\"error\" *ngIf=\"!selectedAssessment\">\n            This field is required\n          </ion-note>\n        </ion-item>\n\n        <!-- Block Selection -->\n        <ion-item class=\"form-item\">\n          <ion-icon slot=\"start\" [name]=\"icons.LOCATION\" color=\"primary\"></ion-icon>\n          <ion-label position=\"stacked\">Block *</ion-label>\n          <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedBlock\" (ionChange)=\"onBlockChange()\" placeholder=\"Choose block\">\n            <ion-select-option *ngFor=\"let block of blocks\" [value]=\"block\">\n              {{ block.title }}\n            </ion-select-option>\n          </ion-select>\n          <ion-note slot=\"error\" *ngIf=\"!selectedBlock\">\n            This field is required\n          </ion-note>\n        </ion-item>\n\n        <!-- Sub-Block Selection -->\n        <ion-item class=\"form-item\">\n          <ion-icon slot=\"start\" [name]=\"icons.GRID\" color=\"primary\"></ion-icon>\n          <ion-label position=\"stacked\">Sub-Blocks (Optional)</ion-label>\n          <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedSubBlocks\" multiple=\"true\"\n                      [disabled]=\"!selectedBlock\" (ionChange)=\"onSubBlockChange()\"\n                      placeholder=\"Choose sub-blocks (optional)\">\n            <ion-select-option *ngFor=\"let subBlock of subBlocks\" [value]=\"subBlock\">\n              {{ subBlock.title }}\n            </ion-select-option>\n          </ion-select>\n          <ion-note slot=\"helper\" *ngIf=\"selectedBlock\">\n            Select multiple sub-blocks or leave empty to search all sub-blocks in the selected block\n          </ion-note>\n        </ion-item>\n\n        <div class=\"action-buttons\">\n          <ion-button\n            expand=\"block\"\n            fill=\"solid\"\n            color=\"primary\"\n            (click)=\"loadBeneficiaries()\"\n            [disabled]=\"!selectedAssessment || !selectedBlock\">\n            <ion-icon [name]=\"icons.SEARCH\" slot=\"start\"></ion-icon>\n            Load Beneficiaries\n          </ion-button>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n    <!-- Beneficiaries List -->\n    <ion-card *ngIf=\"beneficiaries.length > 0\">\n      <ion-card-header>\n        <ion-card-title>\n          <ion-icon [name]=\"icons.PEOPLE\" color=\"tertiary\"></ion-icon>\n          Eligible Beneficiaries ({{ beneficiaries.length }})\n        </ion-card-title>\n        <ion-card-subtitle>\n          Eligible beneficiaries for the selected assessment\n          <span *ngIf=\"getSelectedCount() > 0\" class=\"selected-count\">\n            • {{ getSelectedCount() }} selected\n          </span>\n        </ion-card-subtitle>\n      </ion-card-header>\n\n      <ion-card-content>\n        <!-- Search Input -->\n        <div class=\"search-container\" *ngIf=\"beneficiaries.length > 0\">\n          <ion-searchbar\n            [(ngModel)]=\"searchTerm\"\n            (ionInput)=\"onSearchChange($event)\"\n            placeholder=\"Search by FCN, name, father/husband name, HH no...\"\n            show-clear-button=\"focus\"\n            debounce=\"300\"\n            class=\"beneficiary-search\">\n          </ion-searchbar>\n        </div>\n\n        <!-- Results Summary -->\n        <div class=\"results-summary\" *ngIf=\"beneficiaries.length > 0 && searchTerm\">\n          <p class=\"search-results\">\n            Showing {{ filteredBeneficiaries.length }} of {{ beneficiaries.length }} beneficiaries\n            <ion-button fill=\"clear\" size=\"small\" (click)=\"clearSearch()\" *ngIf=\"searchTerm\">\n              <ion-icon [name]=\"icons.CLOSE_OUTLINE\" slot=\"start\"></ion-icon>\n              Clear\n            </ion-button>\n          </p>\n        </div>\n\n        <!-- Bulk Selection Controls -->\n        <div class=\"selection-controls\" *ngIf=\"filteredBeneficiaries.length > 0\">\n          <ion-checkbox\n            [(ngModel)]=\"allSelected\"\n            (ionChange)=\"toggleAllBeneficiaries($event)\"\n            [indeterminate]=\"isIndeterminate()\">\n          </ion-checkbox>\n          <ion-label class=\"bulk-select-label\">\n            {{ allSelected ? 'Deselect All Visible' : 'Select All Visible' }} ({{ filteredBeneficiaries.length }})\n          </ion-label>\n\n          <div class=\"selection-actions\" *ngIf=\"getSelectedCount() > 0\">\n            <ion-chip color=\"primary\" outline>\n              <ion-icon [name]=\"icons.CHECKMARK_CIRCLE\" slot=\"start\"></ion-icon>\n              <ion-label>{{ getSelectedCount() }} Selected</ion-label>\n            </ion-chip>\n          </div>\n        </div>\n\n        <!-- Child Beneficiaries Table -->\n        <div class=\"table-container\" *ngIf=\"getFilteredChildBeneficiaries().length > 0\">\n          <div class=\"table-header\" *ngIf=\"hasMixedBeneficiaryTypes()\">\n            <h4>Child Beneficiaries ({{ getFilteredChildBeneficiaries().length }})</h4>\n          </div>\n          <table class=\"beneficiaries-table\">\n            <thead>\n              <tr>\n                <th class=\"checkbox-column\">\n                  <ion-checkbox\n                    [(ngModel)]=\"allSelected\"\n                    (ionChange)=\"toggleAllBeneficiaries($event)\"\n                    [indeterminate]=\"isIndeterminate()\">\n                  </ion-checkbox>\n                </th>\n                <th>FCN</th>\n                <th>Name</th>\n                <th>Age (In M)</th>\n                <th>Father Name</th>\n                <th>Mother Name</th>\n                <th>Gender</th>\n                <th>Disability</th>\n                <th>HH No</th>\n              </tr>\n            </thead>\n            <tbody>\n              <ng-container *ngFor=\"let beneficiary of getFilteredChildBeneficiaries(); let i = index\">\n                <tr [class.selected-row]=\"beneficiary.selected\">\n                <td class=\"checkbox-column\">\n                  <ion-checkbox\n                    [(ngModel)]=\"beneficiary.selected\"\n                    (ionChange)=\"onBeneficiarySelectionChange()\">\n                  </ion-checkbox>\n                </td>\n                <td class=\"fcn-cell\">{{ beneficiary.fcn }}</td>\n                <td>{{ beneficiary.displayName }}</td>\n                <td>{{ beneficiary.age || 'N/A' }}</td>\n                <td>{{ beneficiary.fatherName || 'N/A' }}</td>\n                <td>{{ beneficiary.motherName || 'N/A' }}</td>\n                <td>{{ beneficiary.gender || 'N/A' }}</td>\n                <td>{{ formatDisability(beneficiary.disability) }}</td>\n                <td>{{ beneficiary.householdNo || 'N/A' }}</td>\n                </tr>\n              </ng-container>\n            </tbody>\n          </table>\n        </div>\n\n        <!-- PLW Beneficiaries Table -->\n        <div class=\"table-container\" *ngIf=\"getFilteredPlwBeneficiaries().length > 0\">\n          <div class=\"table-header\" *ngIf=\"hasMixedBeneficiaryTypes()\">\n            <h4>PBW Beneficiaries ({{ getFilteredPlwBeneficiaries().length }})</h4>\n          </div>\n          <table class=\"beneficiaries-table\">\n            <thead>\n              <tr>\n                <th class=\"checkbox-column\">\n                  <ion-checkbox\n                    [(ngModel)]=\"allSelected\"\n                    (ionChange)=\"toggleAllBeneficiaries($event)\"\n                    [indeterminate]=\"isIndeterminate()\">\n                  </ion-checkbox>\n                </th>\n                <th>FCN</th>\n                <th>Name</th>\n                <th>Husband Name</th>\n                <th>Status</th>\n                <th>Sub Block</th>\n                <th>HH No</th>\n              </tr>\n            </thead>\n            <tbody>\n              <ng-container *ngFor=\"let beneficiary of getFilteredPlwBeneficiaries(); let i = index\">\n                <tr [class.selected-row]=\"beneficiary.selected\">\n                <td class=\"checkbox-column\">\n                  <ion-checkbox\n                    [(ngModel)]=\"beneficiary.selected\"\n                    (ionChange)=\"onBeneficiarySelectionChange()\">\n                  </ion-checkbox>\n                </td>\n                <td class=\"fcn-cell\">{{ beneficiary.fcn }}</td>\n                <td>{{ beneficiary.displayName }}</td>\n                <td>{{ beneficiary.husbandName || 'N/A' }}</td>\n                <td>\n                  <small *ngIf=\"beneficiary.isPregnant\" class=\"status-tag pregnant\">Pregnant</small>\n                  <small *ngIf=\"beneficiary.isLactating\" class=\"status-tag lactating\">Lactating</small>\n                  <small *ngIf=\"!beneficiary.isPregnant && !beneficiary.isLactating\" class=\"status-tag none\">N/A</small>\n                </td>\n                <td>{{ beneficiary.subBlock || 'N/A' }}</td>\n                <td>{{ beneficiary.householdNo || 'N/A' }}</td>\n                </tr>\n              </ng-container>\n            </tbody>\n          </table>\n        </div>\n\n        <div class=\"action-buttons\">\n          <ion-button\n            expand=\"block\"\n            fill=\"solid\"\n            color=\"success\"\n            [disabled]=\"getSelectedCount() === 0\"\n            (click)=\"saveForOffline()\">\n            <ion-icon [name]=\"icons.DOWNLOAD\" slot=\"start\"></ion-icon>\n            Save Selected for Community Assessment ({{ getSelectedCount() }})\n          </ion-button>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n    <!-- No Search Results -->\n    <ion-card *ngIf=\"beneficiaries.length > 0 && filteredBeneficiaries.length === 0 && searchTerm\">\n      <ion-card-content>\n        <div class=\"no-results\">\n          <ion-icon [name]=\"icons.SEARCH\" color=\"medium\"></ion-icon>\n          <h3>No Search Results</h3>\n          <p>No beneficiaries found matching \"{{ searchTerm }}\"</p>\n          <ion-button fill=\"outline\" (click)=\"clearSearch()\">\n            <ion-icon [name]=\"icons.CLOSE_OUTLINE\" slot=\"start\"></ion-icon>\n            Clear Search\n          </ion-button>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n    <!-- Empty State -->\n    <ion-card *ngIf=\"selectedBlock && beneficiaries.length === 0 && !isLoading\">\n      <ion-card-content>\n        <div class=\"empty-state\">\n          <ion-icon [name]=\"icons.PEOPLE\" color=\"medium\"></ion-icon>\n          <h3>No Beneficiaries Found</h3>\n          <p>No eligible beneficiaries found in the selected {{ selectedSubBlocks.length > 0 ? 'block and sub-blocks' : 'block' }}.</p>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n  </div>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_offline-assessment_offline-assessment_module_ts.js.map