(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_manage-supplylist_manage-supplylist_module_ts"],{

/***/ 61391:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/manage-supplylist/manage-supplylist-routing.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ManageSupplylistPageRoutingModule: () => (/* binding */ ManageSupplylistPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _manage_supplylist_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./manage-supplylist.page */ 55649);




const routes = [{
  path: '',
  component: _manage_supplylist_page__WEBPACK_IMPORTED_MODULE_0__.ManageSupplylistPage
}];
let ManageSupplylistPageRoutingModule = class ManageSupplylistPageRoutingModule {};
ManageSupplylistPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], ManageSupplylistPageRoutingModule);


/***/ }),

/***/ 74494:
/*!*********************************************************************!*\
  !*** ./src/app/pages/manage-supplylist/manage-supplylist.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ManageSupplylistPageModule: () => (/* binding */ ManageSupplylistPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _manage_supplylist_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./manage-supplylist-routing.module */ 61391);
/* harmony import */ var _manage_supplylist_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./manage-supplylist.page */ 55649);








let ManageSupplylistPageModule = class ManageSupplylistPageModule {};
ManageSupplylistPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _manage_supplylist_routing_module__WEBPACK_IMPORTED_MODULE_1__.ManageSupplylistPageRoutingModule],
  declarations: [_manage_supplylist_page__WEBPACK_IMPORTED_MODULE_2__.ManageSupplylistPage]
})], ManageSupplylistPageModule);


/***/ }),

/***/ 55649:
/*!*******************************************************************!*\
  !*** ./src/app/pages/manage-supplylist/manage-supplylist.page.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ManageSupplylistPage: () => (/* binding */ ManageSupplylistPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _manage_supplylist_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./manage-supplylist.page.html?ngResource */ 27235);
/* harmony import */ var _manage_supplylist_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./manage-supplylist.page.scss?ngResource */ 4791);
/* harmony import */ var _manage_supplylist_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_manage_supplylist_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 52575);
/* harmony import */ var src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/supply_api.service */ 78982);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _ManageSupplylistPage;











let ManageSupplylistPage = (_ManageSupplylistPage = class ManageSupplylistPage {
  constructor(route, router, api, b, change, formBuilder) {
    this.route = route;
    this.router = router;
    this.api = api;
    this.b = b;
    this.change = change;
    this.formBuilder = formBuilder;
    this.searchTerm = '';
    this.searching = false;
    this.pending = -1;
    this.transactionTypes = [];
    this.isRequisitionMode = false;
    this.lastSupplyOutDate = null;
    // Pagination properties
    this.currentPage = 1;
    this.itemsPerPage = 10;
    this.totalPages = 1;
    // Backend flag for pending transactions
    this.hasPendingFromBackend = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_6__.ICONS;
    //construction works
    this.searchControl = new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormControl();
    this.transactionDefControl = new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormControl(''); // Default to 'All Supply'
    this.type = this.route.snapshot.paramMap.get('type');
    // Check for requisition mode
    this.route.queryParams.subscribe(params => {
      this.isRequisitionMode = params['mode'] === 'requisition';
      if (this.isRequisitionMode) {
        this.title = 'Requisitions';
        this.transactionDefControl.setValue('inf_to_dp');
        this.transactionDefControl.disable();
      } else {
        this.title = src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.supplyListConfig[this.type].title;
      }
    });
    // Set default date range (last 7 days)
    const today = new Date();
    const sevenDaysAgo = new Date(today);
    sevenDaysAgo.setDate(today.getDate() - 7);
    this.filterForm = this.formBuilder.group({
      start_date: [this.formatDateForInput(sevenDaysAgo)],
      end_date: [this.formatDateForInput(today)]
    });
    // Set transaction types based on type
    this.setTransactionTypes();
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Load last supply-out date for supply-in deletion validation
      if (_this.type === 'in') {
        yield _this.loadLastSupplyOutDate();
      }
      // Auto-apply filter for requisition mode or Facility Supervisor viewing 'out' transactions
      if (_this.isRequisitionMode || _this.type === 'out' && _this.isFacilitySupervisor()) {
        if (!_this.isRequisitionMode) {
          _this.transactionDefControl.setValue('inf_to_dp');
        }
        _this.applyFilter();
      } else {
        _this.load();
      }
    })();
  }
  loadLastSupplyOutDate() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        var _response$data;
        const response = yield _this2.api.getLastTransactionDate('Out');
        _this2.lastSupplyOutDate = (response === null || response === void 0 || (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.transaction_date) || null;
      } catch (error) {
        _this2.lastSupplyOutDate = null;
      }
    })();
  }
  load(event, filterParams) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        let resp;
        if (filterParams) {
          resp = yield _this3.api.getFilteredSupplyTransactions(filterParams);
        } else {
          resp = yield _this3.api.manageSupplyList(_this3.type);
        }
        if (_this3.type === 'process-request-list') {
          var _resp$data;
          _this3.manageRequestListItemList = resp.data.all_request || resp.data;
          _this3.pending = (_resp$data = resp.data) === null || _resp$data === void 0 ? void 0 : _resp$data.request_pending;
        } else if (_this3.type === 'process-return-list') {
          var _resp$data2;
          _this3.manageRequestListItemList = resp.data.all_return || resp.data;
          _this3.pending = (_resp$data2 = resp.data) === null || _resp$data2 === void 0 ? void 0 : _resp$data2.return_pending;
        } else {
          var _resp$data3;
          // Handle new response structure with has_pending flag
          if ((_resp$data3 = resp.data) !== null && _resp$data3 !== void 0 && _resp$data3.transactions) {
            _this3.manageRequestListItemList = resp.data.transactions;
            _this3.hasPendingFromBackend = resp.data.has_pending || false;
          } else {
            _this3.manageRequestListItemList = resp.data;
            _this3.hasPendingFromBackend = false;
          }
        }
        _this3.filteredList = _this3.manageRequestListItemList;
        _this3.updatePagination();
        if (event) {
          setTimeout(() => {
            event.target.complete();
          }, 2000);
        }
        _this3.change.markForCheck();
      } catch (error) {
        if (event) {
          setTimeout(() => {
            event.target.complete();
          }, 2000);
        }
      }
    })();
  }
  delete(id) {
    var _this4 = this;
    this.b.loadAlert('Delete Supply Item', 'Are you sure you want to delete?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const result = yield _this4.api.deleteSupplyItem(id);
      _this4.b.responseToast(result);
      if (result.success) {
        // Reload data from server to ensure consistency
        yield _this4.load();
      }
    }));
  }
  ionViewDidEnter() {
    this.searchControl.valueChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(250)).subscribe(search => {
      this.searchTerm = search;
      this.searching = false;
      this.setFilteredItems();
    });
    // Always reload data when view is entered to ensure fresh data
    this.load();
  }
  onSearchInput() {
    this.searching = true;
  }
  setFilteredItems() {
    this.filteredList = this.filterItems(this.searchTerm);
    this.updatePagination();
  }
  filterItems(searchTerm) {
    const val = searchTerm.toLowerCase();
    return this.manageRequestListItemList.filter(item => {
      var _item$id, _item$invoice_no, _item$waybill, _item$transaction_dat, _item$created_by, _item$status, _item$pp, _item$transfer_type, _item$supply_source, _item$supply_destinat;
      return (item === null || item === void 0 || (_item$id = item.id) === null || _item$id === void 0 ? void 0 : _item$id.toString().toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$invoice_no = item.invoice_no) === null || _item$invoice_no === void 0 ? void 0 : _item$invoice_no.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$waybill = item.waybill) === null || _item$waybill === void 0 ? void 0 : _item$waybill.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$transaction_dat = item.transaction_date) === null || _item$transaction_dat === void 0 ? void 0 : _item$transaction_dat.toString().toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$created_by = item.created_by) === null || _item$created_by === void 0 ? void 0 : _item$created_by.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$status = item.status) === null || _item$status === void 0 ? void 0 : _item$status.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$pp = item.pp) === null || _item$pp === void 0 ? void 0 : _item$pp.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$transfer_type = item.transfer_type) === null || _item$transfer_type === void 0 ? void 0 : _item$transfer_type.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$supply_source = item.supply_source) === null || _item$supply_source === void 0 ? void 0 : _item$supply_source.toLowerCase().indexOf(val)) > -1 || (item === null || item === void 0 || (_item$supply_destinat = item.supply_destination) === null || _item$supply_destinat === void 0 ? void 0 : _item$supply_destinat.toLowerCase().indexOf(val)) > -1;
    });
  }
  getStatusColor(status) {
    switch (status === null || status === void 0 ? void 0 : status.toLowerCase()) {
      case 'pending':
        return 'warning';
      case 'approved':
        return 'success';
      case 'draft':
        return 'secondary';
      case 'locked':
        return 'tertiary';
      case 'rejected':
        return 'danger';
      default:
        return 'medium';
    }
  }
  getStatusIcon(status) {
    switch (status === null || status === void 0 ? void 0 : status.toLowerCase()) {
      case 'pending':
        return 'time-outline';
      case 'approved':
        return 'checkmark-circle-outline';
      case 'draft':
        return 'document-outline';
      case 'locked':
        return 'lock-closed-outline';
      case 'rejected':
        return 'close-circle-outline';
      default:
        return 'information-circle-outline';
    }
  }
  isTransactionEditable(status) {
    // Can only edit draft and pending transactions
    const editableStatuses = ['draft', 'pending'];
    return editableStatuses.includes(status === null || status === void 0 ? void 0 : status.toLowerCase());
  }
  isLatestTransaction(transaction) {
    if (!this.manageRequestListItemList || this.manageRequestListItemList.length === 0) return false;
    if (!transaction || !transaction.created_at) return false;
    // Find the latest transaction by created_at date from full list
    const latestTransaction = this.manageRequestListItemList.reduce((latest, current) => {
      if (!current.created_at) return latest;
      if (!latest.created_at) return current;
      const latestDate = new Date(latest.created_at).getTime();
      const currentDate = new Date(current.created_at).getTime();
      return currentDate > latestDate ? current : latest;
    });
    return transaction.id === latestTransaction.id;
  }
  canDeleteTransaction(transaction) {
    // For supply-out: Only allow deletion if it's the latest transaction
    if (this.type === 'out') {
      return this.isLatestTransaction(transaction);
    }
    // For supply-in: Allow deletion only if transaction date is after last supply-out date
    if (this.type === 'in') {
      // If there's no supply-out date, allow deletion
      if (!this.lastSupplyOutDate) {
        return true;
      }
      // Compare transaction date with last supply-out date
      const transactionDate = new Date(transaction.transaction_date);
      const lastOutDate = new Date(this.lastSupplyOutDate);
      // Reset time to compare only dates
      transactionDate.setHours(0, 0, 0, 0);
      lastOutDate.setHours(0, 0, 0, 0);
      // Allow deletion only if transaction date is after last supply-out date
      return transactionDate > lastOutDate;
    }
    return false;
  }
  addSupplyToStore() {
    this.router.navigate([this.b.routesConfig.supplyIn]);
  }
  addDailyReturn() {
    this.router.navigate([this.b.routesConfig.supplyIn], {
      queryParams: {
        mode: 'daily-return'
      }
    });
  }
  addSupplyOut() {
    if (this.isRequisitionMode) {
      this.router.navigate(['/supply-out'], {
        queryParams: {
          mode: 'requisition'
        }
      });
    } else {
      this.router.navigate(['/supply-out']);
    }
  }
  hasUnapprovedTransactions() {
    var _this$filteredList;
    return ((_this$filteredList = this.filteredList) === null || _this$filteredList === void 0 ? void 0 : _this$filteredList.some(item => {
      var _item$status2, _item$status3;
      return ((_item$status2 = item.status) === null || _item$status2 === void 0 ? void 0 : _item$status2.toLowerCase()) === 'pending' || ((_item$status3 = item.status) === null || _item$status3 === void 0 ? void 0 : _item$status3.toLowerCase()) === 'draft';
    })) || false;
  }
  canCreateNewRequisition() {
    if (!this.isRequisitionMode) return true;
    return !this.hasUnapprovedTransactions();
  }
  canCreateNewTransaction() {
    // Use backend flag if available, otherwise fall back to frontend check
    return !this.hasPendingFromBackend && !this.hasUnapprovedTransactions();
  }
  returnSupply(supplyItem) {
    // Navigate to the supply-out module for processing returns
    this.router.navigate(['/supply-edit-out', supplyItem.id]);
  }
  viewTransactionDetail(supplyItem) {
    // Navigate to the supply detail page, preserving requisition mode
    if (this.isRequisitionMode) {
      this.router.navigate(['/supply-detail', supplyItem.id], {
        queryParams: {
          fromRequisition: 'true'
        }
      });
    } else {
      this.router.navigate(['/supply-detail', supplyItem.id]);
    }
  }
  applyFilter() {
    var _this$filterForm$get, _this$filterForm$get2;
    const startDate = (_this$filterForm$get = this.filterForm.get('start_date')) === null || _this$filterForm$get === void 0 ? void 0 : _this$filterForm$get.value;
    const endDate = (_this$filterForm$get2 = this.filterForm.get('end_date')) === null || _this$filterForm$get2 === void 0 ? void 0 : _this$filterForm$get2.value;
    const transactionDef = this.transactionDefControl.value;
    if (!startDate || !endDate) {
      this.b.errorToast('Please select start date and end date');
      return;
    }
    const filterParams = {
      transaction_type: this.type,
      start_date: startDate,
      end_date: endDate
    };
    // Only add transaction_def if it's not empty (not "All Supply")
    if (transactionDef && transactionDef !== '') {
      filterParams.transaction_def = transactionDef;
    }
    this.load(null, filterParams);
  }
  formatDateForInput(date) {
    return date.toISOString().split('T')[0];
  }
  getDatePlaceholder() {
    return 'dd/mm/yyyy';
  }
  getFormattedDate(date) {
    if (!date) return '';
    const d = new Date(date);
    const day = String(d.getDate()).padStart(2, '0');
    const month = String(d.getMonth() + 1).padStart(2, '0');
    const year = d.getFullYear();
    return `${day}/${month}/${year}`;
  }
  getFormattedTransactionDate(date) {
    if (!date) return '-';
    const d = new Date(date);
    const day = String(d.getDate()).padStart(2, '0');
    const month = String(d.getMonth() + 1).padStart(2, '0');
    const year = d.getFullYear();
    return `${day}/${month}/${year}`;
  }
  getFormattedCreatedDate(date) {
    if (!date) return '-';
    const d = new Date(date);
    const day = String(d.getDate()).padStart(2, '0');
    const month = String(d.getMonth() + 1).padStart(2, '0');
    const year = d.getFullYear();
    let hours = d.getHours();
    const minutes = String(d.getMinutes()).padStart(2, '0');
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    const hoursStr = String(hours).padStart(2, '0');
    return `${day}/${month}/${year} ${hoursStr}:${minutes} ${ampm}`;
  }
  formatDateDDMMYYYY(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${day}/${month}/${year}`;
  }
  setTransactionTypes() {
    // Always include "All Supply" as first option
    this.transactionTypes = [{
      value: '',
      title: 'All Supply'
    }];
    if (this.type === 'in') {
      this.transactionTypes.push({
        value: 'dp_to_inf',
        title: 'From Distribution Point'
      }, {
        value: 'wh_to_inf',
        title: 'WH to INF'
      }, {
        value: 'inf_to_inf',
        title: 'INF to INF'
      });
    } else if (this.type === 'out') {
      this.transactionTypes.push({
        value: 'inf_to_dp',
        title: 'INF to DP'
      }, {
        value: 'inf_to_wh',
        title: 'INF to WH'
      }, {
        value: 'inf_to_inf',
        title: 'INF to INF'
      });
    }
  }
  isFacilitySupervisor() {
    var _user$user;
    const user = this.b.getCurrentUser();
    return (user === null || user === void 0 || (_user$user = user.user) === null || _user$user === void 0 ? void 0 : _user$user.user_type) === 'Facility Supervisor';
  }
  updatePagination() {
    var _this$filteredList2;
    this.totalPages = Math.ceil((((_this$filteredList2 = this.filteredList) === null || _this$filteredList2 === void 0 ? void 0 : _this$filteredList2.length) || 0) / this.itemsPerPage);
    if (this.currentPage > this.totalPages) {
      this.currentPage = this.totalPages > 0 ? this.totalPages : 1;
    }
    this.updatePaginatedList();
  }
  updatePaginatedList() {
    var _this$filteredList3;
    const startIndex = (this.currentPage - 1) * this.itemsPerPage;
    const endIndex = startIndex + this.itemsPerPage;
    this.paginatedList = ((_this$filteredList3 = this.filteredList) === null || _this$filteredList3 === void 0 ? void 0 : _this$filteredList3.slice(startIndex, endIndex)) || [];
    this.change.markForCheck();
  }
  goToPage(page) {
    if (page >= 1 && page <= this.totalPages) {
      this.currentPage = page;
      this.updatePaginatedList();
    }
  }
  nextPage() {
    if (this.currentPage < this.totalPages) {
      this.currentPage++;
      this.updatePaginatedList();
    }
  }
  previousPage() {
    if (this.currentPage > 1) {
      this.currentPage--;
      this.updatePaginatedList();
    }
  }
  getPageNumbers() {
    const pages = [];
    const maxPagesToShow = 5;
    let startPage = Math.max(1, this.currentPage - Math.floor(maxPagesToShow / 2));
    let endPage = Math.min(this.totalPages, startPage + maxPagesToShow - 1);
    if (endPage - startPage + 1 < maxPagesToShow) {
      startPage = Math.max(1, endPage - maxPagesToShow + 1);
    }
    for (let i = startPage; i <= endPage; i++) {
      pages.push(i);
    }
    return pages;
  }
}, _ManageSupplylistPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.Router
}, {
  type: src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__.SupplyAPIService
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ChangeDetectorRef
}, {
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder
}], _ManageSupplylistPage);
ManageSupplylistPage = (0,tslib__WEBPACK_IMPORTED_MODULE_11__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_10__.Component)({
  selector: 'app-manage-supplylist',
  template: _manage_supplylist_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ChangeDetectionStrategy.OnPush,
  styles: [(_manage_supplylist_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ManageSupplylistPage);


/***/ }),

/***/ 52575:
/*!***********************************************************************!*\
  !*** ./node_modules/rxjs/dist/esm/internal/operators/debounceTime.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounceTime: () => (/* binding */ debounceTime)
/* harmony export */ });
/* harmony import */ var _scheduler_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scheduler/async */ 18473);
/* harmony import */ var _util_lift__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/lift */ 50819);
/* harmony import */ var _OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OperatorSubscriber */ 91687);



function debounceTime(dueTime, scheduler = _scheduler_async__WEBPACK_IMPORTED_MODULE_0__.asyncScheduler) {
  return (0,_util_lift__WEBPACK_IMPORTED_MODULE_1__.operate)((source, subscriber) => {
    let activeTask = null;
    let lastValue = null;
    let lastTime = null;
    const emit = () => {
      if (activeTask) {
        activeTask.unsubscribe();
        activeTask = null;
        const value = lastValue;
        lastValue = null;
        subscriber.next(value);
      }
    };
    function emitWhenIdle() {
      const targetTime = lastTime + dueTime;
      const now = scheduler.now();
      if (now < targetTime) {
        activeTask = this.schedule(undefined, targetTime - now);
        subscriber.add(activeTask);
        return;
      }
      emit();
    }
    source.subscribe((0,_OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__.createOperatorSubscriber)(subscriber, value => {
      lastValue = value;
      lastTime = scheduler.now();
      if (!activeTask) {
        activeTask = scheduler.schedule(emitWhenIdle, dueTime);
        subscriber.add(activeTask);
      }
    }, () => {
      emit();
      subscriber.complete();
    }, undefined, () => {
      lastValue = activeTask = null;
    }));
  });
}

/***/ }),

/***/ 4791:
/*!********************************************************************************!*\
  !*** ./src/app/pages/manage-supplylist/manage-supplylist.page.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.supply-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.action-buttons-group {
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
  flex: 0 1 auto;
}
.action-buttons-group .action-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  min-width: 120px;
  transition: all 0.3s ease;
}
.action-buttons-group .action-btn ion-icon {
  font-size: 18px;
  margin-inline-end: 6px !important;
}
.action-buttons-group .action-btn:hover {
  transform: translateY(-2px);
  --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);
}
.action-buttons-group .action-btn:active {
  transform: translateY(0);
}
.action-buttons-group .pending-chip {
  height: 32px;
  font-weight: 600;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 100%;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 6px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: normal;
  word-wrap: break-word;
}
.measurements-table td {
  padding: 10px 6px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

.row-number {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: center;
  width: 30px;
  font-size: 15px;
}

.transaction-type-cell, .supply-source-cell, .supply-destination-cell {
  max-width: 120px;
  font-size: 15px;
  color: var(--ion-color-dark);
  line-height: 1.2;
}

.actions-cell {
  min-width: 120px; /* Ensure minimum space for buttons */
  text-align: center;
}

.status-cell ion-badge {
  font-size: 12px;
  font-weight: 600;
  padding: 4px 10px;
  border-radius: 6px;
  text-transform: capitalize;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 300px;
}

.filter-item {
  --background: rgba(73, 144, 226, 0.02);
  --border-radius: 8px;
  margin-bottom: 12px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.filter-item ion-label {
  font-size: 12px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin-bottom: 4px;
}

.filter-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  margin-top: 8px;
}
.filter-btn ion-icon {
  font-size: 18px;
}

ion-searchbar {
  margin-bottom: 12px;
  --border-radius: 12px;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .action-buttons-group {
    width: 100%;
    justify-content: stretch;
  }
  .action-buttons-group .action-btn {
    flex: 1 1 auto;
    height: 42px;
    font-size: 13px;
    min-width: 100px;
  }
  .action-buttons-group .action-btn ion-icon {
    font-size: 16px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .measurements-table {
    font-size: 0.75rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .status-cell ion-badge {
    font-size: 11px;
    padding: 3px 8px;
  }
  .filter-item {
    margin-bottom: 8px;
  }
  .filter-item ion-label {
    font-size: 11px;
  }
  .filter-btn {
    height: 40px;
    font-size: 13px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .action-buttons-group {
    flex-direction: column;
    gap: 8px;
  }
  .action-buttons-group .action-btn {
    width: 100%;
    min-width: auto;
    height: 40px;
    font-size: 13px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .measurements-table {
    font-size: 0.7rem;
    min-width: 100%;
  }
  .measurements-table th, .measurements-table td {
    padding: 6px 3px;
    font-size: 0.7rem;
  }
  .status-cell ion-badge {
    font-size: 10px;
    padding: 2px 6px;
  }
  .filter-item {
    margin-bottom: 6px;
  }
  .filter-item ion-label {
    font-size: 10px;
  }
  .filter-btn {
    height: 38px;
    font-size: 12px;
  }
}
.warning-card {
  margin-bottom: 16px;
}
.warning-card .warning-content {
  display: flex;
  align-items: center;
  gap: 16px;
}
.warning-card .warning-content ion-icon {
  flex-shrink: 0;
  color: var(--ion-color-warning-contrast);
}
.warning-card .warning-content h3 {
  margin: 0 0 4px 0;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-warning-contrast);
}
.warning-card .warning-content p {
  margin: 0;
  font-size: 14px;
  color: var(--ion-color-warning-contrast);
  opacity: 0.9;
}

.items-per-page {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 14px;
}
.items-per-page ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
  white-space: nowrap;
}
.items-per-page ion-select {
  min-width: 80px;
  --padding-start: 8px;
  --padding-end: 8px;
}

.pagination-container {
  display: flex;
  align-items: center;
  justify-content: center;
  flex-wrap: wrap;
  gap: 4px;
  padding: 16px 8px;
  margin-top: 16px;
  border-top: 1px solid var(--ion-color-light);
}
.pagination-container ion-button {
  --border-radius: 8px;
  min-width: 40px;
  height: 36px;
  margin: 0;
}
.pagination-container ion-button[disabled] {
  opacity: 0.4;
}
.pagination-container .pagination-dots {
  padding: 0 8px;
  color: var(--ion-color-medium);
  font-weight: 600;
}
.pagination-container .pagination-info {
  width: 100%;
  text-align: center;
  margin-top: 8px;
  font-size: 13px;
  color: var(--ion-color-medium);
  font-weight: 500;
}

@media (max-width: 768px) {
  .items-per-page {
    font-size: 12px;
  }
  .items-per-page ion-select {
    min-width: 70px;
  }
  .pagination-container {
    padding: 12px 4px;
    gap: 2px;
  }
  .pagination-container ion-button {
    min-width: 36px;
    height: 32px;
    font-size: 12px;
  }
  .pagination-container .pagination-dots {
    padding: 0 4px;
  }
  .pagination-container .pagination-info {
    font-size: 12px;
    margin-top: 6px;
  }
}
@media (max-width: 480px) {
  .section-header {
    flex-direction: column;
    align-items: flex-start !important;
    gap: 12px;
  }
  .items-per-page {
    width: 100%;
    justify-content: space-between;
  }
  .pagination-container {
    padding: 10px 2px;
  }
  .pagination-container ion-button {
    min-width: 32px;
    height: 28px;
    font-size: 11px;
  }
  .pagination-container .pagination-info {
    font-size: 11px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/manage-supplylist/manage-supplylist.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,gBAAA;EACA,cAAA;AADF;;AAIA;EACE,gBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAMA;EACE,aAAA;EACA,SAAA;EACA,eAAA;EACA,mBAAA;EACA,cAAA;AAHF;AAKE;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,gBAAA;EACA,yBAAA;AAHJ;AAKI;EACE,eAAA;EACA,iCAAA;AAHN;AAMI;EACE,2BAAA;EACA,4CAAA;AAJN;AAOI;EACE,wBAAA;AALN;AASE;EACE,YAAA;EACA,gBAAA;AAPJ;;AAYA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AATF;;AAYA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AATF;AAWE;EACE,eAAA;EACA,cAAA;AATJ;;AAcA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AAXF;;AAeA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;AAZF;AAcE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;EACA,qBAAA;AAZJ;AAeE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAbJ;AAgBE;EACE,yBAAA;AAdJ;AAgBI;EACE,6CAAA;AAdN;AAkBE;EACE,mBAAA;AAhBJ;;AAoBA;EACE,gBAAA;EACA,+BAAA;EACA,kBAAA;EACA,WAAA;EACA,eAAA;AAjBF;;AAoBA;EACE,gBAAA;EACA,eAAA;EACA,4BAAA;EACA,gBAAA;AAjBF;;AAoBA;EACE,gBAAA,EAAA,qCAAA;EACA,kBAAA;AAjBF;;AAqBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,0BAAA;AAlBJ;;AAuBA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AApBF;AAsBE;EACE,eAAA;EACA,mBAAA;AApBJ;AAuBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AArBJ;AAwBE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AAtBJ;;AA2BA;EACE,sCAAA;EACA,oBAAA;EACA,mBAAA;EACA,qCAAA;AAxBF;AA0BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AAxBJ;;AA4BA;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,eAAA;AAzBF;AA2BE;EACE,eAAA;AAzBJ;;AA6BA;EACE,mBAAA;EACA,qBAAA;AA1BF;;AA8BA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EA3BF;EA8BA;IACE,mBAAA;EA5BF;EA+BA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EA7BF;EAgCA;IACE,eAAA;IACA,WAAA;EA9BF;EAgCE;IACE,eAAA;EA9BJ;EAkCA;IACE,WAAA;IACA,wBAAA;EAhCF;EAkCE;IACE,cAAA;IACA,YAAA;IACA,eAAA;IACA,gBAAA;EAhCJ;EAkCI;IACE,eAAA;EAhCN;EAqCA;IACE,cAAA;IACA,SAAA;EAnCF;EAqCE;IACE,eAAA;EAnCJ;EAqCI;IACE,eAAA;EAnCN;EAwCA;IACE,kBAAA;IACA,eAAA;EAtCF;EAwCE;IACE,gBAAA;IACA,kBAAA;EAtCJ;EA0CA;IACE,eAAA;IACA,gBAAA;EAxCF;EA2CA;IACE,kBAAA;EAzCF;EA2CE;IACE,eAAA;EAzCJ;EA6CA;IACE,YAAA;IACA,eAAA;EA3CF;AACF;AA8CA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EA5CF;EA+CA;IACE,mBAAA;EA7CF;EAgDA;IACE,mBAAA;EA9CF;EAiDA;IACE,eAAA;EA/CF;EAiDE;IACE,eAAA;EA/CJ;EAmDA;IACE,sBAAA;IACA,QAAA;EAjDF;EAmDE;IACE,WAAA;IACA,eAAA;IACA,YAAA;IACA,eAAA;EAjDJ;EAqDA;IACE,cAAA;IACA,QAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAqDI;IACE,eAAA;EAnDN;EAwDA;IACE,iBAAA;IACA,eAAA;EAtDF;EAwDE;IACE,gBAAA;IACA,iBAAA;EAtDJ;EA0DA;IACE,eAAA;IACA,gBAAA;EAxDF;EA2DA;IACE,kBAAA;EAzDF;EA2DE;IACE,eAAA;EAzDJ;EA6DA;IACE,YAAA;IACA,eAAA;EA3DF;AACF;AA+DA;EACE,mBAAA;AA7DF;AA+DE;EACE,aAAA;EACA,mBAAA;EACA,SAAA;AA7DJ;AA+DI;EACE,cAAA;EACA,wCAAA;AA7DN;AAgEI;EACE,iBAAA;EACA,eAAA;EACA,gBAAA;EACA,wCAAA;AA9DN;AAiEI;EACE,SAAA;EACA,eAAA;EACA,wCAAA;EACA,YAAA;AA/DN;;AAqEA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;AAlEF;AAoEE;EACE,gBAAA;EACA,4BAAA;EACA,mBAAA;AAlEJ;AAqEE;EACE,eAAA;EACA,oBAAA;EACA,kBAAA;AAnEJ;;AAuEA;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,eAAA;EACA,QAAA;EACA,iBAAA;EACA,gBAAA;EACA,4CAAA;AApEF;AAsEE;EACE,oBAAA;EACA,eAAA;EACA,YAAA;EACA,SAAA;AApEJ;AAsEI;EACE,YAAA;AApEN;AAwEE;EACE,cAAA;EACA,8BAAA;EACA,gBAAA;AAtEJ;AAyEE;EACE,WAAA;EACA,kBAAA;EACA,eAAA;EACA,eAAA;EACA,8BAAA;EACA,gBAAA;AAvEJ;;AA2EA;EACE;IACE,eAAA;EAxEF;EA0EE;IACE,eAAA;EAxEJ;EA4EA;IACE,iBAAA;IACA,QAAA;EA1EF;EA4EE;IACE,eAAA;IACA,YAAA;IACA,eAAA;EA1EJ;EA6EE;IACE,cAAA;EA3EJ;EA8EE;IACE,eAAA;IACA,eAAA;EA5EJ;AACF;AAgFA;EACE;IACE,sBAAA;IACA,kCAAA;IACA,SAAA;EA9EF;EAiFA;IACE,WAAA;IACA,8BAAA;EA/EF;EAkFA;IACE,iBAAA;EAhFF;EAkFE;IACE,eAAA;IACA,YAAA;IACA,eAAA;EAhFJ;EAmFE;IACE,eAAA;EAjFJ;AACF","sourcesContent":["// Styles matching child-detail design\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.supply-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header (matching child-detail)\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.action-buttons-group {\n  display: flex;\n  gap: 10px;\n  flex-wrap: wrap;\n  align-items: center;\n  flex: 0 1 auto;\n\n  .action-btn {\n    --border-radius: 12px;\n    --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n    height: 44px;\n    font-size: 14px;\n    font-weight: 600;\n    text-transform: none;\n    min-width: 120px;\n    transition: all 0.3s ease;\n\n    ion-icon {\n      font-size: 18px;\n      margin-inline-end: 6px !important;\n    }\n\n    &:hover {\n      transform: translateY(-2px);\n      --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);\n    }\n\n    &:active {\n      transform: translateY(0);\n    }\n  }\n\n  .pending-chip {\n    height: 32px;\n    font-weight: 600;\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Table Container (matching child-detail)\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n// Measurements Table Styles (matching child-detail)\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 100%; // Changed from 800px to fit viewport\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 6px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: normal; // Changed from nowrap to allow text wrapping\n    word-wrap: break-word;\n  }\n\n  td {\n    padding: 10px 6px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n.row-number {\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  text-align: center;\n  width: 30px;\n  font-size: 15px;\n}\n\n.transaction-type-cell, .supply-source-cell, .supply-destination-cell {\n  max-width: 120px;\n  font-size: 15px;\n  color: var(--ion-color-dark);\n  line-height: 1.2;\n}\n\n.actions-cell {\n  min-width: 120px; /* Ensure minimum space for buttons */\n  text-align: center;\n}\n\n.status-cell {\n  ion-badge {\n    font-size: 12px;\n    font-weight: 600;\n    padding: 4px 10px;\n    border-radius: 6px;\n    text-transform: capitalize;\n  }\n}\n\n// Empty State (matching child-detail)\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 300px;\n  }\n}\n\n// Filter Styles\n.filter-item {\n  --background: rgba(73, 144, 226, 0.02);\n  --border-radius: 8px;\n  margin-bottom: 12px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n\n  ion-label {\n    font-size: 12px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    margin-bottom: 4px;\n  }\n}\n\n.filter-btn {\n  --border-radius: 12px;\n  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n  height: 44px;\n  font-size: 14px;\n  font-weight: 600;\n  text-transform: none;\n  margin-top: 8px;\n\n  ion-icon {\n    font-size: 18px;\n  }\n}\n\nion-searchbar {\n  margin-bottom: 12px;\n  --border-radius: 12px;\n}\n\n// Mobile and Tablet Responsive Design (matching child-detail)\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .action-buttons-group {\n    width: 100%;\n    justify-content: stretch;\n\n    .action-btn {\n      flex: 1 1 auto;\n      height: 42px;\n      font-size: 13px;\n      min-width: 100px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.75rem;\n    min-width: 100%; // Changed from 700px to fit viewport\n\n    th, td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n  }\n\n  .status-cell ion-badge {\n    font-size: 11px;\n    padding: 3px 8px;\n  }\n\n  .filter-item {\n    margin-bottom: 8px;\n\n    ion-label {\n      font-size: 11px;\n    }\n  }\n\n  .filter-btn {\n    height: 40px;\n    font-size: 13px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .action-buttons-group {\n    flex-direction: column;\n    gap: 8px;\n\n    .action-btn {\n      width: 100%;\n      min-width: auto;\n      height: 40px;\n      font-size: 13px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.7rem;\n    min-width: 100%; // Changed from 650px to fit viewport\n\n    th, td {\n      padding: 6px 3px;\n      font-size: 0.7rem;\n    }\n  }\n\n  .status-cell ion-badge {\n    font-size: 10px;\n    padding: 2px 6px;\n  }\n\n  .filter-item {\n    margin-bottom: 6px;\n\n    ion-label {\n      font-size: 10px;\n    }\n  }\n\n  .filter-btn {\n    height: 38px;\n    font-size: 12px;\n  }\n}\n\n// Warning Card Styles\n.warning-card {\n  margin-bottom: 16px;\n\n  .warning-content {\n    display: flex;\n    align-items: center;\n    gap: 16px;\n\n    ion-icon {\n      flex-shrink: 0;\n      color: var(--ion-color-warning-contrast);\n    }\n\n    h3 {\n      margin: 0 0 4px 0;\n      font-size: 16px;\n      font-weight: 600;\n      color: var(--ion-color-warning-contrast);\n    }\n\n    p {\n      margin: 0;\n      font-size: 14px;\n      color: var(--ion-color-warning-contrast);\n      opacity: 0.9;\n    }\n  }\n}\n\n// Pagination Styles\n.items-per-page {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 14px;\n\n  ion-label {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n    white-space: nowrap;\n  }\n\n  ion-select {\n    min-width: 80px;\n    --padding-start: 8px;\n    --padding-end: 8px;\n  }\n}\n\n.pagination-container {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-wrap: wrap;\n  gap: 4px;\n  padding: 16px 8px;\n  margin-top: 16px;\n  border-top: 1px solid var(--ion-color-light);\n\n  ion-button {\n    --border-radius: 8px;\n    min-width: 40px;\n    height: 36px;\n    margin: 0;\n\n    &[disabled] {\n      opacity: 0.4;\n    }\n  }\n\n  .pagination-dots {\n    padding: 0 8px;\n    color: var(--ion-color-medium);\n    font-weight: 600;\n  }\n\n  .pagination-info {\n    width: 100%;\n    text-align: center;\n    margin-top: 8px;\n    font-size: 13px;\n    color: var(--ion-color-medium);\n    font-weight: 500;\n  }\n}\n\n@media (max-width: 768px) {\n  .items-per-page {\n    font-size: 12px;\n\n    ion-select {\n      min-width: 70px;\n    }\n  }\n\n  .pagination-container {\n    padding: 12px 4px;\n    gap: 2px;\n\n    ion-button {\n      min-width: 36px;\n      height: 32px;\n      font-size: 12px;\n    }\n\n    .pagination-dots {\n      padding: 0 4px;\n    }\n\n    .pagination-info {\n      font-size: 12px;\n      margin-top: 6px;\n    }\n  }\n}\n\n@media (max-width: 480px) {\n  .section-header {\n    flex-direction: column;\n    align-items: flex-start !important;\n    gap: 12px;\n  }\n\n  .items-per-page {\n    width: 100%;\n    justify-content: space-between;\n  }\n\n  .pagination-container {\n    padding: 10px 2px;\n\n    ion-button {\n      min-width: 32px;\n      height: 28px;\n      font-size: 11px;\n    }\n\n    .pagination-info {\n      font-size: 11px;\n    }\n  }\n}\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 27235:
/*!********************************************************************************!*\
  !*** ./src/app/pages/manage-supplylist/manage-supplylist.page.html?ngResource ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>{{title}}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"load($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n  <div *ngIf=\"manageRequestListItemList; else skeleton\" class=\"supply-container\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"icons.CUBE\" color=\"primary\"></ion-icon>\n        {{title}}\n      </h2>\n      <div class=\"action-buttons-group\">\n        <ion-chip color=\"primary\" *ngIf=\"pending >= 0\" class=\"pending-chip\">\n          <ion-icon [name]=\"icons.TIME\"></ion-icon>\n          <ion-label>{{pending}} Pending</ion-label>\n        </ion-chip>\n        <ion-button *ngIf=\"type === 'in'\" (click)=\"addDailyReturn()\" color=\"secondary\" class=\"action-btn\" [disabled]=\"!canCreateNewTransaction()\">\n          <ion-icon [name]=\"icons.ARROW_UNDO\" slot=\"start\"></ion-icon>\n          Daily Return\n        </ion-button>\n        <ion-button *ngIf=\"type === 'in'\" (click)=\"addSupplyToStore()\" color=\"primary\" class=\"action-btn\" [disabled]=\"!canCreateNewTransaction()\">\n          <ion-icon [name]=\"icons.ADD\" slot=\"start\"></ion-icon>\n          Add Stock\n        </ion-button>\n        <ion-button *ngIf=\"type === 'out' && !isRequisitionMode\" (click)=\"addSupplyOut()\" color=\"warning\" class=\"action-btn\" [disabled]=\"!canCreateNewTransaction()\">\n          <ion-icon [name]=\"icons.REMOVE_CIRCLE\" slot=\"start\"></ion-icon>\n          Supply Out\n        </ion-button>\n        <ion-button *ngIf=\"type === 'out' && isRequisitionMode\" (click)=\"addSupplyOut()\" color=\"primary\" class=\"action-btn\" [disabled]=\"!canCreateNewRequisition()\">\n          <ion-icon [name]=\"icons.DOCUMENT_TEXT\" slot=\"start\"></ion-icon>\n          Create Requisition\n        </ion-button>\n      </div>\n    </div>\n\n    <!-- Warning for unapproved transactions (requisition mode) -->\n    <ion-card *ngIf=\"isRequisitionMode && hasUnapprovedTransactions()\" color=\"warning\" class=\"warning-card\">\n      <ion-card-content>\n        <div class=\"warning-content\">\n          <ion-icon [name]=\"icons.WARNING\" size=\"large\"></ion-icon>\n          <div>\n            <h3>Pending Requisitions</h3>\n            <p>Store has unapproved requisitions. Please wait for approval before creating a new requisition.</p>\n          </div>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n    <!-- Warning for unapproved transactions (normal mode) -->\n    <ion-card *ngIf=\"!isRequisitionMode && !canCreateNewTransaction()\" color=\"warning\" class=\"warning-card\">\n      <ion-card-content>\n        <div class=\"warning-content\">\n          <ion-icon [name]=\"icons.WARNING\" size=\"large\"></ion-icon>\n          <div>\n            <h3>Pending Transactions</h3>\n            <p>Store has unapproved transactions. Please wait for approval before creating a new transaction.</p>\n          </div>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n    <!-- Search Section -->\n    <ion-searchbar mode=\"ios\" placeholder=\"Way Bill/Supply Source/Status\" [formControl]=\"searchControl\" (ionChange)=\"onSearchInput()\"></ion-searchbar>\n\n    <!-- Filter Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"filterForm\">\n            <ion-grid>\n              <ion-row>\n                <ion-col size=\"12\" size-md=\"4\">\n                  <ion-item lines=\"none\" class=\"filter-item\">\n                    <ion-label position=\"stacked\">Start Date</ion-label>\n                    <ion-input\n                      formControlName=\"start_date\"\n                      type=\"date\"\n                      lang=\"en-GB\"\n                      [placeholder]=\"getDatePlaceholder()\">\n                    </ion-input>\n                  </ion-item>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"4\">\n                  <ion-item lines=\"none\" class=\"filter-item\">\n                    <ion-label position=\"stacked\">End Date</ion-label>\n                    <ion-input\n                      formControlName=\"end_date\"\n                      type=\"date\"\n                      lang=\"en-GB\"\n                      [placeholder]=\"getDatePlaceholder()\">\n                    </ion-input>\n                  </ion-item>\n                </ion-col>\n                <ion-col size=\"12\" size-md=\"4\">\n                  <ion-item lines=\"none\" class=\"filter-item\">\n                    <ion-label position=\"stacked\">Transfer Type</ion-label>\n                    <ion-select *ngIf=\"!isRequisitionMode\" interface=\"action-sheet\" [formControl]=\"transactionDefControl\" placeholder=\"Select Type\">\n                      <ion-select-option *ngFor=\"let transactionType of transactionTypes\" [value]=\"transactionType.value\">{{transactionType.title}}</ion-select-option>\n                    </ion-select>\n                    <ion-input *ngIf=\"isRequisitionMode\" value=\"INF to DP\" readonly></ion-input>\n                  </ion-item>\n                </ion-col>\n              </ion-row>\n              <ion-row>\n                <ion-col size=\"12\">\n                  <ion-button expand=\"block\" (click)=\"applyFilter()\" color=\"primary\" class=\"filter-btn\">\n                    <ion-icon [name]=\"icons.FILTER\" slot=\"start\"></ion-icon>\n                    Apply Filter\n                  </ion-button>\n                </ion-col>\n              </ion-row>\n            </ion-grid>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Table Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n            Supply Records ({{filteredList?.length || 0}})\n          </h2>\n          <div class=\"items-per-page\">\n            <ion-label>Items per page:</ion-label>\n            <ion-select [(ngModel)]=\"itemsPerPage\" (ionChange)=\"updatePagination()\" interface=\"popover\">\n              <ion-select-option [value]=\"10\">10</ion-select-option>\n              <ion-select-option [value]=\"25\">25</ion-select-option>\n              <ion-select-option [value]=\"50\">50</ion-select-option>\n              <ion-select-option [value]=\"100\">100</ion-select-option>\n            </ion-select>\n          </div>\n        </div>\n        <ion-card-content *ngIf=\"paginatedList?.length > 0; else emptyState\">\n          <div class=\"table-container\">\n            <table class=\"measurements-table\">\n              <thead>\n                <tr>\n                  <th>#</th>\n                  <th>Way Bill</th>\n                  <th>Entry Date</th>\n                  <th>Transfer Type</th>\n                  <th *ngIf=\"type === 'in'\">Supply Source</th>\n                  <th *ngIf=\"type === 'out'\">Supply Destination</th>\n                  <th>Created At</th>\n                  <th>Status</th>\n                  <th class=\"actions-cell\">Actions</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr *ngFor=\"let supplyItem of paginatedList; let i = index\" class=\"supply-row\">\n                  <td class=\"row-number\">{{ (currentPage - 1) * itemsPerPage + i + 1 }}</td>\n                  <td>{{ supplyItem.waybill || '-' }}</td>\n                  <td>{{ getFormattedTransactionDate(supplyItem.transaction_date) }}</td>\n                  <td class=\"transaction-type-cell\">{{ supplyItem.transfer_type }}</td>\n                  <td *ngIf=\"type === 'in'\" class=\"supply-source-cell\">{{ supplyItem.supply_source || '-' }}</td>\n                  <td *ngIf=\"type === 'out'\" class=\"supply-destination-cell\">{{ supplyItem.supply_destination || '-' }}</td>\n                  <td>{{ getFormattedCreatedDate(supplyItem.created_at) }}</td>\n                  <td class=\"status-cell\">\n                    <ion-badge [color]=\"getStatusColor(supplyItem.status)\">\n                      {{ supplyItem.status || 'Unknown' }}\n                    </ion-badge>\n                  </td>\n                  <td class=\"actions-cell\">\n                    <ion-button fill=\"clear\" size=\"small\" (click)=\"viewTransactionDetail(supplyItem)\" color=\"primary\">\n                      <ion-icon [name]=\"icons.EYE\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canDeleteTransaction(supplyItem)\" fill=\"clear\" size=\"small\" (click)=\"delete(supplyItem.id)\" color=\"danger\">\n                      <ion-icon [name]=\"icons.DELETE\"></ion-icon>\n                    </ion-button>\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n\n          <!-- Pagination Controls -->\n          <div class=\"pagination-container\" *ngIf=\"totalPages > 1\">\n            <ion-button fill=\"clear\" size=\"small\" (click)=\"previousPage()\" [disabled]=\"currentPage === 1\">\n              <ion-icon [name]=\"icons.CHEVRON_BACK\"></ion-icon>\n            </ion-button>\n\n            <ion-button *ngIf=\"currentPage > 2\" fill=\"clear\" size=\"small\" (click)=\"goToPage(1)\">\n              1\n            </ion-button>\n\n            <span *ngIf=\"currentPage > 3\" class=\"pagination-dots\">...</span>\n\n            <ion-button *ngFor=\"let page of getPageNumbers()\"\n                        [fill]=\"page === currentPage ? 'solid' : 'clear'\"\n                        [color]=\"page === currentPage ? 'primary' : 'medium'\"\n                        size=\"small\"\n                        (click)=\"goToPage(page)\">\n              {{ page }}\n            </ion-button>\n\n            <span *ngIf=\"currentPage < totalPages - 2\" class=\"pagination-dots\">...</span>\n\n            <ion-button *ngIf=\"currentPage < totalPages - 1\" fill=\"clear\" size=\"small\" (click)=\"goToPage(totalPages)\">\n              {{ totalPages }}\n            </ion-button>\n\n            <ion-button fill=\"clear\" size=\"small\" (click)=\"nextPage()\" [disabled]=\"currentPage === totalPages\">\n              <ion-icon [name]=\"icons.CHEVRON_FORWARD\"></ion-icon>\n            </ion-button>\n\n            <div class=\"pagination-info\">\n              <span>Page {{ currentPage }} of {{ totalPages }}</span>\n            </div>\n          </div>\n        </ion-card-content>\n\n        <!-- Empty State -->\n        <ng-template #emptyState>\n          <ion-card-content>\n            <div class=\"empty-state\">\n              <ion-icon [name]=\"icons.CUBE\" color=\"medium\"></ion-icon>\n              <h3>No Supply Requests</h3>\n              <p>No supply request records found.</p>\n            </div>\n          </ion-card-content>\n        </ng-template>\n      </ion-card>\n    </div>\n  </div>\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_manage-supplylist_manage-supplylist_module_ts.js.map