(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_inpatient-care-treatment-list_inpatient-care-treatment-list_module_ts"],{

/***/ 96183:
/*!*****************************************************************************************************!*\
  !*** ./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list-routing.module.ts ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InpatientCareTreatmentListPageRoutingModule: () => (/* binding */ InpatientCareTreatmentListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _inpatient_care_treatment_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./inpatient-care-treatment-list.page */ 31769);




const routes = [{
  path: '',
  component: _inpatient_care_treatment_list_page__WEBPACK_IMPORTED_MODULE_0__.InpatientCareTreatmentListPage
}];
let InpatientCareTreatmentListPageRoutingModule = class InpatientCareTreatmentListPageRoutingModule {};
InpatientCareTreatmentListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], InpatientCareTreatmentListPageRoutingModule);


/***/ }),

/***/ 72966:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list.module.ts ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InpatientCareTreatmentListPageModule: () => (/* binding */ InpatientCareTreatmentListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _inpatient_care_treatment_list_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./inpatient-care-treatment-list-routing.module */ 96183);
/* harmony import */ var _inpatient_care_treatment_list_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./inpatient-care-treatment-list.page */ 31769);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let InpatientCareTreatmentListPageModule = class InpatientCareTreatmentListPageModule {};
InpatientCareTreatmentListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule, _inpatient_care_treatment_list_routing_module__WEBPACK_IMPORTED_MODULE_0__.InpatientCareTreatmentListPageRoutingModule],
  declarations: [_inpatient_care_treatment_list_page__WEBPACK_IMPORTED_MODULE_1__.InpatientCareTreatmentListPage]
})], InpatientCareTreatmentListPageModule);


/***/ }),

/***/ 31769:
/*!*******************************************************************************************!*\
  !*** ./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list.page.ts ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InpatientCareTreatmentListPage: () => (/* binding */ InpatientCareTreatmentListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _inpatient_care_treatment_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./inpatient-care-treatment-list.page.html?ngResource */ 41675);
/* harmony import */ var _inpatient_care_treatment_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./inpatient-care-treatment-list.page.scss?ngResource */ 19039);
/* harmony import */ var _inpatient_care_treatment_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_inpatient_care_treatment_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_inpatient_care_treatment_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/inpatient_care_treatment_api.service */ 62446);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _InpatientCareTreatmentListPage;








let InpatientCareTreatmentListPage = (_InpatientCareTreatmentListPage = class InpatientCareTreatmentListPage {
  constructor(b, router, api) {
    var _currentUser$user;
    this.b = b;
    this.router = router;
    this.api = api;
    this.treatments = [];
    this.filteredTreatments = [];
    // Loading state
    this.isLoading = false;
    // Filters
    this.filterStatus = '';
    this.filterFromInf = '';
    this.infList = [];
    // Pagination
    this.currentPage = 1;
    this.perPage = 20;
    this.totalRecords = 0;
    // User role check
    this.isSCManager = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__.ICONS;
    const currentUser = this.b.getCurrentUser();
    this.isSCManager = (currentUser === null || currentUser === void 0 || (_currentUser$user = currentUser.user) === null || _currentUser$user === void 0 ? void 0 : _currentUser$user.user_type) === 'SC Manager';
  }
  ngOnInit() {
    this.loadInfList();
    this.loadData();
  }
  /**
   * Load INF list for filter from backend
   */
  loadInfList() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this.api.getFromInfList();
        if (response && response.success && response.data) {
          _this.infList = response.data;
        }
      } catch (error) {}
    })();
  }
  /**
   * Load inpatient care treatments
   */
  loadData(event) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this2.isLoading = true;
        const params = {
          page: _this2.currentPage,
          per_page: _this2.perPage
        };
        // Add filters to params
        if (_this2.filterStatus) {
          params.status = _this2.filterStatus;
        }
        if (_this2.filterFromInf) {
          params.from_inf_id = _this2.filterFromInf;
        }
        const response = yield _this2.api.getTreatments(params);
        if (response.data) {
          // Handle paginated response structure
          if (response.data.data) {
            _this2.treatments = response.data.data;
            _this2.totalRecords = response.data.total || 0;
          } else {
            // Handle non-paginated response
            _this2.treatments = Array.isArray(response.data) ? response.data : [response.data];
            _this2.totalRecords = _this2.treatments.length;
          }
          _this2.filteredTreatments = _this2.treatments;
        }
        if (event) {
          event.target.complete();
        }
      } catch (error) {
        _this2.b.errorToast('Failed to load inpatient care treatments');
      } finally {
        _this2.isLoading = false;
      }
    })();
  }
  /**
   * Navigate to create new treatment
   */
  createNewTreatment() {
    this.router.navigate(['/inpatient-care-treatment']);
  }
  /**
   * View treatment details
   */
  viewTreatment(treatment) {
    this.router.navigate(['/inpatient-care-treatment-view', treatment.id]);
  }
  /**
   * Edit treatment
   */
  editTreatment(treatment) {
    this.router.navigate(['/inpatient-care-treatment', treatment.id], {
      state: {
        edit_mode: true,
        action_inf_id: treatment.action_inf_id
      }
    });
  }
  /**
   * Delete treatment
   */
  deleteTreatment(treatment) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.b.loadAlert('Delete Treatment', 'Are you sure you want to delete this inpatient care treatment record?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        try {
          yield _this3.api.deleteTreatment(treatment.id);
          _this3.b.toast('Treatment deleted successfully');
          _this3.loadData();
        } catch (error) {
          _this3.b.errorToast('Failed to delete treatment');
        }
      }));
    })();
  }
  /**
   * Approve SC transfer request (SC Manager only)
   */
  approveSCTransfer(treatment) {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this4.isSCManager) {
        _this4.b.errorToast('Only SC Managers can approve transfer requests');
        return;
      }
      yield _this4.b.loadAlert('Approve Transfer', 'Are you sure you want to approve this SC transfer request and admit the child?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        try {
          const response = yield _this4.api.updateTransferStatus(treatment.id, 'approve');
          if (response && response.success) {
            _this4.b.toast('SC transfer approved and child admitted successfully');
            _this4.loadData();
          } else {
            _this4.b.errorToast(response.message || 'Failed to approve transfer');
          }
        } catch (error) {
          _this4.b.errorToast('Failed to approve transfer');
        }
      }));
    })();
  }
  /**
   * Reject SC transfer request (SC Manager only)
   */
  rejectSCTransfer(treatment) {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this5.isSCManager) {
        _this5.b.errorToast('Only SC Managers can reject transfer requests');
        return;
      }
      yield _this5.b.loadAlert('Reject Transfer', 'Are you sure you want to reject this SC transfer request?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        try {
          const response = yield _this5.api.updateTransferStatus(treatment.id, 'reject');
          if (response && response.success) {
            _this5.b.toast('SC transfer request rejected successfully');
            _this5.loadData();
          } else {
            _this5.b.errorToast(response.message || 'Failed to reject transfer');
          }
        } catch (error) {
          _this5.b.errorToast('Failed to reject transfer');
        }
      }));
    })();
  }
  /**
   * Check if treatment is pending and user is SC Manager
   */
  canApproveOrReject(treatment) {
    var _treatment$status;
    return this.isSCManager && ((_treatment$status = treatment.status) === null || _treatment$status === void 0 ? void 0 : _treatment$status.toLowerCase()) === 'pending';
  }
  /**
   * Format date for display
   */
  formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('en-GB', {
      day: '2-digit',
      month: 'short',
      year: 'numeric'
    });
  }
  /**
   * Get status color
   */
  getStatusColor(status) {
    switch (status === null || status === void 0 ? void 0 : status.toLowerCase()) {
      case 'admitted':
        return 'primary';
      case 'discharged':
        return 'success';
      case 'pending':
        return 'warning';
      case 'rejected':
        return 'danger';
      default:
        return 'medium';
    }
  }
  /**
   * Get sync status color
   */
  getSyncStatusColor(status) {
    switch (status) {
      case 'synced':
        return 'success';
      case 'pending':
        return 'warning';
      case 'failed':
        return 'danger';
      default:
        return 'medium';
    }
  }
  /**
   * Apply filters and reset to page 1
   */
  applyFilters() {
    this.currentPage = 1;
    this.loadData();
  }
  /**
   * Refresh data
   */
  refresh(event) {
    this.currentPage = 1;
    this.loadData(event);
  }
  /**
   * Load more data (infinite scroll)
   */
  loadMore(event) {
    if (this.filteredTreatments.length < this.totalRecords) {
      this.currentPage++;
      this.loadData(event);
    } else {
      event.target.complete();
    }
  }
  /**
   * Check if treatment can be edited/deleted (only if created today)
   */
  canEditOrDelete(treatment) {
    if (!treatment.created_at) return false;
    const createdDate = new Date(treatment.created_at);
    const today = new Date();
    // Compare only the date part (ignore time)
    return createdDate.getFullYear() === today.getFullYear() && createdDate.getMonth() === today.getMonth() && createdDate.getDate() === today.getDate();
  }
  /**
   * Track by function for ngFor performance
   */
  trackByTreatment(index, item) {
    return item.id || index;
  }
  /**
   * Get admission number from response
   */
  getAdmissionNumber(treatment) {
    var _treatment$sc_respons;
    return ((_treatment$sc_respons = treatment.sc_response) === null || _treatment$sc_respons === void 0 ? void 0 : _treatment$sc_respons.admission_number) || 'N/A';
  }
}, _InpatientCareTreatmentListPage.ctorParameters = () => [{
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.Router
}, {
  type: src_app_services_inpatient_care_treatment_api_service__WEBPACK_IMPORTED_MODULE_3__.InpatientCareTreatmentAPIService
}], _InpatientCareTreatmentListPage);
InpatientCareTreatmentListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-inpatient-care-treatment-list',
  template: _inpatient_care_treatment_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_inpatient_care_treatment_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], InpatientCareTreatmentListPage);


/***/ }),

/***/ 19039:
/*!********************************************************************************************************!*\
  !*** ./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list.page.scss?ngResource ***!
  \********************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.supply-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.action-buttons-group {
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
  flex: 0 1 auto;
}
.action-buttons-group .action-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  min-width: 120px;
  transition: all 0.3s ease;
}
.action-buttons-group .action-btn ion-icon {
  font-size: 18px;
  margin-inline-end: 6px !important;
}
.action-buttons-group .action-btn:hover {
  transform: translateY(-2px);
  --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);
}
.action-buttons-group .action-btn:active {
  transform: translateY(0);
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: auto;
  table-layout: auto;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 8px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: nowrap;
}
.measurements-table td {
  padding: 10px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

.row-number {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: center;
  width: 40px;
  font-size: 15px;
  white-space: nowrap;
}

.actions-cell {
  width: 180px;
  text-align: center;
  white-space: nowrap;
}
.actions-cell ion-button {
  margin: 0 2px;
  --padding-start: 6px;
  --padding-end: 6px;
}
.actions-cell ion-button ion-icon {
  font-size: 18px;
}

.transfer-reason {
  max-width: 300px;
  text-align: left;
  white-space: normal;
  word-wrap: break-word;
  padding: 10px 12px !important;
}

.status-cell ion-badge {
  font-size: 12px;
  font-weight: 600;
  padding: 4px 10px;
  border-radius: 6px;
  text-transform: capitalize;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0 0 16px 0;
  max-width: 300px;
}
.empty-state ion-button {
  --border-radius: 12px;
  height: 44px;
  font-size: 14px;
  font-weight: 600;
}
.empty-state ion-button ion-icon {
  font-size: 18px;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .action-buttons-group {
    width: 100%;
    justify-content: stretch;
  }
  .action-buttons-group .action-btn {
    flex: 1 1 auto;
    height: 42px;
    font-size: 13px;
    min-width: 100px;
  }
  .action-buttons-group .action-btn ion-icon {
    font-size: 16px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .measurements-table {
    font-size: 0.75rem;
    min-width: auto;
  }
  .measurements-table th, .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .actions-cell {
    width: 100px;
  }
  .actions-cell ion-button {
    --padding-start: 6px;
    --padding-end: 6px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 16px;
  }
  .status-cell ion-badge {
    font-size: 11px;
    padding: 3px 8px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .action-buttons-group {
    flex-direction: column;
    gap: 8px;
  }
  .action-buttons-group .action-btn {
    width: 100%;
    min-width: auto;
    height: 40px;
    font-size: 13px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .measurements-table {
    font-size: 0.7rem;
    min-width: auto;
  }
  .measurements-table th, .measurements-table td {
    padding: 6px 3px;
    font-size: 0.7rem;
  }
  .actions-cell {
    width: 90px;
  }
  .actions-cell ion-button {
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 14px;
  }
  .status-cell ion-badge {
    font-size: 10px;
    padding: 2px 6px;
  }
  .empty-state {
    padding: 40px 16px;
  }
  .empty-state ion-icon {
    font-size: 40px;
  }
  .empty-state h3 {
    font-size: 16px;
  }
  .empty-state p {
    font-size: 13px;
  }
  .empty-state ion-button {
    height: 40px;
    font-size: 13px;
  }
}
.no-data {
  color: var(--ion-color-medium);
  font-style: italic;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,gBAAA;EACA,cAAA;AADF;;AAIA;EACE,gBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAMA;EACE,aAAA;EACA,SAAA;EACA,eAAA;EACA,mBAAA;EACA,cAAA;AAHF;AAKE;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,gBAAA;EACA,yBAAA;AAHJ;AAKI;EACE,eAAA;EACA,iCAAA;AAHN;AAMI;EACE,2BAAA;EACA,4CAAA;AAJN;AAOI;EACE,wBAAA;AALN;;AAWA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AARF;;AAWA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AARF;AAUE;EACE,eAAA;EACA,cAAA;AARJ;;AAaA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AAVF;;AAcA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;EACA,kBAAA;AAXF;AAaE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;AAXJ;AAcE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAZJ;AAeE;EACE,yBAAA;AAbJ;AAeI;EACE,6CAAA;AAbN;AAiBE;EACE,mBAAA;AAfJ;;AAmBA;EACE,gBAAA;EACA,+BAAA;EACA,kBAAA;EACA,WAAA;EACA,eAAA;EACA,mBAAA;AAhBF;;AAmBA;EACE,YAAA;EACA,kBAAA;EACA,mBAAA;AAhBF;AAkBE;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AAhBJ;AAkBI;EACE,eAAA;AAhBN;;AAqBA;EACE,gBAAA;EACA,gBAAA;EACA,mBAAA;EACA,qBAAA;EACA,6BAAA;AAlBF;;AAsBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,0BAAA;AAnBJ;;AAwBA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AArBF;AAuBE;EACE,eAAA;EACA,mBAAA;AArBJ;AAwBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AAtBJ;AAyBE;EACE,eAAA;EACA,8BAAA;EACA,kBAAA;EACA,gBAAA;AAvBJ;AA0BE;EACE,qBAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;AAxBJ;AA0BI;EACE,eAAA;AAxBN;;AA8BA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EA3BF;EA8BA;IACE,mBAAA;EA5BF;EA+BA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EA7BF;EAgCA;IACE,eAAA;IACA,WAAA;EA9BF;EAgCE;IACE,eAAA;EA9BJ;EAkCA;IACE,WAAA;IACA,wBAAA;EAhCF;EAkCE;IACE,cAAA;IACA,YAAA;IACA,eAAA;IACA,gBAAA;EAhCJ;EAkCI;IACE,eAAA;EAhCN;EAqCA;IACE,cAAA;IACA,SAAA;EAnCF;EAqCE;IACE,eAAA;EAnCJ;EAqCI;IACE,eAAA;EAnCN;EAwCA;IACE,kBAAA;IACA,eAAA;EAtCF;EAwCE;IACE,gBAAA;IACA,kBAAA;EAtCJ;EA0CA;IACE,YAAA;EAxCF;EA0CE;IACE,oBAAA;IACA,kBAAA;EAxCJ;EA0CI;IACE,eAAA;EAxCN;EA6CA;IACE,eAAA;IACA,gBAAA;EA3CF;AACF;AA8CA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EA5CF;EA+CA;IACE,mBAAA;EA7CF;EAgDA;IACE,mBAAA;EA9CF;EAiDA;IACE,eAAA;EA/CF;EAiDE;IACE,eAAA;EA/CJ;EAmDA;IACE,sBAAA;IACA,QAAA;EAjDF;EAmDE;IACE,WAAA;IACA,eAAA;IACA,YAAA;IACA,eAAA;EAjDJ;EAqDA;IACE,cAAA;IACA,QAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAqDI;IACE,eAAA;EAnDN;EAwDA;IACE,iBAAA;IACA,eAAA;EAtDF;EAwDE;IACE,gBAAA;IACA,iBAAA;EAtDJ;EA0DA;IACE,WAAA;EAxDF;EA0DE;IACE,oBAAA;IACA,kBAAA;EAxDJ;EA0DI;IACE,eAAA;EAxDN;EA6DA;IACE,eAAA;IACA,gBAAA;EA3DF;EA8DA;IACE,kBAAA;EA5DF;EA8DE;IACE,eAAA;EA5DJ;EA+DE;IACE,eAAA;EA7DJ;EAgEE;IACE,eAAA;EA9DJ;EAiEE;IACE,YAAA;IACA,eAAA;EA/DJ;AACF;AAmEA;EACE,8BAAA;EACA,kBAAA;AAjEF","sourcesContent":["// Styles matching facility supervision design\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.supply-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.action-buttons-group {\n  display: flex;\n  gap: 10px;\n  flex-wrap: wrap;\n  align-items: center;\n  flex: 0 1 auto;\n\n  .action-btn {\n    --border-radius: 12px;\n    --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n    height: 44px;\n    font-size: 14px;\n    font-weight: 600;\n    text-transform: none;\n    min-width: 120px;\n    transition: all 0.3s ease;\n\n    ion-icon {\n      font-size: 18px;\n      margin-inline-end: 6px !important;\n    }\n\n    &:hover {\n      transform: translateY(-2px);\n      --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);\n    }\n\n    &:active {\n      transform: translateY(0);\n    }\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Table Container\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n// Measurements Table Styles\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: auto;\n  table-layout: auto;\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 8px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: nowrap;\n  }\n\n  td {\n    padding: 10px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n.row-number {\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  text-align: center;\n  width: 40px;\n  font-size: 15px;\n  white-space: nowrap;\n}\n\n.actions-cell {\n  width: 180px;\n  text-align: center;\n  white-space: nowrap;\n\n  ion-button {\n    margin: 0 2px;\n    --padding-start: 6px;\n    --padding-end: 6px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n.transfer-reason {\n  max-width: 300px;\n  text-align: left;\n  white-space: normal;\n  word-wrap: break-word;\n  padding: 10px 12px !important;\n}\n\n.status-cell {\n  ion-badge {\n    font-size: 12px;\n    font-weight: 600;\n    padding: 4px 10px;\n    border-radius: 6px;\n    text-transform: capitalize;\n  }\n}\n\n// Empty State\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0 0 16px 0;\n    max-width: 300px;\n  }\n\n  ion-button {\n    --border-radius: 12px;\n    height: 44px;\n    font-size: 14px;\n    font-weight: 600;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n// Mobile and Tablet Responsive Design\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .action-buttons-group {\n    width: 100%;\n    justify-content: stretch;\n\n    .action-btn {\n      flex: 1 1 auto;\n      height: 42px;\n      font-size: 13px;\n      min-width: 100px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.75rem;\n    min-width: auto;\n\n    th, td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n  }\n\n  .actions-cell {\n    width: 100px;\n\n    ion-button {\n      --padding-start: 6px;\n      --padding-end: 6px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .status-cell ion-badge {\n    font-size: 11px;\n    padding: 3px 8px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .action-buttons-group {\n    flex-direction: column;\n    gap: 8px;\n\n    .action-btn {\n      width: 100%;\n      min-width: auto;\n      height: 40px;\n      font-size: 13px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.7rem;\n    min-width: auto;\n\n    th, td {\n      padding: 6px 3px;\n      font-size: 0.7rem;\n    }\n  }\n\n  .actions-cell {\n    width: 90px;\n\n    ion-button {\n      --padding-start: 4px;\n      --padding-end: 4px;\n\n      ion-icon {\n        font-size: 14px;\n      }\n    }\n  }\n\n  .status-cell ion-badge {\n    font-size: 10px;\n    padding: 2px 6px;\n  }\n\n  .empty-state {\n    padding: 40px 16px;\n\n    ion-icon {\n      font-size: 40px;\n    }\n\n    h3 {\n      font-size: 16px;\n    }\n\n    p {\n      font-size: 13px;\n    }\n\n    ion-button {\n      height: 40px;\n      font-size: 13px;\n    }\n  }\n}\n\n.no-data {\n  color: var(--ion-color-medium);\n  font-style: italic;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 41675:
/*!********************************************************************************************************!*\
  !*** ./src/app/pages/inpatient-care-treatment-list/inpatient-care-treatment-list.page.html?ngResource ***!
  \********************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Inpatient Care Treatments</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"refresh($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n  <div *ngIf=\"!isLoading || filteredTreatments.length > 0; else skeleton\" class=\"supply-container\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"icons.MEDICAL\" color=\"primary\"></ion-icon>\n        Inpatient Care Treatments\n      </h2>\n    </div>\n\n    <!-- Filter Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <ion-grid>\n            <ion-row>\n              <ion-col size=\"12\" size-md=\"6\">\n                <ion-item lines=\"none\" class=\"filter-item\">\n                  <ion-label position=\"stacked\">Status</ion-label>\n                  <ion-select [(ngModel)]=\"filterStatus\" interface=\"action-sheet\" placeholder=\"All\">\n                    <ion-select-option value=\"\">All</ion-select-option>\n                    <ion-select-option value=\"pending\">Pending</ion-select-option>\n                    <ion-select-option value=\"admitted\">Admitted</ion-select-option>\n                    <ion-select-option value=\"discharged\">Discharged</ion-select-option>\n                    <ion-select-option value=\"rejected\">Rejected</ion-select-option>\n                  </ion-select>\n                </ion-item>\n              </ion-col>\n              <ion-col size=\"12\" size-md=\"6\">\n                <ion-item lines=\"none\" class=\"filter-item\">\n                  <ion-label position=\"stacked\">From INF</ion-label>\n                  <ion-select [(ngModel)]=\"filterFromInf\" interface=\"action-sheet\" placeholder=\"All\">\n                    <ion-select-option value=\"\">All</ion-select-option>\n                    <ion-select-option *ngFor=\"let inf of infList\" [value]=\"inf.id\">\n                      {{ inf.title }}\n                    </ion-select-option>\n                  </ion-select>\n                </ion-item>\n              </ion-col>\n            </ion-row>\n            <ion-row>\n              <ion-col size=\"12\">\n                <ion-button expand=\"block\" (click)=\"applyFilters()\" color=\"primary\" class=\"filter-btn\">\n                  <ion-icon [name]=\"icons.FILTER\" slot=\"start\"></ion-icon>\n                  Apply Filter\n                </ion-button>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Table Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n            Treatment Records ({{filteredTreatments?.length || 0}})\n          </h2>\n        </div>\n        <ion-card-content *ngIf=\"filteredTreatments?.length > 0; else emptyState\">\n          <div class=\"table-container\">\n            <table class=\"measurements-table\">\n              <thead>\n                <tr>\n                  <th>#</th>\n                  <th>Patient Name</th>\n                  <th>From INF</th>\n                  <th>Status</th>\n                  <th>Transfer Reason</th>\n                  <th>Created At</th>\n                  <th>Actions</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr *ngFor=\"let treatment of filteredTreatments; trackBy: trackByTreatment; let i = index\" class=\"supply-row\">\n                  <td class=\"row-number\">{{ i + 1 }}</td>\n                  <td>{{ treatment.child.name }}</td>\n                  <td>{{ treatment.from_inf.title }}</td>\n                  <td>\n                    <ion-badge [color]=\"getStatusColor(treatment.status || 'pending')\">\n                      {{ treatment.status || 'pending' }}\n                    </ion-badge>\n                  </td>\n                  <td class=\"transfer-reason\">{{ treatment.transfer_reason || '-' }}</td>\n                  <td>{{ formatDate(treatment.created_at || '') }}</td>\n                  <td class=\"actions-cell\">\n                    <ion-button fill=\"clear\" size=\"small\" (click)=\"viewTreatment(treatment)\" color=\"primary\" title=\"View Details\">\n                      <ion-icon [name]=\"icons.EYE\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canApproveOrReject(treatment)\" fill=\"clear\" size=\"small\" (click)=\"approveSCTransfer(treatment)\" color=\"success\" title=\"Approve Transfer\">\n                      <ion-icon [name]=\"icons.CHECKMARK_CIRCLE\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canApproveOrReject(treatment)\" fill=\"clear\" size=\"small\" (click)=\"rejectSCTransfer(treatment)\" color=\"danger\" title=\"Reject Transfer\">\n                      <ion-icon [name]=\"icons.CLOSE_CIRCLE\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canEditOrDelete(treatment)\" fill=\"clear\" size=\"small\" (click)=\"editTreatment(treatment)\" color=\"secondary\" title=\"Edit\">\n                      <ion-icon [name]=\"icons.EDIT\"></ion-icon>\n                    </ion-button>\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n        </ion-card-content>\n\n        <!-- Empty State -->\n        <ng-template #emptyState>\n          <ion-card-content>\n            <div class=\"empty-state\">\n              <ion-icon [name]=\"icons.MEDICAL\" color=\"medium\"></ion-icon>\n              <h3>No Inpatient Care Treatments</h3>\n              <p>No inpatient care treatment records found.</p>\n            </div>\n          </ion-card-content>\n        </ng-template>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_inpatient-care-treatment-list_inpatient-care-treatment-list_module_ts.js.map