(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_facility-supervision_facility-supervision_module_ts"],{

/***/ 49047:
/*!***********************************************************************************!*\
  !*** ./src/app/pages/facility-supervision/facility-supervision-routing.module.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionPageRoutingModule: () => (/* binding */ FacilitySupervisionPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _facility_supervision_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./facility-supervision.page */ 30489);




const routes = [{
  path: '',
  component: _facility_supervision_page__WEBPACK_IMPORTED_MODULE_0__.FacilitySupervisionPage
}];
let FacilitySupervisionPageRoutingModule = class FacilitySupervisionPageRoutingModule {};
FacilitySupervisionPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], FacilitySupervisionPageRoutingModule);


/***/ }),

/***/ 44454:
/*!***************************************************************************!*\
  !*** ./src/app/pages/facility-supervision/facility-supervision.module.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionPageModule: () => (/* binding */ FacilitySupervisionPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _facility_supervision_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./facility-supervision-routing.module */ 49047);
/* harmony import */ var _facility_supervision_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./facility-supervision.page */ 30489);
/* harmony import */ var _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../survey-form/survey-form.module */ 87550);








// Import custom formly components from survey-form module

let FacilitySupervisionPageModule = class FacilitySupervisionPageModule {};
FacilitySupervisionPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _facility_supervision_routing_module__WEBPACK_IMPORTED_MODULE_0__.FacilitySupervisionPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_8__.FormlyModule.forRoot({
    types: [{
      name: 'input',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicInput
    }, {
      name: 'radio',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicRadio
    }, {
      name: 'template',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldTemplate
    }, {
      name: 'textarea',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicTextarea
    }, {
      name: 'checkbox',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicCheckbox
    }, {
      name: 'multicheckbox',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicMulticheckbox
    }, {
      name: 'select',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicSelect
    }, {
      name: 'repeat',
      component: _survey_form_survey_form_module__WEBPACK_IMPORTED_MODULE_2__.FormlyFieldIonicRepeat
    }]
  })],
  declarations: [_facility_supervision_page__WEBPACK_IMPORTED_MODULE_1__.FacilitySupervisionPage]
})], FacilitySupervisionPageModule);


/***/ }),

/***/ 30489:
/*!*************************************************************************!*\
  !*** ./src/app/pages/facility-supervision/facility-supervision.page.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionPage: () => (/* binding */ FacilitySupervisionPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _facility_supervision_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./facility-supervision.page.html?ngResource */ 76395);
/* harmony import */ var _facility_supervision_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./facility-supervision.page.scss?ngResource */ 3331);
/* harmony import */ var _facility_supervision_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_facility_supervision_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_survey_form_validation_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/survey-form-validation.service */ 92091);
/* harmony import */ var src_app_services_facility_supervision_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/facility_supervision_api.service */ 73556);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _FacilitySupervisionPage;











let FacilitySupervisionPage = (_FacilitySupervisionPage = class FacilitySupervisionPage {
  constructor(b, location, router, activatedRoute, validationService, api) {
    this.b = b;
    this.location = location;
    this.router = router;
    this.activatedRoute = activatedRoute;
    this.validationService = validationService;
    this.api = api;
    this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormGroup({});
    this.model = {};
    this.fields = [];
    this.schema = []; // Form schema from backend
    this.title = 'Facility Supervision Form';
    this.formDescription = '';
    this.showValidationErrors = false;
    this.edit_mode = false;
    // Step-based navigation
    this.currentSectionIndex = 0;
    this.sectionLoaded = false;
    this.savedSections = new Set(); // Track which sections have been saved
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_6__.ICONS;
  }
  ngOnInit() {
    this.initializeFromNavigation();
    this.id = this.activatedRoute.snapshot.paramMap.get('id');
    this.load();
  }
  /**
   * Initialize component state from navigation parameters
   */
  initializeFromNavigation() {
    var _nav$extras, _nav$extras2;
    const nav = this.router.getCurrentNavigation();
    this.inf_id = (nav === null || nav === void 0 || (_nav$extras = nav.extras) === null || _nav$extras === void 0 || (_nav$extras = _nav$extras.state) === null || _nav$extras === void 0 ? void 0 : _nav$extras['inf_id']) || null;
    this.edit_mode = (nav === null || nav === void 0 || (_nav$extras2 = nav.extras) === null || _nav$extras2 === void 0 || (_nav$extras2 = _nav$extras2.state) === null || _nav$extras2 === void 0 ? void 0 : _nav$extras2['edit_mode']) || false;
  }
  /**
   * Load form schema and initialize model
   */
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this.edit_mode && _this.id) {
          yield _this.loadEditModeData();
        } else {
          yield _this.loadFormSchemaAndPrefill();
        }
        // Process form schema
        _this.processFormSchema();
      } catch (error) {
        _this.b.errorToast('Failed to load form');
      }
    })();
  }
  /**
   * Load form schema and prefill data from backend
   * Gets schema from SurveyForm with type='facility-supervision'
   * Gets prefill data based on authenticated user's default INF
   */
  loadFormSchemaAndPrefill() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this2.api.getFormSchemaAndPrefill();
        if (response.data) {
          var _response$data$prefil;
          // Load schema from backend
          _this2.schema = response.data.schema || [];
          _this2.title = response.data.title || 'Facility Supervision';
          _this2.formDescription = response.data.description || '';
          // Store inf_id for submission
          _this2.inf_id = (_response$data$prefil = response.data.prefillData) === null || _response$data$prefil === void 0 ? void 0 : _response$data$prefil.inf_id;
          // Merge prefill data into model
          _this2.model = {
            ...response.data.prefillData,
            ..._this2.model
          };
        }
      } catch (error) {
        yield _this2.b.errorToast('Failed to load facility supervision form');
        _this2.model = {
          date_of_visit: new Date().toISOString().split('T')[0]
        };
      }
    })();
  }
  /**
   * Load existing supervision data for edit mode
   */
  loadEditModeData() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // First load the schema
        const schemaResponse = yield _this3.api.getFormSchemaAndPrefill();
        if (schemaResponse.data) {
          _this3.schema = schemaResponse.data.schema || [];
          _this3.title = schemaResponse.data.title || 'Facility Supervision';
          _this3.formDescription = schemaResponse.data.description || '';
        }
        // Then load the existing supervision data
        const response = yield _this3.api.getSupervision(_this3.id);
        if (response.data) {
          _this3.model = response.data.response || {};
          _this3.inf_id = response.data.inf_id;
          // Note: savedSections tracking is session-based only
          // Will be populated as user saves sections during this session
        }
      } catch (error) {
        _this3.b.errorToast('Failed to load supervision data');
      }
    })();
  }
  /**
   * Process form schema
   */
  processFormSchema() {
    // Deep clone the schema from backend
    this.fields = JSON.parse(JSON.stringify(this.schema));
    // Process fields to handle expression properties and calculations
    this.fields = this.processFieldsRecursively(this.fields);
    // Reset to first section and load it
    this.currentSectionIndex = 0;
    this.loadCurrentSection();
  }
  /**
   * Recursively process fields to handle expressionProperties
   */
  processFieldsRecursively(fields) {
    return fields.map(field => {
      // Convert expressionProperties from IIFE strings to functions
      if (field.expressionProperties) {
        const expressions = {};
        Object.keys(field.expressionProperties).forEach(key => {
          const expression = field.expressionProperties[key];
          if (typeof expression === 'string') {
            // Remove IIFE wrapper: "(() => { ... })()" -> "{ ... }"
            let cleanExpr = expression.trim();
            if (cleanExpr.startsWith('(() => {') && cleanExpr.endsWith('})()')) {
              cleanExpr = cleanExpr.slice(8, -4); // Remove "(() => {" and "})()"
            } else if (cleanExpr.startsWith('(function() {') && cleanExpr.endsWith('})()')) {
              cleanExpr = cleanExpr.slice(13, -4);
            }
            // Create function that receives field and returns the evaluated expression
            // Formly expressions receive (field, formState, model) as parameters
            expressions[key] = field => {
              try {
                var _field$options;
                const model = field.model;
                const formState = (_field$options = field.options) === null || _field$options === void 0 ? void 0 : _field$options.formState;
                // Use Function constructor to evaluate the expression with model in scope
                const func = new Function('model', 'formState', 'field', cleanExpr);
                return func(model, formState, field);
              } catch (e) {
                return null;
              }
            };
          } else {
            expressions[key] = expression;
          }
        });
        field.expressions = expressions;
        delete field.expressionProperties;
      }
      // Add dynamic color class for score fields
      if (field.key && typeof field.key === 'string' && field.key.includes('_score')) {
        if (!field.expressions) {
          field.expressions = {};
        }
        // Add expression to set className based on score percentage
        field.expressions['className'] = field => {
          var _field$formControl;
          const value = (_field$formControl = field.formControl) === null || _field$formControl === void 0 ? void 0 : _field$formControl.value;
          const colorClass = this.getScoreColorClass(value);
          return `score-field ${colorClass}`;
        };
      }
      // Recursively process nested fields
      if (field.fieldGroup) {
        field.fieldGroup = this.processFieldsRecursively(field.fieldGroup);
      }
      return field;
    });
  }
  /**
   * Extract percentage from score string and return appropriate color class
   */
  getScoreColorClass(scoreString) {
    if (!scoreString || typeof scoreString !== 'string') return 'score-default';
    // Extract percentage from format like "45/51 (88.2% - Good)"
    const match = scoreString.match(/\((\d+\.?\d*)%/);
    if (!match) return 'score-default';
    const percentage = parseFloat(match[1]);
    // Apply color based on percentage ranges
    if (percentage >= 90) return 'score-success'; // Green - Exceed Expectation
    if (percentage >= 70) return 'score-primary'; // Blue - Meet Expectation
    if (percentage >= 50) return 'score-warning'; // Orange - Near Expectation
    return 'score-danger'; // Red - Below Expectation
  }
  /**
   * Go to next section
   */
  nextSection() {
    if (this.currentSectionIndex < this.fields.length - 1) {
      this.sectionLoaded = false;
      this.currentSectionIndex++;
      this.loadCurrentSection();
      this.scrollToTop();
    }
  }
  /**
   * Go to previous section
   */
  previousSection() {
    if (this.currentSectionIndex > 0) {
      this.sectionLoaded = false;
      this.currentSectionIndex--;
      this.loadCurrentSection();
      this.scrollToTop();
    }
  }
  /**
   * Go to specific section
   */
  goToSection(index) {
    if (index >= 0 && index < this.fields.length) {
      this.sectionLoaded = false;
      this.currentSectionIndex = index;
      this.loadCurrentSection();
      this.scrollToTop();
    }
  }
  /**
   * Load current section with small delay for smooth UI
   */
  loadCurrentSection() {
    setTimeout(() => {
      this.sectionLoaded = true;
    }, 100);
  }
  /**
   * Get section label from field
   */
  getSectionLabel(field) {
    var _field$props, _field$key;
    const fieldData = field.data;
    return (fieldData === null || fieldData === void 0 ? void 0 : fieldData.sectionName) || ((_field$props = field.props) === null || _field$props === void 0 ? void 0 : _field$props.label) || ((_field$key = field.key) === null || _field$key === void 0 ? void 0 : _field$key.toString()) || `Section ${this.fields.indexOf(field) + 1}`;
  }
  /**
   * Check if on first section
   */
  isFirstSection() {
    return this.currentSectionIndex === 0;
  }
  /**
   * Check if on last section
   */
  isLastSection() {
    return this.currentSectionIndex === this.fields.length - 1;
  }
  /**
   * Scroll to top of content
   */
  scrollToTop() {
    const content = document.querySelector('ion-content');
    if (content) {
      content.scrollToTop(300);
    }
  }
  /**
   * Submit form
   */
  submit() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Validate form
      const isFormValid = _this4.form.valid;
      if (isFormValid) {
        _this4.showValidationErrors = false;
        // Show summary of scores in console for debugging
        _this4.logScoreSummary();
        // Save to backend
        yield _this4.submitFormData();
      } else {
        _this4.showValidationErrors = true;
        _this4.validationService.markAllFieldsAsTouched(_this4.form);
        // Navigate to section with first error and scroll to the field
        const invalidFields = _this4.getInvalidFieldsWithKeys();
        if (invalidFields.length > 0) {
          const firstInvalidKey = invalidFields[0].key;
          const errorSectionIndex = _this4.findSectionContainingField(firstInvalidKey);
          if (errorSectionIndex !== -1 && errorSectionIndex !== _this4.currentSectionIndex) {
            // Navigate to the section first, then scroll to field
            _this4.goToSection(errorSectionIndex);
            setTimeout(() => {
              _this4.scrollToField(firstInvalidKey);
            }, 200);
          } else {
            // Already on the correct section, just scroll to field
            _this4.scrollToField(firstInvalidKey);
          }
        }
        _this4.b.errorToast('Please fill in all required fields');
      }
    })();
  }
  /**
   * Find the index of the section containing a specific field key
   */
  findSectionContainingField(fieldKey) {
    for (let i = 0; i < this.fields.length; i++) {
      if (this.fieldContainsKey(this.fields[i], fieldKey)) {
        return i;
      }
    }
    return -1;
  }
  /**
   * Check if a field or its children contain the given key
   */
  fieldContainsKey(field, key) {
    if (field.key === key) return true;
    if (field.fieldGroup) {
      return field.fieldGroup.some(child => this.fieldContainsKey(child, key));
    }
    return false;
  }
  /**
   * Submit form data to backend
   */
  submitFormData() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const body = {
        response: _this5.model
      };
      if (_this5.edit_mode && _this5.id) {
        // Update existing supervision
        const result = yield _this5.api.updateSupervision(_this5.id, body);
        yield _this5.b.responseToast(result);
        if (result.success) {
          _this5.navigateBack();
        }
      } else {
        // Create new supervision
        const result = yield _this5.api.storeSupervision(body);
        yield _this5.b.responseToast(result);
        if (result.success) {
          _this5.navigateBack();
        }
      }
    })();
  }
  /**
   * Save current section separately
   */
  saveSection() {
    var _this6 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Get the current section's fields
      const currentSection = _this6.fields[_this6.currentSectionIndex];
      const sectionLabel = _this6.getSectionLabel(currentSection);
      // Validate current section fields
      const sectionValid = _this6.validateSection(currentSection);
      if (!sectionValid) {
        _this6.showValidationErrors = true;
        _this6.validationService.markAllFieldsAsTouched(_this6.form);
        _this6.b.errorToast(`Please fill in all required fields in ${sectionLabel}`);
        return;
      }
      // Hide validation errors if section is valid
      _this6.showValidationErrors = false;
      // Prepare data for saving
      const body = {
        response: _this6.model,
        section_index: _this6.currentSectionIndex,
        section_label: sectionLabel
      };
      try {
        if (_this6.edit_mode && _this6.id) {
          // Update existing supervision
          const result = yield _this6.api.updateSupervision(_this6.id, body);
          yield _this6.b.responseToast(result);
          if (result.success) {
            _this6.savedSections.add(_this6.currentSectionIndex);
            _this6.b.toast(`${sectionLabel} saved successfully`);
            // Navigate to facility supervision list
            _this6.router.navigate(['/facility-supervision-list']);
          }
        } else {
          // Create or update supervision
          const result = yield _this6.api.storeSupervision(body);
          yield _this6.b.responseToast(result);
          if (result.success) {
            var _result$data;
            // If this is the first save and we got an ID back, switch to edit mode
            if (!_this6.id && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.id) {
              _this6.id = result.data.id;
              _this6.edit_mode = true;
            }
            _this6.savedSections.add(_this6.currentSectionIndex);
            _this6.b.toast(`${sectionLabel} saved successfully`);
            // Navigate to facility supervision list
            _this6.router.navigate(['/facility-supervision-list']);
          }
        }
      } catch (error) {
        _this6.b.errorToast(`Failed to save ${sectionLabel}`);
      }
    })();
  }
  /**
   * Validate a specific section
   */
  validateSection(section) {
    // Get all form controls for this section
    const sectionFields = this.getFieldsFromSection(section);
    // Check if all required fields in this section are valid
    for (const field of sectionFields) {
      const control = this.form.get(field.key);
      if (control && control.invalid) {
        return false;
      }
    }
    return true;
  }
  /**
   * Get all fields from a section recursively
   */
  getFieldsFromSection(section) {
    const fields = [];
    if (section.key) {
      fields.push(section);
    }
    if (section.fieldGroup) {
      for (const field of section.fieldGroup) {
        fields.push(...this.getFieldsFromSection(field));
      }
    }
    return fields;
  }
  /**
   * Log score summary to console
   */
  logScoreSummary() {}
  /**
   * Navigate back
   */
  navigateBack() {
    this.location.back();
  }
  /**
   * Scroll to validation card
   */
  scrollToValidationCard() {
    setTimeout(() => {
      const validationCard = document.querySelector('.validation-card');
      if (validationCard) {
        validationCard.scrollIntoView({
          behavior: 'smooth',
          block: 'center'
        });
      }
    }, 100);
  }
  /**
   * Get invalid fields with keys (for template)
   */
  getInvalidFieldsWithKeys() {
    return this.validationService.getInvalidFieldsWithKeys(this.form, this.fields, this.model);
  }
  /**
   * Track by function for ngFor
   */
  trackByField(_index, item) {
    return item.key;
  }
  /**
   * Scroll to specific field
   */
  scrollToField(fieldKey) {
    const selectors = [`[data-field-key="${fieldKey}"]`, `[formcontrolname="${fieldKey}"]`, `[ng-reflect-name="${fieldKey}"]`, `formly-field[data-key="${fieldKey}"]`, `#${fieldKey}`, `.field-${fieldKey}`];
    let fieldElement = null;
    for (const selector of selectors) {
      fieldElement = document.querySelector(selector);
      if (fieldElement) break;
    }
    if (!fieldElement) {
      var _field$props2;
      const field = this.fields.find(f => f.key === fieldKey);
      if (field !== null && field !== void 0 && (_field$props2 = field.props) !== null && _field$props2 !== void 0 && _field$props2.label) {
        const labels = document.querySelectorAll('ion-label, label');
        for (let i = 0; i < labels.length; i++) {
          var _label$textContent;
          const label = labels[i];
          if ((_label$textContent = label.textContent) !== null && _label$textContent !== void 0 && _label$textContent.includes(field.props.label)) {
            fieldElement = label.closest('ion-item, formly-field, .form-field') || label;
            break;
          }
        }
      }
    }
    if (fieldElement) {
      fieldElement.scrollIntoView({
        behavior: 'smooth',
        block: 'center'
      });
      const input = fieldElement.querySelector('input, select, textarea, ion-input, ion-select, ion-textarea');
      if (input && typeof input.setFocus === 'function') {
        setTimeout(() => input.setFocus(), 300);
      }
    } else {}
  }
  /**
   * Refresh data
   */
  refresh(event) {
    this.load();
    if (event) {
      setTimeout(() => {
        event.target.complete();
      }, 1000);
    }
  }
  /**
   * Reset form
   */
  reset() {
    this.b.loadAlert('Reset Form', 'Are you sure you want to reset the form? All entered data will be lost.', () => {
      this.load();
      this.b.toast('Form reset successfully');
    });
  }
}, _FacilitySupervisionPage.ctorParameters = () => [{
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_5__.BaseHelper
}, {
  type: _angular_common__WEBPACK_IMPORTED_MODULE_8__.Location
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.Router
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute
}, {
  type: src_app_services_survey_form_validation_service__WEBPACK_IMPORTED_MODULE_3__.SurveyFormValidationService
}, {
  type: src_app_services_facility_supervision_api_service__WEBPACK_IMPORTED_MODULE_4__.FacilitySupervisionAPIService
}], _FacilitySupervisionPage);
FacilitySupervisionPage = (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-facility-supervision',
  template: _facility_supervision_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_facility_supervision_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], FacilitySupervisionPage);


/***/ }),

/***/ 3331:
/*!**************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision/facility-supervision.page.scss?ngResource ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.form-container {
  max-width: 900px;
  margin: 0 auto;
  padding-bottom: 20px;
}

.step-progress {
  margin-bottom: 20px;
  padding: 16px;
  background: var(--ion-color-light);
  border-radius: 8px;
}
.step-progress .step-info {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 12px;
}
.step-progress .step-info .step-counter {
  font-size: 12px;
  color: var(--ion-color-medium);
  font-weight: 500;
}
.step-progress .step-info .step-title {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  text-align: right;
  flex: 1;
  margin-left: 12px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}
.step-progress .progress-bar {
  height: 4px;
  background: var(--ion-color-medium-tint);
  border-radius: 2px;
  overflow: hidden;
  margin-bottom: 12px;
}
.step-progress .progress-bar .progress-fill {
  height: 100%;
  background: var(--ion-color-primary);
  border-radius: 2px;
  transition: width 0.3s ease;
}
.step-progress .step-boxes {
  display: flex;
  justify-content: center;
  gap: 12px;
  flex-wrap: wrap;
  margin-top: 8px;
}
.step-progress .step-boxes .step-box {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  min-width: 100px;
  padding: 10px 14px;
  border-radius: 6px;
  border: 2px solid var(--ion-color-medium);
  background: var(--ion-color-light);
  cursor: pointer;
  transition: all 0.3s ease;
  position: relative;
}
.step-progress .step-boxes .step-box .saved-icon {
  position: absolute;
  top: 4px;
  right: 4px;
  font-size: 16px;
  color: var(--ion-color-success);
}
.step-progress .step-boxes .step-box .warning-icon {
  position: absolute;
  top: 4px;
  right: 4px;
  font-size: 16px;
  color: var(--ion-color-warning);
}
.step-progress .step-boxes .step-box .section-name {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-align: center;
  line-height: 1.3;
  max-width: 120px;
  overflow: hidden;
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
}
.step-progress .step-boxes .step-box.active {
  border-color: var(--ion-color-primary);
  background: var(--ion-color-primary);
  transform: scale(1.05);
  box-shadow: 0 4px 8px rgba(var(--ion-color-primary-rgb), 0.3);
}
.step-progress .step-boxes .step-box.active .section-name {
  color: var(--ion-color-primary-contrast);
}
.step-progress .step-boxes .step-box.active .saved-icon {
  color: var(--ion-color-primary-contrast);
}
.step-progress .step-boxes .step-box.active .warning-icon {
  color: var(--ion-color-primary-contrast);
}
.step-progress .step-boxes .step-box.saved {
  border-color: var(--ion-color-success);
  background: rgba(var(--ion-color-success-rgb), 0.1);
}
.step-progress .step-boxes .step-box.saved .section-name {
  color: var(--ion-color-success-shade);
}
.step-progress .step-boxes .step-box.skipped {
  border-color: var(--ion-color-warning);
  background: rgba(var(--ion-color-warning-rgb), 0.1);
}
.step-progress .step-boxes .step-box.skipped .section-name {
  color: var(--ion-color-warning-shade);
}
.step-progress .step-boxes .step-box.not-reached {
  border-color: var(--ion-color-medium);
  background: var(--ion-color-light);
}
.step-progress .step-boxes .step-box.not-reached .section-name {
  color: var(--ion-color-medium);
}
.step-progress .step-boxes .step-box:hover {
  transform: scale(1.08);
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
}

.section-card {
  margin-bottom: 12px;
  border-radius: 8px;
  overflow: hidden;
}
.section-card .section-content {
  padding: 16px;
}
.section-card .section-loading {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 12px;
  padding: 40px;
  color: var(--ion-color-medium);
}
.section-card .section-loading ion-spinner {
  --color: var(--ion-color-primary);
}

.step-navigation {
  display: flex;
  justify-content: space-between;
  align-items: center;
  gap: 12px;
  margin-top: 20px;
  margin-bottom: 12px;
  flex-wrap: wrap;
}
.step-navigation ion-button {
  flex: 1;
  min-width: 120px;
  max-width: 180px;
}
.step-navigation ion-button:first-child {
  margin-right: auto;
}
.step-navigation ion-button:last-child {
  margin-left: auto;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 40px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
}
.loading-container p {
  color: var(--ion-color-medium);
  margin: 0;
}

.validation-card {
  margin: 20px 0;
  border-left: 4px solid var(--ion-color-danger);
}
.validation-card ion-card-header {
  background: rgba(var(--ion-color-danger-rgb), 0.05);
}
.validation-card ion-card-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
}
.validation-card ion-list {
  margin: 16px 0;
  border-radius: 8px;
  overflow: hidden;
}
.validation-card ion-item {
  --border-radius: 0;
  --padding-start: 12px;
  --padding-end: 12px;
  cursor: pointer;
  transition: all 0.2s ease;
}
.validation-card ion-item:hover {
  --background: rgba(var(--ion-color-danger-rgb), 0.08);
}
.validation-card small {
  display: flex;
  align-items: center;
  gap: 6px;
  color: var(--ion-color-medium);
  margin-top: 12px;
}
.validation-card small ion-icon {
  font-size: 14px;
}

:host ::ng-deep .template-content h3 {
  color: var(--ion-color-primary);
  margin-top: 24px;
  margin-bottom: 16px;
  padding-bottom: 8px;
  border-bottom: 2px solid var(--ion-color-primary);
  font-size: 18px;
  font-weight: 600;
}
:host ::ng-deep .template-content h4 {
  color: var(--ion-color-dark);
  margin-top: 20px;
  margin-bottom: 12px;
  font-size: 16px;
  font-weight: 600;
}
:host ::ng-deep .template-content hr {
  margin: 24px 0;
  border: none;
  border-top: 1px solid var(--ion-color-light);
}
:host ::ng-deep .template-content p {
  margin: 8px 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}
:host ::ng-deep .template-content p strong {
  color: var(--ion-color-dark);
}
:host ::ng-deep formly-field[data-key\$=_score] .custom-ion-item {
  --background: rgba(73, 144, 226, 0.08);
  --border-color: rgba(73, 144, 226, 0.4);
  --border-width: 2px;
}
:host ::ng-deep formly-field[data-key\$=_score] .custom-ion-item .custom-label {
  color: var(--ion-color-primary) !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field[data-key\$=_score] .custom-ion-item .custom-input {
  --color: var(--ion-color-primary-shade);
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly {
  --background: rgba(146, 148, 156, 0.08) !important;
  --border-color: rgba(146, 148, 156, 0.3) !important;
  --border-width: 1px !important;
  margin-bottom: 20px;
}
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly ion-label,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly .custom-label,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly label,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly ion-item ion-label {
  --color: #5a5c69 !important;
  color: #5a5c69 !important;
  font-weight: 600 !important;
}
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly ion-input,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly ion-textarea,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly ion-select,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly .custom-input,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly input,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly textarea,
:host ::ng-deep formly-field:not([data-key\$=_score]) .custom-ion-item.readonly select {
  --color: var(--ion-color-dark) !important;
  color: var(--ion-color-dark) !important;
  font-weight: 600;
  font-size: 15px;
}
:host ::ng-deep formly-field:not([data-key\$=_score]) ion-item.custom-ion-item.readonly ion-label {
  --color: #5a5c69 !important;
  color: #5a5c69 !important;
}
:host ::ng-deep formly-field.score-success .custom-ion-item,
:host ::ng-deep formly-field.score-success .custom-ion-item.readonly {
  --background: rgba(9, 170, 78, 0.1) !important;
  --border-color: #09AA4E !important;
  --border-width: 2px;
}
:host ::ng-deep formly-field.score-success .custom-ion-item .custom-label,
:host ::ng-deep formly-field.score-success .custom-ion-item.readonly .custom-label {
  color: #09AA4E !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field.score-success .custom-ion-item .custom-input,
:host ::ng-deep formly-field.score-success .custom-ion-item.readonly .custom-input {
  --color: #09AA4E !important;
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field.score-primary .custom-ion-item,
:host ::ng-deep formly-field.score-primary .custom-ion-item.readonly {
  --background: rgba(14, 165, 233, 0.1) !important;
  --border-color: #0EA5E9 !important;
  --border-width: 2px;
}
:host ::ng-deep formly-field.score-primary .custom-ion-item .custom-label,
:host ::ng-deep formly-field.score-primary .custom-ion-item.readonly .custom-label {
  color: #0EA5E9 !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field.score-primary .custom-ion-item .custom-input,
:host ::ng-deep formly-field.score-primary .custom-ion-item.readonly .custom-input {
  --color: #0EA5E9 !important;
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field.score-warning .custom-ion-item,
:host ::ng-deep formly-field.score-warning .custom-ion-item.readonly {
  --background: rgba(255, 165, 0, 0.1) !important;
  --border-color: #FFA500 !important;
  --border-width: 2px;
}
:host ::ng-deep formly-field.score-warning .custom-ion-item .custom-label,
:host ::ng-deep formly-field.score-warning .custom-ion-item.readonly .custom-label {
  color: #FFA500 !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field.score-warning .custom-ion-item .custom-input,
:host ::ng-deep formly-field.score-warning .custom-ion-item.readonly .custom-input {
  --color: #FFA500 !important;
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field.score-danger .custom-ion-item,
:host ::ng-deep formly-field.score-danger .custom-ion-item.readonly {
  --background: rgba(191, 10, 11, 0.1) !important;
  --border-color: #BF0A0B !important;
  --border-width: 2px;
}
:host ::ng-deep formly-field.score-danger .custom-ion-item .custom-label,
:host ::ng-deep formly-field.score-danger .custom-ion-item.readonly .custom-label {
  color: #BF0A0B !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field.score-danger .custom-ion-item .custom-input,
:host ::ng-deep formly-field.score-danger .custom-ion-item.readonly .custom-input {
  --color: #BF0A0B !important;
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field.score-default .custom-ion-item,
:host ::ng-deep formly-field.score-default .custom-ion-item.readonly {
  --background: rgba(146, 148, 156, 0.08) !important;
  --border-color: var(--ion-color-medium) !important;
  --border-width: 2px;
}
:host ::ng-deep formly-field.score-default .custom-ion-item .custom-label,
:host ::ng-deep formly-field.score-default .custom-ion-item.readonly .custom-label {
  color: var(--ion-color-medium) !important;
  font-weight: 700 !important;
  font-size: 15px !important;
}
:host ::ng-deep formly-field.score-default .custom-ion-item .custom-input,
:host ::ng-deep formly-field.score-default .custom-ion-item.readonly .custom-input {
  --color: var(--ion-color-medium) !important;
  font-weight: 700;
  font-size: 16px;
}
:host ::ng-deep formly-field[data-key=overall_total_score] .custom-ion-item {
  --background: linear-gradient(135deg, rgba(73, 144, 226, 0.15) 0%, rgba(45, 211, 111, 0.15) 100%);
  --border-color: var(--ion-color-primary);
  --border-width: 3px;
  padding: 8px 0;
}
:host ::ng-deep formly-field[data-key=overall_total_score] .custom-ion-item .custom-label {
  color: var(--ion-color-primary) !important;
  font-weight: 800 !important;
  font-size: 17px !important;
}
:host ::ng-deep formly-field[data-key=overall_total_score] .custom-ion-item .custom-input {
  --color: var(--ion-color-primary);
  font-weight: 800;
  font-size: 18px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/facility-supervision/facility-supervision.page.scss"],"names":[],"mappings":"AAAA;EACE,gBAAA;EACA,cAAA;EACA,oBAAA;AACF;;AAGA;EACE,mBAAA;EACA,aAAA;EACA,kCAAA;EACA,kBAAA;AAAF;AAEE;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;AAAJ;AAEI;EACE,eAAA;EACA,8BAAA;EACA,gBAAA;AAAN;AAGI;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,iBAAA;EACA,OAAA;EACA,iBAAA;EACA,mBAAA;EACA,gBAAA;EACA,uBAAA;AADN;AAKE;EACE,WAAA;EACA,wCAAA;EACA,kBAAA;EACA,gBAAA;EACA,mBAAA;AAHJ;AAKI;EACE,YAAA;EACA,oCAAA;EACA,kBAAA;EACA,2BAAA;AAHN;AAOE;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,eAAA;EACA,eAAA;AALJ;AAOI;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,gBAAA;EACA,kBAAA;EACA,kBAAA;EACA,yCAAA;EACA,kCAAA;EACA,eAAA;EACA,yBAAA;EACA,kBAAA;AALN;AAOM;EACE,kBAAA;EACA,QAAA;EACA,UAAA;EACA,eAAA;EACA,+BAAA;AALR;AAQM;EACE,kBAAA;EACA,QAAA;EACA,UAAA;EACA,eAAA;EACA,+BAAA;AANR;AASM;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,kBAAA;EACA,gBAAA;EACA,gBAAA;EACA,gBAAA;EACA,uBAAA;EACA,oBAAA;EACA,qBAAA;EACA,4BAAA;AAPR;AAUM;EACE,sCAAA;EACA,oCAAA;EACA,sBAAA;EACA,6DAAA;AARR;AAUQ;EACE,wCAAA;AARV;AAWQ;EACE,wCAAA;AATV;AAYQ;EACE,wCAAA;AAVV;AAcM;EACE,sCAAA;EACA,mDAAA;AAZR;AAcQ;EACE,qCAAA;AAZV;AAgBM;EACE,sCAAA;EACA,mDAAA;AAdR;AAgBQ;EACE,qCAAA;AAdV;AAkBM;EACE,qCAAA;EACA,kCAAA;AAhBR;AAkBQ;EACE,8BAAA;AAhBV;AAoBM;EACE,sBAAA;EACA,yCAAA;AAlBR;;AAyBA;EACE,mBAAA;EACA,kBAAA;EACA,gBAAA;AAtBF;AAwBE;EACE,aAAA;AAtBJ;AAyBE;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,SAAA;EACA,aAAA;EACA,8BAAA;AAvBJ;AAyBI;EACE,iCAAA;AAvBN;;AA6BA;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,SAAA;EACA,gBAAA;EACA,mBAAA;EACA,eAAA;AA1BF;AA4BE;EACE,OAAA;EACA,gBAAA;EACA,gBAAA;AA1BJ;AA4BI;EACE,kBAAA;AA1BN;AA6BI;EACE,iBAAA;AA3BN;;AAgCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA7BF;AA+BE;EACE,mBAAA;AA7BJ;AAgCE;EACE,8BAAA;EACA,SAAA;AA9BJ;;AAkCA;EACE,cAAA;EACA,8CAAA;AA/BF;AAiCE;EACE,mDAAA;AA/BJ;AAkCE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;AAhCJ;AAmCE;EACE,cAAA;EACA,kBAAA;EACA,gBAAA;AAjCJ;AAoCE;EACE,kBAAA;EACA,qBAAA;EACA,mBAAA;EACA,eAAA;EACA,yBAAA;AAlCJ;AAoCI;EACE,qDAAA;AAlCN;AAsCE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,8BAAA;EACA,gBAAA;AApCJ;AAsCI;EACE,eAAA;AApCN;;AA4CE;EACE,+BAAA;EACA,gBAAA;EACA,mBAAA;EACA,mBAAA;EACA,iDAAA;EACA,eAAA;EACA,gBAAA;AAzCJ;AA4CE;EACE,4BAAA;EACA,gBAAA;EACA,mBAAA;EACA,eAAA;EACA,gBAAA;AA1CJ;AA6CE;EACE,cAAA;EACA,YAAA;EACA,4CAAA;AA3CJ;AA8CE;EACE,aAAA;EACA,8BAAA;EACA,eAAA;AA5CJ;AA8CI;EACE,4BAAA;AA5CN;AAkDI;EACE,sCAAA;EACA,uCAAA;EACA,mBAAA;AAhDN;AAkDM;EACE,0CAAA;EACA,2BAAA;EACA,0BAAA;AAhDR;AAmDM;EACE,uCAAA;EACA,gBAAA;EACA,eAAA;AAjDR;AAyDI;EACE,kDAAA;EACA,mDAAA;EACA,8BAAA;EACA,mBAAA;AAvDN;AAyDM;;;;EAIE,2BAAA;EACA,yBAAA;EACA,2BAAA;AAvDR;AA0DM;;;;;;;EAOE,yCAAA;EACA,uCAAA;EACA,gBAAA;EACA,eAAA;AAxDR;AA+DI;EACE,2BAAA;EACA,yBAAA;AA7DN;AAsEI;;EAEE,8CAAA;EACA,kCAAA;EACA,mBAAA;AApEN;AAsEM;;EACE,yBAAA;EACA,2BAAA;EACA,0BAAA;AAnER;AAsEM;;EACE,2BAAA;EACA,gBAAA;EACA,eAAA;AAnER;AA0EI;;EAEE,gDAAA;EACA,kCAAA;EACA,mBAAA;AAxEN;AA0EM;;EACE,yBAAA;EACA,2BAAA;EACA,0BAAA;AAvER;AA0EM;;EACE,2BAAA;EACA,gBAAA;EACA,eAAA;AAvER;AA8EI;;EAEE,+CAAA;EACA,kCAAA;EACA,mBAAA;AA5EN;AA8EM;;EACE,yBAAA;EACA,2BAAA;EACA,0BAAA;AA3ER;AA8EM;;EACE,2BAAA;EACA,gBAAA;EACA,eAAA;AA3ER;AAkFI;;EAEE,+CAAA;EACA,kCAAA;EACA,mBAAA;AAhFN;AAkFM;;EACE,yBAAA;EACA,2BAAA;EACA,0BAAA;AA/ER;AAkFM;;EACE,2BAAA;EACA,gBAAA;EACA,eAAA;AA/ER;AAsFI;;EAEE,kDAAA;EACA,kDAAA;EACA,mBAAA;AApFN;AAsFM;;EACE,yCAAA;EACA,2BAAA;EACA,0BAAA;AAnFR;AAsFM;;EACE,2CAAA;EACA,gBAAA;EACA,eAAA;AAnFR;AA0FI;EACE,iGAAA;EACA,wCAAA;EACA,mBAAA;EACA,cAAA;AAxFN;AA0FM;EACE,0CAAA;EACA,2BAAA;EACA,0BAAA;AAxFR;AA2FM;EACE,iCAAA;EACA,gBAAA;EACA,eAAA;AAzFR","sourcesContent":[".form-container {\n  max-width: 900px;\n  margin: 0 auto;\n  padding-bottom: 20px;\n}\n\n// Step progress indicator\n.step-progress {\n  margin-bottom: 20px;\n  padding: 16px;\n  background: var(--ion-color-light);\n  border-radius: 8px;\n\n  .step-info {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 12px;\n\n    .step-counter {\n      font-size: 12px;\n      color: var(--ion-color-medium);\n      font-weight: 500;\n    }\n\n    .step-title {\n      font-size: 14px;\n      font-weight: 600;\n      color: var(--ion-color-dark);\n      text-align: right;\n      flex: 1;\n      margin-left: 12px;\n      white-space: nowrap;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n  }\n\n  .progress-bar {\n    height: 4px;\n    background: var(--ion-color-medium-tint);\n    border-radius: 2px;\n    overflow: hidden;\n    margin-bottom: 12px;\n\n    .progress-fill {\n      height: 100%;\n      background: var(--ion-color-primary);\n      border-radius: 2px;\n      transition: width 0.3s ease;\n    }\n  }\n\n  .step-boxes {\n    display: flex;\n    justify-content: center;\n    gap: 12px;\n    flex-wrap: wrap;\n    margin-top: 8px;\n\n    .step-box {\n      display: flex;\n      flex-direction: column;\n      align-items: center;\n      justify-content: center;\n      min-width: 100px;\n      padding: 10px 14px;\n      border-radius: 6px;\n      border: 2px solid var(--ion-color-medium);\n      background: var(--ion-color-light);\n      cursor: pointer;\n      transition: all 0.3s ease;\n      position: relative;\n\n      .saved-icon {\n        position: absolute;\n        top: 4px;\n        right: 4px;\n        font-size: 16px;\n        color: var(--ion-color-success);\n      }\n\n      .warning-icon {\n        position: absolute;\n        top: 4px;\n        right: 4px;\n        font-size: 16px;\n        color: var(--ion-color-warning);\n      }\n\n      .section-name {\n        font-size: 11px;\n        font-weight: 600;\n        color: var(--ion-color-medium);\n        text-align: center;\n        line-height: 1.3;\n        max-width: 120px;\n        overflow: hidden;\n        text-overflow: ellipsis;\n        display: -webkit-box;\n        -webkit-line-clamp: 2;\n        -webkit-box-orient: vertical;\n      }\n\n      &.active {\n        border-color: var(--ion-color-primary);\n        background: var(--ion-color-primary);\n        transform: scale(1.05);\n        box-shadow: 0 4px 8px rgba(var(--ion-color-primary-rgb), 0.3);\n\n        .section-name {\n          color: var(--ion-color-primary-contrast);\n        }\n\n        .saved-icon {\n          color: var(--ion-color-primary-contrast);\n        }\n\n        .warning-icon {\n          color: var(--ion-color-primary-contrast);\n        }\n      }\n\n      &.saved {\n        border-color: var(--ion-color-success);\n        background: rgba(var(--ion-color-success-rgb), 0.1);\n\n        .section-name {\n          color: var(--ion-color-success-shade);\n        }\n      }\n\n      &.skipped {\n        border-color: var(--ion-color-warning);\n        background: rgba(var(--ion-color-warning-rgb), 0.1);\n\n        .section-name {\n          color: var(--ion-color-warning-shade);\n        }\n      }\n\n      &.not-reached {\n        border-color: var(--ion-color-medium);\n        background: var(--ion-color-light);\n\n        .section-name {\n          color: var(--ion-color-medium);\n        }\n      }\n\n      &:hover {\n        transform: scale(1.08);\n        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);\n      }\n    }\n  }\n}\n\n// Section card styling\n.section-card {\n  margin-bottom: 12px;\n  border-radius: 8px;\n  overflow: hidden;\n\n  .section-content {\n    padding: 16px;\n  }\n\n  .section-loading {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    gap: 12px;\n    padding: 40px;\n    color: var(--ion-color-medium);\n\n    ion-spinner {\n      --color: var(--ion-color-primary);\n    }\n  }\n}\n\n// Step navigation buttons\n.step-navigation {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  gap: 12px;\n  margin-top: 20px;\n  margin-bottom: 12px;\n  flex-wrap: wrap;\n\n  ion-button {\n    flex: 1;\n    min-width: 120px;\n    max-width: 180px;\n\n    &:first-child {\n      margin-right: auto;\n    }\n\n    &:last-child {\n      margin-left: auto;\n    }\n  }\n}\n\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 40px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n  }\n\n  p {\n    color: var(--ion-color-medium);\n    margin: 0;\n  }\n}\n\n.validation-card {\n  margin: 20px 0;\n  border-left: 4px solid var(--ion-color-danger);\n\n  ion-card-header {\n    background: rgba(var(--ion-color-danger-rgb), 0.05);\n  }\n\n  ion-card-title {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n  }\n\n  ion-list {\n    margin: 16px 0;\n    border-radius: 8px;\n    overflow: hidden;\n  }\n\n  ion-item {\n    --border-radius: 0;\n    --padding-start: 12px;\n    --padding-end: 12px;\n    cursor: pointer;\n    transition: all 0.2s ease;\n\n    &:hover {\n      --background: rgba(var(--ion-color-danger-rgb), 0.08);\n    }\n  }\n\n  small {\n    display: flex;\n    align-items: center;\n    gap: 6px;\n    color: var(--ion-color-medium);\n    margin-top: 12px;\n\n    ion-icon {\n      font-size: 14px;\n    }\n  }\n}\n\n// Formly field styling enhancements for facility supervision form\n:host ::ng-deep {\n  // Section headers\n  .template-content h3 {\n    color: var(--ion-color-primary);\n    margin-top: 24px;\n    margin-bottom: 16px;\n    padding-bottom: 8px;\n    border-bottom: 2px solid var(--ion-color-primary);\n    font-size: 18px;\n    font-weight: 600;\n  }\n\n  .template-content h4 {\n    color: var(--ion-color-dark);\n    margin-top: 20px;\n    margin-bottom: 12px;\n    font-size: 16px;\n    font-weight: 600;\n  }\n\n  .template-content hr {\n    margin: 24px 0;\n    border: none;\n    border-top: 1px solid var(--ion-color-light);\n  }\n\n  .template-content p {\n    margin: 8px 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n\n    strong {\n      color: var(--ion-color-dark);\n    }\n  }\n\n  // Score display fields - Default styling (must come before readonly to allow override)\n  formly-field[data-key$=\"_score\"] {\n    .custom-ion-item {\n      --background: rgba(73, 144, 226, 0.08);\n      --border-color: rgba(73, 144, 226, 0.4);\n      --border-width: 2px;\n\n      .custom-label {\n        color: var(--ion-color-primary) !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: var(--ion-color-primary-shade);\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Calculated/readonly fields styling (non-score fields)\n  // This must come AFTER score field default styling to properly override\n  formly-field:not([data-key$=\"_score\"]) {\n    .custom-ion-item.readonly {\n      --background: rgba(146, 148, 156, 0.08) !important;\n      --border-color: rgba(146, 148, 156, 0.3) !important;\n      --border-width: 1px !important;\n      margin-bottom: 20px;\n\n      ion-label,\n      .custom-label,\n      label,\n      ion-item ion-label {\n        --color: #5a5c69 !important;\n        color: #5a5c69 !important;\n        font-weight: 600 !important;\n      }\n\n      ion-input,\n      ion-textarea,\n      ion-select,\n      .custom-input,\n      input,\n      textarea,\n      select {\n        --color: var(--ion-color-dark) !important;\n        color: var(--ion-color-dark) !important;\n        font-weight: 600;\n        font-size: 15px;\n      }\n    }\n  }\n\n  // Extra specificity for readonly ion-items (non-score fields)\n  formly-field:not([data-key$=\"_score\"]) ion-item.custom-ion-item.readonly {\n    ion-label {\n      --color: #5a5c69 !important;\n      color: #5a5c69 !important;\n    }\n  }\n\n  // Dynamic score colors based on percentage\n  // These have higher specificity to override readonly styling\n\n  // Green - Exceed Expectation (≥90%)\n  formly-field.score-success {\n    .custom-ion-item,\n    .custom-ion-item.readonly {\n      --background: rgba(9, 170, 78, 0.1) !important;\n      --border-color: #09AA4E !important;\n      --border-width: 2px;\n\n      .custom-label {\n        color: #09AA4E !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: #09AA4E !important;\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Blue - Meet Expectation (≥70%)\n  formly-field.score-primary {\n    .custom-ion-item,\n    .custom-ion-item.readonly {\n      --background: rgba(14, 165, 233, 0.1) !important;\n      --border-color: #0EA5E9 !important;\n      --border-width: 2px;\n\n      .custom-label {\n        color: #0EA5E9 !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: #0EA5E9 !important;\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Orange - Near Expectation (≥50%)\n  formly-field.score-warning {\n    .custom-ion-item,\n    .custom-ion-item.readonly {\n      --background: rgba(255, 165, 0, 0.1) !important;\n      --border-color: #FFA500 !important;\n      --border-width: 2px;\n\n      .custom-label {\n        color: #FFA500 !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: #FFA500 !important;\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Red - Below Expectation (<50%)\n  formly-field.score-danger {\n    .custom-ion-item,\n    .custom-ion-item.readonly {\n      --background: rgba(191, 10, 11, 0.1) !important;\n      --border-color: #BF0A0B !important;\n      --border-width: 2px;\n\n      .custom-label {\n        color: #BF0A0B !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: #BF0A0B !important;\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Default for score fields without percentage\n  formly-field.score-default {\n    .custom-ion-item,\n    .custom-ion-item.readonly {\n      --background: rgba(146, 148, 156, 0.08) !important;\n      --border-color: var(--ion-color-medium) !important;\n      --border-width: 2px;\n\n      .custom-label {\n        color: var(--ion-color-medium) !important;\n        font-weight: 700 !important;\n        font-size: 15px !important;\n      }\n\n      .custom-input {\n        --color: var(--ion-color-medium) !important;\n        font-weight: 700;\n        font-size: 16px;\n      }\n    }\n  }\n\n  // Overall score field\n  formly-field[data-key=\"overall_total_score\"] {\n    .custom-ion-item {\n      --background: linear-gradient(135deg, rgba(73, 144, 226, 0.15) 0%, rgba(45, 211, 111, 0.15) 100%);\n      --border-color: var(--ion-color-primary);\n      --border-width: 3px;\n      padding: 8px 0;\n\n      .custom-label {\n        color: var(--ion-color-primary) !important;\n        font-weight: 800 !important;\n        font-size: 17px !important;\n      }\n\n      .custom-input {\n        --color: var(--ion-color-primary);\n        font-weight: 800;\n        font-size: 18px;\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 76395:
/*!**************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision/facility-supervision.page.html?ngResource ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button defaultHref=\"/home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ title }}</ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button (click)=\"reset()\">\n        <ion-icon slot=\"icon-only\" [name]=\"icons.REFRESH\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <!-- Form Container -->\n  <ng-container *ngIf=\"fields.length > 0; else loading\">\n    <form [formGroup]=\"form\" (ngSubmit)=\"submit()\">\n      <div class=\"form-container\">\n        <!-- Step Progress Indicator -->\n        <div class=\"step-progress\" *ngIf=\"fields.length > 1\">\n          <div class=\"step-info\">\n            <span class=\"step-counter\">Section {{ currentSectionIndex + 1 }} of {{ fields.length }}</span>\n            <span class=\"step-title\">{{ getSectionLabel(fields[currentSectionIndex]) }}</span>\n          </div>\n          <div class=\"progress-bar\">\n            <div class=\"progress-fill\" [style.width.%]=\"((currentSectionIndex + 1) / fields.length) * 100\"></div>\n          </div>\n          <!-- Section Navigation Boxes -->\n          <div class=\"step-boxes\">\n            <button\n              *ngFor=\"let field of fields; let i = index\"\n              type=\"button\"\n              class=\"step-box\"\n              [class.active]=\"i === currentSectionIndex\"\n              [class.saved]=\"savedSections.has(i) && i !== currentSectionIndex\"\n              [class.skipped]=\"!savedSections.has(i) && i < currentSectionIndex\"\n              [class.not-reached]=\"!savedSections.has(i) && i > currentSectionIndex\"\n              (click)=\"goToSection(i)\"\n              [attr.aria-label]=\"'Go to section ' + (i + 1)\">\n              <ion-icon\n                *ngIf=\"savedSections.has(i) && i !== currentSectionIndex\"\n                [name]=\"icons.CHECKMARK_CIRCLE\"\n                class=\"saved-icon\">\n              </ion-icon>\n              <ion-icon\n                *ngIf=\"!savedSections.has(i) && i < currentSectionIndex\"\n                [name]=\"icons.ALERT_CIRCLE\"\n                class=\"warning-icon\">\n              </ion-icon>\n              <span class=\"section-name\">{{ getSectionLabel(field) }}</span>\n            </button>\n          </div>\n        </div>\n\n        <!-- Current Section Content -->\n        <ion-card class=\"section-card\">\n          <ion-card-content class=\"section-content\">\n            <!-- Loading State -->\n            <div *ngIf=\"!sectionLoaded\" class=\"section-loading\">\n              <ion-spinner name=\"crescent\"></ion-spinner>\n              <span>Loading section...</span>\n            </div>\n\n            <!-- Loaded Content -->\n            <ng-container *ngIf=\"sectionLoaded\">\n              <formly-form [form]=\"form\" [fields]=\"[fields[currentSectionIndex]]\" [model]=\"model\"></formly-form>\n            </ng-container>\n          </ion-card-content>\n        </ion-card>\n\n        <!-- Navigation Buttons -->\n        <div class=\"step-navigation\">\n          <ion-button\n            fill=\"outline\"\n            (click)=\"previousSection()\"\n            [disabled]=\"isFirstSection()\"\n            type=\"button\">\n            <ion-icon [name]=\"icons.CHEVRON_BACK\" slot=\"start\"></ion-icon>\n            Previous\n          </ion-button>\n\n          <ion-button\n            *ngIf=\"!isLastSection()\"\n            (click)=\"nextSection()\"\n            type=\"button\">\n            Next\n            <ion-icon [name]=\"icons.CHEVRON_FORWARD\" slot=\"end\"></ion-icon>\n          </ion-button>\n\n          <ion-button\n            (click)=\"saveSection()\"\n            type=\"button\"\n            color=\"success\">\n            <ion-icon [name]=\"icons.CHECKMARK_CIRCLE\" slot=\"start\"></ion-icon>\n            Complete Supervision\n          </ion-button>\n        </div>\n\n        <!-- Validation Status Card -->\n        <ion-card *ngIf=\"showValidationErrors && getInvalidFieldsWithKeys().length > 0\" class=\"validation-card\">\n          <ion-card-header>\n            <ion-card-title color=\"danger\">\n              <ion-icon [name]=\"icons.ALERT_CIRCLE\" slot=\"start\"></ion-icon>\n              Form Validation Errors\n            </ion-card-title>\n          </ion-card-header>\n          <ion-card-content>\n            <p><strong>Please fix the following fields:</strong></p>\n            <ion-list>\n              <ion-item\n                *ngFor=\"let fieldInfo of getInvalidFieldsWithKeys(); trackBy: trackByField\"\n                color=\"light\"\n                button\n                (click)=\"scrollToField(fieldInfo.key)\">\n                <ion-icon [name]=\"icons.CLOSE_CIRCLE\" color=\"danger\" slot=\"start\"></ion-icon>\n                <ion-label class=\"ion-text-wrap\">{{ fieldInfo.label }}</ion-label>\n                <ion-icon [name]=\"icons.CHEVRON_FORWARD\" slot=\"end\" color=\"medium\"></ion-icon>\n              </ion-item>\n            </ion-list>\n            <p><small><ion-icon [name]=\"icons.INFORMATION_CIRCLE\" color=\"medium\"></ion-icon> Tap on any field above to scroll to it</small></p>\n          </ion-card-content>\n        </ion-card>\n      </div>\n    </form>\n  </ng-container>\n\n  <ng-template #loading>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\"></ion-spinner>\n      <p>Loading form...</p>\n    </div>\n  </ng-template>\n\n  <!-- Pull to Refresh -->\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"refresh($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_facility-supervision_facility-supervision_module_ts.js.map