(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_child-list_child-list_module_ts"],{

/***/ 58795:
/*!***************************************************************!*\
  !*** ./src/app/pages/child-list/child-list-routing.module.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChildListPageRoutingModule: () => (/* binding */ ChildListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _child_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./child-list.page */ 53277);




const routes = [{
  path: '',
  component: _child_list_page__WEBPACK_IMPORTED_MODULE_0__.ChildListPage
}];
let ChildListPageRoutingModule = class ChildListPageRoutingModule {};
ChildListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], ChildListPageRoutingModule);


/***/ }),

/***/ 23978:
/*!*******************************************************!*\
  !*** ./src/app/pages/child-list/child-list.module.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChildListPageModule: () => (/* binding */ ChildListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/cdk/scrolling */ 2356);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _child_list_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./child-list-routing.module */ 58795);
/* harmony import */ var _child_list_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./child-list.page */ 53277);
/* harmony import */ var src_app_pipes_age_pipe__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/pipes/age.pipe */ 37529);










let ChildListPageModule = class ChildListPageModule {};
ChildListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _child_list_routing_module__WEBPACK_IMPORTED_MODULE_1__.ChildListPageRoutingModule, _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_8__.ScrollingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_9__.FormsModule],
  declarations: [_child_list_page__WEBPACK_IMPORTED_MODULE_2__.ChildListPage, src_app_pipes_age_pipe__WEBPACK_IMPORTED_MODULE_3__.AgePipe]
})], ChildListPageModule);


/***/ }),

/***/ 53277:
/*!*****************************************************!*\
  !*** ./src/app/pages/child-list/child-list.page.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChildListPage: () => (/* binding */ ChildListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _child_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./child-list.page.html?ngResource */ 41175);
/* harmony import */ var _child_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./child-list.page.scss?ngResource */ 7903);
/* harmony import */ var _child_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_child_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/child_api.service */ 57571);
/* harmony import */ var src_app_services_permission_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/permission.service */ 7773);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/platform-browser */ 80436);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _components_report_modal_report_modal_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/report-modal/report-modal.component */ 69843);
/* harmony import */ var src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/services/survey_form_api.service */ 55856);
/* harmony import */ var _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @capacitor-mlkit/barcode-scanning */ 89265);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _ChildListPage;















let ChildListPage = (_ChildListPage = class ChildListPage {
  constructor(permissionService, api, b, sanitizer, modalCtrl, surveyApi) {
    this.permissionService = permissionService;
    this.api = api;
    this.b = b;
    this.sanitizer = sanitizer;
    this.modalCtrl = modalCtrl;
    this.surveyApi = surveyApi;
    this.childList = null;
    this.searchTerm = '';
    this.searching = false;
    this.isLoading = false;
    // Filter properties
    this.blocks = [];
    this.subBlocks = [];
    this.allSubBlocks = [];
    this.selectedBlock = null;
    this.selectedSubBlocks = [];
    this.selectedGender = null;
    this.selectedAgeGroup = null;
    this.selectedNextVisitDate = null;
    this.selectedHasDisability = null;
    this.selectedVerified = null;
    this.selectedSurveyForm = null;
    this.surveyForms = [];
    // Pagination properties
    this.currentPage = 1;
    this.pageSize = 25;
    this.totalItems = 0;
    this.totalPages = 0;
    this.hasMoreData = true;
    // Toggle filter section
    this.isFilterCollapsed = true;
    this.Math = Math;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_10__.ICONS;
    this.user = this.b.getCurrentUser();
    this.searchControl = new _angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormControl();
  }
  hasPermission(permissionTitle) {
    var _userObj$user;
    if (!this.user) {
      return false;
    }
    // Handle both UserApiResponse and User types
    const userObj = this.user;
    const roles = userObj.roles || ((_userObj$user = userObj.user) === null || _userObj$user === void 0 ? void 0 : _userObj$user.roles);
    if (!roles) {
      return false;
    }
    // Iterate through all roles and their permissions
    for (const role of roles) {
      if (role.permissions) {
        const hasPermission = role.permissions.some(permission => permission.title === permissionTitle);
        if (hasPermission) {
          return true;
        }
      }
    }
    return false;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        yield _this.loadLocationData();
        yield _this.loadSurveyForms();
        _this.loadFiltersFromStorage();
      } catch (error) {
        _this.childList = [];
        _this.isLoading = false;
      }
    })();
  }
  showReport(type) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _user$profile;
      const token = localStorage.getItem('token');
      const userJson = localStorage.getItem('user');
      const user = JSON.parse(userJson);
      const inf_id = user === null || user === void 0 || (_user$profile = user.profile) === null || _user$profile === void 0 || (_user$profile = _user$profile.default_inf) === null || _user$profile === void 0 ? void 0 : _user$profile.id;
      if (!token) return;
      const fullUrl = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_6__.hostLocal}/child-register/${type}?inf_id=${inf_id}&api_token=${token}`;
      const modal = yield _this2.modalCtrl.create({
        component: _components_report_modal_report_modal_component__WEBPACK_IMPORTED_MODULE_7__.ReportModalComponent,
        componentProps: {
          url: fullUrl,
          title: 'Register'
        },
        cssClass: 'report-modal-fullscreen'
      });
      yield modal.present();
    })();
  }
  load(_x) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (event, append = false) {
      try {
        var _this3$selectedBlock, _this3$selectedSurvey;
        if (!append) {
          _this3.isLoading = true;
        }
        // Extract sub-block IDs from selected sub-blocks
        const subBlockIds = _this3.selectedSubBlocks.length > 0 ? _this3.selectedSubBlocks.map(sb => sb.id) : null;
        const response = yield _this3.api.allChildWithPagination(_this3.currentPage, _this3.pageSize, _this3.searchTerm, (_this3$selectedBlock = _this3.selectedBlock) === null || _this3$selectedBlock === void 0 ? void 0 : _this3$selectedBlock.id, subBlockIds, _this3.selectedGender, _this3.selectedAgeGroup, _this3.selectedNextVisitDate, _this3.selectedHasDisability, _this3.selectedVerified, (_this3$selectedSurvey = _this3.selectedSurveyForm) === null || _this3$selectedSurvey === void 0 ? void 0 : _this3$selectedSurvey.id);
        if (append) {
          // Append new data to existing list
          _this3.childList = [..._this3.childList, ...response.data.data];
          _this3.filteredList = _this3.childList;
        } else {
          // Replace data (for initial load and filters)
          _this3.childList = response.data.data;
          _this3.filteredList = _this3.childList;
        }
        _this3.totalItems = response.data.total;
        _this3.currentPage = response.data.current_page;
        _this3.totalPages = response.data.last_page;
        // Check if more data is available
        _this3.hasMoreData = _this3.currentPage < _this3.totalPages;
      } catch (error) {
        if (!append) {
          _this3.childList = [];
          _this3.filteredList = [];
        }
        _this3.b.errorToast('Failed to load children list');
      } finally {
        _this3.isLoading = false;
        if (event) {
          setTimeout(() => {
            event.target.complete();
          }, 100);
        }
      }
    }).apply(this, arguments);
  }
  loadLocationData() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this4.surveyApi.getLocationData();
        if (response.success) {
          _this4.blocks = response.data.blocks || [];
          _this4.allSubBlocks = response.data.sub_blocks || [];
          _this4.subBlocks = [];
        }
      } catch (error) {
        _this4.b.errorToast('Failed to load location data');
      }
    })();
  }
  loadSurveyForms() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this5.surveyApi.getAssessmentForms('child,followup', 'all');
        if (response.success) {
          _this5.surveyForms = response.data;
        }
      } catch (error) {
        _this5.b.errorToast('Failed to load survey forms');
      }
    })();
  }
  toggleFilterSection() {
    this.isFilterCollapsed = !this.isFilterCollapsed;
  }
  onBlockChange() {
    this.selectedSubBlocks = [];
    if (this.selectedBlock) {
      this.subBlocks = this.allSubBlocks.filter(sb => sb.block_id === this.selectedBlock.block_id);
    } else {
      this.subBlocks = [];
    }
  }
  applyFilters() {
    this.currentPage = 1;
    this.hasMoreData = true;
    this.saveFiltersToStorage();
    this.load();
  }
  clearFilters() {
    this.selectedBlock = null;
    this.selectedSubBlocks = [];
    this.selectedGender = null;
    this.selectedAgeGroup = null;
    this.selectedNextVisitDate = null;
    this.selectedHasDisability = null;
    this.selectedVerified = null;
    this.selectedSurveyForm = null;
    this.searchTerm = '';
    this.subBlocks = [];
    this.currentPage = 1;
    this.hasMoreData = true;
    localStorage.removeItem('childListFilters');
    this.load();
  }
  loadMore(event) {
    var _this6 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this6.hasMoreData) {
        _this6.currentPage++;
        yield _this6.load(event, true);
      } else {
        event.target.complete();
      }
    })();
  }
  ionViewDidEnter() {
    var _this7 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Ensure location data and filters are loaded before fetching data
      if (_this7.blocks.length === 0 || _this7.surveyForms.length === 0) {
        yield _this7.loadLocationData();
        yield _this7.loadSurveyForms();
        _this7.loadFiltersFromStorage();
      }
      _this7.load();
    })();
  }
  trackByChildId(_index, child) {
    return child.id;
  }
  saveFiltersToStorage() {
    var _this$selectedBlock, _this$selectedSurveyF;
    const filters = {
      selectedBlockId: (_this$selectedBlock = this.selectedBlock) === null || _this$selectedBlock === void 0 ? void 0 : _this$selectedBlock.id,
      selectedSubBlockIds: this.selectedSubBlocks.map(sb => sb.id),
      selectedGender: this.selectedGender,
      selectedAgeGroup: this.selectedAgeGroup,
      selectedNextVisitDate: this.selectedNextVisitDate,
      selectedHasDisability: this.selectedHasDisability,
      selectedVerified: this.selectedVerified,
      selectedSurveyFormId: (_this$selectedSurveyF = this.selectedSurveyForm) === null || _this$selectedSurveyF === void 0 ? void 0 : _this$selectedSurveyF.id,
      searchTerm: this.searchTerm,
      pageSize: this.pageSize
    };
    localStorage.setItem('childListFilters', JSON.stringify(filters));
  }
  loadFiltersFromStorage() {
    const savedFilters = localStorage.getItem('childListFilters');
    if (!savedFilters) {
      return;
    }
    const filters = JSON.parse(savedFilters);
    // Restore simple filter values first
    this.selectedGender = filters.selectedGender || null;
    this.selectedAgeGroup = filters.selectedAgeGroup || null;
    this.selectedNextVisitDate = filters.selectedNextVisitDate || null;
    this.selectedHasDisability = filters.selectedHasDisability || null;
    this.selectedVerified = filters.selectedVerified || null;
    this.searchTerm = filters.searchTerm || '';
    this.pageSize = filters.pageSize || 25;
    // Restore block by ID
    if (filters.selectedBlockId && this.blocks.length > 0) {
      this.selectedBlock = this.blocks.find(b => b.id === filters.selectedBlockId) || null;
      // Update sub-blocks based on selected block
      if (this.selectedBlock && this.allSubBlocks.length > 0) {
        this.subBlocks = this.allSubBlocks.filter(sb => sb.block_id === this.selectedBlock.block_id);
        // Restore selected sub-blocks by IDs
        if (filters.selectedSubBlockIds && filters.selectedSubBlockIds.length > 0) {
          this.selectedSubBlocks = this.subBlocks.filter(sb => filters.selectedSubBlockIds.includes(sb.id));
        }
      }
    }
    // Restore survey form by ID
    if (filters.selectedSurveyFormId && this.surveyForms.length > 0) {
      this.selectedSurveyForm = this.surveyForms.find(f => f.id === filters.selectedSurveyFormId) || null;
    }
  }
  scanQRCode() {
    var _this8 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // Check current permission status first
        const permissionStatus = yield _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeScanner.checkPermissions();
        if (permissionStatus.camera === 'denied') {
          // Show alert explaining why permission is needed
          _this8.b.loadAlert('Camera Permission Required', 'Camera access is needed to scan QR codes. Please grant camera permission in your device settings to use this feature.', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
            // Request permissions
            const {
              camera
            } = yield _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeScanner.requestPermissions();
            if (camera === 'granted' || camera === 'limited') {
              yield _this8.performScan();
            } else {
              _this8.b.toast('Camera permission is required to scan QR codes');
            }
          }));
          return;
        }
        // If permission not determined yet, request it
        if (permissionStatus.camera === 'prompt' || permissionStatus.camera === 'prompt-with-rationale') {
          const {
            camera
          } = yield _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeScanner.requestPermissions();
          if (camera !== 'granted' && camera !== 'limited') {
            _this8.b.toast('Camera permission is required to scan QR codes');
            return;
          }
        }
        // If we have permission, proceed with scanning
        if (permissionStatus.camera === 'granted' || permissionStatus.camera === 'limited') {
          yield _this8.performScan();
        }
      } catch (error) {
        _this8.b.errorToast('Failed to scan QR code. Please try again.');
      }
    })();
  }
  performScan() {
    var _this9 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // Start the scanner
        const scanPromise = _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeScanner.scan({
          formats: [_capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.Code128, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.Code39, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.Code93, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.Ean13, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.Ean8, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.UpcA, _capacitor_mlkit_barcode_scanning__WEBPACK_IMPORTED_MODULE_9__.BarcodeFormat.UpcE]
        });
        // Wait 1.5 seconds for camera to auto-focus before capturing
        // This happens silently - no user messages
        yield _this9.delay(1500);
        const result = yield scanPromise;
        if (result.barcodes && result.barcodes.length > 0) {
          const barcode = result.barcodes[0];
          const scannedValue = barcode.rawValue;
          // Validate scanned value before using it
          if (!scannedValue || scannedValue.trim() === '') {
            _this9.b.errorToast('Invalid barcode. Please try again.');
            return;
          }
          // Trim whitespace that might come from angle-based misreads
          const cleanValue = scannedValue.trim();
          // FCN-specific validation: Must be exactly 6 digits
          const fcnPattern = /^\d{6}$/;
          if (!fcnPattern.test(cleanValue)) {
            _this9.b.errorToast('Invalid FCN format. Must be 6 digits.');
            return;
          }
          // Check if barcode was severely distorted (strict 0.15 tolerance - more strict)
          if (barcode.cornerPoints && barcode.cornerPoints.length === 4) {
            const isDistorted = _this9.checkBarcodeDistortion(barcode.cornerPoints);
            if (isDistorted) {
              _this9.b.errorToast('Barcode not clear. Hold device steady and try again.');
              return;
            }
          }
          // Check quality score with VERY HIGH threshold (0.8 = 80% quality)
          // This is the main defense against misreads
          if (barcode.cornerPoints && barcode.cornerPoints.length === 4) {
            const qualityScore = _this9.calculateQualityScore(barcode.cornerPoints);
            if (qualityScore < 0.8) {
              _this9.b.errorToast('Scan quality too low. Hold steady, good lighting, horizontal alignment.');
              return;
            }
          }
          // All validations passed - show what was scanned so user can verify
          _this9.b.toast(`Scanned: ${cleanValue}`, 3000);
          _this9.searchTerm = cleanValue;
          _this9.currentPage = 1;
          _this9.load();
        } else {
          _this9.b.errorToast('No barcode detected. Please try again.');
        }
      } catch (error) {
        _this9.b.errorToast('Scan failed. Please try again.');
      }
    })();
  }
  /**
   * Check if barcode appears heavily distorted based on corner points
   * Returns true if the barcode should be rejected due to poor angle or quality
   * Using very strict 0.15 distortion tolerance (85% similarity required)
   */
  checkBarcodeDistortion(cornerPoints) {
    if (!cornerPoints || cornerPoints.length !== 4) return false;
    // For 1D barcodes, check alignment and distortion
    const [tl, tr, br, bl] = cornerPoints;
    // Calculate distances between corners
    const topWidth = Math.sqrt(Math.pow(tr.x - tl.x, 2) + Math.pow(tr.y - tl.y, 2));
    const bottomWidth = Math.sqrt(Math.pow(br.x - bl.x, 2) + Math.pow(br.y - bl.y, 2));
    const leftHeight = Math.sqrt(Math.pow(bl.x - tl.x, 2) + Math.pow(bl.y - tl.y, 2));
    const rightHeight = Math.sqrt(Math.pow(br.x - tr.x, 2) + Math.pow(br.y - tr.y, 2));
    // VERY STRICT CHECK: 0.15 distortion tolerance (85% similarity required)
    // If top/bottom widths differ by more than 15%, reject
    const widthRatio = Math.min(topWidth, bottomWidth) / Math.max(topWidth, bottomWidth);
    const heightRatio = Math.min(leftHeight, rightHeight) / Math.max(leftHeight, rightHeight);
    if (widthRatio < 0.85 || heightRatio < 0.85) {
      return true; // Too distorted
    }
    // For 1D barcodes: Check horizontal alignment
    // Top and bottom edges should be nearly parallel
    const topAngle = Math.atan2(tr.y - tl.y, tr.x - tl.x);
    const bottomAngle = Math.atan2(br.y - bl.y, br.x - bl.x);
    const angleDifference = Math.abs(topAngle - bottomAngle);
    // Reject if edges aren't parallel (> 8 degrees difference - stricter)
    if (angleDifference > 0.14) {
      // 0.14 radians = ~8 degrees
      return true;
    }
    // Check skew: left and right edges should be nearly vertical
    const leftAngle = Math.atan2(bl.y - tl.y, bl.x - tl.x);
    const rightAngle = Math.atan2(br.y - tr.y, br.x - tr.x);
    const verticalDifference = Math.abs(leftAngle - rightAngle);
    // Reject if vertical edges are too skewed (stricter)
    if (verticalDifference > 0.14) {
      // ~8 degrees
      return true;
    }
    // For 1D barcodes: aspect ratio should be wide (width > height)
    const avgWidth = (topWidth + bottomWidth) / 2;
    const avgHeight = (leftHeight + rightHeight) / 2;
    // Barcodes should be wider than tall (typical ratio 3:1 to 10:1)
    // Reject if height > width (wrong orientation) or too square
    if (avgHeight >= avgWidth) {
      return true; // Wrong orientation
    }
    return false;
  }
  /**
   * Calculate a quality score based on barcode geometry
   * Returns a score between 0 and 1, where 1 is perfect quality
   */
  calculateQualityScore(cornerPoints) {
    if (!cornerPoints || cornerPoints.length !== 4) return 0;
    const [tl, tr, br, bl] = cornerPoints;
    // Calculate distances
    const topWidth = Math.sqrt(Math.pow(tr.x - tl.x, 2) + Math.pow(tr.y - tl.y, 2));
    const bottomWidth = Math.sqrt(Math.pow(br.x - bl.x, 2) + Math.pow(br.y - bl.y, 2));
    const leftHeight = Math.sqrt(Math.pow(bl.x - tl.x, 2) + Math.pow(bl.y - tl.y, 2));
    const rightHeight = Math.sqrt(Math.pow(br.x - tr.x, 2) + Math.pow(br.y - tr.y, 2));
    // Score based on parallelogram quality (how rectangular is it)
    const widthRatio = Math.min(topWidth, bottomWidth) / Math.max(topWidth, bottomWidth);
    const heightRatio = Math.min(leftHeight, rightHeight) / Math.max(leftHeight, rightHeight);
    const geometryScore = (widthRatio + heightRatio) / 2;
    // Score based on angle alignment
    const topAngle = Math.atan2(tr.y - tl.y, tr.x - tl.x);
    const bottomAngle = Math.atan2(br.y - bl.y, br.x - bl.x);
    const angleDifference = Math.abs(topAngle - bottomAngle);
    const angleScore = Math.max(0, 1 - angleDifference / 0.349); // 0.349 rad = 20 degrees
    // Score based on size (larger barcodes scan better)
    const avgWidth = (topWidth + bottomWidth) / 2;
    const avgHeight = (leftHeight + rightHeight) / 2;
    const area = avgWidth * avgHeight;
    const sizeScore = Math.min(1, area / 50000); // Normalize based on expected area
    // Weighted average of all scores
    const qualityScore = geometryScore * 0.5 + angleScore * 0.3 + sizeScore * 0.2;
    return qualityScore;
  }
  /**
   * Delay helper for camera focus
   */
  delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
  }
}, _ChildListPage.ctorParameters = () => [{
  type: src_app_services_permission_service__WEBPACK_IMPORTED_MODULE_5__.PermissionService
}, {
  type: src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_4__.ChildAPIService
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_12__.DomSanitizer
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.ModalController
}, {
  type: src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_8__.SurveyFormAPIService
}], _ChildListPage);
ChildListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_15__.Component)({
  selector: 'app-child-list',
  template: _child_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_child_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ChildListPage);


/***/ }),

/***/ 37529:
/*!***********************************!*\
  !*** ./src/app/pipes/age.pipe.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AgePipe: () => (/* binding */ AgePipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);


let AgePipe = class AgePipe {
  transform(dateOfBirth) {
    if (!dateOfBirth) {
      return 'N/A';
    }
    const dob = new Date(dateOfBirth);
    const today = new Date();
    let years = today.getFullYear() - dob.getFullYear();
    let months = today.getMonth() - dob.getMonth();
    let days = today.getDate() - dob.getDate();
    if (days < 0) {
      months--;
      const lastDayOfPrevMonth = new Date(today.getFullYear(), today.getMonth(), 0).getDate();
      days += lastDayOfPrevMonth;
    }
    if (months < 0) {
      years--;
      months += 12;
    }
    const totalMonths = years * 12 + months;
    let result = '';
    if (totalMonths > 0) {
      result += `${totalMonths} Months`;
    }
    if (days > 0) {
      if (result.length > 0) {
        result += ' ';
      }
      result += `${days} days`;
    }
    return result || '0d';
  }
};
AgePipe = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Pipe)({
  name: 'age',
  pure: true
})], AgePipe);


/***/ }),

/***/ 7903:
/*!******************************************************************!*\
  !*** ./src/app/pages/child-list/child-list.page.scss?ngResource ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.viewport {
  height: 1100px; /* or any value appropriate for your needs */
  width: 100%;
  overflow: auto; /* Make sure scrolling works */
}

:host {
  --ion-background-color: #f8f9fa;
  --ion-color-light: #f8f9fa;
  --ion-color-primary: #3880ff;
  --ion-color-secondary: #1eb0c4;
  --ion-color-tertiary: #7854e4;
  --ion-color-warning: #ffce00;
  --ion-color-danger: #f04141;
  --ion-color-dark: #4a4c52;
  --ion-color-purple: #8836ca;
  --card-border-radius: 16px;
  --card-box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
}

ion-toolbar {
  --background: #ffffff;
  --border-style: none;
}

.search-container {
  margin-top: 10px;
  margin-bottom: 20px;
  display: flex;
  align-items: center;
  gap: 8px;
  position: relative;
}
.search-container ion-searchbar {
  flex: 1;
}
.search-container .qr-scan-button {
  --padding-start: 12px;
  --padding-end: 12px;
  height: 44px;
}
.search-container .qr-scan-button ion-icon {
  font-size: 24px;
}
.search-container .scan-hint {
  position: absolute;
  right: 8px;
  bottom: -18px;
  font-size: 10px;
  color: var(--ion-color-medium);
  font-style: italic;
}

ion-searchbar {
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
  --border-radius: 12px;
  --background: #ffffff;
  --color: var(--ion-color-dark);
  --placeholder-color: var(--ion-color-medium);
  --icon-color: var(--ion-color-primary);
  padding: 0;
}

.list-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 16px;
}

.list-header h2 {
  font-size: 20px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin: 0;
}

.child-viewport {
  height: calc(100vh - 180px);
  width: 100%;
}

.child-card {
  margin-bottom: 16px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
  background-color: #ffffff;
  overflow: hidden;
}

.card-header {
  padding: 12px;
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

.child-name-container {
  display: flex;
  align-items: center;
}

.child-name {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  margin-right: 10px;
}

.child-name.verified-name {
  font-weight: 700;
  color: #28a745;
}

.birth-date {
  display: flex;
  align-items: center;
  font-size: 14px;
  color: var(--ion-color-medium);
}

.birth-date ion-icon {
  margin-right: 4px;
}

.identifiers {
  padding: 12px;
  display: flex;
  flex-wrap: wrap;
  gap: 10px;
  background-color: rgba(var(--ion-color-light-rgb), 0.5);
}

.id-item {
  flex: 1;
  min-width: 120px;
  display: flex;
  flex-direction: column;
}

.id-label {
  font-size: 11px;
  color: var(--ion-color-medium);
  margin-bottom: 2px;
}

.id-value {
  font-size: 13px;
  font-weight: 600;
  color: var(--ion-color-dark);
}

.card-actions {
  display: flex;
  padding: 6px;
  border-top: 1px solid rgba(0, 0, 0, 0.05);
  overflow-x: auto;
}

.card-actions ion-button {
  flex: 1;
  font-size: 12px;
  --padding-start: 6px;
  --padding-end: 6px;
  height: 34px;
}

.card-actions ion-button ion-icon {
  margin-right: 4px;
}

/* Tablet view - ensure filters display like desktop */
@media (min-width: 577px) and (max-width: 991px) {
  .filters-card ion-row ion-col[size="12"] {
    flex: 0 0 50% !important;
    max-width: 50% !important;
  }
}
/* Responsive adjustments */
@media (max-width: 576px) {
  .id-item {
    min-width: 100px;
  }
  .card-actions ion-button {
    font-size: 11px;
  }
}
/* Scrollbar styling */
.child-viewport::-webkit-scrollbar {
  width: 8px;
}

.child-viewport::-webkit-scrollbar-track {
  background: transparent;
}

.child-viewport::-webkit-scrollbar-thumb {
  background-color: rgba(var(--ion-color-medium-rgb), 0.3);
  border-radius: 4px;
}

/* Quick Action Card */
.quick-action-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
  background: linear-gradient(135deg, var(--ion-color-primary) 0%, var(--ion-color-primary-shade) 100%);
  overflow: hidden;
}
.quick-action-card ion-card-content {
  padding: 16px;
}
.quick-action-card ion-button {
  --background: #ffffff;
  --color: var(--ion-color-primary);
  font-weight: 600;
  font-size: 16px;
  height: 48px;
  text-transform: none;
  letter-spacing: 0.3px;
}
.quick-action-card ion-button ion-icon {
  font-size: 24px;
}
.quick-action-card ion-button:hover {
  --background: rgba(255, 255, 255, 0.9);
}

/* Filters Card */
.filters-card {
  margin-bottom: 20px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
}

.filters-card ion-card-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 18px;
  font-weight: 600;
}

.filters-card ion-card-subtitle {
  margin-top: 0.5rem;
  color: var(--ion-color-medium);
  font-size: 0.9rem;
}

.form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.form-item ion-select {
  width: 100%;
}

.beneficiary-search {
  --background: rgba(var(--ion-color-dark-rgb), 0.08);
  --border-radius: 8px;
  --box-shadow: 0 2px 4px rgba(0,0,0,0.12);
  --color: var(--ion-color-dark);
  --placeholder-color: var(--ion-color-medium);
  --icon-color: var(--ion-color-medium);
  margin: 0;
  font-size: 0.9rem;
  border: 1px solid rgba(var(--ion-color-dark-rgb), 0.1);
}
.beneficiary-search.searchbar-has-value {
  --background: var(--ion-color-primary-tint);
  --color: var(--ion-color-primary-contrast);
  --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);
  --icon-color: var(--ion-color-primary-contrast);
}

.action-buttons {
  margin-top: 1.5rem;
  display: flex;
  gap: 0.5rem;
}
.action-buttons ion-button {
  flex: 1;
}
.action-buttons ion-button[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

/* Pagination Styles */
.pagination-card {
  margin-top: 20px;
  margin-bottom: 20px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
}

.pagination-controls {
  display: flex;
  justify-content: center;
  align-items: center;
  gap: 8px;
  padding: 12px;
}

.page-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 4px;
  margin: 0 12px;
}

.page-info span {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
}

.page-info ion-select {
  font-size: 12px;
  max-width: 150px;
}

.pagination-info {
  text-align: center;
  font-size: 13px;
  color: var(--ion-color-medium);
  padding-top: 8px;
  border-top: 1px solid rgba(0, 0, 0, 0.05);
}

.children-list {
  margin-bottom: 20px;
}

/* Responsive pagination */
@media (max-width: 576px) {
  .pagination-controls {
    flex-wrap: wrap;
  }
  .page-info {
    flex-direction: row;
    gap: 8px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/child-list/child-list.page.scss"],"names":[],"mappings":"AAAA;EACE,cAAA,EAAA,4CAAA;EACA,WAAA;EACA,cAAA,EAAA,8BAAA;AACF;;AAEA;EACE,+BAAA;EACA,0BAAA;EACA,4BAAA;EACA,8BAAA;EACA,6BAAA;EACA,4BAAA;EACA,2BAAA;EACA,yBAAA;EACA,2BAAA;EACA,0BAAA;EACA,iDAAA;AACF;;AAEA;EACE,qBAAA;EACA,oBAAA;AACF;;AAEA;EACE,gBAAA;EACA,mBAAA;EACA,aAAA;EACA,mBAAA;EACA,QAAA;EACA,kBAAA;AACF;AACE;EACE,OAAA;AACJ;AAEE;EACE,qBAAA;EACA,mBAAA;EACA,YAAA;AAAJ;AAEI;EACE,eAAA;AAAN;AAIE;EACE,kBAAA;EACA,UAAA;EACA,aAAA;EACA,eAAA;EACA,8BAAA;EACA,kBAAA;AAFJ;;AAMA;EACE,4CAAA;EACA,qBAAA;EACA,qBAAA;EACA,8BAAA;EACA,4CAAA;EACA,sCAAA;EACA,UAAA;AAHF;;AAMA;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;AAHF;;AAMA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,SAAA;AAHF;;AAMA;EACE,2BAAA;EACA,WAAA;AAHF;;AAMA;EACE,mBAAA;EACA,mBAAA;EACA,0CAAA;EACA,yBAAA;EACA,gBAAA;AAHF;;AAMA;EACE,aAAA;EACA,aAAA;EACA,8BAAA;EACA,uBAAA;EACA,4CAAA;AAHF;;AAMA;EACE,aAAA;EACA,mBAAA;AAHF;;AAMA;EACE,SAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;AAHF;;AAMA;EACE,gBAAA;EACA,cAAA;AAHF;;AAMA;EACE,aAAA;EACA,mBAAA;EACA,eAAA;EACA,8BAAA;AAHF;;AAMA;EACE,iBAAA;AAHF;;AAMA;EACE,aAAA;EACA,aAAA;EACA,eAAA;EACA,SAAA;EACA,uDAAA;AAHF;;AAMA;EACE,OAAA;EACA,gBAAA;EACA,aAAA;EACA,sBAAA;AAHF;;AAMA;EACE,eAAA;EACA,8BAAA;EACA,kBAAA;AAHF;;AAMA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAHF;;AAMA;EACE,aAAA;EACA,YAAA;EACA,yCAAA;EACA,gBAAA;AAHF;;AAMA;EACE,OAAA;EACA,eAAA;EACA,oBAAA;EACA,kBAAA;EACA,YAAA;AAHF;;AAMA;EACE,iBAAA;AAHF;;AAMA,sDAAA;AACA;EAKQ;IACE,wBAAA;IACA,yBAAA;EAPR;AACF;AAaA,2BAAA;AACA;EACE;IACE,gBAAA;EAXF;EAcA;IACE,eAAA;EAZF;AACF;AAeA,sBAAA;AACA;EACE,UAAA;AAbF;;AAgBA;EACE,uBAAA;AAbF;;AAgBA;EACE,wDAAA;EACA,kBAAA;AAbF;;AAgBA,sBAAA;AACA;EACE,mBAAA;EACA,0CAAA;EACA,qGAAA;EACA,gBAAA;AAbF;AAeE;EACE,aAAA;AAbJ;AAgBE;EACE,qBAAA;EACA,iCAAA;EACA,gBAAA;EACA,eAAA;EACA,YAAA;EACA,oBAAA;EACA,qBAAA;AAdJ;AAgBI;EACE,eAAA;AAdN;AAiBI;EACE,sCAAA;AAfN;;AAoBA,iBAAA;AACA;EACE,mBAAA;EACA,mBAAA;EACA,0CAAA;AAjBF;;AAoBA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;AAjBF;;AAoBA;EACE,kBAAA;EACA,8BAAA;EACA,iBAAA;AAjBF;;AAoBA;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAjBF;AAmBE;EACE,gBAAA;EACA,4BAAA;AAjBJ;AAoBE;EACE,eAAA;EACA,eAAA;AAlBJ;AAoBI;EACE,8BAAA;AAlBN;AAqBI;EACE,8BAAA;AAnBN;AAuBE;EACE,WAAA;AArBJ;;AAyBA;EACE,mDAAA;EACA,oBAAA;EACA,wCAAA;EACA,8BAAA;EACA,4CAAA;EACA,qCAAA;EACA,SAAA;EACA,iBAAA;EACA,sDAAA;AAtBF;AAwBE;EACE,2CAAA;EACA,0CAAA;EACA,qEAAA;EACA,+CAAA;AAtBJ;;AA0BA;EACE,kBAAA;EACA,aAAA;EACA,WAAA;AAvBF;AAyBE;EACE,OAAA;AAvBJ;AA0BE;EACE,YAAA;EACA,mBAAA;AAxBJ;;AA4BA,sBAAA;AACA;EACE,gBAAA;EACA,mBAAA;EACA,mBAAA;EACA,0CAAA;AAzBF;;AA4BA;EACE,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,QAAA;EACA,aAAA;AAzBF;;AA4BA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,QAAA;EACA,cAAA;AAzBF;;AA4BA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAzBF;;AA4BA;EACE,eAAA;EACA,gBAAA;AAzBF;;AA4BA;EACE,kBAAA;EACA,eAAA;EACA,8BAAA;EACA,gBAAA;EACA,yCAAA;AAzBF;;AA4BA;EACE,mBAAA;AAzBF;;AA4BA,0BAAA;AACA;EACE;IACE,eAAA;EAzBF;EA4BA;IACE,mBAAA;IACA,QAAA;EA1BF;AACF","sourcesContent":[".viewport {\n  height: 1100px; /* or any value appropriate for your needs */\n  width: 100%;\n  overflow: auto; /* Make sure scrolling works */\n}\n\n:host {\n  --ion-background-color: #f8f9fa;\n  --ion-color-light: #f8f9fa;\n  --ion-color-primary: #3880ff;\n  --ion-color-secondary: #1eb0c4;\n  --ion-color-tertiary: #7854e4;\n  --ion-color-warning: #ffce00;\n  --ion-color-danger: #f04141;\n  --ion-color-dark: #4a4c52;\n  --ion-color-purple: #8836ca;\n  --card-border-radius: 16px;\n  --card-box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);\n}\n\nion-toolbar {\n  --background: #ffffff;\n  --border-style: none;\n}\n\n.search-container {\n  margin-top: 10px;\n  margin-bottom: 20px;\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  position: relative;\n\n  ion-searchbar {\n    flex: 1;\n  }\n\n  .qr-scan-button {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    height: 44px;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .scan-hint {\n    position: absolute;\n    right: 8px;\n    bottom: -18px;\n    font-size: 10px;\n    color: var(--ion-color-medium);\n    font-style: italic;\n  }\n}\n\nion-searchbar {\n  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);\n  --border-radius: 12px;\n  --background: #ffffff;\n  --color: var(--ion-color-dark);\n  --placeholder-color: var(--ion-color-medium);\n  --icon-color: var(--ion-color-primary);\n  padding: 0;\n}\n\n.list-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: 16px;\n}\n\n.list-header h2 {\n  font-size: 20px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  margin: 0;\n}\n\n.child-viewport {\n  height: calc(100vh - 180px);\n  width: 100%;\n}\n\n.child-card {\n  margin-bottom: 16px;\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);\n  background-color: #ffffff;\n  overflow: hidden;\n}\n\n.card-header {\n  padding: 12px;\n  display: flex;\n  justify-content: space-between;\n  align-items: flex-start;\n  border-bottom: 1px solid rgba(0, 0, 0, 0.05);\n}\n\n.child-name-container {\n  display: flex;\n  align-items: center;\n}\n\n.child-name {\n  margin: 0;\n  font-size: 18px;\n  font-weight: 600;\n  margin-right: 10px;\n}\n\n.child-name.verified-name {\n  font-weight: 700;\n  color: #28a745;\n}\n\n.birth-date {\n  display: flex;\n  align-items: center;\n  font-size: 14px;\n  color: var(--ion-color-medium);\n}\n\n.birth-date ion-icon {\n  margin-right: 4px;\n}\n\n.identifiers {\n  padding: 12px;\n  display: flex;\n  flex-wrap: wrap;\n  gap: 10px;\n  background-color: rgba(var(--ion-color-light-rgb), 0.5);\n}\n\n.id-item {\n  flex: 1;\n  min-width: 120px;\n  display: flex;\n  flex-direction: column;\n}\n\n.id-label {\n  font-size: 11px;\n  color: var(--ion-color-medium);\n  margin-bottom: 2px;\n}\n\n.id-value {\n  font-size: 13px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n}\n\n.card-actions {\n  display: flex;\n  padding: 6px;\n  border-top: 1px solid rgba(0, 0, 0, 0.05);\n  overflow-x: auto;\n}\n\n.card-actions ion-button {\n  flex: 1;\n  font-size: 12px;\n  --padding-start: 6px;\n  --padding-end: 6px;\n  height: 34px;\n}\n\n.card-actions ion-button ion-icon {\n  margin-right: 4px;\n}\n\n/* Tablet view - ensure filters display like desktop */\n@media (min-width: 577px) and (max-width: 991px) {\n  .filters-card {\n    ion-row {\n      ion-col {\n        // Override any single column layout\n        &[size=\"12\"] {\n          flex: 0 0 50% !important;\n          max-width: 50% !important;\n        }\n      }\n    }\n  }\n}\n\n/* Responsive adjustments */\n@media (max-width: 576px) {\n  .id-item {\n    min-width: 100px;\n  }\n\n  .card-actions ion-button {\n    font-size: 11px;\n  }\n}\n\n/* Scrollbar styling */\n.child-viewport::-webkit-scrollbar {\n  width: 8px;\n}\n\n.child-viewport::-webkit-scrollbar-track {\n  background: transparent;\n}\n\n.child-viewport::-webkit-scrollbar-thumb {\n  background-color: rgba(var(--ion-color-medium-rgb), 0.3);\n  border-radius: 4px;\n}\n\n/* Quick Action Card */\n.quick-action-card {\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);\n  background: linear-gradient(135deg, var(--ion-color-primary) 0%, var(--ion-color-primary-shade) 100%);\n  overflow: hidden;\n\n  ion-card-content {\n    padding: 16px;\n  }\n\n  ion-button {\n    --background: #ffffff;\n    --color: var(--ion-color-primary);\n    font-weight: 600;\n    font-size: 16px;\n    height: 48px;\n    text-transform: none;\n    letter-spacing: 0.3px;\n\n    ion-icon {\n      font-size: 24px;\n    }\n\n    &:hover {\n      --background: rgba(255, 255, 255, 0.9);\n    }\n  }\n}\n\n/* Filters Card */\n.filters-card {\n  margin-bottom: 20px;\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);\n}\n\n.filters-card ion-card-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 18px;\n  font-weight: 600;\n}\n\n.filters-card ion-card-subtitle {\n  margin-top: 0.5rem;\n  color: var(--ion-color-medium);\n  font-size: 0.9rem;\n}\n\n.form-item {\n  margin-bottom: 16px;\n  border-radius: 8px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n\n  ion-label {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n  }\n\n  ion-note {\n    font-size: 12px;\n    margin-top: 4px;\n\n    &[slot=\"helper\"] {\n      color: var(--ion-color-medium);\n    }\n\n    &[slot=\"error\"] {\n      color: var(--ion-color-danger);\n    }\n  }\n\n  ion-select {\n    width: 100%;\n  }\n}\n\n.beneficiary-search {\n  --background: rgba(var(--ion-color-dark-rgb), 0.08);\n  --border-radius: 8px;\n  --box-shadow: 0 2px 4px rgba(0,0,0,0.12);\n  --color: var(--ion-color-dark);\n  --placeholder-color: var(--ion-color-medium);\n  --icon-color: var(--ion-color-medium);\n  margin: 0;\n  font-size: 0.9rem;\n  border: 1px solid rgba(var(--ion-color-dark-rgb), 0.1);\n\n  &.searchbar-has-value {\n    --background: var(--ion-color-primary-tint);\n    --color: var(--ion-color-primary-contrast);\n    --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);\n    --icon-color: var(--ion-color-primary-contrast);\n  }\n}\n\n.action-buttons {\n  margin-top: 1.5rem;\n  display: flex;\n  gap: 0.5rem;\n\n  ion-button {\n    flex: 1;\n  }\n\n  ion-button[disabled] {\n    opacity: 0.5;\n    cursor: not-allowed;\n  }\n}\n\n/* Pagination Styles */\n.pagination-card {\n  margin-top: 20px;\n  margin-bottom: 20px;\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);\n}\n\n.pagination-controls {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  gap: 8px;\n  padding: 12px;\n}\n\n.page-info {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  gap: 4px;\n  margin: 0 12px;\n}\n\n.page-info span {\n  font-size: 14px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n}\n\n.page-info ion-select {\n  font-size: 12px;\n  max-width: 150px;\n}\n\n.pagination-info {\n  text-align: center;\n  font-size: 13px;\n  color: var(--ion-color-medium);\n  padding-top: 8px;\n  border-top: 1px solid rgba(0, 0, 0, 0.05);\n}\n\n.children-list {\n  margin-bottom: 20px;\n}\n\n/* Responsive pagination */\n@media (max-width: 576px) {\n  .pagination-controls {\n    flex-wrap: wrap;\n  }\n\n  .page-info {\n    flex-direction: row;\n    gap: 8px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 41175:
/*!******************************************************************!*\
  !*** ./src/app/pages/child-list/child-list.page.html?ngResource ***!
  \******************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Children</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding-horizontal\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"load($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n  <ng-container *ngIf=\"childList; else skeleton\">\n    <!-- Filters Section -->\n    <ion-card class=\"filters-card\">\n      <ion-card-header (click)=\"toggleFilterSection()\" style=\"cursor: pointer;\">\n        <ion-card-title style=\"display: flex; align-items: center; justify-content: space-between;\">\n          <div style=\"display: flex; align-items: center; gap: 8px;\">\n            <ion-icon [name]=\"icons.FILTER\" color=\"primary\"></ion-icon>\n            <span>Filters</span>\n          </div>\n          <ion-icon [name]=\"isFilterCollapsed  ? icons.CHEVRON_DOWN : icons.CHEVRON_UP\" color=\"medium\"></ion-icon>\n        </ion-card-title>\n        <ion-card-subtitle>Filter children by location and attributes</ion-card-subtitle>\n      </ion-card-header>\n      <ion-card-content *ngIf=\"!isFilterCollapsed\">\n        <ion-row>\n          <!-- Next Visit Date -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.TIME\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Planned Visit Date</ion-label>\n              <ion-input\n                type=\"date\"\n                [(ngModel)]=\"selectedNextVisitDate\"\n                placeholder=\"Select date\">\n              </ion-input>\n              <ion-button slot=\"end\" fill=\"clear\" size=\"small\" (click)=\"selectedNextVisitDate = null\" *ngIf=\"selectedNextVisitDate\">\n                <ion-icon [name]=\"icons.CLOSE_CIRCLE\" color=\"medium\"></ion-icon>\n              </ion-button>\n            </ion-item>\n          </ion-col>\n\n          <!-- Follow Up Service -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.DOCUMENT_TEXT\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Follow Up Service</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedSurveyForm\" placeholder=\"Select follow up service\">\n                <ion-select-option [value]=\"null\">All</ion-select-option>\n                <ion-select-option *ngFor=\"let form of surveyForms\" [value]=\"form\">\n                  {{ form.title }}\n                </ion-select-option>\n              </ion-select>\n              <ion-note slot=\"helper\">\n                Filter children with active follow-up visits\n              </ion-note>\n            </ion-item>\n          </ion-col>\n        </ion-row>\n\n        <ion-row>\n          <!-- Verified Status -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.CHECKMARK_CIRCLE\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Verified Status</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedVerified\" placeholder=\"Select verified status\">\n                <ion-select-option [value]=\"null\">All</ion-select-option>\n                <ion-select-option value=\"true\">Verified</ion-select-option>\n                <ion-select-option value=\"false\">Not Verified</ion-select-option>\n              </ion-select>\n            </ion-item>\n          </ion-col>\n\n          <!-- Has Disability -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.ACCESSIBILITY\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Has Disability</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedHasDisability\" placeholder=\"Select disability status\">\n                <ion-select-option [value]=\"null\">All</ion-select-option>\n                <ion-select-option value=\"Yes\">Yes</ion-select-option>\n                <ion-select-option value=\"No\">No</ion-select-option>\n              </ion-select>\n            </ion-item>\n          </ion-col>\n        </ion-row>\n\n        <ion-row>\n          <!-- Block Selection -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.LOCATION\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Block</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedBlock\" (ionChange)=\"onBlockChange()\" placeholder=\"Select block\">\n                <ion-select-option [value]=\"null\">All Blocks</ion-select-option>\n                <ion-select-option *ngFor=\"let block of blocks\" [value]=\"block\">\n                  {{ block.title }}\n                </ion-select-option>\n              </ion-select>\n            </ion-item>\n          </ion-col>\n\n          <!-- Sub-Block Selection (Multi-select) -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.GRID\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Sub-Blocks</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedSubBlocks\" multiple=\"true\" [disabled]=\"!selectedBlock\" placeholder=\"Select sub-blocks\">\n                <ion-select-option *ngFor=\"let subBlock of subBlocks\" [value]=\"subBlock\">\n                  {{ subBlock.title }}\n                </ion-select-option>\n              </ion-select>\n              <ion-note slot=\"helper\" *ngIf=\"selectedBlock\">\n                Select multiple sub-blocks or leave empty for all\n              </ion-note>\n            </ion-item>\n          </ion-col>\n        </ion-row>\n\n        <ion-row>\n          <!-- Gender Selection -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.PERSON\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Gender</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedGender\" placeholder=\"Select gender\">\n                <ion-select-option [value]=\"null\">All Genders</ion-select-option>\n                <ion-select-option value=\"Male\">Male</ion-select-option>\n                <ion-select-option value=\"Female\">Female</ion-select-option>\n              </ion-select>\n            </ion-item>\n          </ion-col>\n\n          <!-- Age Group Selection -->\n          <ion-col size=\"12\" size-md=\"6\">\n            <ion-item class=\"form-item\">\n              <ion-icon slot=\"start\" [name]=\"icons.CALENDAR\" color=\"primary\"></ion-icon>\n              <ion-label position=\"stacked\">Age Group</ion-label>\n              <ion-select interface=\"action-sheet\" [(ngModel)]=\"selectedAgeGroup\" placeholder=\"Select age group\">\n                <ion-select-option [value]=\"null\">All Ages</ion-select-option>\n                <ion-select-option value=\"0-6\">0-6 months</ion-select-option>\n                <ion-select-option value=\"6-24\">6-23 months</ion-select-option>\n                <ion-select-option value=\"24-59\">24-59 months</ion-select-option>\n              </ion-select>\n            </ion-item>\n          </ion-col>\n        </ion-row>\n      </ion-card-content>\n\n      <!-- Search Input -->\n      <div class=\"search-container\">\n        <ion-searchbar\n          [(ngModel)]=\"searchTerm\"\n          placeholder=\"Search by name, ID or FCN...\"\n          show-clear-button=\"focus\"\n          class=\"beneficiary-search\">\n        </ion-searchbar>\n        <ion-button fill=\"clear\" (click)=\"scanQRCode()\" class=\"qr-scan-button\">\n          <ion-icon slot=\"icon-only\" [name]=\"icons.QR_CODE\"></ion-icon>\n        </ion-button>\n        <ion-note class=\"scan-hint\">Hold camera straight</ion-note>\n      </div>\n\n      <div class=\"action-buttons\">\n        <ion-button expand=\"block\" fill=\"clear\" (click)=\"clearFilters()\">\n          <ion-icon [name]=\"icons.CLOSE_CIRCLE\" slot=\"start\"></ion-icon>\n          Clear Filters\n        </ion-button>\n        <ion-button expand=\"block\" color=\"primary\" (click)=\"applyFilters()\">\n          <ion-icon [name]=\"icons.SEARCH\" slot=\"start\"></ion-icon>\n          Apply Filters\n        </ion-button>\n      </div>\n    </ion-card>\n\n    <!-- Results Header -->\n    <ion-card *ngIf=\"filteredList?.length > 0\">\n      <ion-card-header>\n        <div style=\"display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 12px;\">\n          <div>\n            <ion-card-title>\n              <ion-icon [name]=\"icons.PEOPLE\" color=\"tertiary\"></ion-icon>\n              Children List ({{ totalItems }})\n            </ion-card-title>\n            <ion-card-subtitle>\n              Showing {{ ((currentPage - 1) * pageSize) + 1 }} to {{ Math.min(currentPage * pageSize, totalItems) }} of {{ totalItems }} children\n            </ion-card-subtitle>\n          </div>\n          <ion-button [routerLink]=\"b.routesConfig.childAdd\" *ngIf=\"hasPermission('app-child-add')\" color=\"primary\">\n            <ion-icon slot=\"start\" [name]=\"icons.ADD_CIRCLE\"></ion-icon>\n            Add Child\n          </ion-button>\n        </div>\n      </ion-card-header>\n    </ion-card>\n\n    <div class=\"children-list\">\n      <ion-card *ngFor=\"let child of filteredList; trackBy: trackByChildId\" class=\"child-card\">\n        <div class=\"card-header\">\n          <div class=\"child-name-container\">\n            <div style=\"display: flex; gap: 6px; align-items: center; flex-wrap: wrap;\">\n              <h2 class=\"child-name\" style=\"margin: 0;\">{{child.name}}</h2>\n              <ion-badge *ngIf=\"child?.verified === 1\" color=\"success\" style=\"padding: 6px 12px; font-size: 12px; display: flex; align-items: center; gap: 4px;\">\n                <ion-icon [name]=\"icons.SHIELD_CHECKMARK\" style=\"font-size: 14px;\"></ion-icon>\n                Verified\n              </ion-badge>\n              <ion-badge [color]=\"child.gender === 'Male' || child.gender === 'Female' ? '' : 'tertiary'\" [style.background]=\"child.gender === 'Male' ? '#10b981' : child.gender === 'Female' ? '#ec4899' : ''\" style=\"padding: 6px 12px; font-size: 12px; display: flex; align-items: center; gap: 4px;\">\n                <ion-icon [name]=\"child.gender === 'Male'  ? icons.MALE : icons.FEMALE\" style=\"font-size: 14px;\"></ion-icon>\n                {{child.gender}}\n              </ion-badge>\n              <ion-badge\n                *ngFor=\"let programme of child.ongoing_programme\"\n                [color]=\"programme === 'OTP' ? 'danger' : programme === 'TSFP' ? 'warning' : programme === 'BSFP' ? 'success' : 'medium'\"\n                style=\"padding: 6px 12px; font-size: 12px; display: flex; align-items: center; gap: 4px;\">\n                <ion-icon [name]=\"icons.FITNESS\" style=\"font-size: 14px;\"></ion-icon>\n                {{programme}}\n              </ion-badge>\n              <ion-badge *ngIf=\"child.has_disability === 'Yes'\" color=\"secondary\" style=\"padding: 6px 12px; font-size: 12px; display: flex; align-items: center; gap: 4px;\">\n                <ion-icon [name]=\"icons.ACCESSIBILITY\" style=\"font-size: 14px;\"></ion-icon>\n                Special Need\n              </ion-badge>\n            </div>\n          </div>\n          <div class=\"birth-date\">\n            <ion-icon [name]=\"icons.CALENDAR\"></ion-icon>\n            <span>Age: {{child.date_of_birth | age}}</span>\n          </div>\n        </div>\n\n        <div class=\"identifiers\">\n          <div class=\"id-item\">\n            <span class=\"id-label\">Progress ID</span>\n            <span class=\"id-value\">{{child.progress_id || 'N/A'}}</span>\n          </div>\n          <div class=\"id-item\">\n            <span class=\"id-label\">FCN</span>\n            <span class=\"id-value\">{{child.fcn || 'N/A'}}</span>\n          </div>\n          <div class=\"id-item\">\n            <span class=\"id-label\">Scope No.</span>\n            <span class=\"id-value\">{{child?.scope_no || 'N/A'}}</span>\n          </div>\n          <div class=\"id-item\">\n            <span class=\"id-label\">MOHA ID</span>\n            <span class=\"id-value\">{{child.moha_id || 'N/A'}}</span>\n          </div>\n        </div>\n\n        <div class=\"card-actions\">\n          <ion-button fill=\"clear\" color=\"success\" [routerLink]=\"b.routesConfig.childDetail + child.id\">\n            <ion-icon [name]=\"icons.PERSON_CIRCLE\"></ion-icon>\n            <span>Profile</span>\n          </ion-button>\n\n          <ion-button fill=\"clear\" color=\"primary\" [routerLink]=\"['/measurement-create', child.id]\" *ngIf=\"hasPermission('app-child-measurement-add')\">\n            <ion-icon [name]=\"icons.FITNESS\"></ion-icon>\n            <span>Measurement</span>\n          </ion-button>\n\n          <ion-button fill=\"clear\" color=\"tertiary\" [routerLink]=\"b.routesConfig.beneficiaryAssessment + child?.id + '/child'\" *ngIf=\"hasPermission('app-child-assessment-add')\">\n            <ion-icon [name]=\"icons.LIST\"></ion-icon>\n            <span>Service</span>\n          </ion-button>\n\n          <ion-button fill=\"clear\" color=\"secondary\" [routerLink]=\"['/distribution-create', child.id]\" *ngIf=\"hasPermission('app-child-distribution-add')\">\n            <ion-icon [name]=\"icons.CUBE\"></ion-icon>\n            <span>Distribution</span>\n          </ion-button>\n        </div>\n      </ion-card>\n    </div>\n\n    <!-- Infinite Scroll -->\n    <ion-infinite-scroll threshold=\"100px\" (ionInfinite)=\"loadMore($event)\" [disabled]=\"!hasMoreData\">\n      <ion-infinite-scroll-content\n        loadingSpinner=\"bubbles\"\n        loadingText=\"Loading more children...\">\n      </ion-infinite-scroll-content>\n    </ion-infinite-scroll>\n\n    <!-- End of list message -->\n    <ion-card *ngIf=\"!hasMoreData && filteredList?.length > 0\" class=\"end-message\">\n      <ion-card-content class=\"ion-text-center\">\n        <ion-text color=\"medium\">\n          <p>You've reached the end of the list ({{ totalItems }} total children)</p>\n        </ion-text>\n      </ion-card-content>\n    </ion-card>\n  </ng-container>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n\n  <!-- Floating Action Button for Add Child -->\n  <ion-fab slot=\"fixed\" vertical=\"bottom\" horizontal=\"end\" *ngIf=\"hasPermission('app-child-add')\">\n    <ion-fab-button [routerLink]=\"b.routesConfig.childAdd\" color=\"primary\">\n      <ion-icon [name]=\"icons.ADD\"></ion-icon>\n    </ion-fab-button>\n  </ion-fab>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_child-list_child-list_module_ts.js.map