(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_beneficiary-assessment_beneficiary-assessment_module_ts"],{

/***/ 30357:
/*!***************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-assessment/beneficiary-assessment-routing.module.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryAssessmentPageRoutingModule: () => (/* binding */ BeneficiaryAssessmentPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _beneficiary_assessment_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./beneficiary-assessment.page */ 58519);




const routes = [{
  path: '',
  component: _beneficiary_assessment_page__WEBPACK_IMPORTED_MODULE_0__.BeneficiaryAssessmentPage
}];
let BeneficiaryAssessmentPageRoutingModule = class BeneficiaryAssessmentPageRoutingModule {};
BeneficiaryAssessmentPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], BeneficiaryAssessmentPageRoutingModule);


/***/ }),

/***/ 82812:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/beneficiary-assessment/beneficiary-assessment.module.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryAssessmentPageModule: () => (/* binding */ BeneficiaryAssessmentPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _ngx_formly_ionic__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-formly/ionic */ 24295);
/* harmony import */ var _beneficiary_assessment_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./beneficiary-assessment-routing.module */ 30357);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _beneficiary_assessment_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./beneficiary-assessment.page */ 58519);










let BeneficiaryAssessmentPageModule = class BeneficiaryAssessmentPageModule {};
BeneficiaryAssessmentPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _beneficiary_assessment_routing_module__WEBPACK_IMPORTED_MODULE_0__.BeneficiaryAssessmentPageRoutingModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_8__.FormlyModule.forRoot(), _ngx_formly_ionic__WEBPACK_IMPORTED_MODULE_9__.FormlyIonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_1__.SharedModule],
  declarations: [_beneficiary_assessment_page__WEBPACK_IMPORTED_MODULE_2__.BeneficiaryAssessmentPage]
})], BeneficiaryAssessmentPageModule);


/***/ }),

/***/ 58519:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/beneficiary-assessment/beneficiary-assessment.page.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryAssessmentPage: () => (/* binding */ BeneficiaryAssessmentPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _beneficiary_assessment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./beneficiary-assessment.page.html?ngResource */ 29649);
/* harmony import */ var _beneficiary_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./beneficiary-assessment.page.scss?ngResource */ 53381);
/* harmony import */ var _beneficiary_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_beneficiary_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/survey_form_api.service */ 55856);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _components_report_modal_report_modal_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/report-modal/report-modal.component */ 69843);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _BeneficiaryAssessmentPage;











let BeneficiaryAssessmentPage = (_BeneficiaryAssessmentPage = class BeneficiaryAssessmentPage {
  constructor(b, activatedRoute, api, router, cdr, modalCtrl) {
    this.b = b;
    this.activatedRoute = activatedRoute;
    this.api = api;
    this.router = router;
    this.cdr = cdr;
    this.modalCtrl = modalCtrl;
    this.id = null;
    this.surveyBenificiaryResponse = null;
    this.beneficiary_info = null;
    this.beneficiary_id = null;
    this.survey_responses = [];
    this.survey_forms_to_fill = [];
    this.ongoing_assessments = [];
    this.required_assessments = [];
    this.type = '';
    this.backButtonUrl = '/home';
    this.fromAddPage = false;
    this.mandatoryFormActive = false;
    this.mandatoryFormId = null;
    this.timeoutIds = [];
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_7__.ICONS;
  }
  ngOnInit() {
    this.initializeRouteParams();
    this.setBackButtonUrl();
    if (this.id) {
      this.load(null);
    }
    this.handleFormCompletedParam();
  }
  ngOnDestroy() {
    this.clearAllTimeouts();
  }
  initializeRouteParams() {
    const snapshot = this.activatedRoute.snapshot;
    this.id = snapshot.paramMap.get('id');
    this.type = snapshot.paramMap.get('type') || '';
    const fromParam = snapshot.queryParamMap.get('from');
    this.fromAddPage = fromParam === 'child-add' || fromParam === 'woman-add';
  }
  setBackButtonUrl() {
    this.backButtonUrl = this.type === 'child' ? `/child-detail/${this.id}` : this.type === 'plw' ? `/woman-detail/${this.id}` : '/home';
  }
  handleFormCompletedParam() {
    const formCompleted = this.activatedRoute.snapshot.queryParamMap.get('formCompleted');
    if (formCompleted) {
      const timeoutId = window.setTimeout(() => {
        this.clearFormCompletedParam();
      }, 100);
      this.timeoutIds.push(timeoutId);
    }
  }
  clearAllTimeouts() {
    this.timeoutIds.forEach(id => window.clearTimeout(id));
    this.timeoutIds = [];
  }
  ionViewWillEnter() {
    // Check for formCompleted parameter when returning to this page
    const formCompleted = this.activatedRoute.snapshot.queryParamMap.get('formCompleted');
    if (formCompleted) {
      this.clearFormCompletedParam();
    }
    if (this.id) {
      this.load(null);
    }
    // Check if returning from a mandatory form completion
    this.checkMandatoryFormCompletion();
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (event = null) {
      try {
        var _this$surveyBenificia, _this$beneficiary_inf, _this$surveyBenificia2, _this$surveyBenificia3, _this$beneficiary_inf2, _this$beneficiary_inf3;
        if (!_this.id || !_this.type) {
          throw new Error('Missing required parameters: id or type');
        }
        _this.surveyBenificiaryResponse = (yield _this.api.getSurveyResponseData(_this.id, _this.type)).data;
        _this.beneficiary_info = ((_this$surveyBenificia = _this.surveyBenificiaryResponse) === null || _this$surveyBenificia === void 0 ? void 0 : _this$surveyBenificia.beneficiary_info) || null;
        _this.beneficiary_id = ((_this$beneficiary_inf = _this.beneficiary_info) === null || _this$beneficiary_inf === void 0 ? void 0 : _this$beneficiary_inf.id) || null;
        _this.survey_forms_to_fill = ((_this$surveyBenificia2 = _this.surveyBenificiaryResponse) === null || _this$surveyBenificia2 === void 0 ? void 0 : _this$surveyBenificia2.survey_form_to_fill) || [];
        _this.survey_responses = Array.isArray((_this$surveyBenificia3 = _this.surveyBenificiaryResponse) === null || _this$surveyBenificia3 === void 0 ? void 0 : _this$surveyBenificia3.survey_responses) ? _this.surveyBenificiaryResponse.survey_responses : [];
        // Separate ongoing and required assessments
        _this.ongoing_assessments = _this.survey_forms_to_fill.filter(form => form.is_ongoing);
        _this.required_assessments = _this.survey_forms_to_fill.filter(form => !form.is_ongoing);
        // Check for mandatory disability assessments if has_disability is null
        if (((_this$beneficiary_inf2 = _this.beneficiary_info) === null || _this$beneficiary_inf2 === void 0 ? void 0 : _this$beneficiary_inf2.has_disability) === null || ((_this$beneficiary_inf3 = _this.beneficiary_info) === null || _this$beneficiary_inf3 === void 0 ? void 0 : _this$beneficiary_inf3.has_disability) === undefined) {
          _this.checkMandatoryDisabilityAssessments();
        }
        // Trigger specific forms when coming from add pages
        if (_this.fromAddPage && _this.survey_forms_to_fill.length > 0) {
          _this.triggerFormsForAddPages();
          _this.clearAddPageRedirectState();
        }
        if (event && event.target) {
          const timeoutId = window.setTimeout(() => {
            event.target.complete();
          }, 2000);
          _this.timeoutIds.push(timeoutId);
        }
      } catch (error) {
        _this.b.errorToast('Error loading assessment data. Please try again.');
      }
    }).apply(this, arguments);
  }
  goToRapidForm(formId, responseId, assessmentMode) {
    const navigationState = {
      beneficiary_id: this.beneficiary_id,
      beneficiary_type: this.type
    };
    // Add mandatory form flag if this is a mandatory form
    if (this.mandatoryFormActive && this.mandatoryFormId === formId) {
      navigationState.mandatoryForm = true;
      navigationState.returnUrl = this.router.url;
    }
    // Add assessment mode if provided
    if (assessmentMode) {
      navigationState.assessmentMode = assessmentMode;
    }
    // If there's a response_id, navigate to edit the existing response
    if (responseId) {
      this.router.navigate(['/survey-form', responseId], {
        state: {
          ...navigationState,
          edit_mode: true,
          is_ongoing: true
        }
      });
    } else {
      // New assessment
      this.router.navigate(['/survey-form', formId], {
        state: navigationState
      });
    }
  }
  triggerFormsForAddPages() {
    // Find disability assessment forms instead of hardcoding form types
    const disabilityAssessments = this.survey_forms_to_fill.filter(form => form.is_disability_assessment);
    // If disability assessment forms are found, automatically navigate to the first one
    if (disabilityAssessments.length > 0) {
      const firstDisabilityForm = disabilityAssessments[0];
      this.setMandatoryForm(firstDisabilityForm);
      this.b.toast(`You must complete ${firstDisabilityForm.title} assessment before proceeding`, 3000, 'warning');
      const timeoutId = window.setTimeout(() => {
        this.goToRapidForm(firstDisabilityForm.id);
      }, 1500);
      this.timeoutIds.push(timeoutId);
    } else {
      // If no disability assessments found, use first available form
      const fallbackForm = this.survey_forms_to_fill[0];
      if (fallbackForm) {
        this.setMandatoryForm(fallbackForm);
        this.b.toast(`You must complete ${fallbackForm.title} assessment before proceeding`, 3000, 'warning');
        const timeoutId = window.setTimeout(() => {
          this.goToRapidForm(fallbackForm.id);
        }, 1500);
        this.timeoutIds.push(timeoutId);
      } else {
        // No suitable forms found at all
        this.b.toast(`No suitable assessment forms available for ${this.type}.`, 3000, 'warning');
      }
    }
  }
  setMandatoryForm(form) {
    this.mandatoryFormActive = true;
    this.mandatoryFormId = form.id;
  }
  clearMandatoryForm() {
    this.mandatoryFormActive = false;
    this.mandatoryFormId = null;
    this.cdr.detectChanges();
  }
  clearAddPageRedirectState() {
    this.fromAddPage = false;
    // Force update back button to correct location immediately
    const correctBackUrl = this.type === 'child' ? `/child-detail/${this.id}` : `/woman-detail/${this.id}`;
    this.backButtonUrl = correctBackUrl;
    // Clear the query parameters from the URL
    this.router.navigate([], {
      relativeTo: this.activatedRoute,
      queryParams: {},
      replaceUrl: true
    });
  }
  clearFormCompletedParam() {
    // Force clear mandatory form state immediately
    this.mandatoryFormActive = false;
    this.mandatoryFormId = null;
    this.fromAddPage = false;
    this.b.toast('Assessment completed!');
    // Force Angular to detect changes
    this.cdr.detectChanges();
    // Clear the formCompleted parameter from URL
    this.router.navigate([], {
      relativeTo: this.activatedRoute,
      queryParams: {
        formCompleted: null
      },
      queryParamsHandling: 'merge',
      replaceUrl: true
    });
  }
  checkMandatoryFormCompletion() {
    if (this.mandatoryFormActive && this.mandatoryFormId) {
      var _this$survey_response;
      // Check if the mandatory form has been completed
      const completedForm = (_this$survey_response = this.survey_responses) === null || _this$survey_response === void 0 ? void 0 : _this$survey_response.find(response => {
        var _response$survey_form;
        return ((_response$survey_form = response.survey_form) === null || _response$survey_form === void 0 ? void 0 : _response$survey_form.id) === this.mandatoryFormId;
      });
      if (completedForm) {
        this.clearMandatoryForm();
        this.b.toast('Assessment completed!');
      }
    }
  }
  checkMandatoryDisabilityAssessments() {
    // Find incomplete disability assessments
    const incompleteDisabilityAssessments = this.survey_forms_to_fill.filter(form => form.is_disability_assessment && !form.is_ongoing);
    // If there are incomplete mandatory disability assessments, force redirect to first one
    if (incompleteDisabilityAssessments.length > 0) {
      const firstMandatoryForm = incompleteDisabilityAssessments[0];
      this.setMandatoryForm(firstMandatoryForm);
      this.b.toast(`You must complete ${firstMandatoryForm.title} assessment to determine disability status`, 3000, 'warning');
      const timeoutId = window.setTimeout(() => {
        this.goToRapidForm(firstMandatoryForm.id);
      }, 1500);
      this.timeoutIds.push(timeoutId);
    }
  }
  goBack(event) {
    // Prevent default back button behavior
    event.preventDefault();
    event.stopPropagation();
    // Always navigate to the correct detail page
    const targetUrl = this.type === 'child' ? `/child-detail/${this.id}` : `/woman-detail/${this.id}`;
    this.router.navigateByUrl(targetUrl);
  }
  calculateAgeInMonths(dateOfBirth) {
    if (!dateOfBirth) {
      return 0;
    }
    const today = new Date();
    const birthDate = new Date(dateOfBirth);
    const months = (today.getFullYear() - birthDate.getFullYear()) * 12 + (today.getMonth() - birthDate.getMonth());
    return months;
  }
  getAgeDisplay(dateOfBirth) {
    const months = this.calculateAgeInMonths(dateOfBirth);
    // For PLW, show age in years
    if (this.type === 'plw') {
      const years = Math.floor(months / 12);
      return `${years} years`;
    }
    // For children, show age in months
    return `${months} months`;
  }
  displayProgrammeCard(responseId) {
    const token = localStorage.getItem('token');
    if (!token) return;
    const fullUrl = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_5__.hostLocal}/programme-card/${responseId}?api_token=${token}`;
    this.modalCtrl.create({
      component: _components_report_modal_report_modal_component__WEBPACK_IMPORTED_MODULE_6__.ReportModalComponent,
      componentProps: {
        url: fullUrl,
        title: 'Programme Card'
      },
      cssClass: 'report-modal-fullscreen'
    }).then(modal => modal.present());
  }
  hasProgrammeTag(form) {
    var _form$tags;
    return form === null || form === void 0 || (_form$tags = form.tags) === null || _form$tags === void 0 ? void 0 : _form$tags.includes('programme');
  }
  getLastVisitData(form) {
    var _form$response;
    if (!form.is_ongoing || !((_form$response = form.response) !== null && _form$response !== void 0 && _form$response.follow_up_visits) || form.response.follow_up_visits.length === 0) {
      return {
        date: null,
        next_visit_date: null,
        current_visit_no: null,
        next_visit_no: null
      };
    }
    // Get the last visit from the follow_up_visits array in form.response
    const lastVisit = form.response.follow_up_visits[form.response.follow_up_visits.length - 1];
    return {
      date: lastVisit.date || null,
      next_visit_date: lastVisit.next_date || null,
      current_visit_no: lastVisit.current_visit_no || null,
      next_visit_no: lastVisit.next_visit_no || null
    };
  }
  getFollowupButtonText(form) {
    var _this$surveyBenificia4;
    if (!form.is_follow_up_assessment) {
      return 'Follow-up';
    }
    // Check if maximum follow-ups reached
    if (this.hasReachedMaxFollowups(form)) {
      return 'Maximum Followup Reached';
    }
    const lastVisitData = this.getLastVisitData(form);
    const lastFollowupDate = lastVisitData.date;
    const lastMeasurementDate = (_this$surveyBenificia4 = this.surveyBenificiaryResponse) === null || _this$surveyBenificia4 === void 0 || (_this$surveyBenificia4 = _this$surveyBenificia4.last_measurement) === null || _this$surveyBenificia4 === void 0 ? void 0 : _this$surveyBenificia4.date;
    // If both dates exist and they are the same, show "Update Last Follow-up"
    if (lastFollowupDate && lastMeasurementDate) {
      // Compare dates (normalize to YYYY-MM-DD format for comparison)
      const followupDateStr = new Date(lastFollowupDate).toISOString().split('T')[0];
      const measurementDateStr = new Date(lastMeasurementDate).toISOString().split('T')[0];
      if (followupDateStr === measurementDateStr) {
        return 'Update Last Follow-up';
      }
    }
    return 'Follow-up';
  }
  /**
   * Check if the maximum follow-up visit limit (13) has been reached
   */
  hasReachedMaxFollowups(form) {
    var _form$response2;
    const MAX_FOLLOWUP_VISITS = 13;
    if (!form.is_follow_up_assessment || !((_form$response2 = form.response) !== null && _form$response2 !== void 0 && _form$response2.follow_up_visits)) {
      return false;
    }
    const lastVisitData = this.getLastVisitData(form);
    const currentVisitNo = lastVisitData.current_visit_no;
    return currentVisitNo >= MAX_FOLLOWUP_VISITS;
  }
}, _BeneficiaryAssessmentPage.ctorParameters = () => [{
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.ActivatedRoute
}, {
  type: src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_3__.SurveyFormAPIService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.Router
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_9__.ChangeDetectorRef
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.ModalController
}], _BeneficiaryAssessmentPage);
BeneficiaryAssessmentPage = (0,tslib__WEBPACK_IMPORTED_MODULE_11__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_9__.Component)({
  selector: 'app-beneficiary-assessment',
  template: _beneficiary_assessment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_beneficiary_assessment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], BeneficiaryAssessmentPage);


/***/ }),

/***/ 53381:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-assessment/beneficiary-assessment.page.scss?ngResource ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.disabled {
  pointer-events: none;
  opacity: 0.5;
}

.mandatory-form {
  background-color: var(--ion-color-warning) !important;
  color: white !important;
  font-weight: bold !important;
  border-radius: 8px !important;
}

.mandatory-row {
  background-color: rgba(255, 193, 7, 0.05) !important;
  border-left: 4px solid var(--ion-color-warning) !important;
  transition: all 0.2s ease;
}
.mandatory-row td {
  font-weight: 600 !important;
}
.mandatory-row:hover {
  background-color: rgba(255, 193, 7, 0.08) !important;
}

ion-item[color=warning] {
  --background: rgba(255, 193, 7, 0.1);
  --border-color: var(--ion-color-warning);
  border-left: 4px solid var(--ion-color-warning);
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.child-info-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.child-info-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.child-info-card .info-item:last-child {
  margin-bottom: 0;
}
.child-info-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.child-info-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
  margin-inline-end: 0 !important;
}

.child-info-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.child-info-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
  display: flex;
  align-items: center;
  flex-wrap: wrap;
  gap: 6px;
}
.child-info-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.verified-badge-inline {
  font-size: 11px;
  font-weight: 600;
  padding: 3px 8px;
  border-radius: 12px;
  display: inline-flex;
  align-items: center;
  gap: 3px;
  vertical-align: middle;
  margin-left: 4px;
}
.verified-badge-inline ion-icon {
  font-size: 12px;
  margin-inline-end: 0 !important;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}
.section-header ion-button {
  flex-shrink: 0;
  height: 44px;
  --padding-start: 16px;
  --padding-end: 16px;
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  transition: all 0.3s ease;
}
.section-header ion-button:hover {
  transform: translateY(-2px);
  --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
}
.section-header ion-button ion-icon {
  font-size: 18px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.form-item {
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.form-item:hover {
  background: rgba(73, 144, 226, 0.02);
}

.form-number {
  width: 32px;
  height: 32px;
  border-radius: 16px;
  background: var(--ion-color-primary);
  color: white;
  display: flex;
  align-items: center;
  justify-content: center;
  font-weight: 600;
  font-size: 14px;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  transition: all 0.3s ease;
}
.form-number.ongoing-form {
  background: var(--ion-color-tertiary);
  animation: pulse 2s infinite;
}

@keyframes pulse {
  0%, 100% {
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  }
  50% {
    box-shadow: 0 2px 12px rgba(255, 138, 101, 0.4);
  }
}
.completed-item {
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.completed-item:hover {
  background: rgba(73, 144, 226, 0.02);
}

.last-update {
  font-size: 12px;
  color: var(--ion-color-medium);
  margin-top: 4px;
  display: flex;
  align-items: center;
  gap: 4px;
}

.last-update ion-icon {
  font-size: 12px;
}

.action-buttons {
  display: flex;
  gap: 4px;
  align-items: center;
}

.action-buttons ion-button {
  --padding-start: 8px;
  --padding-end: 8px;
  --padding-top: 6px;
  --padding-bottom: 6px;
  height: 32px;
  width: 32px;
  transition: all 0.2s ease;
}
.action-buttons ion-button:hover {
  transform: translateY(-1px);
}

.action-buttons ion-button ion-icon {
  font-size: 16px;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 300px;
}

.remarks-container {
  margin-top: 12px;
  padding: 12px;
  background: rgba(73, 144, 226, 0.05);
  border-radius: 8px;
  border-left: 3px solid var(--ion-color-primary);
  transition: all 0.2s ease;
}
.remarks-container:hover {
  background: rgba(73, 144, 226, 0.08);
}

.remarks-title {
  display: flex;
  align-items: center;
  gap: 6px;
  font-size: 13px;
  font-weight: 600;
  color: var(--ion-color-primary);
  margin: 0 0 6px 0;
}

.remarks-title ion-icon {
  font-size: 14px;
}

.remarks-text {
  font-size: 13px;
  color: var(--ion-color-dark);
  margin: 0;
  line-height: 1.5;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .child-info-card .profile-content {
    padding: 16px;
  }
  .child-info-card .content-grid ion-col {
    padding: 0 3px;
  }
  .child-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .child-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .child-info-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .child-info-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .child-info-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .child-info-card .item-content .value {
    font-size: 13px;
  }
  .verified-badge-inline {
    font-size: 10px;
    padding: 2px 6px;
  }
  .verified-badge-inline ion-icon {
    font-size: 11px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .section-header ion-button {
    height: 40px;
    font-size: 13px;
    --padding-start: 12px;
    --padding-end: 12px;
  }
  .section-header ion-button ion-icon {
    font-size: 16px;
  }
  .form-number {
    width: 28px;
    height: 28px;
    font-size: 12px;
  }
  .empty-state {
    padding: 30px 16px;
  }
  .action-buttons {
    flex-direction: column;
    gap: 2px;
  }
}
.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 0;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 100%;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 6px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: normal;
  word-wrap: break-word;
}
.measurements-table td {
  padding: 10px 6px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table td.date-cell {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: left;
}
.measurements-table td.actions-cell {
  white-space: nowrap;
  padding: 10px 2px;
}
.measurements-table td.actions-cell ion-button {
  margin: 0 1px;
  --padding-start: 4px;
  --padding-end: 4px;
}
.measurements-table td.actions-cell div {
  display: flex;
  gap: 4px;
  justify-content: center;
  align-items: center;
}
.measurements-table td.actions-cell .disabled-text {
  color: var(--ion-color-medium);
  font-size: 0.9rem;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .child-info-card .profile-content {
    padding: 12px;
  }
  .child-info-card .content-grid ion-col {
    padding: 0 2px;
  }
  .child-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 4px;
  }
  .child-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 4px;
  }
  .child-info-card .info-item {
    padding: 8px 4px;
    gap: 8px;
    margin-bottom: 5px;
  }
  .child-info-card .info-item ion-icon {
    font-size: 14px;
    width: 16px;
  }
  .child-info-card .item-content .label {
    font-size: 9px;
    letter-spacing: 0.2px;
  }
  .child-info-card .item-content .value {
    font-size: 12px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
    flex-wrap: wrap;
  }
  .section-header .section-title {
    font-size: 16px;
    flex: 1 1 100%;
    justify-content: flex-start;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .section-header ion-button {
    flex: 1 1 100%;
    height: 40px;
    font-size: 13px;
    --padding-start: 12px;
    --padding-end: 12px;
  }
  .section-header ion-button ion-icon {
    font-size: 16px;
  }
  .followup-actions {
    flex-wrap: wrap;
  }
  .followup-actions ion-button {
    flex: 1 1 calc(50% - 4px);
    min-width: 140px;
  }
}
.followup-card {
  margin-bottom: 16px;
  border-left: 4px solid var(--ion-color-tertiary);
  transition: all 0.3s ease;
}
.followup-card:hover {
  transform: translateY(-2px);
  box-shadow: 0 12px 24px rgba(0, 0, 0, 0.12);
}
.followup-card ion-card-header {
  padding: 16px;
  background: linear-gradient(135deg, rgba(var(--ion-color-tertiary-rgb), 0.05) 0%, rgba(var(--ion-color-tertiary-rgb), 0.02) 100%);
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}
.followup-card ion-card-content {
  padding: 16px;
}

.followup-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 12px;
}

.followup-title-section {
  display: flex;
  align-items: center;
  gap: 12px;
  flex: 1;
}
.followup-title-section > ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.followup-title-text {
  display: flex;
  flex-direction: column;
  gap: 6px;
}
.followup-title-text h3 {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.followup-title-text ion-badge {
  align-self: flex-start;
  font-size: 11px;
  font-weight: 600;
  padding: 4px 10px;
}

.followup-details {
  margin-bottom: 16px;
}
.followup-details ion-grid {
  padding: 0;
}
.followup-details ion-row {
  margin: 0 -4px;
}
.followup-details ion-col {
  padding: 4px;
}

.detail-item {
  display: flex;
  align-items: flex-start;
  gap: 10px;
  padding: 12px;
  background: rgba(255, 255, 255, 0.8);
  border: 1px solid rgba(0, 0, 0, 0.08);
  border-radius: 8px;
  height: 100%;
  transition: all 0.2s ease;
}
.detail-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.detail-item ion-icon {
  font-size: 20px;
  flex-shrink: 0;
  margin-top: 2px;
}

.detail-content {
  display: flex;
  flex-direction: column;
  gap: 4px;
  flex: 1;
  min-width: 0;
}

.detail-label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
}

.detail-value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  word-wrap: break-word;
}

.followup-actions {
  display: flex;
  gap: 8px;
  flex-wrap: wrap;
  padding-top: 8px;
  border-top: 1px solid rgba(0, 0, 0, 0.06);
}
.followup-actions ion-button {
  flex: 0 1 auto;
  --border-radius: 8px;
  font-weight: 600;
  text-transform: none;
  font-size: 13px;
  height: 36px;
  transition: all 0.2s ease;
}
.followup-actions ion-button:hover {
  transform: translateY(-1px);
}
.followup-actions ion-button ion-icon {
  font-size: 16px;
}

@media (max-width: 768px) {
  .followup-card ion-card-header {
    padding: 12px;
  }
  .followup-card ion-card-content {
    padding: 12px;
  }
  .followup-title-section > ion-icon {
    font-size: 24px;
  }
  .followup-title-text h3 {
    font-size: 16px;
  }
  .followup-title-text ion-badge {
    font-size: 10px;
    padding: 3px 8px;
  }
  .detail-item {
    padding: 10px;
  }
  .detail-item ion-icon {
    font-size: 18px;
  }
  .detail-label {
    font-size: 10px;
  }
  .detail-value {
    font-size: 13px;
  }
  .followup-actions ion-button {
    font-size: 12px;
    height: 34px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/beneficiary-assessment/beneficiary-assessment.page.scss"],"names":[],"mappings":"AACA;EACE,oBAAA;EACA,YAAA;AAAF;;AAGA;EACE,qDAAA;EACA,uBAAA;EACA,4BAAA;EACA,6BAAA;AAAF;;AAGA;EACE,oDAAA;EACA,0DAAA;EACA,yBAAA;AAAF;AAEE;EACE,2BAAA;AAAJ;AAGE;EACE,oDAAA;AADJ;;AAKA;EACE,oCAAA;EACA,wCAAA;EACA,+CAAA;AAFF;;AAMA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AAHF;;AAMA;EACE,gBAAA;EACA,wBAAA;AAHF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AAHF;;AAOA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAJF;AAME;EACE,eAAA;EACA,cAAA;AAJJ;;AASA;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AANF;;AASA;EACE,aAAA;AANF;;AASA;EACE,UAAA;EACA,SAAA;AANF;AAQE;EACE,SAAA;AANJ;AASE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAPJ;AASI;EACE,eAAA;EACA,kBAAA;AAPN;AAUI;EACE,gBAAA;EACA,iBAAA;AARN;;AAaA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAVF;AAYE;EACE,gBAAA;AAVJ;AAaE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAXJ;AAcE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;EACA,+BAAA;AAZJ;;AAgBA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAbF;AAeE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AAbJ;AAgBE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;EACA,aAAA;EACA,mBAAA;EACA,eAAA;EACA,QAAA;AAdJ;AAgBI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AAdN;;AAoBA;EACE,eAAA;EACA,gBAAA;EACA,gBAAA;EACA,mBAAA;EACA,oBAAA;EACA,mBAAA;EACA,QAAA;EACA,sBAAA;EACA,gBAAA;AAjBF;AAmBE;EACE,eAAA;EACA,+BAAA;AAjBJ;;AAsBA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AAnBF;AAqBE;EACE,cAAA;EACA,YAAA;EACA,qBAAA;EACA,mBAAA;EACA,qBAAA;EACA,2CAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,yBAAA;AAnBJ;AAqBI;EACE,2BAAA;EACA,4CAAA;AAnBN;AAsBI;EACE,eAAA;AApBN;;AAyBA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,OAAA;EACA,YAAA;AAtBF;AAwBE;EACE,eAAA;EACA,cAAA;AAtBJ;;AA2BA;EACE,kBAAA;EACA,yBAAA;AAxBF;AA0BE;EACE,oCAAA;AAxBJ;;AA4BA;EACE,WAAA;EACA,YAAA;EACA,mBAAA;EACA,oCAAA;EACA,YAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,gBAAA;EACA,eAAA;EACA,yCAAA;EACA,yBAAA;AAzBF;AA2BE;EACE,qCAAA;EACA,4BAAA;AAzBJ;;AA6BA;EACE;IACE,yCAAA;EA1BF;EA4BA;IACE,+CAAA;EA1BF;AACF;AA8BA;EACE,kBAAA;EACA,yBAAA;AA5BF;AA8BE;EACE,oCAAA;AA5BJ;;AAgCA;EACE,eAAA;EACA,8BAAA;EACA,eAAA;EACA,aAAA;EACA,mBAAA;EACA,QAAA;AA7BF;;AAgCA;EACE,eAAA;AA7BF;;AAiCA;EACE,aAAA;EACA,QAAA;EACA,mBAAA;AA9BF;;AAiCA;EACE,oBAAA;EACA,kBAAA;EACA,kBAAA;EACA,qBAAA;EACA,YAAA;EACA,WAAA;EACA,yBAAA;AA9BF;AAgCE;EACE,2BAAA;AA9BJ;;AAkCA;EACE,eAAA;AA/BF;;AAmCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAhCF;AAkCE;EACE,eAAA;EACA,mBAAA;AAhCJ;AAmCE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AAjCJ;AAoCE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AAlCJ;;AAuCA;EACE,gBAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,+CAAA;EACA,yBAAA;AApCF;AAsCE;EACE,oCAAA;AApCJ;;AAwCA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,iBAAA;AArCF;;AAwCA;EACE,eAAA;AArCF;;AAwCA;EACE,eAAA;EACA,4BAAA;EACA,SAAA;EACA,gBAAA;AArCF;;AAyCA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EAtCF;EAyCA;IACE,mBAAA;EAvCF;EA0CA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EAxCF;EA2CA;IACE,eAAA;IACA,WAAA;EAzCF;EA2CE;IACE,eAAA;EAzCJ;EA8CE;IACE,aAAA;EA5CJ;EAgDI;IACE,cAAA;EA9CN;EAgDM;IACE,eAAA;IACA,kBAAA;EA9CR;EAiDM;IACE,gBAAA;IACA,iBAAA;EA/CR;EAoDE;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAlDJ;EAoDI;IACE,eAAA;IACA,WAAA;EAlDN;EAuDI;IACE,eAAA;IACA,qBAAA;EArDN;EAwDI;IACE,eAAA;EAtDN;EA2DA;IACE,eAAA;IACA,gBAAA;EAzDF;EA2DE;IACE,eAAA;EAzDJ;EA6DA;IACE,cAAA;IACA,SAAA;EA3DF;EA6DE;IACE,eAAA;EA3DJ;EA6DI;IACE,eAAA;EA3DN;EA+DE;IACE,YAAA;IACA,eAAA;IACA,qBAAA;IACA,mBAAA;EA7DJ;EA+DI;IACE,eAAA;EA7DN;EAkEA;IACE,WAAA;IACA,YAAA;IACA,eAAA;EAhEF;EAmEA;IACE,kBAAA;EAjEF;EAoEA;IACE,sBAAA;IACA,QAAA;EAlEF;AACF;AAsEA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,aAAA;AApEF;;AAuEA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;AApEF;AAsEE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;EACA,qBAAA;AApEJ;AAuEE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AArEJ;AAuEI;EACE,gBAAA;EACA,+BAAA;EACA,gBAAA;AArEN;AAwEI;EACE,mBAAA;EACA,iBAAA;AAtEN;AAwEM;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AAtER;AAyEM;EACE,aAAA;EACA,QAAA;EACA,uBAAA;EACA,mBAAA;AAvER;AA0EM;EACE,8BAAA;EACA,iBAAA;AAxER;AA6EE;EACE,yBAAA;AA3EJ;AA6EI;EACE,6CAAA;AA3EN;AA+EE;EACE,mBAAA;AA7EJ;;AAiFA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EA9EF;EAiFA;IACE,mBAAA;EA/EF;EAkFA;IACE,mBAAA;EAhFF;EAmFA;IACE,eAAA;EAjFF;EAmFE;IACE,eAAA;EAjFJ;EAsFE;IACE,aAAA;EApFJ;EAwFI;IACE,cAAA;EAtFN;EAwFM;IACE,eAAA;IACA,kBAAA;EAtFR;EAyFM;IACE,gBAAA;IACA,iBAAA;EAvFR;EA4FE;IACE,gBAAA;IACA,QAAA;IACA,kBAAA;EA1FJ;EA4FI;IACE,eAAA;IACA,WAAA;EA1FN;EA+FI;IACE,cAAA;IACA,qBAAA;EA7FN;EAgGI;IACE,eAAA;EA9FN;EAmGA;IACE,cAAA;IACA,QAAA;IACA,eAAA;EAjGF;EAmGE;IACE,eAAA;IACA,cAAA;IACA,2BAAA;EAjGJ;EAmGI;IACE,eAAA;EAjGN;EAqGE;IACE,cAAA;IACA,YAAA;IACA,eAAA;IACA,qBAAA;IACA,mBAAA;EAnGJ;EAqGI;IACE,eAAA;EAnGN;EAwGA;IACE,eAAA;EAtGF;EAwGE;IACE,yBAAA;IACA,gBAAA;EAtGJ;AACF;AA2GA;EACE,mBAAA;EACA,gDAAA;EACA,yBAAA;AAzGF;AA2GE;EACE,2BAAA;EACA,2CAAA;AAzGJ;AA4GE;EACE,aAAA;EACA,iIAAA;EACA,4CAAA;AA1GJ;AA6GE;EACE,aAAA;AA3GJ;;AA+GA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;AA5GF;;AA+GA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,OAAA;AA5GF;AA8GE;EACE,eAAA;EACA,cAAA;AA5GJ;;AAgHA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AA7GF;AA+GE;EACE,SAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;AA7GJ;AAgHE;EACE,sBAAA;EACA,eAAA;EACA,gBAAA;EACA,iBAAA;AA9GJ;;AAkHA;EACE,mBAAA;AA/GF;AAiHE;EACE,UAAA;AA/GJ;AAkHE;EACE,cAAA;AAhHJ;AAmHE;EACE,YAAA;AAjHJ;;AAqHA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,aAAA;EACA,oCAAA;EACA,qCAAA;EACA,kBAAA;EACA,YAAA;EACA,yBAAA;AAlHF;AAoHE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAlHJ;AAqHE;EACE,eAAA;EACA,cAAA;EACA,eAAA;AAnHJ;;AAuHA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;AApHF;;AAuHA;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;AApHF;;AAuHA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,qBAAA;AApHF;;AAuHA;EACE,aAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,yCAAA;AApHF;AAsHE;EACE,cAAA;EACA,oBAAA;EACA,gBAAA;EACA,oBAAA;EACA,eAAA;EACA,YAAA;EACA,yBAAA;AApHJ;AAsHI;EACE,2BAAA;AApHN;AAuHI;EACE,eAAA;AArHN;;AA0HA;EAEI;IACE,aAAA;EAxHJ;EA2HE;IACE,aAAA;EAzHJ;EA8HE;IACE,eAAA;EA5HJ;EAiIE;IACE,eAAA;EA/HJ;EAkIE;IACE,eAAA;IACA,gBAAA;EAhIJ;EAoIA;IACE,aAAA;EAlIF;EAoIE;IACE,eAAA;EAlIJ;EAsIA;IACE,eAAA;EApIF;EAuIA;IACE,eAAA;EArIF;EAyIE;IACE,eAAA;IACA,YAAA;EAvIJ;AACF","sourcesContent":["// Component-specific styles\n.disabled {\n  pointer-events: none;\n  opacity: 0.5;\n}\n\n.mandatory-form {\n  background-color: var(--ion-color-warning) !important;\n  color: white !important;\n  font-weight: bold !important;\n  border-radius: 8px !important;\n}\n\n.mandatory-row {\n  background-color: rgba(255, 193, 7, 0.05) !important;\n  border-left: 4px solid var(--ion-color-warning) !important;\n  transition: all 0.2s ease;\n\n  td {\n    font-weight: 600 !important;\n  }\n\n  &:hover {\n    background-color: rgba(255, 193, 7, 0.08) !important;\n  }\n}\n\nion-item[color=\"warning\"] {\n  --background: rgba(255, 193, 7, 0.1);\n  --border-color: var(--ion-color-warning);\n  border-left: 4px solid var(--ion-color-warning);\n}\n\n// Main container (matching child-detail)\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header (matching child-detail)\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n// Child/Beneficiary Information Card (matching child-detail)\n.child-info-card {\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n  overflow: hidden;\n  margin: 0;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.child-info-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n    margin-inline-end: 0 !important;\n  }\n}\n\n.child-info-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n    display: flex;\n    align-items: center;\n    flex-wrap: wrap;\n    gap: 6px;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Verified Badge Inline Styles\n.verified-badge-inline {\n  font-size: 11px;\n  font-weight: 600;\n  padding: 3px 8px;\n  border-radius: 12px;\n  display: inline-flex;\n  align-items: center;\n  gap: 3px;\n  vertical-align: middle;\n  margin-left: 4px;\n\n  ion-icon {\n    font-size: 12px;\n    margin-inline-end: 0 !important;\n  }\n}\n\n// Section Header (matching child-detail)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n\n  ion-button {\n    flex-shrink: 0;\n    height: 44px;\n    --padding-start: 16px;\n    --padding-end: 16px;\n    --border-radius: 12px;\n    --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    font-size: 14px;\n    font-weight: 600;\n    text-transform: none;\n    transition: all 0.3s ease;\n\n    &:hover {\n      transform: translateY(-2px);\n      --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);\n    }\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Form Item Styles\n.form-item {\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.02);\n  }\n}\n\n.form-number {\n  width: 32px;\n  height: 32px;\n  border-radius: 16px;\n  background: var(--ion-color-primary);\n  color: white;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  font-weight: 600;\n  font-size: 14px;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);\n  transition: all 0.3s ease;\n\n  &.ongoing-form {\n    background: var(--ion-color-tertiary);\n    animation: pulse 2s infinite;\n  }\n}\n\n@keyframes pulse {\n  0%, 100% {\n    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);\n  }\n  50% {\n    box-shadow: 0 2px 12px rgba(255, 138, 101, 0.4);\n  }\n}\n\n// Completed Item Styles\n.completed-item {\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.02);\n  }\n}\n\n.last-update {\n  font-size: 12px;\n  color: var(--ion-color-medium);\n  margin-top: 4px;\n  display: flex;\n  align-items: center;\n  gap: 4px;\n}\n\n.last-update ion-icon {\n  font-size: 12px;\n}\n\n// Action Buttons Container\n.action-buttons {\n  display: flex;\n  gap: 4px;\n  align-items: center;\n}\n\n.action-buttons ion-button {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  --padding-top: 6px;\n  --padding-bottom: 6px;\n  height: 32px;\n  width: 32px;\n  transition: all 0.2s ease;\n\n  &:hover {\n    transform: translateY(-1px);\n  }\n}\n\n.action-buttons ion-button ion-icon {\n  font-size: 16px;\n}\n\n// Empty State (matching child-detail)\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 300px;\n  }\n}\n\n// Remarks Container Styles\n.remarks-container {\n  margin-top: 12px;\n  padding: 12px;\n  background: rgba(73, 144, 226, 0.05);\n  border-radius: 8px;\n  border-left: 3px solid var(--ion-color-primary);\n  transition: all 0.2s ease;\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.08);\n  }\n}\n\n.remarks-title {\n  display: flex;\n  align-items: center;\n  gap: 6px;\n  font-size: 13px;\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  margin: 0 0 6px 0;\n}\n\n.remarks-title ion-icon {\n  font-size: 14px;\n}\n\n.remarks-text {\n  font-size: 13px;\n  color: var(--ion-color-dark);\n  margin: 0;\n  line-height: 1.5;\n}\n\n// Mobile Responsive Design (matching child-detail)\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .child-info-card {\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n\n  .verified-badge-inline {\n    font-size: 10px;\n    padding: 2px 6px;\n\n    ion-icon {\n      font-size: 11px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n\n    ion-button {\n      height: 40px;\n      font-size: 13px;\n      --padding-start: 12px;\n      --padding-end: 12px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .form-number {\n    width: 28px;\n    height: 28px;\n    font-size: 12px;\n  }\n\n  .empty-state {\n    padding: 30px 16px;\n  }\n\n  .action-buttons {\n    flex-direction: column;\n    gap: 2px;\n  }\n}\n\n// Table Styles (matching child-detail exactly)\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 0;\n}\n\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 100%; // Changed from 600px to fit viewport\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 6px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: normal; // Changed from nowrap to allow text wrapping\n    word-wrap: break-word;\n  }\n\n  td {\n    padding: 10px 6px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n\n    &.date-cell {\n      font-weight: 600;\n      color: var(--ion-color-primary);\n      text-align: left;\n    }\n\n    &.actions-cell {\n      white-space: nowrap;\n      padding: 10px 2px;\n\n      ion-button {\n        margin: 0 1px;\n        --padding-start: 4px;\n        --padding-end: 4px;\n      }\n\n      div {\n        display: flex;\n        gap: 4px;\n        justify-content: center;\n        align-items: center;\n      }\n\n      .disabled-text {\n        color: var(--ion-color-medium);\n        font-size: 0.9rem;\n      }\n    }\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .child-info-card {\n    .profile-content {\n      padding: 12px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 2px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 4px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 4px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 8px 4px;\n      gap: 8px;\n      margin-bottom: 5px;\n\n      ion-icon {\n        font-size: 14px;\n        width: 16px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 9px;\n        letter-spacing: 0.2px;\n      }\n\n      .value {\n        font-size: 12px;\n      }\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n    flex-wrap: wrap;\n\n    .section-title {\n      font-size: 16px;\n      flex: 1 1 100%;\n      justify-content: flex-start;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n\n    ion-button {\n      flex: 1 1 100%;\n      height: 40px;\n      font-size: 13px;\n      --padding-start: 12px;\n      --padding-end: 12px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .followup-actions {\n    flex-wrap: wrap;\n\n    ion-button {\n      flex: 1 1 calc(50% - 4px);\n      min-width: 140px;\n    }\n  }\n}\n\n// Followup Card Styles\n.followup-card {\n  margin-bottom: 16px;\n  border-left: 4px solid var(--ion-color-tertiary);\n  transition: all 0.3s ease;\n\n  &:hover {\n    transform: translateY(-2px);\n    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.12);\n  }\n\n  ion-card-header {\n    padding: 16px;\n    background: linear-gradient(135deg, rgba(var(--ion-color-tertiary-rgb), 0.05) 0%, rgba(var(--ion-color-tertiary-rgb), 0.02) 100%);\n    border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n  }\n\n  ion-card-content {\n    padding: 16px;\n  }\n}\n\n.followup-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 12px;\n}\n\n.followup-title-section {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n  flex: 1;\n\n  > ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.followup-title-text {\n  display: flex;\n  flex-direction: column;\n  gap: 6px;\n\n  h3 {\n    margin: 0;\n    font-size: 18px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n  }\n\n  ion-badge {\n    align-self: flex-start;\n    font-size: 11px;\n    font-weight: 600;\n    padding: 4px 10px;\n  }\n}\n\n.followup-details {\n  margin-bottom: 16px;\n\n  ion-grid {\n    padding: 0;\n  }\n\n  ion-row {\n    margin: 0 -4px;\n  }\n\n  ion-col {\n    padding: 4px;\n  }\n}\n\n.detail-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 10px;\n  padding: 12px;\n  background: rgba(255, 255, 255, 0.8);\n  border: 1px solid rgba(0, 0, 0, 0.08);\n  border-radius: 8px;\n  height: 100%;\n  transition: all 0.2s ease;\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 20px;\n    flex-shrink: 0;\n    margin-top: 2px;\n  }\n}\n\n.detail-content {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n  flex: 1;\n  min-width: 0;\n}\n\n.detail-label {\n  font-size: 11px;\n  font-weight: 600;\n  color: var(--ion-color-medium);\n  text-transform: uppercase;\n  letter-spacing: 0.5px;\n}\n\n.detail-value {\n  font-size: 14px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  word-wrap: break-word;\n}\n\n.followup-actions {\n  display: flex;\n  gap: 8px;\n  flex-wrap: wrap;\n  padding-top: 8px;\n  border-top: 1px solid rgba(0, 0, 0, 0.06);\n\n  ion-button {\n    flex: 0 1 auto;\n    --border-radius: 8px;\n    font-weight: 600;\n    text-transform: none;\n    font-size: 13px;\n    height: 36px;\n    transition: all 0.2s ease;\n\n    &:hover {\n      transform: translateY(-1px);\n    }\n\n    ion-icon {\n      font-size: 16px;\n    }\n  }\n}\n\n@media (max-width: 768px) {\n  .followup-card {\n    ion-card-header {\n      padding: 12px;\n    }\n\n    ion-card-content {\n      padding: 12px;\n    }\n  }\n\n  .followup-title-section {\n    > ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .followup-title-text {\n    h3 {\n      font-size: 16px;\n    }\n\n    ion-badge {\n      font-size: 10px;\n      padding: 3px 8px;\n    }\n  }\n\n  .detail-item {\n    padding: 10px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .detail-label {\n    font-size: 10px;\n  }\n\n  .detail-value {\n    font-size: 13px;\n  }\n\n  .followup-actions {\n    ion-button {\n      font-size: 12px;\n      height: 34px;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 29649:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-assessment/beneficiary-assessment.page.html?ngResource ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button defaultHref=\"/home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ type === 'child' ? 'Child' : type === 'plw' ? 'Mother' : (type | titlecase) }} Services</ion-title>\n    <ion-chip *ngIf=\"mandatoryFormActive\" color=\"warning\" slot=\"end\">\n      <ion-icon [name]=\"icons.LOCK_CLOSED\"></ion-icon>\n      <ion-label>Required</ion-label>\n    </ion-chip>\n  </ion-toolbar>\n</ion-header>\n\n\n<ion-content class=\"ion-padding\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"load($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n  <div class=\"card-container\">\n    <!-- Main Section Header -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"type === 'child' ? icons.PERSON : icons.WOMAN\" color=\"primary\"></ion-icon>\n        {{ type === 'child' ? 'Child' : type === 'plw' ? 'Mother' : (type | titlecase) }} Basic Information\n      </h2>\n    </div>\n\n    <!-- Beneficiary Information Card -->\n    <ion-card class=\"child-info-card\">\n      <ion-card-content>\n        <div class=\"profile-content\">\n          <ion-grid class=\"content-grid\">\n            <ion-row>\n              <!-- Left Column -->\n              <ion-col size=\"6\">\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.PERSON_CIRCLE\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">{{ type === 'child' ? 'Child Name' : 'Mother Name' }}</span>\n                    <span class=\"value\">{{ beneficiary_info?.name || '-' }}\n                      <ion-badge color=\"success\" class=\"verified-badge-inline\" *ngIf=\"beneficiary_info?.verified === 1\">\n                        <ion-icon [name]=\"icons.SHIELD_CHECKMARK\"></ion-icon>\n                        Verified\n                      </ion-badge>\n                    </span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\" *ngIf=\"type === 'child'\">\n                  <ion-icon [name]=\"icons.MALE_FEMALE\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Gender</span>\n                    <span class=\"value\">{{ beneficiary_info?.gender || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.ID_CARD\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Progress ID</span>\n                    <span class=\"value\">{{ beneficiary_info?.progress_id || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.DOCUMENT_TEXT\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">FCN</span>\n                    <span class=\"value\">{{ beneficiary_info?.fcn || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.CALENDAR\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Date of Birth</span>\n                    <span class=\"value\">{{ beneficiary_info?.date_of_birth | date:'dd MMM yyyy' || beneficiary_info?.date_of_birth || '-' }} ({{ getAgeDisplay(beneficiary_info?.date_of_birth) }})</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.ACCESSIBILITY\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Has Disability</span>\n                    <span class=\"value\">{{ beneficiary_info?.has_disability || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n\n              <!-- Right Column -->\n              <ion-col size=\"6\">\n                <div class=\"info-item\" *ngIf=\"type === 'child'\">\n                  <ion-icon [name]=\"icons.WOMAN\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Mother</span>\n                    <span class=\"value\">{{ beneficiary_info?.mother || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\" *ngIf=\"type === 'plw'\">\n                  <ion-icon [name]=\"icons.MAN\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Husband</span>\n                    <span class=\"value\">{{ beneficiary_info?.husband || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\" *ngIf=\"type === 'child'\">\n                  <ion-icon [name]=\"icons.MAN\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Father</span>\n                    <span class=\"value\">{{ beneficiary_info?.father || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.MEDKIT\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">INF</span>\n                    <span class=\"value\">{{ beneficiary_info?.current_location?.inf?.title || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.LOCATION\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Block</span>\n                    <span class=\"value\">{{ beneficiary_info?.current_location?.block_majhi?.block?.title || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.HOME\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Sub Block</span>\n                    <span class=\"value\">{{ beneficiary_info?.current_location?.sub_block_sub_majhi?.sub_block_title || '-' }}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon [name]=\"icons.HOME\" color=\"secondary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">House Hold</span>\n                    <span class=\"value\">{{ beneficiary_info?.current_location?.hh_no || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </div>\n      </ion-card-content>\n    </ion-card>\n  </div>\n\n  <!-- Ongoing Assessments Section -->\n  <div class=\"card-container\" *ngIf=\"ongoing_assessments && ongoing_assessments.length > 0\">\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon [name]=\"icons.SYNC\" color=\"tertiary\"></ion-icon>\n        Ongoing Followups ({{ ongoing_assessments?.length || 0 }})\n      </h2>\n    </div>\n\n    <ion-card *ngFor=\"let form of ongoing_assessments\" class=\"followup-card\">\n      <ion-card-header>\n        <div class=\"followup-header\">\n          <div class=\"followup-title-section\">\n            <ion-icon [name]=\"icons.MEDKIT\" color=\"tertiary\"></ion-icon>\n            <div class=\"followup-title-text\">\n              <h3>{{ form.title || 'Assessment Form' }}</h3>\n              <ion-badge color=\"tertiary\" *ngIf=\"form.is_follow_up_assessment\">Active Follow-up</ion-badge>\n            </div>\n          </div>\n        </div>\n      </ion-card-header>\n\n      <ion-card-content>\n        <div class=\"followup-details\">\n          <ion-grid>\n            <ion-row>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"detail-item\">\n                  <ion-icon [name]=\"icons.CALENDAR\" color=\"primary\"></ion-icon>\n                  <div class=\"detail-content\">\n                    <span class=\"detail-label\">Last Visit Date</span>\n                    <span class=\"detail-value\">{{ getLastVisitData(form).date | date:'dd MMM yyyy' || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"detail-item\">\n                  <ion-icon [name]=\"icons.DOCUMENT_TEXT\" color=\"secondary\"></ion-icon>\n                  <div class=\"detail-content\">\n                    <span class=\"detail-label\">Current Visit No</span>\n                    <span class=\"detail-value\">{{ getLastVisitData(form).current_visit_no || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"detail-item\">\n                  <ion-icon [name]=\"icons.CALENDAR\" color=\"success\"></ion-icon>\n                  <div class=\"detail-content\">\n                    <span class=\"detail-label\">Next Visit Date</span>\n                    <span class=\"detail-value\">{{ getLastVisitData(form).next_visit_date | date:'dd MMM yyyy' || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n              <ion-col size=\"6\" size-md=\"3\">\n                <div class=\"detail-item\">\n                  <ion-icon [name]=\"icons.DOCUMENT_TEXT\" color=\"warning\"></ion-icon>\n                  <div class=\"detail-content\">\n                    <span class=\"detail-label\">Next Visit No</span>\n                    <span class=\"detail-value\">{{ getLastVisitData(form).next_visit_no || '-' }}</span>\n                  </div>\n                </div>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </div>\n\n        <div class=\"followup-actions\">\n          <ion-button *ngIf=\"form.is_follow_up_assessment\"\n                      size=\"small\"\n                      fill=\"solid\"\n                      [color]=\"hasReachedMaxFollowups(form) ? 'danger' : 'success'\"\n                      [disabled]=\"hasReachedMaxFollowups(form)\"\n                      (click)=\"goToRapidForm(form.id, form.response_id, 'followup')\">\n            <ion-icon slot=\"start\" [name]=\"hasReachedMaxFollowups(form) ? icons.WARNING : icons.ADD\"></ion-icon>\n            {{ getFollowupButtonText(form) }}\n          </ion-button>\n          <ion-button *ngIf=\"form.is_follow_up_assessment\" size=\"small\" fill=\"outline\" color=\"secondary\" (click)=\"goToRapidForm(form.id, form.response_id, 'full')\">\n            <ion-icon slot=\"start\" [name]=\"icons.EDIT\"></ion-icon>\n            Update General Info\n          </ion-button>\n          <ion-button *ngIf=\"form.is_follow_up_assessment\" size=\"small\" fill=\"outline\" color=\"warning\" (click)=\"goToRapidForm(form.id, form.response_id, 'discharge')\">\n            <ion-icon slot=\"start\" [name]=\"icons.EXIT\"></ion-icon>\n            Discharge\n          </ion-button>\n          <ion-button *ngIf=\"hasProgrammeTag(form)\" size=\"small\" fill=\"outline\" color=\"tertiary\" (click)=\"displayProgrammeCard(form.response_id)\">\n            <ion-icon slot=\"start\" [name]=\"icons.DOCUMENT\"></ion-icon>\n            Service Card\n          </ion-button>\n          <ion-button *ngIf=\"!form.is_follow_up_assessment\"\n                      fill=\"outline\"\n                      size=\"small\"\n                      color=\"tertiary\"\n                      (click)=\"goToRapidForm(form.id, form.response_id)\">\n            <ion-icon slot=\"start\" [name]=\"icons.EDIT\"></ion-icon>\n            Edit\n          </ion-button>\n        </div>\n      </ion-card-content>\n    </ion-card>\n  </div>\n\n  <!-- Required Assessments Section -->\n  <div class=\"card-container\" *ngIf=\"required_assessments && required_assessments.length > 0\">\n    <ion-card>\n      <div class=\"section-header\">\n        <h2 class=\"section-title\">\n          <ion-icon [name]=\"icons.CLIPBOARD\" color=\"primary\"></ion-icon>\n          Eligible Services ({{ required_assessments?.length || 0 }})\n        </h2>\n        <ion-chip *ngIf=\"mandatoryFormActive\" color=\"warning\">\n          <ion-icon [name]=\"icons.WARNING\"></ion-icon>\n          <ion-label>Complete to proceed</ion-label>\n        </ion-chip>\n      </div>\n\n      <ion-card-content>\n        <div class=\"table-container\">\n          <table class=\"measurements-table\">\n            <thead>\n              <tr>\n                <th>#</th>\n                <th>Assessment Name</th>\n                <th>Actions</th>\n              </tr>\n            </thead>\n            <tbody>\n              <tr *ngFor=\"let form of required_assessments; let i = index\"\n                  [class.mandatory-row]=\"mandatoryFormId === form.id\">\n                <td>{{ i + 1 }}</td>\n                <td>\n                  {{ form.title || 'Assessment Form' }}\n                  <ion-icon *ngIf=\"mandatoryFormId === form.id\" [name]=\"icons.LOCK_CLOSED\" color=\"warning\" style=\"margin-left: 5px;\"></ion-icon>\n                </td>\n                <td class=\"actions-cell\">\n                  <ion-button fill=\"outline\" size=\"small\" color=\"primary\" (click)=\"goToRapidForm(form.id, form.response_id)\">\n                    {{ form.is_follow_up_assessment ? 'Admission' : 'Start' }}\n                  </ion-button>\n                </td>\n              </tr>\n            </tbody>\n          </table>\n        </div>\n      </ion-card-content>\n    </ion-card>\n  </div>\n\n  <!-- Empty state for Assessments -->\n  <div class=\"card-container\" *ngIf=\"(!ongoing_assessments || ongoing_assessments.length === 0) && (!required_assessments || required_assessments.length === 0)\">\n    <ion-card>\n      <div class=\"section-header\">\n        <h2 class=\"section-title\">\n          <ion-icon [name]=\"icons.CLIPBOARD\" color=\"primary\"></ion-icon>\n          Assessments\n        </h2>\n      </div>\n      <ion-card-content>\n        <div class=\"empty-state\">\n          <ion-icon [name]=\"icons.DOCUMENT\" color=\"medium\"></ion-icon>\n          <h3>No Assessment Available</h3>\n          <p>Check back later for new assessments.</p>\n        </div>\n      </ion-card-content>\n    </ion-card>\n  </div>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ }),

/***/ 84832:
/*!***************************************************************************!*\
  !*** ./node_modules/@ngx-formly/core/fesm2022/ngx-formly-core-select.mjs ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlySelectModule: () => (/* binding */ FormlySelectModule),
/* harmony export */   FormlySelectOptionsPipe: () => (/* binding */ FormlySelectOptionsPipe),
/* harmony export */   LegacyFormlySelectOptionsPipe: () => (/* binding */ LegacyFormlySelectOptionsPipe)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ 43942);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 98764);
var _FormlySelectOptionsPipe, _LegacyFormlySelectOptionsPipe, _FormlySelectModule;




class FormlySelectOptionsPipe {
  transform(options, field) {
    if (!(options instanceof rxjs__WEBPACK_IMPORTED_MODULE_0__.Observable)) {
      options = this.observableOf(options, field);
    } else {
      this.dispose();
    }
    return options.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_1__.map)(value => this.transformOptions(value, field)));
  }
  ngOnDestroy() {
    this.dispose();
  }
  transformOptions(options, field) {
    const to = this.transformSelectProps(field);
    const opts = [];
    const groups = {};
    options === null || options === void 0 || options.forEach(option => {
      const o = this.transformOption(option, to);
      if (o.group) {
        const id = groups[o.label];
        if (id === undefined) {
          groups[o.label] = opts.push(o) - 1;
        } else {
          o.group.forEach(o => opts[id].group.push(o));
        }
      } else {
        opts.push(o);
      }
    });
    return opts;
  }
  transformOption(option, props) {
    const group = props.groupProp(option);
    if (Array.isArray(group)) {
      return {
        label: props.labelProp(option),
        group: group.map(opt => this.transformOption(opt, props))
      };
    }
    option = {
      label: props.labelProp(option),
      value: props.valueProp(option),
      disabled: !!props.disabledProp(option)
    };
    if (group) {
      return {
        label: group,
        group: [option]
      };
    }
    return option;
  }
  transformSelectProps(field) {
    const props = (field === null || field === void 0 ? void 0 : field.props) || (field === null || field === void 0 ? void 0 : field.templateOptions) || {};
    const selectPropFn = prop => typeof prop === 'function' ? prop : o => o[prop];
    return {
      groupProp: selectPropFn(props.groupProp || 'group'),
      labelProp: selectPropFn(props.labelProp || 'label'),
      valueProp: selectPropFn(props.valueProp || 'value'),
      disabledProp: selectPropFn(props.disabledProp || 'disabled')
    };
  }
  dispose() {
    if (this._options) {
      this._options.complete();
      this._options = null;
    }
    if (this._subscription) {
      this._subscription.unsubscribe();
      this._subscription = null;
    }
  }
  observableOf(options, f) {
    this.dispose();
    if (f && f.options && f.options.fieldChanges) {
      this._subscription = f.options.fieldChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.filter)(({
        property,
        type,
        field
      }) => {
        return type === 'expressionChanges' && (property.indexOf('templateOptions.options') === 0 || property.indexOf('props.options') === 0) && field === f && Array.isArray(field.props.options) && !!this._options;
      }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.tap)(() => this._options.next(f.props.options))).subscribe();
    }
    this._options = new rxjs__WEBPACK_IMPORTED_MODULE_4__.BehaviorSubject(options);
    return this._options.asObservable();
  }
}
_FormlySelectOptionsPipe = FormlySelectOptionsPipe;
_FormlySelectOptionsPipe.ɵfac = function _FormlySelectOptionsPipe_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlySelectOptionsPipe)();
};
_FormlySelectOptionsPipe.ɵpipe = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefinePipe"]({
  name: "formlySelectOptions",
  type: _FormlySelectOptionsPipe,
  pure: true,
  standalone: true
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵsetClassMetadata"](FormlySelectOptionsPipe, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Pipe,
    args: [{
      name: 'formlySelectOptions',
      standalone: true
    }]
  }], null, null);
})();
class LegacyFormlySelectOptionsPipe extends FormlySelectOptionsPipe {}
_LegacyFormlySelectOptionsPipe = LegacyFormlySelectOptionsPipe;
_LegacyFormlySelectOptionsPipe.ɵfac = /* @__PURE__ */(() => {
  let ɵ_LegacyFormlySelectOptionsPipe_BaseFactory;
  return function _LegacyFormlySelectOptionsPipe_Factory(__ngFactoryType__) {
    return (ɵ_LegacyFormlySelectOptionsPipe_BaseFactory || (ɵ_LegacyFormlySelectOptionsPipe_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetInheritedFactory"](_LegacyFormlySelectOptionsPipe)))(__ngFactoryType__ || _LegacyFormlySelectOptionsPipe);
  };
})();
_LegacyFormlySelectOptionsPipe.ɵpipe = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefinePipe"]({
  name: "formlySelectOptions",
  type: _LegacyFormlySelectOptionsPipe,
  pure: true
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵsetClassMetadata"](LegacyFormlySelectOptionsPipe, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Pipe,
    args: [{
      name: 'formlySelectOptions',
      standalone: false
    }]
  }], null, null);
})();
class FormlySelectModule {}
_FormlySelectModule = FormlySelectModule;
_FormlySelectModule.ɵfac = function _FormlySelectModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlySelectModule)();
};
_FormlySelectModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineNgModule"]({
  type: _FormlySelectModule,
  declarations: [LegacyFormlySelectOptionsPipe],
  exports: [LegacyFormlySelectOptionsPipe]
});
_FormlySelectModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjector"]({});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵsetClassMetadata"](FormlySelectModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.NgModule,
    args: [{
      declarations: [LegacyFormlySelectOptionsPipe],
      exports: [LegacyFormlySelectOptionsPipe]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 835:
/*!*******************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-checkbox.mjs ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyCheckboxModule: () => (/* binding */ FormlyCheckboxModule),
/* harmony export */   FormlyFieldCheckbox: () => (/* binding */ FormlyFieldCheckbox),
/* harmony export */   withFormlyFieldCheckbox: () => (/* binding */ withFormlyFieldCheckbox)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
var _FormlyFieldCheckbox, _FormlyCheckboxModule;











class FormlyFieldCheckbox extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FieldType {}
_FormlyFieldCheckbox = FormlyFieldCheckbox;
_FormlyFieldCheckbox.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldCheckbox_BaseFactory;
  return function _FormlyFieldCheckbox_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldCheckbox_BaseFactory || (ɵ_FormlyFieldCheckbox_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](_FormlyFieldCheckbox)))(__ngFactoryType__ || _FormlyFieldCheckbox);
  };
})();
_FormlyFieldCheckbox.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: _FormlyFieldCheckbox,
  selectors: [["formly-field-ion-checkbox"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 2,
  vars: 3,
  consts: [[3, "formControl", "ionFormlyAttributes"]],
  template: function _FormlyFieldCheckbox_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ion-checkbox", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("formControl", ctx.formControl)("ionFormlyAttributes", ctx.field);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.props.label, " ");
    }
  },
  dependencies: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonCheckbox, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.BooleanValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__["ɵIonFormlyAttributes"]],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyFieldCheckbox, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'formly-field-ion-checkbox',
      template: `
    <ion-checkbox [formControl]="formControl" [ionFormlyAttributes]="field">
      {{ props.label }}
    </ion-checkbox>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldCheckbox() {
  return {
    types: [{
      name: 'checkbox',
      component: FormlyFieldCheckbox,
      wrappers: ['form-field']
    }, {
      name: 'boolean',
      extends: 'checkbox'
    }]
  };
}
class FormlyCheckboxModule {}
_FormlyCheckboxModule = FormlyCheckboxModule;
_FormlyCheckboxModule.ɵfac = function _FormlyCheckboxModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyCheckboxModule)();
};
_FormlyCheckboxModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: _FormlyCheckboxModule,
  declarations: [FormlyFieldCheckbox],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule]
});
_FormlyCheckboxModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldCheckbox())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyCheckboxModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      declarations: [FormlyFieldCheckbox],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldCheckbox())]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 40739:
/*!*******************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-datetime.mjs ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyDatetimeModule: () => (/* binding */ FormlyDatetimeModule),
/* harmony export */   withFormlyFieldDatetime: () => (/* binding */ withFormlyFieldDatetime)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
var _FormlyFieldDatetime, _FormlyDatetimeModule;
function _FormlyFieldDatetime_ng_template_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-datetime", 2)(1, "ion-buttons", 3)(2, "ion-button", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function _FormlyFieldDatetime_ng_template_5_Template_ion_button_click_2_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r1);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r1.reset());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "ion-button", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function _FormlyFieldDatetime_ng_template_5_Template_ion_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r1);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r1.confirm());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("locale", ctx_r1.props.locale)("presentation", ctx_r1.props.presentation)("cancelText", ctx_r1.props.cancelText)("dayValues", ctx_r1.props.dayValues)("doneText", ctx_r1.props.doneText)("hourValues", ctx_r1.props.hourValues)("minuteValues", ctx_r1.props.minuteValues)("monthValues", ctx_r1.props.monthValues)("yearValues", ctx_r1.props.yearValues)("min", ctx_r1.props.minDate ? ctx_r1.props.minDate : ctx_r1.props.min)("max", ctx_r1.props.maxDate ? ctx_r1.props.maxDate : ctx_r1.props.max)("formControl", ctx_r1.formControl)("ionFormlyAttributes", ctx_r1.field);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r1.props.cancelText || "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r1.props.doneText || "Done");
  }
}












class FormlyFieldDatetime extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FieldType {
  constructor() {
    super(...arguments);
    this.isOpen = false;
    this.defaultOptions = {
      props: {
        presentation: 'month-year'
      }
    };
  }
  displayFormat() {
    if (this.props.displayFormat) {
      return this.props.displayFormat;
    }
    switch (this.props.presentation) {
      case 'date-time':
      case 'time-date':
        return 'short';
      case 'time':
        return 'shortTime';
      case 'month':
        return 'MMMM';
      case 'month-year':
        return 'MMMM, y';
      case 'year':
        return 'y';
      case 'date':
        return 'mediumDate';
    }
  }
  confirm() {
    var _this$datetime;
    (_this$datetime = this.datetime) === null || _this$datetime === void 0 || _this$datetime.confirm();
    this.close();
  }
  reset() {
    var _this$datetime2;
    (_this$datetime2 = this.datetime) === null || _this$datetime2 === void 0 || _this$datetime2.reset();
    this.close();
  }
  close() {
    this.isOpen = false;
    this.formControl.markAsTouched();
  }
}
_FormlyFieldDatetime = FormlyFieldDatetime;
_FormlyFieldDatetime.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldDatetime_BaseFactory;
  return function _FormlyFieldDatetime_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldDatetime_BaseFactory || (ɵ_FormlyFieldDatetime_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyFieldDatetime)))(__ngFactoryType__ || _FormlyFieldDatetime);
  };
})();
_FormlyFieldDatetime.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyFieldDatetime,
  selectors: [["formly-field-ion-datetime"]],
  viewQuery: function _FormlyFieldDatetime_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonDatetime, 5);
    }
    if (rf & 2) {
      let _t;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.datetime = _t.first);
    }
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 6,
  vars: 8,
  consts: [[3, "click", "button", "detail"], [3, "didDismiss", "isOpen", "cssClass"], [3, "locale", "presentation", "cancelText", "dayValues", "doneText", "hourValues", "minuteValues", "monthValues", "yearValues", "min", "max", "formControl", "ionFormlyAttributes"], ["slot", "buttons"], [3, "click"]],
  template: function _FormlyFieldDatetime_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-item", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function _FormlyFieldDatetime_Template_ion_item_click_0_listener() {
        return ctx.isOpen = true;
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "ion-label");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "date");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "ion-modal", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("didDismiss", function _FormlyFieldDatetime_Template_ion_modal_didDismiss_4_listener() {
        return ctx.close();
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, _FormlyFieldDatetime_ng_template_5_Template, 6, 15, "ng-template");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("button", true)("detail", false);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.formControl.value ? _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind2"](3, 5, ctx.formControl.value, ctx.displayFormat()) : ctx.props.placeholder, " ");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("isOpen", ctx.isOpen)("cssClass", "ion-datetime-modal ion-datetime-modal-" + ctx.props.presentation);
    }
  },
  dependencies: [_angular_forms__WEBPACK_IMPORTED_MODULE_3__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonButton, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonButtons, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonDatetime, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonItem, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonLabel, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonModal, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.SelectValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__["ɵIonFormlyAttributes"], _angular_common__WEBPACK_IMPORTED_MODULE_5__.DatePipe],
  styles: [".ion-datetime-modal{--width: 310px;--border-radius: 8px}.ion-datetime-modal.ion-datetime-modal-time-date{--height: 440px}.ion-datetime-modal.ion-datetime-modal-date{--height: 390px}.ion-datetime-modal.ion-datetime-modal-time{--height: 260px}formly-field-ion-datetime{display:inherit}formly-field-ion-datetime ion-item{flex:1}\n"],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFieldDatetime, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field-ion-datetime',
      template: `
    <ion-item [button]="true" [detail]="false" (click)="isOpen = true">
      <ion-label>
        {{ formControl.value ? (formControl.value | date: displayFormat()) : props.placeholder }}
      </ion-label>
    </ion-item>
    <ion-modal
      [isOpen]="isOpen"
      (didDismiss)="close()"
      [cssClass]="'ion-datetime-modal ion-datetime-modal-' + props.presentation"
    >
      <ng-template>
        <ion-datetime
          [locale]="props.locale"
          [presentation]="props.presentation"
          [cancelText]="props.cancelText"
          [dayValues]="props.dayValues"
          [doneText]="props.doneText"
          [hourValues]="props.hourValues"
          [minuteValues]="props.minuteValues"
          [monthValues]="props.monthValues"
          [yearValues]="props.yearValues"
          [min]="props.minDate ? props.minDate : props.min"
          [max]="props.maxDate ? props.maxDate : props.max"
          [formControl]="formControl"
          [ionFormlyAttributes]="field"
        >
          <ion-buttons slot="buttons">
            <ion-button (click)="reset()">{{ props.cancelText || 'Cancel' }}</ion-button>
            <ion-button (click)="confirm()">{{ props.doneText || 'Done' }}</ion-button>
          </ion-buttons>
        </ion-datetime>
      </ng-template>
    </ion-modal>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewEncapsulation.None,
      styles: [".ion-datetime-modal{--width: 310px;--border-radius: 8px}.ion-datetime-modal.ion-datetime-modal-time-date{--height: 440px}.ion-datetime-modal.ion-datetime-modal-date{--height: 390px}.ion-datetime-modal.ion-datetime-modal-time{--height: 260px}formly-field-ion-datetime{display:inherit}formly-field-ion-datetime ion-item{flex:1}\n"]
    }]
  }], null, {
    datetime: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild,
      args: [_ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonDatetime]
    }]
  });
})();
function withFormlyFieldDatetime() {
  return {
    types: [{
      name: 'datetime',
      component: FormlyFieldDatetime,
      wrappers: ['form-field']
    }]
  };
}
class FormlyDatetimeModule {}
_FormlyDatetimeModule = FormlyDatetimeModule;
_FormlyDatetimeModule.ɵfac = function _FormlyDatetimeModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyDatetimeModule)();
};
_FormlyDatetimeModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlyDatetimeModule,
  declarations: [FormlyFieldDatetime],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule]
});
_FormlyDatetimeModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldDatetime())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyDatetimeModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyFieldDatetime],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldDatetime())]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 34553:
/*!*********************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-form-field.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyFormFieldModule: () => (/* binding */ FormlyFormFieldModule),
/* harmony export */   withFormlyFormField: () => (/* binding */ withFormlyFormField),
/* harmony export */   "ɵIonFormlyAttributes": () => (/* binding */ IonFormlyAttributes)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ 34456);
var _FormlyWrapperFormField, _IonFormlyAttributes, _FormlyFormFieldModule;
function _FormlyWrapperFormField_ng_template_1_Template(rf, ctx) {}
function _FormlyWrapperFormField_ion_item_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-item", 3)(1, "ion-label")(2, "ion-text", 4)(3, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "formly-validation-message", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("field", ctx_r0.field);
  }
}









class FormlyWrapperFormField extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FieldWrapper {}
_FormlyWrapperFormField = FormlyWrapperFormField;
_FormlyWrapperFormField.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyWrapperFormField_BaseFactory;
  return function _FormlyWrapperFormField_Factory(__ngFactoryType__) {
    return (ɵ_FormlyWrapperFormField_BaseFactory || (ɵ_FormlyWrapperFormField_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyWrapperFormField)))(__ngFactoryType__ || _FormlyWrapperFormField);
  };
})();
_FormlyWrapperFormField.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyWrapperFormField,
  selectors: [["formly-wrapper-ion-form-field"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 4,
  vars: 2,
  consts: [["fieldComponent", ""], [3, "lines"], ["lines", "none", 4, "ngIf"], ["lines", "none"], ["color", "danger"], [3, "field"]],
  template: function _FormlyWrapperFormField_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-item", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, _FormlyWrapperFormField_ng_template_1_Template, 0, 0, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, _FormlyWrapperFormField_ion_item_3_Template, 5, 1, "ion-item", 2);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("lines", ctx.props.itemLines);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showError);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonItem, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonLabel, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonText, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.LegacyFormlyValidationMessage],
  encapsulation: 2
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyWrapperFormField, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-wrapper-ion-form-field',
      template: `
    <ion-item [lines]="props.itemLines">
      <ng-template #fieldComponent></ng-template>
    </ion-item>
    <ion-item lines="none" *ngIf="showError">
      <ion-label>
        <ion-text color="danger">
          <p>
            <formly-validation-message [field]="field"></formly-validation-message>
          </p>
        </ion-text>
      </ion-label>
    </ion-item>
  `
    }]
  }], null, null);
})();
function withFormlyFormField() {
  return {
    wrappers: [{
      name: 'form-field',
      component: FormlyWrapperFormField
    }]
  };
}
class IonFormlyAttributes extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyAttributes {
  constructor(renderer, elementRef, _document) {
    super(renderer, elementRef, _document);
  }
}
_IonFormlyAttributes = IonFormlyAttributes;
_IonFormlyAttributes.ɵfac = function _IonFormlyAttributes_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _IonFormlyAttributes)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_2__.DOCUMENT));
};
_IonFormlyAttributes.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _IonFormlyAttributes,
  selectors: [["", "ionFormlyAttributes", ""]],
  hostBindings: function _IonFormlyAttributes_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ionFocus", function _IonFormlyAttributes_ionFocus_HostBindingHandler($event) {
        return ctx.onFocus($event);
      })("ionBlur", function _IonFormlyAttributes_ionBlur_HostBindingHandler($event) {
        return ctx.onBlur($event);
      })("ionChange", function _IonFormlyAttributes_ionChange_HostBindingHandler($event) {
        return ctx.onChange($event);
      })("ionInput", function _IonFormlyAttributes_ionInput_HostBindingHandler($event) {
        return ctx.onChange($event);
      });
    }
  },
  inputs: {
    field: [0, "ionFormlyAttributes", "field"]
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](IonFormlyAttributes, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      // eslint-disable-next-line
      selector: '[ionFormlyAttributes]',
      host: {
        '(ionFocus)': 'onFocus($event)',
        '(ionBlur)': 'onBlur($event)',
        '(ionChange)': 'onChange($event)',
        '(ionInput)': 'onChange($event)'
      }
    }]
  }], () => [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
  }, {
    type: undefined,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject,
      args: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.DOCUMENT]
    }]
  }], {
    field: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['ionFormlyAttributes']
    }]
  });
})();
class FormlyFormFieldModule {}
_FormlyFormFieldModule = FormlyFormFieldModule;
_FormlyFormFieldModule.ɵfac = function _FormlyFormFieldModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyFormFieldModule)();
};
_FormlyFormFieldModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlyFormFieldModule,
  declarations: [FormlyWrapperFormField, IonFormlyAttributes],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule],
  exports: [IonFormlyAttributes]
});
_FormlyFormFieldModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFormField())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFormFieldModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyWrapperFormField, IonFormlyAttributes],
      exports: [IonFormlyAttributes],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFormField())]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 88916:
/*!****************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-input.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyFieldInput: () => (/* binding */ FormlyFieldInput),
/* harmony export */   FormlyInputModule: () => (/* binding */ FormlyInputModule),
/* harmony export */   withFormlyFieldInput: () => (/* binding */ withFormlyFieldInput)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
var _FormlyFieldInput, _FormlyInputModule;
function _FormlyFieldInput_ion_input_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "ion-input", 2);
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("type", ctx_r0.props.type || "text")("label", ctx_r0.props.label)("labelPlacement", ctx_r0.props.labelPosition)("formControl", ctx_r0.formControl)("ionFormlyAttributes", ctx_r0.field);
  }
}
function _FormlyFieldInput_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "ion-input", 3);
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("label", ctx_r0.props.label)("formControl", ctx_r0.formControl)("ionFormlyAttributes", ctx_r0.field);
  }
}












class FormlyFieldInput extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FieldType {}
_FormlyFieldInput = FormlyFieldInput;
_FormlyFieldInput.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldInput_BaseFactory;
  return function _FormlyFieldInput_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldInput_BaseFactory || (ɵ_FormlyFieldInput_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyFieldInput)))(__ngFactoryType__ || _FormlyFieldInput);
  };
})();
_FormlyFieldInput.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyFieldInput,
  selectors: [["formly-field-ion-input"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 3,
  vars: 2,
  consts: [["numberTmp", ""], [3, "type", "label", "labelPlacement", "formControl", "ionFormlyAttributes", 4, "ngIf", "ngIfElse"], [3, "type", "label", "labelPlacement", "formControl", "ionFormlyAttributes"], ["type", "number", 3, "label", "formControl", "ionFormlyAttributes"]],
  template: function _FormlyFieldInput_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, _FormlyFieldInput_ion_input_0_Template, 1, 5, "ion-input", 1)(1, _FormlyFieldInput_ng_template_1_Template, 1, 3, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    }
    if (rf & 2) {
      const numberTmp_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.props.type !== "number")("ngIfElse", numberTmp_r2);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonInput, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NumericValueAccessor, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.TextValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__["ɵIonFormlyAttributes"]],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFieldInput, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field-ion-input',
      template: `
    <ion-input
      *ngIf="props.type !== 'number'; else numberTmp"
      [type]="props.type || 'text'"
      [label]="props.label"
      [labelPlacement]="props.labelPosition"
      [formControl]="formControl"
      [ionFormlyAttributes]="field"
    ></ion-input>
    <ng-template #numberTmp>
      <ion-input
        type="number"
        [label]="props.label"
        [formControl]="formControl"
        [ionFormlyAttributes]="field"
      ></ion-input>
    </ng-template>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldInput() {
  return {
    types: [{
      name: 'input',
      component: FormlyFieldInput,
      wrappers: ['form-field']
    }, {
      name: 'string',
      extends: 'input'
    }, {
      name: 'number',
      extends: 'input',
      defaultOptions: {
        props: {
          type: 'number'
        }
      }
    }, {
      name: 'integer',
      extends: 'input',
      defaultOptions: {
        props: {
          type: 'number'
        }
      }
    }]
  };
}
class FormlyInputModule {}
_FormlyInputModule = FormlyInputModule;
_FormlyInputModule.ɵfac = function _FormlyInputModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyInputModule)();
};
_FormlyInputModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlyInputModule,
  declarations: [FormlyFieldInput],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule]
});
_FormlyInputModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldInput())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyInputModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyFieldInput],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldInput())],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_0__.NO_ERRORS_SCHEMA]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 60253:
/*!****************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-radio.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyFieldRadio: () => (/* binding */ FormlyFieldRadio),
/* harmony export */   FormlyRadioModule: () => (/* binding */ FormlyRadioModule),
/* harmony export */   withFormlyFieldRadio: () => (/* binding */ withFormlyFieldRadio)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-formly/core/select */ 84832);
var _FormlyFieldRadio, _FormlyRadioModule;
function _FormlyFieldRadio_ion_item_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-item", 2)(1, "ion-radio", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const option_r1 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", option_r1.disabled || ctx_r1.formControl.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", option_r1.value);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", option_r1.label, " ");
  }
}














class FormlyFieldRadio extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FieldType {}
_FormlyFieldRadio = FormlyFieldRadio;
_FormlyFieldRadio.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldRadio_BaseFactory;
  return function _FormlyFieldRadio_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldRadio_BaseFactory || (ɵ_FormlyFieldRadio_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyFieldRadio)))(__ngFactoryType__ || _FormlyFieldRadio);
  };
})();
_FormlyFieldRadio.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyFieldRadio,
  selectors: [["formly-field-ion-radio"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 7,
  vars: 9,
  consts: [[3, "formControl", "ionFormlyAttributes"], [3, "disabled", 4, "ngFor", "ngForOf"], [3, "disabled"], [3, "value"]],
  template: function _FormlyFieldRadio_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-list")(1, "ion-list-header");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "ion-radio-group", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, _FormlyFieldRadio_ion_item_4_Template, 3, 3, "ion-item", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](5, "formlySelectOptions");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](6, "async");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.props.label);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formControl", ctx.formControl)("ionFormlyAttributes", ctx.field);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](6, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind2"](5, 4, ctx.props.options, ctx.field)));
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgForOf, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonItem, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonList, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonListHeader, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonRadio, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonRadioGroup, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.SelectValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__["ɵIonFormlyAttributes"], _angular_common__WEBPACK_IMPORTED_MODULE_2__.AsyncPipe, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.LegacyFormlySelectOptionsPipe],
  styles: ["[_nghost-%COMP%]{display:inherit}[_nghost-%COMP%]   ion-list[_ngcontent-%COMP%]{flex:1}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFieldRadio, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field-ion-radio',
      template: `
    <ion-list>
      <ion-list-header>{{ props.label }}</ion-list-header>
      <ion-radio-group [formControl]="formControl" [ionFormlyAttributes]="field">
        <ion-item
          *ngFor="let option of props.options | formlySelectOptions: field | async"
          [disabled]="option.disabled || formControl.disabled"
        >
          <ion-radio [value]="option.value">
            {{ option.label }}
          </ion-radio>
        </ion-item>
      </ion-radio-group>
    </ion-list>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}:host ion-list{flex:1}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldRadio() {
  return {
    types: [{
      name: 'radio',
      component: FormlyFieldRadio,
      wrappers: ['form-field']
    }]
  };
}
class FormlyRadioModule {}
_FormlyRadioModule = FormlyRadioModule;
_FormlyRadioModule.ɵfac = function _FormlyRadioModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyRadioModule)();
};
_FormlyRadioModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlyRadioModule,
  declarations: [FormlyFieldRadio],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule]
});
_FormlyRadioModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldRadio())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyRadioModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyFieldRadio],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldRadio())]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 43936:
/*!*****************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-select.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyFieldSelect: () => (/* binding */ FormlyFieldSelect),
/* harmony export */   FormlySelectModule: () => (/* binding */ FormlySelectModule),
/* harmony export */   withFormlyFieldSelect: () => (/* binding */ withFormlyFieldSelect)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-formly/core/select */ 84832);
var _FormlyFieldSelect, _FormlySelectModule;
function _FormlyFieldSelect_ng_container_0_ion_select_option_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ion-select-option", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const option_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", option_r1.value)("disabled", option_r1.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", option_r1.label, " ");
  }
}
function _FormlyFieldSelect_ng_container_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "ion-select", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, _FormlyFieldSelect_ng_container_0_ion_select_option_2_Template, 2, 3, "ion-select-option", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
  }
  if (rf & 2) {
    const selectOptions_r2 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("align-self", ctx_r2.props.labelPosition === "floating" ? "stretch" : "")("max-width", ctx_r2.props.labelPosition === "floating" ? 100 : "", "%");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formControl", ctx_r2.formControl)("compareWith", ctx_r2.props.compareWith)("ionFormlyAttributes", ctx_r2.field)("multiple", ctx_r2.props.multiple)("interface", ctx_r2.props.interface)("okText", ctx_r2.props.okText)("cancelText", ctx_r2.props.cancelText)("label", ctx_r2.props.label)("labelPlacement", ctx_r2.props.labelPosition);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", selectOptions_r2);
  }
}














class FormlyFieldSelect extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FieldType {
  constructor() {
    super(...arguments);
    this.defaultOptions = {
      props: {
        compareWith(o1, o2) {
          return o1 === o2;
        }
      }
    };
  }
}
_FormlyFieldSelect = FormlyFieldSelect;
_FormlyFieldSelect.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldSelect_BaseFactory;
  return function _FormlyFieldSelect_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldSelect_BaseFactory || (ɵ_FormlyFieldSelect_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyFieldSelect)))(__ngFactoryType__ || _FormlyFieldSelect);
  };
})();
_FormlyFieldSelect.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyFieldSelect,
  selectors: [["formly-field-ion-select"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 3,
  vars: 6,
  consts: [[4, "ngIf"], [3, "formControl", "compareWith", "ionFormlyAttributes", "multiple", "interface", "okText", "cancelText", "label", "labelPlacement"], [3, "value", "disabled", 4, "ngFor", "ngForOf"], [3, "value", "disabled"]],
  template: function _FormlyFieldSelect_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, _FormlyFieldSelect_ng_container_0_Template, 3, 14, "ng-container", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "formlySelectOptions");
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "async");
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 4, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind2"](1, 1, ctx.props.options, ctx.field)));
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonSelect, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonSelectOption, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.SelectValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__["ɵIonFormlyAttributes"], _angular_common__WEBPACK_IMPORTED_MODULE_2__.AsyncPipe, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.LegacyFormlySelectOptionsPipe],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFieldSelect, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field-ion-select',
      template: `
    <!-- ng-container used as a workaround for https://github.com/ionic-team/ionic/issues/19324 -->
    <ng-container *ngIf="props.options | formlySelectOptions: field | async; let selectOptions">
      <ion-select
        [style.align-self]="props.labelPosition === 'floating' ? 'stretch' : ''"
        [style.max-width.%]="props.labelPosition === 'floating' ? 100 : ''"
        [formControl]="formControl"
        [compareWith]="props.compareWith"
        [ionFormlyAttributes]="field"
        [multiple]="props.multiple"
        [interface]="props.interface"
        [okText]="props.okText"
        [cancelText]="props.cancelText"
        [label]="props.label"
        [labelPlacement]="props.labelPosition"
      >
        <ion-select-option *ngFor="let option of selectOptions" [value]="option.value" [disabled]="option.disabled">
          {{ option.label }}
        </ion-select-option>
      </ion-select>
    </ng-container>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldSelect() {
  return {
    types: [{
      name: 'select',
      component: FormlyFieldSelect,
      wrappers: ['form-field']
    }, {
      name: 'enum',
      extends: 'select'
    }]
  };
}
class FormlySelectModule {}
_FormlySelectModule = FormlySelectModule;
_FormlySelectModule.ɵfac = function _FormlySelectModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlySelectModule)();
};
_FormlySelectModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlySelectModule,
  declarations: [FormlyFieldSelect],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule]
});
_FormlySelectModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldSelect())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlySelectModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyFieldSelect],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_5__.FormlyFormFieldModule, _ngx_formly_core_select__WEBPACK_IMPORTED_MODULE_6__.FormlySelectModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_1__.FormlyModule.forChild(withFormlyFieldSelect())],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_0__.NO_ERRORS_SCHEMA]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 12003:
/*!*****************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-slider.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlySliderModule: () => (/* binding */ FormlySliderModule),
/* harmony export */   withFormlyFieldSlider: () => (/* binding */ withFormlyFieldSlider)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
var _FormlyFieldSlider, _FormlySliderModule;











class FormlyFieldSlider extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FieldType {}
_FormlyFieldSlider = FormlyFieldSlider;
_FormlyFieldSlider.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldSlider_BaseFactory;
  return function _FormlyFieldSlider_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldSlider_BaseFactory || (ɵ_FormlyFieldSlider_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](_FormlyFieldSlider)))(__ngFactoryType__ || _FormlyFieldSlider);
  };
})();
_FormlyFieldSlider.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: _FormlyFieldSlider,
  selectors: [["formly-field-ion-range"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 5,
  vars: 8,
  consts: [[3, "min", "max", "formControl", "ionFormlyAttributes", "label", "labelPlacement"], ["slot", "start"], ["slot", "end"]],
  template: function _FormlyFieldSlider_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ion-range", 0)(1, "ion-label", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "ion-label", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("min", ctx.props.min)("max", ctx.props.max)("formControl", ctx.formControl)("ionFormlyAttributes", ctx.field)("label", ctx.props.label)("labelPlacement", ctx.props.labelPosition);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.props.min);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.props.max);
    }
  },
  dependencies: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonLabel, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonRange, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.NumericValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__["ɵIonFormlyAttributes"]],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyFieldSlider, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'formly-field-ion-range',
      template: `
    <ion-range
      [min]="props.min"
      [max]="props.max"
      [formControl]="formControl"
      [ionFormlyAttributes]="field"
      [label]="props.label"
      [labelPlacement]="props.labelPosition"
    >
      <ion-label slot="start">{{ props.min }}</ion-label>
      <ion-label slot="end">{{ props.max }}</ion-label>
    </ion-range>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldSlider() {
  return {
    types: [{
      name: 'slider',
      component: FormlyFieldSlider,
      wrappers: ['form-field']
    }, {
      name: 'range',
      extends: 'slider'
    }]
  };
}
class FormlySliderModule {}
_FormlySliderModule = FormlySliderModule;
_FormlySliderModule.ɵfac = function _FormlySliderModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlySliderModule)();
};
_FormlySliderModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: _FormlySliderModule,
  declarations: [FormlyFieldSlider],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule]
});
_FormlySliderModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldSlider())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlySliderModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      declarations: [FormlyFieldSlider],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldSlider())],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.NO_ERRORS_SCHEMA]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 69030:
/*!*******************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-textarea.mjs ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyFieldTextArea: () => (/* binding */ FormlyFieldTextArea),
/* harmony export */   FormlyTextAreaModule: () => (/* binding */ FormlyTextAreaModule),
/* harmony export */   withFormlyFieldTextArea: () => (/* binding */ withFormlyFieldTextArea)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
var _FormlyFieldTextArea, _FormlyTextAreaModule;











class FormlyFieldTextArea extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FieldType {}
_FormlyFieldTextArea = FormlyFieldTextArea;
_FormlyFieldTextArea.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldTextArea_BaseFactory;
  return function _FormlyFieldTextArea_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldTextArea_BaseFactory || (ɵ_FormlyFieldTextArea_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](_FormlyFieldTextArea)))(__ngFactoryType__ || _FormlyFieldTextArea);
  };
})();
_FormlyFieldTextArea.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: _FormlyFieldTextArea,
  selectors: [["formly-field-ion-textarea"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 1,
  vars: 6,
  consts: [[3, "formControl", "ionFormlyAttributes", "cols", "rows", "label", "labelPlacement"]],
  template: function _FormlyFieldTextArea_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "ion-textarea", 0);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("formControl", ctx.formControl)("ionFormlyAttributes", ctx.field)("cols", ctx.props.cols)("rows", ctx.props.rows)("label", ctx.props.label)("labelPlacement", ctx.props.labelPosition);
    }
  },
  dependencies: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonTextarea, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.TextValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__["ɵIonFormlyAttributes"]],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyFieldTextArea, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'formly-field-ion-textarea',
      template: `
    <ion-textarea
      [formControl]="formControl"
      [ionFormlyAttributes]="field"
      [cols]="props.cols"
      [rows]="props.rows"
      [label]="props.label"
      [labelPlacement]="props.labelPosition"
    >
    </ion-textarea>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldTextArea() {
  return {
    types: [{
      name: 'textarea',
      component: FormlyFieldTextArea,
      wrappers: ['form-field']
    }]
  };
}
class FormlyTextAreaModule {}
_FormlyTextAreaModule = FormlyTextAreaModule;
_FormlyTextAreaModule.ɵfac = function _FormlyTextAreaModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyTextAreaModule)();
};
_FormlyTextAreaModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: _FormlyTextAreaModule,
  declarations: [FormlyFieldTextArea],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule]
});
_FormlyTextAreaModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldTextArea())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyTextAreaModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      declarations: [FormlyFieldTextArea],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldTextArea())],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_1__.NO_ERRORS_SCHEMA]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 76560:
/*!*****************************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic-toggle.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyToggleModule: () => (/* binding */ FormlyToggleModule),
/* harmony export */   withFormlyFieldToggle: () => (/* binding */ withFormlyFieldToggle)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ngx-formly/core */ 10535);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
var _FormlyFieldToggle, _FormlyToggleModule;











class FormlyFieldToggle extends _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FieldType {}
_FormlyFieldToggle = FormlyFieldToggle;
_FormlyFieldToggle.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyFieldToggle_BaseFactory;
  return function _FormlyFieldToggle_Factory(__ngFactoryType__) {
    return (ɵ_FormlyFieldToggle_BaseFactory || (ɵ_FormlyFieldToggle_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](_FormlyFieldToggle)))(__ngFactoryType__ || _FormlyFieldToggle);
  };
})();
_FormlyFieldToggle.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({
  type: _FormlyFieldToggle,
  selectors: [["formly-field-ion-toggle"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]],
  decls: 2,
  vars: 3,
  consts: [[3, "formControl", "ionFormlyAttributes"]],
  template: function _FormlyFieldToggle_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "ion-toggle", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("formControl", ctx.formControl)("ionFormlyAttributes", ctx.field);
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.props.label, " ");
    }
  },
  dependencies: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControlDirective, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonToggle, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.BooleanValueAccessor, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__["ɵIonFormlyAttributes"]],
  styles: ["[_nghost-%COMP%]{display:inherit}"],
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyFieldToggle, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.Component,
    args: [{
      selector: 'formly-field-ion-toggle',
      template: `
    <ion-toggle [formControl]="formControl" [ionFormlyAttributes]="field">
      {{ props.label }}
    </ion-toggle>
  `,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionStrategy.OnPush,
      styles: [":host{display:inherit}\n"]
    }]
  }], null, null);
})();
function withFormlyFieldToggle() {
  return {
    types: [{
      name: 'toggle',
      component: FormlyFieldToggle,
      wrappers: ['form-field']
    }]
  };
}
class FormlyToggleModule {}
_FormlyToggleModule = FormlyToggleModule;
_FormlyToggleModule.ɵfac = function _FormlyToggleModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyToggleModule)();
};
_FormlyToggleModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
  type: _FormlyToggleModule,
  declarations: [FormlyFieldToggle],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule]
});
_FormlyToggleModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldToggle())]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](FormlyToggleModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule,
    args: [{
      declarations: [FormlyFieldToggle],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.IonicModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_4__.FormlyFormFieldModule, _ngx_formly_core__WEBPACK_IMPORTED_MODULE_0__.FormlyModule.forChild(withFormlyFieldToggle())]
    }]
  }], null, null);
})();

/**
 * Generated bundle index. Do not edit.
 */



/***/ }),

/***/ 24295:
/*!**********************************************************************!*\
  !*** ./node_modules/@ngx-formly/ionic/fesm2022/ngx-formly-ionic.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormlyIonicModule: () => (/* binding */ FormlyIonicModule),
/* harmony export */   withFormlyIonic: () => (/* binding */ withFormlyIonic)
/* harmony export */ });
/* harmony import */ var _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ngx-formly/ionic/form-field */ 34553);
/* harmony import */ var _ngx_formly_ionic_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ngx-formly/ionic/input */ 88916);
/* harmony import */ var _ngx_formly_ionic_textarea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ngx-formly/ionic/textarea */ 69030);
/* harmony import */ var _ngx_formly_ionic_radio__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngx-formly/ionic/radio */ 60253);
/* harmony import */ var _ngx_formly_ionic_checkbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-formly/ionic/checkbox */ 835);
/* harmony import */ var _ngx_formly_ionic_select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-formly/ionic/select */ 43936);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_formly_ionic_toggle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-formly/ionic/toggle */ 76560);
/* harmony import */ var _ngx_formly_ionic_slider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-formly/ionic/slider */ 12003);
/* harmony import */ var _ngx_formly_ionic_datetime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-formly/ionic/datetime */ 40739);
var _FormlyIonicModule;











function withFormlyIonic() {
  return [(0,_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.withFormlyFormField)(), (0,_ngx_formly_ionic_input__WEBPACK_IMPORTED_MODULE_1__.withFormlyFieldInput)(), (0,_ngx_formly_ionic_textarea__WEBPACK_IMPORTED_MODULE_2__.withFormlyFieldTextArea)(), (0,_ngx_formly_ionic_radio__WEBPACK_IMPORTED_MODULE_3__.withFormlyFieldRadio)(), (0,_ngx_formly_ionic_checkbox__WEBPACK_IMPORTED_MODULE_4__.withFormlyFieldCheckbox)(), (0,_ngx_formly_ionic_select__WEBPACK_IMPORTED_MODULE_5__.withFormlyFieldSelect)()];
}
class FormlyIonicModule {}
_FormlyIonicModule = FormlyIonicModule;
_FormlyIonicModule.ɵfac = function _FormlyIonicModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyIonicModule)();
};
_FormlyIonicModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineNgModule"]({
  type: _FormlyIonicModule,
  imports: [_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule, _ngx_formly_ionic_input__WEBPACK_IMPORTED_MODULE_1__.FormlyInputModule, _ngx_formly_ionic_textarea__WEBPACK_IMPORTED_MODULE_2__.FormlyTextAreaModule, _ngx_formly_ionic_radio__WEBPACK_IMPORTED_MODULE_3__.FormlyRadioModule, _ngx_formly_ionic_checkbox__WEBPACK_IMPORTED_MODULE_4__.FormlyCheckboxModule, _ngx_formly_ionic_select__WEBPACK_IMPORTED_MODULE_5__.FormlySelectModule, _ngx_formly_ionic_toggle__WEBPACK_IMPORTED_MODULE_7__.FormlyToggleModule, _ngx_formly_ionic_slider__WEBPACK_IMPORTED_MODULE_8__.FormlySliderModule, _ngx_formly_ionic_datetime__WEBPACK_IMPORTED_MODULE_9__.FormlyDatetimeModule],
  exports: [_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule]
});
_FormlyIonicModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineInjector"]({
  imports: [_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule, _ngx_formly_ionic_input__WEBPACK_IMPORTED_MODULE_1__.FormlyInputModule, _ngx_formly_ionic_textarea__WEBPACK_IMPORTED_MODULE_2__.FormlyTextAreaModule, _ngx_formly_ionic_radio__WEBPACK_IMPORTED_MODULE_3__.FormlyRadioModule, _ngx_formly_ionic_checkbox__WEBPACK_IMPORTED_MODULE_4__.FormlyCheckboxModule, _ngx_formly_ionic_select__WEBPACK_IMPORTED_MODULE_5__.FormlySelectModule, _ngx_formly_ionic_toggle__WEBPACK_IMPORTED_MODULE_7__.FormlyToggleModule, _ngx_formly_ionic_slider__WEBPACK_IMPORTED_MODULE_8__.FormlySliderModule, _ngx_formly_ionic_datetime__WEBPACK_IMPORTED_MODULE_9__.FormlyDatetimeModule, _ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵsetClassMetadata"](FormlyIonicModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.NgModule,
    args: [{
      imports: [_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule, _ngx_formly_ionic_input__WEBPACK_IMPORTED_MODULE_1__.FormlyInputModule, _ngx_formly_ionic_textarea__WEBPACK_IMPORTED_MODULE_2__.FormlyTextAreaModule, _ngx_formly_ionic_radio__WEBPACK_IMPORTED_MODULE_3__.FormlyRadioModule, _ngx_formly_ionic_checkbox__WEBPACK_IMPORTED_MODULE_4__.FormlyCheckboxModule, _ngx_formly_ionic_select__WEBPACK_IMPORTED_MODULE_5__.FormlySelectModule, _ngx_formly_ionic_toggle__WEBPACK_IMPORTED_MODULE_7__.FormlyToggleModule, _ngx_formly_ionic_slider__WEBPACK_IMPORTED_MODULE_8__.FormlySliderModule, _ngx_formly_ionic_datetime__WEBPACK_IMPORTED_MODULE_9__.FormlyDatetimeModule],
      exports: [_ngx_formly_ionic_form_field__WEBPACK_IMPORTED_MODULE_0__.FormlyFormFieldModule]
    }]
  }], null, null);
})();

/*
 * Public API Surface of ionic
 */

/**
 * Generated bundle index. Do not edit.
 */



/***/ })

}]);
//# sourceMappingURL=src_app_pages_beneficiary-assessment_beneficiary-assessment_module_ts.js.map