(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_beneficiary-activity-list_beneficiary-activity-list_module_ts"],{

/***/ 51955:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-activity-list/beneficiary-activity-list-routing.module.ts ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryActivityListPageRoutingModule: () => (/* binding */ BeneficiaryActivityListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _beneficiary_activity_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./beneficiary-activity-list.page */ 13173);




const routes = [{
  path: '',
  component: _beneficiary_activity_list_page__WEBPACK_IMPORTED_MODULE_0__.BeneficiaryActivityListPage
}];
let BeneficiaryActivityListPageRoutingModule = class BeneficiaryActivityListPageRoutingModule {};
BeneficiaryActivityListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], BeneficiaryActivityListPageRoutingModule);


/***/ }),

/***/ 28242:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-activity-list/beneficiary-activity-list.module.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryActivityListPageModule: () => (/* binding */ BeneficiaryActivityListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _beneficiary_activity_list_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./beneficiary-activity-list-routing.module */ 51955);
/* harmony import */ var _beneficiary_activity_list_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./beneficiary-activity-list.page */ 13173);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let BeneficiaryActivityListPageModule = class BeneficiaryActivityListPageModule {};
BeneficiaryActivityListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _beneficiary_activity_list_routing_module__WEBPACK_IMPORTED_MODULE_0__.BeneficiaryActivityListPageRoutingModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule],
  declarations: [_beneficiary_activity_list_page__WEBPACK_IMPORTED_MODULE_1__.BeneficiaryActivityListPage]
})], BeneficiaryActivityListPageModule);


/***/ }),

/***/ 13173:
/*!***********************************************************************************!*\
  !*** ./src/app/pages/beneficiary-activity-list/beneficiary-activity-list.page.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryActivityListPage: () => (/* binding */ BeneficiaryActivityListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _beneficiary_activity_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./beneficiary-activity-list.page.html?ngResource */ 30519);
/* harmony import */ var _beneficiary_activity_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./beneficiary-activity-list.page.scss?ngResource */ 54691);
/* harmony import */ var _beneficiary_activity_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_beneficiary_activity_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_beneficiary_activity_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/beneficiary_activity_api.service */ 84430);
/* harmony import */ var _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @app/constants/icons.constants */ 35997);

var _BeneficiaryActivityListPage;







let BeneficiaryActivityListPage = (_BeneficiaryActivityListPage = class BeneficiaryActivityListPage {
  constructor(api, b) {
    this.api = api;
    this.b = b;
    this.beneficiaryActivities = [];
    this.isLoading = false;
    this.icons = _app_constants_icons_constants__WEBPACK_IMPORTED_MODULE_5__.ICONS;
    this.user = this.b.getCurrentUser();
    // Set default date to today (using local timezone)
    const today = new Date();
    const year = today.getFullYear();
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const day = String(today.getDate()).padStart(2, '0');
    this.selectedDate = `${year}-${month}-${day}`;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.load();
    })();
  }
  load(event) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!event) {
        _this2.isLoading = true;
      }
      try {
        const response = yield _this2.api.getBeneficiaryActivities(_this2.selectedDate);
        if (response && response.success) {
          _this2.beneficiaryActivities = response.data || [];
          // Sort activities by timestamp (most recent first) for each beneficiary
          _this2.beneficiaryActivities.forEach(beneficiary => {
            beneficiary.activities.sort((a, b) => b.timestamp - a.timestamp);
          });
          // Sort beneficiaries by their latest activity (most recent first)
          _this2.beneficiaryActivities.sort((a, b) => {
            var _a$activities$, _b$activities$;
            const latestA = ((_a$activities$ = a.activities[0]) === null || _a$activities$ === void 0 ? void 0 : _a$activities$.timestamp) || 0;
            const latestB = ((_b$activities$ = b.activities[0]) === null || _b$activities$ === void 0 ? void 0 : _b$activities$.timestamp) || 0;
            return latestB - latestA;
          });
        } else {
          yield _this2.b.errorToast('Failed to load beneficiary activities');
          _this2.beneficiaryActivities = [];
        }
      } catch (error) {
        yield _this2.b.errorToast('Error loading activities');
        _this2.beneficiaryActivities = [];
      } finally {
        _this2.isLoading = false;
        if (event) {
          event.target.complete();
        }
      }
    })();
  }
  onDateChange() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.load();
    })();
  }
  getActivityDisplayName(activity) {
    if (activity.type === 'Survey Response' && activity.survey_type) {
      return activity.survey_type;
    }
    return activity.type;
  }
  getActivityColor(activityType) {
    const colorMap = {
      'Child Updated': 'primary',
      'PBW Updated': 'primary',
      'Measurement': 'success',
      'Distribution': 'warning',
      'Inpatient Care': 'danger',
      'Survey Response': 'tertiary',
      'Location Update': 'secondary',
      'Pregnancy History': 'medium',
      'Transfer Out': 'dark',
      // Survey types
      'IYCF Screening for children under 2': 'tertiary',
      'IYCF Screening for Pregnant women': 'tertiary',
      'IYCF - FULL ASSESSMENT FOR MOTHER BABY PAIR': 'tertiary',
      'IYCF-E ASSESSMENT FOR PREGNANT WOMEN': 'tertiary',
      'CFM - Ages 2-4 Year': 'tertiary',
      'WG Short Set on Functioning': 'tertiary',
      'Rapid Assessment for Infants less than 6 months': 'tertiary',
      'CFM - Age 5-17 Years': 'tertiary',
      'Exit Interview': 'tertiary',
      'PSS Rapid Assessment (WHO-5)': 'tertiary',
      'PSS In-depth Assessment (GHQ-12)': 'tertiary',
      'Home Visit - PBW': 'tertiary',
      'Child Home Visit - OTP/TSFP': 'tertiary',
      'OTP Children (<5)': 'tertiary',
      'TSFP Children (<5)': 'tertiary',
      'BSFP Children (6-23 Months)': 'tertiary',
      'TSFP PBW': 'tertiary',
      'BSFP PBW': 'tertiary',
      'Facility Supervision': 'tertiary',
      'Inpatient care treatment': 'danger',
      'NSFP Children (24-59 Months)': 'tertiary'
    };
    return colorMap[activityType] || 'medium';
  }
  formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleString('en-US', {
      month: 'short',
      day: 'numeric',
      year: 'numeric',
      hour: '2-digit',
      minute: '2-digit'
    });
  }
  formatTime(dateString) {
    const date = new Date(dateString);
    return date.toLocaleTimeString('en-US', {
      hour: '2-digit',
      minute: '2-digit',
      hour12: true
    });
  }
  calculateAge(dateOfBirth) {
    if (!dateOfBirth) {
      return 'N/A';
    }
    const today = new Date();
    const birthDate = new Date(dateOfBirth);
    const ageInMonths = (today.getFullYear() - birthDate.getFullYear()) * 12 + (today.getMonth() - birthDate.getMonth());
    if (ageInMonths < 12) {
      return `${ageInMonths} months`;
    } else {
      const years = Math.floor(ageInMonths / 12);
      const months = ageInMonths % 12;
      return months > 0 ? `${years}y ${months}m` : `${years} years`;
    }
  }
  navigateToDetail(beneficiary) {
    if (beneficiary.beneficiary_type === 'Child') {
      this.b.navigateForward(`/child-detail/${beneficiary.beneficiary_id}`);
    } else if (beneficiary.beneficiary_type === 'PLW') {
      this.b.navigateForward(`/woman-detail/${beneficiary.beneficiary_id}`);
    }
  }
  trackByBeneficiary(_index, item) {
    return item.beneficiary_id;
  }
}, _BeneficiaryActivityListPage.ctorParameters = () => [{
  type: src_app_services_beneficiary_activity_api_service__WEBPACK_IMPORTED_MODULE_4__.BeneficiaryActivityAPIService
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}], _BeneficiaryActivityListPage);
BeneficiaryActivityListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-beneficiary-activity-list',
  template: _beneficiary_activity_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_beneficiary_activity_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], BeneficiaryActivityListPage);


/***/ }),

/***/ 84430:
/*!**************************************************************!*\
  !*** ./src/app/services/beneficiary_activity_api.service.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BeneficiaryActivityAPIService: () => (/* binding */ BeneficiaryActivityAPIService)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 61318);


/* eslint-disable @typescript-eslint/naming-convention */




let BeneficiaryActivityAPIService = class BeneficiaryActivityAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_1__.APIBaseService {
  getBeneficiaryActivities(date) {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_2__.domain}/beneficiary-activities?date=${date}`;
      const options = _this.getHeader();
      return _this.http.get(url, options).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.catchError)(error => _this.errorHandle(error))).toPromise();
    })();
  }
};
BeneficiaryActivityAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Injectable)({
  providedIn: 'root'
})], BeneficiaryActivityAPIService);


/***/ }),

/***/ 54691:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-activity-list/beneficiary-activity-list.page.scss?ngResource ***!
  \************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.activity-container {
  max-width: 1200px;
  margin: 0 auto;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 1200px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.date-selector {
  display: flex;
  align-items: center;
  flex: 0 1 auto;
  min-width: 220px;
}
.date-selector .date-input {
  --background: rgba(73, 144, 226, 0.05);
  --border-radius: 12px;
  --padding-start: 12px;
  --padding-end: 12px;
  --min-height: 44px;
  border: 1px solid rgba(0, 0, 0, 0.08);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.date-selector .date-input ion-icon {
  margin-right: 8px;
  font-size: 20px;
}
.date-selector .date-input ion-input {
  font-size: 14px;
  font-weight: 500;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

ion-note {
  font-size: 13px;
  color: var(--ion-color-medium);
  font-weight: 500;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.activity-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 800px;
  table-layout: auto;
}
.activity-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 12px 8px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: nowrap;
}
.activity-table td {
  padding: 12px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.activity-table tbody tr {
  transition: all 0.2s ease;
}
.activity-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.activity-table tbody tr:last-child td {
  border-bottom: none;
}

.row-number {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: center;
  width: 50px;
  font-size: 15px;
  white-space: nowrap;
}

.name-cell {
  text-align: left !important;
  font-weight: 600;
  color: var(--ion-color-dark);
  min-width: 150px;
}

.type-cell {
  width: 100px;
}
.type-cell .type-badge {
  font-size: 12px;
  font-weight: 600;
  padding: 6px 12px;
  border-radius: 6px;
  text-transform: capitalize;
}

.activities-cell {
  text-align: left !important;
  width: auto;
  max-width: 400px;
  padding: 8px !important;
}

.activities-container {
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
  align-items: flex-start;
}

.activity-badge {
  display: inline-flex;
  flex-direction: column;
  align-items: flex-start;
  font-size: 11px;
  font-weight: 500;
  padding: 5px 8px;
  border-radius: 6px;
  white-space: nowrap;
  margin: 2px;
  gap: 2px;
}
.activity-badge .activity-type {
  font-weight: 600;
  font-size: 11px;
  line-height: 1.2;
}
.activity-badge .activity-time {
  font-size: 9px;
  font-weight: 400;
  opacity: 0.9;
  line-height: 1.2;
}

.actions-cell {
  width: 80px;
  text-align: center;
  white-space: nowrap;
}
.actions-cell ion-button {
  margin: 0 2px;
  --padding-start: 8px;
  --padding-end: 8px;
}
.actions-cell ion-button ion-icon {
  font-size: 18px;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 64px;
  margin-bottom: 16px;
  opacity: 0.4;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 300px;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .date-selector {
    width: 100%;
    min-width: auto;
  }
  .date-selector .date-input {
    width: 100%;
    --min-height: 42px;
  }
  .date-selector .date-input ion-icon {
    font-size: 18px;
  }
  .date-selector .date-input ion-input {
    font-size: 13px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .activity-table {
    font-size: 0.75rem;
    min-width: 700px;
  }
  .activity-table th, .activity-table td {
    padding: 8px 6px;
    font-size: 0.75rem;
  }
  .actions-cell {
    width: 70px;
  }
  .actions-cell ion-button {
    --padding-start: 6px;
    --padding-end: 6px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 16px;
  }
  .activity-badge {
    padding: 4px 6px;
    gap: 1px;
  }
  .activity-badge .activity-type {
    font-size: 10px;
  }
  .activity-badge .activity-time {
    font-size: 8px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .activity-table {
    font-size: 0.7rem;
    min-width: 650px;
  }
  .activity-table th, .activity-table td {
    padding: 6px 4px;
    font-size: 0.7rem;
  }
  .actions-cell {
    width: 60px;
  }
  .actions-cell ion-button {
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 14px;
  }
  .activity-badge {
    padding: 3px 5px;
    gap: 1px;
  }
  .activity-badge .activity-type {
    font-size: 9px;
  }
  .activity-badge .activity-time {
    font-size: 7px;
  }
  .empty-state {
    padding: 40px 16px;
  }
  .empty-state ion-icon {
    font-size: 48px;
  }
  .empty-state h3 {
    font-size: 16px;
  }
  .empty-state p {
    font-size: 13px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/beneficiary-activity-list/beneficiary-activity-list.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,iBAAA;EACA,cAAA;AADF;;AAIA;EACE,iBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,iBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAMA;EACE,aAAA;EACA,mBAAA;EACA,cAAA;EACA,gBAAA;AAHF;AAKE;EACE,sCAAA;EACA,qBAAA;EACA,qBAAA;EACA,mBAAA;EACA,kBAAA;EACA,qCAAA;EACA,yCAAA;AAHJ;AAKI;EACE,iBAAA;EACA,eAAA;AAHN;AAMI;EACE,eAAA;EACA,gBAAA;AAJN;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AAPF;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AAPF;AASE;EACE,eAAA;EACA,cAAA;AAPJ;;AAWA;EACE,eAAA;EACA,8BAAA;EACA,gBAAA;AARF;;AAYA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AATF;;AAaA;EACE,WAAA;EACA,yBAAA;EACA,gBAAA;EACA,kBAAA;AAVF;AAYE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;AAVJ;AAaE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAXJ;AAcE;EACE,yBAAA;AAZJ;AAcI;EACE,6CAAA;AAZN;AAgBE;EACE,mBAAA;AAdJ;;AAkBA;EACE,gBAAA;EACA,+BAAA;EACA,kBAAA;EACA,WAAA;EACA,eAAA;EACA,mBAAA;AAfF;;AAkBA;EACE,2BAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;AAfF;;AAkBA;EACE,YAAA;AAfF;AAiBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,0BAAA;AAfJ;;AAmBA;EACE,2BAAA;EACA,WAAA;EACA,gBAAA;EACA,uBAAA;AAhBF;;AAmBA;EACE,aAAA;EACA,eAAA;EACA,QAAA;EACA,uBAAA;AAhBF;;AAmBA;EACE,oBAAA;EACA,sBAAA;EACA,uBAAA;EACA,eAAA;EACA,gBAAA;EACA,gBAAA;EACA,kBAAA;EACA,mBAAA;EACA,WAAA;EACA,QAAA;AAhBF;AAkBE;EACE,gBAAA;EACA,eAAA;EACA,gBAAA;AAhBJ;AAmBE;EACE,cAAA;EACA,gBAAA;EACA,YAAA;EACA,gBAAA;AAjBJ;;AAqBA;EACE,WAAA;EACA,kBAAA;EACA,mBAAA;AAlBF;AAoBE;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AAlBJ;AAoBI;EACE,eAAA;AAlBN;;AAwBA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AArBF;AAuBE;EACE,eAAA;EACA,mBAAA;EACA,YAAA;AArBJ;AAwBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AAtBJ;AAyBE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;AAvBJ;;AA4BA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EAzBF;EA4BA;IACE,mBAAA;EA1BF;EA6BA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EA3BF;EA8BA;IACE,eAAA;IACA,WAAA;EA5BF;EA8BE;IACE,eAAA;EA5BJ;EAgCA;IACE,WAAA;IACA,eAAA;EA9BF;EAgCE;IACE,WAAA;IACA,kBAAA;EA9BJ;EAgCI;IACE,eAAA;EA9BN;EAiCI;IACE,eAAA;EA/BN;EAoCA;IACE,cAAA;IACA,SAAA;EAlCF;EAoCE;IACE,eAAA;EAlCJ;EAoCI;IACE,eAAA;EAlCN;EAuCA;IACE,kBAAA;IACA,gBAAA;EArCF;EAuCE;IACE,gBAAA;IACA,kBAAA;EArCJ;EAyCA;IACE,WAAA;EAvCF;EAyCE;IACE,oBAAA;IACA,kBAAA;EAvCJ;EAyCI;IACE,eAAA;EAvCN;EA4CA;IACE,gBAAA;IACA,QAAA;EA1CF;EA4CE;IACE,eAAA;EA1CJ;EA6CE;IACE,cAAA;EA3CJ;AACF;AA+CA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EA7CF;EAgDA;IACE,mBAAA;EA9CF;EAiDA;IACE,mBAAA;EA/CF;EAkDA;IACE,eAAA;EAhDF;EAkDE;IACE,eAAA;EAhDJ;EAoDA;IACE,cAAA;IACA,QAAA;EAlDF;EAoDE;IACE,eAAA;EAlDJ;EAoDI;IACE,eAAA;EAlDN;EAuDA;IACE,iBAAA;IACA,gBAAA;EArDF;EAuDE;IACE,gBAAA;IACA,iBAAA;EArDJ;EAyDA;IACE,WAAA;EAvDF;EAyDE;IACE,oBAAA;IACA,kBAAA;EAvDJ;EAyDI;IACE,eAAA;EAvDN;EA4DA;IACE,gBAAA;IACA,QAAA;EA1DF;EA4DE;IACE,cAAA;EA1DJ;EA6DE;IACE,cAAA;EA3DJ;EA+DA;IACE,kBAAA;EA7DF;EA+DE;IACE,eAAA;EA7DJ;EAgEE;IACE,eAAA;EA9DJ;EAiEE;IACE,eAAA;EA/DJ;AACF","sourcesContent":["// Styles matching facility-supervision design\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.activity-container {\n  max-width: 1200px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header\n.section-header-main {\n  max-width: 1200px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.date-selector {\n  display: flex;\n  align-items: center;\n  flex: 0 1 auto;\n  min-width: 220px;\n\n  .date-input {\n    --background: rgba(73, 144, 226, 0.05);\n    --border-radius: 12px;\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --min-height: 44px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n\n    ion-icon {\n      margin-right: 8px;\n      font-size: 20px;\n    }\n\n    ion-input {\n      font-size: 14px;\n      font-weight: 500;\n    }\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\nion-note {\n  font-size: 13px;\n  color: var(--ion-color-medium);\n  font-weight: 500;\n}\n\n// Table Container\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n// Activity Table Styles\n.activity-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 800px;\n  table-layout: auto;\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 12px 8px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: nowrap;\n  }\n\n  td {\n    padding: 12px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n.row-number {\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  text-align: center;\n  width: 50px;\n  font-size: 15px;\n  white-space: nowrap;\n}\n\n.name-cell {\n  text-align: left !important;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  min-width: 150px;\n}\n\n.type-cell {\n  width: 100px;\n\n  .type-badge {\n    font-size: 12px;\n    font-weight: 600;\n    padding: 6px 12px;\n    border-radius: 6px;\n    text-transform: capitalize;\n  }\n}\n\n.activities-cell {\n  text-align: left !important;\n  width: auto;\n  max-width: 400px;\n  padding: 8px !important;\n}\n\n.activities-container {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 6px;\n  align-items: flex-start;\n}\n\n.activity-badge {\n  display: inline-flex;\n  flex-direction: column;\n  align-items: flex-start;\n  font-size: 11px;\n  font-weight: 500;\n  padding: 5px 8px;\n  border-radius: 6px;\n  white-space: nowrap;\n  margin: 2px;\n  gap: 2px;\n\n  .activity-type {\n    font-weight: 600;\n    font-size: 11px;\n    line-height: 1.2;\n  }\n\n  .activity-time {\n    font-size: 9px;\n    font-weight: 400;\n    opacity: 0.9;\n    line-height: 1.2;\n  }\n}\n\n.actions-cell {\n  width: 80px;\n  text-align: center;\n  white-space: nowrap;\n\n  ion-button {\n    margin: 0 2px;\n    --padding-start: 8px;\n    --padding-end: 8px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n// Empty State\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 64px;\n    margin-bottom: 16px;\n    opacity: 0.4;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 300px;\n  }\n}\n\n// Mobile and Tablet Responsive Design\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .date-selector {\n    width: 100%;\n    min-width: auto;\n\n    .date-input {\n      width: 100%;\n      --min-height: 42px;\n\n      ion-icon {\n        font-size: 18px;\n      }\n\n      ion-input {\n        font-size: 13px;\n      }\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .activity-table {\n    font-size: 0.75rem;\n    min-width: 700px;\n\n    th, td {\n      padding: 8px 6px;\n      font-size: 0.75rem;\n    }\n  }\n\n  .actions-cell {\n    width: 70px;\n\n    ion-button {\n      --padding-start: 6px;\n      --padding-end: 6px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .activity-badge {\n    padding: 4px 6px;\n    gap: 1px;\n\n    .activity-type {\n      font-size: 10px;\n    }\n\n    .activity-time {\n      font-size: 8px;\n    }\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .activity-table {\n    font-size: 0.7rem;\n    min-width: 650px;\n\n    th, td {\n      padding: 6px 4px;\n      font-size: 0.7rem;\n    }\n  }\n\n  .actions-cell {\n    width: 60px;\n\n    ion-button {\n      --padding-start: 4px;\n      --padding-end: 4px;\n\n      ion-icon {\n        font-size: 14px;\n      }\n    }\n  }\n\n  .activity-badge {\n    padding: 3px 5px;\n    gap: 1px;\n\n    .activity-type {\n      font-size: 9px;\n    }\n\n    .activity-time {\n      font-size: 7px;\n    }\n  }\n\n  .empty-state {\n    padding: 40px 16px;\n\n    ion-icon {\n      font-size: 48px;\n    }\n\n    h3 {\n      font-size: 16px;\n    }\n\n    p {\n      font-size: 13px;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 30519:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/beneficiary-activity-list/beneficiary-activity-list.page.html?ngResource ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Beneficiary Activity</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"load($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n  <div *ngIf=\"!isLoading || beneficiaryActivities.length > 0; else skeleton\" class=\"activity-container\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon [name]=\"icons.TIME\" color=\"primary\"></ion-icon>\n        Today's Beneficiary Activity\n      </h2>\n    </div>\n\n    <!-- Table Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon [name]=\"icons.LIST\" color=\"primary\"></ion-icon>\n            Activity Records ({{beneficiaryActivities?.length || 0}})\n          </h2>\n        </div>\n        <ion-card-content *ngIf=\"beneficiaryActivities?.length > 0; else emptyState\">\n          <div class=\"table-container\">\n            <table class=\"activity-table\">\n              <thead>\n                <tr>\n                  <th>#</th>\n                  <th>Beneficiary</th>\n                  <th>Type</th>\n                  <th>FCN</th>\n                  <th>DOB</th>\n                  <th>Activities</th>\n                  <th>Actions</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr *ngFor=\"let beneficiary of beneficiaryActivities; trackBy: trackByBeneficiary; let i = index\" class=\"activity-row\">\n                  <td class=\"row-number\">{{ i + 1 }}</td>\n                  <td class=\"name-cell\">{{ beneficiary.name }}</td>\n                  <td class=\"type-cell\">\n                    <ion-badge [color]=\"beneficiary.beneficiary_type === 'Child' ? 'primary' : 'secondary'\" class=\"type-badge\">\n                      {{ beneficiary.beneficiary_type }}\n                    </ion-badge>\n                  </td>\n                  <td>{{ beneficiary.fcn || 'N/A' }}</td>\n                  <td>{{ beneficiary.date_of_birth | date:'dd/MM/yyyy' }}</td>\n                  <td class=\"activities-cell\">\n                    <div class=\"activities-container\">\n                      <ion-badge\n                        *ngFor=\"let activity of beneficiary.activities\"\n                        [color]=\"getActivityColor(getActivityDisplayName(activity))\"\n                        class=\"activity-badge\">\n                        <span class=\"activity-type\">{{ getActivityDisplayName(activity) }}</span>\n                        <span class=\"activity-time\">{{ formatTime(activity.date) }}</span>\n                      </ion-badge>\n                    </div>\n                  </td>\n                  <td class=\"actions-cell\">\n                    <ion-button fill=\"clear\" size=\"small\" (click)=\"navigateToDetail(beneficiary)\" color=\"success\" title=\"View Profile\">\n                      <ion-icon [name]=\"icons.EYE\"></ion-icon>\n                    </ion-button>\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n        </ion-card-content>\n\n        <!-- Empty State -->\n        <ng-template #emptyState>\n          <ion-card-content>\n            <div class=\"empty-state\">\n              <ion-icon [name]=\"icons.CALENDAR_CLEAR\" color=\"medium\"></ion-icon>\n              <h3>No Activities Found</h3>\n              <p>No beneficiary activities found for today</p>\n            </div>\n          </ion-card-content>\n        </ng-template>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_beneficiary-activity-list_beneficiary-activity-list_module_ts.js.map