"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["node_modules_capacitor_filesystem_dist_esm_web_js"],{

/***/ 40936:
/*!************************************************************!*\
  !*** ./node_modules/@capacitor/filesystem/dist/esm/web.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FilesystemWeb: () => (/* binding */ FilesystemWeb)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/core */ 14070);
/* harmony import */ var _definitions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./definitions */ 34868);



function resolve(path) {
  const posix = path.split('/').filter(item => item !== '.');
  const newPosix = [];
  posix.forEach(item => {
    if (item === '..' && newPosix.length > 0 && newPosix[newPosix.length - 1] !== '..') {
      newPosix.pop();
    } else {
      newPosix.push(item);
    }
  });
  return newPosix.join('/');
}
function isPathParent(parent, children) {
  parent = resolve(parent);
  children = resolve(children);
  const pathsA = parent.split('/');
  const pathsB = children.split('/');
  return parent !== children && pathsA.every((value, index) => value === pathsB[index]);
}
class FilesystemWeb extends _capacitor_core__WEBPACK_IMPORTED_MODULE_1__.WebPlugin {
  constructor() {
    var _this;
    super(...arguments);
    _this = this;
    this.DB_VERSION = 1;
    this.DB_NAME = 'Disc';
    this._writeCmds = ['add', 'put', 'delete'];
    /**
     * Function that performs a http request to a server and downloads the file to the specified destination
     *
     * @param options the options for the download operation
     * @returns a promise that resolves with the download file result
     */
    this.downloadFile = /*#__PURE__*/function () {
      var _ref = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        var _a, _b;
        const requestInit = (0,_capacitor_core__WEBPACK_IMPORTED_MODULE_1__.buildRequestInit)(options, options.webFetchExtra);
        const response = yield fetch(options.url, requestInit);
        let blob;
        if (!options.progress) blob = yield response.blob();else if (!(response === null || response === void 0 ? void 0 : response.body)) blob = new Blob();else {
          const reader = response.body.getReader();
          let bytes = 0;
          const chunks = [];
          const contentType = response.headers.get('content-type');
          const contentLength = parseInt(response.headers.get('content-length') || '0', 10);
          while (true) {
            const {
              done,
              value
            } = yield reader.read();
            if (done) break;
            chunks.push(value);
            bytes += (value === null || value === void 0 ? void 0 : value.length) || 0;
            const status = {
              url: options.url,
              bytes,
              contentLength
            };
            _this.notifyListeners('progress', status);
          }
          const allChunks = new Uint8Array(bytes);
          let position = 0;
          for (const chunk of chunks) {
            if (typeof chunk === 'undefined') continue;
            allChunks.set(chunk, position);
            position += chunk.length;
          }
          blob = new Blob([allChunks.buffer], {
            type: contentType || undefined
          });
        }
        const result = yield _this.writeFile({
          path: options.path,
          directory: (_a = options.directory) !== null && _a !== void 0 ? _a : undefined,
          recursive: (_b = options.recursive) !== null && _b !== void 0 ? _b : false,
          data: blob
        });
        return {
          path: result.uri,
          blob
        };
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
  }
  initDb() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2._db !== undefined) {
        return _this2._db;
      }
      if (!('indexedDB' in window)) {
        throw _this2.unavailable("This browser doesn't support IndexedDB");
      }
      return new Promise((resolve, reject) => {
        const request = indexedDB.open(_this2.DB_NAME, _this2.DB_VERSION);
        request.onupgradeneeded = FilesystemWeb.doUpgrade;
        request.onsuccess = () => {
          _this2._db = request.result;
          resolve(request.result);
        };
        request.onerror = () => reject(request.error);
        request.onblocked = () => {
          console.warn('db blocked');
        };
      });
    })();
  }
  static doUpgrade(event) {
    const eventTarget = event.target;
    const db = eventTarget.result;
    switch (event.oldVersion) {
      case 0:
      case 1:
      default:
        {
          if (db.objectStoreNames.contains('FileStorage')) {
            db.deleteObjectStore('FileStorage');
          }
          const store = db.createObjectStore('FileStorage', {
            keyPath: 'path'
          });
          store.createIndex('by_folder', 'folder');
        }
    }
  }
  dbRequest(cmd, args) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const readFlag = _this3._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';
      return _this3.initDb().then(conn => {
        return new Promise((resolve, reject) => {
          const tx = conn.transaction(['FileStorage'], readFlag);
          const store = tx.objectStore('FileStorage');
          const req = store[cmd](...args);
          req.onsuccess = () => resolve(req.result);
          req.onerror = () => reject(req.error);
        });
      });
    })();
  }
  dbIndexRequest(indexName, cmd, args) {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const readFlag = _this4._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';
      return _this4.initDb().then(conn => {
        return new Promise((resolve, reject) => {
          const tx = conn.transaction(['FileStorage'], readFlag);
          const store = tx.objectStore('FileStorage');
          const index = store.index(indexName);
          const req = index[cmd](...args);
          req.onsuccess = () => resolve(req.result);
          req.onerror = () => reject(req.error);
        });
      });
    })();
  }
  getPath(directory, uriPath) {
    const cleanedUriPath = uriPath !== undefined ? uriPath.replace(/^[/]+|[/]+$/g, '') : '';
    let fsPath = '';
    if (directory !== undefined) fsPath += '/' + directory;
    if (uriPath !== '') fsPath += '/' + cleanedUriPath;
    return fsPath;
  }
  clear() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const conn = yield _this5.initDb();
      const tx = conn.transaction(['FileStorage'], 'readwrite');
      const store = tx.objectStore('FileStorage');
      store.clear();
    })();
  }
  /**
   * Read a file from disk
   * @param options options for the file read
   * @return a promise that resolves with the read file data result
   */
  readFile(options) {
    var _this6 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this6.getPath(options.directory, options.path);
      // const encoding = options.encoding;
      const entry = yield _this6.dbRequest('get', [path]);
      if (entry === undefined) throw Error('File does not exist.');
      return {
        data: entry.content ? entry.content : ''
      };
    })();
  }
  /**
   * Write a file to disk in the specified location on device
   * @param options options for the file write
   * @return a promise that resolves with the file write result
   */
  writeFile(options) {
    var _this7 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this7.getPath(options.directory, options.path);
      let data = options.data;
      const encoding = options.encoding;
      const doRecursive = options.recursive;
      const occupiedEntry = yield _this7.dbRequest('get', [path]);
      if (occupiedEntry && occupiedEntry.type === 'directory') throw Error('The supplied path is a directory.');
      const parentPath = path.substr(0, path.lastIndexOf('/'));
      const parentEntry = yield _this7.dbRequest('get', [parentPath]);
      if (parentEntry === undefined) {
        const subDirIndex = parentPath.indexOf('/', 1);
        if (subDirIndex !== -1) {
          const parentArgPath = parentPath.substr(subDirIndex);
          yield _this7.mkdir({
            path: parentArgPath,
            directory: options.directory,
            recursive: doRecursive
          });
        }
      }
      if (!encoding && !(data instanceof Blob)) {
        data = data.indexOf(',') >= 0 ? data.split(',')[1] : data;
        if (!_this7.isBase64String(data)) throw Error('The supplied data is not valid base64 content.');
      }
      const now = Date.now();
      const pathObj = {
        path: path,
        folder: parentPath,
        type: 'file',
        size: data instanceof Blob ? data.size : data.length,
        ctime: now,
        mtime: now,
        content: data
      };
      yield _this7.dbRequest('put', [pathObj]);
      return {
        uri: pathObj.path
      };
    })();
  }
  /**
   * Append to a file on disk in the specified location on device
   * @param options options for the file append
   * @return a promise that resolves with the file write result
   */
  appendFile(options) {
    var _this8 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this8.getPath(options.directory, options.path);
      let data = options.data;
      const encoding = options.encoding;
      const parentPath = path.substr(0, path.lastIndexOf('/'));
      const now = Date.now();
      let ctime = now;
      const occupiedEntry = yield _this8.dbRequest('get', [path]);
      if (occupiedEntry && occupiedEntry.type === 'directory') throw Error('The supplied path is a directory.');
      const parentEntry = yield _this8.dbRequest('get', [parentPath]);
      if (parentEntry === undefined) {
        const subDirIndex = parentPath.indexOf('/', 1);
        if (subDirIndex !== -1) {
          const parentArgPath = parentPath.substr(subDirIndex);
          yield _this8.mkdir({
            path: parentArgPath,
            directory: options.directory,
            recursive: true
          });
        }
      }
      if (!encoding && !_this8.isBase64String(data)) throw Error('The supplied data is not valid base64 content.');
      if (occupiedEntry !== undefined) {
        if (occupiedEntry.content instanceof Blob) {
          throw Error('The occupied entry contains a Blob object which cannot be appended to.');
        }
        if (occupiedEntry.content !== undefined && !encoding) {
          data = btoa(atob(occupiedEntry.content) + atob(data));
        } else {
          data = occupiedEntry.content + data;
        }
        ctime = occupiedEntry.ctime;
      }
      const pathObj = {
        path: path,
        folder: parentPath,
        type: 'file',
        size: data.length,
        ctime: ctime,
        mtime: now,
        content: data
      };
      yield _this8.dbRequest('put', [pathObj]);
    })();
  }
  /**
   * Delete a file from disk
   * @param options options for the file delete
   * @return a promise that resolves with the deleted file data result
   */
  deleteFile(options) {
    var _this9 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this9.getPath(options.directory, options.path);
      const entry = yield _this9.dbRequest('get', [path]);
      if (entry === undefined) throw Error('File does not exist.');
      const entries = yield _this9.dbIndexRequest('by_folder', 'getAllKeys', [IDBKeyRange.only(path)]);
      if (entries.length !== 0) throw Error('Folder is not empty.');
      yield _this9.dbRequest('delete', [path]);
    })();
  }
  /**
   * Create a directory.
   * @param options options for the mkdir
   * @return a promise that resolves with the mkdir result
   */
  mkdir(options) {
    var _this0 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this0.getPath(options.directory, options.path);
      const doRecursive = options.recursive;
      const parentPath = path.substr(0, path.lastIndexOf('/'));
      const depth = (path.match(/\//g) || []).length;
      const parentEntry = yield _this0.dbRequest('get', [parentPath]);
      const occupiedEntry = yield _this0.dbRequest('get', [path]);
      if (depth === 1) throw Error('Cannot create Root directory');
      if (occupiedEntry !== undefined) throw Error('Current directory does already exist.');
      if (!doRecursive && depth !== 2 && parentEntry === undefined) throw Error('Parent directory must exist');
      if (doRecursive && depth !== 2 && parentEntry === undefined) {
        const parentArgPath = parentPath.substr(parentPath.indexOf('/', 1));
        yield _this0.mkdir({
          path: parentArgPath,
          directory: options.directory,
          recursive: doRecursive
        });
      }
      const now = Date.now();
      const pathObj = {
        path: path,
        folder: parentPath,
        type: 'directory',
        size: 0,
        ctime: now,
        mtime: now
      };
      yield _this0.dbRequest('put', [pathObj]);
    })();
  }
  /**
   * Remove a directory
   * @param options the options for the directory remove
   */
  rmdir(options) {
    var _this1 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const {
        path,
        directory,
        recursive
      } = options;
      const fullPath = _this1.getPath(directory, path);
      const entry = yield _this1.dbRequest('get', [fullPath]);
      if (entry === undefined) throw Error('Folder does not exist.');
      if (entry.type !== 'directory') throw Error('Requested path is not a directory');
      const readDirResult = yield _this1.readdir({
        path,
        directory
      });
      if (readDirResult.files.length !== 0 && !recursive) throw Error('Folder is not empty');
      for (const entry of readDirResult.files) {
        const entryPath = `${path}/${entry.name}`;
        const entryObj = yield _this1.stat({
          path: entryPath,
          directory
        });
        if (entryObj.type === 'file') {
          yield _this1.deleteFile({
            path: entryPath,
            directory
          });
        } else {
          yield _this1.rmdir({
            path: entryPath,
            directory,
            recursive
          });
        }
      }
      yield _this1.dbRequest('delete', [fullPath]);
    })();
  }
  /**
   * Return a list of files from the directory (not recursive)
   * @param options the options for the readdir operation
   * @return a promise that resolves with the readdir directory listing result
   */
  readdir(options) {
    var _this10 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this10.getPath(options.directory, options.path);
      const entry = yield _this10.dbRequest('get', [path]);
      if (options.path !== '' && entry === undefined) throw Error('Folder does not exist.');
      const entries = yield _this10.dbIndexRequest('by_folder', 'getAllKeys', [IDBKeyRange.only(path)]);
      const files = yield Promise.all(entries.map(/*#__PURE__*/function () {
        var _ref2 = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (e) {
          let subEntry = yield _this10.dbRequest('get', [e]);
          if (subEntry === undefined) {
            subEntry = yield _this10.dbRequest('get', [e + '/']);
          }
          return {
            name: e.substring(path.length + 1),
            type: subEntry.type,
            size: subEntry.size,
            ctime: subEntry.ctime,
            mtime: subEntry.mtime,
            uri: subEntry.path
          };
        });
        return function (_x2) {
          return _ref2.apply(this, arguments);
        };
      }()));
      return {
        files: files
      };
    })();
  }
  /**
   * Return full File URI for a path and directory
   * @param options the options for the stat operation
   * @return a promise that resolves with the file stat result
   */
  getUri(options) {
    var _this11 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this11.getPath(options.directory, options.path);
      let entry = yield _this11.dbRequest('get', [path]);
      if (entry === undefined) {
        entry = yield _this11.dbRequest('get', [path + '/']);
      }
      return {
        uri: (entry === null || entry === void 0 ? void 0 : entry.path) || path
      };
    })();
  }
  /**
   * Return data about a file
   * @param options the options for the stat operation
   * @return a promise that resolves with the file stat result
   */
  stat(options) {
    var _this12 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const path = _this12.getPath(options.directory, options.path);
      let entry = yield _this12.dbRequest('get', [path]);
      if (entry === undefined) {
        entry = yield _this12.dbRequest('get', [path + '/']);
      }
      if (entry === undefined) throw Error('Entry does not exist.');
      return {
        type: entry.type,
        size: entry.size,
        ctime: entry.ctime,
        mtime: entry.mtime,
        uri: entry.path
      };
    })();
  }
  /**
   * Rename a file or directory
   * @param options the options for the rename operation
   * @return a promise that resolves with the rename result
   */
  rename(options) {
    var _this13 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this13._copy(options, true);
      return;
    })();
  }
  /**
   * Copy a file or directory
   * @param options the options for the copy operation
   * @return a promise that resolves with the copy result
   */
  copy(options) {
    var _this14 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return _this14._copy(options, false);
    })();
  }
  requestPermissions() {
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return {
        publicStorage: 'granted'
      };
    })();
  }
  checkPermissions() {
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return {
        publicStorage: 'granted'
      };
    })();
  }
  /**
   * Function that can perform a copy or a rename
   * @param options the options for the rename operation
   * @param doRename whether to perform a rename or copy operation
   * @return a promise that resolves with the result
   */
  _copy(_x3) {
    var _this15 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options, doRename = false) {
      let {
        toDirectory
      } = options;
      const {
        to,
        from,
        directory: fromDirectory
      } = options;
      if (!to || !from) {
        throw Error('Both to and from must be provided');
      }
      // If no "to" directory is provided, use the "from" directory
      if (!toDirectory) {
        toDirectory = fromDirectory;
      }
      const fromPath = _this15.getPath(fromDirectory, from);
      const toPath = _this15.getPath(toDirectory, to);
      // Test that the "to" and "from" locations are different
      if (fromPath === toPath) {
        return {
          uri: toPath
        };
      }
      if (isPathParent(fromPath, toPath)) {
        throw Error('To path cannot contain the from path');
      }
      // Check the state of the "to" location
      let toObj;
      try {
        toObj = yield _this15.stat({
          path: to,
          directory: toDirectory
        });
      } catch (e) {
        // To location does not exist, ensure the directory containing "to" location exists and is a directory
        const toPathComponents = to.split('/');
        toPathComponents.pop();
        const toPath = toPathComponents.join('/');
        // Check the containing directory of the "to" location exists
        if (toPathComponents.length > 0) {
          const toParentDirectory = yield _this15.stat({
            path: toPath,
            directory: toDirectory
          });
          if (toParentDirectory.type !== 'directory') {
            throw new Error('Parent directory of the to path is a file');
          }
        }
      }
      // Cannot overwrite a directory
      if (toObj && toObj.type === 'directory') {
        throw new Error('Cannot overwrite a directory with a file');
      }
      // Ensure the "from" object exists
      const fromObj = yield _this15.stat({
        path: from,
        directory: fromDirectory
      });
      // Set the mtime/ctime of the supplied path
      const updateTime = /*#__PURE__*/function () {
        var _ref3 = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (path, ctime, mtime) {
          const fullPath = _this15.getPath(toDirectory, path);
          const entry = yield _this15.dbRequest('get', [fullPath]);
          entry.ctime = ctime;
          entry.mtime = mtime;
          yield _this15.dbRequest('put', [entry]);
        });
        return function updateTime(_x4, _x5, _x6) {
          return _ref3.apply(this, arguments);
        };
      }();
      const ctime = fromObj.ctime ? fromObj.ctime : Date.now();
      switch (fromObj.type) {
        // The "from" object is a file
        case 'file':
          {
            // Read the file
            const file = yield _this15.readFile({
              path: from,
              directory: fromDirectory
            });
            // Optionally remove the file
            if (doRename) {
              yield _this15.deleteFile({
                path: from,
                directory: fromDirectory
              });
            }
            let encoding;
            if (!(file.data instanceof Blob) && !_this15.isBase64String(file.data)) {
              encoding = _definitions__WEBPACK_IMPORTED_MODULE_2__.Encoding.UTF8;
            }
            // Write the file to the new location
            const writeResult = yield _this15.writeFile({
              path: to,
              directory: toDirectory,
              data: file.data,
              encoding: encoding
            });
            // Copy the mtime/ctime of a renamed file
            if (doRename) {
              yield updateTime(to, ctime, fromObj.mtime);
            }
            // Resolve promise
            return writeResult;
          }
        case 'directory':
          {
            if (toObj) {
              throw Error('Cannot move a directory over an existing object');
            }
            try {
              // Create the to directory
              yield _this15.mkdir({
                path: to,
                directory: toDirectory,
                recursive: false
              });
              // Copy the mtime/ctime of a renamed directory
              if (doRename) {
                yield updateTime(to, ctime, fromObj.mtime);
              }
            } catch (e) {
              // ignore
            }
            // Iterate over the contents of the from location
            const contents = (yield _this15.readdir({
              path: from,
              directory: fromDirectory
            })).files;
            for (const filename of contents) {
              // Move item from the from directory to the to directory
              yield _this15._copy({
                from: `${from}/${filename.name}`,
                to: `${to}/${filename.name}`,
                directory: fromDirectory,
                toDirectory
              }, doRename);
            }
            // Optionally remove the original from directory
            if (doRename) {
              yield _this15.rmdir({
                path: from,
                directory: fromDirectory
              });
            }
          }
      }
      return {
        uri: toPath
      };
    }).apply(this, arguments);
  }
  isBase64String(str) {
    try {
      return btoa(atob(str)) == str;
    } catch (err) {
      return false;
    }
  }
}
FilesystemWeb._debug = true;

/***/ })

}]);
//# sourceMappingURL=node_modules_capacitor_filesystem_dist_esm_web_js.js.map