"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["default-src_app_constants_icons_constants_ts-src_app_services_api_base_service_ts"],{

/***/ 35997:
/*!**********************************************!*\
  !*** ./src/app/constants/icons.constants.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ICONS: () => (/* binding */ ICONS),
/* harmony export */   ICON_GROUPS: () => (/* binding */ ICON_GROUPS)
/* harmony export */ });
/**
 * Centralized Icon Constants
 * All Ionicons used throughout the application
 *
 * Usage:
 * import { ICONS } from '@app/constants/icons.constants';
 * <ion-icon [name]="ICONS.CALENDAR"></ion-icon>
 */
const ICONS = {
  // Navigation & UI
  HOME: 'home-outline',
  MENU: 'menu-outline',
  CLOSE: 'close',
  CLOSE_CIRCLE: 'close-circle-outline',
  SEARCH: 'search-outline',
  FILTER: 'filter-outline',
  REFRESH: 'refresh-outline',
  SETTINGS: 'settings-outline',
  CHEVRON_UP: 'chevron-up-outline',
  CHEVRON_DOWN: 'chevron-down-outline',
  CHEVRON_BACK: 'chevron-back-outline',
  CHEVRON_FORWARD: 'chevron-forward-outline',
  ARROW_BACK: 'arrow-back-outline',
  ARROW_FORWARD: 'arrow-forward-outline',
  // Actions
  ADD: 'add-outline',
  ADD_CIRCLE: 'add-circle-outline',
  EDIT: 'create-outline',
  DELETE: 'trash-outline',
  SAVE: 'save-outline',
  DOWNLOAD: 'download-outline',
  UPLOAD: 'cloud-upload-outline',
  SHARE: 'share-outline',
  COPY: 'copy-outline',
  EYE: 'eye-outline',
  EYE_OFF: 'eye-off-outline',
  // People & Users
  PERSON: 'person-outline',
  PERSON_CIRCLE: 'person-circle-outline',
  PEOPLE: 'people-outline',
  PEOPLE_CIRCLE: 'people-circle-outline',
  WOMAN: 'woman-outline',
  MAN: 'man-outline',
  MALE: 'male-outline',
  FEMALE: 'female-outline',
  MALE_FEMALE: 'male-female-outline',
  // Medical & Health
  MEDICAL: 'medical-outline',
  MEDKIT: 'medkit-outline',
  FITNESS: 'fitness-outline',
  ACCESSIBILITY: 'accessibility-outline',
  HEART: 'heart-outline',
  PULSE: 'pulse-outline',
  HAPPY: 'happy-outline',
  SAD: 'sad-outline',
  FLAME: 'flame-outline',
  // Measurements & Data
  RESIZE: 'resize-outline',
  SCALE: 'scale-outline',
  STATS_CHART: 'stats-chart-outline',
  BAR_CHART: 'bar-chart-outline',
  PIE_CHART: 'pie-chart-outline',
  ANALYTICS: 'analytics-outline',
  // Date & Time
  CALENDAR: 'calendar-outline',
  CALENDAR_NUMBER: 'calendar-number-outline',
  CALENDAR_CLEAR: 'calendar-clear-outline',
  TIME: 'time-outline',
  TODAY: 'today-outline',
  STOPWATCH: 'stopwatch-outline',
  // Location
  LOCATION: 'location-outline',
  MAP: 'map-outline',
  NAVIGATE: 'navigate-outline',
  HOME_LOCATION: 'home-outline',
  // Documents & Files
  DOCUMENT: 'document-outline',
  DOCUMENT_TEXT: 'document-text-outline',
  DOCUMENTS: 'documents-outline',
  FOLDER: 'folder-outline',
  FOLDER_OPEN: 'folder-open-outline',
  LIST: 'list-outline',
  LIST_CIRCLE: 'list-circle-outline',
  CLIPBOARD: 'clipboard-outline',
  // Distribution & Supply
  CUBE: 'cube-outline',
  BOX: 'cube-outline',
  GIFT: 'gift-outline',
  CART: 'cart-outline',
  // Communication & Info
  INFORMATION: 'information-outline',
  INFORMATION_CIRCLE: 'information-circle-outline',
  HELP: 'help-outline',
  HELP_CIRCLE: 'help-circle-outline',
  ALERT: 'alert-outline',
  ALERT_CIRCLE: 'alert-circle-outline',
  WARNING: 'warning-outline',
  NOTIFICATIONS: 'notifications-outline',
  MAIL: 'mail-outline',
  CALL: 'call-outline',
  CHATBUBBLE: 'chatbubble-outline',
  // Security & Verification
  SHIELD: 'shield-outline',
  SHIELD_CHECKMARK: 'shield-checkmark-outline',
  LOCK_CLOSED: 'lock-closed-outline',
  LOCK_OPEN: 'lock-open-outline',
  KEY: 'key-outline',
  // Status & State
  CHECKMARK: 'checkmark-outline',
  CHECKMARK_CIRCLE: 'checkmark-circle-outline',
  CHECKMARK_DONE: 'checkmark-done-outline',
  CLOSE_OUTLINE: 'close-outline',
  REMOVE_CIRCLE: 'remove-circle-outline',
  // Transfer & Movement
  SWAP_HORIZONTAL: 'swap-horizontal-outline',
  SWAP_VERTICAL: 'swap-vertical-outline',
  ENTER: 'log-in-outline',
  EXIT: 'exit-outline',
  REPEAT: 'repeat-outline',
  SYNC: 'sync-outline',
  // ID & Cards
  ID_CARD: 'id-card-outline',
  CARD: 'card-outline',
  BARCODE: 'barcode-outline',
  // Misc
  CAMERA: 'camera-outline',
  IMAGE: 'image-outline',
  IMAGES: 'images-outline',
  ELLIPSIS_HORIZONTAL: 'ellipsis-horizontal-outline',
  ELLIPSIS_VERTICAL: 'ellipsis-vertical-outline',
  FINGERPRINT: 'fingerprint-outline',
  BLUETOOTH: 'bluetooth-outline',
  WIFI: 'wifi-outline',
  BATTERY_FULL: 'battery-full-outline',
  POWER: 'power-outline',
  OPTIONS: 'options-outline',
  BODY: 'body-outline',
  PODIUM: 'podium-outline',
  NUTRITION: 'nutrition-outline',
  BASKET: 'basket-outline',
  CLOUD_OFFLINE: 'cloud-offline-outline',
  APPS: 'apps-outline',
  ARROW_UNDO: 'arrow-undo-outline',
  BUSINESS: 'business-outline',
  CODE: 'code-outline',
  GRID: 'grid-outline',
  HAND_LEFT: 'hand-left-outline',
  HOURGLASS: 'hourglass-outline',
  LAYERS: 'layers-outline',
  LINK: 'link-outline',
  PERSON_ADD: 'person-add-outline',
  SEND: 'send-outline',
  TRENDING_UP: 'trending-up-outline',
  QR_CODE: 'qr-code-outline',
  CALCULATOR: 'calculator-outline',
  CHATBOX: 'chatbox-outline',
  CHATBUBBLES: 'chatbubbles-outline',
  CHECKBOX: 'checkbox-outline',
  GIT_BRANCH: 'git-branch-outline',
  PRICETAG: 'pricetag-outline',
  RECEIPT: 'receipt-outline',
  WATER: 'water-outline',
  // Custom Icons (md- prefix - may need verification)
  MD_HOUSE: 'md-house',
  MD_CHILDREN: 'md-children',
  MD_PREGNANT: 'md-pregnant',
  MD_PREPAREDNESS: 'md-Preparedness',
  MD_DISTRIBUTION_SITE: 'md-Distribution-site',
  MD_PREVIOUS_ITEM: 'md-Previous-item',
  MD_OUT_OF_PLATFORM: 'md-Out-of-platform'
};
/**
 * Icon Groups for easier organization
 */
const ICON_GROUPS = {
  GENDER: {
    MALE: ICONS.MALE,
    FEMALE: ICONS.FEMALE,
    MALE_FEMALE: ICONS.MALE_FEMALE
  },
  PEOPLE: {
    PERSON: ICONS.PERSON,
    PEOPLE: ICONS.PEOPLE,
    WOMAN: ICONS.WOMAN,
    MAN: ICONS.MAN
  },
  ACTIONS: {
    ADD: ICONS.ADD,
    EDIT: ICONS.EDIT,
    DELETE: ICONS.DELETE,
    VIEW: ICONS.EYE,
    SAVE: ICONS.SAVE
  },
  MEASUREMENTS: {
    RESIZE: ICONS.RESIZE,
    SCALE: ICONS.SCALE,
    FITNESS: ICONS.FITNESS,
    ACCESSIBILITY: ICONS.ACCESSIBILITY
  },
  NUTRITION_STATUS: {
    SAM: ICONS.FLAME,
    MAM: ICONS.MEDKIT,
    NORMAL: ICONS.HAPPY,
    WASTING: ICONS.FITNESS,
    STUNTING: ICONS.ACCESSIBILITY,
    UNDERWEIGHT: ICONS.SCALE
  },
  TRANSFER: {
    ADMISSION: ICONS.ENTER,
    DISCHARGE: ICONS.EXIT,
    FOLLOW_UP: ICONS.REPEAT,
    TRANSFER: ICONS.SWAP_HORIZONTAL
  },
  NAVIGATION: {
    BACK: ICONS.CHEVRON_BACK,
    FORWARD: ICONS.CHEVRON_FORWARD,
    UP: ICONS.CHEVRON_UP,
    DOWN: ICONS.CHEVRON_DOWN,
    HOME: ICONS.HOME
  }
};

/***/ }),

/***/ 70014:
/*!**********************************************!*\
  !*** ./src/app/services/api_base.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   APIBaseService: () => (/* binding */ APIBaseService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./global */ 99328);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
var _APIBaseService;

/* eslint-disable eqeqeq */

/* eslint-disable @typescript-eslint/naming-convention */




let APIBaseService = (_APIBaseService = class APIBaseService {
  constructor(http, g, b, store) {
    this.http = http;
    this.g = g;
    this.b = b;
    this.store = store;
  }
  getHeader(params = {}) {
    // Get token from current user if g.jws is not available
    let token = this.g.jws;
    if (!token) {
      const currentUser = this.b.getCurrentUser();
      token = currentUser === null || currentUser === void 0 ? void 0 : currentUser.token;
    }
    return {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpHeaders({
        Authorization: token
      }),
      params
    };
  }
  errorHandle(err) {
    let message = '';
    let detailedErrors = null;
    // Extract error details from response
    if (err !== null && err !== void 0 && err.error) {
      // Backend error format: {success: false, message: string, data?: object|string}
      message = err.error.message || err.message;
      detailedErrors = err.error.data;
    } else {
      message = err.message;
    }
    // Handle specific HTTP status codes
    switch (err.status) {
      case 0:
        // Network error
        message = 'Failed reaching server!!! Make sure you are connected to internet or camp site network.';
        this.b.errorToast(message);
        break;
      case 400:
        // Bad Request
        message = message || 'Bad request. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 401:
        // Unauthorized - token expired
        message = message || 'Session expired. Please login again.';
        this.b.errorToast(message);
        setTimeout(() => {
          this.b.logout('token_expired');
        }, 3000);
        break;
      case 403:
        // Forbidden
        message = message || 'Access denied. You do not have permission to perform this action.';
        this.b.errorToast(message);
        break;
      case 404:
        // Not Found
        message = message || 'Resource not found.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 422:
        // Validation Error (Unprocessable Entity)
        message = message || 'Validation failed. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 500:
        // Internal Server Error
        message = message || 'Internal server error. Please try again later.';
        this.b.errorToast(message);
        break;
      case 503:
        // Service Unavailable
        message = message || 'Service unavailable. Please try again later.';
        this.b.errorToast(message);
        break;
      default:
        // Other errors
        message = message || 'Unknown error occurred. Make sure you are connected and retry.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
    }
    return Promise.resolve({
      message: this.formatErrorMessage(message, detailedErrors),
      success: false,
      data: detailedErrors
    });
  }
  /**
   * Format error message with detailed validation errors or data
   */
  formatErrorMessage(mainMessage, detailedErrors) {
    if (!detailedErrors) {
      return mainMessage;
    }
    // If detailedErrors is a string (like the data field from backend)
    if (typeof detailedErrors === 'string') {
      return `${mainMessage} - ${detailedErrors}`;
    }
    // If detailedErrors is an object with field-specific errors (validation errors)
    if (typeof detailedErrors === 'object' && !Array.isArray(detailedErrors)) {
      const errorMessages = [mainMessage];
      Object.keys(detailedErrors).forEach(field => {
        const fieldErrors = detailedErrors[field];
        if (Array.isArray(fieldErrors)) {
          fieldErrors.forEach(error => errorMessages.push(`• ${error}`));
        } else if (typeof fieldErrors === 'string') {
          errorMessages.push(`• ${fieldErrors}`);
        }
      });
      return errorMessages.join('\n');
    }
    return mainMessage;
  }
}, _APIBaseService.ctorParameters = () => [{
  type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient
}, {
  type: _global__WEBPACK_IMPORTED_MODULE_0__.GlobalProvider
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_3__.Store
}], _APIBaseService);
APIBaseService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], APIBaseService);


/***/ })

}]);
//# sourceMappingURL=default-src_app_constants_icons_constants_ts-src_app_services_api_base_service_ts.js.map