(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_woman-add-edit_add-plw_module_ts"],{

/***/ 39995:
/*!****************************************************************!*\
  !*** ./src/app/pages/woman-add-edit/add-plw-routing.module.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddPlwPageRoutingModule: () => (/* binding */ AddPlwPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _add_plw_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./add-plw.page */ 72461);




const routes = [{
  path: '',
  component: _add_plw_page__WEBPACK_IMPORTED_MODULE_0__.AddPlwPage
}, {
  path: 'edit/:id',
  component: _add_plw_page__WEBPACK_IMPORTED_MODULE_0__.AddPlwPage
}];
let AddPlwPageRoutingModule = class AddPlwPageRoutingModule {};
AddPlwPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AddPlwPageRoutingModule);


/***/ }),

/***/ 37082:
/*!********************************************************!*\
  !*** ./src/app/pages/woman-add-edit/add-plw.module.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddPlwPageModule: () => (/* binding */ AddPlwPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _add_plw_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./add-plw-routing.module */ 39995);
/* harmony import */ var _add_plw_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-plw.page */ 72461);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);







let AddPlwPageModule = class AddPlwPageModule {};
AddPlwPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule, _add_plw_routing_module__WEBPACK_IMPORTED_MODULE_0__.AddPlwPageRoutingModule],
  declarations: [_add_plw_page__WEBPACK_IMPORTED_MODULE_1__.AddPlwPage]
})], AddPlwPageModule);


/***/ }),

/***/ 72461:
/*!******************************************************!*\
  !*** ./src/app/pages/woman-add-edit/add-plw.page.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddPlwPage: () => (/* binding */ AddPlwPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _add_plw_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-plw.page.html?ngResource */ 67531);
/* harmony import */ var _add_plw_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-plw.page.scss?ngResource */ 9377);
/* harmony import */ var _add_plw_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_add_plw_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _services_woman_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../services/woman_api.service */ 11975);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/baseHelper */ 76434);
/* harmony import */ var _util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 95072);

var _AddPlwPage;



/* eslint-disable max-len */

/* eslint-disable @typescript-eslint/naming-convention */






let AddPlwPage = (_AddPlwPage = class AddPlwPage {
  constructor(fb, api, b, router, activatedRoute) {
    this.fb = fb;
    this.api = api;
    this.b = b;
    this.router = router;
    this.activatedRoute = activatedRoute;
    this.today = new Date().toISOString().split('T')[0];
    this.maxDate = (() => {
      const date = new Date();
      date.setFullYear(date.getFullYear() - 10);
      return date.toISOString().split('T')[0];
    })();
    this.subBlocks = [];
    this.blockMajhis = [];
    this.subBlockMajhis = [];
    this.allSubBlockMajhis = [];
    this.caregivers = [];
    this.blocks = [];
    this.availableSubBlocks = [];
    this.selectedSubBlockMajhi = null;
    // Edit mode properties
    this.isEditMode = false;
    this.womanDataLoaded = false;
    this.regDataLoaded = false;
    this.tempLocationData = null;
    //construction work
    this.setUpForm();
    if (!this.isEditMode) {
      var _this$b$getCurrentUse;
      this.registerFrom.get('inf_id').setValue((_this$b$getCurrentUse = this.b.getCurrentUser()) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.user) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.profile) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.default_inf) === null || _this$b$getCurrentUse === void 0 ? void 0 : _this$b$getCurrentUse.id);
    }
  }
  setUpForm() {
    this.registerFrom = this.fb.group({
      inf_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      block_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      sub_block_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      majhi_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      sub_block_majhi_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      caregiver_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      caregiver_name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      hh_no: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      husband: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      father: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      date_of_birth: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.datePattern), this.minimumAgeValidator(10)]],
      age: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]],
      phone: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.mobilePattern)]],
      fcn: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      case_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      moha_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      progress_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      scope_no: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      mother_support_status: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]]
    });
    const progressIdControl = this.registerFrom.get('progress_id');
    progressIdControl.valueChanges.subscribe(value => {
      if (value) {
        progressIdControl.setValue(value.toUpperCase(), {
          emitEvent: false
        });
      }
    });
    const dobControl = this.registerFrom.get('date_of_birth');
    const ageControl = this.registerFrom.get('age');
    let isUpdatingFromDob = false;
    let isUpdatingFromAge = false;
    dobControl === null || dobControl === void 0 || dobControl.valueChanges.subscribe(dob => {
      if (isUpdatingFromAge) return;
      isUpdatingFromDob = true;
      if (dob) {
        const birthDate = new Date(dob);
        const today = new Date();
        let years = today.getFullYear() - birthDate.getFullYear();
        let months = today.getMonth() - birthDate.getMonth();
        if (today.getDate() < birthDate.getDate()) {
          months--;
        }
        if (months < 0) {
          years--;
          months += 12;
        }
        ageControl === null || ageControl === void 0 || ageControl.setValue(`${years} years ${months} months`);
      } else {
        ageControl === null || ageControl === void 0 || ageControl.setValue('');
      }
      isUpdatingFromDob = false;
    });
  }
  ngOnInit() {
    this.activatedRoute.paramMap.subscribe(paramMap => {
      const id = paramMap.get('id');
      // Check if we're on the edit route (woman-edit/:id) or edit sub-route (add-plw/edit/:id)
      const currentUrl = this.router.url;
      if (id && (currentUrl.includes('woman-edit') || currentUrl.includes('/edit/'))) {
        this.isEditMode = true;
        this.plwId = id;
        this.updateValidatorsBasedOnMode();
        this.loadEditData(id);
      } else {
        this.isEditMode = false;
        this.updateValidatorsBasedOnMode();
        this.womanDataLoaded = true;
      }
    });
    this.load();
  }
  load() {
    this.api.womanRegistrationData().then(data => {
      this.beneficiaryRegPreqData = data.data;
      this.blocks = data.data.block_majhi || [];
      this.caregivers = data.data.caregivers || [];
      this.allSubBlockMajhis = data.data.sub_block_sub_majhi || [];
      this.regDataLoaded = true;
      // If we're in edit mode and have loaded the woman data, update the form with location data
      if (this.isEditMode && this.womanDataLoaded) {
        this.updateLocationInForm();
      }
    });
  }
  submit(formGroup) {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Mark all fields as touched to show validation errors
      _this.markFormGroupTouched(formGroup);
      // Comprehensive validation with detailed error messages
      const validationErrors = _this.validateFormFields(formGroup);
      if (validationErrors.length > 0) {
        // Show the first validation error
        _this.b.errorToast(validationErrors[0]);
        return;
      }
      if (formGroup.valid) {
        if (_this.isEditMode) {
          const result = yield _this.api.updateWoman(formGroup.value, _this.plwId);
          yield _this.b.responseToast(result);
          if (result.success) {
            _this.b.navigateWithParam(_this.b.routesConfig.plwList, {
              reload: true
            });
            return;
          }
        } else {
          const result = yield _this.api.storeWoman(formGroup.value);
          yield _this.b.responseToast(result);
          if (result.success) {
            _this.router.navigate([_this.b.routesConfig.beneficiaryAssessment + result.data.id + '/plw'], {
              queryParams: {
                from: 'woman-add'
              },
              replaceUrl: true
            });
            return;
          }
          yield _this.b.errorToast(result.message);
        }
      } else {
        // If form is invalid but no custom validation errors were caught
        const formErrors = _this.getDetailedFormErrors();
        _this.b.errorToast(formErrors || 'Please fill out all required fields correctly');
      }
    })();
  }
  onBlockSelected(event) {
    const selectedBlockMajhiId = this.getFormFieldValue('block_id');
    // Reset dependencies first
    this.resetBlocDependencies();
    // Find and set the selected block using block_majhi.id
    this.selectedBlock = this.blocks.find(item => item.id === selectedBlockMajhiId);
    if (this.selectedBlock) {
      var _this$registerFrom$ge;
      // Auto-fill block majhi when block is selected (same value as block_id)
      (_this$registerFrom$ge = this.registerFrom.get('majhi_id')) === null || _this$registerFrom$ge === void 0 || _this$registerFrom$ge.setValue(this.selectedBlock.id);
      // Populate available sub-blocks for the selected block using the actual block.id
      this.availableSubBlocks = this.allSubBlockMajhis.filter(item => item.block_id === this.selectedBlock.block.id);
    }
  }
  loadEditData(id) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this2.api.getWoman(id);
        const woman = response.data;
        const locationInfo = woman.current_location;
        // Format date for form
        let formattedDob = '';
        if (woman.date_of_birth) {
          formattedDob = new Date(woman.date_of_birth).toISOString().split('T')[0];
        }
        // Determine mother support status based on caregiver data
        let motherSupportStatus = 'yes'; // Default to 'yes'
        // If caregiver_id or caregiver_name exists, ALWAYS set to 'no' (overrides API status)
        if (woman.caregiver_id || woman.caregiver_name) {
          motherSupportStatus = 'no';
        }
        // Only use explicit mother_support_status from API if no caregiver data exists
        else if (woman.mother_support_status) {
          // Normalize the API value to lowercase for consistency
          motherSupportStatus = woman.mother_support_status.toLowerCase();
        }
        // Ensure the value is always 'yes' or 'no' (normalize)
        motherSupportStatus = motherSupportStatus === 'yes' || motherSupportStatus === 'Yes' || motherSupportStatus === 'YES' ? 'yes' : 'no';
        // Patch form with PLW data directly from root level
        const formData = {
          name: woman.name,
          husband: woman.husband,
          father: woman.father,
          date_of_birth: formattedDob,
          phone: woman.phone,
          fcn: woman.fcn,
          case_id: woman.case_id,
          progress_id: woman.progress_id,
          scope_no: woman.scope_no,
          caregiver_id: woman.caregiver_id,
          caregiver_name: woman.caregiver_name,
          mother_support_status: motherSupportStatus
        };
        _this2.registerFrom.patchValue(formData);
        // Trigger mother support status change to set validators correctly
        _this2.onMotherSupportStatusChange();
        // Trigger age calculation if date of birth is present
        if (formattedDob) {
          _this2.calculateAgeFromDob(formattedDob);
        }
        // Handle location data from current_location
        if (locationInfo) {
          const locationData = {
            block_id: locationInfo.block_id,
            sub_block_id: locationInfo.sub_block_id,
            sub_block_majhi_id: locationInfo.sub_block_majhi_id,
            hh_no: locationInfo.hh_no,
            inf_id: locationInfo.inf_id,
            majhi_id: locationInfo.majhi_id
          };
          _this2.registerFrom.patchValue(locationData);
          // Store location data temporarily if blocks not loaded yet
          _this2.tempLocationData = locationInfo;
          // Try to set location data now if blocks are available
          if (_this2.blocks.length > 0) {
            _this2.updateLocationInForm();
          }
        }
        _this2.womanDataLoaded = true;
        // Update location if registration data is already loaded
        if (_this2.regDataLoaded) {
          _this2.updateLocationInForm();
        }
      } catch (error) {
        _this2.b.errorToast('Error loading PLW data');
      }
    })();
  }
  updateLocationInForm() {
    if (!this.tempLocationData || this.blocks.length === 0) {
      return;
    }
    const currentLocation = this.tempLocationData;
    // Find and set the selected block using block_majhi information
    if (currentLocation.block_id) {
      // For edit mode, create selected block from current_location data
      if (currentLocation.block_majhi) {
        var _this$registerFrom$ge2, _this$registerFrom$ge3;
        this.selectedBlock = {
          id: currentLocation.majhi_id,
          block: currentLocation.block_majhi.block,
          majhi_title: currentLocation.block_majhi.majhi_title || `${currentLocation.block_majhi.block.title} Block Majhi`
        };
        // Set both block_id and majhi_id to the same value (majhi_id)
        (_this$registerFrom$ge2 = this.registerFrom.get('block_id')) === null || _this$registerFrom$ge2 === void 0 || _this$registerFrom$ge2.setValue(this.selectedBlock.id);
        (_this$registerFrom$ge3 = this.registerFrom.get('majhi_id')) === null || _this$registerFrom$ge3 === void 0 || _this$registerFrom$ge3.setValue(this.selectedBlock.id);
      } else {
        // Fallback to finding from blocks array using the original block_id
        this.selectedBlock = this.blocks.find(item => item.block.id === currentLocation.block_id);
        if (this.selectedBlock) {
          var _this$registerFrom$ge4, _this$registerFrom$ge5;
          // Set both block_id and majhi_id to the same value (block_majhi.id)
          (_this$registerFrom$ge4 = this.registerFrom.get('block_id')) === null || _this$registerFrom$ge4 === void 0 || _this$registerFrom$ge4.setValue(this.selectedBlock.id);
          (_this$registerFrom$ge5 = this.registerFrom.get('majhi_id')) === null || _this$registerFrom$ge5 === void 0 || _this$registerFrom$ge5.setValue(this.selectedBlock.id);
        }
      }
      // Populate available sub-blocks for the selected block
      this.availableSubBlocks = this.allSubBlockMajhis.filter(item => item.block_id === currentLocation.block_id);
      // If there's a sub_block_majhi_id in current location, find and set the selected sub-block
      if (currentLocation.sub_block_majhi_id) {
        this.selectedSubBlockMajhi = this.availableSubBlocks.find(item => item.id === currentLocation.sub_block_majhi_id);
        // If not found in availableSubBlocks, create from current_location.sub_block_sub_majhi
        if (!this.selectedSubBlockMajhi && currentLocation.sub_block_sub_majhi) {
          this.selectedSubBlockMajhi = {
            id: currentLocation.sub_block_sub_majhi.id,
            block_id: currentLocation.sub_block_sub_majhi.block_id,
            sub_block_title: currentLocation.sub_block_sub_majhi.sub_block_title,
            sub_block_majhi: currentLocation.sub_block_sub_majhi.sub_block_majhi
          };
        }
      }
      // Also handle case where sub_block_id exists but sub_block_majhi_id doesn't
      else if (currentLocation.sub_block_id) {
        this.selectedSubBlockMajhi = this.availableSubBlocks.find(item => item.id === currentLocation.sub_block_id);
        // Auto-fill the sub_block_majhi_id
        if (this.selectedSubBlockMajhi) {
          var _this$registerFrom$ge6;
          (_this$registerFrom$ge6 = this.registerFrom.get('sub_block_majhi_id')) === null || _this$registerFrom$ge6 === void 0 || _this$registerFrom$ge6.setValue(this.selectedSubBlockMajhi.id);
        }
      }
    }
  }
  onSubBlockSelected() {
    const selectedSubBlockId = this.getFormFieldValue('sub_block_id');
    // Find the selected sub-block and auto-fill sub-block majhi
    this.selectedSubBlockMajhi = this.availableSubBlocks.find(item => item.id === selectedSubBlockId);
    if (this.selectedSubBlockMajhi) {
      var _this$registerFrom$ge7;
      // Auto-fill sub-block majhi ID (same as sub-block ID)
      (_this$registerFrom$ge7 = this.registerFrom.get('sub_block_majhi_id')) === null || _this$registerFrom$ge7 === void 0 || _this$registerFrom$ge7.setValue(this.selectedSubBlockMajhi.id);
    }
  }
  resetBlocDependencies() {
    this.resetFormFieldValue('sub_block_id');
    this.resetFormFieldValue('majhi_id');
    this.resetFormFieldValue('sub_block_majhi_id');
    this.selectedSubBlockMajhi = null;
    this.availableSubBlocks = [];
  }
  resetSubBlocDependencies() {
    this.resetFormFieldValue('sub_block_majhi_id');
  }
  /**
   * Value getter
   */
  getFormFieldValue(key) {
    var _this$registerFrom$ge8;
    return (_this$registerFrom$ge8 = this.registerFrom.get(key)) === null || _this$registerFrom$ge8 === void 0 ? void 0 : _this$registerFrom$ge8.value;
  }
  resetFormFieldValue(key) {
    var _this$registerFrom$ge9;
    (_this$registerFrom$ge9 = this.registerFrom.get(key)) === null || _this$registerFrom$ge9 === void 0 || _this$registerFrom$ge9.setValue(null);
  }
  calculateAgeFromDob(dob) {
    if (dob) {
      const birthDate = new Date(dob);
      const today = new Date();
      let years = today.getFullYear() - birthDate.getFullYear();
      let months = today.getMonth() - birthDate.getMonth();
      if (today.getDate() < birthDate.getDate()) {
        months--;
      }
      if (months < 0) {
        years--;
        months += 12;
      }
      const ageControl = this.registerFrom.get('age');
      ageControl === null || ageControl === void 0 || ageControl.setValue(`${years} years ${months} months`);
    }
  }
  shouldShowCaregiverSection() {
    return this.getFormFieldValue('mother_support_status') === 'no';
  }
  onMotherSupportStatusChange() {
    const status = this.getFormFieldValue('mother_support_status');
    const caregiverIdControl = this.registerFrom.get('caregiver_id');
    const caregiverNameControl = this.registerFrom.get('caregiver_name');
    if (status === 'no') {
      // Make caregiver fields required when mother can't take care
      caregiverIdControl === null || caregiverIdControl === void 0 || caregiverIdControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
      caregiverNameControl === null || caregiverNameControl === void 0 || caregiverNameControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]);
    } else {
      // Make caregiver fields optional when mother can take care
      caregiverIdControl === null || caregiverIdControl === void 0 || caregiverIdControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
      caregiverNameControl === null || caregiverNameControl === void 0 || caregiverNameControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]);
      // Clear caregiver fields
      this.registerFrom.patchValue({
        caregiver_id: null,
        caregiver_name: null
      });
    }
    // Update validity
    caregiverIdControl === null || caregiverIdControl === void 0 || caregiverIdControl.updateValueAndValidity();
    caregiverNameControl === null || caregiverNameControl === void 0 || caregiverNameControl.updateValueAndValidity();
  }
  updateValidatorsBasedOnMode() {
    const blockControl = this.registerFrom.get('block_id');
    const subBlockControl = this.registerFrom.get('sub_block_id');
    if (this.isEditMode) {
      // In edit mode, location fields are readonly so not required
      blockControl === null || blockControl === void 0 || blockControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
      subBlockControl === null || subBlockControl === void 0 || subBlockControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
    } else {
      // In add mode, location fields are required
      blockControl === null || blockControl === void 0 || blockControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
      subBlockControl === null || subBlockControl === void 0 || subBlockControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]);
    }
    blockControl === null || blockControl === void 0 || blockControl.updateValueAndValidity();
    subBlockControl === null || subBlockControl === void 0 || subBlockControl.updateValueAndValidity();
  }
  minimumAgeValidator(minAge) {
    return control => {
      if (!control.value) {
        return null;
      }
      const birthDate = new Date(control.value);
      const today = new Date();
      const age = today.getFullYear() - birthDate.getFullYear();
      const monthDiff = today.getMonth() - birthDate.getMonth();
      let actualAge = age;
      if (monthDiff < 0 || monthDiff === 0 && today.getDate() < birthDate.getDate()) {
        actualAge--;
      }
      return actualAge < minAge ? {
        minimumAge: {
          requiredAge: minAge,
          actualAge
        }
      } : null;
    };
  }
  validateFormFields(formGroup) {
    var _formGroup$get5, _formGroup$get6, _formGroup$get7, _formGroup$get8, _formGroup$get9;
    const errors = [];
    // Check required fields based on mode
    if (!this.isEditMode) {
      var _formGroup$get, _formGroup$get2, _formGroup$get3, _formGroup$get4;
      // Block validation for add mode
      if (!((_formGroup$get = formGroup.get('block_id')) !== null && _formGroup$get !== void 0 && _formGroup$get.value)) {
        errors.push('Block selection is required');
      }
      // Sub-block validation for add mode
      if (!((_formGroup$get2 = formGroup.get('sub_block_id')) !== null && _formGroup$get2 !== void 0 && _formGroup$get2.value)) {
        errors.push('Sub-Block selection is required');
      }
      // Progress ID validation for add mode
      const progressIdValue = (_formGroup$get3 = formGroup.get('progress_id')) === null || _formGroup$get3 === void 0 ? void 0 : _formGroup$get3.value;
      if (!progressIdValue || progressIdValue.trim() === '') {
        errors.push('Progress ID is required');
      }
      // FCN validation for add mode
      const fcnValue = (_formGroup$get4 = formGroup.get('fcn')) === null || _formGroup$get4 === void 0 ? void 0 : _formGroup$get4.value;
      if (!fcnValue || fcnValue.trim() === '') {
        errors.push('Family Count Number (FCN) is required');
      }
    }
    // PBW name validation
    const nameValue = (_formGroup$get5 = formGroup.get('name')) === null || _formGroup$get5 === void 0 ? void 0 : _formGroup$get5.value;
    if (!nameValue || nameValue.trim() === '') {
      errors.push('PBW name is required');
    }
    // Husband name validation
    const husbandValue = (_formGroup$get6 = formGroup.get('husband')) === null || _formGroup$get6 === void 0 ? void 0 : _formGroup$get6.value;
    if (!husbandValue || husbandValue.trim() === '') {
      errors.push('Husband name is required');
    }
    // Date of birth validation
    const dobValue = (_formGroup$get7 = formGroup.get('date_of_birth')) === null || _formGroup$get7 === void 0 ? void 0 : _formGroup$get7.value;
    if (!dobValue || dobValue.trim() === '') {
      errors.push('Date of birth is required');
    }
    // Mother support status validation
    const motherSupportValue = (_formGroup$get8 = formGroup.get('mother_support_status')) === null || _formGroup$get8 === void 0 ? void 0 : _formGroup$get8.value;
    if (!motherSupportValue || motherSupportValue.trim() === '') {
      errors.push('Mother care capability selection is required');
    }
    // Household number validation - now optional
    // const hhNoValue = formGroup.get('hh_no')?.value;
    // if (!hhNoValue || hhNoValue.trim() === '') {
    //   errors.push('Household number is required');
    // }
    // Infrastructure ID validation
    const infIdValue = (_formGroup$get9 = formGroup.get('inf_id')) === null || _formGroup$get9 === void 0 ? void 0 : _formGroup$get9.value;
    if (!infIdValue || infIdValue.toString().trim() === '') {
      errors.push('Infrastructure ID is required');
    }
    // Pattern validations
    this.validatePatterns(formGroup, errors);
    return errors;
  }
  validatePatterns(formGroup, errors) {
    // FCN pattern validation
    const fcnControl = formGroup.get('fcn');
    if (fcnControl !== null && fcnControl !== void 0 && fcnControl.value && fcnControl.hasError('pattern')) {
      errors.push('FCN format is invalid');
    }
    // Progress ID pattern validation
    const progressIdControl = formGroup.get('progress_id');
    if (progressIdControl !== null && progressIdControl !== void 0 && progressIdControl.value && progressIdControl.hasError('pattern')) {
      errors.push('Progress ID format is invalid');
    }
    // Name pattern validation
    const nameControl = formGroup.get('name');
    if (nameControl !== null && nameControl !== void 0 && nameControl.value && nameControl.hasError('pattern')) {
      errors.push('PBW name contains invalid characters');
    }
    // Husband name pattern validation
    const husbandControl = formGroup.get('husband');
    if (husbandControl !== null && husbandControl !== void 0 && husbandControl.value && husbandControl.hasError('pattern')) {
      errors.push('Husband name contains invalid characters');
    }
    // Father name pattern validation
    const fatherControl = formGroup.get('father');
    if (fatherControl !== null && fatherControl !== void 0 && fatherControl.value && fatherControl.hasError('pattern')) {
      errors.push('Father name contains invalid characters');
    }
    // Date of birth validation (including minimum age)
    const dobControl = formGroup.get('date_of_birth');
    if (dobControl !== null && dobControl !== void 0 && dobControl.value) {
      if (dobControl.hasError('pattern')) {
        errors.push('Date of birth format is invalid');
      }
      if (dobControl.hasError('minimumAge')) {
        var _dobControl$errors;
        const minAge = ((_dobControl$errors = dobControl.errors) === null || _dobControl$errors === void 0 || (_dobControl$errors = _dobControl$errors['minimumAge']) === null || _dobControl$errors === void 0 ? void 0 : _dobControl$errors.requiredAge) || 10;
        errors.push(`PBW must be at least ${minAge} years old`);
      }
    }
    // Phone pattern validation
    const phoneControl = formGroup.get('phone');
    if (phoneControl !== null && phoneControl !== void 0 && phoneControl.value && phoneControl.hasError('pattern')) {
      errors.push('Phone number format is invalid');
    }
    // Number pattern validations for IDs
    const numberFields = ['inf_id', 'block_id', 'sub_block_id', 'majhi_id', 'sub_block_majhi_id', 'caregiver_id'];
    numberFields.forEach(field => {
      const control = formGroup.get(field);
      if (control !== null && control !== void 0 && control.value && control.hasError('pattern')) {
        const fieldName = this.getFieldDisplayName(field);
        errors.push(`${fieldName} must be a valid number`);
      }
    });
  }
  getFieldDisplayName(fieldName) {
    const displayNames = {
      'name': 'PBW Name',
      'husband': 'Husband Name',
      'father': 'Father Name',
      'date_of_birth': 'Date of Birth',
      'phone': 'Phone Number',
      'fcn': 'Family Count Number (FCN)',
      'case_id': 'Case ID',
      'progress_id': 'Progress ID',
      'scope_no': 'Scope ID',
      'mnr_no': 'MNR Number',
      'moha_id': 'MOHA ID',
      'mother_support_status': 'Mother Care Capability',
      'caregiver_id': 'Caregiver Type',
      'caregiver_name': 'Caregiver Name',
      'inf_id': 'Infrastructure ID',
      'block_id': 'Block',
      'sub_block_id': 'Sub Block',
      'majhi_id': 'Majhi',
      'sub_block_majhi_id': 'Sub Block Majhi',
      'hh_no': 'Household Number'
    };
    return displayNames[fieldName] || fieldName;
  }
  getDetailedFormErrors() {
    const errors = [];
    const formErrors = this.getFormErrors();
    for (const [fieldName, fieldErrors] of Object.entries(formErrors)) {
      const displayName = this.getFieldDisplayName(fieldName);
      if (fieldErrors['required']) {
        errors.push(`${displayName} is required`);
      }
      if (fieldErrors['pattern']) {
        errors.push(`${displayName} format is invalid`);
      }
      if (fieldErrors['minimumAge']) {
        const minAge = fieldErrors['minimumAge'].requiredAge || 10;
        errors.push(`${displayName} must be at least ${minAge} years old`);
      }
    }
    return errors.length > 0 ? errors[0] : 'Please check all fields and try again';
  }
  getFormErrors() {
    let formErrors = {};
    Object.keys(this.registerFrom.controls).forEach(key => {
      var _this$registerFrom$ge0;
      const controlErrors = (_this$registerFrom$ge0 = this.registerFrom.get(key)) === null || _this$registerFrom$ge0 === void 0 ? void 0 : _this$registerFrom$ge0.errors;
      if (controlErrors) {
        formErrors[key] = controlErrors;
      }
    });
    return formErrors;
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      control === null || control === void 0 || control.markAsTouched();
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
        this.markFormGroupTouched(control);
      }
    });
  }
  getFieldErrorMessage(fieldName) {
    const control = this.registerFrom.get(fieldName);
    if (control && control.invalid && control.touched) {
      if (control.hasError('required')) {
        return `${this.getFieldDisplayName(fieldName)} is required`;
      }
      if (control.hasError('pattern')) {
        return `${this.getFieldDisplayName(fieldName)} format is invalid`;
      }
      if (control.hasError('minimumAge')) {
        var _control$errors;
        const minAge = ((_control$errors = control.errors) === null || _control$errors === void 0 || (_control$errors = _control$errors['minimumAge']) === null || _control$errors === void 0 ? void 0 : _control$errors.requiredAge) || 10;
        return `${this.getFieldDisplayName(fieldName)} must be at least ${minAge} years old`;
      }
    }
    return '';
  }
  isFieldInvalid(fieldName) {
    const control = this.registerFrom.get(fieldName);
    return !!(control && control.invalid && control.touched);
  }
}, _AddPlwPage.ctorParameters = () => [{
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder
}, {
  type: _services_woman_api_service__WEBPACK_IMPORTED_MODULE_3__.WomanAPIService
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.Router
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute
}], _AddPlwPage);
AddPlwPage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_9__.Component)({
  selector: 'app-add-plw',
  template: _add_plw_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_add_plw_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AddPlwPage);


/***/ }),

/***/ 9377:
/*!*******************************************************************!*\
  !*** ./src/app/pages/woman-add-edit/add-plw.page.scss?ngResource ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.plw-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.plw-form .form-section {
  margin-bottom: 32px;
}
.plw-form .form-section:last-child {
  margin-bottom: 0;
}
.plw-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.plw-form .section-subtitle ion-icon {
  font-size: 20px;
}
.plw-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.plw-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.plw-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.plw-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.plw-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.plw-form .form-item.auto-filled-item {
  background: rgba(45, 211, 111, 0.05);
  border-color: rgba(45, 211, 111, 0.2);
}
.plw-form .form-item.auto-filled-item .auto-filled-input {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
}
.plw-form .form-item.auto-filled-item ion-label {
  color: var(--ion-color-success) !important;
  font-weight: 600;
}

.info-tip {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 12px 16px;
  background: rgba(73, 144, 226, 0.1);
  border-radius: 8px;
  margin-bottom: 16px;
  border-left: 4px solid var(--ion-color-primary);
}
.info-tip ion-icon {
  font-size: 18px;
}
.info-tip span {
  color: var(--ion-color-primary-shade);
  font-size: 14px;
  font-weight: 500;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-primary), transparent);
  border-radius: 1px;
}

@media (min-width: 768px) {
  .plw-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .submit-btn {
    min-width: 200px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
  .info-tip {
    padding: 10px 12px;
  }
  .info-tip span {
    font-size: 13px;
  }
}
@media (prefers-color-scheme: dark) {
  .form-item.auto-filled-item {
    background: rgba(45, 211, 111, 0.08);
    border-color: rgba(45, 211, 111, 0.3);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
  .info-tip {
    background: rgba(73, 144, 226, 0.15);
    border-left-color: var(--ion-color-primary-tint);
  }
}
@media (prefers-reduced-motion: reduce) {
  * {
    transition: none !important;
    animation: none !important;
  }
}
@media (prefers-contrast: high) {
  .form-item {
    border-width: 2px;
  }
  .section-subtitle {
    border-bottom-width: 3px;
  }
  ion-label {
    font-weight: 600;
  }
}
.radio-item {
  --padding-start: 0;
  --inner-padding-end: 0;
  margin-bottom: 8px;
}
.radio-item ion-radio {
  margin-right: 12px;
}
.radio-item ion-label {
  font-size: 16px;
  color: var(--ion-color-dark);
}

ion-radio-group {
  display: flex;
  flex-direction: column;
  gap: 4px;
  margin-top: 8px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/woman-add-edit/add-plw.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAaE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAXJ;AAaI;EACE,gBAAA;EACA,4BAAA;AAXN;AAcI;EACE,eAAA;EACA,eAAA;AAZN;AAcM;EACE,8BAAA;AAZR;AAeM;EACE,8BAAA;AAbR;AAkBI;EACE,oCAAA;EACA,qCAAA;AAhBN;AAkBM;EACE,uCAAA;EACA,gBAAA;AAhBR;AAmBM;EACE,0CAAA;EACA,gBAAA;AAjBR;;AAwBA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,kBAAA;EACA,mCAAA;EACA,kBAAA;EACA,mBAAA;EACA,+CAAA;AArBF;AAuBE;EACE,eAAA;AArBJ;AAwBE;EACE,qCAAA;EACA,eAAA;EACA,gBAAA;AAtBJ;;AA2BA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AAxBF;AA0BE;EACE,gBAAA;AAxBJ;AA0BI;EACE,YAAA;EACA,mBAAA;AAxBN;;AA8BA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA3BF;AA6BE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AA3BJ;AA8BE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AA5BJ;;AAiCA;EACE,oBAAA;EACA,kBAAA;AA9BF;AAgCE;EACE,uCAAA;EACA,gBAAA;EACA,eAAA;AA9BJ;;AAkCA;EACE,oBAAA;EACA,kBAAA;AA/BF;;AAmCA;EACE,qCAAA;AAhCF;AAkCE;EACE,8BAAA;AAhCJ;;AAoCA;EACE,sCAAA;AAjCF;;AAqCA;EACE,gBAAA;AAlCF;AAoCE;EACE,cAAA;EACA,oBAAA;AAlCJ;;AAuCA;EACE,kBAAA;AApCF;AAsCE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AApCJ;;AAyCA;EACE;IACE,gBAAA;EAtCF;EAyCA;IACE,gBAAA;EAvCF;EA0CA;IACE,eAAA;EAxCF;EA0CE;IACE,eAAA;EAxCJ;EA4CA;IACE,eAAA;EA1CF;EA4CE;IACE,eAAA;EA1CJ;EA8CA;IACE,gBAAA;EA5CF;EA8CE;IACE,gBAAA;EA5CJ;EAgDA;IACE,kBAAA;EA9CF;EAgDE;IACE,WAAA;IACA,YAAA;EA9CJ;EAiDE;IACE,eAAA;EA/CJ;AACF;AAoDA;EACE;IACE,eAAA;EAlDF;EAoDE;IACE,eAAA;EAlDJ;EAsDA;IACE,eAAA;EApDF;EAsDE;IACE,eAAA;EApDJ;EAwDA;IACE,sBAAA;IACA,gBAAA;EAtDF;EAwDE;IACE,WAAA;IACA,eAAA;EAtDJ;EA0DA;IACE,kBAAA;EAxDF;EA0DE;IACE,eAAA;EAxDJ;EA4DA;IACE,kBAAA;EA1DF;EA4DE;IACE,eAAA;EA1DJ;AACF;AA+DA;EACE;IACE,oCAAA;IACA,qCAAA;EA7DF;EAgEA;;IAEE,6BAAA;EA9DF;EAiEA;IACE,oCAAA;IACA,gDAAA;EA/DF;AACF;AAmEA;EACE;IACE,2BAAA;IACA,0BAAA;EAjEF;AACF;AAqEA;EACE;IACE,iBAAA;EAnEF;EAsEA;IACE,wBAAA;EApEF;EAuEA;IACE,gBAAA;EArEF;AACF;AAyEA;EACE,kBAAA;EACA,sBAAA;EACA,kBAAA;AAvEF;AAyEE;EACE,kBAAA;AAvEJ;AA0EE;EACE,eAAA;EACA,4BAAA;AAxEJ;;AA4EA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,eAAA;AAzEF","sourcesContent":["// PLW Add Form Styles - Following Supply-In Design Patterns\n\n// Container styling\n.plw-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  \n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.plw-form {\n  .form-section {\n    margin-bottom: 32px;\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n    \n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n    \n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n      \n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n      \n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n    \n    // Auto-filled item styling\n    &.auto-filled-item {\n      background: rgba(45, 211, 111, 0.05);\n      border-color: rgba(45, 211, 111, 0.2);\n      \n      .auto-filled-input {\n        --color: var(--ion-color-success-shade);\n        font-weight: 500;\n      }\n      \n      ion-label {\n        color: var(--ion-color-success) !important;\n        font-weight: 600;\n      }\n    }\n  }\n}\n\n// Info tip styling\n.info-tip {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  padding: 12px 16px;\n  background: rgba(73, 144, 226, 0.1);\n  border-radius: 8px;\n  margin-bottom: 16px;\n  border-left: 4px solid var(--ion-color-primary);\n  \n  ion-icon {\n    font-size: 18px;\n  }\n  \n  span {\n    color: var(--ion-color-primary-shade);\n    font-size: 14px;\n    font-weight: 500;\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n  \n  .submit-btn {\n    min-width: 180px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n  \n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n  \n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  \n  &[readonly] {\n    --color: var(--ion-color-success-shade);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n  \n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n  \n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Enhanced visual indicators for headers\n.section-header .section-title {\n  position: relative;\n  \n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-primary), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .plw-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n  \n  .section-title {\n    font-size: 24px;\n    \n    ion-icon {\n      font-size: 28px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .form-actions {\n    margin-top: 32px;\n    \n    .submit-btn {\n      min-width: 200px;\n    }\n  }\n  \n  .loading-container {\n    padding: 80px 40px;\n    \n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n    \n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 14px;\n    \n    ion-icon {\n      font-size: 18px;\n    }\n  }\n  \n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n    \n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n  \n  .loading-container {\n    padding: 40px 16px;\n    \n    p {\n      font-size: 12px;\n    }\n  }\n  \n  .info-tip {\n    padding: 10px 12px;\n    \n    span {\n      font-size: 13px;\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .form-item.auto-filled-item {\n    background: rgba(45, 211, 111, 0.08);\n    border-color: rgba(45, 211, 111, 0.3);\n  }\n  \n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n  \n  .info-tip {\n    background: rgba(73, 144, 226, 0.15);\n    border-left-color: var(--ion-color-primary-tint);\n  }\n}\n\n// Accessibility improvements\n@media (prefers-reduced-motion: reduce) {\n  * {\n    transition: none !important;\n    animation: none !important;\n  }\n}\n\n// High contrast mode\n@media (prefers-contrast: high) {\n  .form-item {\n    border-width: 2px;\n  }\n  \n  .section-subtitle {\n    border-bottom-width: 3px;\n  }\n  \n  ion-label {\n    font-weight: 600;\n  }\n}\n\n// Radio button styling\n.radio-item {\n  --padding-start: 0;\n  --inner-padding-end: 0;\n  margin-bottom: 8px;\n  \n  ion-radio {\n    margin-right: 12px;\n  }\n  \n  ion-label {\n    font-size: 16px;\n    color: var(--ion-color-dark);\n  }\n}\n\nion-radio-group {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n  margin-top: 8px;\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 67531:
/*!*******************************************************************!*\
  !*** ./src/app/pages/woman-add-edit/add-plw.page.html?ngResource ***!
  \*******************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{isEditMode ? 'Edit Mother' : 'Add Mother'}}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"beneficiaryRegPreqData; else loading\" class=\"plw-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"{{isEditMode ? 'create-outline' : 'person-add-outline'}}\" color=\"primary\"></ion-icon>\n        {{isEditMode ? 'Edit Mother Information' : 'Add New Mother'}}\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"registerFrom\" (ngSubmit)=\"submit(registerFrom)\" class=\"plw-form\">\n\n            <!-- Location Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"location-outline\" color=\"primary\"></ion-icon>\n                {{isEditMode ? 'Current Location Information' : 'Location Information'}}\n              </h3>\n\n              <!-- Block Selection - Readonly in Edit Mode -->\n              <ion-item class=\"form-item\" *ngIf=\"!isEditMode\" [class.ion-invalid]=\"isFieldInvalid('block_id')\">\n                <ion-icon slot=\"start\" name=\"location-outline\" [color]=\"isFieldInvalid('block_id') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Select Block *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"block_id\" (ionChange)=\"onBlockSelected($event)\" placeholder=\"Choose your block\">\n                  <ion-select-option *ngFor=\"let blockMajhi of blocks\" [value]=\"blockMajhi.id\">{{blockMajhi.block.title}}</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('block_id')\">\n                  {{getFieldErrorMessage('block_id')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- Block Display - Readonly for Edit Mode -->\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"isEditMode && selectedBlock\">\n                <ion-icon slot=\"start\" name=\"location-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Block</ion-label>\n                <ion-input [value]=\"selectedBlock?.block?.title || ''\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <!-- Block Majhi Display - Always Readonly -->\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"selectedBlock\">\n                <ion-icon slot=\"start\" name=\"checkmark-circle\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Block Majhi</ion-label>\n                <ion-input [value]=\"selectedBlock?.majhi_title || ''\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <!-- Sub-Block Selection - Only for Add Mode -->\n              <ion-item class=\"form-item\" *ngIf=\"!isEditMode && availableSubBlocks.length > 0\" [class.ion-invalid]=\"isFieldInvalid('sub_block_id')\">\n                <ion-icon slot=\"start\" name=\"grid-outline\" [color]=\"isFieldInvalid('sub_block_id') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Sub-Block *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"sub_block_id\" (ionChange)=\"onSubBlockSelected()\" placeholder=\"Choose sub-block\">\n                  <ion-select-option *ngFor=\"let subBlock of availableSubBlocks\" [value]=\"subBlock.id\">{{subBlock.sub_block_title}}</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('sub_block_id')\">\n                  {{getFieldErrorMessage('sub_block_id')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- Sub-Block Display - Readonly for Edit Mode -->\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"isEditMode && selectedSubBlockMajhi\">\n                <ion-icon slot=\"start\" name=\"grid-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Sub-Block</ion-label>\n                <ion-input [value]=\"selectedSubBlockMajhi?.sub_block_title || ''\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <!-- Sub Block Majhi Display - Always Readonly -->\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"selectedSubBlockMajhi\">\n                <ion-icon slot=\"start\" name=\"checkmark-circle\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Sub Block Majhi</ion-label>\n                <ion-input [value]=\"selectedSubBlockMajhi?.sub_block_majhi || ''\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('hh_no')\" [class.auto-filled-item]=\"isEditMode\">\n                <ion-icon slot=\"start\" name=\"home-outline\" [color]=\"isEditMode ? 'success' : (isFieldInvalid('hh_no') ? 'danger' : 'primary')\"></ion-icon>\n                <ion-label position=\"stacked\">House Hold Number</ion-label>\n                <ion-input formControlName=\"hh_no\" placeholder=\"Enter house number (optional)\" [readonly]=\"isEditMode\" [class.auto-filled-input]=\"isEditMode\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('hh_no') && !isEditMode\">\n                  {{getFieldErrorMessage('hh_no')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- Location Update Button for Edit Mode -->\n              <div class=\"location-update-section\" *ngIf=\"isEditMode\">\n                <ion-button fill=\"outline\" color=\"primary\" routerDirection=\"root\" [routerLink]=\"'/location-update-woman/' + plwId\" class=\"location-update-btn\">\n                  <ion-icon name=\"location-outline\" slot=\"start\"></ion-icon>\n                  Update Location\n                </ion-button>\n              </div>\n            </div>\n\n            <!-- Personal Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                Personal Information\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('name')\">\n                <ion-icon slot=\"start\" name=\"person\" [color]=\"isFieldInvalid('name') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Name *</ion-label>\n                <ion-input formControlName=\"name\" placeholder=\"Enter full name\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('name')\">\n                  {{getFieldErrorMessage('name')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('progress_id')\">\n                <ion-icon slot=\"start\" name=\"id-card-outline\" [color]=\"isFieldInvalid('progress_id') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Progress ID *</ion-label>\n                <ion-input formControlName=\"progress_id\" placeholder=\"Enter Progress ID\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('progress_id')\">\n                  {{getFieldErrorMessage('progress_id')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('fcn')\">\n                <ion-icon slot=\"start\" name=\"document-text-outline\" [color]=\"isFieldInvalid('fcn') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Family Count Number (FCN) *</ion-label>\n                <ion-input formControlName=\"fcn\" placeholder=\"Enter FCN number\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('fcn')\">\n                  {{getFieldErrorMessage('fcn')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('case_id')\">\n                <ion-icon slot=\"start\" name=\"pricetag-outline\" [color]=\"isFieldInvalid('case_id') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Case ID</ion-label>\n                <ion-input formControlName=\"case_id\" placeholder=\"Enter Case ID (optional)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('case_id')\">\n                  {{getFieldErrorMessage('case_id')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('scope_no')\">\n                <ion-icon slot=\"start\" name=\"document-outline\" [color]=\"isFieldInvalid('scope_no') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Scope ID</ion-label>\n                <ion-input formControlName=\"scope_no\" placeholder=\"Enter Scope ID (optional)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('scope_no')\">\n                  {{getFieldErrorMessage('scope_no')}}\n                </ion-note>\n              </ion-item>\n            </div>\n\n            <!-- Family Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"people-outline\" color=\"primary\"></ion-icon>\n                Family Information\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('husband')\">\n                <ion-icon slot=\"start\" name=\"heart-outline\" [color]=\"isFieldInvalid('husband') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Husband's Name *</ion-label>\n                <ion-input formControlName=\"husband\" placeholder=\"Enter husband's name\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('husband')\">\n                  {{getFieldErrorMessage('husband')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('father')\">\n                <ion-icon slot=\"start\" name=\"person-outline\" [color]=\"isFieldInvalid('father') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Father's Name</ion-label>\n                <ion-input formControlName=\"father\" placeholder=\"Enter father's name\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('father')\">\n                  {{getFieldErrorMessage('father')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- Mother Care Capability Question -->\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('mother_support_status')\">\n                <ion-icon slot=\"start\" name=\"help-circle-outline\" [color]=\"isFieldInvalid('mother_support_status') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Is the mother capable of taking care of her child? *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"mother_support_status\" (ionChange)=\"onMotherSupportStatusChange()\" placeholder=\"Select capability status\">\n                  <ion-select-option value=\"yes\">Yes</ion-select-option>\n                  <ion-select-option value=\"no\">No</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('mother_support_status')\">\n                  {{getFieldErrorMessage('mother_support_status')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- Caregiver Section - Only show if mother can't take care -->\n              <div *ngIf=\"shouldShowCaregiverSection()\">\n                <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('caregiver_id')\">\n                  <ion-icon slot=\"start\" name=\"people-circle-outline\" [color]=\"isFieldInvalid('caregiver_id') ? 'danger' : 'primary'\"></ion-icon>\n                  <ion-label position=\"stacked\">Caregiver Type *</ion-label>\n                  <ion-select interface=\"action-sheet\" formControlName=\"caregiver_id\" placeholder=\"Select caregiver type\">\n                    <ion-select-option *ngFor=\"let caregiver of caregivers\" [value]=\"caregiver.id\">{{caregiver.title}}</ion-select-option>\n                  </ion-select>\n                  <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('caregiver_id')\">\n                    {{getFieldErrorMessage('caregiver_id')}}\n                  </ion-note>\n                </ion-item>\n\n                <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('caregiver_name')\">\n                  <ion-icon slot=\"start\" name=\"person-circle-outline\" [color]=\"isFieldInvalid('caregiver_name') ? 'danger' : 'primary'\"></ion-icon>\n                  <ion-label position=\"stacked\">Caregiver Name *</ion-label>\n                  <ion-input formControlName=\"caregiver_name\" placeholder=\"Enter caregiver's name\"></ion-input>\n                  <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('caregiver_name')\">\n                    {{getFieldErrorMessage('caregiver_name')}}\n                  </ion-note>\n                </ion-item>\n              </div>\n            </div>\n\n            <!-- Age & Contact Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                Age & Contact Information\n              </h3>\n\n              <!-- Info tip for age calculation\n              <div class=\"info-tip\">\n                <ion-icon name=\"information-circle\" color=\"primary\"></ion-icon>\n                <span>Age will be calculated automatically from date of birth</span>\n              </div> -->\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('date_of_birth')\">\n                <ion-icon slot=\"start\" name=\"calendar\" [color]=\"isFieldInvalid('date_of_birth') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Date of Birth *</ion-label>\n                <ion-input formControlName=\"date_of_birth\" type=\"date\" [max]=\"maxDate\" placeholder=\"Select date\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\">Enter date of birth to calculate age automatically</ion-note>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('date_of_birth')\">\n                  {{getFieldErrorMessage('date_of_birth')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"getFormFieldValue('age')\">\n                <ion-icon slot=\"start\" name=\"time-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Calculated Age</ion-label>\n                <ion-input [value]=\"getFormFieldValue('age')\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('phone')\">\n                <ion-icon slot=\"start\" name=\"call-outline\" [color]=\"isFieldInvalid('phone') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Phone Number </ion-label>\n                <ion-input formControlName=\"phone\" type=\"tel\" placeholder=\"Enter phone number\" maxlength=\"11\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('phone')\">\n                  {{getFieldErrorMessage('phone')}}\n                </ion-note>\n              </ion-item>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\">\n                <ion-icon name=\"{{isEditMode ? 'save-outline' : 'save-outline'}}\" slot=\"start\"></ion-icon>\n                {{isEditMode ? 'Update Mother Information' : 'Save Mother Information'}}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"plw-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading Mother form data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_woman-add-edit_add-plw_module_ts.js.map