(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_supply-out_supply-out_module_ts"],{

/***/ 18981:
/*!***************************************************************!*\
  !*** ./src/app/pages/supply-out/supply-out-routing.module.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyOutPageRoutingModule: () => (/* binding */ SupplyOutPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _supply_out_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-out.page */ 167);




const routes = [{
  path: '',
  component: _supply_out_page__WEBPACK_IMPORTED_MODULE_0__.SupplyOutPage
}];
let SupplyOutPageRoutingModule = class SupplyOutPageRoutingModule {};
SupplyOutPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SupplyOutPageRoutingModule);


/***/ }),

/***/ 38476:
/*!*******************************************************!*\
  !*** ./src/app/pages/supply-out/supply-out.module.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyOutPageModule: () => (/* binding */ SupplyOutPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _supply_out_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-out-routing.module */ 18981);
/* harmony import */ var _supply_out_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-out.page */ 167);








let SupplyOutPageModule = class SupplyOutPageModule {};
SupplyOutPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _supply_out_routing_module__WEBPACK_IMPORTED_MODULE_1__.SupplyOutPageRoutingModule],
  declarations: [_supply_out_page__WEBPACK_IMPORTED_MODULE_2__.SupplyOutPage]
})], SupplyOutPageModule);


/***/ }),

/***/ 167:
/*!*****************************************************!*\
  !*** ./src/app/pages/supply-out/supply-out.page.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyOutPage: () => (/* binding */ SupplyOutPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _supply_out_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-out.page.html?ngResource */ 68105);
/* harmony import */ var _supply_out_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-out.page.scss?ngResource */ 65093);
/* harmony import */ var _supply_out_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_supply_out_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/supply_api.service */ 78982);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);

var _SupplyOutPage;




/* eslint-disable @typescript-eslint/member-ordering */
/* eslint-disable @typescript-eslint/naming-convention */







let SupplyOutPage = (_SupplyOutPage = class SupplyOutPage {
  constructor(route, router, fb, b, change, zone, api, popoverController) {
    this.route = route;
    this.router = router;
    this.fb = fb;
    this.b = b;
    this.change = change;
    this.zone = zone;
    this.api = api;
    this.popoverController = popoverController;
    this.isEditMode = false;
    this.isRequisitionMode = false;
    this.transactionDefTypes = ['inf_to_wh', 'inf_to_inf'];
    this.lotLists = {};
    this.lotAllocations = {};
    this.itemsWithAvailableLots = new Set(); // Track which supply items have available lots
    // Provider search properties
    this.filteredProviders = [];
    this.providerSearchTerm = '';
    this.showFilteredOptions = false;
  }
  ngOnInit() {
    this.id = this.route.snapshot.paramMap.get('id');
    this.isEditMode = !!this.id;
    // Check if requisition mode from query params
    this.route.queryParams.subscribe(params => {
      this.isRequisitionMode = params['mode'] === 'requisition';
    });
    this.title = this.isRequisitionMode ? 'Create Requisition' : this.isEditMode ? 'Edit Supply Out' : 'Supply Out';
    this.setupForm();
    this.load();
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this.isEditMode) {
          _this.supplyEditPreqData = (yield _this.api.getSupplyItemEditPreq(+_this.id)).data;
          _this.patchForm();
        } else {
          var _yield$_this$api$crea;
          _this.supplyRequestPreq = (_yield$_this$api$crea = yield _this.api.createPreq()) === null || _yield$_this$api$crea === void 0 ? void 0 : _yield$_this$api$crea.data;
          // Pre-load lot lists for all supply items to check availability
          yield _this.preloadLotLists();
          // Add first supply item by default for new entries
          _this.addNewSupply();
        }
        // Initialize provider search after data is loaded
        setTimeout(() => {
          _this.initializeProviderSearch();
        }, 100);
        _this.change.markForCheck();
      } catch (error) {
        _this.b.errorToast('Error loading supply data');
      }
    })();
  }
  preloadLotLists() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _this2$supplyRequestP;
      const supplyList = (_this2$supplyRequestP = _this2.supplyRequestPreq) === null || _this2$supplyRequestP === void 0 ? void 0 : _this2$supplyRequestP.supply_list;
      if (!supplyList) return;
      // Load lot lists for all supply items
      const lotLoadPromises = supplyList.map(/*#__PURE__*/function () {
        var _ref = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (item) {
          try {
            const lotResponse = yield _this2.api.getLotList(item.id);
            const lots = lotResponse.data || [];
            // Check if this item has any lots with available quantity
            const hasAvailableLots = lots.some(lot => _this2.getAvailableQuantity(lot) > 0);
            if (hasAvailableLots) {
              _this2.itemsWithAvailableLots.add(item.id);
            }
          } catch (error) {
            console.error(`Error loading lot list for item ${item.id}:`, error);
          }
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      yield Promise.all(lotLoadPromises);
    })();
  }
  setupForm() {
    // For requisition mode, set transaction_def to inf_to_dp by default
    const defaultTransactionDef = this.isRequisitionMode ? 'inf_to_dp' : 'inf_to_dp';
    this.supplyRequestForm = this.fb.group({
      transaction_date: [new Date().toISOString().split('T')[0], [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, this.futureDateValidator()]],
      supply_items: this.fb.array([], [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]),
      transaction_type: ['Out'],
      transaction_def: [defaultTransactionDef, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      provider: [''],
      waybill: [''],
      notes: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]],
      inf: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]]
    });
  }
  get supplyItems() {
    return this.supplyRequestForm.get('supply_items');
  }
  addSupplyItem(supply_item_id, total_quantity, available, lot_no, expire_date, batch_no) {
    available = available !== null && available !== void 0 ? available : 0;
    const isFifoMode = this.isFifoMode();
    const group = this.fb.group({
      supply_item_id: [supply_item_id, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      total_quantity: [{
        value: total_quantity || '',
        disabled: !supply_item_id && !this.isEditMode || !lot_no && !isFifoMode && !this.isEditMode
      }, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberPattern), _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.min(1), this.quantityValidator()]],
      lot_no: [lot_no || '', isFifoMode ? [] : [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, this.duplicateLotValidator.bind(this)]],
      batch_no: [{
        value: batch_no || lot_no || '',
        disabled: true
      }, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]],
      expire_date: [{
        value: expire_date || '',
        disabled: true
      }, isFifoMode ? [] : [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      available: [available]
    });
    return group;
  }
  isFifoMode() {
    var _this$supplyRequestFo;
    return ((_this$supplyRequestFo = this.supplyRequestForm) === null || _this$supplyRequestFo === void 0 || (_this$supplyRequestFo = _this$supplyRequestFo.get('transaction_def')) === null || _this$supplyRequestFo === void 0 ? void 0 : _this$supplyRequestFo.value) === 'inf_to_dp';
  }
  getUserType() {
    return localStorage.getItem('user_type') || '';
  }
  getSubmitStatus() {
    // For requisition mode:
    // - Store Keeper submits as 'draft'
    // - Facility Supervisor submits as 'pending'
    if (this.isRequisitionMode) {
      return this.getUserType() === 'Store Keeper' ? 'draft' : 'pending';
    }
    // For normal supply out, always save as draft
    return 'draft';
  }
  getTotal(i) {
    const total = +this.supplyItems.at(i).get('total_quantity').value || 0;
    return isNaN(total) ? 0 : total;
  }
  addNewSupply(supply_item_id, total_quantity, available, lot_no, expire_date, batch_no) {
    const formGroup = this.addSupplyItem(supply_item_id, total_quantity, available, lot_no, expire_date, batch_no);
    this.supplyItems.push(formGroup);
  }
  submitForm(supplyRequestForm) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Mark all fields as touched to show validation errors
      _this3.markFormGroupTouched(supplyRequestForm);
      // Check for duplicate lot numbers before submission (only for non-FIFO mode)
      if (!_this3.isFifoMode()) {
        const hasDuplicates = _this3.supplyItems.controls.some((_, index) => _this3.isDuplicateLotNumber(index));
        if (hasDuplicates) {
          _this3.b.errorToast('Cannot submit: Duplicate lot numbers found for the same supply item');
          return;
        }
      }
      // Comprehensive validation with detailed error messages
      const validationErrors = _this3.validateFormFields(supplyRequestForm);
      if (validationErrors.length > 0) {
        // Show the first validation error
        _this3.b.errorToast(validationErrors[0]);
        return;
      }
      if (supplyRequestForm.valid) {
        const formObj = supplyRequestForm.getRawValue();
        let processedItems = [];
        if (_this3.isFifoMode()) {
          // Apply FIFO lot selection logic for inf_to_dp
          for (const item of formObj.supply_items) {
            const itemLots = _this3.lotLists[formObj.supply_items.indexOf(item)] || [];
            const allocatedLots = _this3.allocateQuantityToLots(item.total_quantity, itemLots);
            // Create separate entries for each lot allocation
            for (const allocation of allocatedLots) {
              processedItems.push({
                supply_item_id: item.supply_item_id,
                total_quantity: allocation.quantity,
                expire_date: allocation.expire_date,
                lot_no: allocation.lot_no
              });
            }
          }
        } else {
          // Use manual lot selection for other transaction types
          processedItems = formObj.supply_items.map(item => ({
            supply_item_id: item.supply_item_id,
            total_quantity: item.total_quantity,
            expire_date: item.expire_date,
            lot_no: item.lot_no
          }));
        }
        // Transform form data to match PHP controller expectations
        const submitData = {
          transaction_date: formObj.transaction_date,
          transaction_type: formObj.transaction_type,
          transaction_def: formObj.transaction_def,
          provider: formObj.provider,
          waybill: formObj.waybill,
          notes: formObj.notes || '',
          inf: formObj.inf || '',
          status: _this3.getSubmitStatus(),
          // Send status based on user type
          supply_item_id: processedItems.map(item => item.supply_item_id),
          total_quantity: processedItems.map(item => item.total_quantity),
          expire_date: processedItems.map(item => item.expire_date),
          lot_no: processedItems.map(item => item.lot_no)
        };
        try {
          let response;
          let successMessage;
          if (_this3.isEditMode) {
            response = yield _this3.api.editSupply(submitData, _this3.id);
            successMessage = response.message || 'Supply transaction updated successfully';
          } else {
            response = yield _this3.api.storeSupply(submitData);
            if (_this3.isRequisitionMode) {
              const userType = _this3.getUserType();
              if (userType === 'Store Keeper') {
                successMessage = 'Requisition saved as draft successfully';
              } else {
                successMessage = 'Requisition submitted for approval successfully';
              }
            } else {
              successMessage = response.message || 'Supply transaction created successfully';
            }
          }
          _this3.b.toast(successMessage);
          // Navigate back to appropriate page
          if (_this3.isRequisitionMode) {
            _this3.router.navigate(['/manage-supplylist', 'out'], {
              queryParams: {
                mode: 'requisition'
              }
            });
          } else {
            _this3.router.navigate(['/manage-supplylist', 'out']);
          }
        } catch (error) {
          const action = _this3.isEditMode ? 'updating' : _this3.isRequisitionMode ? 'submitting requisition' : 'creating';
          _this3.b.errorToast(`Error ${action} supply transaction`);
        }
      } else {
        // If form is invalid but no custom validation errors were caught
        const formErrors = _this3.getDetailedFormErrors();
        _this3.b.errorToast(formErrors || 'Please fill out all required fields correctly');
      }
    })();
  }
  validateFormFields(formGroup) {
    var _formGroup$get, _formGroup$get2;
    const errors = [];
    // Transaction date validation
    const dateValue = (_formGroup$get = formGroup.get('transaction_date')) === null || _formGroup$get === void 0 ? void 0 : _formGroup$get.value;
    if (!dateValue || dateValue.toString().trim() === '') {
      errors.push('Transaction date is required');
    } else {
      // Check for future date
      const selectedDate = new Date(dateValue);
      const today = new Date();
      selectedDate.setHours(0, 0, 0, 0);
      today.setHours(0, 0, 0, 0);
      if (selectedDate > today) {
        errors.push('Transaction date cannot be in the future');
      }
    }
    // Transaction definition validation
    const transactionDef = (_formGroup$get2 = formGroup.get('transaction_def')) === null || _formGroup$get2 === void 0 ? void 0 : _formGroup$get2.value;
    if (!transactionDef || transactionDef.toString().trim() === '') {
      errors.push('Transaction type is required');
    }
    // Provider validation (required for non-inf_to_dp)
    if (transactionDef && transactionDef !== 'inf_to_dp') {
      var _formGroup$get3;
      const providerValue = (_formGroup$get3 = formGroup.get('provider')) === null || _formGroup$get3 === void 0 ? void 0 : _formGroup$get3.value;
      if (!providerValue || providerValue.toString().trim() === '') {
        errors.push('Provider/Destination is required for this transaction type');
      }
    }
    // Supply items validation
    const supplyItems = formGroup.get('supply_items');
    if (!supplyItems || supplyItems.length === 0) {
      errors.push('At least one supply item is required');
    } else {
      // Check each supply item
      for (let i = 0; i < supplyItems.length; i++) {
        var _item$get, _item$get2, _item$get3;
        const item = supplyItems.at(i);
        // Supply item selection
        const supplyItemId = (_item$get = item.get('supply_item_id')) === null || _item$get === void 0 ? void 0 : _item$get.value;
        if (!supplyItemId) {
          errors.push(`Supply item ${i + 1}: Please select a supply item`);
          break;
        }
        // Quantity validation
        const quantity = (_item$get2 = item.get('total_quantity')) === null || _item$get2 === void 0 ? void 0 : _item$get2.value;
        if (!quantity || quantity === '' || quantity === 0) {
          errors.push(`Supply item ${i + 1}: Quantity is required`);
          break;
        }
        const available = ((_item$get3 = item.get('available')) === null || _item$get3 === void 0 ? void 0 : _item$get3.value) || 0;
        if (parseFloat(quantity) > available) {
          errors.push(`Supply item ${i + 1}: Quantity (${quantity}) exceeds available stock (${available})`);
          break;
        }
        // Lot number validation (for non-FIFO mode)
        if (!this.isFifoMode()) {
          var _item$get4, _item$get5;
          const lotNo = (_item$get4 = item.get('lot_no')) === null || _item$get4 === void 0 ? void 0 : _item$get4.value;
          if (!lotNo || lotNo.trim() === '') {
            errors.push(`Supply item ${i + 1}: Lot number is required`);
            break;
          }
          const expireDate = (_item$get5 = item.get('expire_date')) === null || _item$get5 === void 0 ? void 0 : _item$get5.value;
          if (!expireDate || expireDate.trim() === '') {
            errors.push(`Supply item ${i + 1}: Expiry date is required`);
            break;
          }
        }
      }
    }
    return errors;
  }
  getDetailedFormErrors() {
    const errors = [];
    // Check main form fields
    Object.keys(this.supplyRequestForm.controls).forEach(key => {
      const control = this.supplyRequestForm.get(key);
      if (control && control.invalid && control.errors && key !== 'supply_items') {
        const fieldName = this.getFieldDisplayName(key);
        if (control.errors['required']) {
          errors.push(`${fieldName} is required`);
        }
        if (control.errors['futureDate']) {
          errors.push(`${fieldName} cannot be in the future`);
        }
      }
    });
    // Check supply items array
    const supplyItems = this.supplyRequestForm.get('supply_items');
    if (supplyItems && supplyItems.length === 0) {
      errors.push('At least one supply item is required');
    }
    return errors.length > 0 ? errors[0] : 'Please check all fields and try again';
  }
  getFieldDisplayName(fieldName) {
    const displayNames = {
      'transaction_date': 'Transaction Date',
      'transaction_def': 'Transaction Type',
      'provider': 'Provider/Destination',
      'waybill': 'Waybill/Reference',
      'notes': 'Notes',
      'supply_item_id': 'Supply Item',
      'total_quantity': 'Quantity',
      'lot_no': 'Lot Number',
      'expire_date': 'Expiry Date'
    };
    return displayNames[fieldName] || fieldName;
  }
  onSelectSupplyItem(event, index) {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const supplyItemId = event.detail.value;
      const available = _this4.getQuantityInStoreOfProgram(supplyItemId);
      _this4.supplyItems.at(index).get('available').setValue(available !== null && available !== void 0 ? available : 0);
      // Reset lot-related fields when supply item changes
      _this4.supplyItems.at(index).get('lot_no').setValue('');
      _this4.supplyItems.at(index).get('expire_date').setValue('');
      _this4.supplyItems.at(index).get('total_quantity').setValue('');
      // Load lot list for this supply item
      if (supplyItemId) {
        try {
          const lotResponse = yield _this4.api.getLotList(supplyItemId);
          _this4.lotLists[index] = lotResponse.data || [];
          if (_this4.isFifoMode()) {
            // FIFO mode: Calculate total available and enable quantity immediately
            const totalAvailable = _this4.lotLists[index].reduce((sum, lot) => sum + _this4.getAvailableQuantity(lot), 0);
            _this4.supplyItems.at(index).get('available').setValue(totalAvailable);
            _this4.supplyItems.at(index).get('total_quantity').enable();
          } else {
            // Manual mode: Disable quantity until lot is selected
            _this4.supplyItems.at(index).get('total_quantity').disable();
          }
        } catch (error) {
          _this4.lotLists[index] = [];
          _this4.b.errorToast('Error loading lot numbers');
        }
      } else {
        _this4.lotLists[index] = [];
        _this4.supplyItems.at(index).get('total_quantity').disable();
      }
      // Trigger validation for all lot_no fields to check for duplicates (manual mode only)
      if (!_this4.isFifoMode()) {
        _this4.supplyItems.controls.forEach((control, i) => {
          var _control$get;
          (_control$get = control.get('lot_no')) === null || _control$get === void 0 || _control$get.updateValueAndValidity();
        });
      }
      _this4.change.markForCheck();
    })();
  }
  removeSupply(index) {
    if (this.supplyItems.length > 1) {
      this.supplyItems.removeAt(index);
      this.change.markForCheck();
    } else {
      this.b.toast('At least one supply item is required');
    }
  }
  getQuantityInStoreOfProgram(supplyItemId) {
    var _this$supplyEditPreqD, _this$supplyRequestPr, _inStore$find;
    const inStore = this.isEditMode ? (_this$supplyEditPreqD = this.supplyEditPreqData) === null || _this$supplyEditPreqD === void 0 ? void 0 : _this$supplyEditPreqD.in_store : (_this$supplyRequestPr = this.supplyRequestPreq) === null || _this$supplyRequestPr === void 0 ? void 0 : _this$supplyRequestPr.in_store;
    return inStore === null || inStore === void 0 || (_inStore$find = inStore.find(p => p.id === supplyItemId)) === null || _inStore$find === void 0 ? void 0 : _inStore$find.qty_in_store;
  }
  getAvailableSupplyItems(currentIndex) {
    var _this$supplyEditPreqD2, _this$supplyRequestPr2;
    const supplyList = this.isEditMode ? (_this$supplyEditPreqD2 = this.supplyEditPreqData) === null || _this$supplyEditPreqD2 === void 0 ? void 0 : _this$supplyEditPreqD2.supply_list : (_this$supplyRequestPr2 = this.supplyRequestPreq) === null || _this$supplyRequestPr2 === void 0 ? void 0 : _this$supplyRequestPr2.supply_list;
    if (!supplyList) return [];
    // Filter out items that have no available lots (only for non-edit mode)
    let filteredList = supplyList;
    if (!this.isEditMode) {
      filteredList = supplyList.filter(item => this.itemsWithAvailableLots.has(item.id));
    }
    // For FIFO mode (inf_to_dp), exclude already selected items (except current item)
    if (this.isFifoMode()) {
      const selectedItemIds = this.supplyItems.controls.map((control, index) => {
        var _control$get2;
        // Don't exclude the current item's selection
        if (index === currentIndex) return null;
        return (_control$get2 = control.get('supply_item_id')) === null || _control$get2 === void 0 ? void 0 : _control$get2.value;
      }).filter(id => id != null);
      return filteredList.filter(item => !selectedItemIds.includes(item.id));
    }
    // For manual mode, allow same item multiple times with different lots
    return filteredList;
  }
  patchForm() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _this5$supplyEditPreq;
      if ((_this5$supplyEditPreq = _this5.supplyEditPreqData) !== null && _this5$supplyEditPreq !== void 0 && _this5$supplyEditPreq.supply_prev) {
        var _this5$supplyEditPreq3;
        // Clear existing supply items first
        while (_this5.supplyItems.length > 0) {
          _this5.supplyItems.removeAt(0);
        }
        // Format date properly for date input
        const formattedDate = _this5.supplyEditPreqData.supply_prev.transaction_date ? new Date(_this5.supplyEditPreqData.supply_prev.transaction_date).toISOString().split('T')[0] : '';
        const waybill = _this5.supplyEditPreqData.supply_prev.waybill || _this5.supplyEditPreqData.supply_prev.ref || '';
        // Determine transaction_def and provider based on edit data
        let transactionDef = _this5.supplyEditPreqData.supply_prev.transaction_def || 'inf_to_dp';
        let providerId = _this5.supplyEditPreqData.supply_prev.provider;
        // If transaction_def is not set in the data, try to infer it
        if (!_this5.supplyEditPreqData.supply_prev.transaction_def) {
          var _this5$supplyEditPreq2;
          // Check if provider ID exists in INFs list - if so, it's inf_to_inf
          const infExists = (_this5$supplyEditPreq2 = _this5.supplyEditPreqData.infs) === null || _this5$supplyEditPreq2 === void 0 ? void 0 : _this5$supplyEditPreq2.some(inf => inf.id === providerId);
          if (infExists) {
            transactionDef = 'inf_to_inf';
          }
        }
        _this5.supplyRequestForm.patchValue({
          transaction_date: formattedDate,
          transaction_type: 'Out',
          transaction_def: transactionDef,
          provider: providerId,
          waybill: waybill,
          notes: ((_this5$supplyEditPreq3 = _this5.supplyEditPreqData.supply_prev) === null || _this5$supplyEditPreq3 === void 0 ? void 0 : _this5$supplyEditPreq3.notes) || ''
        });
        // Initialize provider search for edit mode
        setTimeout(() => {
          var _this5$supplyRequestF;
          const transactionDef = (_this5$supplyRequestF = _this5.supplyRequestForm.get('transaction_def')) === null || _this5$supplyRequestF === void 0 ? void 0 : _this5$supplyRequestF.value;
          if (transactionDef === 'inf_to_inf') {
            _this5.initializeProviderSearch();
          }
        }, 200);
        // Add supply items from edit data - aggregate by supply_item_id
        if (_this5.supplyEditPreqData.supply_prev.supply_item && _this5.supplyEditPreqData.supply_prev.supply_item.length > 0) {
          // Group items by supply_item_id and sum quantities
          const itemsMap = new Map();
          for (const item of _this5.supplyEditPreqData.supply_prev.supply_item) {
            const supplyItemId = item.supply_item_id;
            const qty = parseFloat(item.total_quantity) || 0;
            if (itemsMap.has(supplyItemId)) {
              const existing = itemsMap.get(supplyItemId);
              existing.total_quantity += qty;
            } else {
              itemsMap.set(supplyItemId, {
                supply_item_id: supplyItemId,
                total_quantity: qty
              });
            }
          }
          // Add aggregated items to form
          const aggregatedArray = Array.from(itemsMap.values());
          for (let itemIndex = 0; itemIndex < aggregatedArray.length; itemIndex++) {
            const aggregatedItem = aggregatedArray[itemIndex];
            _this5.addNewSupply(aggregatedItem.supply_item_id, aggregatedItem.total_quantity, 0,
            // Will be updated when lots are loaded
            '', '', '');
            // Load lot list for this supply item
            if (aggregatedItem.supply_item_id) {
              try {
                const lotResponse = yield _this5.api.getLotList(aggregatedItem.supply_item_id);
                _this5.lotLists[itemIndex] = lotResponse.data || [];
                // Calculate total available across all lots
                const totalAvailable = _this5.lotLists[itemIndex].reduce((sum, lot) => sum + _this5.getAvailableQuantity(lot), 0);
                _this5.supplyItems.at(itemIndex).get('available').setValue(totalAvailable);
                // Enable quantity field
                const quantityControl = _this5.supplyItems.at(itemIndex).get('total_quantity');
                quantityControl === null || quantityControl === void 0 || quantityControl.enable();
                quantityControl === null || quantityControl === void 0 || quantityControl.setValue(aggregatedItem.total_quantity);
                quantityControl === null || quantityControl === void 0 || quantityControl.updateValueAndValidity();
              } catch (error) {
                _this5.lotLists[itemIndex] = [];
                _this5.supplyItems.at(itemIndex).get('available').setValue(0);
              }
            }
          }
        } else {
          // Add at least one empty supply item if none exist
          _this5.addNewSupply();
        }
        // Update form validation after patching
        _this5.supplyRequestForm.updateValueAndValidity();
        _this5.supplyItems.controls.forEach(control => {
          if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
            control.updateValueAndValidity();
            Object.keys(control.controls).forEach(key => {
              var _control$get3;
              (_control$get3 = control.get(key)) === null || _control$get3 === void 0 || _control$get3.updateValueAndValidity();
            });
          }
        });
        // Force change detection
        _this5.change.markForCheck();
        // Re-validate form after a brief delay to ensure all async operations complete
        setTimeout(() => {
          _this5.supplyRequestForm.updateValueAndValidity();
          _this5.supplyItems.controls.forEach(control => {
            if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
              control.updateValueAndValidity();
              Object.keys(control.controls).forEach(key => {
                var _control$get4;
                (_control$get4 = control.get(key)) === null || _control$get4 === void 0 || _control$get4.updateValueAndValidity();
              });
            }
          });
          _this5.change.markForCheck();
        }, 100);
        // Debug form validation state
        _this5.supplyItems.controls.forEach((control, index) => {
          if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup && control.invalid) {
            Object.keys(control.controls).forEach(key => {
              const fieldControl = control.get(key);
              if (fieldControl !== null && fieldControl !== void 0 && fieldControl.invalid) {}
            });
          }
        });
      } else {}
    })();
  }
  onTransactionDefChange(event) {
    const transactionDef = event.detail.value;
    const providerControl = this.supplyRequestForm.get('provider');
    const waybillControl = this.supplyRequestForm.get('waybill');
    // Reset provider and waybill when transaction_def changes
    providerControl === null || providerControl === void 0 || providerControl.setValue('');
    waybillControl === null || waybillControl === void 0 || waybillControl.setValue('');
    // Reset provider search
    this.resetProviderSearch();
    // Initialize provider search for inf_to_inf
    if (transactionDef === 'inf_to_inf') {
      setTimeout(() => {
        this.initializeProviderSearch();
      }, 100);
    }
    // Update validation based on transaction_def
    if (transactionDef === 'inf_to_dp') {
      providerControl === null || providerControl === void 0 || providerControl.clearValidators();
      waybillControl === null || waybillControl === void 0 || waybillControl.clearValidators();
    } else {
      providerControl === null || providerControl === void 0 || providerControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]);
      waybillControl === null || waybillControl === void 0 || waybillControl.clearValidators(); // waybill is optional for other types
    }
    providerControl === null || providerControl === void 0 || providerControl.updateValueAndValidity();
    waybillControl === null || waybillControl === void 0 || waybillControl.updateValueAndValidity();
    // Update supply items validation based on FIFO mode
    this.updateSupplyItemsValidation();
    this.change.markForCheck();
  }
  updateSupplyItemsValidation() {
    const isFifo = this.isFifoMode();
    this.supplyItems.controls.forEach((control, index) => {
      const lotNoControl = control.get('lot_no');
      const expireDateControl = control.get('expire_date');
      const quantityControl = control.get('total_quantity');
      if (isFifo) {
        var _control$get5;
        // FIFO mode: Remove lot validators, enable quantity if supply item selected
        lotNoControl === null || lotNoControl === void 0 || lotNoControl.clearValidators();
        expireDateControl === null || expireDateControl === void 0 || expireDateControl.clearValidators();
        const supplyItemId = (_control$get5 = control.get('supply_item_id')) === null || _control$get5 === void 0 ? void 0 : _control$get5.value;
        if (supplyItemId) {
          quantityControl === null || quantityControl === void 0 || quantityControl.enable();
        }
      } else {
        var _control$get6;
        // Manual mode: Add lot validators, disable quantity until lot selected
        lotNoControl === null || lotNoControl === void 0 || lotNoControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, this.duplicateLotValidator.bind(this)]);
        expireDateControl === null || expireDateControl === void 0 || expireDateControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]);
        const lotNo = (_control$get6 = control.get('lot_no')) === null || _control$get6 === void 0 ? void 0 : _control$get6.value;
        if (!lotNo) {
          quantityControl === null || quantityControl === void 0 || quantityControl.disable();
        }
      }
      lotNoControl === null || lotNoControl === void 0 || lotNoControl.updateValueAndValidity();
      expireDateControl === null || expireDateControl === void 0 || expireDateControl.updateValueAndValidity();
      quantityControl === null || quantityControl === void 0 || quantityControl.updateValueAndValidity();
    });
  }
  getProviderList() {
    var _this$supplyRequestFo2;
    const transactionDef = (_this$supplyRequestFo2 = this.supplyRequestForm.get('transaction_def')) === null || _this$supplyRequestFo2 === void 0 ? void 0 : _this$supplyRequestFo2.value;
    const data = this.isEditMode ? this.supplyEditPreqData : this.supplyRequestPreq;
    if (transactionDef === 'inf_to_inf') {
      return (data === null || data === void 0 ? void 0 : data.infs) || [];
    } else {
      return (data === null || data === void 0 ? void 0 : data.pps) || [];
    }
  }
  getSupplyItemUnit(supplyItemId) {
    var _this$supplyEditPreqD3, _this$supplyRequestPr3, _supplyItem$unit;
    if (!supplyItemId) return '';
    const supplyList = this.isEditMode ? (_this$supplyEditPreqD3 = this.supplyEditPreqData) === null || _this$supplyEditPreqD3 === void 0 ? void 0 : _this$supplyEditPreqD3.supply_list : (_this$supplyRequestPr3 = this.supplyRequestPreq) === null || _this$supplyRequestPr3 === void 0 ? void 0 : _this$supplyRequestPr3.supply_list;
    const supplyItem = supplyList === null || supplyList === void 0 ? void 0 : supplyList.find(item => item.id === supplyItemId);
    return (supplyItem === null || supplyItem === void 0 || (_supplyItem$unit = supplyItem.unit) === null || _supplyItem$unit === void 0 ? void 0 : _supplyItem$unit.title) || '';
  }
  onSelectLot(event, index) {
    const selectedLotNo = event.detail.value;
    const lotList = this.lotLists[index] || [];
    const selectedLot = lotList.find(lot => lot.lot_no === selectedLotNo);
    if (selectedLot) {
      // Auto-populate expire_date from selected lot
      this.supplyItems.at(index).get('expire_date').setValue(selectedLot.expire_date || '');
      // Calculate and set available quantity
      const availableQty = this.getAvailableQuantity(selectedLot);
      this.supplyItems.at(index).get('available').setValue(availableQty);
      // Enable quantity input now that lot is selected
      this.supplyItems.at(index).get('total_quantity').enable();
      this.supplyItems.at(index).get('total_quantity').setValue('');
    } else {
      // Clear fields if no lot selected
      this.supplyItems.at(index).get('expire_date').setValue('');
      this.supplyItems.at(index).get('available').setValue(0);
      this.supplyItems.at(index).get('total_quantity').disable();
      this.supplyItems.at(index).get('total_quantity').setValue('');
    }
    // Trigger validation for all lot_no fields to check for duplicates
    this.supplyItems.controls.forEach((control, i) => {
      var _control$get7;
      (_control$get7 = control.get('lot_no')) === null || _control$get7 === void 0 || _control$get7.updateValueAndValidity();
    });
    this.change.markForCheck();
  }
  /**
   * Allocates requested quantity across lots using FIFO (First-In-First-Out) based on expiry date
   * If two lots have the same expiry date, prioritize the lot with less available quantity first
   * @param requestedQuantity Total quantity requested
   * @param lots Available lots for the supply item
   * @returns Array of lot allocations with lot_no, quantity, and expire_date
   */
  allocateQuantityToLots(requestedQuantity, lots) {
    const allocations = [];
    let remainingQuantity = requestedQuantity;
    // Sort lots by:
    // 1. Expire date (earliest first) - FIFO
    // 2. If same expiry date, smaller quantity first
    const sortedLots = [...lots].sort((a, b) => {
      const dateA = new Date(a.expire_date).getTime();
      const dateB = new Date(b.expire_date).getTime();
      // First compare by expiry date
      if (dateA !== dateB) {
        return dateA - dateB;
      }
      // If same expiry date, prioritize lot with less available quantity
      const qtyA = this.getAvailableQuantity(a);
      const qtyB = this.getAvailableQuantity(b);
      return qtyA - qtyB;
    });
    // Allocate quantity starting from earliest expiring lot
    for (const lot of sortedLots) {
      if (remainingQuantity <= 0) break;
      const availableInLot = this.getAvailableQuantity(lot);
      const allocatedFromLot = Math.min(remainingQuantity, availableInLot);
      if (allocatedFromLot > 0) {
        allocations.push({
          lot_no: lot.lot_no,
          quantity: allocatedFromLot,
          expire_date: lot.expire_date
        });
        remainingQuantity -= allocatedFromLot;
      }
    }
    // If we still have remaining quantity, it means insufficient stock
    if (remainingQuantity > 0) {}
    return allocations;
  }
  getLotList(index) {
    return this.lotLists[index] || [];
  }
  getAvailableQuantity(lot) {
    return parseFloat(lot.available_in_store) || 0;
  }
  validateQuantity(event, index) {
    const quantity = parseInt(event.detail.value) || 0;
    const quantityControl = this.supplyItems.at(index).get('total_quantity');
    // Calculate total available quantity across all lots for this supply item
    const lotList = this.lotLists[index] || [];
    const totalAvailable = lotList.reduce((sum, lot) => sum + this.getAvailableQuantity(lot), 0);
    if (quantity > totalAvailable) {
      quantityControl.setErrors({
        quantityExceedsAvailable: true
      });
      this.lotAllocations[index] = [];
    } else {
      // Clear custom error but preserve other validation errors
      const errors = quantityControl.errors;
      if (errors !== null && errors !== void 0 && errors.quantityExceedsAvailable) {
        delete errors.quantityExceedsAvailable;
        quantityControl.setErrors(Object.keys(errors).length ? errors : null);
      }
      // Calculate and store lot allocations for display
      if (quantity > 0) {
        this.lotAllocations[index] = this.allocateQuantityToLots(quantity, lotList);
      } else {
        this.lotAllocations[index] = [];
      }
    }
    this.change.markForCheck();
  }
  quantityValidator() {
    return control => {
      if (!control.parent || !this.supplyItems) return null;
      const quantity = parseInt(control.value) || 0;
      if (quantity === 0) return null;
      // Find the index of this control in the supplyItems array
      const index = this.supplyItems.controls.indexOf(control.parent);
      if (index === -1) return null;
      if (this.isFifoMode()) {
        // FIFO mode: Calculate total available quantity across all lots
        const lotList = this.lotLists[index] || [];
        const totalAvailable = lotList.reduce((sum, lot) => sum + this.getAvailableQuantity(lot), 0);
        return quantity > totalAvailable ? {
          quantityExceedsAvailable: true
        } : null;
      } else {
        var _control$parent$get;
        // Manual mode: Check against selected lot's available quantity
        const available = ((_control$parent$get = control.parent.get('available')) === null || _control$parent$get === void 0 ? void 0 : _control$parent$get.value) || 0;
        return quantity > available ? {
          quantityExceedsAvailable: true
        } : null;
      }
    };
  }
  duplicateLotValidator(control) {
    var _control$value, _control$parent$get2;
    if (!control.parent || !this.supplyItems || !this.supplyItems.controls) return null;
    const currentIndex = this.supplyItems.controls.indexOf(control.parent);
    if (currentIndex === -1) return null;
    const currentLotNo = (_control$value = control.value) === null || _control$value === void 0 ? void 0 : _control$value.trim();
    const currentSupplyItemId = (_control$parent$get2 = control.parent.get('supply_item_id')) === null || _control$parent$get2 === void 0 ? void 0 : _control$parent$get2.value;
    if (!currentLotNo || !currentSupplyItemId) return null;
    // Skip validation during form initialization in edit mode
    if (this.isEditMode && !control.touched) return null;
    const hasDuplicate = this.supplyItems.controls.some((formControl, index) => {
      var _formControl$get, _formControl$get2;
      if (index === currentIndex) return false;
      const lotNo = (_formControl$get = formControl.get('lot_no')) === null || _formControl$get === void 0 || (_formControl$get = _formControl$get.value) === null || _formControl$get === void 0 ? void 0 : _formControl$get.trim();
      const supplyItemId = (_formControl$get2 = formControl.get('supply_item_id')) === null || _formControl$get2 === void 0 ? void 0 : _formControl$get2.value;
      return lotNo === currentLotNo && supplyItemId === currentSupplyItemId;
    });
    return hasDuplicate ? {
      duplicateLot: true
    } : null;
  }
  isDuplicateLotNumber(currentIndex) {
    var _currentControl$get, _currentControl$get2;
    if (!this.supplyItems || currentIndex >= this.supplyItems.length) return false;
    const currentControl = this.supplyItems.at(currentIndex);
    if (!currentControl) return false;
    const currentLotNo = (_currentControl$get = currentControl.get('lot_no')) === null || _currentControl$get === void 0 || (_currentControl$get = _currentControl$get.value) === null || _currentControl$get === void 0 ? void 0 : _currentControl$get.trim();
    const currentSupplyItemId = (_currentControl$get2 = currentControl.get('supply_item_id')) === null || _currentControl$get2 === void 0 ? void 0 : _currentControl$get2.value;
    if (!currentLotNo || !currentSupplyItemId) return false;
    const duplicateFound = this.supplyItems.controls.some((control, index) => {
      var _control$get8, _control$get9;
      if (index === currentIndex) return false;
      const lotNo = (_control$get8 = control.get('lot_no')) === null || _control$get8 === void 0 || (_control$get8 = _control$get8.value) === null || _control$get8 === void 0 ? void 0 : _control$get8.trim();
      const supplyItemId = (_control$get9 = control.get('supply_item_id')) === null || _control$get9 === void 0 ? void 0 : _control$get9.value;
      return lotNo === currentLotNo && supplyItemId === currentSupplyItemId;
    });
    return duplicateFound;
  }
  getTodaysDate() {
    return new Date().toISOString().split('T')[0];
  }
  futureDateValidator() {
    return control => {
      if (!control.value) return null;
      const selectedDate = new Date(control.value);
      const today = new Date();
      // Reset time to start of day for accurate comparison
      selectedDate.setHours(0, 0, 0, 0);
      today.setHours(0, 0, 0, 0);
      return selectedDate > today ? {
        futureDate: true
      } : null;
    };
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
        this.markFormGroupTouched(control);
      } else if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormArray) {
        control.controls.forEach(ctrl => {
          if (ctrl instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
            this.markFormGroupTouched(ctrl);
          } else {
            ctrl.markAsTouched();
          }
        });
      } else {
        control === null || control === void 0 || control.markAsTouched();
      }
    });
  }
  // Provider search methods
  ngAfterViewInit() {
    // Initialize provider search when component loads
    setTimeout(() => {
      this.initializeProviderSearch();
    }, 100);
  }
  initializeProviderSearch() {
    const providers = this.getProviderList();
    this.filteredProviders = [...providers];
    this.updateSearchTermFromSelected();
    this.change.markForCheck();
  }
  filterProviders(event) {
    const searchTerm = event.target.value.toLowerCase().trim();
    this.providerSearchTerm = searchTerm;
    const allProviders = this.getProviderList();
    if (!searchTerm) {
      this.filteredProviders = [...allProviders];
    } else {
      this.filteredProviders = allProviders.filter(provider => provider.title.toLowerCase().includes(searchTerm));
    }
    this.showFilteredOptions = true;
    this.change.markForCheck();
  }
  selectProvider(provider) {
    var _this$supplyRequestFo3;
    (_this$supplyRequestFo3 = this.supplyRequestForm.get('provider')) === null || _this$supplyRequestFo3 === void 0 || _this$supplyRequestFo3.setValue(provider.id);
    this.providerSearchTerm = provider.title;
    this.showFilteredOptions = false;
    this.change.markForCheck();
  }
  updateSearchTermFromSelected() {
    var _this$supplyRequestFo4;
    const selectedProviderId = (_this$supplyRequestFo4 = this.supplyRequestForm.get('provider')) === null || _this$supplyRequestFo4 === void 0 ? void 0 : _this$supplyRequestFo4.value;
    if (selectedProviderId) {
      const providers = this.getProviderList();
      const selectedProvider = providers.find(p => p.id === selectedProviderId);
      if (selectedProvider) {
        this.providerSearchTerm = selectedProvider.title;
      }
    } else {
      this.providerSearchTerm = '';
    }
  }
  resetProviderSearch() {
    this.filteredProviders = [];
    this.providerSearchTerm = '';
    this.showFilteredOptions = false;
  }
  onSearchFocus() {
    this.initializeProviderSearch();
    this.showFilteredOptions = true;
    this.change.markForCheck();
  }
  trackByProviderId(index, provider) {
    return provider.id;
  }
  onSearchBlur() {
    // Delay hiding the options to allow for click events
    setTimeout(() => {
      this.showFilteredOptions = false;
      this.change.markForCheck();
    }, 200);
  }
  getLotAllocation(index) {
    return this.lotAllocations[index] || [];
  }
  getLotAllocatedQty(index, lotNo) {
    const allocations = this.lotAllocations[index] || [];
    const allocation = allocations.find(a => a.lot_no === lotNo);
    return allocation ? allocation.quantity : 0;
  }
  formatDate(dateString) {
    if (!dateString) return '';
    const date = new Date(dateString);
    return date.toLocaleDateString('en-GB', {
      day: '2-digit',
      month: 'short',
      year: 'numeric'
    });
  }
}, _SupplyOutPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.Router
}, {
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ChangeDetectorRef
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.NgZone
}, {
  type: src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__.SupplyAPIService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.PopoverController
}], _SupplyOutPage);
SupplyOutPage = (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-supply-out',
  template: _supply_out_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ChangeDetectionStrategy.OnPush,
  styles: [(_supply_out_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SupplyOutPage);


/***/ }),

/***/ 65093:
/*!******************************************************************!*\
  !*** ./src/app/pages/supply-out/supply-out.page.scss?ngResource ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-warning: #ffc409;
  --ion-color-warning-rgb: 255, 196, 9;
  --ion-color-warning-contrast: #000000;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

.supply-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.supply-form .form-section {
  margin-bottom: 32px;
}
.supply-form .form-section:last-child {
  margin-bottom: 0;
}
.supply-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.supply-form .section-subtitle ion-icon {
  font-size: 20px;
}
.supply-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.supply-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.supply-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.supply-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.supply-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.supply-form .form-item ion-note[color=warning] {
  color: var(--ion-color-warning);
  font-weight: 500;
}

.supply-item-card {
  border: 1px solid rgba(255, 196, 9, 0.2);
  border-radius: 12px;
  margin-bottom: 20px;
  padding: 16px;
  background: rgba(255, 196, 9, 0.05);
  position: relative;
}
.supply-item-card .supply-item-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 16px;
  padding-bottom: 12px;
  border-bottom: 1px solid rgba(255, 196, 9, 0.2);
}
.supply-item-card .supply-item-header .item-number {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-warning);
  background: rgba(255, 196, 9, 0.15);
  padding: 4px 8px;
  border-radius: 8px;
}
.supply-item-card .supply-item-header .remove-btn {
  --padding-start: 8px;
  --padding-end: 8px;
  --padding-top: 4px;
  --padding-bottom: 4px;
  height: 32px;
}
.supply-item-card .form-item {
  margin-bottom: 12px;
  background: white;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.06);
}
.supply-item-card .form-item:last-child {
  margin-bottom: 0;
}
.supply-item-card .total-input {
  font-weight: 600;
  color: var(--ion-color-warning);
}
.supply-item-card .total-input ion-input {
  --color: var(--ion-color-warning);
  --placeholder-color: rgba(255, 196, 9, 0.5);
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .add-item-btn {
  min-width: 140px;
}
.form-actions .add-item-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}
.form-actions .submit-btn {
  min-width: 160px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

@media (min-width: 768px) {
  .supply-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .supply-item-card {
    padding: 20px;
  }
  .supply-item-card .supply-item-header {
    margin-bottom: 20px;
  }
  .supply-item-card .supply-item-header .item-number {
    font-size: 16px;
    padding: 6px 12px;
  }
  .supply-item-card .supply-item-header .remove-btn {
    height: 36px;
  }
  .supply-item-card .form-item {
    margin-bottom: 16px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .add-item-btn {
    min-width: 160px;
  }
  .form-actions .submit-btn {
    min-width: 180px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 16px;
  }
  .section-title ion-icon {
    font-size: 20px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .supply-item-card {
    padding: 12px;
    margin-bottom: 16px;
  }
  .supply-item-card .supply-item-header {
    margin-bottom: 12px;
  }
  .supply-item-card .supply-item-header .item-number {
    font-size: 12px;
    padding: 3px 6px;
  }
  .supply-item-card .supply-item-header .remove-btn {
    height: 28px;
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .supply-item-card .form-item {
    margin-bottom: 8px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .add-item-btn,
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
}
@media (prefers-color-scheme: dark) {
  .supply-item-card {
    background: rgba(255, 196, 9, 0.08);
    border-color: rgba(255, 196, 9, 0.3);
  }
  .supply-item-card .supply-item-header {
    border-bottom-color: rgba(255, 196, 9, 0.3);
  }
  .supply-item-card .form-item {
    background: var(--ion-color-step-50);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
}
ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-medium);
  font-weight: 500;
  cursor: pointer;
}

ion-select {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-grid {
  padding: 0;
}
ion-grid ion-row {
  margin: 0;
}
ion-grid ion-col {
  padding: 4px;
}

.supply-container app-skeleton {
  margin: 20px 0;
}

.form-section:has(.total-input) .section-subtitle {
  color: var(--ion-color-warning);
  border-bottom-color: rgba(255, 196, 9, 0.3);
}
.form-section:has(.total-input) .section-subtitle ion-icon {
  color: var(--ion-color-warning);
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-warning), transparent);
  border-radius: 1px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-warning);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.total-input ion-input {
  background: rgba(255, 196, 9, 0.1);
  border-radius: 4px;
  font-weight: 600;
}

.unit-label {
  color: var(--ion-color-primary);
  font-weight: 500;
  font-size: 0.9em;
}

.available-label {
  color: var(--ion-color-success);
  font-weight: 600;
  font-size: 0.9em;
}

.lot-allocation-info {
  background: rgba(73, 144, 226, 0.05);
  border: 1px solid rgba(73, 144, 226, 0.2);
  border-radius: 8px;
  padding: 12px;
  margin-top: 8px;
}
.lot-allocation-info .lot-allocation-label {
  display: flex;
  align-items: center;
  gap: 6px;
  font-size: 13px;
  font-weight: 600;
  color: var(--ion-color-primary);
  margin-bottom: 8px;
}
.lot-allocation-info .lot-allocation-label ion-icon {
  font-size: 18px;
}
.lot-allocation-info .lot-allocation-label ion-icon[color=success] {
  color: var(--ion-color-success);
}
.lot-allocation-info .lot-allocation-list {
  display: flex;
  flex-direction: column;
  gap: 6px;
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=primary] {
  margin: 0;
  width: 100%;
  max-width: 100%;
  height: auto;
  padding: 8px 12px;
  --background: rgba(73, 144, 226, 0.08);
  border: 1px solid rgba(73, 144, 226, 0.3);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=primary] ion-icon {
  font-size: 16px;
  margin-right: 6px;
  color: var(--ion-color-primary);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=primary] ion-label {
  font-size: 12px;
  white-space: normal;
  word-break: break-word;
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=primary] ion-label strong {
  font-weight: 600;
  color: var(--ion-color-primary);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] {
  margin: 0;
  width: 100%;
  max-width: 100%;
  height: auto;
  padding: 8px 12px;
  --background: rgba(45, 211, 111, 0.1);
  border: 1px solid rgba(45, 211, 111, 0.3);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] ion-icon {
  font-size: 16px;
  margin-right: 6px;
  color: var(--ion-color-success);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] ion-label {
  font-size: 12px;
  white-space: normal;
  word-break: break-word;
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] ion-label strong {
  font-weight: 600;
  color: var(--ion-color-success);
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] ion-label .allocated-text {
  color: var(--ion-color-success);
  font-weight: 600;
}
.lot-allocation-info .lot-allocation-list .lot-allocation-item ion-chip[color=success] ion-label .allocated-text strong {
  color: var(--ion-color-success);
}

.provider-search-container {
  margin-bottom: 16px;
  padding: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.provider-search-container .provider-label {
  font-weight: 500;
  color: var(--ion-color-dark);
  font-size: 14px;
  margin-bottom: 8px;
  display: block;
}
.provider-search-container .provider-search-wrapper {
  position: relative;
  width: 100%;
}
.provider-search-container .provider-search-wrapper .provider-searchbar {
  --background: white;
  --border-radius: 4px;
  --box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  --padding-start: 12px;
  --padding-end: 12px;
  margin: 0;
}
.provider-search-container .provider-search-wrapper .provider-searchbar ion-searchbar {
  --placeholder-color: var(--ion-color-medium);
  --color: var(--ion-color-dark);
  --icon-color: var(--ion-color-medium);
}
.provider-search-container .provider-search-wrapper .provider-options-list {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  z-index: 1000;
  max-height: 240px;
  overflow-y: auto;
  background: white;
  border: 1px solid rgba(0, 0, 0, 0.1);
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
  margin-top: 4px;
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item {
  --min-height: 48px;
  --padding-start: 16px;
  --padding-end: 16px;
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item:last-child {
  border-bottom: none;
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item:hover, .provider-search-container .provider-search-wrapper .provider-options-list ion-item.selected {
  --background: rgba(73, 144, 226, 0.1);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item ion-label {
  font-size: 14px;
  font-weight: 400;
  color: var(--ion-color-dark);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item ion-icon[name=checkmark] {
  font-size: 18px;
}
.provider-search-container .provider-search-wrapper .no-results {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  z-index: 1000;
  background: white;
  border: 1px solid rgba(0, 0, 0, 0.1);
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
  margin-top: 4px;
  padding: 24px;
  text-align: center;
}
.provider-search-container .provider-search-wrapper .no-results p {
  color: var(--ion-color-medium);
  font-size: 14px;
  margin: 0;
}
.provider-search-container .error-note {
  font-size: 12px;
  color: var(--ion-color-danger);
  margin-top: 4px;
  display: block;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/supply-out/supply-out.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,4BAAA;EACA,oCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAAF;;AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAAF;;AAGA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAAF;;AAIA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AADF;;AAIA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AADF;AAGE;EACE,eAAA;AADJ;;AAOE;EACE,mBAAA;AAJJ;AAMI;EACE,gBAAA;AAJN;AAQE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AANJ;AAQI;EACE,eAAA;AANN;AAUE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AARJ;AAUI;EACE,gBAAA;EACA,4BAAA;AARN;AAWI;EACE,eAAA;EACA,eAAA;AATN;AAWM;EACE,8BAAA;AATR;AAYM;EACE,8BAAA;AAVR;AAaM;EACE,+BAAA;EACA,gBAAA;AAXR;;AAkBA;EACE,wCAAA;EACA,mBAAA;EACA,mBAAA;EACA,aAAA;EACA,mCAAA;EACA,kBAAA;AAfF;AAiBE;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;EACA,oBAAA;EACA,+CAAA;AAfJ;AAiBI;EACE,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,mCAAA;EACA,gBAAA;EACA,kBAAA;AAfN;AAkBI;EACE,oBAAA;EACA,kBAAA;EACA,kBAAA;EACA,qBAAA;EACA,YAAA;AAhBN;AAoBE;EACE,mBAAA;EACA,iBAAA;EACA,kBAAA;EACA,qCAAA;AAlBJ;AAoBI;EACE,gBAAA;AAlBN;AAsBE;EACE,gBAAA;EACA,+BAAA;AApBJ;AAsBI;EACE,iCAAA;EACA,2CAAA;AApBN;;AA0BA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AAvBF;AAyBE;EACE,gBAAA;AAvBJ;AAyBI;EACE,YAAA;EACA,mBAAA;AAvBN;AA2BE;EACE,gBAAA;AAzBJ;AA2BI;EACE,YAAA;EACA,mBAAA;AAzBN;;AA+BA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA5BF;AA8BE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AA5BJ;AA+BE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AA7BJ;;AAkCA;EACE;IACE,gBAAA;EA/BF;EAkCA;IACE,gBAAA;EAhCF;EAmCA;IACE,eAAA;EAjCF;EAmCE;IACE,eAAA;EAjCJ;EAqCA;IACE,eAAA;EAnCF;EAqCE;IACE,eAAA;EAnCJ;EAuCA;IACE,aAAA;EArCF;EAuCE;IACE,mBAAA;EArCJ;EAuCI;IACE,eAAA;IACA,iBAAA;EArCN;EAwCI;IACE,YAAA;EAtCN;EA0CE;IACE,mBAAA;EAxCJ;EA4CA;IACE,gBAAA;EA1CF;EA4CE;IACE,gBAAA;EA1CJ;EA6CE;IACE,gBAAA;EA3CJ;EA+CA;IACE,kBAAA;EA7CF;EA+CE;IACE,WAAA;IACA,YAAA;EA7CJ;EAgDE;IACE,eAAA;EA9CJ;AACF;AAmDA;EACE;IACE,eAAA;EAjDF;EAmDE;IACE,eAAA;EAjDJ;EAqDA;IACE,eAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAuDA;IACE,aAAA;IACA,mBAAA;EArDF;EAuDE;IACE,mBAAA;EArDJ;EAuDI;IACE,eAAA;IACA,gBAAA;EArDN;EAwDI;IACE,YAAA;IACA,oBAAA;IACA,kBAAA;EAtDN;EA0DE;IACE,kBAAA;EAxDJ;EA4DA;IACE,sBAAA;IACA,gBAAA;EA1DF;EA4DE;;IAEE,WAAA;IACA,eAAA;EA1DJ;EA8DA;IACE,kBAAA;EA5DF;EA8DE;IACE,eAAA;EA5DJ;AACF;AAiEA;EACE;IACE,mCAAA;IACA,oCAAA;EA/DF;EAiEE;IACE,2CAAA;EA/DJ;EAkEE;IACE,oCAAA;IACA,uCAAA;EAhEJ;EAoEA;;IAEE,6BAAA;EAlEF;AACF;AAsEA;EACE,oBAAA;EACA,kBAAA;AApEF;AAsEE;EACE,gCAAA;EACA,gBAAA;EACA,eAAA;AApEJ;;AAwEA;EACE,oBAAA;EACA,kBAAA;AArEF;;AAyEA;EACE,UAAA;AAtEF;AAwEE;EACE,SAAA;AAtEJ;AAyEE;EACE,YAAA;AAvEJ;;AA4EA;EACE,cAAA;AAzEF;;AA8EE;EACE,+BAAA;EACA,2CAAA;AA3EJ;AA6EI;EACE,+BAAA;AA3EN;;AAiFA;EACE,kBAAA;AA9EF;AAgFE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AA9EJ;;AAmFA;EACE,qCAAA;AAhFF;AAkFE;EACE,8BAAA;AAhFJ;;AAoFA;EACE,sCAAA;AAjFF;;AAqFA;EACE,gBAAA;AAlFF;AAoFE;EACE,cAAA;EACA,oBAAA;AAlFJ;;AAuFA;EACE,kCAAA;EACA,kBAAA;EACA,gBAAA;AApFF;;AAwFA;EACE,+BAAA;EACA,gBAAA;EACA,gBAAA;AArFF;;AAyFA;EACE,+BAAA;EACA,gBAAA;EACA,gBAAA;AAtFF;;AA0FA;EACE,oCAAA;EACA,yCAAA;EACA,kBAAA;EACA,aAAA;EACA,eAAA;AAvFF;AAyFE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,kBAAA;AAvFJ;AAyFI;EACE,eAAA;AAvFN;AA2FI;EACE,+BAAA;AAzFN;AA6FE;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AA3FJ;AA+FM;EACE,SAAA;EACA,WAAA;EACA,eAAA;EACA,YAAA;EACA,iBAAA;EACA,sCAAA;EACA,yCAAA;AA7FR;AA+FQ;EACE,eAAA;EACA,iBAAA;EACA,+BAAA;AA7FV;AAgGQ;EACE,eAAA;EACA,mBAAA;EACA,sBAAA;AA9FV;AAgGU;EACE,gBAAA;EACA,+BAAA;AA9FZ;AAoGM;EACE,SAAA;EACA,WAAA;EACA,eAAA;EACA,YAAA;EACA,iBAAA;EACA,qCAAA;EACA,yCAAA;AAlGR;AAoGQ;EACE,eAAA;EACA,iBAAA;EACA,+BAAA;AAlGV;AAqGQ;EACE,eAAA;EACA,mBAAA;EACA,sBAAA;AAnGV;AAqGU;EACE,gBAAA;EACA,+BAAA;AAnGZ;AAsGU;EACE,+BAAA;EACA,gBAAA;AApGZ;AAsGY;EACE,+BAAA;AApGd;;AA8GA;EACE,mBAAA;EACA,aAAA;EACA,kBAAA;EACA,qCAAA;AA3GF;AA6GE;EACE,gBAAA;EACA,4BAAA;EACA,eAAA;EACA,kBAAA;EACA,cAAA;AA3GJ;AA8GE;EACE,kBAAA;EACA,WAAA;AA5GJ;AA8GI;EACE,mBAAA;EACA,oBAAA;EACA,0CAAA;EACA,qBAAA;EACA,mBAAA;EACA,SAAA;AA5GN;AA8GM;EACE,4CAAA;EACA,8BAAA;EACA,qCAAA;AA5GR;AAgHI;EACE,kBAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,aAAA;EACA,iBAAA;EACA,gBAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,0CAAA;EACA,eAAA;AA9GN;AAgHM;EACE,kBAAA;EACA,qBAAA;EACA,mBAAA;EACA,4CAAA;AA9GR;AAgHQ;EACE,mBAAA;AA9GV;AAiHQ;EACE,qCAAA;AA/GV;AAkHQ;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAhHV;AAmHQ;EACE,eAAA;AAjHV;AAsHI;EACE,kBAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,aAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,0CAAA;EACA,eAAA;EACA,aAAA;EACA,kBAAA;AApHN;AAsHM;EACE,8BAAA;EACA,eAAA;EACA,SAAA;AApHR;AAyHE;EACE,eAAA;EACA,8BAAA;EACA,eAAA;EACA,cAAA;AAvHJ","sourcesContent":["// Supply out styles adapted from supply-in\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-warning: #ffc409;\n  --ion-color-warning-rgb: 255, 196, 9;\n  --ion-color-warning-contrast: #000000;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n.supply-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  \n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.supply-form {\n  .form-section {\n    margin-bottom: 32px;\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n    \n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n    \n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n      \n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n      \n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n      \n      &[color=\"warning\"] {\n        color: var(--ion-color-warning);\n        font-weight: 500;\n      }\n    }\n  }\n}\n\n// Supply item cards with warning theme for out operations\n.supply-item-card {\n  border: 1px solid rgba(255, 196, 9, 0.2);\n  border-radius: 12px;\n  margin-bottom: 20px;\n  padding: 16px;\n  background: rgba(255, 196, 9, 0.05);\n  position: relative;\n  \n  .supply-item-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 16px;\n    padding-bottom: 12px;\n    border-bottom: 1px solid rgba(255, 196, 9, 0.2);\n    \n    .item-number {\n      font-size: 14px;\n      font-weight: 600;\n      color: var(--ion-color-warning);\n      background: rgba(255, 196, 9, 0.15);\n      padding: 4px 8px;\n      border-radius: 8px;\n    }\n    \n    .remove-btn {\n      --padding-start: 8px;\n      --padding-end: 8px;\n      --padding-top: 4px;\n      --padding-bottom: 4px;\n      height: 32px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 12px;\n    background: white;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.06);\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .total-input {\n    font-weight: 600;\n    color: var(--ion-color-warning);\n    \n    ion-input {\n      --color: var(--ion-color-warning);\n      --placeholder-color: rgba(255, 196, 9, 0.5);\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n  \n  .add-item-btn {\n    min-width: 140px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n  \n  .submit-btn {\n    min-width: 160px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n  \n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n  \n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .supply-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n  \n  .section-title {\n    font-size: 24px;\n    \n    ion-icon {\n      font-size: 28px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .supply-item-card {\n    padding: 20px;\n    \n    .supply-item-header {\n      margin-bottom: 20px;\n      \n      .item-number {\n        font-size: 16px;\n        padding: 6px 12px;\n      }\n      \n      .remove-btn {\n        height: 36px;\n      }\n    }\n    \n    .form-item {\n      margin-bottom: 16px;\n    }\n  }\n  \n  .form-actions {\n    margin-top: 32px;\n    \n    .add-item-btn {\n      min-width: 160px;\n    }\n    \n    .submit-btn {\n      min-width: 180px;\n    }\n  }\n  \n  .loading-container {\n    padding: 80px 40px;\n    \n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n    \n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 16px;\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 14px;\n    \n    ion-icon {\n      font-size: 18px;\n    }\n  }\n  \n  .supply-item-card {\n    padding: 12px;\n    margin-bottom: 16px;\n    \n    .supply-item-header {\n      margin-bottom: 12px;\n      \n      .item-number {\n        font-size: 12px;\n        padding: 3px 6px;\n      }\n      \n      .remove-btn {\n        height: 28px;\n        --padding-start: 4px;\n        --padding-end: 4px;\n      }\n    }\n    \n    .form-item {\n      margin-bottom: 8px;\n    }\n  }\n  \n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n    \n    .add-item-btn,\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n  \n  .loading-container {\n    padding: 40px 16px;\n    \n    p {\n      font-size: 12px;\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .supply-item-card {\n    background: rgba(255, 196, 9, 0.08);\n    border-color: rgba(255, 196, 9, 0.3);\n    \n    .supply-item-header {\n      border-bottom-color: rgba(255, 196, 9, 0.3);\n    }\n    \n    .form-item {\n      background: var(--ion-color-step-50);\n      border-color: rgba(255, 255, 255, 0.08);\n    }\n  }\n  \n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  \n  &[readonly] {\n    --color: var(--ion-color-medium);\n    font-weight: 500;\n    cursor: pointer;\n  }\n}\n\nion-select {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Grid spacing adjustments\nion-grid {\n  padding: 0;\n  \n  ion-row {\n    margin: 0;\n  }\n  \n  ion-col {\n    padding: 4px;\n  }\n}\n\n// Loading skeleton container\n.supply-container app-skeleton {\n  margin: 20px 0;\n}\n\n// Warning-specific styling for out operations\n.form-section:has(.total-input) {\n  .section-subtitle {\n    color: var(--ion-color-warning);\n    border-bottom-color: rgba(255, 196, 9, 0.3);\n    \n    ion-icon {\n      color: var(--ion-color-warning);\n    }\n  }\n}\n\n// Enhanced visual indicators for out flow\n.section-header .section-title {\n  position: relative;\n  \n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-warning), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n  \n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-warning);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n  \n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Quantity calculation visual feedback\n.total-input ion-input {\n  background: rgba(255, 196, 9, 0.1);\n  border-radius: 4px;\n  font-weight: 600;\n}\n\n// Unit label styling\n.unit-label {\n  color: var(--ion-color-primary);\n  font-weight: 500;\n  font-size: 0.9em;\n}\n\n// Available label styling\n.available-label {\n  color: var(--ion-color-success);\n  font-weight: 600;\n  font-size: 0.9em;\n}\n\n// Lot allocation info display with available and allocated quantities\n.lot-allocation-info {\n  background: rgba(73, 144, 226, 0.05);\n  border: 1px solid rgba(73, 144, 226, 0.2);\n  border-radius: 8px;\n  padding: 12px;\n  margin-top: 8px;\n\n  .lot-allocation-label {\n    display: flex;\n    align-items: center;\n    gap: 6px;\n    font-size: 13px;\n    font-weight: 600;\n    color: var(--ion-color-primary);\n    margin-bottom: 8px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n\n    // When lots are allocated, label turns green\n    ion-icon[color=\"success\"] {\n      color: var(--ion-color-success);\n    }\n  }\n\n  .lot-allocation-list {\n    display: flex;\n    flex-direction: column;\n    gap: 6px;\n\n    .lot-allocation-item {\n      // Default chips (primary/blue) - not allocated\n      ion-chip[color=\"primary\"] {\n        margin: 0;\n        width: 100%;\n        max-width: 100%;\n        height: auto;\n        padding: 8px 12px;\n        --background: rgba(73, 144, 226, 0.08);\n        border: 1px solid rgba(73, 144, 226, 0.3);\n\n        ion-icon {\n          font-size: 16px;\n          margin-right: 6px;\n          color: var(--ion-color-primary);\n        }\n\n        ion-label {\n          font-size: 12px;\n          white-space: normal;\n          word-break: break-word;\n\n          strong {\n            font-weight: 600;\n            color: var(--ion-color-primary);\n          }\n        }\n      }\n\n      // Allocated chips (success/green)\n      ion-chip[color=\"success\"] {\n        margin: 0;\n        width: 100%;\n        max-width: 100%;\n        height: auto;\n        padding: 8px 12px;\n        --background: rgba(45, 211, 111, 0.1);\n        border: 1px solid rgba(45, 211, 111, 0.3);\n\n        ion-icon {\n          font-size: 16px;\n          margin-right: 6px;\n          color: var(--ion-color-success);\n        }\n\n        ion-label {\n          font-size: 12px;\n          white-space: normal;\n          word-break: break-word;\n\n          strong {\n            font-weight: 600;\n            color: var(--ion-color-success);\n          }\n\n          .allocated-text {\n            color: var(--ion-color-success);\n            font-weight: 600;\n\n            strong {\n              color: var(--ion-color-success);\n            }\n          }\n        }\n      }\n    }\n  }\n}\n\n// Provider search styling\n.provider-search-container {\n  margin-bottom: 16px;\n  padding: 16px;\n  border-radius: 8px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n  \n  .provider-label {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n    font-size: 14px;\n    margin-bottom: 8px;\n    display: block;\n  }\n  \n  .provider-search-wrapper {\n    position: relative;\n    width: 100%;\n    \n    .provider-searchbar {\n      --background: white;\n      --border-radius: 4px;\n      --box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\n      --padding-start: 12px;\n      --padding-end: 12px;\n      margin: 0;\n      \n      ion-searchbar {\n        --placeholder-color: var(--ion-color-medium);\n        --color: var(--ion-color-dark);\n        --icon-color: var(--ion-color-medium);\n      }\n    }\n    \n    .provider-options-list {\n      position: absolute;\n      top: 100%;\n      left: 0;\n      right: 0;\n      z-index: 1000;\n      max-height: 240px;\n      overflow-y: auto;\n      background: white;\n      border: 1px solid rgba(0, 0, 0, 0.1);\n      border-radius: 8px;\n      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n      margin-top: 4px;\n      \n      ion-item {\n        --min-height: 48px;\n        --padding-start: 16px;\n        --padding-end: 16px;\n        border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n        \n        &:last-child {\n          border-bottom: none;\n        }\n        \n        &:hover, &.selected {\n          --background: rgba(73, 144, 226, 0.1);\n        }\n        \n        ion-label {\n          font-size: 14px;\n          font-weight: 400;\n          color: var(--ion-color-dark);\n        }\n        \n        ion-icon[name=\"checkmark\"] {\n          font-size: 18px;\n        }\n      }\n    }\n    \n    .no-results {\n      position: absolute;\n      top: 100%;\n      left: 0;\n      right: 0;\n      z-index: 1000;\n      background: white;\n      border: 1px solid rgba(0, 0, 0, 0.1);\n      border-radius: 8px;\n      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n      margin-top: 4px;\n      padding: 24px;\n      text-align: center;\n      \n      p {\n        color: var(--ion-color-medium);\n        font-size: 14px;\n        margin: 0;\n      }\n    }\n  }\n  \n  .error-note {\n    font-size: 12px;\n    color: var(--ion-color-danger);\n    margin-top: 4px;\n    display: block;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 68105:
/*!******************************************************************!*\
  !*** ./src/app/pages/supply-out/supply-out.page.html?ngResource ***!
  \******************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n       <ion-back-button defaultHref=\"home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{title}}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"(isEditMode && supplyEditPreqData) || (!isEditMode && supplyRequestPreq); else loading\"\n    class=\"supply-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"{{isEditMode ? 'create-outline' : (isRequisitionMode ? 'document-text-outline' : 'remove-circle-outline')}}\" [color]=\"isRequisitionMode ? 'primary' : 'warning'\"></ion-icon>\n        {{title}}\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"supplyRequestForm\" (ngSubmit)=\"submitForm(supplyRequestForm)\" class=\"supply-form\">\n\n            <!-- Basic Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"information-circle-outline\" color=\"primary\"></ion-icon>\n                Basic Information\n              </h3>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Transaction Date *</ion-label>\n                <ion-input formControlName=\"transaction_date\" type=\"date\"\n                  placeholder=\"Select transaction date\" [max]=\"getTodaysDate()\"></ion-input>\n                <ion-note slot=\"error\"\n                  *ngIf=\"supplyRequestForm.get('transaction_date')?.invalid && supplyRequestForm.get('transaction_date')?.touched\">\n                  <span *ngIf=\"supplyRequestForm.get('transaction_date')?.errors?.['required']\">This field is required</span>\n                  <span *ngIf=\"supplyRequestForm.get('transaction_date')?.errors?.['futureDate']\">Transaction date cannot be in the future</span>\n                </ion-note>\n              </ion-item>\n\n              <!-- Out Reason - Hidden for requisition mode -->\n              <ion-item class=\"form-item\" *ngIf=\"!isRequisitionMode\">\n                <ion-label position=\"stacked\">Out Reason *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"transaction_def\"\n                  (ionChange)=\"onTransactionDefChange($event)\">\n                  <ion-select-option value=\"inf_to_dp\">Provide to Distribution Point</ion-select-option>\n                  <ion-select-option value=\"inf_to_wh\">Damaged Item</ion-select-option>\n                  <ion-select-option value=\"inf_to_inf\">Supply for Another INF</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\"\n                  *ngIf=\"supplyRequestForm.get('transaction_def')?.invalid && supplyRequestForm.get('transaction_def')?.touched\">\n                  This field is required\n                </ion-note>\n              </ion-item>\n\n              <!-- Provider selection for inf_to_inf with search -->\n              <div *ngIf=\"supplyRequestForm.get('transaction_def')?.value === 'inf_to_inf'\" class=\"form-item provider-search-container\">\n                <ion-label class=\"provider-label\">Destination INF *</ion-label>\n                \n                \n                <div class=\"provider-search-wrapper\" (click)=\"$event.stopPropagation()\">\n                  <ion-searchbar \n                    [(ngModel)]=\"providerSearchTerm\"\n                    (ionInput)=\"filterProviders($event)\"\n                    (ionFocus)=\"onSearchFocus()\"\n                    (ionBlur)=\"onSearchBlur()\"\n                    placeholder=\"Search and select destination INF...\"\n                    [ngModelOptions]=\"{standalone: true}\"\n                    class=\"provider-searchbar\">\n                  </ion-searchbar>\n                  \n                  <!-- Hidden select for form integration -->\n                  <ion-select \n                    formControlName=\"provider\"\n                    interface=\"action-sheet\"\n                    style=\"display: none;\">\n                    <ion-select-option *ngFor=\"let item of getProviderList()\"\n                      [value]=\"item.id\">{{item.title}}</ion-select-option>\n                  </ion-select>\n                  \n                  <!-- Options dropdown -->\n                  <ion-list *ngIf=\"showFilteredOptions && filteredProviders?.length > 0\" class=\"provider-options-list\">\n                    <ion-item \n                      button \n                      *ngFor=\"let provider of filteredProviders; trackBy: trackByProviderId\" \n                      (click)=\"selectProvider(provider)\"\n                      [class.selected]=\"supplyRequestForm.get('provider')?.value === provider.id\">\n                      <ion-label>{{provider.title}}</ion-label>\n                      <ion-icon \n                        *ngIf=\"supplyRequestForm.get('provider')?.value === provider.id\" \n                        name=\"checkmark\" \n                        color=\"primary\" \n                        slot=\"end\">\n                      </ion-icon>\n                    </ion-item>\n                  </ion-list>\n                  \n                  <!-- No results -->\n                  <div *ngIf=\"showFilteredOptions && filteredProviders?.length === 0 && providerSearchTerm\" class=\"no-results\">\n                    <p>No INFs found matching \"{{providerSearchTerm}}\"</p>\n                  </div>\n                  \n                  <div *ngIf=\"showFilteredOptions && filteredProviders?.length === 0 && !providerSearchTerm\" class=\"no-results\">\n                    <p>No INF data available. Check console for details.</p>\n                  </div>\n                </div>\n                \n                <ion-note class=\"error-note\"\n                  *ngIf=\"supplyRequestForm.get('provider')?.invalid && supplyRequestForm.get('provider')?.touched\">\n                  This field is required\n                </ion-note>\n              </div>\n\n              <!-- Provider selection for other transaction types -->\n              <ion-item class=\"form-item\" *ngIf=\"supplyRequestForm.get('transaction_def')?.value === 'inf_to_wh'\">\n                <ion-label position=\"stacked\">Destination PP *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"provider\">\n                  <ion-select-option *ngFor=\"let item of getProviderList()\"\n                    [value]=\"item.id\">{{item.title}}</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\"\n                  *ngIf=\"supplyRequestForm.get('provider')?.invalid && supplyRequestForm.get('provider')?.touched\">\n                  This field is required\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" *ngIf=\"supplyRequestForm.get('transaction_def')?.value !== 'inf_to_dp'\">\n                <ion-icon slot=\"start\" name=\"receipt-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Waybill No</ion-label>\n                <ion-input formControlName=\"waybill\" placeholder=\"Enter waybill number (optional)\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Notes</ion-label>\n                <ion-textarea formControlName=\"notes\" placeholder=\"Enter additional notes (optional)\"\n                  rows=\"3\"></ion-textarea>\n              </ion-item>\n            </div>\n\n            <!-- Supply Items Section -->\n            <div class=\"form-section\" formArrayName=\"supply_items\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"cube-outline\" color=\"primary\"></ion-icon>\n                Supply Items ({{supplyItems.length}})\n              </h3>\n\n              <div *ngFor=\"let item of supplyRequestForm.controls.supply_items['controls']; let i=index\"\n                [formGroupName]=\"i\" class=\"supply-item-card\">\n                <div class=\"supply-item-header\">\n                  <span class=\"item-number\">Item #{{i + 1}}</span>\n                  <ion-button *ngIf=\"supplyItems.length > 1\" fill=\"clear\" color=\"danger\" (click)=\"removeSupply(i)\"\n                    class=\"remove-btn\">\n                    <ion-icon name=\"trash-outline\" slot=\"icon-only\"></ion-icon>\n                  </ion-button>\n                </div>\n\n                <ion-grid>\n                  <ion-row>\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-label position=\"stacked\">Supply Item *</ion-label>\n                        <ion-select interface=\"action-sheet\" formControlName=\"supply_item_id\"\n                          (ionChange)=\"onSelectSupplyItem($event, i)\">\n                          <ion-select-option *ngFor=\"let supply of getAvailableSupplyItems(i)\" [value]=\"supply.id\">\n                            {{supply.title}}\n                          </ion-select-option>\n                        </ion-select>\n                        <ion-note slot=\"error\"\n                          *ngIf=\"supplyItems.at(i).get('supply_item_id')?.invalid && supplyItems.at(i).get('supply_item_id')?.touched\">\n                          Please select a supply item\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n\n                    <!-- Lot Selection for Manual Mode (non-FIFO) -->\n                    <ion-col size=\"12\" size-md=\"6\" *ngIf=\"!isFifoMode()\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"pricetag-outline\" color=\"primary\"></ion-icon>\n                        <ion-label position=\"stacked\">Lot/Batch No *</ion-label>\n                        <ion-select interface=\"action-sheet\" formControlName=\"lot_no\"\n                          (ionChange)=\"onSelectLot($event, i)\"\n                          [disabled]=\"!supplyItems.at(i).get('supply_item_id')?.value\">\n                          <ion-select-option *ngFor=\"let lot of getLotList(i)\" [value]=\"lot.lot_no\">\n                            {{lot.lot_no}} (Available: {{getAvailableQuantity(lot)}})\n                          </ion-select-option>\n                        </ion-select>\n                        <ion-note slot=\"error\"\n                          *ngIf=\"supplyItems.at(i).get('lot_no')?.invalid && supplyItems.at(i).get('lot_no')?.touched\">\n                          <span *ngIf=\"supplyItems.at(i).get('lot_no')?.errors?.['required']\">Please select a lot number</span>\n                          <span *ngIf=\"supplyItems.at(i).get('lot_no')?.errors?.['duplicateLot']\">This lot number already exists for this supply item</span>\n                        </ion-note>\n                        <ion-note slot=\"helper\" *ngIf=\"!supplyItems.at(i).get('supply_item_id')?.value\" color=\"medium\">\n                          Select supply item first\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n\n                    <!-- Total Quantity for FIFO Mode (in same row as Supply Item) -->\n                    <ion-col size=\"12\" size-md=\"6\" *ngIf=\"isFifoMode()\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"calculator-outline\" color=\"warning\"></ion-icon>\n                        <ion-label position=\"stacked\">\n                          Total Quantity *\n                          <span *ngIf=\"getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value)\"\n                            class=\"unit-label\">\n                            ({{ getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value) }})\n                          </span>\n                          <span *ngIf=\"supplyItems.at(i).get('available')?.value > 0\" class=\"available-label\">\n                            - Available: {{supplyItems.at(i).get('available')?.value}}\n                          </span>\n                        </ion-label>\n                        <ion-input formControlName=\"total_quantity\" type=\"number\" min=\"0\"\n                          placeholder=\"Enter total quantity\"\n                          [disabled]=\"!supplyItems.at(i).get('supply_item_id')?.value\"\n                          (ionInput)=\"validateQuantity($event, i)\"></ion-input>\n                        <ion-note slot=\"error\"\n                          *ngIf=\"supplyItems.at(i).get('total_quantity')?.invalid && supplyItems.at(i).get('total_quantity')?.touched\">\n                          <span *ngIf=\"!supplyItems.at(i).get('supply_item_id')?.value\">Please select a supply item first</span>\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['required']\">Enter total quantity</span>\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['quantityExceedsAvailable']\">Quantity exceeds available stock</span>\n                        </ion-note>\n                        <ion-note slot=\"helper\" *ngIf=\"!supplyItems.at(i).get('supply_item_id')?.value\" color=\"medium\">\n                          Select supply item first. Lots will be automatically allocated using FIFO.\n                        </ion-note>\n                        <ion-note slot=\"helper\" *ngIf=\"supplyItems.at(i).get('supply_item_id')?.value && getLotAllocation(i).length === 0\" color=\"primary\">\n                          Lot numbers will be automatically selected based on earliest expiry date (FIFO).\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n                  </ion-row>\n\n                  <!-- Second row for Manual Mode -->\n                  <ion-row *ngIf=\"!isFifoMode()\">\n                    <!-- Expire Date for Manual Mode -->\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                        <ion-label position=\"stacked\">Expire Date *</ion-label>\n                        <ion-input formControlName=\"expire_date\" readonly\n                          placeholder=\"Auto-filled from lot selection\"></ion-input>\n                        <ion-note slot=\"error\"\n                          *ngIf=\"supplyItems.at(i).get('expire_date')?.invalid && supplyItems.at(i).get('expire_date')?.touched\">\n                          Expire date will be auto-filled from lot selection\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n\n                    <!-- Total Quantity for Manual Mode -->\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"calculator-outline\" color=\"warning\"></ion-icon>\n                        <ion-label position=\"stacked\">\n                          Total Quantity *\n                          <span *ngIf=\"getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value)\"\n                            class=\"unit-label\">\n                            ({{ getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value) }})\n                          </span>\n                          <span *ngIf=\"supplyItems.at(i).get('available')?.value > 0\" class=\"available-label\">\n                            - Available: {{supplyItems.at(i).get('available')?.value}}\n                          </span>\n                        </ion-label>\n                        <ion-input formControlName=\"total_quantity\" type=\"number\" min=\"0\"\n                          placeholder=\"Enter total quantity\"\n                          [disabled]=\"!supplyItems.at(i).get('lot_no')?.value\"\n                          (ionInput)=\"validateQuantity($event, i)\"></ion-input>\n                        <ion-note slot=\"error\"\n                          *ngIf=\"supplyItems.at(i).get('total_quantity')?.invalid && supplyItems.at(i).get('total_quantity')?.touched\">\n                          <span *ngIf=\"!supplyItems.at(i).get('lot_no')?.value\">Please select a lot number first</span>\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['required']\">Enter total quantity</span>\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['quantityExceedsAvailable']\">Quantity exceeds available stock</span>\n                        </ion-note>\n                        <ion-note slot=\"helper\" *ngIf=\"!supplyItems.at(i).get('lot_no')?.value\" color=\"medium\">\n                          Select lot number to enable quantity input\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n                  </ion-row>\n\n                  <!-- Auto-allocated Lots Display with Available Info (FIFO Mode Only) -->\n                  <ion-row *ngIf=\"isFifoMode() && supplyItems.at(i).get('supply_item_id')?.value && getLotList(i).length > 0\">\n                    <ion-col size=\"12\">\n                      <div class=\"lot-allocation-info\">\n                        <ion-label class=\"lot-allocation-label\">\n                          <ion-icon name=\"layers-outline\" [color]=\"getLotAllocation(i).length > 0 ? 'success' : 'primary'\"></ion-icon>\n                          Auto-allocated lots (FIFO):\n                        </ion-label>\n                        <div class=\"lot-allocation-list\">\n                          <div *ngFor=\"let lot of getLotList(i)\" class=\"lot-allocation-item\">\n                            <ion-chip\n                              [color]=\"getLotAllocatedQty(i, lot.lot_no) > 0 ? 'success' : 'primary'\"\n                              outline=\"true\">\n                              <ion-icon [name]=\"getLotAllocatedQty(i, lot.lot_no) > 0 ? 'checkmark-circle-outline' : 'pricetag-outline'\"></ion-icon>\n                              <ion-label>\n                                <strong>Lot:</strong> {{lot.lot_no}} |\n                                <strong>Available:</strong> {{getAvailableQuantity(lot)}}\n                                <span *ngIf=\"getLotAllocatedQty(i, lot.lot_no) > 0\" class=\"allocated-text\">\n                                  | <strong>Allocated:</strong> {{getLotAllocatedQty(i, lot.lot_no)}}\n                                </span>\n                                | <strong>Expires:</strong> {{formatDate(lot.expire_date)}}\n                              </ion-label>\n                            </ion-chip>\n                          </div>\n                        </div>\n                      </div>\n                    </ion-col>\n                  </ion-row>\n                </ion-grid>\n              </div>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button fill=\"outline\" color=\"primary\" (click)=\"addNewSupply()\" type=\"button\" class=\"add-item-btn\">\n                <ion-icon name=\"add\" slot=\"start\"></ion-icon>\n                Add Supply Item\n              </ion-button>\n\n              <ion-button type=\"submit\" color=\"warning\" class=\"submit-btn\">\n                <ion-icon name=\"{{isEditMode ? 'save-outline' : 'send-outline'}}\" slot=\"start\"></ion-icon>\n                {{isEditMode ? 'Update Supply' : 'Process Supply Out'}}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"supply-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading supply data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n\n\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_supply-out_supply-out_module_ts.js.map