(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_supply-in_supply-in_module_ts"],{

/***/ 76159:
/*!*************************************************************!*\
  !*** ./src/app/pages/supply-in/supply-in-routing.module.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyInPageRoutingModule: () => (/* binding */ SupplyInPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _supply_in_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supply-in.page */ 67633);




const routes = [{
  path: '',
  component: _supply_in_page__WEBPACK_IMPORTED_MODULE_0__.SupplyInPage
}];
let SupplyInPageRoutingModule = class SupplyInPageRoutingModule {};
SupplyInPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SupplyInPageRoutingModule);


/***/ }),

/***/ 91214:
/*!*****************************************************!*\
  !*** ./src/app/pages/supply-in/supply-in.module.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyInPageModule: () => (/* binding */ SupplyInPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _supply_in_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-in-routing.module */ 76159);
/* harmony import */ var _supply_in_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-in.page */ 67633);








let SupplyInPageModule = class SupplyInPageModule {};
SupplyInPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _supply_in_routing_module__WEBPACK_IMPORTED_MODULE_1__.SupplyInPageRoutingModule],
  declarations: [_supply_in_page__WEBPACK_IMPORTED_MODULE_2__.SupplyInPage]
})], SupplyInPageModule);


/***/ }),

/***/ 67633:
/*!***************************************************!*\
  !*** ./src/app/pages/supply-in/supply-in.page.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SupplyInPage: () => (/* binding */ SupplyInPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _supply_in_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./supply-in.page.html?ngResource */ 30035);
/* harmony import */ var _supply_in_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./supply-in.page.scss?ngResource */ 90559);
/* harmony import */ var _supply_in_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_supply_in_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/supply_api.service */ 78982);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);

var _SupplyInPage;




/* eslint-disable @typescript-eslint/member-ordering */
/* eslint-disable @typescript-eslint/naming-convention */






let SupplyInPage = (_SupplyInPage = class SupplyInPage {
  constructor(route, router, fb, b, change, api) {
    this.route = route;
    this.router = router;
    this.fb = fb;
    this.b = b;
    this.change = change;
    this.api = api;
    this.isEditMode = false;
    this.isDailyReturnMode = false;
    this.transactionDefTypes = ['dp_to_inf', 'wh_to_inf', 'inf_to_inf'];
    this.lotLists = {};
    // Provider search properties
    this.filteredProviders = [];
    this.providerSearchTerm = '';
    this.showFilteredOptions = false;
  }
  ngOnInit() {
    this.id = this.route.snapshot.paramMap.get('id');
    this.isEditMode = !!this.id;
    // Check for daily-return mode
    this.route.queryParams.subscribe(params => {
      this.isDailyReturnMode = params['mode'] === 'daily-return';
      if (this.isDailyReturnMode) {
        this.title = 'Daily Return';
        this.transactionDefTypes = ['dp_to_inf'];
      } else {
        this.title = this.isEditMode ? 'Edit Supply In' : 'Add Stock';
        this.transactionDefTypes = ['wh_to_inf', 'inf_to_inf'];
      }
    });
    this.setupForm();
    this.load();
  }
  ngAfterViewInit() {
    // Initialize provider search when component loads
    setTimeout(() => {
      this.initializeProviderSearch();
    }, 100);
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this.isEditMode) {
          _this.supplyEditPreqData = (yield _this.api.getSupplyItemEditPreq(+_this.id)).data;
          _this.patchForm();
        } else {
          var _yield$_this$api$crea;
          _this.supplyRequestPreq = (_yield$_this$api$crea = yield _this.api.createPreq()) === null || _yield$_this$api$crea === void 0 ? void 0 : _yield$_this$api$crea.data;
          // Add first supply item by default for new entries
          _this.addNewSupply();
        }
        // Initialize provider search after data is loaded
        setTimeout(() => {
          _this.initializeProviderSearch();
        }, 100);
        _this.change.markForCheck();
      } catch (error) {
        _this.b.errorToast('Error loading supply data');
      }
    })();
  }
  setupForm() {
    this.supplyRequestForm = this.fb.group({
      transaction_date: [new Date().toISOString().split('T')[0], [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, this.futureDateValidator()]],
      supply_items: this.fb.array([], [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]),
      transaction_type: ['In'],
      transaction_def: ['dp_to_inf', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      provider: [''],
      waybill: [''],
      notes: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]],
      inf: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator]]
    });
  }
  get supplyItems() {
    return this.supplyRequestForm.get('supply_items');
  }
  addSupplyItem(supply_item_id, total_quantity, available, lot_no, expire_date) {
    available = available !== null && available !== void 0 ? available : 0;
    const group = this.fb.group({
      supply_item_id: [supply_item_id, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      total_quantity: [total_quantity || 0, [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberPattern), _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.min(1), this.quantityValidator()]],
      lot_no: [lot_no || '', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, this.duplicateLotValidator.bind(this)]],
      expire_date: [expire_date || '', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      available: [available]
    });
    return group;
  }
  getTotal(i) {
    const total = +this.supplyItems.at(i).get('total_quantity').value || 0;
    return isNaN(total) ? 0 : total;
  }
  addNewSupply(supply_item_id, total_quantity, available, lot_no, expire_date) {
    const formGroup = this.addSupplyItem(supply_item_id, total_quantity, available, lot_no, expire_date);
    this.supplyItems.push(formGroup);
  }
  submitForm(supplyRequestForm) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Check for duplicate lot numbers before submission
      const hasDuplicates = _this2.supplyItems.controls.some((_, index) => _this2.isDuplicateLotNumber(index));
      if (hasDuplicates) {
        _this2.b.errorToast('Cannot submit: Duplicate lot numbers found for the same supply item');
        return;
      }
      if (supplyRequestForm.valid) {
        const formObj = supplyRequestForm.getRawValue();
        // Transform form data to match PHP controller expectations
        const submitData = {
          transaction_date: formObj.transaction_date,
          transaction_type: formObj.transaction_type,
          transaction_def: formObj.transaction_def,
          provider: formObj.provider,
          waybill: formObj.waybill,
          notes: formObj.notes || '',
          inf: formObj.inf || '',
          supply_item_id: formObj.supply_items.map(item => item.supply_item_id),
          total_quantity: formObj.supply_items.map(item => item.total_quantity),
          expire_date: formObj.supply_items.map(item => item.expire_date),
          lot_no: formObj.supply_items.map(item => item.lot_no)
        };
        try {
          let response;
          if (_this2.isEditMode) {
            response = yield _this2.api.editSupply(submitData, _this2.id);
            _this2.b.toast(response.message || 'Supply transaction updated successfully');
          } else {
            response = yield _this2.api.storeSupply(submitData);
            _this2.b.toast(response.message || 'Supply transaction created successfully');
          }
          _this2.router.navigate(['/manage-supplylist', 'in']);
        } catch (error) {
          const action = _this2.isEditMode ? 'updating' : 'creating';
          _this2.b.errorToast(`Error ${action} supply transaction`);
        }
      } else {
        _this2.b.errorToast('Please fill out all required fields correctly');
        _this2.markFormGroupTouched(supplyRequestForm);
      }
    })();
  }
  onSelectSupplyItem(event, index) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _this3$supplyRequestF;
      const supplyItemId = event.detail.value;
      const available = _this3.getQuantityInStoreOfProgram(supplyItemId);
      _this3.supplyItems.at(index).get('available').setValue(available !== null && available !== void 0 ? available : 0);
      // Reset lot-related fields when supply item changes
      _this3.supplyItems.at(index).get('lot_no').setValue('');
      _this3.supplyItems.at(index).get('expire_date').setValue('');
      // Load lot list for this supply item when transaction_def is dp_to_inf
      const transactionDef = (_this3$supplyRequestF = _this3.supplyRequestForm.get('transaction_def')) === null || _this3$supplyRequestF === void 0 ? void 0 : _this3$supplyRequestF.value;
      if (supplyItemId && transactionDef === 'dp_to_inf') {
        try {
          const lotResponse = yield _this3.api.getLotList(supplyItemId);
          _this3.lotLists[index] = lotResponse.data || [];
        } catch (error) {
          _this3.lotLists[index] = [];
          _this3.b.errorToast('Error loading lot numbers');
        }
      } else {
        _this3.lotLists[index] = [];
      }
      // Trigger validation for all lot_no fields to check for duplicates
      _this3.supplyItems.controls.forEach((control, i) => {
        var _control$get;
        (_control$get = control.get('lot_no')) === null || _control$get === void 0 || _control$get.updateValueAndValidity();
      });
      _this3.change.markForCheck();
    })();
  }
  onSelectLot(event, index) {
    const selectedLotNo = event.detail.value;
    const lotList = this.lotLists[index] || [];
    const selectedLot = lotList.find(lot => lot.lot_no === selectedLotNo);
    if (selectedLot) {
      var _this$supplyRequestFo;
      // Auto-populate expire_date from selected lot
      const formattedExpireDate = selectedLot.expire_date ? new Date(selectedLot.expire_date).toISOString().split('T')[0] : '';
      this.supplyItems.at(index).get('expire_date').setValue(formattedExpireDate);
      // Set available quantity from lot data for dp_to_inf
      const transactionDef = (_this$supplyRequestFo = this.supplyRequestForm.get('transaction_def')) === null || _this$supplyRequestFo === void 0 ? void 0 : _this$supplyRequestFo.value;
      if (transactionDef === 'dp_to_inf') {
        const availableQty = this.getAvailableQuantity(selectedLot);
        this.supplyItems.at(index).get('available').setValue(availableQty);
      }
    } else {
      // Clear expire_date if no lot selected
      this.supplyItems.at(index).get('expire_date').setValue('');
    }
    // Trigger validation for all lot_no fields to check for duplicates
    this.supplyItems.controls.forEach((control, i) => {
      var _control$get2;
      (_control$get2 = control.get('lot_no')) === null || _control$get2 === void 0 || _control$get2.updateValueAndValidity();
    });
    this.change.markForCheck();
  }
  onLotNumberChange(index) {
    // Trigger validation for all lot_no fields to check for duplicates
    this.supplyItems.controls.forEach((control, i) => {
      var _control$get3;
      (_control$get3 = control.get('lot_no')) === null || _control$get3 === void 0 || _control$get3.updateValueAndValidity();
    });
    this.change.markForCheck();
  }
  removeSupply(index) {
    if (this.supplyItems.length > 1) {
      this.supplyItems.removeAt(index);
      this.change.markForCheck();
    } else {
      this.b.toast('At least one supply item is required');
    }
  }
  getQuantityInStoreOfProgram(supplyItemId) {
    var _this$supplyEditPreqD, _this$supplyRequestPr, _inStore$find;
    const inStore = this.isEditMode ? (_this$supplyEditPreqD = this.supplyEditPreqData) === null || _this$supplyEditPreqD === void 0 ? void 0 : _this$supplyEditPreqD.in_store : (_this$supplyRequestPr = this.supplyRequestPreq) === null || _this$supplyRequestPr === void 0 ? void 0 : _this$supplyRequestPr.in_store;
    return inStore === null || inStore === void 0 || (_inStore$find = inStore.find(p => p.id === supplyItemId)) === null || _inStore$find === void 0 ? void 0 : _inStore$find.qty_in_store;
  }
  getAllSupplyItems() {
    var _this$supplyEditPreqD2, _this$supplyRequestPr2;
    const supplyList = (this.isEditMode ? (_this$supplyEditPreqD2 = this.supplyEditPreqData) === null || _this$supplyEditPreqD2 === void 0 ? void 0 : _this$supplyEditPreqD2.supply_list : (_this$supplyRequestPr2 = this.supplyRequestPreq) === null || _this$supplyRequestPr2 === void 0 ? void 0 : _this$supplyRequestPr2.supply_list) || [];
    // For supply-in, always show all items regardless of availability
    return supplyList;
  }
  getLotList(index) {
    return this.lotLists[index] || [];
  }
  isLotDropdownMode() {
    var _this$supplyRequestFo2;
    return ((_this$supplyRequestFo2 = this.supplyRequestForm.get('transaction_def')) === null || _this$supplyRequestFo2 === void 0 ? void 0 : _this$supplyRequestFo2.value) === 'dp_to_inf';
  }
  getAvailableQuantity(lot) {
    return lot.provisioned_amount_in_dp;
  }
  validateQuantity(event, index) {
    var _this$supplyItems$at$;
    const quantity = parseInt(event.detail.value) || 0;
    const available = ((_this$supplyItems$at$ = this.supplyItems.at(index).get('available')) === null || _this$supplyItems$at$ === void 0 ? void 0 : _this$supplyItems$at$.value) || 0;
    const quantityControl = this.supplyItems.at(index).get('total_quantity');
    if (quantity > available) {
      quantityControl.setErrors({
        quantityExceedsAvailable: true
      });
    } else {
      // Clear custom error but preserve other validation errors
      const errors = quantityControl.errors;
      if (errors !== null && errors !== void 0 && errors.quantityExceedsAvailable) {
        delete errors.quantityExceedsAvailable;
        quantityControl.setErrors(Object.keys(errors).length ? errors : null);
      }
    }
    this.change.markForCheck();
  }
  quantityValidator() {
    return control => {
      var _control$parent$get, _this$supplyRequestFo3;
      if (!control.parent) return null;
      const quantity = parseInt(control.value) || 0;
      const available = ((_control$parent$get = control.parent.get('available')) === null || _control$parent$get === void 0 ? void 0 : _control$parent$get.value) || 0;
      // Only validate against available quantity for dp_to_inf
      const transactionDef = (_this$supplyRequestFo3 = this.supplyRequestForm) === null || _this$supplyRequestFo3 === void 0 || (_this$supplyRequestFo3 = _this$supplyRequestFo3.get('transaction_def')) === null || _this$supplyRequestFo3 === void 0 ? void 0 : _this$supplyRequestFo3.value;
      if (transactionDef === 'dp_to_inf') {
        return quantity > available ? {
          quantityExceedsAvailable: true
        } : null;
      }
      return null;
    };
  }
  isDuplicateLotNumber(currentIndex) {
    var _currentControl$get, _currentControl$get2;
    if (!this.supplyItems || currentIndex >= this.supplyItems.length) return false;
    const currentControl = this.supplyItems.at(currentIndex);
    if (!currentControl) return false;
    const currentLotNo = (_currentControl$get = currentControl.get('lot_no')) === null || _currentControl$get === void 0 ? void 0 : _currentControl$get.value;
    const currentSupplyItemId = (_currentControl$get2 = currentControl.get('supply_item_id')) === null || _currentControl$get2 === void 0 ? void 0 : _currentControl$get2.value;
    if (!currentLotNo || !currentSupplyItemId) return false;
    const duplicateFound = this.supplyItems.controls.some((control, index) => {
      var _control$get4, _control$get5;
      if (index === currentIndex) return false;
      const lotNo = (_control$get4 = control.get('lot_no')) === null || _control$get4 === void 0 ? void 0 : _control$get4.value;
      const supplyItemId = (_control$get5 = control.get('supply_item_id')) === null || _control$get5 === void 0 ? void 0 : _control$get5.value;
      return lotNo === currentLotNo && supplyItemId === currentSupplyItemId;
    });
    return duplicateFound;
  }
  patchForm() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _this4$supplyEditPreq;
      if ((_this4$supplyEditPreq = _this4.supplyEditPreqData) !== null && _this4$supplyEditPreq !== void 0 && _this4$supplyEditPreq.supply_prev) {
        var _this4$supplyEditPreq3;
        // Clear existing supply items first
        while (_this4.supplyItems.length > 0) {
          _this4.supplyItems.removeAt(0);
        }
        // Format date properly for date input
        const formattedDate = _this4.supplyEditPreqData.supply_prev.transaction_date ? new Date(_this4.supplyEditPreqData.supply_prev.transaction_date).toISOString().split('T')[0] : '';
        const waybill = _this4.supplyEditPreqData.supply_prev.waybill || _this4.supplyEditPreqData.supply_prev.ref || '';
        // Determine transaction_def and provider based on edit data
        let transactionDef = _this4.supplyEditPreqData.supply_prev.transaction_def || 'wh_to_inf';
        let providerId = _this4.supplyEditPreqData.supply_prev.provider;
        // If transaction_def is not set in the data, try to infer it
        if (!_this4.supplyEditPreqData.supply_prev.transaction_def) {
          var _this4$supplyEditPreq2;
          // Check if provider ID exists in INFs list - if so, it's inf_to_inf
          const infExists = (_this4$supplyEditPreq2 = _this4.supplyEditPreqData.infs) === null || _this4$supplyEditPreq2 === void 0 ? void 0 : _this4$supplyEditPreq2.some(inf => inf.id === providerId);
          if (infExists) {
            transactionDef = 'inf_to_inf';
          }
        }
        _this4.supplyRequestForm.patchValue({
          transaction_date: formattedDate,
          transaction_type: 'In',
          transaction_def: transactionDef,
          provider: providerId,
          waybill: waybill,
          notes: ((_this4$supplyEditPreq3 = _this4.supplyEditPreqData.supply_prev) === null || _this4$supplyEditPreq3 === void 0 ? void 0 : _this4$supplyEditPreq3.notes) || ''
        });
        // Initialize provider search for edit mode
        setTimeout(() => {
          if (transactionDef !== 'dp_to_inf') {
            _this4.initializeProviderSearch();
          }
        }, 200);
        // Add supply items from edit data
        if (_this4.supplyEditPreqData.supply_prev.supply_item && _this4.supplyEditPreqData.supply_prev.supply_item.length > 0) {
          for (let index = 0; index < _this4.supplyEditPreqData.supply_prev.supply_item.length; index++) {
            const item = _this4.supplyEditPreqData.supply_prev.supply_item[index];
            // Format expire date properly
            const formattedExpireDate = item.expire_date ? new Date(item.expire_date).toISOString().split('T')[0] : '';
            _this4.addNewSupply(item.supply_item_id, item.total_quantity, _this4.getQuantityInStoreOfProgram(item.supply_item_id), item.lot_no, formattedExpireDate);
            // Load lot list for this supply item if transaction_def is dp_to_inf
            if (item.supply_item_id && transactionDef === 'dp_to_inf') {
              try {
                const lotResponse = yield _this4.api.getLotList(item.supply_item_id);
                _this4.lotLists[index] = lotResponse.data || [];
              } catch (error) {
                _this4.lotLists[index] = [];
              }
            }
          }
        } else {
          // Add at least one empty supply item if none exist
          _this4.addNewSupply();
        }
        // Update form validation after patching
        _this4.supplyRequestForm.updateValueAndValidity();
        _this4.supplyItems.controls.forEach(control => {
          if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
            control.updateValueAndValidity();
            Object.keys(control.controls).forEach(key => {
              var _control$get6;
              (_control$get6 = control.get(key)) === null || _control$get6 === void 0 || _control$get6.updateValueAndValidity();
            });
          }
        });
        // Force change detection
        _this4.change.markForCheck();
        // Re-validate form after a brief delay to ensure all async operations complete
        setTimeout(() => {
          _this4.supplyRequestForm.updateValueAndValidity();
          _this4.supplyItems.controls.forEach(control => {
            if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
              control.updateValueAndValidity();
              Object.keys(control.controls).forEach(key => {
                var _control$get7;
                (_control$get7 = control.get(key)) === null || _control$get7 === void 0 || _control$get7.updateValueAndValidity();
              });
            }
          });
          _this4.change.markForCheck();
        }, 100);
        // Debug form validation state
        _this4.supplyItems.controls.forEach((control, index) => {
          if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup && control.invalid) {
            Object.keys(control.controls).forEach(key => {
              const fieldControl = control.get(key);
              if (fieldControl !== null && fieldControl !== void 0 && fieldControl.invalid) {}
            });
          }
        });
      } else {}
    })();
  }
  onTransactionDefChange(event) {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const transactionDef = event.detail.value;
      const providerControl = _this5.supplyRequestForm.get('provider');
      const waybillControl = _this5.supplyRequestForm.get('waybill');
      // Reset provider and waybill when transaction_def changes
      providerControl === null || providerControl === void 0 || providerControl.setValue('');
      waybillControl === null || waybillControl === void 0 || waybillControl.setValue('');
      // Reset provider search
      _this5.resetProviderSearch();
      // Initialize provider search for non dp_to_inf
      if (transactionDef !== 'dp_to_inf') {
        setTimeout(() => {
          _this5.initializeProviderSearch();
        }, 100);
      }
      // Update validation based on transaction_def
      if (transactionDef === 'dp_to_inf') {
        providerControl === null || providerControl === void 0 || providerControl.clearValidators();
        waybillControl === null || waybillControl === void 0 || waybillControl.clearValidators();
      } else {
        providerControl === null || providerControl === void 0 || providerControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]);
        waybillControl === null || waybillControl === void 0 || waybillControl.setValidators([_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]);
      }
      providerControl === null || providerControl === void 0 || providerControl.updateValueAndValidity();
      waybillControl === null || waybillControl === void 0 || waybillControl.updateValueAndValidity();
      // Reset and reload lot lists for all supply items when transaction_def changes
      for (let i = 0; i < _this5.supplyItems.length; i++) {
        var _this5$supplyItems$at;
        const supplyItemId = (_this5$supplyItems$at = _this5.supplyItems.at(i).get('supply_item_id')) === null || _this5$supplyItems$at === void 0 ? void 0 : _this5$supplyItems$at.value;
        _this5.supplyItems.at(i).get('lot_no').setValue('');
        _this5.supplyItems.at(i).get('expire_date').setValue('');
        if (supplyItemId && transactionDef === 'dp_to_inf') {
          try {
            const lotResponse = yield _this5.api.getLotList(supplyItemId);
            _this5.lotLists[i] = lotResponse.data || [];
          } catch (error) {
            _this5.lotLists[i] = [];
          }
        } else {
          _this5.lotLists[i] = [];
        }
      }
      _this5.change.markForCheck();
    })();
  }
  getProviderList() {
    var _this$supplyRequestFo4;
    const transactionDef = (_this$supplyRequestFo4 = this.supplyRequestForm.get('transaction_def')) === null || _this$supplyRequestFo4 === void 0 ? void 0 : _this$supplyRequestFo4.value;
    const data = this.isEditMode ? this.supplyEditPreqData : this.supplyRequestPreq;
    if (transactionDef === 'inf_to_inf') {
      return (data === null || data === void 0 ? void 0 : data.infs) || [];
    } else {
      return (data === null || data === void 0 ? void 0 : data.pps) || [];
    }
  }
  getSupplyItemUnit(supplyItemId) {
    var _this$supplyEditPreqD3, _this$supplyRequestPr3, _supplyItem$unit;
    if (!supplyItemId) return '';
    const supplyList = this.isEditMode ? (_this$supplyEditPreqD3 = this.supplyEditPreqData) === null || _this$supplyEditPreqD3 === void 0 ? void 0 : _this$supplyEditPreqD3.supply_list : (_this$supplyRequestPr3 = this.supplyRequestPreq) === null || _this$supplyRequestPr3 === void 0 ? void 0 : _this$supplyRequestPr3.supply_list;
    const supplyItem = supplyList === null || supplyList === void 0 ? void 0 : supplyList.find(item => item.id === supplyItemId);
    return (supplyItem === null || supplyItem === void 0 || (_supplyItem$unit = supplyItem.unit) === null || _supplyItem$unit === void 0 ? void 0 : _supplyItem$unit.title) || '';
  }
  duplicateLotValidator(control) {
    var _control$value, _control$parent$get2;
    if (!control.parent || !this.supplyItems || !this.supplyItems.controls) return null;
    const currentIndex = this.supplyItems.controls.indexOf(control.parent);
    if (currentIndex === -1) return null;
    const currentLotNo = (_control$value = control.value) === null || _control$value === void 0 ? void 0 : _control$value.trim();
    const currentSupplyItemId = (_control$parent$get2 = control.parent.get('supply_item_id')) === null || _control$parent$get2 === void 0 ? void 0 : _control$parent$get2.value;
    if (!currentLotNo || !currentSupplyItemId) return null;
    // Skip validation during form initialization in edit mode
    if (this.isEditMode && !control.touched) return null;
    const hasDuplicate = this.supplyItems.controls.some((formControl, index) => {
      var _formControl$get, _formControl$get2;
      if (index === currentIndex) return false;
      const lotNo = (_formControl$get = formControl.get('lot_no')) === null || _formControl$get === void 0 || (_formControl$get = _formControl$get.value) === null || _formControl$get === void 0 ? void 0 : _formControl$get.trim();
      const supplyItemId = (_formControl$get2 = formControl.get('supply_item_id')) === null || _formControl$get2 === void 0 ? void 0 : _formControl$get2.value;
      return lotNo === currentLotNo && supplyItemId === currentSupplyItemId;
    });
    return hasDuplicate ? {
      duplicateLot: true
    } : null;
  }
  getTodaysDate() {
    return new Date().toISOString().split('T')[0];
  }
  futureDateValidator() {
    return control => {
      if (!control.value) return null;
      const selectedDate = new Date(control.value);
      const today = new Date();
      // Reset time to start of day for accurate comparison
      selectedDate.setHours(0, 0, 0, 0);
      today.setHours(0, 0, 0, 0);
      return selectedDate > today ? {
        futureDate: true
      } : null;
    };
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
        this.markFormGroupTouched(control);
      } else if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormArray) {
        control.controls.forEach(ctrl => {
          if (ctrl instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
            this.markFormGroupTouched(ctrl);
          } else {
            ctrl.markAsTouched();
          }
        });
      } else {
        control === null || control === void 0 || control.markAsTouched();
      }
    });
  }
  // Provider search methods
  initializeProviderSearch() {
    const providers = this.getProviderList();
    this.filteredProviders = [...providers];
    this.updateSearchTermFromSelected();
    this.change.markForCheck();
  }
  filterProviders(event) {
    const searchTerm = event.target.value.toLowerCase().trim();
    this.providerSearchTerm = searchTerm;
    const allProviders = this.getProviderList();
    if (!searchTerm) {
      this.filteredProviders = [...allProviders];
    } else {
      this.filteredProviders = allProviders.filter(provider => provider.title.toLowerCase().includes(searchTerm));
    }
    this.showFilteredOptions = true;
    this.change.markForCheck();
  }
  selectProvider(provider) {
    var _this$supplyRequestFo5;
    (_this$supplyRequestFo5 = this.supplyRequestForm.get('provider')) === null || _this$supplyRequestFo5 === void 0 || _this$supplyRequestFo5.setValue(provider.id);
    this.providerSearchTerm = provider.title;
    this.showFilteredOptions = false;
    this.change.markForCheck();
  }
  updateSearchTermFromSelected() {
    var _this$supplyRequestFo6;
    const selectedProviderId = (_this$supplyRequestFo6 = this.supplyRequestForm.get('provider')) === null || _this$supplyRequestFo6 === void 0 ? void 0 : _this$supplyRequestFo6.value;
    if (selectedProviderId) {
      const providers = this.getProviderList();
      const selectedProvider = providers.find(p => p.id === selectedProviderId);
      if (selectedProvider) {
        this.providerSearchTerm = selectedProvider.title;
      }
    } else {
      this.providerSearchTerm = '';
    }
  }
  resetProviderSearch() {
    this.filteredProviders = [];
    this.providerSearchTerm = '';
    this.showFilteredOptions = false;
  }
  onSearchFocus() {
    this.initializeProviderSearch();
    this.showFilteredOptions = true;
    this.change.markForCheck();
  }
  trackByProviderId(index, provider) {
    return provider.id;
  }
  onSearchBlur() {
    // Delay hiding the options to allow for click events
    setTimeout(() => {
      this.showFilteredOptions = false;
      this.change.markForCheck();
    }, 200);
  }
}, _SupplyInPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.Router
}, {
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ChangeDetectorRef
}, {
  type: src_app_services_supply_api_service__WEBPACK_IMPORTED_MODULE_3__.SupplyAPIService
}], _SupplyInPage);
SupplyInPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-supply-in',
  template: _supply_in_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ChangeDetectionStrategy.OnPush,
  styles: [(_supply_in_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SupplyInPage);


/***/ }),

/***/ 90559:
/*!****************************************************************!*\
  !*** ./src/app/pages/supply-in/supply-in.page.scss?ngResource ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-warning: #ffc409;
  --ion-color-warning-rgb: 255, 196, 9;
  --ion-color-warning-contrast: #000000;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

.supply-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.supply-form .form-section {
  margin-bottom: 32px;
}
.supply-form .form-section:last-child {
  margin-bottom: 0;
}
.supply-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.supply-form .section-subtitle ion-icon {
  font-size: 20px;
}
.supply-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.supply-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.supply-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.supply-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.supply-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.supply-form .form-item ion-note[color=warning] {
  color: var(--ion-color-warning);
  font-weight: 500;
}

.supply-item-card {
  border: 1px solid rgba(45, 211, 111, 0.2);
  border-radius: 12px;
  margin-bottom: 20px;
  padding: 16px;
  background: rgba(45, 211, 111, 0.05);
  position: relative;
}
.supply-item-card .supply-item-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 16px;
  padding-bottom: 12px;
  border-bottom: 1px solid rgba(45, 211, 111, 0.2);
}
.supply-item-card .supply-item-header .item-number {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-success);
  background: rgba(45, 211, 111, 0.15);
  padding: 4px 8px;
  border-radius: 8px;
}
.supply-item-card .supply-item-header .remove-btn {
  --padding-start: 8px;
  --padding-end: 8px;
  --padding-top: 4px;
  --padding-bottom: 4px;
  height: 32px;
}
.supply-item-card .form-item {
  margin-bottom: 12px;
  background: white;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.06);
}
.supply-item-card .form-item:last-child {
  margin-bottom: 0;
}
.supply-item-card .total-input {
  font-weight: 600;
  color: var(--ion-color-success);
}
.supply-item-card .total-input ion-input {
  --color: var(--ion-color-success);
  --placeholder-color: rgba(45, 211, 111, 0.5);
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .add-item-btn {
  min-width: 140px;
}
.form-actions .add-item-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}
.form-actions .submit-btn {
  min-width: 160px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

@media (min-width: 768px) {
  .supply-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .supply-item-card {
    padding: 20px;
  }
  .supply-item-card .supply-item-header {
    margin-bottom: 20px;
  }
  .supply-item-card .supply-item-header .item-number {
    font-size: 16px;
    padding: 6px 12px;
  }
  .supply-item-card .supply-item-header .remove-btn {
    height: 36px;
  }
  .supply-item-card .form-item {
    margin-bottom: 16px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .add-item-btn {
    min-width: 160px;
  }
  .form-actions .submit-btn {
    min-width: 180px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 16px;
  }
  .section-title ion-icon {
    font-size: 20px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .supply-item-card {
    padding: 12px;
    margin-bottom: 16px;
  }
  .supply-item-card .supply-item-header {
    margin-bottom: 12px;
  }
  .supply-item-card .supply-item-header .item-number {
    font-size: 12px;
    padding: 3px 6px;
  }
  .supply-item-card .supply-item-header .remove-btn {
    height: 28px;
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .supply-item-card .form-item {
    margin-bottom: 8px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .add-item-btn,
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
}
@media (prefers-color-scheme: dark) {
  .supply-item-card {
    background: rgba(45, 211, 111, 0.08);
    border-color: rgba(45, 211, 111, 0.3);
  }
  .supply-item-card .supply-item-header {
    border-bottom-color: rgba(45, 211, 111, 0.3);
  }
  .supply-item-card .form-item {
    background: var(--ion-color-step-50);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
}
ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-medium);
  font-weight: 500;
  cursor: pointer;
}

ion-select {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-grid {
  padding: 0;
}
ion-grid ion-row {
  margin: 0;
}
ion-grid ion-col {
  padding: 4px;
}

.supply-container app-skeleton {
  margin: 20px 0;
}

.form-section:has(.total-input) .section-subtitle {
  color: var(--ion-color-success);
  border-bottom-color: rgba(45, 211, 111, 0.3);
}
.form-section:has(.total-input) .section-subtitle ion-icon {
  color: var(--ion-color-success);
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-success), transparent);
  border-radius: 1px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.total-input ion-input {
  background: rgba(45, 211, 111, 0.1);
  border-radius: 4px;
  font-weight: 600;
}

.unit-label {
  color: var(--ion-color-primary);
  font-weight: 500;
  font-size: 0.9em;
}

.provider-search-container {
  margin-bottom: 16px;
  padding: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.provider-search-container .provider-label {
  font-weight: 500;
  color: var(--ion-color-dark);
  font-size: 14px;
  margin-bottom: 8px;
  display: block;
}
.provider-search-container .provider-search-wrapper {
  position: relative;
  width: 100%;
}
.provider-search-container .provider-search-wrapper .provider-searchbar {
  --background: white;
  --border-radius: 4px;
  --box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  --padding-start: 12px;
  --padding-end: 12px;
  margin: 0;
}
.provider-search-container .provider-search-wrapper .provider-searchbar ion-searchbar {
  --placeholder-color: var(--ion-color-medium);
  --color: var(--ion-color-dark);
  --icon-color: var(--ion-color-medium);
}
.provider-search-container .provider-search-wrapper .provider-options-list {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  z-index: 1000;
  max-height: 240px;
  overflow-y: auto;
  background: white;
  border: 1px solid rgba(0, 0, 0, 0.1);
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
  margin-top: 4px;
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item {
  --min-height: 48px;
  --padding-start: 16px;
  --padding-end: 16px;
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item:last-child {
  border-bottom: none;
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item:hover, .provider-search-container .provider-search-wrapper .provider-options-list ion-item.selected {
  --background: rgba(45, 211, 111, 0.1);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item ion-label {
  font-size: 14px;
  font-weight: 400;
  color: var(--ion-color-dark);
}
.provider-search-container .provider-search-wrapper .provider-options-list ion-item ion-icon[name=checkmark] {
  font-size: 18px;
}
.provider-search-container .provider-search-wrapper .no-results {
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
  z-index: 1000;
  background: white;
  border: 1px solid rgba(0, 0, 0, 0.1);
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
  margin-top: 4px;
  padding: 24px;
  text-align: center;
}
.provider-search-container .provider-search-wrapper .no-results p {
  color: var(--ion-color-medium);
  font-size: 14px;
  margin: 0;
}
.provider-search-container .error-note {
  font-size: 12px;
  color: var(--ion-color-danger);
  margin-top: 4px;
  display: block;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/supply-in/supply-in.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,4BAAA;EACA,oCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAAF;;AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAAF;;AAGA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAAF;;AAIA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AADF;;AAIA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AADF;AAGE;EACE,eAAA;AADJ;;AAOE;EACE,mBAAA;AAJJ;AAMI;EACE,gBAAA;AAJN;AAQE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AANJ;AAQI;EACE,eAAA;AANN;AAUE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AARJ;AAUI;EACE,gBAAA;EACA,4BAAA;AARN;AAWI;EACE,eAAA;EACA,eAAA;AATN;AAWM;EACE,8BAAA;AATR;AAYM;EACE,8BAAA;AAVR;AAaM;EACE,+BAAA;EACA,gBAAA;AAXR;;AAkBA;EACE,yCAAA;EACA,mBAAA;EACA,mBAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;AAfF;AAiBE;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;EACA,oBAAA;EACA,gDAAA;AAfJ;AAiBI;EACE,eAAA;EACA,gBAAA;EACA,+BAAA;EACA,oCAAA;EACA,gBAAA;EACA,kBAAA;AAfN;AAkBI;EACE,oBAAA;EACA,kBAAA;EACA,kBAAA;EACA,qBAAA;EACA,YAAA;AAhBN;AAoBE;EACE,mBAAA;EACA,iBAAA;EACA,kBAAA;EACA,qCAAA;AAlBJ;AAoBI;EACE,gBAAA;AAlBN;AAsBE;EACE,gBAAA;EACA,+BAAA;AApBJ;AAsBI;EACE,iCAAA;EACA,4CAAA;AApBN;;AA0BA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AAvBF;AAyBE;EACE,gBAAA;AAvBJ;AAyBI;EACE,YAAA;EACA,mBAAA;AAvBN;AA2BE;EACE,gBAAA;AAzBJ;AA2BI;EACE,YAAA;EACA,mBAAA;AAzBN;;AA+BA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA5BF;AA8BE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AA5BJ;AA+BE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AA7BJ;;AAkCA;EACE;IACE,gBAAA;EA/BF;EAkCA;IACE,gBAAA;EAhCF;EAmCA;IACE,eAAA;EAjCF;EAmCE;IACE,eAAA;EAjCJ;EAqCA;IACE,eAAA;EAnCF;EAqCE;IACE,eAAA;EAnCJ;EAuCA;IACE,aAAA;EArCF;EAuCE;IACE,mBAAA;EArCJ;EAuCI;IACE,eAAA;IACA,iBAAA;EArCN;EAwCI;IACE,YAAA;EAtCN;EA0CE;IACE,mBAAA;EAxCJ;EA4CA;IACE,gBAAA;EA1CF;EA4CE;IACE,gBAAA;EA1CJ;EA6CE;IACE,gBAAA;EA3CJ;EA+CA;IACE,kBAAA;EA7CF;EA+CE;IACE,WAAA;IACA,YAAA;EA7CJ;EAgDE;IACE,eAAA;EA9CJ;AACF;AAmDA;EACE;IACE,eAAA;EAjDF;EAmDE;IACE,eAAA;EAjDJ;EAqDA;IACE,eAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAuDA;IACE,aAAA;IACA,mBAAA;EArDF;EAuDE;IACE,mBAAA;EArDJ;EAuDI;IACE,eAAA;IACA,gBAAA;EArDN;EAwDI;IACE,YAAA;IACA,oBAAA;IACA,kBAAA;EAtDN;EA0DE;IACE,kBAAA;EAxDJ;EA4DA;IACE,sBAAA;IACA,gBAAA;EA1DF;EA4DE;;IAEE,WAAA;IACA,eAAA;EA1DJ;EA8DA;IACE,kBAAA;EA5DF;EA8DE;IACE,eAAA;EA5DJ;AACF;AAiEA;EACE;IACE,oCAAA;IACA,qCAAA;EA/DF;EAiEE;IACE,4CAAA;EA/DJ;EAkEE;IACE,oCAAA;IACA,uCAAA;EAhEJ;EAoEA;;IAEE,6BAAA;EAlEF;AACF;AAsEA;EACE,oBAAA;EACA,kBAAA;AApEF;AAsEE;EACE,gCAAA;EACA,gBAAA;EACA,eAAA;AApEJ;;AAwEA;EACE,oBAAA;EACA,kBAAA;AArEF;;AAyEA;EACE,UAAA;AAtEF;AAwEE;EACE,SAAA;AAtEJ;AAyEE;EACE,YAAA;AAvEJ;;AA4EA;EACE,cAAA;AAzEF;;AA8EE;EACE,+BAAA;EACA,4CAAA;AA3EJ;AA6EI;EACE,+BAAA;AA3EN;;AAiFA;EACE,kBAAA;AA9EF;AAgFE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AA9EJ;;AAmFA;EACE,qCAAA;AAhFF;AAkFE;EACE,8BAAA;AAhFJ;;AAoFA;EACE,sCAAA;AAjFF;;AAqFA;EACE,gBAAA;AAlFF;AAoFE;EACE,cAAA;EACA,oBAAA;AAlFJ;;AAuFA;EACE,mCAAA;EACA,kBAAA;EACA,gBAAA;AApFF;;AAwFA;EACE,+BAAA;EACA,gBAAA;EACA,gBAAA;AArFF;;AAyFA;EACE,mBAAA;EACA,aAAA;EACA,kBAAA;EACA,qCAAA;AAtFF;AAwFE;EACE,gBAAA;EACA,4BAAA;EACA,eAAA;EACA,kBAAA;EACA,cAAA;AAtFJ;AAyFE;EACE,kBAAA;EACA,WAAA;AAvFJ;AAyFI;EACE,mBAAA;EACA,oBAAA;EACA,0CAAA;EACA,qBAAA;EACA,mBAAA;EACA,SAAA;AAvFN;AAyFM;EACE,4CAAA;EACA,8BAAA;EACA,qCAAA;AAvFR;AA2FI;EACE,kBAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,aAAA;EACA,iBAAA;EACA,gBAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,0CAAA;EACA,eAAA;AAzFN;AA2FM;EACE,kBAAA;EACA,qBAAA;EACA,mBAAA;EACA,4CAAA;AAzFR;AA2FQ;EACE,mBAAA;AAzFV;AA4FQ;EACE,qCAAA;AA1FV;AA6FQ;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AA3FV;AA8FQ;EACE,eAAA;AA5FV;AAiGI;EACE,kBAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,aAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,0CAAA;EACA,eAAA;EACA,aAAA;EACA,kBAAA;AA/FN;AAiGM;EACE,8BAAA;EACA,eAAA;EACA,SAAA;AA/FR;AAoGE;EACE,eAAA;EACA,8BAAA;EACA,eAAA;EACA,cAAA;AAlGJ","sourcesContent":["// Supply add to store styles adapted from manage-supplylist\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-warning: #ffc409;\n  --ion-color-warning-rgb: 255, 196, 9;\n  --ion-color-warning-contrast: #000000;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n.supply-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  \n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.supply-form {\n  .form-section {\n    margin-bottom: 32px;\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n    \n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n    \n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n      \n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n      \n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n      \n      &[color=\"warning\"] {\n        color: var(--ion-color-warning);\n        font-weight: 500;\n      }\n    }\n  }\n}\n\n// Supply item cards with success theme for add operations\n.supply-item-card {\n  border: 1px solid rgba(45, 211, 111, 0.2);\n  border-radius: 12px;\n  margin-bottom: 20px;\n  padding: 16px;\n  background: rgba(45, 211, 111, 0.05);\n  position: relative;\n  \n  .supply-item-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin-bottom: 16px;\n    padding-bottom: 12px;\n    border-bottom: 1px solid rgba(45, 211, 111, 0.2);\n    \n    .item-number {\n      font-size: 14px;\n      font-weight: 600;\n      color: var(--ion-color-success);\n      background: rgba(45, 211, 111, 0.15);\n      padding: 4px 8px;\n      border-radius: 8px;\n    }\n    \n    .remove-btn {\n      --padding-start: 8px;\n      --padding-end: 8px;\n      --padding-top: 4px;\n      --padding-bottom: 4px;\n      height: 32px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 12px;\n    background: white;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.06);\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .total-input {\n    font-weight: 600;\n    color: var(--ion-color-success);\n    \n    ion-input {\n      --color: var(--ion-color-success);\n      --placeholder-color: rgba(45, 211, 111, 0.5);\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n  \n  .add-item-btn {\n    min-width: 140px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n  \n  .submit-btn {\n    min-width: 160px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n  \n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n  \n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .supply-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n  \n  .section-title {\n    font-size: 24px;\n    \n    ion-icon {\n      font-size: 28px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .supply-item-card {\n    padding: 20px;\n    \n    .supply-item-header {\n      margin-bottom: 20px;\n      \n      .item-number {\n        font-size: 16px;\n        padding: 6px 12px;\n      }\n      \n      .remove-btn {\n        height: 36px;\n      }\n    }\n    \n    .form-item {\n      margin-bottom: 16px;\n    }\n  }\n  \n  .form-actions {\n    margin-top: 32px;\n    \n    .add-item-btn {\n      min-width: 160px;\n    }\n    \n    .submit-btn {\n      min-width: 180px;\n    }\n  }\n  \n  .loading-container {\n    padding: 80px 40px;\n    \n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n    \n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 16px;\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 14px;\n    \n    ion-icon {\n      font-size: 18px;\n    }\n  }\n  \n  .supply-item-card {\n    padding: 12px;\n    margin-bottom: 16px;\n    \n    .supply-item-header {\n      margin-bottom: 12px;\n      \n      .item-number {\n        font-size: 12px;\n        padding: 3px 6px;\n      }\n      \n      .remove-btn {\n        height: 28px;\n        --padding-start: 4px;\n        --padding-end: 4px;\n      }\n    }\n    \n    .form-item {\n      margin-bottom: 8px;\n    }\n  }\n  \n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n    \n    .add-item-btn,\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n  \n  .loading-container {\n    padding: 40px 16px;\n    \n    p {\n      font-size: 12px;\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .supply-item-card {\n    background: rgba(45, 211, 111, 0.08);\n    border-color: rgba(45, 211, 111, 0.3);\n    \n    .supply-item-header {\n      border-bottom-color: rgba(45, 211, 111, 0.3);\n    }\n    \n    .form-item {\n      background: var(--ion-color-step-50);\n      border-color: rgba(255, 255, 255, 0.08);\n    }\n  }\n  \n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  \n  &[readonly] {\n    --color: var(--ion-color-medium);\n    font-weight: 500;\n    cursor: pointer;\n  }\n}\n\nion-select {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Grid spacing adjustments\nion-grid {\n  padding: 0;\n  \n  ion-row {\n    margin: 0;\n  }\n  \n  ion-col {\n    padding: 4px;\n  }\n}\n\n// Loading skeleton container\n.supply-container app-skeleton {\n  margin: 20px 0;\n}\n\n// Success-specific styling for add operations\n.form-section:has(.total-input) {\n  .section-subtitle {\n    color: var(--ion-color-success);\n    border-bottom-color: rgba(45, 211, 111, 0.3);\n    \n    ion-icon {\n      color: var(--ion-color-success);\n    }\n  }\n}\n\n// Enhanced visual indicators for add/edit flow\n.section-header .section-title {\n  position: relative;\n  \n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-success), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n  \n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n  \n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Quantity calculation visual feedback\n.total-input ion-input {\n  background: rgba(45, 211, 111, 0.1);\n  border-radius: 4px;\n  font-weight: 600;\n}\n\n// Unit label styling\n.unit-label {\n  color: var(--ion-color-primary);\n  font-weight: 500;\n  font-size: 0.9em;\n}\n\n// Provider search styling\n.provider-search-container {\n  margin-bottom: 16px;\n  padding: 16px;\n  border-radius: 8px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n  \n  .provider-label {\n    font-weight: 500;\n    color: var(--ion-color-dark);\n    font-size: 14px;\n    margin-bottom: 8px;\n    display: block;\n  }\n  \n  .provider-search-wrapper {\n    position: relative;\n    width: 100%;\n    \n    .provider-searchbar {\n      --background: white;\n      --border-radius: 4px;\n      --box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\n      --padding-start: 12px;\n      --padding-end: 12px;\n      margin: 0;\n      \n      ion-searchbar {\n        --placeholder-color: var(--ion-color-medium);\n        --color: var(--ion-color-dark);\n        --icon-color: var(--ion-color-medium);\n      }\n    }\n    \n    .provider-options-list {\n      position: absolute;\n      top: 100%;\n      left: 0;\n      right: 0;\n      z-index: 1000;\n      max-height: 240px;\n      overflow-y: auto;\n      background: white;\n      border: 1px solid rgba(0, 0, 0, 0.1);\n      border-radius: 8px;\n      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n      margin-top: 4px;\n      \n      ion-item {\n        --min-height: 48px;\n        --padding-start: 16px;\n        --padding-end: 16px;\n        border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n        \n        &:last-child {\n          border-bottom: none;\n        }\n        \n        &:hover, &.selected {\n          --background: rgba(45, 211, 111, 0.1);\n        }\n        \n        ion-label {\n          font-size: 14px;\n          font-weight: 400;\n          color: var(--ion-color-dark);\n        }\n        \n        ion-icon[name=\"checkmark\"] {\n          font-size: 18px;\n        }\n      }\n    }\n    \n    .no-results {\n      position: absolute;\n      top: 100%;\n      left: 0;\n      right: 0;\n      z-index: 1000;\n      background: white;\n      border: 1px solid rgba(0, 0, 0, 0.1);\n      border-radius: 8px;\n      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n      margin-top: 4px;\n      padding: 24px;\n      text-align: center;\n      \n      p {\n        color: var(--ion-color-medium);\n        font-size: 14px;\n        margin: 0;\n      }\n    }\n  }\n  \n  .error-note {\n    font-size: 12px;\n    color: var(--ion-color-danger);\n    margin-top: 4px;\n    display: block;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 30035:
/*!****************************************************************!*\
  !*** ./src/app/pages/supply-in/supply-in.page.html?ngResource ***!
  \****************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n       <ion-back-button defaultHref=\"home\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{title}}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"(isEditMode && supplyEditPreqData) || (!isEditMode && supplyRequestPreq); else loading\" class=\"supply-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"{{isEditMode ? 'create-outline' : 'add-circle-outline'}}\" color=\"success\"></ion-icon>\n        {{title}}\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"supplyRequestForm\" (ngSubmit)=\"submitForm(supplyRequestForm)\" class=\"supply-form\">\n\n            <!-- Basic Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"information-circle-outline\" color=\"primary\"></ion-icon>\n                Basic Information\n              </h3>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Entry Date *</ion-label>\n                <ion-input formControlName=\"transaction_date\" type=\"date\" placeholder=\"Select entry date\" [max]=\"getTodaysDate()\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"supplyRequestForm.get('transaction_date')?.invalid && supplyRequestForm.get('transaction_date')?.touched\">\n                  <span *ngIf=\"supplyRequestForm.get('transaction_date')?.errors?.['required']\">This field is required</span>\n                  <span *ngIf=\"supplyRequestForm.get('transaction_date')?.errors?.['futureDate']\">Transaction date cannot be in the future</span>\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-label position=\"stacked\">Supply in Source *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"transaction_def\" (ionChange)=\"onTransactionDefChange($event)\">\n                  <ion-select-option *ngIf=\"transactionDefTypes.includes('dp_to_inf')\" value=\"dp_to_inf\">From Distribution Point</ion-select-option>\n                  <ion-select-option *ngIf=\"transactionDefTypes.includes('wh_to_inf')\" value=\"wh_to_inf\">From Warehouse</ion-select-option>\n                  <ion-select-option *ngIf=\"transactionDefTypes.includes('inf_to_inf')\" value=\"inf_to_inf\">From another INF</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"supplyRequestForm.get('transaction_def')?.invalid && supplyRequestForm.get('transaction_def')?.touched\">\n                  This field is required\n                </ion-note>\n              </ion-item>\n\n              <!-- Provider selection with search functionality -->\n              <div *ngIf=\"supplyRequestForm.get('transaction_def')?.value !== 'dp_to_inf'\" class=\"form-item provider-search-container\">\n                <ion-label class=\"provider-label\">Which {{supplyRequestForm.get('transaction_def')?.value === 'inf_to_inf' ? 'INF' : 'Program Partner'}} *</ion-label>\n                \n                <div class=\"provider-search-wrapper\" (click)=\"$event.stopPropagation()\">\n                  <ion-searchbar \n                    [(ngModel)]=\"providerSearchTerm\"\n                    (ionInput)=\"filterProviders($event)\"\n                    (ionFocus)=\"onSearchFocus()\"\n                    (ionBlur)=\"onSearchBlur()\"\n                    [placeholder]=\"'Search and select ' + (supplyRequestForm.get('transaction_def')?.value === 'inf_to_inf' ? 'INF' : 'Program Partner') + '...'\"\n                    [ngModelOptions]=\"{standalone: true}\"\n                    class=\"provider-searchbar\">\n                  </ion-searchbar>\n                  \n                  <!-- Hidden select for form integration -->\n                  <ion-select \n                    formControlName=\"provider\"\n                    interface=\"action-sheet\"\n                    style=\"display: none;\">\n                    <ion-select-option *ngFor=\"let item of getProviderList()\"\n                      [value]=\"item.id\">{{item.title}}</ion-select-option>\n                  </ion-select>\n                  \n                  <!-- Options dropdown -->\n                  <ion-list *ngIf=\"showFilteredOptions && filteredProviders?.length > 0\" class=\"provider-options-list\">\n                    <ion-item \n                      button \n                      *ngFor=\"let provider of filteredProviders; trackBy: trackByProviderId\" \n                      (click)=\"selectProvider(provider)\"\n                      [class.selected]=\"supplyRequestForm.get('provider')?.value === provider.id\">\n                      <ion-label>{{provider.title}}</ion-label>\n                      <ion-icon \n                        *ngIf=\"supplyRequestForm.get('provider')?.value === provider.id\" \n                        name=\"checkmark\" \n                        color=\"primary\" \n                        slot=\"end\">\n                      </ion-icon>\n                    </ion-item>\n                  </ion-list>\n                  \n                  <!-- No results -->\n                  <div *ngIf=\"showFilteredOptions && filteredProviders?.length === 0 && providerSearchTerm\" class=\"no-results\">\n                    <p>No {{supplyRequestForm.get('transaction_def')?.value === 'inf_to_inf' ? 'INFs' : 'Program Partners'}} found matching \"{{providerSearchTerm}}\"</p>\n                  </div>\n                  \n                  <div *ngIf=\"showFilteredOptions && filteredProviders?.length === 0 && !providerSearchTerm\" class=\"no-results\">\n                    <p>No {{supplyRequestForm.get('transaction_def')?.value === 'inf_to_inf' ? 'INF' : 'Program Partner'}} data available.</p>\n                  </div>\n                </div>\n                \n                <ion-note class=\"error-note\"\n                  *ngIf=\"supplyRequestForm.get('provider')?.invalid && supplyRequestForm.get('provider')?.touched\">\n                  This field is required\n                </ion-note>\n              </div>\n\n              <ion-item class=\"form-item\" *ngIf=\"supplyRequestForm.get('transaction_def')?.value !== 'dp_to_inf'\">\n                <ion-icon slot=\"start\" name=\"receipt-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Waybill No *</ion-label>\n                <ion-input formControlName=\"waybill\" placeholder=\"Enter waybill number\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"supplyRequestForm.get('waybill')?.invalid && supplyRequestForm.get('waybill')?.touched\">\n                  This field is required\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Notes</ion-label>\n                <ion-textarea formControlName=\"notes\" placeholder=\"Enter additional notes (optional)\" rows=\"3\"></ion-textarea>\n              </ion-item>\n            </div>\n\n            <!-- Supply Items Section -->\n            <div class=\"form-section\" formArrayName=\"supply_items\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"cube-outline\" color=\"primary\"></ion-icon>\n                Items ({{supplyItems.length}})\n              </h3>\n\n              <div *ngFor=\"let item of supplyRequestForm.controls.supply_items['controls']; let i=index\" [formGroupName]=\"i\" class=\"supply-item-card\">\n                <div class=\"supply-item-header\">\n                  <span class=\"item-number\">Item #{{i + 1}}</span>\n                  <ion-button *ngIf=\"supplyItems.length > 1\" fill=\"clear\" color=\"danger\" (click)=\"removeSupply(i)\" class=\"remove-btn\">\n                    <ion-icon name=\"trash-outline\" slot=\"icon-only\"></ion-icon>\n                  </ion-button>\n                </div>\n\n                <ion-grid>\n                  <ion-row>\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-label position=\"stacked\">Supply Item *</ion-label>\n                        <ion-select interface=\"action-sheet\" formControlName=\"supply_item_id\" (ionChange)=\"onSelectSupplyItem($event, i)\">\n                          <ion-select-option *ngFor=\"let supply of getAllSupplyItems()\" [value]=\"supply.id\">\n                            {{supply.title}}\n                          </ion-select-option>\n                        </ion-select>\n                        <ion-note slot=\"error\" *ngIf=\"supplyItems.at(i).get('supply_item_id')?.invalid && supplyItems.at(i).get('supply_item_id')?.touched\">\n                          Please select a supply item\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n\n                                        <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"pricetag-outline\" color=\"primary\"></ion-icon>\n                        <ion-label position=\"stacked\">Lot/Batch No *</ion-label>\n\n                        <!-- Dropdown for dp_to_inf -->\n                        <ion-select *ngIf=\"isLotDropdownMode()\" interface=\"action-sheet\" formControlName=\"lot_no\"\n                          (ionChange)=\"onSelectLot($event, i)\"\n                          [disabled]=\"!supplyItems.at(i).get('supply_item_id')?.value\">\n                          <ion-select-option *ngFor=\"let lot of getLotList(i)\" [value]=\"lot.lot_no\">\n                            {{lot.lot_no}} (Available: {{getAvailableQuantity(lot)}})\n                          </ion-select-option>\n                        </ion-select>\n\n                        <!-- Text input for other transaction types -->\n                        <ion-input *ngIf=\"!isLotDropdownMode()\" formControlName=\"lot_no\" placeholder=\"Enter lot number\" (ionInput)=\"onLotNumberChange(i)\"></ion-input>\n\n                        <ion-note slot=\"error\" *ngIf=\"supplyItems.at(i).get('lot_no')?.invalid && supplyItems.at(i).get('lot_no')?.touched\">\n                          <span *ngIf=\"supplyItems.at(i).get('lot_no')?.errors?.['required']\">Lot/Batch number is required</span>\n                          <span *ngIf=\"supplyItems.at(i).get('lot_no')?.errors?.['duplicateLot']\">This lot number already exists for this supply item</span>\n                        </ion-note>\n                        <ion-note slot=\"helper\" *ngIf=\"isLotDropdownMode() && !supplyItems.at(i).get('supply_item_id')?.value\" color=\"medium\">\n                          Select supply item first\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n                  </ion-row>\n\n                  <ion-row>\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                        <ion-label position=\"stacked\">Expire Date *</ion-label>\n                        <ion-input formControlName=\"expire_date\" type=\"date\"\n                          [readonly]=\"isLotDropdownMode()\"\n                          [placeholder]=\"isLotDropdownMode() ? 'Auto-filled from lot selection' : 'Select expire date'\"></ion-input>\n                        <ion-note slot=\"error\" *ngIf=\"supplyItems.at(i).get('expire_date')?.invalid && supplyItems.at(i).get('expire_date')?.touched\">\n                          <span *ngIf=\"!isLotDropdownMode()\">Please select expire date</span>\n                          <span *ngIf=\"isLotDropdownMode()\">Expire date will be auto-filled from lot selection</span>\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n                    <ion-col size=\"12\" size-md=\"6\">\n                      <ion-item class=\"form-item\">\n                        <ion-icon slot=\"start\" name=\"calculator-outline\" color=\"success\"></ion-icon>\n                        <ion-label position=\"stacked\">\n                          Total Quantity *\n                          <span *ngIf=\"getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value)\" class=\"unit-label\">\n                            ({{ getSupplyItemUnit(supplyItems.at(i).get('supply_item_id')?.value) }})\n                          </span>\n                          <span *ngIf=\"isLotDropdownMode() && supplyItems.at(i).get('available')?.value > 0\" class=\"available-label\">\n                            - Available: {{supplyItems.at(i).get('available')?.value}}\n                          </span>\n                        </ion-label>\n                        <ion-input formControlName=\"total_quantity\" type=\"number\" min=\"0\"\n                          [max]=\"isLotDropdownMode() ? (supplyItems.at(i).get('available')?.value || 999999) : 999999\"\n                          placeholder=\"Enter total quantity\"\n                          (ionInput)=\"isLotDropdownMode() ? validateQuantity($event, i) : null\"></ion-input>\n                        <ion-note slot=\"error\" *ngIf=\"supplyItems.at(i).get('total_quantity')?.invalid && supplyItems.at(i).get('total_quantity')?.touched\">\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['required']\">Enter total quantity</span>\n                          <span *ngIf=\"supplyItems.at(i).get('total_quantity')?.errors?.['quantityExceedsAvailable']\">Quantity exceeds available stock</span>\n                        </ion-note>\n                      </ion-item>\n                    </ion-col>\n                  </ion-row>\n                </ion-grid>\n              </div>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button fill=\"outline\" color=\"primary\" (click)=\"addNewSupply()\" type=\"button\" class=\"add-item-btn\">\n                <ion-icon name=\"add\" slot=\"start\"></ion-icon>\n                Add Supply Item\n              </ion-button>\n\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\" [disabled]=\"supplyRequestForm.invalid\">\n                <ion-icon name=\"{{isEditMode ? 'save-outline' : 'cloud-upload-outline'}}\" slot=\"start\"></ion-icon>\n                {{isEditMode ? 'Update Supply' : 'Save Supply'}}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"supply-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading supply data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_supply-in_supply-in_module_ts.js.map