(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_sc-transfer-create_sc-transfer-create_module_ts-src_app_services_api_base_service_ts"],{

/***/ 75895:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/sc-transfer-create/sc-transfer-create-routing.module.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScTransferCreatePageRoutingModule: () => (/* binding */ ScTransferCreatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _sc_transfer_create_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sc-transfer-create.page */ 31609);




const routes = [{
  path: '',
  component: _sc_transfer_create_page__WEBPACK_IMPORTED_MODULE_0__.ScTransferCreatePage
}];
let ScTransferCreatePageRoutingModule = class ScTransferCreatePageRoutingModule {};
ScTransferCreatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], ScTransferCreatePageRoutingModule);


/***/ }),

/***/ 85638:
/*!***********************************************************************!*\
  !*** ./src/app/pages/sc-transfer-create/sc-transfer-create.module.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScTransferCreatePageModule: () => (/* binding */ ScTransferCreatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _sc_transfer_create_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sc-transfer-create-routing.module */ 75895);
/* harmony import */ var _sc_transfer_create_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sc-transfer-create.page */ 31609);







let ScTransferCreatePageModule = class ScTransferCreatePageModule {};
ScTransferCreatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _sc_transfer_create_routing_module__WEBPACK_IMPORTED_MODULE_0__.ScTransferCreatePageRoutingModule],
  declarations: [_sc_transfer_create_page__WEBPACK_IMPORTED_MODULE_1__.ScTransferCreatePage]
})], ScTransferCreatePageModule);


/***/ }),

/***/ 31609:
/*!*********************************************************************!*\
  !*** ./src/app/pages/sc-transfer-create/sc-transfer-create.page.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScTransferCreatePage: () => (/* binding */ ScTransferCreatePage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _sc_transfer_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sc-transfer-create.page.html?ngResource */ 49483);
/* harmony import */ var _sc_transfer_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sc-transfer-create.page.scss?ngResource */ 79215);
/* harmony import */ var _sc_transfer_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_sc_transfer_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_inpatient_care_treatment_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/inpatient_care_treatment_api.service */ 62446);
/* harmony import */ var src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/child_api.service */ 57571);

var _ScTransferCreatePage;








let ScTransferCreatePage = (_ScTransferCreatePage = class ScTransferCreatePage {
  constructor(route, b, scApi, childApi, change) {
    this.route = route;
    this.b = b;
    this.scApi = scApi;
    this.childApi = childApi;
    this.change = change;
    this.isEditMode = false;
    this.child = null;
    this.stabilizationCenters = [];
    this.loading = false;
    this.loadingData = false;
    this.transferReason = '';
    this.childId = +this.route.snapshot.paramMap.get('childId');
    this.route.queryParams.subscribe(params => {
      if (params['scTransferId']) {
        this.scTransferId = +params['scTransferId'];
        this.isEditMode = true;
      }
    });
  }
  ngOnInit() {
    this.load();
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this.loadingData = true;
        // Load child details
        const childResponse = yield _this.childApi.getChild(_this.childId);
        if (childResponse && childResponse.success) {
          _this.child = childResponse.data;
        } else {
          yield _this.b.errorToast('Failed to load child details');
          _this.b.goBack();
          return;
        }
        // Load stabilization centers
        const scResponse = yield _this.scApi.getStabilizationCenters();
        if (scResponse && scResponse.success) {
          _this.stabilizationCenters = scResponse.data || [];
        } else {
          yield _this.b.errorToast('Failed to load stabilization centers');
        }
        // Load existing SC transfer data if in edit mode
        if (_this.isEditMode && _this.scTransferId) {
          const transferResponse = yield _this.scApi.getTreatment(_this.scTransferId);
          if (transferResponse && transferResponse.success) {
            const transfer = transferResponse.data;
            _this.selectedScId = transfer.sc_id;
            _this.transferReason = transfer.transfer_reason || '';
          } else {
            yield _this.b.errorToast('Failed to load SC transfer details');
          }
        }
        _this.change.markForCheck();
      } catch (error) {
        yield _this.b.errorToast('Error loading data');
      } finally {
        _this.loadingData = false;
      }
    })();
  }
  submitTransferRequest() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Validation
      if (!_this2.selectedScId) {
        yield _this2.b.errorToast('Please select a stabilization center');
        return;
      }
      if (!_this2.transferReason || _this2.transferReason.trim().length < 10) {
        yield _this2.b.errorToast('Please enter a transfer reason (minimum 10 characters)');
        return;
      }
      try {
        _this2.loading = true;
        const payload = {
          beneficiary_id: _this2.childId,
          sc_id: _this2.selectedScId,
          transfer_reason: _this2.transferReason.trim()
        };
        let response;
        if (_this2.isEditMode && _this2.scTransferId) {
          response = yield _this2.scApi.updateTreatment(_this2.scTransferId, payload);
          if (response && response.success) {
            yield _this2.b.toast('SC transfer request updated successfully');
            _this2.b.goBack();
          } else {
            yield _this2.b.errorToast(response.message || 'Failed to update SC transfer request');
          }
        } else {
          response = yield _this2.scApi.createTransferRequest(payload);
          if (response && response.success) {
            yield _this2.b.toast('SC transfer request created successfully');
            _this2.b.goBack();
          } else {
            yield _this2.b.errorToast(response.message || 'Failed to create SC transfer request');
          }
        }
      } catch (error) {
        yield _this2.b.errorToast('Error saving SC transfer request');
      } finally {
        _this2.loading = false;
      }
    })();
  }
  cancel() {
    this.b.goBack();
  }
  calculateAgeInMonths(dateOfBirth) {
    if (!dateOfBirth) {
      return 0;
    }
    const today = new Date();
    const birthDate = new Date(dateOfBirth);
    const months = (today.getFullYear() - birthDate.getFullYear()) * 12 + (today.getMonth() - birthDate.getMonth());
    return months;
  }
}, _ScTransferCreatePage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.ActivatedRoute
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: src_app_services_inpatient_care_treatment_api_service__WEBPACK_IMPORTED_MODULE_4__.InpatientCareTreatmentAPIService
}, {
  type: src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_5__.ChildAPIService
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectorRef
}], _ScTransferCreatePage);
ScTransferCreatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-sc-transfer-create',
  template: _sc_transfer_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_sc_transfer_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ScTransferCreatePage);


/***/ }),

/***/ 70014:
/*!**********************************************!*\
  !*** ./src/app/services/api_base.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   APIBaseService: () => (/* binding */ APIBaseService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./global */ 99328);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
var _APIBaseService;

/* eslint-disable eqeqeq */

/* eslint-disable @typescript-eslint/naming-convention */




let APIBaseService = (_APIBaseService = class APIBaseService {
  constructor(http, g, b, store) {
    this.http = http;
    this.g = g;
    this.b = b;
    this.store = store;
  }
  getHeader(params = {}) {
    // Get token from current user if g.jws is not available
    let token = this.g.jws;
    if (!token) {
      const currentUser = this.b.getCurrentUser();
      token = currentUser === null || currentUser === void 0 ? void 0 : currentUser.token;
    }
    return {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpHeaders({
        Authorization: token
      }),
      params
    };
  }
  errorHandle(err) {
    let message = '';
    let detailedErrors = null;
    // Extract error details from response
    if (err !== null && err !== void 0 && err.error) {
      // Backend error format: {success: false, message: string, data?: object|string}
      message = err.error.message || err.message;
      detailedErrors = err.error.data;
    } else {
      message = err.message;
    }
    // Handle specific HTTP status codes
    switch (err.status) {
      case 0:
        // Network error
        message = 'Failed reaching server!!! Make sure you are connected to internet or camp site network.';
        this.b.errorToast(message);
        break;
      case 400:
        // Bad Request
        message = message || 'Bad request. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 401:
        // Unauthorized - token expired
        message = message || 'Session expired. Please login again.';
        this.b.errorToast(message);
        setTimeout(() => {
          this.b.logout('token_expired');
        }, 3000);
        break;
      case 403:
        // Forbidden
        message = message || 'Access denied. You do not have permission to perform this action.';
        this.b.errorToast(message);
        break;
      case 404:
        // Not Found
        message = message || 'Resource not found.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 422:
        // Validation Error (Unprocessable Entity)
        message = message || 'Validation failed. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 500:
        // Internal Server Error
        message = message || 'Internal server error. Please try again later.';
        this.b.errorToast(message);
        break;
      case 503:
        // Service Unavailable
        message = message || 'Service unavailable. Please try again later.';
        this.b.errorToast(message);
        break;
      default:
        // Other errors
        message = message || 'Unknown error occurred. Make sure you are connected and retry.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
    }
    return Promise.resolve({
      message: this.formatErrorMessage(message, detailedErrors),
      success: false,
      data: detailedErrors
    });
  }
  /**
   * Format error message with detailed validation errors or data
   */
  formatErrorMessage(mainMessage, detailedErrors) {
    if (!detailedErrors) {
      return mainMessage;
    }
    // If detailedErrors is a string (like the data field from backend)
    if (typeof detailedErrors === 'string') {
      return `${mainMessage} - ${detailedErrors}`;
    }
    // If detailedErrors is an object with field-specific errors (validation errors)
    if (typeof detailedErrors === 'object' && !Array.isArray(detailedErrors)) {
      const errorMessages = [mainMessage];
      Object.keys(detailedErrors).forEach(field => {
        const fieldErrors = detailedErrors[field];
        if (Array.isArray(fieldErrors)) {
          fieldErrors.forEach(error => errorMessages.push(`• ${error}`));
        } else if (typeof fieldErrors === 'string') {
          errorMessages.push(`• ${fieldErrors}`);
        }
      });
      return errorMessages.join('\n');
    }
    return mainMessage;
  }
}, _APIBaseService.ctorParameters = () => [{
  type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient
}, {
  type: _global__WEBPACK_IMPORTED_MODULE_0__.GlobalProvider
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_3__.Store
}], _APIBaseService);
APIBaseService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], APIBaseService);


/***/ }),

/***/ 79215:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/sc-transfer-create/sc-transfer-create.page.scss?ngResource ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.transfer-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.transfer-form .form-section {
  margin-bottom: 32px;
}
.transfer-form .form-section:last-child {
  margin-bottom: 0;
}
.transfer-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.transfer-form .section-subtitle ion-icon {
  font-size: 20px;
}
.transfer-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.transfer-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.transfer-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.transfer-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.transfer-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}

.child-info-card {
  margin: 16px 0;
}
.child-info-card .child-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.child-info-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.child-info-card .info-item:last-child {
  margin-bottom: 0;
}
.child-info-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.child-info-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.child-info-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.child-info-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.transfer-note {
  display: flex;
  align-items: center;
  gap: 6px;
  padding: 12px;
  background: rgba(var(--ion-color-warning-rgb), 0.1);
  border-radius: 8px;
  font-size: 13px;
  line-height: 1.4;
  margin-top: 16px;
}
.transfer-note ion-icon {
  font-size: 18px;
  flex-shrink: 0;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn,
.form-actions .cancel-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled],
.form-actions .cancel-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input, ion-textarea {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-select {
  --padding-start: 8px;
  --padding-end: 8px;
}

@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn,
  .form-actions .cancel-btn {
    width: 100%;
    min-width: auto;
  }
  .child-info-card {
    margin: 12px 0;
  }
  .child-info-card .profile-content {
    padding: 16px;
  }
  .child-info-card .content-grid ion-col {
    padding: 0 3px;
  }
  .child-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .child-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .child-info-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .child-info-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .child-info-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .child-info-card .item-content .value {
    font-size: 13px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/sc-transfer-create/sc-transfer-create.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAaE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAXJ;AAaI;EACE,gBAAA;EACA,4BAAA;AAXN;AAcI;EACE,eAAA;EACA,eAAA;AAZN;AAcM;EACE,8BAAA;AAZR;AAeM;EACE,8BAAA;AAbR;;AAoBA;EACE,cAAA;AAjBF;AAmBE;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAjBJ;;AAqBA;EACE,aAAA;AAlBF;;AAqBA;EACE,UAAA;EACA,SAAA;AAlBF;AAoBE;EACE,SAAA;AAlBJ;AAqBE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAnBJ;AAqBI;EACE,eAAA;EACA,kBAAA;AAnBN;AAsBI;EACE,gBAAA;EACA,iBAAA;AApBN;;AAyBA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAtBF;AAwBE;EACE,gBAAA;AAtBJ;AAyBE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAvBJ;AA0BE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AAxBJ;;AA4BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAzBF;AA2BE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AAzBJ;AA4BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AA1BJ;AA4BI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AA1BN;;AAgCA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,aAAA;EACA,mDAAA;EACA,kBAAA;EACA,eAAA;EACA,gBAAA;EACA,gBAAA;AA7BF;AA+BE;EACE,eAAA;EACA,cAAA;AA7BJ;;AAkCA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AA/BF;AAiCE;;EAEE,gBAAA;AA/BJ;AAiCI;;EACE,YAAA;EACA,mBAAA;AA9BN;;AAoCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAjCF;AAmCE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AAjCJ;AAoCE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AAlCJ;;AAuCA;EACE,oBAAA;EACA,kBAAA;AApCF;;AAuCA;EACE,oBAAA;EACA,kBAAA;AApCF;;AAwCA;EACE;IACE,eAAA;EArCF;EAuCE;IACE,eAAA;EArCJ;EAyCA;IACE,eAAA;EAvCF;EAyCE;IACE,eAAA;EAvCJ;EA2CA;IACE,sBAAA;IACA,gBAAA;EAzCF;EA2CE;;IAEE,WAAA;IACA,eAAA;EAzCJ;EA6CA;IACE,cAAA;EA3CF;EA6CE;IACE,aAAA;EA3CJ;EA+CI;IACE,cAAA;EA7CN;EA+CM;IACE,eAAA;IACA,kBAAA;EA7CR;EAgDM;IACE,gBAAA;IACA,iBAAA;EA9CR;EAmDE;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAjDJ;EAmDI;IACE,eAAA;IACA,WAAA;EAjDN;EAsDI;IACE,eAAA;IACA,qBAAA;EApDN;EAuDI;IACE,eAAA;EArDN;AACF","sourcesContent":["// SC Transfer Create Form Styles - Following PLW Transfer Out Design Patterns\n\n// Container styling\n.transfer-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.transfer-form {\n  .form-section {\n    margin-bottom: 32px;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n\n    ion-icon {\n      font-size: 20px;\n    }\n  }\n\n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n\n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n\n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n\n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n  }\n}\n\n// Child Information Card styling\n.child-info-card {\n  margin: 16px 0;\n\n  .child-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.child-info-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n  }\n}\n\n.child-info-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Transfer note styling\n.transfer-note {\n  display: flex;\n  align-items: center;\n  gap: 6px;\n  padding: 12px;\n  background: rgba(var(--ion-color-warning-rgb), 0.1);\n  border-radius: 8px;\n  font-size: 13px;\n  line-height: 1.4;\n  margin-top: 16px;\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n\n  .submit-btn,\n  .cancel-btn {\n    min-width: 180px;\n\n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input, ion-textarea {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\nion-select {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 14px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n\n    .submit-btn,\n    .cancel-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n\n  .child-info-card {\n    margin: 12px 0;\n\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 49483:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/sc-transfer-create/sc-transfer-create.page.html?ngResource ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"'/child-detail/' + childId\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ isEditMode ? 'Edit SC Transfer Request' : 'SC Transfer Request' }}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"child; else loading\" class=\"transfer-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"medkit-outline\" color=\"primary\"></ion-icon>\n        Transfer Child to Stabilization Center\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form class=\"transfer-form\">\n\n            <!-- Child Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                Child Information\n              </h3>\n\n              <!-- Child Information Card -->\n              <div class=\"child-info-card\">\n                <ion-card class=\"child-card\">\n                  <div class=\"profile-content\">\n                    <ion-grid class=\"content-grid\">\n                      <ion-row>\n                        <!-- Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Name</span>\n                              <span class=\"value\">{{ child?.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">SSID</span>\n                              <span class=\"value\">{{ child?.ssid || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Progress ID</span>\n                              <span class=\"value\">{{ child?.progress_id || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"calendar-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Age</span>\n                              <span class=\"value\">{{ calculateAgeInMonths(child?.date_of_birth) || '-' }} months</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"male-female-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Gender</span>\n                              <span class=\"value\">{{ child?.gender || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"business-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Current INF</span>\n                              <span class=\"value\">{{ child?.current_location?.inf?.title || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n                    </ion-grid>\n                  </div>\n                </ion-card>\n              </div>\n\n            </div>\n\n            <!-- Transfer Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"medkit-outline\" color=\"primary\"></ion-icon>\n                Transfer Details\n              </h3>\n\n              <!-- SC Selection -->\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"medical-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Stabilization Center *</ion-label>\n                <ion-select\n                  [(ngModel)]=\"selectedScId\"\n                  [ngModelOptions]=\"{standalone: true}\"\n                  placeholder=\"Select Stabilization Center\"\n                  interface=\"action-sheet\">\n                  <ion-select-option *ngFor=\"let sc of stabilizationCenters\" [value]=\"sc.id\">\n                    {{ sc.title }} {{ sc.sc_code ? '(' + sc.sc_code + ')' : '' }}\n                  </ion-select-option>\n                </ion-select>\n              </ion-item>\n\n              <!-- Show message if no stabilization centers available -->\n                <ion-note *ngIf=\"!loadingData && stabilizationCenters.length === 0\" color=\"warning\" class=\"transfer-note\">\n                  <ion-icon name=\"warning-outline\"></ion-icon>\n                  No stabilization centers available. Please contact your administrator.\n                </ion-note>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"chatbox-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Transfer Reason *</ion-label>\n                <ion-textarea\n                  [(ngModel)]=\"transferReason\"\n                  [ngModelOptions]=\"{standalone: true}\"\n                  rows=\"6\"\n                  placeholder=\"Enter reason for SC transfer (minimum 10 characters)\">\n                </ion-textarea>\n              </ion-item>\n\n              <ion-note color=\"medium\" class=\"transfer-note\">\n                <ion-icon name=\"information-circle-outline\"></ion-icon>\n                This child must not be enrolled in any active program to be eligible for SC transfer.\n              </ion-note>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"button\" color=\"success\" class=\"submit-btn\"\n                (click)=\"submitTransferRequest()\"\n                [disabled]=\"!selectedScId || !transferReason || transferReason.trim().length === 0\">\n                <ion-icon name=\"send-outline\" slot=\"start\"></ion-icon>\n                <span *ngIf=\"!loadingData\">{{ isEditMode ? 'Update Transfer Request' : 'Submit Transfer Request' }}</span>\n                <span *ngIf=\"loadingData\">{{ isEditMode ? 'Updating...' : 'Submitting...' }}</span>\n              </ion-button>\n              <ion-button type=\"button\" fill=\"outline\" color=\"medium\" class=\"cancel-btn\"\n                (click)=\"cancel()\">\n                <ion-icon name=\"close-outline\" slot=\"start\"></ion-icon>\n                Cancel\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\"></ion-spinner>\n      <p>Loading...</p>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_sc-transfer-create_sc-transfer-create_module_ts-src_app_services_api_base_service_ts.js.map