(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_pregnancy-history-create_pregnancy-history-create_module_ts"],{

/***/ 21635:
/*!*******************************************************************************************!*\
  !*** ./src/app/pages/pregnancy-history-create/pregnancy-history-create-routing.module.ts ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PregnancyHistoryCreatePageRoutingModule: () => (/* binding */ PregnancyHistoryCreatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _pregnancy_history_create_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pregnancy-history-create.page */ 21253);




const routes = [{
  path: '',
  component: _pregnancy_history_create_page__WEBPACK_IMPORTED_MODULE_0__.PregnancyHistoryCreatePage
}];
let PregnancyHistoryCreatePageRoutingModule = class PregnancyHistoryCreatePageRoutingModule {};
PregnancyHistoryCreatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], PregnancyHistoryCreatePageRoutingModule);


/***/ }),

/***/ 31138:
/*!***********************************************************************************!*\
  !*** ./src/app/pages/pregnancy-history-create/pregnancy-history-create.module.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PregnancyHistoryCreatePageModule: () => (/* binding */ PregnancyHistoryCreatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _pregnancy_history_create_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pregnancy-history-create-routing.module */ 21635);
/* harmony import */ var _pregnancy_history_create_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pregnancy-history-create.page */ 21253);








let PregnancyHistoryCreatePageModule = class PregnancyHistoryCreatePageModule {};
PregnancyHistoryCreatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _pregnancy_history_create_routing_module__WEBPACK_IMPORTED_MODULE_1__.PregnancyHistoryCreatePageRoutingModule],
  declarations: [_pregnancy_history_create_page__WEBPACK_IMPORTED_MODULE_2__.PregnancyHistoryCreatePage]
})], PregnancyHistoryCreatePageModule);


/***/ }),

/***/ 21253:
/*!*********************************************************************************!*\
  !*** ./src/app/pages/pregnancy-history-create/pregnancy-history-create.page.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PregnancyHistoryCreatePage: () => (/* binding */ PregnancyHistoryCreatePage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _pregnancy_history_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pregnancy-history-create.page.html?ngResource */ 10415);
/* harmony import */ var _pregnancy_history_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pregnancy-history-create.page.scss?ngResource */ 97039);
/* harmony import */ var _pregnancy_history_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_pregnancy_history_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_pregnancy_history_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/pregnancy-history.service */ 548);
/* harmony import */ var src_app_services_woman_api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/woman_api.service */ 11975);

var _PregnancyHistoryCreatePage;









let PregnancyHistoryCreatePage = (_PregnancyHistoryCreatePage = class PregnancyHistoryCreatePage {
  constructor(route, router, fb, b, pregnancyService, womanApi) {
    this.route = route;
    this.router = router;
    this.fb = fb;
    this.b = b;
    this.pregnancyService = pregnancyService;
    this.womanApi = womanApi;
    this.plwData = {};
    this.loading = true;
    this.formErrors = {};
    // Edit mode properties
    this.isEditMode = false;
    this.historyData = {};
    this.deliveryStatuses = ['pending', 'delivered', 'miscarriage', 'abortion'];
    this.deliveryTypes = ['normal', 'c-section'];
    this.numberOfBabiesOptions = [{
      value: '1',
      label: 'Single baby'
    }, {
      value: '2',
      label: 'Twin'
    }, {
      value: '3',
      label: 'Triplet'
    }];
    this.maxDate = new Date().toISOString().split('T')[0];
    this.initForm();
  }
  ngOnInit() {
    // Check if we're in edit mode (has 'id' param) or create mode (has 'plwId' param)
    this.historyId = this.route.snapshot.paramMap.get('id') || '';
    this.plwId = this.route.snapshot.paramMap.get('plwId') || '';
    if (this.historyId) {
      this.isEditMode = true;
    }
    this.loadData();
  }
  initForm() {
    this.pregnancyForm = this.fb.group({
      pregnancy_start_date: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      edd: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      actual_delivery_date: [''],
      delivery_status: ['pending', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      delivery_type: [''],
      number_of_babies: [''],
      birth_weight: [''],
      remarks: ['']
    });
  }
  loadData() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this.loading = true;
        if (_this.isEditMode) {
          // Load existing history data for edit mode
          const historyResponse = yield _this.pregnancyService.getPregnancyHistory(_this.historyId);
          if (historyResponse.success) {
            var _this$historyData$ben, _this$historyData$num;
            _this.historyData = historyResponse.data;
            _this.plwId = ((_this$historyData$ben = _this.historyData.beneficiary_id) === null || _this$historyData$ben === void 0 ? void 0 : _this$historyData$ben.toString()) || '';
            // Populate form with existing data
            _this.pregnancyForm.patchValue({
              pregnancy_start_date: _this.historyData.pregnancy_start_date || '',
              edd: _this.historyData.edd || '',
              actual_delivery_date: _this.historyData.actual_delivery_date || '',
              delivery_status: _this.historyData.delivery_status || 'pending',
              delivery_type: _this.historyData.delivery_type || '',
              number_of_babies: ((_this$historyData$num = _this.historyData.number_of_babies) === null || _this$historyData$num === void 0 ? void 0 : _this$historyData$num.toString()) || '',
              birth_weight: _this.historyData.birth_weight || '',
              remarks: _this.historyData.remarks || ''
            });
          }
        }
        // Load PLW data
        if (_this.plwId) {
          const response = yield _this.womanApi.getWoman(_this.plwId);
          if (response.success) {
            _this.plwData = response.data;
          }
        }
      } catch (error) {
        _this.b.errorToast('Error loading data');
      } finally {
        _this.loading = false;
      }
    })();
  }
  submitForm() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _form$get, _form$get2, _form$get3, _form$get4;
      _this2.formErrors = {};
      const form = _this2.pregnancyForm;
      const startDate = (_form$get = form.get('pregnancy_start_date')) !== null && _form$get !== void 0 && _form$get.value ? new Date((_form$get2 = form.get('pregnancy_start_date')) === null || _form$get2 === void 0 ? void 0 : _form$get2.value) : null;
      const edd = (_form$get3 = form.get('edd')) !== null && _form$get3 !== void 0 && _form$get3.value ? new Date((_form$get4 = form.get('edd')) === null || _form$get4 === void 0 ? void 0 : _form$get4.value) : null;
      // Require both startDate and EDD
      if (!startDate || !edd) {
        _this2.b.errorToast('Please provide both Pregnancy Start Date and Expected Delivery Date.');
        return;
      }
      if (form.valid) {
        try {
          const formData = {
            beneficiary_id: parseInt(_this2.plwId),
            ...form.value
          };
          if (_this2.isEditMode) {
            yield _this2.pregnancyService.updatePregnancyHistory(_this2.historyId, formData);
            _this2.b.toast('Pregnancy history updated successfully');
          } else {
            yield _this2.pregnancyService.createPregnancyHistory(formData);
            _this2.b.toast('Pregnancy history added successfully');
          }
          // Navigate back to woman-detail with reload query param
          _this2.router.navigate(['/woman-detail', _this2.plwId], {
            queryParams: {
              reload: true
            }
          });
        } catch (error) {
          var _error$error, _error$error2;
          if ((error === null || error === void 0 ? void 0 : error.status) === 422 && error !== null && error !== void 0 && (_error$error = error.error) !== null && _error$error !== void 0 && _error$error.errors) {
            _this2.formErrors = error.error.errors;
            const message = error.error.message || 'Validation errors occurred';
            _this2.b.errorToast(message);
          } else if (error !== null && error !== void 0 && (_error$error2 = error.error) !== null && _error$error2 !== void 0 && _error$error2.message) {
            _this2.b.errorToast(error.error.message);
          } else {
            _this2.b.errorToast('Error saving data');
          }
        }
      } else {
        // Mark all fields as touched to show validation errors
        Object.keys(_this2.pregnancyForm.controls).forEach(key => {
          var _this2$pregnancyForm$;
          (_this2$pregnancyForm$ = _this2.pregnancyForm.get(key)) === null || _this2$pregnancyForm$ === void 0 || _this2$pregnancyForm$.markAsTouched();
        });
        _this2.b.errorToast('Please fill all required fields');
      }
    })();
  }
  formatDate(date) {
    if (!date) return 'N/A';
    return new Date(date).toLocaleDateString();
  }
  getLocationInfo() {
    var _location$inf, _location$block, _location$sub_block;
    const location = this.plwData.current_location;
    if (!location) return 'N/A';
    const parts = [];
    if ((_location$inf = location.inf) !== null && _location$inf !== void 0 && _location$inf.title) parts.push(location.inf.title);
    if ((_location$block = location.block) !== null && _location$block !== void 0 && _location$block.title) parts.push(`Block ${location.block.title}`);
    if ((_location$sub_block = location.sub_block) !== null && _location$sub_block !== void 0 && _location$sub_block.title) parts.push(location.sub_block.title);
    return parts.length > 0 ? parts.join(', ') : 'N/A';
  }
  getFormattedDate(controlName) {
    var _this$pregnancyForm$g;
    const value = (_this$pregnancyForm$g = this.pregnancyForm.get(controlName)) === null || _this$pregnancyForm$g === void 0 ? void 0 : _this$pregnancyForm$g.value;
    if (!value) return '';
    try {
      const date = new Date(value);
      return date.toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'short',
        day: 'numeric'
      });
    } catch (error) {
      return '';
    }
  }
}, _PregnancyHistoryCreatePage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.Router
}, {
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: src_app_services_pregnancy_history_service__WEBPACK_IMPORTED_MODULE_4__.PregnancyHistoryService
}, {
  type: src_app_services_woman_api_service__WEBPACK_IMPORTED_MODULE_5__.WomanAPIService
}], _PregnancyHistoryCreatePage);
PregnancyHistoryCreatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_9__.Component)({
  selector: 'app-pregnancy-history-create',
  template: _pregnancy_history_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_pregnancy_history_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], PregnancyHistoryCreatePage);


/***/ }),

/***/ 97039:
/*!**********************************************************************************************!*\
  !*** ./src/app/pages/pregnancy-history-create/pregnancy-history-create.page.scss?ngResource ***!
  \**********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.pregnancy-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.pregnancy-form .form-section {
  margin-bottom: 32px;
}
.pregnancy-form .form-section:last-child {
  margin-bottom: 0;
}
.pregnancy-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.pregnancy-form .section-subtitle ion-icon {
  font-size: 20px;
}
.pregnancy-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.pregnancy-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.pregnancy-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.pregnancy-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.pregnancy-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}

.plw-info-card {
  margin: 16px 0;
}
.plw-info-card .plw-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.plw-info-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.plw-info-card .info-item:last-child {
  margin-bottom: 0;
}
.plw-info-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.plw-info-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.plw-info-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.plw-info-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.plw-info-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.plw-info-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-dark);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime, ion-textarea {
  --padding-start: 8px;
  --padding-end: 8px;
}

@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .plw-info-card {
    margin: 12px 0;
  }
  .plw-info-card .profile-content {
    padding: 16px;
  }
  .plw-info-card .content-grid ion-col {
    padding: 0 3px;
  }
  .plw-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .plw-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .plw-info-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .plw-info-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .plw-info-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .plw-info-card .item-content .value {
    font-size: 13px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/pregnancy-history-create/pregnancy-history-create.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAaE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAXJ;AAaI;EACE,gBAAA;EACA,4BAAA;AAXN;AAcI;EACE,eAAA;EACA,eAAA;AAZN;AAcM;EACE,8BAAA;AAZR;AAeM;EACE,8BAAA;AAbR;;AAoBA;EACE,cAAA;AAjBF;AAmBE;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAjBJ;;AAqBA;EACE,aAAA;AAlBF;;AAqBA;EACE,UAAA;EACA,SAAA;AAlBF;AAoBE;EACE,SAAA;AAlBJ;AAqBE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAnBJ;AAqBI;EACE,eAAA;EACA,kBAAA;AAnBN;AAsBI;EACE,gBAAA;EACA,iBAAA;AApBN;;AAyBA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAtBF;AAwBE;EACE,gBAAA;AAtBJ;AAyBE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAvBJ;AA0BE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AAxBJ;;AA4BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAzBF;AA2BE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AAzBJ;AA4BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AA1BJ;AA4BI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AA1BN;;AAgCA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AA7BF;AA+BE;EACE,gBAAA;AA7BJ;AA+BI;EACE,YAAA;EACA,mBAAA;AA7BN;;AAmCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAhCF;AAkCE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AAhCJ;AAmCE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AAjCJ;;AAsCA;EACE,oBAAA;EACA,kBAAA;AAnCF;AAqCE;EACE,8BAAA;EACA,gBAAA;EACA,eAAA;AAnCJ;;AAuCA;EACE,oBAAA;EACA,kBAAA;AApCF;;AAwCA;EACE;IACE,eAAA;EArCF;EAuCE;IACE,eAAA;EArCJ;EAyCA;IACE,eAAA;EAvCF;EAyCE;IACE,eAAA;EAvCJ;EA2CA;IACE,sBAAA;IACA,gBAAA;EAzCF;EA2CE;IACE,WAAA;IACA,eAAA;EAzCJ;EA6CA;IACE,cAAA;EA3CF;EA6CE;IACE,aAAA;EA3CJ;EA+CI;IACE,cAAA;EA7CN;EA+CM;IACE,eAAA;IACA,kBAAA;EA7CR;EAgDM;IACE,gBAAA;IACA,iBAAA;EA9CR;EAmDE;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAjDJ;EAmDI;IACE,eAAA;IACA,WAAA;EAjDN;EAsDI;IACE,eAAA;IACA,qBAAA;EApDN;EAuDI;IACE,eAAA;EArDN;AACF","sourcesContent":["// Pregnancy History Create Form Styles - Following Measurement Create Design Patterns\n\n// Container styling\n.pregnancy-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.pregnancy-form {\n  .form-section {\n    margin-bottom: 32px;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n\n    ion-icon {\n      font-size: 20px;\n    }\n  }\n\n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n\n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n\n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n\n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n  }\n}\n\n// PLW Information Card styling\n.plw-info-card {\n  margin: 16px 0;\n\n  .plw-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.plw-info-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n  }\n}\n\n.plw-info-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n\n  .submit-btn {\n    min-width: 180px;\n\n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n\n  &[readonly] {\n    --color: var(--ion-color-dark);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime, ion-textarea {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 14px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n\n  .plw-info-card {\n    margin: 12px 0;\n\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 10415:
/*!**********************************************************************************************!*\
  !*** ./src/app/pages/pregnancy-history-create/pregnancy-history-create.page.html?ngResource ***!
  \**********************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"'/woman-detail/' + plwId\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ isEditMode ? 'Edit' : 'Add' }} Pregnancy History</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"plwData && !loading; else loadingTemplate\" class=\"pregnancy-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"heart-outline\" color=\"danger\"></ion-icon>\n        {{ isEditMode ? 'Edit' : 'Add New' }} Pregnancy History\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"pregnancyForm\" (ngSubmit)=\"submitForm()\" class=\"pregnancy-form\">\n\n            <!-- PLW Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                PLW Information\n              </h3>\n\n              <!-- PLW Information Card -->\n              <div class=\"plw-info-card\">\n                <ion-card class=\"plw-card\">\n                  <div class=\"profile-content\">\n                    <ion-grid class=\"content-grid\">\n                      <ion-row>\n                        <!-- Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Name</span>\n                              <span class=\"value\">{{ plwData?.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">FCN</span>\n                              <span class=\"value\">{{ plwData?.fcn || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Progress ID</span>\n                              <span class=\"value\">{{ plwData?.progress_id || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"calendar-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Date of Birth</span>\n                              <span class=\"value\">{{ formatDate(plwData?.date_of_birth) }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Husband</span>\n                              <span class=\"value\">{{ plwData?.husband || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Father</span>\n                              <span class=\"value\">{{ plwData?.father || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n                    </ion-grid>\n                  </div>\n                </ion-card>\n              </div>\n\n            </div>\n\n            <!-- Pregnancy Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"heart-outline\" color=\"danger\"></ion-icon>\n                Pregnancy Information\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"pregnancyForm.get('pregnancy_start_date').invalid && pregnancyForm.get('pregnancy_start_date').touched\">\n                <ion-icon slot=\"start\" name=\"calendar\" [color]=\"pregnancyForm.get('pregnancy_start_date').invalid && pregnancyForm.get('pregnancy_start_date').touched ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Pregnancy Start Date *</ion-label>\n                <ion-input formControlName=\"pregnancy_start_date\" type=\"date\" [max]=\"maxDate\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"pregnancyForm.get('pregnancy_start_date').invalid && pregnancyForm.get('pregnancy_start_date').touched\">Pregnancy start date is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"pregnancyForm.get('edd').invalid && pregnancyForm.get('edd').touched\">\n                <ion-icon slot=\"start\" name=\"calendar-outline\" [color]=\"pregnancyForm.get('edd').invalid && pregnancyForm.get('edd').touched ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Expected Delivery Date (EDD) *</ion-label>\n                <ion-input formControlName=\"edd\" type=\"date\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"pregnancyForm.get('edd').invalid && pregnancyForm.get('edd').touched\">Expected delivery date is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"calendar-number-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Actual Delivery Date</ion-label>\n                <ion-input formControlName=\"actual_delivery_date\" type=\"date\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\">Leave empty if not yet delivered</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"pregnancyForm.get('delivery_status').invalid && pregnancyForm.get('delivery_status').touched\">\n                <ion-icon slot=\"start\" name=\"checkbox-outline\" [color]=\"pregnancyForm.get('delivery_status').invalid && pregnancyForm.get('delivery_status').touched ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Delivery Status *</ion-label>\n                <ion-select formControlName=\"delivery_status\" interface=\"action-sheet\" placeholder=\"Select delivery status\">\n                  <ion-select-option value=\"pending\">Pending</ion-select-option>\n                  <ion-select-option value=\"delivered\">Delivered</ion-select-option>\n                  <ion-select-option value=\"miscarriage\">Miscarriage</ion-select-option>\n                  <ion-select-option value=\"abortion\">Abortion</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"pregnancyForm.get('delivery_status').invalid && pregnancyForm.get('delivery_status').touched\">Delivery status is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"medical-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Delivery Type</ion-label>\n                <ion-select formControlName=\"delivery_type\" interface=\"action-sheet\" placeholder=\"Select delivery type\">\n                  <ion-select-option value=\"normal\">Normal</ion-select-option>\n                  <ion-select-option value=\"c-section\">C-Section</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"helper\" color=\"medium\">Only applicable if delivered</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"people-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Number of Babies</ion-label>\n                <ion-select formControlName=\"number_of_babies\" interface=\"action-sheet\" placeholder=\"Select number of babies\">\n                  <ion-select-option *ngFor=\"let option of numberOfBabiesOptions\" [value]=\"option.value\">\n                    {{ option.label }}\n                  </ion-select-option>\n                </ion-select>\n                <ion-note slot=\"helper\" color=\"medium\">Only applicable if delivered</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"scale-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">{{ pregnancyForm.get('number_of_babies')?.value > 1 ? 'Avg Birth Weight (Kg)' : 'Birth Weight (Kg)' }}</ion-label>\n                <ion-input formControlName=\"birth_weight\" type=\"number\" step=\"0.01\" min=\"0\" max=\"10\" [placeholder]=\"pregnancyForm.get('number_of_babies')?.value > 1 ? 'Enter average birth weight in kg' : 'Enter birth weight in kg'\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\">Only applicable if delivered</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Remarks</ion-label>\n                <ion-textarea formControlName=\"remarks\" rows=\"3\" placeholder=\"Enter any additional remarks\"></ion-textarea>\n              </ion-item>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"submit\" color=\"danger\" class=\"submit-btn\">\n                <ion-icon name=\"save-outline\" slot=\"start\"></ion-icon>\n                {{ isEditMode ? 'Update' : 'Save' }} Pregnancy History\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loadingTemplate>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\"></ion-spinner>\n      <p>Loading...</p>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_pregnancy-history-create_pregnancy-history-create_module_ts.js.map