(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_plw-measurement-create_plw-measurement-create_module_ts-src_app_services_api_ba-975ed7"],{

/***/ 66919:
/*!***************************************************************************************!*\
  !*** ./src/app/pages/plw-measurement-create/plw-measurement-create-routing.module.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlwMeasurementCreatePageRoutingModule: () => (/* binding */ PlwMeasurementCreatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _plw_measurement_create_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plw-measurement-create.page */ 48905);




const routes = [{
  path: '',
  component: _plw_measurement_create_page__WEBPACK_IMPORTED_MODULE_0__.PlwMeasurementCreatePage
}];
let PlwMeasurementCreatePageRoutingModule = class PlwMeasurementCreatePageRoutingModule {};
PlwMeasurementCreatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], PlwMeasurementCreatePageRoutingModule);


/***/ }),

/***/ 52182:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/plw-measurement-create/plw-measurement-create.module.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlwMeasurementCreatePageModule: () => (/* binding */ PlwMeasurementCreatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _plw_measurement_create_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plw-measurement-create-routing.module */ 66919);
/* harmony import */ var _plw_measurement_create_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plw-measurement-create.page */ 48905);







let PlwMeasurementCreatePageModule = class PlwMeasurementCreatePageModule {};
PlwMeasurementCreatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _plw_measurement_create_routing_module__WEBPACK_IMPORTED_MODULE_0__.PlwMeasurementCreatePageRoutingModule],
  declarations: [_plw_measurement_create_page__WEBPACK_IMPORTED_MODULE_1__.PlwMeasurementCreatePage]
})], PlwMeasurementCreatePageModule);


/***/ }),

/***/ 48905:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/plw-measurement-create/plw-measurement-create.page.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlwMeasurementCreatePage: () => (/* binding */ PlwMeasurementCreatePage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _plw_measurement_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plw-measurement-create.page.html?ngResource */ 62395);
/* harmony import */ var _plw_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./plw-measurement-create.page.scss?ngResource */ 42955);
/* harmony import */ var _plw_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_plw_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_plw_measurement_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/plw_measurement_api.service */ 80507);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 10819);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 52575);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs/operators */ 91817);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);

var _PlwMeasurementCreatePage;



/* eslint-disable @typescript-eslint/naming-convention */








let PlwMeasurementCreatePage = (_PlwMeasurementCreatePage = class PlwMeasurementCreatePage {
  constructor(fb, api, activatedRoute, b, change, router) {
    this.fb = fb;
    this.api = api;
    this.activatedRoute = activatedRoute;
    this.b = b;
    this.change = change;
    this.router = router;
    this.isEditMode = false;
    this.muacInputValue$ = new rxjs__WEBPACK_IMPORTED_MODULE_6__.Subject();
    this.weightInputValue$ = new rxjs__WEBPACK_IMPORTED_MODULE_6__.Subject();
    this.NutritionStatusColor = src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.NutritionStatusColor;
    this.NutritionStatusID = src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.NutritionStatusIDs;
    this.isLastMeasurementExpanded = false;
    // Check if we're in edit mode
    this.measurementId = this.activatedRoute.snapshot.paramMap.get('id');
    this.plwId = this.activatedRoute.snapshot.paramMap.get('plwId');
    this.isEditMode = !!this.measurementId;
    // Set today's date
    this.today = new Date().toISOString().split('T')[0];
    // Set minimum date (will be updated after loading last measurement data)
    const minDateObj = new Date();
    minDateObj.setDate(minDateObj.getDate() - 7);
    this.minDate = minDateObj.toISOString().split('T')[0];
    this.setupForm();
    if (!this.isEditMode && this.plwId) {
      this.measurementForm.get('plw_id').setValue(this.plwId);
    }
  }
  ngOnInit() {
    this.load();
    this.setupNutritionStatusCalculation();
  }
  setupForm() {
    this.measurementForm = this.fb.group({
      plw_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      date: [this.today, [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      muac: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      weight: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      nutrition_status: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]]
    });
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this.isEditMode) {
          // Load measurement for editing
          const response = yield _this.api.getPlwMeasurementEditPreq(_this.measurementId);
          if (response.success) {
            var _response$data$measur;
            _this.measurementPreqData = {
              muac_cutoff: response.data.muac_cutoff,
              dob: response.data.dob,
              refer_from: response.data.refer_from,
              nutrition_status: response.data.nutrition_status,
              plw_info: response.data.plw_info
            };
            _this.plw_info = response.data.plw_info;
            _this.plwId = response.data.measurement.plw_id;
            // Populate form with measurement data
            // Enable nutrition_status temporarily to set value
            const nutritionControl = _this.measurementForm.get('nutrition_status');
            nutritionControl.enable({
              emitEvent: false
            });
            _this.measurementForm.patchValue({
              plw_id: response.data.measurement.plw_id,
              date: response.data.measurement.date,
              muac: response.data.measurement.muac,
              weight: response.data.measurement.weight,
              nutrition_status: ((_response$data$measur = response.data.measurement.nutrition_status) === null || _response$data$measur === void 0 ? void 0 : _response$data$measur.id) || response.data.measurement.nutrition_status
            });
            // Disable nutrition_status after setting value
            nutritionControl.disable({
              emitEvent: false
            });
            _this.change.markForCheck();
          }
        } else {
          // Load for creating new measurement
          const response = yield _this.api.getPlwMeasurementPreqData(_this.plwId);
          if (response.success) {
            var _this$measurementPreq;
            _this.measurementPreqData = response.data;
            _this.plw_info = response.data.plw_info;
            // Set minimum date based on last measurement date
            if ((_this$measurementPreq = _this.measurementPreqData.last_measurement) !== null && _this$measurementPreq !== void 0 && _this$measurementPreq.date) {
              const lastMeasurementDate = new Date(_this.measurementPreqData.last_measurement.date);
              // Add 1 day to last measurement date to ensure new measurement is after it
              lastMeasurementDate.setDate(lastMeasurementDate.getDate() + 1);
              _this.minDate = lastMeasurementDate.toISOString().split('T')[0];
            }
            _this.change.markForCheck();
          }
        }
      } catch (error) {
        _this.b.toast('Failed to load prerequisite data');
      }
    })();
  }
  setupNutritionStatusCalculation() {
    var _this2 = this;
    // Auto-calculate nutrition status when MUAC or weight changes
    this.muacInputValue$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(500), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)()).subscribe(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.calculateNutritionStatus();
    }));
    this.weightInputValue$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(500), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)()).subscribe(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.calculateNutritionStatus();
    }));
  }
  calculateNutritionStatus() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const muac = +_this3.measurementForm.get('muac').value;
      if (muac) {
        _this3.changeNutritionStatus({
          muac
        });
      } else {
        _this3.measurementForm.get('nutrition_status').setValue('');
      }
    })();
  }
  onMuacChange(event) {
    var _event$detail, _event$target;
    const value = ((_event$detail = event.detail) === null || _event$detail === void 0 ? void 0 : _event$detail.value) || ((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.value);
    this.muacInputValue$.next(value);
  }
  onWeightChange(event) {
    var _event$detail2, _event$target2;
    const value = ((_event$detail2 = event.detail) === null || _event$detail2 === void 0 ? void 0 : _event$detail2.value) || ((_event$target2 = event.target) === null || _event$target2 === void 0 ? void 0 : _event$target2.value);
    this.weightInputValue$.next(value);
  }
  changeNutritionStatus(value) {
    var _this$measurementForm, _this$measurementPreq2, _this$measurementPreq3;
    const muac = +((_this$measurementForm = this.measurementForm.get('muac')) === null || _this$measurementForm === void 0 ? void 0 : _this$measurementForm.value);
    const control = this.measurementForm.get('nutrition_status');
    control.enable({
      emitEvent: false
    });
    // For PLW: MAM if MUAC <= woman_mam threshold, otherwise Normal (same logic as followup)
    if (muac > 0 && muac <= +((_this$measurementPreq2 = this.measurementPreqData) === null || _this$measurementPreq2 === void 0 || (_this$measurementPreq2 = _this$measurementPreq2.muac_cutoff) === null || _this$measurementPreq2 === void 0 ? void 0 : _this$measurementPreq2.woman_mam)) {
      // MAM case
      control.setValue(this.NutritionStatusID.MAM);
    } else if (muac > +((_this$measurementPreq3 = this.measurementPreqData) === null || _this$measurementPreq3 === void 0 || (_this$measurementPreq3 = _this$measurementPreq3.muac_cutoff) === null || _this$measurementPreq3 === void 0 ? void 0 : _this$measurementPreq3.woman_mam)) {
      // Normal case
      control.setValue(this.NutritionStatusID.NORMAL);
    }
    control.disable({
      emitEvent: false
    });
  }
  onSubmit() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Mark all fields as touched to show validation errors
      _this4.markFormGroupTouched(_this4.measurementForm);
      // Enable nutrition_status control before validation
      const control = _this4.measurementForm.get('nutrition_status');
      control.enable({
        emitEvent: false
      });
      // Comprehensive validation with detailed error messages
      const validationErrors = _this4.validateFormFields(_this4.measurementForm);
      if (validationErrors.length > 0) {
        // Show the first validation error
        _this4.b.errorToast(validationErrors[0]);
        // Disable field again
        control.disable({
          emitEvent: false
        });
        return;
      }
      if (_this4.measurementForm.valid) {
        try {
          // Get form values and convert numbers to strings
          const formValue = {
            ..._this4.measurementForm.value
          };
          // Convert numeric fields to strings as API expects
          if (formValue.muac !== null && formValue.muac !== '') {
            formValue.muac = String(formValue.muac);
          }
          if (formValue.weight !== null && formValue.weight !== '') {
            formValue.weight = String(formValue.weight);
          }
          let result;
          if (_this4.isEditMode) {
            result = yield _this4.api.plwMeasurementUpdate(formValue, _this4.measurementId);
          } else {
            result = yield _this4.api.plwMeasurementStore(formValue);
          }
          if (result.success) {
            _this4.b.toast(result.message || `PLW Measurement ${_this4.isEditMode ? 'updated' : 'created'} successfully`);
            _this4.router.navigate(['/woman-detail', _this4.plwId], {
              queryParams: {
                reload: true
              }
            });
          }
          // Error handling is done in api_base.service.ts errorHandle() method
          // No need to display error toast again here as it's already shown
          // Disable it again after submit
          control.disable({
            emitEvent: false
          });
        } catch (error) {
          _this4.b.errorToast(`Error ${_this4.isEditMode ? 'updating' : 'creating'} PLW measurement`);
          // Disable field again
          control.disable({
            emitEvent: false
          });
        }
      } else {
        // If form is invalid but no custom validation errors were caught
        const formErrors = _this4.getDetailedFormErrors();
        _this4.b.errorToast(formErrors || 'Please fill out all required fields correctly');
        // Disable field again
        control.disable({
          emitEvent: false
        });
      }
    })();
  }
  validateFormFields(formGroup) {
    var _formGroup$get, _formGroup$get2, _formGroup$get3, _formGroup$get4;
    const errors = [];
    // MUAC validation
    const muacValue = (_formGroup$get = formGroup.get('muac')) === null || _formGroup$get === void 0 ? void 0 : _formGroup$get.value;
    if (!muacValue || muacValue.toString().trim() === '') {
      errors.push('MUAC is required');
    }
    // Weight validation
    const weightValue = (_formGroup$get2 = formGroup.get('weight')) === null || _formGroup$get2 === void 0 ? void 0 : _formGroup$get2.value;
    if (!weightValue || weightValue.toString().trim() === '') {
      errors.push('Weight is required');
    }
    // Nutrition status validation
    const nutritionStatus = (_formGroup$get3 = formGroup.get('nutrition_status')) === null || _formGroup$get3 === void 0 ? void 0 : _formGroup$get3.value;
    if (!nutritionStatus || nutritionStatus.toString().trim() === '') {
      errors.push('Nutrition status is required. MUAC must be entered to calculate.');
    }
    // Date validation
    const dateValue = (_formGroup$get4 = formGroup.get('date')) === null || _formGroup$get4 === void 0 ? void 0 : _formGroup$get4.value;
    if (!dateValue || dateValue.toString().trim() === '') {
      errors.push('Measurement date is required');
    } else {
      var _this$measurementPreq4;
      // Check if date is before last measurement
      if (!this.isEditMode && (_this$measurementPreq4 = this.measurementPreqData) !== null && _this$measurementPreq4 !== void 0 && (_this$measurementPreq4 = _this$measurementPreq4.last_measurement) !== null && _this$measurementPreq4 !== void 0 && _this$measurementPreq4.date) {
        const selectedDate = new Date(dateValue);
        const lastMeasurementDate = new Date(this.measurementPreqData.last_measurement.date);
        if (selectedDate <= lastMeasurementDate) {
          errors.push(`Measurement date must be after the last measurement date (${this.measurementPreqData.last_measurement.date})`);
        }
      }
      // Check if date is in the future
      const selectedDate = new Date(dateValue);
      const today = new Date();
      today.setHours(0, 0, 0, 0);
      selectedDate.setHours(0, 0, 0, 0);
      if (selectedDate > today) {
        errors.push('Measurement date cannot be in the future');
      }
    }
    return errors;
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      control === null || control === void 0 || control.markAsTouched();
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormGroup) {
        this.markFormGroupTouched(control);
      }
    });
    this.change.markForCheck();
  }
  getDetailedFormErrors() {
    const errors = [];
    const controls = this.measurementForm.controls;
    Object.keys(controls).forEach(key => {
      const control = controls[key];
      if (control && control.invalid && control.errors) {
        const fieldName = this.getFieldDisplayName(key);
        if (control.errors['required']) {
          errors.push(`${fieldName} is required`);
        }
      }
    });
    return errors.length > 0 ? errors[0] : 'Please check all fields and try again';
  }
  getFieldDisplayName(fieldName) {
    const displayNames = {
      'plw_id': 'PLW ID',
      'date': 'Measurement Date',
      'muac': 'MUAC',
      'weight': 'Weight',
      'nutrition_status': 'Nutrition Status'
    };
    return displayNames[fieldName] || fieldName;
  }
  getAge(dateOfBirth) {
    if (!dateOfBirth) {
      return 'N/A';
    }
    const dob = new Date(dateOfBirth);
    const today = new Date();
    let years = today.getFullYear() - dob.getFullYear();
    let months = today.getMonth() - dob.getMonth();
    if (months < 0) {
      years--;
      months += 12;
    }
    let result = '';
    if (years > 0) {
      result += `${years} Years`;
    }
    if (months > 0) {
      if (result.length > 0) {
        result += ' ';
      }
      result += `${months} Months`;
    }
    return result || '0 Months';
  }
  isFieldInvalid(fieldName) {
    const field = this.measurementForm.get(fieldName);
    return field && field.invalid && (field.dirty || field.touched);
  }
  getNutritionStatusTitle(statusId) {
    var _this$measurementPreq5;
    if (!statusId || !((_this$measurementPreq5 = this.measurementPreqData) !== null && _this$measurementPreq5 !== void 0 && _this$measurementPreq5.nutrition_status)) {
      return '';
    }
    const status = this.measurementPreqData.nutrition_status.find(s => s.id === statusId);
    return status ? status.title : '';
  }
  toggleLastMeasurement() {
    this.isLastMeasurementExpanded = !this.isLastMeasurementExpanded;
  }
}, _PlwMeasurementCreatePage.ctorParameters = () => [{
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder
}, {
  type: src_app_services_plw_measurement_api_service__WEBPACK_IMPORTED_MODULE_3__.PlwMeasurementAPIService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.ActivatedRoute
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ChangeDetectorRef
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.Router
}], _PlwMeasurementCreatePage);
PlwMeasurementCreatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-plw-measurement-create',
  template: _plw_measurement_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_plw_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], PlwMeasurementCreatePage);


/***/ }),

/***/ 70014:
/*!**********************************************!*\
  !*** ./src/app/services/api_base.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   APIBaseService: () => (/* binding */ APIBaseService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./global */ 99328);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
var _APIBaseService;

/* eslint-disable eqeqeq */

/* eslint-disable @typescript-eslint/naming-convention */




let APIBaseService = (_APIBaseService = class APIBaseService {
  constructor(http, g, b, store) {
    this.http = http;
    this.g = g;
    this.b = b;
    this.store = store;
  }
  getHeader(params = {}) {
    // Get token from current user if g.jws is not available
    let token = this.g.jws;
    if (!token) {
      const currentUser = this.b.getCurrentUser();
      token = currentUser === null || currentUser === void 0 ? void 0 : currentUser.token;
    }
    return {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpHeaders({
        Authorization: token
      }),
      params
    };
  }
  errorHandle(err) {
    let message = '';
    let detailedErrors = null;
    // Extract error details from response
    if (err !== null && err !== void 0 && err.error) {
      // Backend error format: {success: false, message: string, data?: object|string}
      message = err.error.message || err.message;
      detailedErrors = err.error.data;
    } else {
      message = err.message;
    }
    // Handle specific HTTP status codes
    switch (err.status) {
      case 0:
        // Network error
        message = 'Failed reaching server!!! Make sure you are connected to internet or camp site network.';
        this.b.errorToast(message);
        break;
      case 400:
        // Bad Request
        message = message || 'Bad request. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 401:
        // Unauthorized - token expired
        message = message || 'Session expired. Please login again.';
        this.b.errorToast(message);
        setTimeout(() => {
          this.b.logout('token_expired');
        }, 3000);
        break;
      case 403:
        // Forbidden
        message = message || 'Access denied. You do not have permission to perform this action.';
        this.b.errorToast(message);
        break;
      case 404:
        // Not Found
        message = message || 'Resource not found.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 422:
        // Validation Error (Unprocessable Entity)
        message = message || 'Validation failed. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 500:
        // Internal Server Error
        message = message || 'Internal server error. Please try again later.';
        this.b.errorToast(message);
        break;
      case 503:
        // Service Unavailable
        message = message || 'Service unavailable. Please try again later.';
        this.b.errorToast(message);
        break;
      default:
        // Other errors
        message = message || 'Unknown error occurred. Make sure you are connected and retry.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
    }
    return Promise.resolve({
      message: this.formatErrorMessage(message, detailedErrors),
      success: false,
      data: detailedErrors
    });
  }
  /**
   * Format error message with detailed validation errors or data
   */
  formatErrorMessage(mainMessage, detailedErrors) {
    if (!detailedErrors) {
      return mainMessage;
    }
    // If detailedErrors is a string (like the data field from backend)
    if (typeof detailedErrors === 'string') {
      return `${mainMessage} - ${detailedErrors}`;
    }
    // If detailedErrors is an object with field-specific errors (validation errors)
    if (typeof detailedErrors === 'object' && !Array.isArray(detailedErrors)) {
      const errorMessages = [mainMessage];
      Object.keys(detailedErrors).forEach(field => {
        const fieldErrors = detailedErrors[field];
        if (Array.isArray(fieldErrors)) {
          fieldErrors.forEach(error => errorMessages.push(`• ${error}`));
        } else if (typeof fieldErrors === 'string') {
          errorMessages.push(`• ${fieldErrors}`);
        }
      });
      return errorMessages.join('\n');
    }
    return mainMessage;
  }
}, _APIBaseService.ctorParameters = () => [{
  type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient
}, {
  type: _global__WEBPACK_IMPORTED_MODULE_0__.GlobalProvider
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_3__.Store
}], _APIBaseService);
APIBaseService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], APIBaseService);


/***/ }),

/***/ 52575:
/*!***********************************************************************!*\
  !*** ./node_modules/rxjs/dist/esm/internal/operators/debounceTime.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounceTime: () => (/* binding */ debounceTime)
/* harmony export */ });
/* harmony import */ var _scheduler_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scheduler/async */ 18473);
/* harmony import */ var _util_lift__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/lift */ 50819);
/* harmony import */ var _OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OperatorSubscriber */ 91687);



function debounceTime(dueTime, scheduler = _scheduler_async__WEBPACK_IMPORTED_MODULE_0__.asyncScheduler) {
  return (0,_util_lift__WEBPACK_IMPORTED_MODULE_1__.operate)((source, subscriber) => {
    let activeTask = null;
    let lastValue = null;
    let lastTime = null;
    const emit = () => {
      if (activeTask) {
        activeTask.unsubscribe();
        activeTask = null;
        const value = lastValue;
        lastValue = null;
        subscriber.next(value);
      }
    };
    function emitWhenIdle() {
      const targetTime = lastTime + dueTime;
      const now = scheduler.now();
      if (now < targetTime) {
        activeTask = this.schedule(undefined, targetTime - now);
        subscriber.add(activeTask);
        return;
      }
      emit();
    }
    source.subscribe((0,_OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__.createOperatorSubscriber)(subscriber, value => {
      lastValue = value;
      lastTime = scheduler.now();
      if (!activeTask) {
        activeTask = scheduler.schedule(emitWhenIdle, dueTime);
        subscriber.add(activeTask);
      }
    }, () => {
      emit();
      subscriber.complete();
    }, undefined, () => {
      lastValue = activeTask = null;
    }));
  });
}

/***/ }),

/***/ 42955:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/plw-measurement-create/plw-measurement-create.page.scss?ngResource ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.measurement-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.measurement-form .form-section {
  margin-bottom: 32px;
}
.measurement-form .form-section:last-child {
  margin-bottom: 0;
}
.measurement-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.measurement-form .section-subtitle ion-icon {
  font-size: 20px;
}
.measurement-form .section-subtitle.collapsible-header {
  cursor: pointer;
  justify-content: space-between;
  padding: 12px;
  background: rgba(73, 144, 226, 0.05);
  border-radius: 8px;
  border-bottom: none;
  transition: all 0.3s ease;
  -webkit-user-select: none;
          user-select: none;
}
.measurement-form .section-subtitle.collapsible-header:hover {
  background: rgba(73, 144, 226, 0.1);
  transform: translateX(2px);
}
.measurement-form .section-subtitle.collapsible-header:active {
  transform: scale(0.98);
}
.measurement-form .section-subtitle.collapsible-header .header-content {
  display: flex;
  align-items: center;
  gap: 8px;
}
.measurement-form .section-subtitle.collapsible-header .collapse-icon {
  font-size: 24px;
  transition: transform 0.3s ease;
}
.measurement-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.measurement-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.measurement-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.measurement-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.measurement-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.measurement-form .form-item.auto-filled-item {
  background: rgba(45, 211, 111, 0.05);
  border-color: rgba(45, 211, 111, 0.2);
}
.measurement-form .form-item.auto-filled-item .auto-filled-input {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
}
.measurement-form .form-item.auto-filled-item ion-label {
  color: var(--ion-color-success) !important;
  font-weight: 600;
}
.measurement-form .form-item.nutrition-status-2 {
  background: rgba(var(--ion-color-warning-rgb), 0.15);
  border-color: rgba(var(--ion-color-warning-rgb), 0.4);
}
.measurement-form .form-item.nutrition-status-2 ion-label {
  color: var(--ion-color-warning-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-2 ion-icon {
  color: var(--ion-color-warning-shade);
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-2 ion-input {
  --color: var(--ion-color-warning-shade);
  color: var(--ion-color-warning-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 {
  background: rgba(var(--ion-color-success-rgb), 0.1);
  border-color: rgba(var(--ion-color-success-rgb), 0.3);
}
.measurement-form .form-item.nutrition-status-3 ion-label {
  color: var(--ion-color-success-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 ion-icon {
  color: var(--ion-color-success-shade);
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 ion-input {
  --color: var(--ion-color-success-shade);
  color: var(--ion-color-success-shade);
  font-weight: 700;
  opacity: 1;
}

.plw-info-card,
.last-measurement-card {
  margin: 16px 0;
}

.last-measurement-card {
  animation: slideDown 0.3s ease-out;
}
.last-measurement-card ion-card {
  background: rgba(73, 144, 226, 0.03);
  border: 1px solid rgba(73, 144, 226, 0.15);
}

@keyframes slideDown {
  from {
    opacity: 0;
    transform: translateY(-10px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.plw-info-card .plw-card,
.plw-info-card .measurement-card,
.last-measurement-card .plw-card,
.last-measurement-card .measurement-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.plw-info-card .info-item,
.last-measurement-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.plw-info-card .info-item:last-child,
.last-measurement-card .info-item:last-child {
  margin-bottom: 0;
}
.plw-info-card .info-item:hover,
.last-measurement-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.plw-info-card .info-item ion-icon,
.last-measurement-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.plw-info-card .item-content,
.last-measurement-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.plw-info-card .item-content .label,
.last-measurement-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.plw-info-card .item-content .value,
.last-measurement-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.plw-info-card .item-content .value:empty::after,
.last-measurement-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-dark);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-primary), transparent);
  border-radius: 1px;
}

@media (min-width: 768px) {
  .measurement-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .submit-btn {
    min-width: 200px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
  .plw-info-card,
  .last-measurement-card {
    margin: 12px 0;
  }
  .plw-info-card .profile-content,
  .last-measurement-card .profile-content {
    padding: 16px;
  }
  .plw-info-card .content-grid ion-col,
  .last-measurement-card .content-grid ion-col {
    padding: 0 3px;
  }
  .plw-info-card .content-grid ion-col:first-child,
  .last-measurement-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .plw-info-card .content-grid ion-col:last-child,
  .last-measurement-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .plw-info-card .info-item,
  .last-measurement-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .plw-info-card .info-item ion-icon,
  .last-measurement-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .plw-info-card .item-content .label,
  .last-measurement-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .plw-info-card .item-content .value,
  .last-measurement-card .item-content .value {
    font-size: 13px;
  }
}
@media (prefers-color-scheme: dark) {
  .form-item.auto-filled-item {
    background: rgba(45, 211, 111, 0.08);
    border-color: rgba(45, 211, 111, 0.3);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
  .plw-card,
  .measurement-card {
    background: rgba(255, 255, 255, 0.05);
    border-color: rgba(255, 255, 255, 0.1);
  }
  .info-item {
    background: rgba(255, 255, 255, 0.03);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .info-item:hover {
    background: rgba(73, 144, 226, 0.08);
    border-color: rgba(73, 144, 226, 0.3);
  }
}
@media (prefers-reduced-motion: reduce) {
  * {
    transition: none !important;
    animation: none !important;
  }
  .last-measurement-card {
    animation: none !important;
  }
  .collapsible-header {
    transition: none !important;
  }
}
@media (prefers-contrast: high) {
  .form-item {
    border-width: 2px;
  }
  .section-subtitle {
    border-bottom-width: 3px;
  }
  ion-label {
    font-weight: 600;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/plw-measurement-create/plw-measurement-create.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAYI;EACE,eAAA;EACA,8BAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,mBAAA;EACA,yBAAA;EACA,yBAAA;UAAA,iBAAA;AAVN;AAYM;EACE,mCAAA;EACA,0BAAA;AAVR;AAaM;EACE,sBAAA;AAXR;AAcM;EACE,aAAA;EACA,mBAAA;EACA,QAAA;AAZR;AAeM;EACE,eAAA;EACA,+BAAA;AAbR;AAkBE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAhBJ;AAkBI;EACE,gBAAA;EACA,4BAAA;AAhBN;AAmBI;EACE,eAAA;EACA,eAAA;AAjBN;AAmBM;EACE,8BAAA;AAjBR;AAoBM;EACE,8BAAA;AAlBR;AAuBI;EACE,oCAAA;EACA,qCAAA;AArBN;AAuBM;EACE,uCAAA;EACA,gBAAA;AArBR;AAwBM;EACE,0CAAA;EACA,gBAAA;AAtBR;AA4BI;EACE,oDAAA;EACA,qDAAA;AA1BN;AA4BM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AA1BR;AA6BM;EACE,qCAAA;EACA,UAAA;AA3BR;AA8BM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AA5BR;AAiCI;EACE,mDAAA;EACA,qDAAA;AA/BN;AAiCM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AA/BR;AAkCM;EACE,qCAAA;EACA,UAAA;AAhCR;AAmCM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AAjCR;;AAwCA;;EAEE,cAAA;AArCF;;AAyCA;EACE,kCAAA;AAtCF;AAwCE;EACE,oCAAA;EACA,0CAAA;AAtCJ;;AA2CA;EACE;IACE,UAAA;IACA,4BAAA;EAxCF;EA0CA;IACE,UAAA;IACA,wBAAA;EAxCF;AACF;AA6CE;;;;EAEE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAzCJ;;AA6CA;EACE,aAAA;AA1CF;;AA6CA;EACE,UAAA;EACA,SAAA;AA1CF;AA4CE;EACE,SAAA;AA1CJ;AA6CE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AA3CJ;AA6CI;EACE,eAAA;EACA,kBAAA;AA3CN;AA8CI;EACE,gBAAA;EACA,iBAAA;AA5CN;;AAiDA;;EAEE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AA9CF;AAgDE;;EACE,gBAAA;AA7CJ;AAgDE;;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AA7CJ;AAgDE;;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AA7CJ;;AAiDA;;EAEE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AA9CF;AAgDE;;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AA7CJ;AAgDE;;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AA7CJ;AA+CI;;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AA5CN;;AAkDA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AA/CF;AAiDE;EACE,gBAAA;AA/CJ;AAiDI;EACE,YAAA;EACA,mBAAA;AA/CN;;AAqDA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAlDF;AAoDE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AAlDJ;AAqDE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AAnDJ;;AAwDA;EACE,oBAAA;EACA,kBAAA;AArDF;AAuDE;EACE,8BAAA;EACA,gBAAA;EACA,eAAA;AArDJ;;AAyDA;EACE,oBAAA;EACA,kBAAA;AAtDF;;AA0DA;EACE,qCAAA;AAvDF;AAyDE;EACE,8BAAA;AAvDJ;;AA2DA;EACE,sCAAA;AAxDF;;AA4DA;EACE,gBAAA;AAzDF;AA2DE;EACE,cAAA;EACA,oBAAA;AAzDJ;;AA8DA;EACE,kBAAA;AA3DF;AA6DE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AA3DJ;;AAgEA;EACE;IACE,gBAAA;EA7DF;EAgEA;IACE,gBAAA;EA9DF;EAiEA;IACE,eAAA;EA/DF;EAiEE;IACE,eAAA;EA/DJ;EAmEA;IACE,eAAA;EAjEF;EAmEE;IACE,eAAA;EAjEJ;EAqEA;IACE,gBAAA;EAnEF;EAqEE;IACE,gBAAA;EAnEJ;EAuEA;IACE,kBAAA;EArEF;EAuEE;IACE,WAAA;IACA,YAAA;EArEJ;EAwEE;IACE,eAAA;EAtEJ;AACF;AA2EA;EACE;IACE,eAAA;EAzEF;EA2EE;IACE,eAAA;EAzEJ;EA6EA;IACE,eAAA;EA3EF;EA6EE;IACE,eAAA;EA3EJ;EA+EA;IACE,sBAAA;IACA,gBAAA;EA7EF;EA+EE;IACE,WAAA;IACA,eAAA;EA7EJ;EAiFA;IACE,kBAAA;EA/EF;EAiFE;IACE,eAAA;EA/EJ;EAmFA;;IAEE,cAAA;EAjFF;EAmFE;;IACE,aAAA;EAhFJ;EAoFI;;IACE,cAAA;EAjFN;EAmFM;;IACE,eAAA;IACA,kBAAA;EAhFR;EAmFM;;IACE,gBAAA;IACA,iBAAA;EAhFR;EAqFE;;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAlFJ;EAoFI;;IACE,eAAA;IACA,WAAA;EAjFN;EAsFI;;IACE,eAAA;IACA,qBAAA;EAnFN;EAsFI;;IACE,eAAA;EAnFN;AACF;AAyFA;EACE;IACE,oCAAA;IACA,qCAAA;EAvFF;EA0FA;;IAEE,6BAAA;EAxFF;EA2FA;;IAEE,qCAAA;IACA,sCAAA;EAzFF;EA4FA;IACE,qCAAA;IACA,uCAAA;EA1FF;EA4FE;IACE,oCAAA;IACA,qCAAA;EA1FJ;AACF;AA+FA;EACE;IACE,2BAAA;IACA,0BAAA;EA7FF;EAgGA;IACE,0BAAA;EA9FF;EAiGA;IACE,2BAAA;EA/FF;AACF;AAmGA;EACE;IACE,iBAAA;EAjGF;EAoGA;IACE,wBAAA;EAlGF;EAqGA;IACE,gBAAA;EAnGF;AACF","sourcesContent":["// PLW Measurement Create Form Styles - Following Measurement Create Design Patterns\n\n// Container styling\n.measurement-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.measurement-form {\n  .form-section {\n    margin-bottom: 32px;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n\n    ion-icon {\n      font-size: 20px;\n    }\n\n    &.collapsible-header {\n      cursor: pointer;\n      justify-content: space-between;\n      padding: 12px;\n      background: rgba(73, 144, 226, 0.05);\n      border-radius: 8px;\n      border-bottom: none;\n      transition: all 0.3s ease;\n      user-select: none;\n\n      &:hover {\n        background: rgba(73, 144, 226, 0.1);\n        transform: translateX(2px);\n      }\n\n      &:active {\n        transform: scale(0.98);\n      }\n\n      .header-content {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n      }\n\n      .collapse-icon {\n        font-size: 24px;\n        transition: transform 0.3s ease;\n      }\n    }\n  }\n\n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n\n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n\n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n\n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n\n    // Auto-filled item styling\n    &.auto-filled-item {\n      background: rgba(45, 211, 111, 0.05);\n      border-color: rgba(45, 211, 111, 0.2);\n\n      .auto-filled-input {\n        --color: var(--ion-color-success-shade);\n        font-weight: 500;\n      }\n\n      ion-label {\n        color: var(--ion-color-success) !important;\n        font-weight: 600;\n      }\n    }\n\n    // Nutrition status color styling\n    // MAM - ID: 2 (Warning/Yellow-Orange)\n    &.nutrition-status-2 {\n      background: rgba(var(--ion-color-warning-rgb), 0.15);\n      border-color: rgba(var(--ion-color-warning-rgb), 0.4);\n\n      ion-label {\n        color: var(--ion-color-warning-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-warning-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-warning-shade);\n        color: var(--ion-color-warning-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // NORMAL - ID: 3 (Success/Green)\n    &.nutrition-status-3 {\n      background: rgba(var(--ion-color-success-rgb), 0.1);\n      border-color: rgba(var(--ion-color-success-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-success-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-success-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-success-shade);\n        color: var(--ion-color-success-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n  }\n}\n\n// PLW Information Card styling\n.plw-info-card,\n.last-measurement-card {\n  margin: 16px 0;\n}\n\n// Last measurement card specific styling\n.last-measurement-card {\n  animation: slideDown 0.3s ease-out;\n\n  ion-card {\n    background: rgba(73, 144, 226, 0.03);\n    border: 1px solid rgba(73, 144, 226, 0.15);\n  }\n}\n\n// Slide down animation\n@keyframes slideDown {\n  from {\n    opacity: 0;\n    transform: translateY(-10px);\n  }\n  to {\n    opacity: 1;\n    transform: translateY(0);\n  }\n}\n\n.plw-info-card,\n.last-measurement-card {\n  .plw-card,\n  .measurement-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.plw-info-card .info-item,\n.last-measurement-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n  }\n}\n\n.plw-info-card .item-content,\n.last-measurement-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n\n  .submit-btn {\n    min-width: 180px;\n\n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n\n  &[readonly] {\n    --color: var(--ion-color-dark);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n\n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n\n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Enhanced visual indicators for headers\n.section-header .section-title {\n  position: relative;\n\n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-primary), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .measurement-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n\n  .section-title {\n    font-size: 24px;\n\n    ion-icon {\n      font-size: 28px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .form-actions {\n    margin-top: 32px;\n\n    .submit-btn {\n      min-width: 200px;\n    }\n  }\n\n  .loading-container {\n    padding: 80px 40px;\n\n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n\n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 14px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n\n  .loading-container {\n    padding: 40px 16px;\n\n    p {\n      font-size: 12px;\n    }\n  }\n\n  .plw-info-card,\n  .last-measurement-card {\n    margin: 12px 0;\n\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .form-item.auto-filled-item {\n    background: rgba(45, 211, 111, 0.08);\n    border-color: rgba(45, 211, 111, 0.3);\n  }\n\n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n\n  .plw-card,\n  .measurement-card {\n    background: rgba(255, 255, 255, 0.05);\n    border-color: rgba(255, 255, 255, 0.1);\n  }\n\n  .info-item {\n    background: rgba(255, 255, 255, 0.03);\n    border-color: rgba(255, 255, 255, 0.08);\n\n    &:hover {\n      background: rgba(73, 144, 226, 0.08);\n      border-color: rgba(73, 144, 226, 0.3);\n    }\n  }\n}\n\n// Accessibility improvements\n@media (prefers-reduced-motion: reduce) {\n  * {\n    transition: none !important;\n    animation: none !important;\n  }\n\n  .last-measurement-card {\n    animation: none !important;\n  }\n\n  .collapsible-header {\n    transition: none !important;\n  }\n}\n\n// High contrast mode\n@media (prefers-contrast: high) {\n  .form-item {\n    border-width: 2px;\n  }\n\n  .section-subtitle {\n    border-bottom-width: 3px;\n  }\n\n  ion-label {\n    font-weight: 600;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 62395:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/plw-measurement-create/plw-measurement-create.page.html?ngResource ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"'/woman-detail/' + plwId\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ isEditMode ? 'Edit Measurement' : 'Add Measurement' }}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"measurementPreqData && plw_info; else loading\" class=\"measurement-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"fitness-outline\" color=\"primary\"></ion-icon>\n        {{ isEditMode ? 'Edit PLW Measurement' : 'Add PLW Measurement' }}\n      </h2>\n    </div>\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"measurementForm\" (ngSubmit)=\"onSubmit()\" class=\"measurement-form\">\n\n            <!-- PLW Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                PLW Information\n              </h3>\n\n              <!-- PLW Information Card -->\n              <div class=\"plw-info-card\">\n                <ion-card class=\"plw-card\">\n                  <div class=\"profile-content\">\n                    <ion-grid class=\"content-grid\">\n                      <ion-row>\n                        <!-- Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Name</span>\n                              <span class=\"value\">{{ plw_info?.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">FCN</span>\n                              <span class=\"value\">{{ plw_info?.fcn || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Progress ID</span>\n                              <span class=\"value\">{{ plw_info?.progress_id || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"calendar-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Date of Birth</span>\n                              <span class=\"value\">{{ plw_info?.date_of_birth || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"hourglass-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Age</span>\n                              <span class=\"value\">{{ getAge(plw_info?.date_of_birth) }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Husband</span>\n                              <span class=\"value\">{{ plw_info?.husband || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n                    </ion-grid>\n                  </div>\n                </ion-card>\n              </div>\n\n            </div>\n\n            <!-- Last Measurement Card -->\n            <div class=\"form-section\" *ngIf=\"measurementPreqData?.last_measurement && !isEditMode\">\n              <h3 class=\"section-subtitle collapsible-header\" (click)=\"toggleLastMeasurement()\">\n                <div class=\"header-content\">\n                  <ion-icon name=\"time-outline\" color=\"primary\"></ion-icon>\n                  <span>Last Measurement</span>\n                </div>\n                <ion-icon\n                  [name]=\"isLastMeasurementExpanded ? 'chevron-up-outline' : 'chevron-down-outline'\"\n                  color=\"primary\"\n                  class=\"collapse-icon\">\n                </ion-icon>\n              </h3>\n\n              <ion-card class=\"last-measurement-card\" *ngIf=\"isLastMeasurementExpanded\">\n                <ion-card-content>\n                  <ion-grid>\n                    <ion-row>\n                      <ion-col size=\"6\">\n                        <div class=\"info-item\">\n                          <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Date</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.date }}</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"resize-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">MUAC</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.muac }} cm</span>\n                          </div>\n                        </div>\n                      </ion-col>\n\n                      <ion-col size=\"6\">\n                        <div class=\"info-item\">\n                          <ion-icon name=\"scale-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Weight</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.weight }} kg</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"medical-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Nutrition Status</span>\n                            <span class=\"value\">{{ getNutritionStatusTitle(measurementPreqData.last_measurement.nutrition_status) }}</span>\n                          </div>\n                        </div>\n                      </ion-col>\n                    </ion-row>\n                  </ion-grid>\n                </ion-card-content>\n              </ion-card>\n            </div>\n\n            <!-- Measurement Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"fitness-outline\" color=\"primary\"></ion-icon>\n                Anthropometric Measurement\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('date')\">\n                <ion-icon slot=\"start\" name=\"calendar\" [color]=\"isFieldInvalid('date') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Measurement Date *</ion-label>\n                <ion-input formControlName=\"date\" type=\"date\" [min]=\"minDate\" [max]=\"today\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"measurementPreqData?.last_measurement\">Must be after last measurement: {{ measurementPreqData.last_measurement.date }}</ion-note>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"!measurementPreqData?.last_measurement\">Cannot be in the future</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('muac')\">\n                <ion-icon slot=\"start\" name=\"resize-outline\" [color]=\"isFieldInvalid('muac') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">MUAC (cm) *</ion-label>\n                <ion-input formControlName=\"muac\" type=\"number\" step=\"0.1\" placeholder=\"Enter MUAC\" (ionInput)=\"onMuacChange($event)\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"measurementPreqData?.muac_cutoff && !isFieldInvalid('muac')\">\n                  MAM: &lt;={{ measurementPreqData.muac_cutoff.woman_mam }}cm\n                </ion-note>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('muac')\">MUAC is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('weight')\">\n                <ion-icon slot=\"start\" name=\"scale-outline\" [color]=\"isFieldInvalid('weight') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Weight (kg) *</ion-label>\n                <ion-input formControlName=\"weight\" type=\"number\" step=\"0.1\" placeholder=\"Enter weight\" (ionInput)=\"onWeightChange($event)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('weight')\">Weight is required</ion-note>\n              </ion-item>\n\n              <!-- Hidden field for form value -->\n              <input type=\"hidden\" formControlName=\"nutrition_status\">\n\n              <ion-item class=\"form-item auto-filled-item nutrition-status-field\" [ngClass]=\"'nutrition-status-' + measurementForm.get('nutrition_status').value\">\n                <ion-icon slot=\"start\" name=\"medical-outline\"></ion-icon>\n                <ion-label position=\"stacked\">Nutrition Status (Auto-selected)</ion-label>\n                <ion-input type=\"text\" [readonly]=\"true\" class=\"auto-filled-input\" [value]=\"getNutritionStatusTitle(measurementForm.get('nutrition_status').value)\"></ion-input>\n              </ion-item>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\">\n                <ion-icon name=\"save-outline\" slot=\"start\"></ion-icon>\n                {{ isEditMode ? 'Update Measurement' : 'Save Measurement' }}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\"></ion-spinner>\n      <p>Loading...</p>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_plw-measurement-create_plw-measurement-create_module_ts-src_app_services_api_ba-975ed7.js.map