(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_offline-survey-list_offline-survey-list_module_ts"],{

/***/ 82247:
/*!*********************************************************************************!*\
  !*** ./src/app/pages/offline-survey-list/offline-survey-list-routing.module.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineSurveyListPageRoutingModule: () => (/* binding */ OfflineSurveyListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _offline_survey_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offline-survey-list.page */ 80457);




const routes = [{
  path: '',
  component: _offline_survey_list_page__WEBPACK_IMPORTED_MODULE_0__.OfflineSurveyListPage
}];
let OfflineSurveyListPageRoutingModule = class OfflineSurveyListPageRoutingModule {};
OfflineSurveyListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], OfflineSurveyListPageRoutingModule);


/***/ }),

/***/ 44982:
/*!*************************************************************************!*\
  !*** ./src/app/pages/offline-survey-list/offline-survey-list.module.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineSurveyListPageModule: () => (/* binding */ OfflineSurveyListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _offline_survey_list_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offline-survey-list-routing.module */ 82247);
/* harmony import */ var _offline_survey_list_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offline-survey-list.page */ 80457);







let OfflineSurveyListPageModule = class OfflineSurveyListPageModule {};
OfflineSurveyListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _offline_survey_list_routing_module__WEBPACK_IMPORTED_MODULE_0__.OfflineSurveyListPageRoutingModule],
  declarations: [_offline_survey_list_page__WEBPACK_IMPORTED_MODULE_1__.OfflineSurveyListPage]
})], OfflineSurveyListPageModule);


/***/ }),

/***/ 80457:
/*!***********************************************************************!*\
  !*** ./src/app/pages/offline-survey-list/offline-survey-list.page.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineSurveyListPage: () => (/* binding */ OfflineSurveyListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _offline_survey_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offline-survey-list.page.html?ngResource */ 99619);
/* harmony import */ var _offline_survey_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./offline-survey-list.page.scss?ngResource */ 65151);
/* harmony import */ var _offline_survey_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_offline_survey_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/services/survey_form_api.service */ 55856);
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/animations */ 47172);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var src_app_state_selectors_user_selector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/state/selectors/user.selector */ 77451);
/* harmony import */ var src_app_services_connectivity_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/services/connectivity.service */ 65065);
/* harmony import */ var src_app_services_offline_sync_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/services/offline-sync.service */ 42439);

var _OfflineSurveyListPage;














let OfflineSurveyListPage = (_OfflineSurveyListPage = class OfflineSurveyListPage {
  constructor(router, alertController, loadingController, b, surveyApi, store, connectivity, cdr, offlineSyncService) {
    this.router = router;
    this.alertController = alertController;
    this.loadingController = loadingController;
    this.b = b;
    this.surveyApi = surveyApi;
    this.store = store;
    this.connectivity = connectivity;
    this.cdr = cdr;
    this.offlineSyncService = offlineSyncService;
    this.savedAssessments = [];
    this.isLoading = false;
    this.syncingBeneficiaries = new Set();
    this.syncingAssessment = null;
    this.searchTerms = {};
    this.isOnline = true;
  }
  ngOnInit() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.loadSavedAssessments();
      yield _this.setupNetworkListener();
    })();
  }
  ionViewWillEnter() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.loadSavedAssessments();
      // Update connectivity status when page is entered
      _this2.isOnline = yield _this2.connectivity.checkServerConnectivity(false);
    })();
  }
  loadSavedAssessments() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // First check INF compatibility
        const user = yield _this3.getCurrentUser();
        if (user) {
          const infCompatible = yield _this3.b.checkInfCompatibility(user);
          if (!infCompatible) {
            // Different INF - clear data and show message
            yield _this3.b.clearOfflineAssessments();
            _this3.savedAssessments = [];
            _this3.b.toast('Previous community assessments from different facility have been cleared.');
            return;
          }
        }
        const saved = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: 'saved_offline_assessments'
        });
        if (saved.value) {
          _this3.savedAssessments = JSON.parse(saved.value);
          // Load beneficiary data for each assessment and track completion status
          for (let assessment of _this3.savedAssessments) {
            try {
              // Load the full offline data including beneficiaries
              const offlineData = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
                key: assessment.key
              });
              if (offlineData.value) {
                const data = JSON.parse(offlineData.value);
                assessment.beneficiaries = data.beneficiaries || [];
                assessment.collapsed = false; // Initially expanded
                // Load responses to track completion
                const responsesKey = `responses_${assessment.key}`;
                const responses = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
                  key: responsesKey
                });
                assessment.completedResponses = responses.value ? JSON.parse(responses.value) : [];
                // Initialize sync status for each beneficiary
                if (assessment.beneficiaries) {
                  for (let beneficiary of assessment.beneficiaries) {
                    beneficiary.syncStatus = _this3.getBeneficiarySyncStatus(assessment, beneficiary.id);
                  }
                }
                // Initialize search term for this assessment
                _this3.searchTerms[assessment.key] = '';
              }
            } catch (error) {
              assessment.beneficiaries = [];
              assessment.completedResponses = [];
            }
          }
        }
      } catch (error) {}
    })();
  }
  startAssessment(assessment) {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const offlineData = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: assessment.key
        });
        if (offlineData.value) {
          const data = JSON.parse(offlineData.value);
          // Verify required data exists - handle both new and legacy data structures
          let hasValidSchema = false;
          if (data.formSchema && data.formSchema.schema) {
            hasValidSchema = true;
          } else if (data.assessment && data.assessment.schema) {
            // Legacy structure - fix it
            data.formSchema = {
              id: data.assessment.id,
              title: data.assessment.title,
              schema: data.assessment.schema
            };
            hasValidSchema = true;
          }
          if (!hasValidSchema) {
            _this4.b.errorToast('Assessment form data is incomplete. Please re-download this assessment.');
            return;
          }
          // Navigate to survey-form page with offline assessment data
          _this4.router.navigate(['/survey-form', data.formSchema.id], {
            state: {
              beneficiary_id: null,
              // Will be set when selecting specific beneficiary
              beneficiary_type: _this4.getDefaultBeneficiaryType(data),
              // Determine based on available beneficiaries
              edit_mode: false,
              mandatoryForm: false,
              offlineMode: true,
              offlineAssessment: data,
              assessmentKey: assessment.key,
              prefillData: {}
            }
          });
        } else {
          _this4.b.errorToast('Assessment data not found. Please re-download the assessment.');
        }
      } catch (error) {
        _this4.b.errorToast('Failed to load assessment data: ' + error.message);
      }
    })();
  }
  clearAllData() {
    var _this5 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const alert = yield _this5.alertController.create({
        header: 'Clear All Data',
        message: 'This will delete all community assessments and pending sync data. This action cannot be undone.',
        buttons: ['Cancel', {
          text: 'Clear All',
          role: 'destructive',
          handler: function () {
            var _ref = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
              try {
                // Clear all saved assessments
                for (const assessment of _this5.savedAssessments) {
                  yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
                    key: assessment.key
                  });
                }
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
                  key: 'saved_offline_assessments'
                });
                _this5.savedAssessments = [];
                // Notify that offline assessments have changed
                _this5.b.notifyOfflineAssessmentChange();
                _this5.b.toast('All offline data cleared');
              } catch (error) {
                _this5.b.errorToast('Failed to clear data');
              }
            });
            return function handler() {
              return _ref.apply(this, arguments);
            };
          }()
        }]
      });
      yield alert.present();
    })();
  }
  getSyncedCount(assessment) {
    var _assessment$completed;
    const syncedResponses = ((_assessment$completed = assessment.completedResponses) === null || _assessment$completed === void 0 ? void 0 : _assessment$completed.filter(response => response.synced === true)) || [];
    return syncedResponses.length;
  }
  getCompletedCount(assessment) {
    var _assessment$completed2;
    return ((_assessment$completed2 = assessment.completedResponses) === null || _assessment$completed2 === void 0 ? void 0 : _assessment$completed2.length) || 0;
  }
  toggleAssessmentCard(assessment) {
    assessment.collapsed = !assessment.collapsed;
  }
  hasAnyCompleted(assessment) {
    return assessment.completedResponses && assessment.completedResponses.length > 0;
  }
  hasCompletedUnsynced(assessment) {
    if (!assessment.completedResponses || assessment.completedResponses.length === 0) {
      return false;
    }
    return assessment.completedResponses.some(response => !response.synced);
  }
  getUnsyncedCompletedCount(assessment) {
    if (!assessment.completedResponses) {
      return 0;
    }
    return assessment.completedResponses.filter(response => !response.synced).length;
  }
  canMarkAsComplete(assessment) {
    // Can mark as complete if:
    // 1. No completed responses (can mark complete without doing any assessments) OR
    // 2. All completed responses are synced
    // 3. Not currently syncing
    if (!assessment.completedResponses || assessment.completedResponses.length === 0) {
      return this.syncingAssessment !== assessment.key;
    }
    const allSynced = assessment.completedResponses.every(response => response.synced);
    return allSynced && this.syncingAssessment !== assessment.key;
  }
  syncCompletedAssessments(assessment) {
    var _this6 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _assessment$completed3;
      if (_this6.syncingAssessment === assessment.key) {
        return;
      }
      const unsyncedResponses = ((_assessment$completed3 = assessment.completedResponses) === null || _assessment$completed3 === void 0 ? void 0 : _assessment$completed3.filter(response => !response.synced)) || [];
      if (unsyncedResponses.length === 0) {
        _this6.b.toast('No completed assessments to sync');
        return;
      }
      const alert = yield _this6.alertController.create({
        header: 'Sync Completed Assessments',
        message: `This will sync ${unsyncedResponses.length} completed assessment(s) for "${assessment.title}". Continue?`,
        buttons: [{
          text: 'Cancel',
          role: 'cancel'
        }, {
          text: 'Sync',
          handler: function () {
            var _ref2 = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
              yield _this6.syncAllResponses(assessment, unsyncedResponses);
            });
            return function handler() {
              return _ref2.apply(this, arguments);
            };
          }()
        }]
      });
      yield alert.present();
    })();
  }
  markAssessmentComplete(assessment) {
    var _this7 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const alert = yield _this7.alertController.create({
        header: 'Mark Assessment Complete',
        message: `This will mark "${assessment.title}" as complete and remove it from offline storage. This action cannot be undone.`,
        buttons: [{
          text: 'Cancel',
          role: 'cancel'
        }, {
          text: 'Mark Complete',
          role: 'destructive',
          handler: function () {
            var _ref3 = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
              try {
                // Remove from stored assessments list
                _this7.savedAssessments = _this7.savedAssessments.filter(a => a.key !== assessment.key);
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
                  key: 'saved_offline_assessments',
                  value: JSON.stringify(_this7.savedAssessments)
                });
                // Remove the actual offline data
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
                  key: assessment.key
                });
                // Remove associated responses
                const responsesKey = `responses_${assessment.key}`;
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
                  key: responsesKey
                });
                // Notify that offline assessments have changed
                _this7.b.notifyOfflineAssessmentChange();
                _this7.b.toast('Assessment marked as complete and removed');
              } catch (error) {
                _this7.b.errorToast('Failed to mark assessment as complete');
              }
            });
            return function handler() {
              return _ref3.apply(this, arguments);
            };
          }()
        }]
      });
      yield alert.present();
    })();
  }
  syncAllResponses(assessment, unsyncedResponses) {
    var _this8 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this8.syncingAssessment = assessment.key;
        // Show loading indicator
        const loading = yield _this8.loadingController.create({
          message: `Syncing responses...`,
          backdropDismiss: false
        });
        yield loading.present();
        // Use the simplified OfflineSyncService
        const result = yield _this8.offlineSyncService.syncAssessmentResponses(assessment.key, false);
        yield loading.dismiss();
        // Reload assessment data to reflect actual sync status
        yield _this8.loadSavedAssessments();
        // Show completion message with better feedback
        if (result.failed === 0 && result.synced > 0) {
          _this8.b.toast(`All ${result.synced} responses synced successfully!`);
        } else if (result.synced > 0) {
          _this8.b.errorToast(`Partially synced: ${result.synced} succeeded, ${result.failed} failed due to server issues.`);
        } else {
          _this8.b.errorToast(`Failed to sync responses. Please check your internet connection and try again.`);
        }
      } catch (error) {
        _this8.b.errorToast('Sync failed due to connection issues. Please check your internet connection and try again.');
      } finally {
        _this8.syncingAssessment = null;
        // Dismiss loading if still present
        try {
          yield _this8.loadingController.dismiss();
        } catch (e) {
          // Loading might already be dismissed
        }
      }
    })();
  }
  getBeneficiaryStatus(assessment, beneficiaryId) {
    var _assessment$completed4;
    const completedResponse = (_assessment$completed4 = assessment.completedResponses) === null || _assessment$completed4 === void 0 ? void 0 : _assessment$completed4.find(response => response.beneficiary_id === beneficiaryId);
    const isCompleted = !!completedResponse;
    const isSyncing = this.syncingBeneficiaries.has(`${assessment.key}_${beneficiaryId}`);
    const isSynced = (completedResponse === null || completedResponse === void 0 ? void 0 : completedResponse.synced) || false;
    if (isSyncing) {
      return {
        completed: true,
        synced: false,
        text: 'Syncing...',
        color: 'warning',
        icon: 'sync-outline'
      };
    } else if (isCompleted && isSynced) {
      return {
        completed: true,
        synced: true,
        text: 'Synced',
        color: 'success',
        icon: 'cloud-done-outline'
      };
    } else if (isCompleted && !isSynced) {
      return {
        completed: true,
        synced: false,
        text: 'Ready to Sync',
        color: 'tertiary',
        icon: 'cloud-upload-outline'
      };
    } else {
      return {
        completed: false,
        synced: false,
        text: 'Pending',
        color: 'medium',
        icon: 'time-outline'
      };
    }
  }
  getBeneficiarySyncStatus(assessment, beneficiaryId) {
    var _assessment$completed5;
    const completedResponse = (_assessment$completed5 = assessment.completedResponses) === null || _assessment$completed5 === void 0 ? void 0 : _assessment$completed5.find(response => response.beneficiary_id === beneficiaryId);
    return (completedResponse === null || completedResponse === void 0 ? void 0 : completedResponse.synced) || false;
  }
  startBeneficiaryAssessment(assessment, beneficiary) {
    var _this9 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // Load the full offline data
        const offlineData = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: assessment.key
        });
        if (offlineData.value) {
          const data = JSON.parse(offlineData.value);
          // Verify required data exists - handle both new and legacy data structures
          let hasValidSchema = false;
          if (data.formSchema && data.formSchema.schema) {
            hasValidSchema = true;
          } else if (data.assessment && data.assessment.schema) {
            // Legacy structure - fix it
            data.formSchema = {
              id: data.assessment.id,
              title: data.assessment.title,
              schema: data.assessment.schema
            };
            hasValidSchema = true;
          }
          if (!hasValidSchema) {
            _this9.b.errorToast('Assessment form data is incomplete. Please re-download this assessment.');
            return;
          }
          // Determine beneficiary type based on the data structure
          const beneficiaryType = _this9.getBeneficiaryType(beneficiary);
          // Navigate to survey-form page with specific beneficiary
          _this9.router.navigate(['/survey-form', data.formSchema.id], {
            state: {
              beneficiary_id: beneficiary.id,
              beneficiary_type: beneficiaryType,
              edit_mode: false,
              mandatoryForm: false,
              offlineMode: true,
              offlineAssessment: data,
              assessmentKey: assessment.key,
              specificBeneficiary: beneficiary,
              prefillData: beneficiary.prefill_data || {}
            }
          });
        } else {
          _this9.b.errorToast('Assessment data not found. Please re-download the assessment.');
        }
      } catch (error) {
        _this9.b.errorToast('Failed to load assessment data: ' + error.message);
      }
    })();
  }
  getSubBlocksDisplay(assessment) {
    // Handle both new multi-select structure and legacy single sub-block
    if (assessment.subBlocks) {
      // New structure - could be array of sub-blocks or comma-separated string
      if (Array.isArray(assessment.subBlocks)) {
        return assessment.subBlocks.map(sb => sb.title || sb).join(', ');
      } else if (typeof assessment.subBlocks === 'string') {
        return assessment.subBlocks;
      }
      return assessment.subBlocks;
    } else if (assessment.subBlock) {
      // Legacy structure - single sub-block
      return assessment.subBlock;
    } else {
      return 'All Sub-blocks';
    }
  }
  // Helper methods for beneficiary type handling
  getBeneficiaryType(beneficiary) {
    // Check for new structure first
    if (beneficiary.beneficiaryType) {
      return beneficiary.beneficiaryType;
    }
    // Check for explicit type field
    if (beneficiary.type) {
      return beneficiary.type;
    }
    // Determine type based on available fields
    if (beneficiary.isPregnant !== undefined || beneficiary.isLactating !== undefined || beneficiary.husbandName) {
      return 'plw';
    }
    // Default to child
    return 'child';
  }
  getDefaultBeneficiaryType(data) {
    if (!data.beneficiaries || data.beneficiaries.length === 0) {
      return 'child'; // Default fallback
    }
    // Return the type of the first beneficiary
    return this.getBeneficiaryType(data.beneficiaries[0]);
  }
  hasChildBeneficiaries(assessment) {
    var _assessment$beneficia;
    return ((_assessment$beneficia = assessment.beneficiaries) === null || _assessment$beneficia === void 0 ? void 0 : _assessment$beneficia.some(b => this.getBeneficiaryType(b) === 'child')) || false;
  }
  hasPlwBeneficiaries(assessment) {
    var _assessment$beneficia2;
    return ((_assessment$beneficia2 = assessment.beneficiaries) === null || _assessment$beneficia2 === void 0 ? void 0 : _assessment$beneficia2.some(b => this.getBeneficiaryType(b) === 'plw')) || false;
  }
  hasMixedBeneficiaryTypes(assessment) {
    return this.hasChildBeneficiaries(assessment) && this.hasPlwBeneficiaries(assessment);
  }
  getChildBeneficiaryIndex(assessment, globalIndex) {
    if (!assessment.beneficiaries) return 0;
    let childIndex = 0;
    for (let i = 0; i < globalIndex; i++) {
      if (this.getBeneficiaryType(assessment.beneficiaries[i]) === 'child') {
        childIndex++;
      }
    }
    return childIndex;
  }
  getPlwBeneficiaryIndex(assessment, globalIndex) {
    if (!assessment.beneficiaries) return 0;
    let plwIndex = 0;
    for (let i = 0; i < globalIndex; i++) {
      if (this.getBeneficiaryType(assessment.beneficiaries[i]) === 'plw') {
        plwIndex++;
      }
    }
    return plwIndex;
  }
  formatDisability(disability) {
    if (!disability) return 'No';
    if (typeof disability === 'boolean') return disability ? 'Yes' : 'No';
    if (typeof disability === 'string') {
      const lower = disability.toLowerCase();
      if (lower === 'yes' || lower === 'true' || lower === '1') return 'Yes';
      if (lower === 'no' || lower === 'false' || lower === '0') return 'No';
      return disability;
    }
    return 'No';
  }
  // Action button methods for beneficiaries
  getActionButtonColor(assessment, beneficiaryId) {
    const status = this.getBeneficiaryStatus(assessment, beneficiaryId);
    if (status.synced) {
      return 'success'; // Synced - view only
    } else if (status.completed) {
      return 'warning'; // Redo assessment
    } else {
      return 'primary'; // Start assessment
    }
  }
  getActionButtonIcon(assessment, beneficiaryId) {
    const status = this.getBeneficiaryStatus(assessment, beneficiaryId);
    if (status.synced) {
      return 'checkmark-circle-outline'; // Synced
    } else if (status.completed) {
      return 'refresh-outline'; // Redo
    } else {
      return 'clipboard-outline'; // Start
    }
  }
  getActionButtonTitle(assessment, beneficiaryId) {
    const status = this.getBeneficiaryStatus(assessment, beneficiaryId);
    if (status.synced) {
      return 'Assessment completed and synced - cannot be redone';
    } else if (status.completed) {
      return 'Redo assessment for this beneficiary';
    } else {
      return 'Start assessment for this beneficiary';
    }
  }
  getActionButtonText(assessment, beneficiaryId) {
    const status = this.getBeneficiaryStatus(assessment, beneficiaryId);
    if (status.synced) {
      return 'Synced';
    } else if (status.completed) {
      return 'Redo';
    } else {
      return 'Start';
    }
  }
  isActionButtonDisabled(assessment, beneficiaryId) {
    const status = this.getBeneficiaryStatus(assessment, beneficiaryId);
    return status.synced; // Disable if already synced
  }
  handleBeneficiaryAction(assessment, beneficiary) {
    var _this0 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const status = _this0.getBeneficiaryStatus(assessment, beneficiary.id);
      if (status.synced) {
        _this0.b.toast('This assessment has been synced and cannot be redone');
        return;
      }
      // Start or redo the assessment
      yield _this0.startBeneficiaryAssessment(assessment, beneficiary);
    })();
  }
  // Search functionality
  getSearchTerm(assessmentKey) {
    return this.searchTerms[assessmentKey] || '';
  }
  onSearchChange(assessmentKey, searchTerm) {
    this.searchTerms[assessmentKey] = searchTerm.toLowerCase();
  }
  getFilteredBeneficiaries(assessment, beneficiaryType) {
    if (!assessment.beneficiaries) {
      return [];
    }
    const searchTerm = this.getSearchTerm(assessment.key);
    let filtered = assessment.beneficiaries.filter(beneficiary => this.getBeneficiaryType(beneficiary) === beneficiaryType);
    if (searchTerm) {
      filtered = filtered.filter(beneficiary => {
        const searchableFields = [beneficiary.fcn, beneficiary.displayName || beneficiary.name, beneficiary.fatherName, beneficiary.motherName, beneficiary.husbandName, beneficiary.householdNo, beneficiary.subBlock || beneficiary.subBlockTitle];
        return searchableFields.some(field => field && field.toString().toLowerCase().includes(searchTerm));
      });
    }
    return filtered;
  }
  getFilteredChildBeneficiaryIndex(assessment, beneficiary) {
    const filteredChildren = this.getFilteredBeneficiaries(assessment, 'child');
    return filteredChildren.findIndex(b => b.id === beneficiary.id);
  }
  getFilteredPlwBeneficiaryIndex(assessment, beneficiary) {
    const filteredPlw = this.getFilteredBeneficiaries(assessment, 'plw');
    return filteredPlw.findIndex(b => b.id === beneficiary.id);
  }
  clearSearch(assessmentKey) {
    this.searchTerms[assessmentKey] = '';
  }
  /**
   * Get current user from store
   */
  getCurrentUser() {
    var _this1 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return new Promise(resolve => {
        _this1.store.select(src_app_state_selectors_user_selector__WEBPACK_IMPORTED_MODULE_6__.retrieveUserSelector).subscribe(data => {
          resolve((data === null || data === void 0 ? void 0 : data.user) || null);
        }).unsubscribe();
      });
    })();
  }
  setupNetworkListener() {
    var _this10 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Check if our target server is reachable by pinging it
      _this10.isOnline = yield _this10.connectivity.checkServerConnectivity(false);
      _this10.cdr.detectChanges();
      // Poll server connectivity periodically
      setInterval(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        const previousStatus = _this10.isOnline;
        _this10.isOnline = yield _this10.connectivity.checkServerConnectivity(false);
        if (previousStatus !== _this10.isOnline) {
          _this10.cdr.detectChanges();
        }
      }), 30000); // Check every 30 seconds
    })();
  }
}, _OfflineSurveyListPage.ctorParameters = () => [{
  type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.Router
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.AlertController
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.LoadingController
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: src_app_services_survey_form_api_service__WEBPACK_IMPORTED_MODULE_5__.SurveyFormAPIService
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_11__.Store
}, {
  type: src_app_services_connectivity_service__WEBPACK_IMPORTED_MODULE_7__.ConnectivityService
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_12__.ChangeDetectorRef
}, {
  type: src_app_services_offline_sync_service__WEBPACK_IMPORTED_MODULE_8__.OfflineSyncService
}], _OfflineSurveyListPage);
OfflineSurveyListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_13__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_12__.Component)({
  selector: 'app-offline-survey-list',
  template: _offline_survey_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  animations: [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.trigger)('slideInOut', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.transition)(':enter', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.style)({
    height: '0px',
    opacity: 0,
    overflow: 'hidden'
  }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.animate)('300ms ease-in-out', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.style)({
    height: '*',
    opacity: 1
  }))]), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.transition)(':leave', [(0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.style)({
    height: '*',
    opacity: 1,
    overflow: 'hidden'
  }), (0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.animate)('300ms ease-in-out', (0,_angular_animations__WEBPACK_IMPORTED_MODULE_14__.style)({
    height: '0px',
    opacity: 0
  }))])])],
  styles: [(_offline_survey_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], OfflineSurveyListPage);


/***/ }),

/***/ 70014:
/*!**********************************************!*\
  !*** ./src/app/services/api_base.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   APIBaseService: () => (/* binding */ APIBaseService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./global */ 99328);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
var _APIBaseService;

/* eslint-disable eqeqeq */

/* eslint-disable @typescript-eslint/naming-convention */




let APIBaseService = (_APIBaseService = class APIBaseService {
  constructor(http, g, b, store) {
    this.http = http;
    this.g = g;
    this.b = b;
    this.store = store;
  }
  getHeader(params = {}) {
    // Get token from current user if g.jws is not available
    let token = this.g.jws;
    if (!token) {
      const currentUser = this.b.getCurrentUser();
      token = currentUser === null || currentUser === void 0 ? void 0 : currentUser.token;
    }
    return {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpHeaders({
        Authorization: token
      }),
      params
    };
  }
  errorHandle(err) {
    let message = '';
    let detailedErrors = null;
    // Extract error details from response
    if (err !== null && err !== void 0 && err.error) {
      // Backend error format: {success: false, message: string, data?: object|string}
      message = err.error.message || err.message;
      detailedErrors = err.error.data;
    } else {
      message = err.message;
    }
    // Handle specific HTTP status codes
    switch (err.status) {
      case 0:
        // Network error
        message = 'Failed reaching server!!! Make sure you are connected to internet or camp site network.';
        this.b.errorToast(message);
        break;
      case 400:
        // Bad Request
        message = message || 'Bad request. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 401:
        // Unauthorized - token expired
        message = message || 'Session expired. Please login again.';
        this.b.errorToast(message);
        setTimeout(() => {
          this.b.logout('token_expired');
        }, 3000);
        break;
      case 403:
        // Forbidden
        message = message || 'Access denied. You do not have permission to perform this action.';
        this.b.errorToast(message);
        break;
      case 404:
        // Not Found
        message = message || 'Resource not found.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 422:
        // Validation Error (Unprocessable Entity)
        message = message || 'Validation failed. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 500:
        // Internal Server Error
        message = message || 'Internal server error. Please try again later.';
        this.b.errorToast(message);
        break;
      case 503:
        // Service Unavailable
        message = message || 'Service unavailable. Please try again later.';
        this.b.errorToast(message);
        break;
      default:
        // Other errors
        message = message || 'Unknown error occurred. Make sure you are connected and retry.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
    }
    return Promise.resolve({
      message: this.formatErrorMessage(message, detailedErrors),
      success: false,
      data: detailedErrors
    });
  }
  /**
   * Format error message with detailed validation errors or data
   */
  formatErrorMessage(mainMessage, detailedErrors) {
    if (!detailedErrors) {
      return mainMessage;
    }
    // If detailedErrors is a string (like the data field from backend)
    if (typeof detailedErrors === 'string') {
      return `${mainMessage} - ${detailedErrors}`;
    }
    // If detailedErrors is an object with field-specific errors (validation errors)
    if (typeof detailedErrors === 'object' && !Array.isArray(detailedErrors)) {
      const errorMessages = [mainMessage];
      Object.keys(detailedErrors).forEach(field => {
        const fieldErrors = detailedErrors[field];
        if (Array.isArray(fieldErrors)) {
          fieldErrors.forEach(error => errorMessages.push(`• ${error}`));
        } else if (typeof fieldErrors === 'string') {
          errorMessages.push(`• ${fieldErrors}`);
        }
      });
      return errorMessages.join('\n');
    }
    return mainMessage;
  }
}, _APIBaseService.ctorParameters = () => [{
  type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient
}, {
  type: _global__WEBPACK_IMPORTED_MODULE_0__.GlobalProvider
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_3__.Store
}], _APIBaseService);
APIBaseService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], APIBaseService);


/***/ }),

/***/ 42439:
/*!**************************************************!*\
  !*** ./src/app/services/offline-sync.service.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OfflineSyncService: () => (/* binding */ OfflineSyncService)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _survey_form_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./survey_form_api.service */ 55856);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
/* harmony import */ var _connectivity_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./connectivity.service */ 65065);

var _OfflineSyncService;






let OfflineSyncService = (_OfflineSyncService = class OfflineSyncService {
  constructor(surveyApi, b, connectivity) {
    this.surveyApi = surveyApi;
    this.b = b;
    this.connectivity = connectivity;
  }
  /**
   * Sync responses for a specific assessment
   * @param assessmentKey The key of the offline assessment
   * @param showToast Whether to show toast messages
   * @returns SyncResult with sync status
   */
  syncAssessmentResponses(_x) {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (assessmentKey, showToast = true) {
      const result = {
        success: false,
        synced: 0,
        failed: 0,
        errors: []
      };
      try {
        // Check if our target server is reachable
        const isServerReachable = yield _this.connectivity.checkServerConnectivity(false);
        if (!isServerReachable) {
          const error = 'Target server is not reachable';
          result.errors.push(error);
          if (showToast) {
            _this.b.errorToast('Sync failed: Server not reachable');
          }
          return result;
        }
        // Load responses for this assessment
        const responsesKey = `responses_${assessmentKey}`;
        const responsesData = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: responsesKey
        });
        if (!responsesData.value) {
          result.success = true;
          if (showToast) {
            _this.b.toast('No responses to sync');
          }
          return result;
        }
        const responses = JSON.parse(responsesData.value);
        // Filter only unsynced responses
        const unsyncedResponses = responses.filter(r => !r.synced);
        if (unsyncedResponses.length === 0) {
          result.success = true;
          if (showToast) {
            _this.b.toast('No pending responses to sync');
          }
          return result;
        }
        // Process each unsynced response
        for (const response of unsyncedResponses) {
          try {
            // Prepare the response data for API
            const submissionData = {
              survey_form_id: response.survey_form_id,
              beneficiary_id: response.beneficiary_id,
              beneficiary_type: response.beneficiary_type,
              response: response.response_data,
              submitted_at: response.submitted_at || response.completed_at || new Date().toISOString()
            };
            const syncResult = yield _this.surveyApi.storeSurvey(submissionData);
            if (syncResult && syncResult.success) {
              // Mark as synced
              response.synced = true;
              response.sync_date = new Date().toISOString();
              result.synced++;
            } else {
              throw new Error((syncResult === null || syncResult === void 0 ? void 0 : syncResult.message) || 'Sync failed');
            }
          } catch (error) {
            result.failed++;
            result.errors.push(`Beneficiary ${response.beneficiary_id}: ${error.message || 'Unknown error'}`);
          }
        }
        // Save updated responses back to storage
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: responsesKey,
          value: JSON.stringify(responses)
        });
        result.success = result.failed === 0 || result.synced > 0;
        // Show appropriate message
        if (showToast) {
          if (result.failed === 0) {
            _this.b.toast(`Successfully synced ${result.synced} response${result.synced !== 1 ? 's' : ''}`);
          } else if (result.synced > 0) {
            _this.b.errorToast(`Partially synced: ${result.synced} succeeded, ${result.failed} failed`);
          } else {
            _this.b.errorToast('Sync failed for all responses');
          }
        }
      } catch (error) {
        result.errors.push(`Sync process error: ${error.message || 'Unknown error'}`);
        if (showToast) {
          _this.b.errorToast('Sync process failed');
        }
      }
      return result;
    }).apply(this, arguments);
  }
  /**
   * Get sync status for a specific assessment
   * @param assessmentKey The key of the offline assessment
   */
  getAssessmentSyncStatus(assessmentKey) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const responsesKey = `responses_${assessmentKey}`;
      const responsesData = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
        key: responsesKey
      });
      let totalResponses = 0;
      let syncedResponses = 0;
      let unsyncedResponses = 0;
      if (responsesData.value) {
        const responses = JSON.parse(responsesData.value);
        totalResponses = responses.length;
        syncedResponses = responses.filter(r => r.synced).length;
        unsyncedResponses = responses.filter(r => !r.synced).length;
      }
      const isOnline = yield _this2.connectivity.checkServerConnectivity(true);
      return {
        totalResponses,
        syncedResponses,
        unsyncedResponses,
        isOnline
      };
    })();
  }
}, _OfflineSyncService.ctorParameters = () => [{
  type: _survey_form_api_service__WEBPACK_IMPORTED_MODULE_2__.SurveyFormAPIService
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: _connectivity_service__WEBPACK_IMPORTED_MODULE_4__.ConnectivityService
}], _OfflineSyncService);
OfflineSyncService = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Injectable)({
  providedIn: 'root'
})], OfflineSyncService);


/***/ }),

/***/ 55856:
/*!*****************************************************!*\
  !*** ./src/app/services/survey_form_api.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveyFormAPIService: () => (/* binding */ SurveyFormAPIService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 61318);

/* eslint-disable @typescript-eslint/naming-convention */




let SurveyFormAPIService = class SurveyFormAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_0__.APIBaseService {
  constructor() {
    super(...arguments);
    this.namespace = '/survey-forms/responses';
    this.formsNamespace = '/survey-forms';
  }
  getSurveyResponseData(id, type) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${type}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  displayForms(id, beneficiaryType, beneficiaryId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.formsNamespace}/${id}`;
    // Add query parameters if provided
    const queryParams = [];
    if (beneficiaryType) {
      queryParams.push(`beneficiary_type=${encodeURIComponent(beneficiaryType)}`);
    }
    if (beneficiaryId) {
      queryParams.push(`beneficiary_id=${encodeURIComponent(beneficiaryId)}`);
    }
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  storeSurvey(body) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}`;
    return this.http.post(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  viewForm(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteForm(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteSurvey(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  // ===== OFFLINE ASSESSMENT APIs =====
  getAssessmentForms(tags, tagMatch = 'all') {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/survey-forms/list`;
    const queryParams = [];
    if (tags) {
      queryParams.push(`tags=${encodeURIComponent(tags)}`);
    }
    queryParams.push(`tag_match=${encodeURIComponent(tagMatch)}`);
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getLocationData() {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/location-data`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getBeneficiariesByLocation(blockCampId, subBlockIds, assessmentId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/beneficiaries?block_id=${blockCampId}&survey_form_id=${assessmentId}`;
    if (subBlockIds !== null && subBlockIds !== undefined) {
      if (Array.isArray(subBlockIds)) {
        const commaSeparatedIds = subBlockIds.join(',');
        url += `&sub_block_ids=${commaSeparatedIds}`;
      }
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
};
SurveyFormAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], SurveyFormAPIService);


/***/ }),

/***/ 65151:
/*!************************************************************************************!*\
  !*** ./src/app/pages/offline-survey-list/offline-survey-list.page.scss?ngResource ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.survey-list-container {
  max-width: 1200px;
  margin: 0 auto;
}

.section-header {
  margin-bottom: 1.5rem;
  text-align: center;
}
.section-header .section-title {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 0.5rem;
  margin: 0;
  font-size: 1.5rem;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.section-header .section-subtitle {
  margin: 0.5rem 0 0 0;
  color: var(--ion-color-medium);
  font-size: 1rem;
}

.assessments-section .assessment-card {
  margin-bottom: 1.5rem;
}
.assessments-section .assessment-card .compact-header {
  padding: 12px 16px;
  background: linear-gradient(135deg, var(--ion-color-step-50), var(--ion-color-step-100));
  border-bottom: 1px solid var(--ion-color-light);
  cursor: pointer;
  -webkit-user-select: none;
          user-select: none;
}
.assessments-section .assessment-card .compact-header:hover {
  background: linear-gradient(135deg, var(--ion-color-step-100), var(--ion-color-step-150));
}
.assessments-section .assessment-card .compact-header .assessment-title {
  display: flex;
  align-items: center;
  gap: 0.75rem;
  margin-bottom: 0.5rem;
}
.assessments-section .assessment-card .compact-header .assessment-title .title-text {
  flex: 1;
  font-size: 1.1rem;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.assessments-section .assessment-card .compact-header .assessment-title .status-chips {
  display: flex;
  gap: 0.5rem;
  align-items: center;
}
.assessments-section .assessment-card .compact-header .assessment-title .status-chips ion-chip {
  font-size: 0.9rem;
  font-weight: 600;
  min-width: 50px;
  height: 32px;
  --padding-start: 8px;
  --padding-end: 8px;
}
.assessments-section .assessment-card .compact-header .assessment-title .status-chips ion-chip .chip-label {
  font-size: 0.75rem;
  font-weight: 500;
  margin-right: 4px;
  opacity: 0.8;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.assessments-section .assessment-card .compact-header .assessment-title .collapse-button {
  margin-left: auto;
  --padding-start: 4px;
  --padding-end: 4px;
  --color: var(--ion-color-medium);
}
.assessments-section .assessment-card .compact-header .assessment-title .collapse-button:hover {
  --color: var(--ion-color-primary);
}
.assessments-section .assessment-card .compact-header .assessment-title .collapse-button ion-icon {
  font-size: 1.2rem;
}
.assessments-section .assessment-card .compact-header .location-info {
  display: flex;
  align-items: center;
  gap: 0.75rem;
  margin: 0;
  flex-wrap: wrap;
}
.assessments-section .assessment-card .compact-header .location-info .location-label {
  font-size: 0.85rem;
  font-weight: 500;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.assessments-section .assessment-card .compact-header .location-info .block-name {
  font-size: 1.1rem;
  font-weight: 700;
  color: var(--ion-color-primary);
}
.assessments-section .assessment-card .compact-header .location-info .sub-blocks {
  font-size: 1rem;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.assessments-section .assessment-card .compact-header .location-info .location-separator {
  color: var(--ion-color-light-shade);
  font-weight: bold;
  font-size: 1.2rem;
}

.beneficiaries-section {
  margin-top: 16px;
  padding-top: 16px;
  border-top: 1px solid var(--ion-color-light);
}
.beneficiaries-section .beneficiaries-header {
  margin-bottom: 16px;
}
.beneficiaries-section .beneficiaries-header .beneficiaries-title {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  margin: 0 0 12px 0;
  color: var(--ion-color-dark);
  font-size: 16px;
  font-weight: 600;
}
.beneficiaries-section .beneficiaries-header .search-container {
  margin-top: 8px;
}
.beneficiaries-section .beneficiaries-header .search-container .beneficiary-search {
  --background: var(--ion-color-step-50);
  --border-radius: 8px;
  --box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  --color: var(--ion-color-dark);
  --placeholder-color: var(--ion-color-medium);
  --icon-color: var(--ion-color-medium);
  margin: 0;
  font-size: 0.9rem;
}
.beneficiaries-section .beneficiaries-header .search-container .beneficiary-search.searchbar-has-value {
  --background: var(--ion-color-primary-tint);
  --color: var(--ion-color-primary-contrast);
  --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);
  --icon-color: var(--ion-color-primary-contrast);
}

.table-header {
  background-color: var(--ion-color-step-50);
  padding: 8px 12px;
  border-bottom: 1px solid var(--ion-color-light);
}
.table-header h5 {
  margin: 0;
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-primary);
}

.table-container + .table-container {
  margin-top: 16px;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
}

.beneficiaries-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 700px;
}
.beneficiaries-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 12px 8px;
  text-align: left;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.9rem;
  white-space: nowrap;
}
.beneficiaries-table th:first-child {
  text-align: center;
  width: 50px;
}
.beneficiaries-table td {
  padding: 12px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.9rem;
  text-align: left;
  vertical-align: middle;
}
.beneficiaries-table td:first-child {
  font-weight: 500;
  color: var(--ion-color-primary);
  text-align: center;
  width: 50px;
}
.beneficiaries-table tbody tr:hover {
  background-color: var(--ion-color-light);
}
.beneficiaries-table tbody tr:last-child td {
  border-bottom: none;
}
.beneficiaries-table .fcn-cell {
  font-weight: 600;
  color: var(--ion-color-success);
}
.beneficiaries-table .actions-cell {
  text-align: center;
  width: 120px;
}
.beneficiaries-table .actions-cell ion-button {
  --padding-start: 8px;
  --padding-end: 8px;
  font-size: 0.8rem;
}
.beneficiaries-table .sync-cell {
  text-align: center;
  width: 80px;
}
.beneficiaries-table .sync-cell .sync-placeholder {
  color: var(--ion-color-medium);
  font-style: italic;
}

.beneficiary-name {
  display: flex;
  flex-direction: column;
  gap: 2px;
}
.beneficiary-name small {
  color: var(--ion-color-medium);
  font-size: 12px;
}

.status-tag {
  display: inline-block;
  padding: 2px 6px;
  border-radius: 4px;
  font-size: 10px;
  font-weight: 500;
  margin-right: 4px;
  margin-bottom: 2px;
}
.status-tag.pregnant {
  background-color: rgba(var(--ion-color-success-rgb), 0.1);
  color: var(--ion-color-success);
  border: 1px solid rgba(var(--ion-color-success-rgb), 0.3);
}
.status-tag.lactating {
  background-color: rgba(var(--ion-color-tertiary-rgb), 0.1);
  color: var(--ion-color-tertiary);
  border: 1px solid rgba(var(--ion-color-tertiary-rgb), 0.3);
}
.status-tag.none {
  background-color: rgba(var(--ion-color-medium-rgb), 0.1);
  color: var(--ion-color-medium);
  border: 1px solid rgba(var(--ion-color-medium-rgb), 0.3);
}

.empty-state {
  text-align: center;
  padding: 2rem;
}
.empty-state ion-icon {
  font-size: 4rem;
  margin-bottom: 1rem;
}
.empty-state h3 {
  color: var(--ion-color-dark);
  margin-bottom: 0.5rem;
}
.empty-state p {
  color: var(--ion-color-medium);
  margin: 0 0 1.5rem 0;
}

.no-results {
  text-align: center;
  padding: 2rem;
  background-color: var(--ion-color-step-50);
  border-radius: 8px;
  margin: 1rem 0;
}
.no-results ion-icon {
  font-size: 2.5rem;
  margin-bottom: 0.75rem;
  color: var(--ion-color-medium);
}
.no-results p {
  color: var(--ion-color-medium);
  margin: 0 0 1rem 0;
  font-style: italic;
}
.no-results ion-button {
  --color: var(--ion-color-medium);
  font-size: 0.85rem;
}

ion-progress-bar {
  margin: 8px 0 16px 0;
}

ion-card-title {
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

ion-card-subtitle {
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.action-buttons {
  margin-top: 1.5rem;
  margin-bottom: 1rem;
  display: flex;
  flex-direction: column;
  gap: 0.75rem;
}
.action-buttons ion-button {
  width: 100%;
}
.action-buttons .no-completed-message {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 0.5rem;
  padding: 1rem;
  background-color: var(--ion-color-light);
  border-radius: 8px;
  color: var(--ion-color-medium);
  font-size: 0.9rem;
  font-style: italic;
}
.action-buttons .no-completed-message ion-icon {
  font-size: 1.2rem;
}

@media (max-width: 768px) {
  .beneficiaries-table {
    font-size: 0.8rem;
  }
  .beneficiaries-table th, .beneficiaries-table td {
    padding: 8px 6px;
  }
  .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) th:nth-child(5), .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) td:nth-child(5),
  .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) th:nth-child(6), .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) td:nth-child(6),
  .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) th:nth-child(8), .beneficiaries-table:has(th:nth-child(5):contains("Father Name")) td:nth-child(8) {
    display: none;
  }
  .beneficiaries-table:has(th:nth-child(4):contains("Husband Name")) th:nth-child(4), .beneficiaries-table:has(th:nth-child(4):contains("Husband Name")) td:nth-child(4),
  .beneficiaries-table:has(th:nth-child(4):contains("Husband Name")) th:nth-child(6), .beneficiaries-table:has(th:nth-child(4):contains("Husband Name")) td:nth-child(6) {
    display: none;
  }
  .beneficiaries-table .sync-cell, .beneficiaries-table .actions-cell {
    width: 60px;
  }
  .beneficiaries-table .sync-cell ion-button, .beneficiaries-table .actions-cell ion-button {
    transform: scale(0.9);
    --padding-start: 8px;
    --padding-end: 8px;
  }
  .detail-item {
    margin-bottom: 0.75rem;
  }
  .detail-item strong {
    font-size: 0.8rem;
  }
  .detail-item p {
    font-size: 0.9rem;
  }
  .beneficiary-name small {
    font-size: 10px;
  }
  .action-buttons {
    flex-direction: column;
    gap: 0.5rem;
  }
  .action-buttons ion-button:first-child {
    flex: none;
    width: 100%;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/offline-survey-list/offline-survey-list.page.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;EACA,cAAA;AACF;;AAEA;EACE,qBAAA;EACA,kBAAA;AACF;AACE;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,WAAA;EACA,SAAA;EACA,iBAAA;EACA,gBAAA;EACA,4BAAA;AACJ;AAEE;EACE,oBAAA;EACA,8BAAA;EACA,eAAA;AAAJ;;AAME;EACE,qBAAA;AAHJ;AAKI;EACE,kBAAA;EACA,wFAAA;EACA,+CAAA;EACA,eAAA;EACA,yBAAA;UAAA,iBAAA;AAHN;AAKM;EACE,yFAAA;AAHR;AAMM;EACE,aAAA;EACA,mBAAA;EACA,YAAA;EACA,qBAAA;AAJR;AAMQ;EACE,OAAA;EACA,iBAAA;EACA,gBAAA;EACA,4BAAA;AAJV;AAOQ;EACE,aAAA;EACA,WAAA;EACA,mBAAA;AALV;AAOU;EACE,iBAAA;EACA,gBAAA;EACA,eAAA;EACA,YAAA;EACA,oBAAA;EACA,kBAAA;AALZ;AAOY;EACE,kBAAA;EACA,gBAAA;EACA,iBAAA;EACA,YAAA;EACA,yBAAA;EACA,qBAAA;AALd;AAUQ;EACE,iBAAA;EACA,oBAAA;EACA,kBAAA;EACA,gCAAA;AARV;AAUU;EACE,iCAAA;AARZ;AAWU;EACE,iBAAA;AATZ;AAcM;EACE,aAAA;EACA,mBAAA;EACA,YAAA;EACA,SAAA;EACA,eAAA;AAZR;AAcQ;EACE,kBAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;AAZV;AAeQ;EACE,iBAAA;EACA,gBAAA;EACA,+BAAA;AAbV;AAgBQ;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAdV;AAiBQ;EACE,mCAAA;EACA,iBAAA;EACA,iBAAA;AAfV;;AAuBA;EACE,gBAAA;EACA,iBAAA;EACA,4CAAA;AApBF;AAsBE;EACE,mBAAA;AApBJ;AAsBI;EACE,aAAA;EACA,mBAAA;EACA,WAAA;EACA,kBAAA;EACA,4BAAA;EACA,eAAA;EACA,gBAAA;AApBN;AAuBI;EACE,eAAA;AArBN;AAuBM;EACE,sCAAA;EACA,oBAAA;EACA,uCAAA;EACA,8BAAA;EACA,4CAAA;EACA,qCAAA;EACA,SAAA;EACA,iBAAA;AArBR;AAuBQ;EACE,2CAAA;EACA,0CAAA;EACA,qEAAA;EACA,+CAAA;AArBV;;AA4BA;EACE,0CAAA;EACA,iBAAA;EACA,+CAAA;AAzBF;AA2BE;EACE,SAAA;EACA,eAAA;EACA,gBAAA;EACA,+BAAA;AAzBJ;;AA6BA;EACE,gBAAA;AA1BF;;AA6BA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;AA1BF;;AA6BA;EACE,WAAA;EACA,yBAAA;EACA,gBAAA;AA1BF;AA4BE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,gBAAA;EACA,gDAAA;EACA,iBAAA;EACA,mBAAA;AA1BJ;AA4BI;EACE,kBAAA;EACA,WAAA;AA1BN;AA8BE;EACE,iBAAA;EACA,+CAAA;EACA,iBAAA;EACA,gBAAA;EACA,sBAAA;AA5BJ;AA8BI;EACE,gBAAA;EACA,+BAAA;EACA,kBAAA;EACA,WAAA;AA5BN;AAgCE;EACE,wCAAA;AA9BJ;AAiCE;EACE,mBAAA;AA/BJ;AAkCE;EACE,gBAAA;EACA,+BAAA;AAhCJ;AAmCE;EACE,kBAAA;EACA,YAAA;AAjCJ;AAmCI;EACE,oBAAA;EACA,kBAAA;EACA,iBAAA;AAjCN;AAqCE;EACE,kBAAA;EACA,WAAA;AAnCJ;AAqCI;EACE,8BAAA;EACA,kBAAA;AAnCN;;AAwCA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AArCF;AAuCE;EACE,8BAAA;EACA,eAAA;AArCJ;;AAyCA;EACE,qBAAA;EACA,gBAAA;EACA,kBAAA;EACA,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;AAtCF;AAwCE;EACE,yDAAA;EACA,+BAAA;EACA,yDAAA;AAtCJ;AAyCE;EACE,0DAAA;EACA,gCAAA;EACA,0DAAA;AAvCJ;AA0CE;EACE,wDAAA;EACA,8BAAA;EACA,wDAAA;AAxCJ;;AA4CA;EACE,kBAAA;EACA,aAAA;AAzCF;AA2CE;EACE,eAAA;EACA,mBAAA;AAzCJ;AA4CE;EACE,4BAAA;EACA,qBAAA;AA1CJ;AA6CE;EACE,8BAAA;EACA,oBAAA;AA3CJ;;AA+CA;EACE,kBAAA;EACA,aAAA;EACA,0CAAA;EACA,kBAAA;EACA,cAAA;AA5CF;AA8CE;EACE,iBAAA;EACA,sBAAA;EACA,8BAAA;AA5CJ;AA+CE;EACE,8BAAA;EACA,kBAAA;EACA,kBAAA;AA7CJ;AAgDE;EACE,gCAAA;EACA,kBAAA;AA9CJ;;AAmDA;EACE,oBAAA;AAhDF;;AAmDA;EACE,aAAA;EACA,mBAAA;EACA,WAAA;AAhDF;;AAmDA;EACE,aAAA;EACA,mBAAA;EACA,WAAA;AAhDF;;AAmDA;EACE,kBAAA;EACA,mBAAA;EACA,aAAA;EACA,sBAAA;EACA,YAAA;AAhDF;AAkDE;EACE,WAAA;AAhDJ;AAmDE;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,WAAA;EACA,aAAA;EACA,wCAAA;EACA,kBAAA;EACA,8BAAA;EACA,iBAAA;EACA,kBAAA;AAjDJ;AAmDI;EACE,iBAAA;AAjDN;;AAsDA;EACE;IACE,iBAAA;EAnDF;EAqDE;IACE,gBAAA;EAnDJ;EAwDI;;;IAIE,aAAA;EAvDN;EA6DI;;IAGE,aAAA;EA5DN;EAgEE;IACE,WAAA;EA9DJ;EAgEI;IACE,qBAAA;IACA,oBAAA;IACA,kBAAA;EA9DN;EAmEA;IACE,sBAAA;EAjEF;EAmEE;IACE,iBAAA;EAjEJ;EAoEE;IACE,iBAAA;EAlEJ;EAuEE;IACE,eAAA;EArEJ;EAyEA;IACE,sBAAA;IACA,WAAA;EAvEF;EAyEE;IACE,UAAA;IACA,WAAA;EAvEJ;AACF","sourcesContent":[".survey-list-container {\n  max-width: 1200px;\n  margin: 0 auto;\n}\n\n.section-header {\n  margin-bottom: 1.5rem;\n  text-align: center;\n\n  .section-title {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    gap: 0.5rem;\n    margin: 0;\n    font-size: 1.5rem;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n  }\n\n  .section-subtitle {\n    margin: 0.5rem 0 0 0;\n    color: var(--ion-color-medium);\n    font-size: 1rem;\n  }\n}\n\n\n.assessments-section {\n  .assessment-card {\n    margin-bottom: 1.5rem;\n\n    .compact-header {\n      padding: 12px 16px;\n      background: linear-gradient(135deg, var(--ion-color-step-50), var(--ion-color-step-100));\n      border-bottom: 1px solid var(--ion-color-light);\n      cursor: pointer;\n      user-select: none;\n\n      &:hover {\n        background: linear-gradient(135deg, var(--ion-color-step-100), var(--ion-color-step-150));\n      }\n\n      .assessment-title {\n        display: flex;\n        align-items: center;\n        gap: 0.75rem;\n        margin-bottom: 0.5rem;\n\n        .title-text {\n          flex: 1;\n          font-size: 1.1rem;\n          font-weight: 600;\n          color: var(--ion-color-dark);\n        }\n\n        .status-chips {\n          display: flex;\n          gap: 0.5rem;\n          align-items: center;\n\n          ion-chip {\n            font-size: 0.9rem;\n            font-weight: 600;\n            min-width: 50px;\n            height: 32px;\n            --padding-start: 8px;\n            --padding-end: 8px;\n\n            .chip-label {\n              font-size: 0.75rem;\n              font-weight: 500;\n              margin-right: 4px;\n              opacity: 0.8;\n              text-transform: uppercase;\n              letter-spacing: 0.5px;\n            }\n          }\n        }\n\n        .collapse-button {\n          margin-left: auto;\n          --padding-start: 4px;\n          --padding-end: 4px;\n          --color: var(--ion-color-medium);\n\n          &:hover {\n            --color: var(--ion-color-primary);\n          }\n\n          ion-icon {\n            font-size: 1.2rem;\n          }\n        }\n      }\n\n      .location-info {\n        display: flex;\n        align-items: center;\n        gap: 0.75rem;\n        margin: 0;\n        flex-wrap: wrap;\n\n        .location-label {\n          font-size: 0.85rem;\n          font-weight: 500;\n          color: var(--ion-color-medium);\n          text-transform: uppercase;\n          letter-spacing: 0.5px;\n        }\n\n        .block-name {\n          font-size: 1.1rem;\n          font-weight: 700;\n          color: var(--ion-color-primary);\n        }\n\n        .sub-blocks {\n          font-size: 1rem;\n          font-weight: 600;\n          color: var(--ion-color-dark);\n        }\n\n        .location-separator {\n          color: var(--ion-color-light-shade);\n          font-weight: bold;\n          font-size: 1.2rem;\n        }\n      }\n    }\n  }\n}\n\n\n.beneficiaries-section {\n  margin-top: 16px;\n  padding-top: 16px;\n  border-top: 1px solid var(--ion-color-light);\n\n  .beneficiaries-header {\n    margin-bottom: 16px;\n\n    .beneficiaries-title {\n      display: flex;\n      align-items: center;\n      gap: 0.5rem;\n      margin: 0 0 12px 0;\n      color: var(--ion-color-dark);\n      font-size: 16px;\n      font-weight: 600;\n    }\n\n    .search-container {\n      margin-top: 8px;\n\n      .beneficiary-search {\n        --background: var(--ion-color-step-50);\n        --border-radius: 8px;\n        --box-shadow: 0 2px 4px rgba(0,0,0,0.1);\n        --color: var(--ion-color-dark);\n        --placeholder-color: var(--ion-color-medium);\n        --icon-color: var(--ion-color-medium);\n        margin: 0;\n        font-size: 0.9rem;\n\n        &.searchbar-has-value {\n          --background: var(--ion-color-primary-tint);\n          --color: var(--ion-color-primary-contrast);\n          --placeholder-color: rgba(var(--ion-color-primary-contrast-rgb), 0.6);\n          --icon-color: var(--ion-color-primary-contrast);\n        }\n      }\n    }\n  }\n}\n\n.table-header {\n  background-color: var(--ion-color-step-50);\n  padding: 8px 12px;\n  border-bottom: 1px solid var(--ion-color-light);\n\n  h5 {\n    margin: 0;\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-primary);\n  }\n}\n\n.table-container + .table-container {\n  margin-top: 16px;\n}\n\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n}\n\n.beneficiaries-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 700px;\n  \n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 12px 8px;\n    text-align: left;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.9rem;\n    white-space: nowrap;\n\n    &:first-child {\n      text-align: center;\n      width: 50px;\n    }\n  }\n  \n  td {\n    padding: 12px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.9rem;\n    text-align: left;\n    vertical-align: middle;\n\n    &:first-child {\n      font-weight: 500;\n      color: var(--ion-color-primary);\n      text-align: center;\n      width: 50px;\n    }\n  }\n  \n  tbody tr:hover {\n    background-color: var(--ion-color-light);\n  }\n  \n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n  \n  .fcn-cell {\n    font-weight: 600;\n    color: var(--ion-color-success);\n  }\n\n  .actions-cell {\n    text-align: center;\n    width: 120px;\n\n    ion-button {\n      --padding-start: 8px;\n      --padding-end: 8px;\n      font-size: 0.8rem;\n    }\n  }\n\n  .sync-cell {\n    text-align: center;\n    width: 80px;\n\n    .sync-placeholder {\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n.beneficiary-name {\n  display: flex;\n  flex-direction: column;\n  gap: 2px;\n\n  small {\n    color: var(--ion-color-medium);\n    font-size: 12px;\n  }\n}\n\n.status-tag {\n  display: inline-block;\n  padding: 2px 6px;\n  border-radius: 4px;\n  font-size: 10px;\n  font-weight: 500;\n  margin-right: 4px;\n  margin-bottom: 2px;\n\n  &.pregnant {\n    background-color: rgba(var(--ion-color-success-rgb), 0.1);\n    color: var(--ion-color-success);\n    border: 1px solid rgba(var(--ion-color-success-rgb), 0.3);\n  }\n\n  &.lactating {\n    background-color: rgba(var(--ion-color-tertiary-rgb), 0.1);\n    color: var(--ion-color-tertiary);\n    border: 1px solid rgba(var(--ion-color-tertiary-rgb), 0.3);\n  }\n\n  &.none {\n    background-color: rgba(var(--ion-color-medium-rgb), 0.1);\n    color: var(--ion-color-medium);\n    border: 1px solid rgba(var(--ion-color-medium-rgb), 0.3);\n  }\n}\n\n.empty-state {\n  text-align: center;\n  padding: 2rem;\n\n  ion-icon {\n    font-size: 4rem;\n    margin-bottom: 1rem;\n  }\n\n  h3 {\n    color: var(--ion-color-dark);\n    margin-bottom: 0.5rem;\n  }\n\n  p {\n    color: var(--ion-color-medium);\n    margin: 0 0 1.5rem 0;\n  }\n}\n\n.no-results {\n  text-align: center;\n  padding: 2rem;\n  background-color: var(--ion-color-step-50);\n  border-radius: 8px;\n  margin: 1rem 0;\n\n  ion-icon {\n    font-size: 2.5rem;\n    margin-bottom: 0.75rem;\n    color: var(--ion-color-medium);\n  }\n\n  p {\n    color: var(--ion-color-medium);\n    margin: 0 0 1rem 0;\n    font-style: italic;\n  }\n\n  ion-button {\n    --color: var(--ion-color-medium);\n    font-size: 0.85rem;\n  }\n}\n\n\nion-progress-bar {\n  margin: 8px 0 16px 0;\n}\n\nion-card-title {\n  display: flex;\n  align-items: center;\n  gap: 0.5rem;\n}\n\nion-card-subtitle {\n  display: flex;\n  align-items: center;\n  gap: 0.5rem;\n}\n\n.action-buttons {\n  margin-top: 1.5rem;\n  margin-bottom: 1rem;\n  display: flex;\n  flex-direction: column;\n  gap: 0.75rem;\n\n  ion-button {\n    width: 100%;\n  }\n\n  .no-completed-message {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    gap: 0.5rem;\n    padding: 1rem;\n    background-color: var(--ion-color-light);\n    border-radius: 8px;\n    color: var(--ion-color-medium);\n    font-size: 0.9rem;\n    font-style: italic;\n\n    ion-icon {\n      font-size: 1.2rem;\n    }\n  }\n}\n\n@media (max-width: 768px) {\n  .beneficiaries-table {\n    font-size: 0.8rem;\n\n    th, td {\n      padding: 8px 6px;\n    }\n\n    // Hide some columns on small screens for child table\n    &:has(th:nth-child(5):contains('Father Name')) {\n      th:nth-child(5), td:nth-child(5), // Father Name\n      th:nth-child(6), td:nth-child(6), // Mother Name\n      th:nth-child(8), td:nth-child(8)  // Disability\n      {\n        display: none;\n      }\n    }\n\n    // Hide some columns on small screens for PLW table\n    &:has(th:nth-child(4):contains('Husband Name')) {\n      th:nth-child(4), td:nth-child(4), // Husband Name\n      th:nth-child(6), td:nth-child(6)  // Sub Block\n      {\n        display: none;\n      }\n    }\n\n    .sync-cell, .actions-cell {\n      width: 60px;\n\n      ion-button {\n        transform: scale(0.9);\n        --padding-start: 8px;\n        --padding-end: 8px;\n      }\n    }\n  }\n  \n  .detail-item {\n    margin-bottom: 0.75rem;\n    \n    strong {\n      font-size: 0.8rem;\n    }\n    \n    p {\n      font-size: 0.9rem;\n    }\n  }\n\n  .beneficiary-name {\n    small {\n      font-size: 10px;\n    }\n  }\n\n  .action-buttons {\n    flex-direction: column;\n    gap: 0.5rem;\n\n    ion-button:first-child {\n      flex: none;\n      width: 100%;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 99619:
/*!************************************************************************************!*\
  !*** ./src/app/pages/offline-survey-list/offline-survey-list.page.html?ngResource ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header [translucent]=\"true\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Community Assessments</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content [fullscreen]=\"true\">\n  <div class=\"ion-padding survey-list-container\">\n\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"clipboard-outline\" color=\"primary\"></ion-icon>\n        Community Assessments ({{ savedAssessments?.length || 0 }})\n      </h2>\n      <p class=\"section-subtitle\">Manage your community assessment data and sync progress</p>\n    </div>\n\n\n    <!-- Saved Assessments -->\n    <div *ngIf=\"savedAssessments.length > 0\" class=\"assessments-section\">\n\n      <ion-card *ngFor=\"let assessment of savedAssessments\" class=\"assessment-card\">\n        <ion-card-header class=\"compact-header\" (click)=\"toggleAssessmentCard(assessment)\">\n          <div class=\"assessment-title\">\n            <ion-icon name=\"document-outline\" color=\"primary\"></ion-icon>\n            <span class=\"title-text\">{{ assessment.title }}</span>\n            <div class=\"status-chips\">\n              <ion-chip color=\"primary\">\n                <span class=\"chip-label\">Total:</span>\n                {{ assessment.beneficiariesCount }}\n              </ion-chip>\n              <ion-chip [color]=\"getCompletedCount(assessment) > 0 ? 'warning' : 'medium'\">\n                <span class=\"chip-label\">Done:</span>\n                {{ getCompletedCount(assessment) }}\n              </ion-chip>\n              <ion-chip [color]=\"getSyncedCount(assessment) > 0 ? 'success' : 'medium'\">\n                <span class=\"chip-label\">Sync:</span>\n                {{ getSyncedCount(assessment) }}\n              </ion-chip>\n            </div>\n            <ion-button fill=\"clear\" size=\"small\" class=\"collapse-button\">\n              <ion-icon\n                [name]=\"assessment.collapsed ? 'chevron-down-outline' : 'chevron-up-outline'\"\n                slot=\"icon-only\">\n              </ion-icon>\n            </ion-button>\n          </div>\n\n          <div class=\"location-info\">\n            <span class=\"location-label\">Block:</span>\n            <span class=\"block-name\">{{ assessment.block }}</span>\n            <span class=\"location-separator\">|</span>\n            <span class=\"location-label\">Sub-blocks:</span>\n            <span class=\"sub-blocks\">{{ getSubBlocksDisplay(assessment) }}</span>\n          </div>\n        </ion-card-header>\n\n        <ion-card-content *ngIf=\"!assessment.collapsed\" [@slideInOut]>\n\n          <!-- Beneficiaries Section -->\n          <div class=\"beneficiaries-section\">\n            <div class=\"beneficiaries-header\">\n              <h4 class=\"beneficiaries-title\">\n                <ion-icon name=\"people-outline\" color=\"tertiary\"></ion-icon>\n                Beneficiaries List ({{ assessment.beneficiaries?.length || 0 }})\n              </h4>\n\n              <!-- Search Input -->\n              <div class=\"search-container\">\n                <ion-searchbar\n                  [value]=\"getSearchTerm(assessment.key)\"\n                  (ionInput)=\"onSearchChange(assessment.key, $event.detail.value!)\"\n                  placeholder=\"Search by FCN, name, father/husband name, HH no...\"\n                  show-clear-button=\"focus\"\n                  debounce=\"300\"\n                  class=\"beneficiary-search\">\n                </ion-searchbar>\n              </div>\n            </div>\n\n            <!-- Child Beneficiaries Table -->\n            <div class=\"table-container\" *ngIf=\"hasChildBeneficiaries(assessment)\">\n              <div class=\"table-header\" *ngIf=\"hasMixedBeneficiaryTypes(assessment)\">\n                <h5>Child Beneficiaries ({{ getFilteredBeneficiaries(assessment, 'child').length }})</h5>\n              </div>\n              <div *ngIf=\"getFilteredBeneficiaries(assessment, 'child').length === 0 && getSearchTerm(assessment.key)\" class=\"no-results\">\n                <ion-icon name=\"search-outline\" color=\"medium\"></ion-icon>\n                <p>No child beneficiaries found matching \"{{ getSearchTerm(assessment.key) }}\"</p>\n              </div>\n              <table class=\"beneficiaries-table\" *ngIf=\"getFilteredBeneficiaries(assessment, 'child').length > 0\">\n                <thead>\n                  <tr>\n                    <th>#</th>\n                    <th>FCN</th>\n                    <th>Name</th>\n                    <th>Age (In M)</th>\n                    <th>Father Name</th>\n                    <th>Mother Name</th>\n                    <th>Disability</th>\n                    <th>HH No</th>\n                    <th>Actions</th>\n                  </tr>\n                </thead>\n                <tbody>\n                  <ng-container *ngFor=\"let beneficiary of getFilteredBeneficiaries(assessment, 'child'); let i = index\">\n                    <tr>\n                      <td>{{ i + 1 }}</td>\n                      <td class=\"fcn-cell\">{{ beneficiary.fcn }}</td>\n                      <td>\n                        <div class=\"beneficiary-name\">\n                          {{ beneficiary.displayName || beneficiary.name }}\n                          <small *ngIf=\"beneficiary.gender\">{{ beneficiary.gender }}</small>\n                        </div>\n                      </td>\n                      <td>{{ beneficiary.age || 'N/A' }}</td>\n                      <td>{{ beneficiary.fatherName || 'N/A' }}</td>\n                      <td>{{ beneficiary.motherName || 'N/A' }}</td>\n                      <td>{{ formatDisability(beneficiary.disability) }}</td>\n                      <td>{{ beneficiary.householdNo || 'N/A' }}</td>\n                      <td class=\"actions-cell\">\n                        <ion-button\n                          size=\"small\"\n                          [fill]=\"isActionButtonDisabled(assessment, beneficiary.id) ? 'solid' : 'outline'\"\n                          [color]=\"getActionButtonColor(assessment, beneficiary.id)\"\n                          (click)=\"handleBeneficiaryAction(assessment, beneficiary)\"\n                          [disabled]=\"isActionButtonDisabled(assessment, beneficiary.id)\"\n                          [title]=\"getActionButtonTitle(assessment, beneficiary.id)\">\n                          <ion-icon\n                            [name]=\"getActionButtonIcon(assessment, beneficiary.id)\"\n                            slot=\"start\">\n                          </ion-icon>\n                          {{ getActionButtonText(assessment, beneficiary.id) }}\n                        </ion-button>\n                      </td>\n                    </tr>\n                  </ng-container>\n                </tbody>\n              </table>\n            </div>\n\n            <!-- PLW Beneficiaries Table -->\n            <div class=\"table-container\" *ngIf=\"hasPlwBeneficiaries(assessment)\">\n              <div class=\"table-header\" *ngIf=\"hasMixedBeneficiaryTypes(assessment)\">\n                <h5>PLW Beneficiaries ({{ getFilteredBeneficiaries(assessment, 'plw').length }})</h5>\n              </div>\n              <div *ngIf=\"getFilteredBeneficiaries(assessment, 'plw').length === 0 && getSearchTerm(assessment.key)\" class=\"no-results\">\n                <ion-icon name=\"search-outline\" color=\"medium\"></ion-icon>\n                <p>No PLW beneficiaries found matching \"{{ getSearchTerm(assessment.key) }}\"</p>\n              </div>\n              <table class=\"beneficiaries-table\" *ngIf=\"getFilteredBeneficiaries(assessment, 'plw').length > 0\">\n                <thead>\n                  <tr>\n                    <th>#</th>\n                    <th>FCN</th>\n                    <th>Name</th>\n                    <th>Husband Name</th>\n                    <th>Status</th>\n                    <th>Sub Block</th>\n                    <th>HH No</th>\n                    <th>Actions</th>\n                  </tr>\n                </thead>\n                <tbody>\n                  <ng-container *ngFor=\"let beneficiary of getFilteredBeneficiaries(assessment, 'plw'); let i = index\">\n                    <tr>\n                      <td>{{ i + 1 }}</td>\n                      <td class=\"fcn-cell\">{{ beneficiary.fcn }}</td>\n                      <td>\n                        <div class=\"beneficiary-name\">\n                          {{ beneficiary.displayName || beneficiary.name }}\n                        </div>\n                      </td>\n                      <td>{{ beneficiary.husbandName || 'N/A' }}</td>\n                      <td>\n                        <small *ngIf=\"beneficiary.isPregnant\" class=\"status-tag pregnant\">Pregnant</small>\n                        <small *ngIf=\"beneficiary.isLactating\" class=\"status-tag lactating\">Lactating</small>\n                        <small *ngIf=\"!beneficiary.isPregnant && !beneficiary.isLactating\" class=\"status-tag none\">N/A</small>\n                      </td>\n                      <td>{{ beneficiary.subBlock || beneficiary.subBlockTitle || 'N/A' }}</td>\n                      <td>{{ beneficiary.householdNo || beneficiary.current_location?.hh_no || 'N/A' }}</td>\n                      <td class=\"actions-cell\">\n                        <ion-button\n                          size=\"small\"\n                          [fill]=\"isActionButtonDisabled(assessment, beneficiary.id) ? 'solid' : 'outline'\"\n                          [color]=\"getActionButtonColor(assessment, beneficiary.id)\"\n                          (click)=\"handleBeneficiaryAction(assessment, beneficiary)\"\n                          [disabled]=\"isActionButtonDisabled(assessment, beneficiary.id)\"\n                          [title]=\"getActionButtonTitle(assessment, beneficiary.id)\">\n                          <ion-icon\n                            [name]=\"getActionButtonIcon(assessment, beneficiary.id)\"\n                            slot=\"start\">\n                          </ion-icon>\n                          {{ getActionButtonText(assessment, beneficiary.id) }}\n                        </ion-button>\n                      </td>\n                    </tr>\n                  </ng-container>\n                </tbody>\n              </table>\n            </div>\n\n            <!-- No Beneficiaries Found Message -->\n            <div *ngIf=\"!hasChildBeneficiaries(assessment) && !hasPlwBeneficiaries(assessment) && getSearchTerm(assessment.key)\" class=\"no-results\">\n              <ion-icon name=\"search-outline\" color=\"medium\"></ion-icon>\n              <p>No beneficiaries found matching \"{{ getSearchTerm(assessment.key) }}\"</p>\n              <ion-button fill=\"clear\" size=\"small\" (click)=\"clearSearch(assessment.key)\">\n                <ion-icon name=\"close-outline\" slot=\"start\"></ion-icon>\n                Clear Search\n              </ion-button>\n            </div>\n          </div>\n\n          <div class=\"action-buttons\">\n            <!-- Sync Completed Button -->\n            <ion-button\n              *ngIf=\"hasCompletedUnsynced(assessment)\"\n              fill=\"solid\"\n              color=\"tertiary\"\n              expand=\"block\"\n              (click)=\"syncCompletedAssessments(assessment)\"\n              [disabled]=\"syncingAssessment === assessment.key\">\n              <ion-icon\n                [name]=\"syncingAssessment === assessment.key ? 'sync-outline' : 'cloud-upload-outline'\"\n                slot=\"start\">\n              </ion-icon>\n              {{ syncingAssessment === assessment.key ? 'Syncing...' : 'Upload ' + getUnsyncedCompletedCount(assessment) + ' Unsynced Assessment' + (getUnsyncedCompletedCount(assessment) > 1 ? 's' : '') }}\n            </ion-button>\n\n            <!-- Mark as Complete Button -->\n            <ion-button\n              *ngIf=\"canMarkAsComplete(assessment)\"\n              fill=\"solid\"\n              color=\"success\"\n              expand=\"block\"\n              (click)=\"markAssessmentComplete(assessment)\">\n              <ion-icon name=\"checkmark-done-outline\" slot=\"start\"></ion-icon>\n              Mark Assessment as Complete\n            </ion-button>\n\n            <!-- Info message when no completed assessments and can't mark as complete -->\n            <div *ngIf=\"!hasAnyCompleted(assessment) && !canMarkAsComplete(assessment)\" class=\"no-completed-message\">\n              <ion-icon name=\"information-circle-outline\" color=\"medium\"></ion-icon>\n              <span>Complete individual assessments to enable sync, or mark assessment as complete</span>\n            </div>\n          </div>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Empty State -->\n    <ion-card *ngIf=\"savedAssessments.length === 0\">\n      <ion-card-content>\n        <div class=\"empty-state\">\n          <ion-icon name=\"clipboard-outline\" color=\"medium\"></ion-icon>\n          <h3>No Community Assessments</h3>\n          <p>You haven't saved any assessments for community use yet.</p>\n\n          <ion-button\n            expand=\"block\"\n            fill=\"outline\"\n            routerLink=\"/offline-assessment\">\n            <ion-icon name=\"add-outline\" slot=\"start\"></ion-icon>\n            Setup New Community Assessment\n          </ion-button>\n        </div>\n      </ion-card-content>\n    </ion-card>\n\n  </div>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_offline-survey-list_offline-survey-list_module_ts.js.map