(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_measurement-create_measurement-create_module_ts"],{

/***/ 99183:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/measurement-create/measurement-create-routing.module.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MeasurementCreatePageRoutingModule: () => (/* binding */ MeasurementCreatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _measurement_create_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./measurement-create.page */ 75745);




const routes = [{
  path: '',
  component: _measurement_create_page__WEBPACK_IMPORTED_MODULE_0__.MeasurementCreatePage
}];
let MeasurementCreatePageRoutingModule = class MeasurementCreatePageRoutingModule {};
MeasurementCreatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], MeasurementCreatePageRoutingModule);


/***/ }),

/***/ 27390:
/*!***********************************************************************!*\
  !*** ./src/app/pages/measurement-create/measurement-create.module.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MeasurementCreatePageModule: () => (/* binding */ MeasurementCreatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _measurement_create_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./measurement-create-routing.module */ 99183);
/* harmony import */ var _measurement_create_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./measurement-create.page */ 75745);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let MeasurementCreatePageModule = class MeasurementCreatePageModule {};
MeasurementCreatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _measurement_create_routing_module__WEBPACK_IMPORTED_MODULE_0__.MeasurementCreatePageRoutingModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule],
  declarations: [_measurement_create_page__WEBPACK_IMPORTED_MODULE_1__.MeasurementCreatePage]
})], MeasurementCreatePageModule);


/***/ }),

/***/ 75745:
/*!*********************************************************************!*\
  !*** ./src/app/pages/measurement-create/measurement-create.page.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MeasurementCreatePage: () => (/* binding */ MeasurementCreatePage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _measurement_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./measurement-create.page.html?ngResource */ 83339);
/* harmony import */ var _measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./measurement-create.page.scss?ngResource */ 42519);
/* harmony import */ var _measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_measurement_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/measurement_api.service */ 15433);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 10819);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 52575);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs/operators */ 91817);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);

var _MeasurementCreatePage;



/* eslint-disable @typescript-eslint/naming-convention */








let MeasurementCreatePage = (_MeasurementCreatePage = class MeasurementCreatePage {
  constructor(fb, api, activatedRoute, b, change, router) {
    this.fb = fb;
    this.api = api;
    this.activatedRoute = activatedRoute;
    this.b = b;
    this.change = change;
    this.router = router;
    this.isEditMode = false;
    this.oedema = ['0', '+', '++', '+++'];
    this.referralStatus = [{
      value: 'BSFP',
      label: 'BSFP'
    }, {
      value: 'TSFP',
      label: 'TSFP'
    }, {
      value: 'OTP',
      label: 'OTP'
    }];
    this.samReferralOptions = [{
      value: 'OTP',
      label: 'OTP'
    }];
    this.counsellingOptions = ['Yes', 'No'];
    this.showOthersInput = false;
    this.weightInputValue$ = new rxjs__WEBPACK_IMPORTED_MODULE_6__.Subject();
    this.heightInputValue$ = new rxjs__WEBPACK_IMPORTED_MODULE_6__.Subject();
    this.dateInputValue$ = new rxjs__WEBPACK_IMPORTED_MODULE_6__.Subject();
    this.NutritionStatusColor = src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.NutritionStatusColor;
    this.NutritionStatusID = src_app_util_utility__WEBPACK_IMPORTED_MODULE_5__.NutritionStatusIDs;
    this.isLastMeasurementExpanded = false;
    this.isOthersExpanded = false;
    // Check if we're in edit mode
    this.measurementId = this.activatedRoute.snapshot.paramMap.get('id');
    this.childId = this.activatedRoute.snapshot.paramMap.get('childId');
    this.isEditMode = !!this.measurementId;
    // Set today's date
    this.today = new Date().toISOString().split('T')[0];
    // Set minimum date (will be updated after loading last measurement data)
    const minDateObj = new Date();
    minDateObj.setDate(minDateObj.getDate() - 7);
    this.minDate = minDateObj.toISOString().split('T')[0];
    this.setupForm();
    if (!this.isEditMode && this.childId) {
      this.measurementForm.get('children_id').setValue(this.childId);
    }
  }
  ngOnInit() {
    this.load();
    this.setupZScoreCalculation();
  }
  setupForm() {
    this.measurementForm = this.fb.group({
      children_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      date: [this.today, [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      muac: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      weight: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      height: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      wfh_zscore: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]],
      haz_zscore: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]],
      waz_zscore: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]],
      nutrition_status: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      oedema: ['0', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      referral_status: [{
        value: null,
        disabled: true
      }, [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]],
      counselling: ['No', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      others: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]],
      others_specify: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.nullValidator]]
    });
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this.isEditMode) {
          // Load measurement for editing
          const response = yield _this.api.getMeasurementEditPreq(_this.measurementId);
          if (response.success) {
            // Map edit response to match MeasurementPreqData structure
            _this.measurementPreqData = {
              muac_cutoff: response.data.muac_cutoff,
              dob: response.data.dob,
              refer_from: response.data.refer_from,
              zscore: response.data.zscore,
              nutrition_status: response.data.nutrition_status,
              sex: response.data.sex,
              child_info: response.data.child_info,
              ongoing_assessment: response.data.ongoing_assessment || null
            };
            _this.child_info = response.data.child_info;
            _this.childId = response.data.measurement.children_id;
            // Populate form with measurement data
            // Enable nutrition_status temporarily to set value
            const nutritionControl = _this.measurementForm.get('nutrition_status');
            nutritionControl.enable({
              emitEvent: false
            });
            // Handle others field - if it's not VAS or Deworming, treat it as "Others" with specify value
            let othersValue = response.data.measurement.others;
            let othersSpecifyValue = '';
            if (othersValue && othersValue !== 'VAS' && othersValue !== 'Deworming') {
              othersSpecifyValue = othersValue;
              othersValue = 'Others';
              _this.showOthersInput = true;
            } else if (othersValue === 'Others') {
              _this.showOthersInput = true;
              // Use optional chaining since others_specify might not exist in the API response
              othersSpecifyValue = response.data.measurement.others_specify || '';
            }
            _this.measurementForm.patchValue({
              children_id: response.data.measurement.children_id,
              date: response.data.measurement.date,
              muac: response.data.measurement.muac,
              weight: response.data.measurement.weight,
              height: response.data.measurement.height,
              wfh_zscore: response.data.measurement.wfh_zscore,
              haz_zscore: response.data.measurement.haz_zscore,
              waz_zscore: response.data.measurement.waz_zscore,
              nutrition_status: response.data.measurement.nutrition_status,
              oedema: response.data.measurement.oedema || '0',
              referral_status: response.data.measurement.referral_status || null,
              counselling: response.data.measurement.counselling || 'No',
              others: othersValue,
              others_specify: othersSpecifyValue
            });
            // Disable nutrition_status after setting value
            nutritionControl.disable({
              emitEvent: false
            });
            _this.change.markForCheck();
          }
        } else {
          // Load for creating new measurement
          const response = yield _this.api.getMeasurementPreqData(_this.childId);
          if (response.success) {
            var _this$measurementPreq, _this$measurementPreq2;
            _this.measurementPreqData = response.data;
            _this.child_info = response.data.child_info;
            // Set minimum date based on last measurement date
            if ((_this$measurementPreq = _this.measurementPreqData.last_measurement) !== null && _this$measurementPreq !== void 0 && _this$measurementPreq.date) {
              const lastMeasurementDate = new Date(_this.measurementPreqData.last_measurement.date);
              // Add 1 day to last measurement date to ensure new measurement is after it
              lastMeasurementDate.setDate(lastMeasurementDate.getDate() + 1);
              _this.minDate = lastMeasurementDate.toISOString().split('T')[0];
            }
            // Prefill height from last measurement if available
            if ((_this$measurementPreq2 = _this.measurementPreqData.last_measurement) !== null && _this$measurementPreq2 !== void 0 && _this$measurementPreq2.height) {
              _this.measurementForm.patchValue({
                height: _this.measurementPreqData.last_measurement.height
              });
            }
            // Initialize referral status based on ongoing assessment
            _this.initializeReferralStatus();
            _this.change.markForCheck();
          }
        }
      } catch (error) {
        _this.b.toast('Failed to load prerequisite data');
      }
    })();
  }
  setupZScoreCalculation() {
    var _this2 = this;
    // Auto-calculate z-score when weight, height, or date changes
    this.weightInputValue$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(500), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)()).subscribe(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.calculateZScore();
    }));
    this.heightInputValue$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(500), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)()).subscribe(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.calculateZScore();
    }));
    this.dateInputValue$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.debounceTime)(500), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)()).subscribe(/*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.calculateZScore();
    }));
  }
  calculateZScore() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var _this3$measurementPre, _this3$measurementPre2;
      const weight = _this3.measurementForm.get('weight').value;
      const height = _this3.measurementForm.get('height').value;
      const sex = (_this3$measurementPre = _this3.measurementPreqData) === null || _this3$measurementPre === void 0 ? void 0 : _this3$measurementPre.sex;
      const dob = (_this3$measurementPre2 = _this3.measurementPreqData) === null || _this3$measurementPre2 === void 0 ? void 0 : _this3$measurementPre2.dob;
      const measurementDate = _this3.measurementForm.get('date').value;
      if (weight && height && sex && dob) {
        try {
          _this3.api.getZScore(sex, height, weight, dob, measurementDate).subscribe({
            next: response => {
              if (response.success && response.data) {
                const zscores = response.data;
                // Set all three z-scores
                _this3.measurementForm.get('wfh_zscore').setValue(zscores.wfh_zscore || 'N/A');
                _this3.measurementForm.get('haz_zscore').setValue(zscores.haz_zscore || 'N/A');
                _this3.measurementForm.get('waz_zscore').setValue(zscores.waz_zscore || 'N/A');
                _this3.measurementForm.get('wfh_zscore').updateValueAndValidity();
                _this3.measurementForm.get('haz_zscore').updateValueAndValidity();
                _this3.measurementForm.get('waz_zscore').updateValueAndValidity();
                // Use WFH z-score for nutrition status calculation (wasting indicator)
                _this3.changeNutritionStatus({
                  zscore: zscores.wfh_zscore
                });
                _this3.change.detectChanges();
              }
            },
            error: error => {}
          });
        } catch (error) {}
      } else {
        _this3.measurementForm.get('wfh_zscore').setValue('');
        _this3.measurementForm.get('haz_zscore').setValue('');
        _this3.measurementForm.get('waz_zscore').setValue('');
      }
    })();
  }
  onWeightChange(event) {
    var _event$detail, _event$target;
    const value = ((_event$detail = event.detail) === null || _event$detail === void 0 ? void 0 : _event$detail.value) || ((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.value);
    this.weightInputValue$.next(value);
  }
  onHeightChange(event) {
    var _event$detail2, _event$target2;
    const value = ((_event$detail2 = event.detail) === null || _event$detail2 === void 0 ? void 0 : _event$detail2.value) || ((_event$target2 = event.target) === null || _event$target2 === void 0 ? void 0 : _event$target2.value);
    this.heightInputValue$.next(value);
  }
  onDateChange(event) {
    var _event$detail3, _event$target3;
    const value = ((_event$detail3 = event.detail) === null || _event$detail3 === void 0 ? void 0 : _event$detail3.value) || ((_event$target3 = event.target) === null || _event$target3 === void 0 ? void 0 : _event$target3.value);
    this.dateInputValue$.next(value);
  }
  onMuacChange(event) {
    var _event$detail4, _event$target4;
    const value = ((_event$detail4 = event.detail) === null || _event$detail4 === void 0 ? void 0 : _event$detail4.value) || ((_event$target4 = event.target) === null || _event$target4 === void 0 ? void 0 : _event$target4.value);
    this.changeNutritionStatus({
      muac: value
    });
  }
  onOedemaChange(event) {
    var _event$detail5, _event$target5;
    const value = ((_event$detail5 = event.detail) === null || _event$detail5 === void 0 ? void 0 : _event$detail5.value) || ((_event$target5 = event.target) === null || _event$target5 === void 0 ? void 0 : _event$target5.value);
    this.changeNutritionStatus({
      oedema: value
    });
  }
  onOthersChange(event) {
    var _event$detail6, _event$target6;
    const value = ((_event$detail6 = event.detail) === null || _event$detail6 === void 0 ? void 0 : _event$detail6.value) || ((_event$target6 = event.target) === null || _event$target6 === void 0 ? void 0 : _event$target6.value);
    this.showOthersInput = value === 'Others';
    // Clear the others_specify field if not selecting Others
    if (!this.showOthersInput) {
      this.measurementForm.get('others_specify').setValue('');
    }
    this.change.detectChanges();
  }
  changeNutritionStatus(value) {
    var _this$measurementForm, _this$measurementForm2, _this$measurementForm3, _this$measurementPreq3, _this$measurementPreq4, _this$measurementPreq5;
    const muac = +((_this$measurementForm = this.measurementForm.get('muac')) === null || _this$measurementForm === void 0 ? void 0 : _this$measurementForm.value);
    const zscore = (_this$measurementForm2 = this.measurementForm.get('wfh_zscore')) === null || _this$measurementForm2 === void 0 ? void 0 : _this$measurementForm2.value;
    const oedema = (_this$measurementForm3 = this.measurementForm.get('oedema')) === null || _this$measurementForm3 === void 0 ? void 0 : _this$measurementForm3.value;
    const nutritionControl = this.measurementForm.get('nutrition_status');
    nutritionControl.enable({
      emitEvent: false
    });
    const hasOedema = oedema === '+' || oedema === '++' || oedema === '+++';
    const hasZscoreSAM = zscore === '< - 3SD';
    const hasMuacSAM = muac <= +((_this$measurementPreq3 = this.measurementPreqData) === null || _this$measurementPreq3 === void 0 || (_this$measurementPreq3 = _this$measurementPreq3.muac_cutoff) === null || _this$measurementPreq3 === void 0 ? void 0 : _this$measurementPreq3.child_sam) && muac !== 0;
    let nutritionStatus;
    if (hasOedema || hasZscoreSAM || hasMuacSAM) {
      // SAM case
      nutritionStatus = this.NutritionStatusID.SAM;
      nutritionControl.setValue(nutritionStatus);
    } else if (zscore === '< - 2SD' || zscore === '> - 3SD' || zscore === '= - 3SD' || muac > +((_this$measurementPreq4 = this.measurementPreqData) === null || _this$measurementPreq4 === void 0 || (_this$measurementPreq4 = _this$measurementPreq4.muac_cutoff) === null || _this$measurementPreq4 === void 0 ? void 0 : _this$measurementPreq4.child_sam) && muac <= +((_this$measurementPreq5 = this.measurementPreqData) === null || _this$measurementPreq5 === void 0 || (_this$measurementPreq5 = _this$measurementPreq5.muac_cutoff) === null || _this$measurementPreq5 === void 0 ? void 0 : _this$measurementPreq5.child_mam)) {
      // MAM case
      nutritionStatus = this.NutritionStatusID.MAM;
      nutritionControl.setValue(nutritionStatus);
    } else {
      // Normal case
      nutritionStatus = this.NutritionStatusID.NORMAL;
      nutritionControl.setValue(nutritionStatus);
    }
    nutritionControl.disable({
      emitEvent: false
    });
    // Calculate referral status based on nutrition status and ongoing assessment
    this.calculateReferralStatus(nutritionStatus);
  }
  initializeReferralStatus() {
    var _this$measurementPreq6;
    // Set initial referral status when form loads (before any measurements)
    const referralControl = this.measurementForm.get('referral_status');
    const ongoingAssessment = (_this$measurementPreq6 = this.measurementPreqData) === null || _this$measurementPreq6 === void 0 ? void 0 : _this$measurementPreq6.ongoing_assessment;
    // For new measurements, always start with null
    // Referral status will be calculated based on nutrition status
    referralControl.enable({
      emitEvent: false
    });
    referralControl.setValue(null);
    referralControl.disable({
      emitEvent: false
    });
    this.change.detectChanges();
  }
  calculateReferralStatus(nutritionStatus) {
    var _this$measurementPreq7;
    const referralControl = this.measurementForm.get('referral_status');
    const ongoingAssessment = (_this$measurementPreq7 = this.measurementPreqData) === null || _this$measurementPreq7 === void 0 ? void 0 : _this$measurementPreq7.ongoing_assessment;
    // Enable control temporarily to set value
    referralControl.enable({
      emitEvent: false
    });
    // If ongoing is OTP, always set to null regardless of nutrition status
    if (ongoingAssessment === 'OTP') {
      referralControl.setValue(null);
      referralControl.disable({
        emitEvent: false
      });
      this.change.detectChanges();
      return;
    }
    if (nutritionStatus === this.NutritionStatusID.SAM) {
      // SAM case: if ongoing is BSFP or TSFP, auto set to OTP (read-only)
      // if no ongoing, auto set to OTP (read-only)
      if (ongoingAssessment === 'BSFP' || ongoingAssessment === 'TSFP' || !ongoingAssessment) {
        referralControl.setValue('OTP');
        referralControl.disable({
          emitEvent: false
        });
        this.change.detectChanges();
        return;
      }
    } else if (nutritionStatus === this.NutritionStatusID.MAM) {
      // MAM case:
      // - if ongoing is BSFP, set to TSFP
      // - if ongoing is TSFP, set to null (no referral needed)
      // - if no ongoing, set to TSFP
      if (ongoingAssessment === 'BSFP') {
        referralControl.setValue('TSFP');
      } else if (ongoingAssessment === 'TSFP') {
        referralControl.setValue(null);
      } else {
        referralControl.setValue('TSFP');
      }
    } else if (nutritionStatus === this.NutritionStatusID.NORMAL) {
      // NORMAL case:
      // - if no ongoing, set to BSFP
      // - if ongoing is BSFP or TSFP, set to null (no referral needed)
      if (!ongoingAssessment) {
        referralControl.setValue('BSFP');
      } else if (ongoingAssessment === 'BSFP' || ongoingAssessment === 'TSFP') {
        referralControl.setValue(null);
      } else {
        referralControl.setValue(null);
      }
    } else {
      // Fallback - no nutrition status set yet
      referralControl.setValue(null);
    }
    // Disable control (read-only) for all cases
    referralControl.disable({
      emitEvent: false
    });
    this.change.detectChanges();
  }
  onSubmit() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Mark all fields as touched to show validation errors
      _this4.markFormGroupTouched(_this4.measurementForm);
      // Enable nutrition_status and referral_status controls before validation
      const nutritionControl = _this4.measurementForm.get('nutrition_status');
      const referralControl = _this4.measurementForm.get('referral_status');
      nutritionControl.enable({
        emitEvent: false
      });
      referralControl.enable({
        emitEvent: false
      });
      // Comprehensive validation with detailed error messages
      const validationErrors = _this4.validateFormFields(_this4.measurementForm);
      if (validationErrors.length > 0) {
        // Show the first validation error
        _this4.b.errorToast(validationErrors[0]);
        // Disable fields again
        nutritionControl.disable({
          emitEvent: false
        });
        referralControl.disable({
          emitEvent: false
        });
        return;
      }
      if (_this4.measurementForm.valid) {
        try {
          // Get form values and convert numbers to strings
          const formValue = {
            ..._this4.measurementForm.value
          };
          // Handle others field - if "Others" is selected, use the others_specify value
          if (formValue.others === 'Others' && formValue.others_specify) {
            formValue.others = formValue.others_specify;
          }
          // Remove others_specify from the form data as it's not needed in API
          delete formValue.others_specify;
          // Convert numeric fields to strings as API expects
          if (formValue.muac !== null && formValue.muac !== '') {
            formValue.muac = String(formValue.muac);
          }
          if (formValue.weight !== null && formValue.weight !== '') {
            formValue.weight = String(formValue.weight);
          }
          if (formValue.height !== null && formValue.height !== '') {
            formValue.height = String(formValue.height);
          }
          if (formValue.wfh_zscore !== null && formValue.wfh_zscore !== '') {
            formValue.wfh_zscore = String(formValue.wfh_zscore);
          }
          if (formValue.haz_zscore !== null && formValue.haz_zscore !== '') {
            formValue.haz_zscore = String(formValue.haz_zscore);
          }
          if (formValue.waz_zscore !== null && formValue.waz_zscore !== '') {
            formValue.waz_zscore = String(formValue.waz_zscore);
          }
          let result;
          if (_this4.isEditMode) {
            result = yield _this4.api.measurementUpdate(formValue, _this4.measurementId);
          } else {
            result = yield _this4.api.measurementStore(formValue);
          }
          if (result.success) {
            _this4.b.toast(result.message || `Measurement ${_this4.isEditMode ? 'updated' : 'created'} successfully`);
            if (!_this4.isEditMode) {
              _this4.resetMeasurementForm();
            }
            _this4.router.navigate(['/child-detail', _this4.childId], {
              queryParams: {
                reload: true
              }
            });
          }
          // Error handling is done in api_base.service.ts errorHandle() method
          // No need to display error toast again here as it's already shown
          // Disable them again after submit
          nutritionControl.disable({
            emitEvent: false
          });
          referralControl.disable({
            emitEvent: false
          });
        } catch (error) {
          _this4.b.errorToast(`Error ${_this4.isEditMode ? 'updating' : 'creating'} measurement`);
          // Disable fields again
          nutritionControl.disable({
            emitEvent: false
          });
          referralControl.disable({
            emitEvent: false
          });
        }
      } else {
        // If form is invalid but no custom validation errors were caught
        const formErrors = _this4.getDetailedFormErrors();
        _this4.b.errorToast(formErrors || 'Please fill out all required fields correctly');
        // Disable fields again
        nutritionControl.disable({
          emitEvent: false
        });
        referralControl.disable({
          emitEvent: false
        });
      }
    })();
  }
  validateFormFields(formGroup) {
    var _formGroup$get, _formGroup$get2, _formGroup$get3, _formGroup$get4, _formGroup$get5, _formGroup$get6, _formGroup$get7, _formGroup$get8;
    const errors = [];
    // MUAC validation
    const muacValue = (_formGroup$get = formGroup.get('muac')) === null || _formGroup$get === void 0 ? void 0 : _formGroup$get.value;
    if (!muacValue || muacValue.toString().trim() === '') {
      errors.push('MUAC is required');
    }
    // Weight validation
    const weightValue = (_formGroup$get2 = formGroup.get('weight')) === null || _formGroup$get2 === void 0 ? void 0 : _formGroup$get2.value;
    if (!weightValue || weightValue.toString().trim() === '') {
      errors.push('Weight is required');
    }
    // Height validation
    const heightValue = (_formGroup$get3 = formGroup.get('height')) === null || _formGroup$get3 === void 0 ? void 0 : _formGroup$get3.value;
    if (!heightValue || heightValue.toString().trim() === '') {
      errors.push('Height is required');
    }
    // Z-scores validation
    const wfhZscore = (_formGroup$get4 = formGroup.get('wfh_zscore')) === null || _formGroup$get4 === void 0 ? void 0 : _formGroup$get4.value;
    if (!wfhZscore || wfhZscore.toString().trim() === '') {
      errors.push('WFH Z-Score is required. Please enter weight and height to calculate.');
    }
    const hazZscore = (_formGroup$get5 = formGroup.get('haz_zscore')) === null || _formGroup$get5 === void 0 ? void 0 : _formGroup$get5.value;
    if (!hazZscore || hazZscore.toString().trim() === '') {
      errors.push('HAZ Z-Score is required. Please enter weight and height to calculate.');
    }
    const wazZscore = (_formGroup$get6 = formGroup.get('waz_zscore')) === null || _formGroup$get6 === void 0 ? void 0 : _formGroup$get6.value;
    if (!wazZscore || wazZscore.toString().trim() === '') {
      errors.push('WAZ Z-Score is required. Please enter weight and height to calculate.');
    }
    // Nutrition status validation
    const nutritionStatus = (_formGroup$get7 = formGroup.get('nutrition_status')) === null || _formGroup$get7 === void 0 ? void 0 : _formGroup$get7.value;
    if (!nutritionStatus || nutritionStatus.toString().trim() === '') {
      errors.push('Nutrition status is required. Z-scores must be calculated first.');
    }
    // Date validation
    const dateValue = (_formGroup$get8 = formGroup.get('date')) === null || _formGroup$get8 === void 0 ? void 0 : _formGroup$get8.value;
    if (!dateValue || dateValue.toString().trim() === '') {
      errors.push('Measurement date is required');
    } else {
      var _this$measurementPreq8;
      // Check if date is before last measurement
      if (!this.isEditMode && (_this$measurementPreq8 = this.measurementPreqData) !== null && _this$measurementPreq8 !== void 0 && (_this$measurementPreq8 = _this$measurementPreq8.last_measurement) !== null && _this$measurementPreq8 !== void 0 && _this$measurementPreq8.date) {
        const selectedDate = new Date(dateValue);
        const lastMeasurementDate = new Date(this.measurementPreqData.last_measurement.date);
        if (selectedDate <= lastMeasurementDate) {
          errors.push(`Measurement date must be after the last measurement date (${this.measurementPreqData.last_measurement.date})`);
        }
      }
      // Check if date is in the future
      const selectedDate = new Date(dateValue);
      const today = new Date();
      today.setHours(0, 0, 0, 0);
      selectedDate.setHours(0, 0, 0, 0);
      if (selectedDate > today) {
        errors.push('Measurement date cannot be in the future');
      }
    }
    return errors;
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      control === null || control === void 0 || control.markAsTouched();
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormGroup) {
        this.markFormGroupTouched(control);
      }
    });
    this.change.markForCheck();
  }
  getDetailedFormErrors() {
    const errors = [];
    const controls = this.measurementForm.controls;
    Object.keys(controls).forEach(key => {
      const control = controls[key];
      if (control && control.invalid && control.errors) {
        const fieldName = this.getFieldDisplayName(key);
        if (control.errors['required']) {
          errors.push(`${fieldName} is required`);
        }
      }
    });
    return errors.length > 0 ? errors[0] : 'Please check all fields and try again';
  }
  getFieldDisplayName(fieldName) {
    const displayNames = {
      'children_id': 'Child ID',
      'date': 'Measurement Date',
      'muac': 'MUAC',
      'weight': 'Weight',
      'height': 'Height',
      'wfh_zscore': 'WFH Z-Score',
      'haz_zscore': 'HAZ Z-Score',
      'waz_zscore': 'WAZ Z-Score',
      'nutrition_status': 'Nutrition Status',
      'oedema': 'Oedema',
      'referral_status': 'Referral Status',
      'counselling': 'Counselling',
      'others': 'Campaign Information',
      'others_specify': 'Other Campaign Details'
    };
    return displayNames[fieldName] || fieldName;
  }
  getAgeInMonths(dateOfBirth) {
    if (!dateOfBirth) {
      return 'N/A';
    }
    const dob = new Date(dateOfBirth);
    const today = new Date();
    let years = today.getFullYear() - dob.getFullYear();
    let months = today.getMonth() - dob.getMonth();
    let days = today.getDate() - dob.getDate();
    if (days < 0) {
      months--;
      const lastDayOfPrevMonth = new Date(today.getFullYear(), today.getMonth(), 0).getDate();
      days += lastDayOfPrevMonth;
    }
    if (months < 0) {
      years--;
      months += 12;
    }
    const totalMonths = years * 12 + months;
    let result = '';
    if (totalMonths > 0) {
      result += `${totalMonths} Months`;
    }
    if (days > 0) {
      if (result.length > 0) {
        result += ' ';
      }
      result += `${days} days`;
    }
    return result || '0d';
  }
  isFieldInvalid(fieldName) {
    const field = this.measurementForm.get(fieldName);
    return field && field.invalid && (field.dirty || field.touched);
  }
  getNutritionStatusTitle(statusId) {
    var _this$measurementPreq9;
    if (!statusId || !((_this$measurementPreq9 = this.measurementPreqData) !== null && _this$measurementPreq9 !== void 0 && _this$measurementPreq9.nutrition_status)) {
      return '';
    }
    const status = this.measurementPreqData.nutrition_status.find(s => s.id === statusId);
    return status ? status.title : '';
  }
  toggleLastMeasurement() {
    this.isLastMeasurementExpanded = !this.isLastMeasurementExpanded;
  }
  toggleOthersAccordion() {
    this.isOthersExpanded = !this.isOthersExpanded;
  }
  getZScoreSeverityClass(zscoreValue) {
    if (!zscoreValue || zscoreValue === 'N/A' || zscoreValue === '') {
      return '';
    }
    // Parse z-score string like "< - 3SD", ">= -2SD", etc.
    // Convert to number for comparison
    let numericValue;
    if (zscoreValue.includes('< - 3SD') || zscoreValue.includes('<-3SD')) {
      numericValue = -3.5; // Severe (< -3)
    } else if (zscoreValue.includes('< - 2SD') || zscoreValue.includes('<-2SD') || zscoreValue.includes('> - 3SD') || zscoreValue.includes('>-3SD') || zscoreValue.includes('= - 3SD') || zscoreValue.includes('=-3SD')) {
      numericValue = -2.5; // Moderate (-3 to -2)
    } else if (zscoreValue.includes('< - 1SD') || zscoreValue.includes('<-1SD') || zscoreValue.includes('>= -2SD') || zscoreValue.includes('>=-2SD') || zscoreValue.includes('= - 2SD') || zscoreValue.includes('=-2SD')) {
      numericValue = -1.5; // Normal (>= -2)
    } else {
      // Try to parse as a plain number
      const match = zscoreValue.match(/-?\d+\.?\d*/);
      if (match) {
        numericValue = parseFloat(match[0]);
      } else {
        return ''; // Default/normal if can't parse
      }
    }
    // Apply severity classes based on thresholds
    if (numericValue < -3) {
      return 'zscore-severe'; // Reddish
    } else if (numericValue < -2) {
      return 'zscore-moderate'; // Yellowish
    } else {
      return 'zscore-normal'; // Greenish
    }
  }
  resetMeasurementForm() {
    this.today = new Date().toISOString().split('T')[0];
    const minDateObj = new Date();
    minDateObj.setDate(minDateObj.getDate() - 7);
    this.minDate = minDateObj.toISOString().split('T')[0];
    this.setupForm();
    if (!this.isEditMode && this.childId) {
      this.measurementForm.get('children_id').setValue(this.childId);
    }
    this.initializeReferralStatus();
    this.measurementForm.markAsPristine();
    this.measurementForm.markAsUntouched();
    this.change.detectChanges();
  }
}, _MeasurementCreatePage.ctorParameters = () => [{
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder
}, {
  type: src_app_services_measurement_api_service__WEBPACK_IMPORTED_MODULE_3__.MeasurementAPIService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.ActivatedRoute
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ChangeDetectorRef
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.Router
}], _MeasurementCreatePage);
MeasurementCreatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-measurement-create',
  template: _measurement_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_measurement_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], MeasurementCreatePage);


/***/ }),

/***/ 52575:
/*!***********************************************************************!*\
  !*** ./node_modules/rxjs/dist/esm/internal/operators/debounceTime.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounceTime: () => (/* binding */ debounceTime)
/* harmony export */ });
/* harmony import */ var _scheduler_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scheduler/async */ 18473);
/* harmony import */ var _util_lift__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/lift */ 50819);
/* harmony import */ var _OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OperatorSubscriber */ 91687);



function debounceTime(dueTime, scheduler = _scheduler_async__WEBPACK_IMPORTED_MODULE_0__.asyncScheduler) {
  return (0,_util_lift__WEBPACK_IMPORTED_MODULE_1__.operate)((source, subscriber) => {
    let activeTask = null;
    let lastValue = null;
    let lastTime = null;
    const emit = () => {
      if (activeTask) {
        activeTask.unsubscribe();
        activeTask = null;
        const value = lastValue;
        lastValue = null;
        subscriber.next(value);
      }
    };
    function emitWhenIdle() {
      const targetTime = lastTime + dueTime;
      const now = scheduler.now();
      if (now < targetTime) {
        activeTask = this.schedule(undefined, targetTime - now);
        subscriber.add(activeTask);
        return;
      }
      emit();
    }
    source.subscribe((0,_OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__.createOperatorSubscriber)(subscriber, value => {
      lastValue = value;
      lastTime = scheduler.now();
      if (!activeTask) {
        activeTask = scheduler.schedule(emitWhenIdle, dueTime);
        subscriber.add(activeTask);
      }
    }, () => {
      emit();
      subscriber.complete();
    }, undefined, () => {
      lastValue = activeTask = null;
    }));
  });
}

/***/ }),

/***/ 42519:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/measurement-create/measurement-create.page.scss?ngResource ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.measurement-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.measurement-form .form-section {
  margin-bottom: 32px;
}
.measurement-form .form-section:last-child {
  margin-bottom: 0;
}
.measurement-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.measurement-form .section-subtitle ion-icon {
  font-size: 20px;
}
.measurement-form .section-subtitle.collapsible-header {
  cursor: pointer;
  justify-content: space-between;
  padding: 12px;
  background: rgba(73, 144, 226, 0.05);
  border-radius: 8px;
  border-bottom: none;
  transition: all 0.3s ease;
  -webkit-user-select: none;
          user-select: none;
}
.measurement-form .section-subtitle.collapsible-header:hover {
  background: rgba(73, 144, 226, 0.1);
  transform: translateX(2px);
}
.measurement-form .section-subtitle.collapsible-header:active {
  transform: scale(0.98);
}
.measurement-form .section-subtitle.collapsible-header .header-content {
  display: flex;
  align-items: center;
  gap: 8px;
}
.measurement-form .section-subtitle.collapsible-header .collapse-icon {
  font-size: 24px;
  transition: transform 0.3s ease;
}
.measurement-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.measurement-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.measurement-form .form-item:has(ion-radio-group) {
  padding: 12px;
  background: rgba(255, 255, 255, 0.8);
}
.measurement-form .form-item:has(ion-radio-group) .form-label {
  display: flex;
  align-items: center;
  gap: 8px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin-bottom: 12px;
  font-size: 14px;
}
.measurement-form .form-item:has(ion-radio-group) .form-label ion-icon {
  font-size: 18px;
}
.measurement-form .form-item:has(ion-radio-group) ion-radio-group {
  display: flex;
  flex-direction: column;
  gap: 8px;
}
.measurement-form .form-item:has(ion-radio-group) ion-radio-group ion-item {
  --background: transparent;
  --border-color: transparent;
  --padding-start: 0;
  --inner-padding-end: 0;
  --min-height: 36px;
  margin: 0;
  border: none;
}
.measurement-form .form-item:has(ion-radio-group) ion-radio-group ion-item ion-radio {
  margin-right: 12px;
}
.measurement-form .form-item:has(ion-radio-group) ion-radio-group ion-item ion-label {
  font-weight: 500;
  font-size: 14px;
}
.measurement-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.measurement-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.measurement-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.measurement-form .form-item.auto-filled-item {
  background: rgba(45, 211, 111, 0.05);
  border-color: rgba(45, 211, 111, 0.2);
}
.measurement-form .form-item.auto-filled-item .auto-filled-input {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
}
.measurement-form .form-item.auto-filled-item ion-label {
  color: var(--ion-color-success) !important;
  font-weight: 600;
}
.measurement-form .form-item.nutrition-status-1 {
  background: rgba(var(--ion-color-danger-rgb), 0.1);
  border-color: rgba(var(--ion-color-danger-rgb), 0.3);
}
.measurement-form .form-item.nutrition-status-1 ion-label {
  color: var(--ion-color-danger-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-1 ion-icon {
  color: var(--ion-color-danger-shade);
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-1 ion-input {
  --color: var(--ion-color-danger-shade);
  color: var(--ion-color-danger-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-2 {
  background: rgba(var(--ion-color-warning-rgb), 0.15);
  border-color: rgba(var(--ion-color-warning-rgb), 0.4);
}
.measurement-form .form-item.nutrition-status-2 ion-label {
  color: var(--ion-color-warning-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-2 ion-icon {
  color: var(--ion-color-warning-shade);
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-2 ion-input {
  --color: var(--ion-color-warning-shade);
  color: var(--ion-color-warning-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 {
  background: rgba(var(--ion-color-success-rgb), 0.1);
  border-color: rgba(var(--ion-color-success-rgb), 0.3);
}
.measurement-form .form-item.nutrition-status-3 ion-label {
  color: var(--ion-color-success-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 ion-icon {
  color: var(--ion-color-success-shade);
  opacity: 1;
}
.measurement-form .form-item.nutrition-status-3 ion-input {
  --color: var(--ion-color-success-shade);
  color: var(--ion-color-success-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-1 {
  background: rgba(var(--ion-color-danger-rgb), 0.1);
  border-color: rgba(var(--ion-color-danger-rgb), 0.3);
}
.measurement-form .form-item.referral-status-1 ion-label {
  color: var(--ion-color-danger-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-1 ion-icon {
  color: var(--ion-color-danger-shade);
  opacity: 1;
}
.measurement-form .form-item.referral-status-1 ion-input {
  --color: var(--ion-color-danger-shade);
  color: var(--ion-color-danger-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-2 {
  background: rgba(var(--ion-color-warning-rgb), 0.15);
  border-color: rgba(var(--ion-color-warning-rgb), 0.4);
}
.measurement-form .form-item.referral-status-2 ion-label {
  color: var(--ion-color-warning-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-2 ion-icon {
  color: var(--ion-color-warning-shade);
  opacity: 1;
}
.measurement-form .form-item.referral-status-2 ion-input {
  --color: var(--ion-color-warning-shade);
  color: var(--ion-color-warning-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-3 {
  background: rgba(var(--ion-color-success-rgb), 0.1);
  border-color: rgba(var(--ion-color-success-rgb), 0.3);
}
.measurement-form .form-item.referral-status-3 ion-label {
  color: var(--ion-color-success-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.referral-status-3 ion-icon {
  color: var(--ion-color-success-shade);
  opacity: 1;
}
.measurement-form .form-item.referral-status-3 ion-input {
  --color: var(--ion-color-success-shade);
  color: var(--ion-color-success-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-severe {
  background: rgba(var(--ion-color-danger-rgb), 0.1);
  border-color: rgba(var(--ion-color-danger-rgb), 0.3);
}
.measurement-form .form-item.zscore-severe ion-label {
  color: var(--ion-color-danger-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-severe ion-icon {
  color: var(--ion-color-danger-shade);
  opacity: 1;
}
.measurement-form .form-item.zscore-severe ion-input {
  --color: var(--ion-color-danger-shade);
  color: var(--ion-color-danger-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-moderate {
  background: rgba(var(--ion-color-warning-rgb), 0.15);
  border-color: rgba(var(--ion-color-warning-rgb), 0.4);
}
.measurement-form .form-item.zscore-moderate ion-label {
  color: var(--ion-color-warning-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-moderate ion-icon {
  color: var(--ion-color-warning-shade);
  opacity: 1;
}
.measurement-form .form-item.zscore-moderate ion-input {
  --color: var(--ion-color-warning-shade);
  color: var(--ion-color-warning-shade);
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-normal {
  background: rgba(var(--ion-color-success-rgb), 0.1);
  border-color: rgba(var(--ion-color-success-rgb), 0.3);
}
.measurement-form .form-item.zscore-normal ion-label {
  color: var(--ion-color-success-shade) !important;
  font-weight: 700;
  opacity: 1;
}
.measurement-form .form-item.zscore-normal ion-icon {
  color: var(--ion-color-success-shade);
  opacity: 1;
}
.measurement-form .form-item.zscore-normal ion-input {
  --color: var(--ion-color-success-shade);
  color: var(--ion-color-success-shade);
  font-weight: 700;
  opacity: 1;
}

.child-info-card,
.last-measurement-card {
  margin: 16px 0;
}

.last-measurement-card {
  animation: slideDown 0.3s ease-out;
}
.last-measurement-card ion-card {
  background: rgba(73, 144, 226, 0.03);
  border: 1px solid rgba(73, 144, 226, 0.15);
}

@keyframes slideDown {
  from {
    opacity: 0;
    transform: translateY(-10px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.child-info-card .child-card,
.child-info-card .measurement-card,
.last-measurement-card .child-card,
.last-measurement-card .measurement-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.child-info-card .child-card ion-card-header,
.child-info-card .measurement-card ion-card-header,
.last-measurement-card .child-card ion-card-header,
.last-measurement-card .measurement-card ion-card-header {
  --background: #f8f9fa;
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}
.child-info-card .child-card ion-card-header ion-card-title,
.child-info-card .measurement-card ion-card-header ion-card-title,
.last-measurement-card .child-card ion-card-header ion-card-title,
.last-measurement-card .measurement-card ion-card-header ion-card-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.child-info-card .child-card ion-card-header ion-card-title ion-icon,
.child-info-card .measurement-card ion-card-header ion-card-title ion-icon,
.last-measurement-card .child-card ion-card-header ion-card-title ion-icon,
.last-measurement-card .measurement-card ion-card-header ion-card-title ion-icon {
  font-size: 20px;
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.child-info-card .info-item,
.last-measurement-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.child-info-card .info-item:last-child,
.last-measurement-card .info-item:last-child {
  margin-bottom: 0;
}
.child-info-card .info-item:hover,
.last-measurement-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.child-info-card .info-item ion-icon,
.last-measurement-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.child-info-card .item-content,
.last-measurement-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.child-info-card .item-content .label,
.last-measurement-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value,
.last-measurement-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value:empty::after,
.last-measurement-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-dark);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-primary), transparent);
  border-radius: 1px;
}

@media (min-width: 768px) {
  .measurement-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .submit-btn {
    min-width: 200px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
  .child-info-card,
  .last-measurement-card {
    margin: 12px 0;
  }
  .child-info-card .profile-content,
  .last-measurement-card .profile-content {
    padding: 16px;
  }
  .child-info-card .content-grid ion-col,
  .last-measurement-card .content-grid ion-col {
    padding: 0 3px;
  }
  .child-info-card .content-grid ion-col:first-child,
  .last-measurement-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .child-info-card .content-grid ion-col:last-child,
  .last-measurement-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .child-info-card .info-item,
  .last-measurement-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .child-info-card .info-item ion-icon,
  .last-measurement-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .child-info-card .item-content .label,
  .last-measurement-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .child-info-card .item-content .value,
  .last-measurement-card .item-content .value {
    font-size: 13px;
  }
}
@media (prefers-color-scheme: dark) {
  .form-item.auto-filled-item {
    background: rgba(45, 211, 111, 0.08);
    border-color: rgba(45, 211, 111, 0.3);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
  .child-card ion-card-header,
  .measurement-card ion-card-header {
    --background: rgba(255, 255, 255, 0.05);
    border-bottom-color: rgba(255, 255, 255, 0.1);
  }
  .info-item {
    background: rgba(255, 255, 255, 0.03);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .info-item:hover {
    background: rgba(73, 144, 226, 0.08);
    border-color: rgba(73, 144, 226, 0.3);
  }
}
@media (prefers-reduced-motion: reduce) {
  * {
    transition: none !important;
    animation: none !important;
  }
  .last-measurement-card {
    animation: none !important;
  }
  .collapsible-header {
    transition: none !important;
  }
}
@media (prefers-contrast: high) {
  .form-item {
    border-width: 2px;
  }
  .section-subtitle {
    border-bottom-width: 3px;
  }
  ion-label {
    font-weight: 600;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/measurement-create/measurement-create.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAYI;EACE,eAAA;EACA,8BAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,mBAAA;EACA,yBAAA;EACA,yBAAA;UAAA,iBAAA;AAVN;AAYM;EACE,mCAAA;EACA,0BAAA;AAVR;AAaM;EACE,sBAAA;AAXR;AAcM;EACE,aAAA;EACA,mBAAA;EACA,QAAA;AAZR;AAeM;EACE,eAAA;EACA,+BAAA;AAbR;AAkBE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAhBJ;AAkBI;EACE,gBAAA;EACA,4BAAA;AAhBN;AAoBI;EACE,aAAA;EACA,oCAAA;AAlBN;AAoBM;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,gBAAA;EACA,4BAAA;EACA,mBAAA;EACA,eAAA;AAlBR;AAoBQ;EACE,eAAA;AAlBV;AAsBM;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AApBR;AAsBQ;EACE,yBAAA;EACA,2BAAA;EACA,kBAAA;EACA,sBAAA;EACA,kBAAA;EACA,SAAA;EACA,YAAA;AApBV;AAsBU;EACE,kBAAA;AApBZ;AAuBU;EACE,gBAAA;EACA,eAAA;AArBZ;AA2BI;EACE,eAAA;EACA,eAAA;AAzBN;AA2BM;EACE,8BAAA;AAzBR;AA4BM;EACE,8BAAA;AA1BR;AA+BI;EACE,oCAAA;EACA,qCAAA;AA7BN;AA+BM;EACE,uCAAA;EACA,gBAAA;AA7BR;AAgCM;EACE,0CAAA;EACA,gBAAA;AA9BR;AAoCI;EACE,kDAAA;EACA,oDAAA;AAlCN;AAoCM;EACE,+CAAA;EACA,gBAAA;EACA,UAAA;AAlCR;AAqCM;EACE,oCAAA;EACA,UAAA;AAnCR;AAsCM;EACE,sCAAA;EACA,oCAAA;EACA,gBAAA;EACA,UAAA;AApCR;AAyCI;EACE,oDAAA;EACA,qDAAA;AAvCN;AAyCM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AAvCR;AA0CM;EACE,qCAAA;EACA,UAAA;AAxCR;AA2CM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AAzCR;AA8CI;EACE,mDAAA;EACA,qDAAA;AA5CN;AA8CM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AA5CR;AA+CM;EACE,qCAAA;EACA,UAAA;AA7CR;AAgDM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AA9CR;AAoDI;EACE,kDAAA;EACA,oDAAA;AAlDN;AAoDM;EACE,+CAAA;EACA,gBAAA;EACA,UAAA;AAlDR;AAqDM;EACE,oCAAA;EACA,UAAA;AAnDR;AAsDM;EACE,sCAAA;EACA,oCAAA;EACA,gBAAA;EACA,UAAA;AApDR;AAyDI;EACE,oDAAA;EACA,qDAAA;AAvDN;AAyDM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AAvDR;AA0DM;EACE,qCAAA;EACA,UAAA;AAxDR;AA2DM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AAzDR;AA8DI;EACE,mDAAA;EACA,qDAAA;AA5DN;AA8DM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AA5DR;AA+DM;EACE,qCAAA;EACA,UAAA;AA7DR;AAgEM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AA9DR;AAoEI;EACE,kDAAA;EACA,oDAAA;AAlEN;AAoEM;EACE,+CAAA;EACA,gBAAA;EACA,UAAA;AAlER;AAqEM;EACE,oCAAA;EACA,UAAA;AAnER;AAsEM;EACE,sCAAA;EACA,oCAAA;EACA,gBAAA;EACA,UAAA;AApER;AAyEI;EACE,oDAAA;EACA,qDAAA;AAvEN;AAyEM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AAvER;AA0EM;EACE,qCAAA;EACA,UAAA;AAxER;AA2EM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AAzER;AA8EI;EACE,mDAAA;EACA,qDAAA;AA5EN;AA8EM;EACE,gDAAA;EACA,gBAAA;EACA,UAAA;AA5ER;AA+EM;EACE,qCAAA;EACA,UAAA;AA7ER;AAgFM;EACE,uCAAA;EACA,qCAAA;EACA,gBAAA;EACA,UAAA;AA9ER;;AAqFA;;EAEE,cAAA;AAlFF;;AAsFA;EACE,kCAAA;AAnFF;AAqFE;EACE,oCAAA;EACA,0CAAA;AAnFJ;;AAwFA;EACE;IACE,UAAA;IACA,4BAAA;EArFF;EAuFA;IACE,UAAA;IACA,wBAAA;EArFF;AACF;AA2FE;;;;EAEE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAvFJ;AAyFI;;;;EACE,qBAAA;EACA,4CAAA;AApFN;AAsFM;;;;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;AAjFR;AAmFQ;;;;EACE,eAAA;AA9EV;;AAqFA;EACE,aAAA;AAlFF;;AAqFA;EACE,UAAA;EACA,SAAA;AAlFF;AAoFE;EACE,SAAA;AAlFJ;AAqFE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAnFJ;AAqFI;EACE,eAAA;EACA,kBAAA;AAnFN;AAsFI;EACE,gBAAA;EACA,iBAAA;AApFN;;AAyFA;;EAEE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAtFF;AAwFE;;EACE,gBAAA;AArFJ;AAwFE;;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AArFJ;AAwFE;;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AArFJ;;AAyFA;;EAEE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAtFF;AAwFE;;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AArFJ;AAwFE;;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AArFJ;AAuFI;;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AApFN;;AA0FA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AAvFF;AAyFE;EACE,gBAAA;AAvFJ;AAyFI;EACE,YAAA;EACA,mBAAA;AAvFN;;AA6FA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AA1FF;AA4FE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AA1FJ;AA6FE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AA3FJ;;AAgGA;EACE,oBAAA;EACA,kBAAA;AA7FF;AA+FE;EACE,8BAAA;EACA,gBAAA;EACA,eAAA;AA7FJ;;AAiGA;EACE,oBAAA;EACA,kBAAA;AA9FF;;AAkGA;EACE,qCAAA;AA/FF;AAiGE;EACE,8BAAA;AA/FJ;;AAmGA;EACE,sCAAA;AAhGF;;AAoGA;EACE,gBAAA;AAjGF;AAmGE;EACE,cAAA;EACA,oBAAA;AAjGJ;;AAsGA;EACE,kBAAA;AAnGF;AAqGE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AAnGJ;;AAwGA;EACE;IACE,gBAAA;EArGF;EAwGA;IACE,gBAAA;EAtGF;EAyGA;IACE,eAAA;EAvGF;EAyGE;IACE,eAAA;EAvGJ;EA2GA;IACE,eAAA;EAzGF;EA2GE;IACE,eAAA;EAzGJ;EA6GA;IACE,gBAAA;EA3GF;EA6GE;IACE,gBAAA;EA3GJ;EA+GA;IACE,kBAAA;EA7GF;EA+GE;IACE,WAAA;IACA,YAAA;EA7GJ;EAgHE;IACE,eAAA;EA9GJ;AACF;AAmHA;EACE;IACE,eAAA;EAjHF;EAmHE;IACE,eAAA;EAjHJ;EAqHA;IACE,eAAA;EAnHF;EAqHE;IACE,eAAA;EAnHJ;EAuHA;IACE,sBAAA;IACA,gBAAA;EArHF;EAuHE;IACE,WAAA;IACA,eAAA;EArHJ;EAyHA;IACE,kBAAA;EAvHF;EAyHE;IACE,eAAA;EAvHJ;EA2HA;;IAEE,cAAA;EAzHF;EA2HE;;IACE,aAAA;EAxHJ;EA4HI;;IACE,cAAA;EAzHN;EA2HM;;IACE,eAAA;IACA,kBAAA;EAxHR;EA2HM;;IACE,gBAAA;IACA,iBAAA;EAxHR;EA6HE;;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EA1HJ;EA4HI;;IACE,eAAA;IACA,WAAA;EAzHN;EA8HI;;IACE,eAAA;IACA,qBAAA;EA3HN;EA8HI;;IACE,eAAA;EA3HN;AACF;AAiIA;EACE;IACE,oCAAA;IACA,qCAAA;EA/HF;EAkIA;;IAEE,6BAAA;EAhIF;EAqIE;;IACE,uCAAA;IACA,6CAAA;EAlIJ;EAsIA;IACE,qCAAA;IACA,uCAAA;EApIF;EAsIE;IACE,oCAAA;IACA,qCAAA;EApIJ;AACF;AAyIA;EACE;IACE,2BAAA;IACA,0BAAA;EAvIF;EA0IA;IACE,0BAAA;EAxIF;EA2IA;IACE,2BAAA;EAzIF;AACF;AA6IA;EACE;IACE,iBAAA;EA3IF;EA8IA;IACE,wBAAA;EA5IF;EA+IA;IACE,gBAAA;EA7IF;AACF","sourcesContent":["// Measurement Create Form Styles - Following Child Add-Edit Design Patterns\n\n// Container styling\n.measurement-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.measurement-form {\n  .form-section {\n    margin-bottom: 32px;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n\n    ion-icon {\n      font-size: 20px;\n    }\n\n    &.collapsible-header {\n      cursor: pointer;\n      justify-content: space-between;\n      padding: 12px;\n      background: rgba(73, 144, 226, 0.05);\n      border-radius: 8px;\n      border-bottom: none;\n      transition: all 0.3s ease;\n      user-select: none;\n\n      &:hover {\n        background: rgba(73, 144, 226, 0.1);\n        transform: translateX(2px);\n      }\n\n      &:active {\n        transform: scale(0.98);\n      }\n\n      .header-content {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n      }\n\n      .collapse-icon {\n        font-size: 24px;\n        transition: transform 0.3s ease;\n      }\n    }\n  }\n\n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n\n    // Radio group styling\n    &:has(ion-radio-group) {\n      padding: 12px;\n      background: rgba(255, 255, 255, 0.8);\n\n      .form-label {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n        margin-bottom: 12px;\n        font-size: 14px;\n\n        ion-icon {\n          font-size: 18px;\n        }\n      }\n\n      ion-radio-group {\n        display: flex;\n        flex-direction: column;\n        gap: 8px;\n\n        ion-item {\n          --background: transparent;\n          --border-color: transparent;\n          --padding-start: 0;\n          --inner-padding-end: 0;\n          --min-height: 36px;\n          margin: 0;\n          border: none;\n\n          ion-radio {\n            margin-right: 12px;\n          }\n\n          ion-label {\n            font-weight: 500;\n            font-size: 14px;\n          }\n        }\n      }\n    }\n\n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n\n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n\n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n\n    // Auto-filled item styling\n    &.auto-filled-item {\n      background: rgba(45, 211, 111, 0.05);\n      border-color: rgba(45, 211, 111, 0.2);\n\n      .auto-filled-input {\n        --color: var(--ion-color-success-shade);\n        font-weight: 500;\n      }\n\n      ion-label {\n        color: var(--ion-color-success) !important;\n        font-weight: 600;\n      }\n    }\n\n    // Nutrition status color styling with reduced opacity\n    // SAM - ID: 1 (Danger/Red)\n    &.nutrition-status-1 {\n      background: rgba(var(--ion-color-danger-rgb), 0.1);\n      border-color: rgba(var(--ion-color-danger-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-danger-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-danger-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-danger-shade);\n        color: var(--ion-color-danger-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // MAM - ID: 2 (Warning/Yellow-Orange)\n    &.nutrition-status-2 {\n      background: rgba(var(--ion-color-warning-rgb), 0.15);\n      border-color: rgba(var(--ion-color-warning-rgb), 0.4);\n\n      ion-label {\n        color: var(--ion-color-warning-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-warning-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-warning-shade);\n        color: var(--ion-color-warning-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // NORMAL - ID: 3 (Success/Green)\n    &.nutrition-status-3 {\n      background: rgba(var(--ion-color-success-rgb), 0.1);\n      border-color: rgba(var(--ion-color-success-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-success-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-success-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-success-shade);\n        color: var(--ion-color-success-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // Referral status color styling (matches nutrition status colors)\n    // SAM -> OTP - ID: 1 (Danger/Red)\n    &.referral-status-1 {\n      background: rgba(var(--ion-color-danger-rgb), 0.1);\n      border-color: rgba(var(--ion-color-danger-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-danger-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-danger-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-danger-shade);\n        color: var(--ion-color-danger-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // MAM -> TSFP - ID: 2 (Warning/Yellow-Orange)\n    &.referral-status-2 {\n      background: rgba(var(--ion-color-warning-rgb), 0.15);\n      border-color: rgba(var(--ion-color-warning-rgb), 0.4);\n\n      ion-label {\n        color: var(--ion-color-warning-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-warning-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-warning-shade);\n        color: var(--ion-color-warning-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // NORMAL -> BSFP - ID: 3 (Success/Green)\n    &.referral-status-3 {\n      background: rgba(var(--ion-color-success-rgb), 0.1);\n      border-color: rgba(var(--ion-color-success-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-success-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-success-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-success-shade);\n        color: var(--ion-color-success-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // Z-Score severity styling\n    // Severe (< -3) - Reddish\n    &.zscore-severe {\n      background: rgba(var(--ion-color-danger-rgb), 0.1);\n      border-color: rgba(var(--ion-color-danger-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-danger-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-danger-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-danger-shade);\n        color: var(--ion-color-danger-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // Moderate (-3 to -2) - Yellowish\n    &.zscore-moderate {\n      background: rgba(var(--ion-color-warning-rgb), 0.15);\n      border-color: rgba(var(--ion-color-warning-rgb), 0.4);\n\n      ion-label {\n        color: var(--ion-color-warning-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-warning-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-warning-shade);\n        color: var(--ion-color-warning-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n\n    // Normal (>= -2) - Greenish\n    &.zscore-normal {\n      background: rgba(var(--ion-color-success-rgb), 0.1);\n      border-color: rgba(var(--ion-color-success-rgb), 0.3);\n\n      ion-label {\n        color: var(--ion-color-success-shade) !important;\n        font-weight: 700;\n        opacity: 1;\n      }\n\n      ion-icon {\n        color: var(--ion-color-success-shade);\n        opacity: 1;\n      }\n\n      ion-input {\n        --color: var(--ion-color-success-shade);\n        color: var(--ion-color-success-shade);\n        font-weight: 700;\n        opacity: 1;\n      }\n    }\n  }\n}\n\n// Child Information Card styling\n.child-info-card,\n.last-measurement-card {\n  margin: 16px 0;\n}\n\n// Last measurement card specific styling\n.last-measurement-card {\n  animation: slideDown 0.3s ease-out;\n\n  ion-card {\n    background: rgba(73, 144, 226, 0.03);\n    border: 1px solid rgba(73, 144, 226, 0.15);\n  }\n}\n\n// Slide down animation\n@keyframes slideDown {\n  from {\n    opacity: 0;\n    transform: translateY(-10px);\n  }\n  to {\n    opacity: 1;\n    transform: translateY(0);\n  }\n}\n\n.child-info-card,\n.last-measurement-card {\n\n  .child-card,\n  .measurement-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-card-header {\n      --background: #f8f9fa;\n      border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n\n      ion-card-title {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n        font-size: 16px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n\n        ion-icon {\n          font-size: 20px;\n        }\n      }\n    }\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.child-info-card .info-item,\n.last-measurement-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n  }\n}\n\n.child-info-card .item-content,\n.last-measurement-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n\n  .submit-btn {\n    min-width: 180px;\n\n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n\n  &[readonly] {\n    --color: var(--ion-color-dark);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n\n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n\n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Enhanced visual indicators for headers\n.section-header .section-title {\n  position: relative;\n\n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-primary), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .measurement-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n\n  .section-title {\n    font-size: 24px;\n\n    ion-icon {\n      font-size: 28px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .form-actions {\n    margin-top: 32px;\n\n    .submit-btn {\n      min-width: 200px;\n    }\n  }\n\n  .loading-container {\n    padding: 80px 40px;\n\n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n\n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 14px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n\n  .loading-container {\n    padding: 40px 16px;\n\n    p {\n      font-size: 12px;\n    }\n  }\n\n  .child-info-card,\n  .last-measurement-card {\n    margin: 12px 0;\n\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .form-item.auto-filled-item {\n    background: rgba(45, 211, 111, 0.08);\n    border-color: rgba(45, 211, 111, 0.3);\n  }\n\n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n\n  .child-card,\n  .measurement-card {\n    ion-card-header {\n      --background: rgba(255, 255, 255, 0.05);\n      border-bottom-color: rgba(255, 255, 255, 0.1);\n    }\n  }\n\n  .info-item {\n    background: rgba(255, 255, 255, 0.03);\n    border-color: rgba(255, 255, 255, 0.08);\n\n    &:hover {\n      background: rgba(73, 144, 226, 0.08);\n      border-color: rgba(73, 144, 226, 0.3);\n    }\n  }\n}\n\n// Accessibility improvements\n@media (prefers-reduced-motion: reduce) {\n  * {\n    transition: none !important;\n    animation: none !important;\n  }\n\n  .last-measurement-card {\n    animation: none !important;\n  }\n\n  .collapsible-header {\n    transition: none !important;\n  }\n}\n\n// High contrast mode\n@media (prefers-contrast: high) {\n  .form-item {\n    border-width: 2px;\n  }\n\n  .section-subtitle {\n    border-bottom-width: 3px;\n  }\n\n  ion-label {\n    font-weight: 600;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 83339:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/measurement-create/measurement-create.page.html?ngResource ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"'/child-detail/' + childId\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ isEditMode ? 'Edit Measurement' : 'Anthropometric Measurement' }}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"measurementPreqData && child_info; else loading\" class=\"measurement-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"fitness-outline\" color=\"primary\"></ion-icon>\n        Child Anthropometric Measurement\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"measurementForm\" (ngSubmit)=\"onSubmit()\" class=\"measurement-form\">\n\n            <!-- Last Measurement Card -->\n            <div class=\"form-section\" *ngIf=\"measurementPreqData?.last_measurement && !isEditMode\">\n              <h3 class=\"section-subtitle collapsible-header\" (click)=\"toggleLastMeasurement()\">\n                <div class=\"header-content\">\n                  <ion-icon name=\"time-outline\" color=\"primary\"></ion-icon>\n                  <span>Last Measurement</span>\n                </div>\n                <ion-icon\n                  [name]=\"isLastMeasurementExpanded ? 'chevron-up-outline' : 'chevron-down-outline'\"\n                  color=\"primary\"\n                  class=\"collapse-icon\">\n                </ion-icon>\n              </h3>\n\n              <ion-card class=\"last-measurement-card\" *ngIf=\"isLastMeasurementExpanded\">\n                <ion-card-content>\n                  <ion-grid>\n                    <ion-row>\n                      <ion-col size=\"6\">\n                        <div class=\"info-item\">\n                          <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Date</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.date }}</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"resize-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">MUAC</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.muac }} cm</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"scale-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Weight</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.weight }} kg</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"trending-up-outline\" color=\"primary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Height</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.height }} cm</span>\n                          </div>\n                        </div>\n                      </ion-col>\n\n                      <ion-col size=\"6\">\n                        <div class=\"info-item\">\n                          <ion-icon name=\"pulse-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">WFH Z-Score</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.wfh_zscore }}</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"trending-up-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">HAZ Z-Score</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.haz_zscore }}</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"scale-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">WAZ Z-Score</span>\n                            <span class=\"value\">{{ measurementPreqData.last_measurement.waz_zscore }}</span>\n                          </div>\n                        </div>\n\n                        <div class=\"info-item\">\n                          <ion-icon name=\"medical-outline\" color=\"secondary\"></ion-icon>\n                          <div class=\"item-content\">\n                            <span class=\"label\">Nutrition Status</span>\n                            <span class=\"value\">{{ getNutritionStatusTitle(measurementPreqData.last_measurement.nutrition_status) }}</span>\n                          </div>\n                        </div>\n                      </ion-col>\n                    </ion-row>\n                  </ion-grid>\n                </ion-card-content>\n              </ion-card>\n            </div>\n\n            <!-- Measurement Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"fitness-outline\" color=\"primary\"></ion-icon>\n                Anthropometric Measurement\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('date')\">\n                <ion-icon slot=\"start\" name=\"calendar\" [color]=\"isFieldInvalid('date') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Measurement Date *</ion-label>\n                <ion-input formControlName=\"date\" type=\"date\" [min]=\"minDate\" [max]=\"today\" (ionInput)=\"onDateChange($event)\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"measurementPreqData?.last_measurement\">Must be after last measurement: {{ measurementPreqData.last_measurement.date }}</ion-note>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"!measurementPreqData?.last_measurement\">Cannot be in the future</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('muac')\">\n                <ion-icon slot=\"start\" name=\"resize-outline\" [color]=\"isFieldInvalid('muac') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">MUAC (cm) *</ion-label>\n                <ion-input formControlName=\"muac\" type=\"number\" step=\"0.1\" placeholder=\"Enter MUAC\" (ionInput)=\"onMuacChange($event)\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\" *ngIf=\"measurementPreqData?.muac_cutoff && !isFieldInvalid('muac')\">\n                  SAM: &lt;{{ measurementPreqData.muac_cutoff.child_sam }}cm | MAM: &lt;{{ measurementPreqData.muac_cutoff.child_mam }}cm\n                </ion-note>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('muac')\">MUAC is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('weight')\">\n                <ion-icon slot=\"start\" name=\"scale-outline\" [color]=\"isFieldInvalid('weight') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Weight (kg) *</ion-label>\n                <ion-input formControlName=\"weight\" type=\"number\" step=\"0.1\" placeholder=\"Enter weight\" (ionInput)=\"onWeightChange($event)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('weight')\">Weight is required</ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('height')\">\n                <ion-icon slot=\"start\" name=\"trending-up-outline\" [color]=\"isFieldInvalid('height') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Height (cm) *</ion-label>\n                <ion-input formControlName=\"height\" type=\"number\" step=\"0.1\" placeholder=\"Enter height\" (ionInput)=\"onHeightChange($event)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('height')\">Height is required</ion-note>\n              </ion-item>\n\n                            <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"water-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Oedema *</ion-label>\n                <ion-select formControlName=\"oedema\" interface=\"action-sheet\" (ionChange)=\"onOedemaChange($event)\">\n                  <ion-select-option *ngFor=\"let item of oedema\" [value]=\"item\">\n                    {{ item }}\n                  </ion-select-option>\n                </ion-select>\n              </ion-item>\n\n              <!-- Hidden field for form value -->\n              <input type=\"hidden\" formControlName=\"nutrition_status\">\n\n              <ion-item class=\"form-item auto-filled-item nutrition-status-field\" [ngClass]=\"'nutrition-status-' + measurementForm.get('nutrition_status').value\">\n                <ion-icon slot=\"start\" name=\"medical-outline\"></ion-icon>\n                <ion-label position=\"stacked\">Nutrition Status (Auto-selected)</ion-label>\n                <ion-input type=\"text\" [readonly]=\"true\" class=\"auto-filled-input\" [value]=\"getNutritionStatusTitle(measurementForm.get('nutrition_status').value)\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item auto-filled-item referral-status-field\" [ngClass]=\"'referral-status-' + measurementForm.get('nutrition_status').value\">\n                <ion-icon slot=\"start\" name=\"git-branch-outline\"></ion-icon>\n                <ion-label position=\"stacked\">Referral Status (Auto-calculated)</ion-label>\n                <ion-input formControlName=\"referral_status\" type=\"text\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <!-- Z-Score Section -->\n              <div class=\"z-scores-section\">\n                <h4 class=\"subsection-title\">\n                  <ion-icon name=\"analytics-outline\" color=\"primary\"></ion-icon>\n                  Z-Scores\n                </h4>\n\n                <ion-row>\n                  <ion-col size=\"12\" size-md=\"4\">\n                    <ion-item class=\"form-item z-score-item\">\n                      <ion-icon slot=\"start\" name=\"pulse-outline\" color=\"primary\"></ion-icon>\n                      <ion-label position=\"stacked\">\n                        WFH Z-Score\n                        <ion-note color=\"medium\">(Wasting)</ion-note>\n                      </ion-label>\n                      <ion-input formControlName=\"wfh_zscore\" type=\"text\" [readonly]=\"true\"></ion-input>\n                    </ion-item>\n                  </ion-col>\n\n                  <ion-col size=\"12\" size-md=\"4\">\n                    <ion-item class=\"form-item z-score-item\">\n                      <ion-icon slot=\"start\" name=\"trending-up-outline\" color=\"primary\"></ion-icon>\n                      <ion-label position=\"stacked\">\n                        HAZ Z-Score\n                        <ion-note color=\"medium\">(Stunting)</ion-note>\n                      </ion-label>\n                      <ion-input formControlName=\"haz_zscore\" type=\"text\" [readonly]=\"true\"></ion-input>\n                    </ion-item>\n                  </ion-col>\n\n                  <ion-col size=\"12\" size-md=\"4\">\n                    <ion-item class=\"form-item z-score-item\">\n                      <ion-icon slot=\"start\" name=\"scale-outline\" color=\"primary\"></ion-icon>\n                      <ion-label position=\"stacked\">\n                        WAZ Z-Score\n                        <ion-note color=\"medium\">(Underweight)</ion-note>\n                      </ion-label>\n                      <ion-input formControlName=\"waz_zscore\" type=\"text\" [readonly]=\"true\"></ion-input>\n                    </ion-item>\n                  </ion-col>\n                </ion-row>\n              </div>\n\n              <!-- Others Accordion Section -->\n              <h3 class=\"section-subtitle collapsible-header\" (click)=\"toggleOthersAccordion()\">\n                <div class=\"header-content\">\n                  <ion-icon name=\"ellipsis-horizontal-outline\" color=\"primary\"></ion-icon>\n                  <span>Others</span>\n                </div>\n                <ion-icon\n                  [name]=\"isOthersExpanded ? 'chevron-up-outline' : 'chevron-down-outline'\"\n                  color=\"primary\"\n                  class=\"collapse-icon\">\n                </ion-icon>\n              </h3>\n\n              <div *ngIf=\"isOthersExpanded\">\n                <ion-item class=\"form-item\">\n                  <ion-icon slot=\"start\" name=\"chatbubbles-outline\" color=\"primary\"></ion-icon>\n                  <ion-label position=\"stacked\">Eligible for GMP promotional Message? *</ion-label>\n                  <ion-select formControlName=\"counselling\" interface=\"action-sheet\">\n                    <ion-select-option *ngFor=\"let option of counsellingOptions\" [value]=\"option\">\n                      {{ option }}\n                    </ion-select-option>\n                  </ion-select>\n                </ion-item>\n\n                <div class=\"form-item\">\n                  <ion-label class=\"form-label\">\n                    <ion-icon name=\"medkit-outline\" color=\"primary\"></ion-icon>\n                    Campaign Information\n                  </ion-label>\n                  <ion-radio-group formControlName=\"others\" (ionChange)=\"onOthersChange($event)\">\n                    <ion-item lines=\"none\">\n                      <ion-radio [value]=\"null\" slot=\"start\"></ion-radio>\n                      <ion-label>None</ion-label>\n                    </ion-item>\n                    <ion-item lines=\"none\">\n                      <ion-radio value=\"VAS\" slot=\"start\"></ion-radio>\n                      <ion-label>VAS</ion-label>\n                    </ion-item>\n                    <ion-item lines=\"none\">\n                      <ion-radio value=\"Deworming\" slot=\"start\"></ion-radio>\n                      <ion-label>Deworming</ion-label>\n                    </ion-item>\n                    <ion-item lines=\"none\">\n                      <ion-radio value=\"Others\" slot=\"start\"></ion-radio>\n                      <ion-label>Others</ion-label>\n                    </ion-item>\n                  </ion-radio-group>\n                </div>\n\n                <ion-item class=\"form-item\" *ngIf=\"showOthersInput\">\n                  <ion-icon slot=\"start\" name=\"create-outline\" color=\"primary\"></ion-icon>\n                  <ion-label position=\"stacked\">Specify Others</ion-label>\n                  <ion-input formControlName=\"others_specify\" type=\"text\" placeholder=\"Please specify\"></ion-input>\n                </ion-item>\n              </div>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\">\n                <ion-icon name=\"save-outline\" slot=\"start\"></ion-icon>\n                {{ isEditMode ? 'Update Measurement' : 'Save Measurement' }}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"measurement-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading measurement form data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_measurement-create_measurement-create_module_ts.js.map