(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_gmp_gmp_module_ts-src_app_services_api_base_service_ts"],{

/***/ 7579:
/*!*************************************************!*\
  !*** ./src/app/pages/gmp/gmp-routing.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GmpPageRoutingModule: () => (/* binding */ GmpPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _gmp_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./gmp.page */ 22349);




const routes = [{
  path: '',
  component: _gmp_page__WEBPACK_IMPORTED_MODULE_0__.GmpPage
}];
let GmpPageRoutingModule = class GmpPageRoutingModule {};
GmpPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], GmpPageRoutingModule);


/***/ }),

/***/ 98522:
/*!*****************************************!*\
  !*** ./src/app/pages/gmp/gmp.module.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GmpPageModule: () => (/* binding */ GmpPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _gmp_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./gmp-routing.module */ 7579);
/* harmony import */ var _gmp_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./gmp.page */ 22349);







let GmpPageModule = class GmpPageModule {};
GmpPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _gmp_routing_module__WEBPACK_IMPORTED_MODULE_0__.GmpPageRoutingModule],
  declarations: [_gmp_page__WEBPACK_IMPORTED_MODULE_1__.GmpPage, _gmp_page__WEBPACK_IMPORTED_MODULE_1__.MeasurementPopoverComponent]
})], GmpPageModule);


/***/ }),

/***/ 22349:
/*!***************************************!*\
  !*** ./src/app/pages/gmp/gmp.page.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GmpPage: () => (/* binding */ GmpPage),
/* harmony export */   MeasurementPopoverComponent: () => (/* binding */ MeasurementPopoverComponent)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _workdir_src_app_pages_gmp_gmp_page_ts_css_ngResource_workdir_node_modules_ngtools_webpack_src_loaders_inline_resource_js_data_CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg_workdir_src_app_pages_gmp_gmp_page_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./src/app/pages/gmp/gmp.page.ts.css?ngResource!=!./node_modules/@ngtools/webpack/src/loaders/inline-resource.js?data=CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg!./src/app/pages/gmp/gmp.page.ts */ 64350);
/* harmony import */ var _workdir_src_app_pages_gmp_gmp_page_ts_css_ngResource_workdir_node_modules_ngtools_webpack_src_loaders_inline_resource_js_data_CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg_workdir_src_app_pages_gmp_gmp_page_ts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_workdir_src_app_pages_gmp_gmp_page_ts_css_ngResource_workdir_node_modules_ngtools_webpack_src_loaders_inline_resource_js_data_CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg_workdir_src_app_pages_gmp_gmp_page_ts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _gmp_page_html_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./gmp.page.html?ngResource */ 99063);
/* harmony import */ var _gmp_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./gmp.page.scss?ngResource */ 94099);
/* harmony import */ var _gmp_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_gmp_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/utility */ 89999);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! d3 */ 40622);
/* harmony import */ var src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/services/child_api.service */ 57571);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);

var _MeasurementPopoverComponent, _GmpPage;
/* eslint-disable @typescript-eslint/naming-convention */
/* eslint-disable max-len */
/* eslint-disable space-before-function-paren */
/* eslint-disable @typescript-eslint/consistent-type-assertions */













let MeasurementPopoverComponent = (_MeasurementPopoverComponent = class MeasurementPopoverComponent {}, _MeasurementPopoverComponent.propDecorators = {
  data: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
  }]
}, _MeasurementPopoverComponent);
MeasurementPopoverComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-measurement-popover',
  template: `
    <div class="measurement-popover">
      <div class="measurement-details">
        <div class="detail-row">
          <span class="detail-label">Date</span>
          <span class="detail-value">{{ data.formattedDate }}</span>
        </div>
        <div class="detail-row">
          <span class="detail-label">Age</span>
          <span class="detail-value">{{ data.ageDisplay }}</span>
        </div>
        <div class="detail-row" *ngIf="data.weight">
          <span class="detail-label">Weight</span>
          <span class="detail-value">{{ data.weight }} kg</span>
        </div>
        <div class="detail-row" *ngIf="data.height">
          <span class="detail-label">Height</span>
          <span class="detail-value">{{ data.height }} cm</span>
        </div>
        <div class="detail-row" *ngIf="data.muac">
          <span class="detail-label">MUAC</span>
          <span class="detail-value">{{ data.muac }} cm</span>
        </div>
        <div class="detail-row" *ngIf="data.z_score">
          <span class="detail-label">Z-Score</span>
          <span class="detail-value">{{ data.z_score }}</span>
        </div>
      </div>
    </div>
  `,
  styles: [(_workdir_src_app_pages_gmp_gmp_page_ts_css_ngResource_workdir_node_modules_ngtools_webpack_src_loaders_inline_resource_js_data_CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg_workdir_src_app_pages_gmp_gmp_page_ts__WEBPACK_IMPORTED_MODULE_1___default())]
})], MeasurementPopoverComponent);

let GmpPage = (_GmpPage = class GmpPage {
  constructor(api, activatedRoute, b, platform, cdr, popoverCtrl) {
    this.api = api;
    this.activatedRoute = activatedRoute;
    this.b = b;
    this.platform = platform;
    this.cdr = cdr;
    this.popoverCtrl = popoverCtrl;
    this.isLandscape = false;
    this.showAreaFill = true;
    this.maxHeight = 124;
    this.maxWeight = 35;
    this.maxY = 100;
  }
  ngOnInit() {
    var _this = this;
    this.activatedRoute.paramMap.subscribe(/*#__PURE__*/function () {
      var _ref = (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (paramMap) {
        _this.type = paramMap.get('type');
        _this.id = paramMap.get('id');
        yield _this.loadChildData();
        yield _this.loadGmpData();
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
    // Listen for orientation changes
    window.addEventListener('orientationchange', () => {
      this.handleOrientationChange();
    });
    // Check initial orientation
    this.checkOrientation();
  }
  ngOnDestroy() {
    window.removeEventListener('orientationchange', () => {
      this.handleOrientationChange();
    });
  }
  checkOrientation() {
    this.isLandscape = window.innerWidth > window.innerHeight;
  }
  handleOrientationChange() {
    setTimeout(() => {
      this.checkOrientation();
      this.recalculateAndRedraw();
    }, 100);
  }
  recalculateAndRedraw() {
    if (this.gmpData) {
      this.calculateWidth();
      this.gmpGraph();
    }
  }
  toggleAreaFill() {
    this.showAreaFill = !this.showAreaFill;
    this.gmpGraph();
  }
  calculateWidth() {
    const screenWidth = this.platform.width();
    if (this.isLandscape) {
      // In landscape, use more of the screen width
      this.width = Math.max(screenWidth - 100, 800);
    } else {
      // Portrait mode
      this.width = screenWidth >= 992 ? screenWidth - 300 : screenWidth - 40;
    }
  }
  loadChildData() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this2.api.getChild(_this2.id);
        _this2.childData = response.data;
      } catch (error) {
        _this2.b.toast('Error loading child data');
      }
    })();
  }
  loadGmpData() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this3.gmpData = (yield _this3.api.childGmp(_this3.id)).data;
        _this3.calculateWidth();
        if (_this3.type === 'height') {
          _this3.gmpGraphData = _this3.gmpData.height_graph_data;
          _this3.maxY = _this3.maxHeight;
        } else {
          _this3.gmpGraphData = _this3.gmpData.weight_graph_data;
          _this3.maxY = _this3.maxWeight;
        }
        // Trigger change detection to ensure DOM is updated
        _this3.cdr.detectChanges();
        // Wait for DOM to be ready before rendering graph
        setTimeout(() => {
          _this3.gmpGraph();
        }, 100);
      } catch (error) {
        _this3.b.toast('Error loading GMP data');
      }
    })();
  }
  gmpGraph() {
    // Check if container exists
    const container = document.querySelector('#gmpGraphCanvas');
    if (!container) {
      return;
    }
    // Clear any existing SVG
    d3__WEBPACK_IMPORTED_MODULE_5__.select('#gmpGraphCanvas').selectAll('*').remove();
    // A color scale: one color for each group
    const height = src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.graphHeight;
    // Calculate legend height - assume max 2 rows of legends at bottom (8 items per row in landscape, 4 in portrait)
    const estimatedLegendsPerRow = this.isLandscape ? 6 : 4;
    const estimatedLegendRows = Math.ceil(9 / estimatedLegendsPerRow); // 8 GMP groups + 1 child's growth
    const totalLegendHeight = estimatedLegendRows * 30 + 80; // 30px per row + 80px spacing
    const svg = (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.generateSVGContainer)('#gmpGraphCanvas', height, totalLegendHeight);
    const chart = svg.append('g').attr('transform', `translate(${src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.left},${src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.top})`);
    //scales
    const chartWidth = this.width - (src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.left + src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.right);
    // Add X axis
    const x = d3__WEBPACK_IMPORTED_MODULE_5__.scaleLinear().domain([0, 60]).range([0, chartWidth]);
    chart.append('g').attr('class', 'axisX').call(d3__WEBPACK_IMPORTED_MODULE_5__.axisBottom(x).tickSize(-height)).attr('transform', `translate(${0},${height})`);
    // Add Y axis
    const minY = this.type === 'height' ? 30 : 0;
    const y = d3__WEBPACK_IMPORTED_MODULE_5__.scaleLinear().domain([minY, this.maxY]).range([height, 0]);
    const yAxis = d3__WEBPACK_IMPORTED_MODULE_5__.axisLeft(y).tickSize(-chartWidth).ticks(10);
    chart.append('g').attr('class', 'axisY').call(yAxis);
    // Add Y-axis label
    svg.append('text').attr('transform', 'rotate(-90)').attr('x', -(height / 2) - src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.top).attr('y', 15).style('text-anchor', 'middle').style('font-size', '16px').style('font-weight', '700').style('fill', '#374151').text(this.type === 'height' ? 'Height (cm)' : 'Weight (kg)');
    // Add X-axis label
    svg.append('text').attr('x', this.width / 2).attr('y', height + src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.top + src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.margin.bottom - 5).style('text-anchor', 'middle').style('font-size', '16px').style('font-weight', '700').style('fill', '#374151').text('Age (months)');
    // Reformat the data: we need an array of arrays of {x, y} tuples
    const gmpGroupData = src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.gmpGroups.map(grpName => ({
      key: grpName,
      values: this.gmpGraphData.map(d => ({
        age: d.age,
        name: grpName,
        value: +d[grpName]
      }))
    }));
    // Add the lines
    const line = d3__WEBPACK_IMPORTED_MODULE_5__.line().x(d => x(+d.age)).y(d => y(+d.value));
    // Create area path if needed
    const lineAreaPath = d3__WEBPACK_IMPORTED_MODULE_5__.area().x(d => x(d.age)).y0(d => y(d.value)).y1((d, i) => {
      const index = gmpGroupData.findIndex(item => item.key === d.name);
      const bound = index > 0 ? gmpGroupData[index - 1].values[i].value : this.type === 'height' ? 30 : 0;
      return y(bound);
    }).curve(d3__WEBPACK_IMPORTED_MODULE_5__.curveBasisOpen);
    chart.selectAll('myLines').data(gmpGroupData).enter().append('path').attr('class', d => d.key).attr('d', d => this.showAreaFill ? lineAreaPath(d.values) : line(d.values)).attr('stroke', d => (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getColorFromGmpConfig)(d.key, this.gmpData.gmpconfigs)).style('stroke-width', this.showAreaFill ? 4 : 3).style('fill', d => this.showAreaFill ? (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getColorFromGmpConfig)(d.key, this.gmpData.gmpconfigs) : 'none');
    // Add the points (small dots on growth curves)
    chart.selectAll('myDots').data(gmpGroupData).enter().append('g').style('fill', 'grey').attr('class', d => d.key).selectAll('myPoints').data(d => d.values).enter().append('circle').attr('cx', d => x(d.age)).attr('cy', d => y(d.value)).attr('r', src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.circleRadius);
    // Add a legend at the bottom with improved styling
    const legendStartY = height + 60;
    const legendSpacing = 30;
    const legendsPerRow = this.isLandscape ? Math.min(gmpGroupData.length + 1, 5) : Math.min(gmpGroupData.length + 1, 3);
    const gmpConfigs = this.gmpData.gmpconfigs;
    chart.selectAll('myLegend').data(gmpGroupData).enter().append('g').attr('class', 'legend-item').each(function (d, i) {
      const row = Math.floor(i / legendsPerRow);
      const col = i % legendsPerRow;
      const xPos = col * 180;
      const yPos = legendStartY + row * legendSpacing;
      const legendGroup = d3__WEBPACK_IMPORTED_MODULE_5__.select(this);
      // Add colored rectangle with shadow
      legendGroup.append('rect').attr('x', xPos).attr('y', yPos - 14).attr('width', 24).attr('height', 18).attr('fill', (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getColorFromGmpConfig)(d.key, gmpConfigs)).attr('rx', 4).style('filter', 'drop-shadow(0px 1px 3px rgba(0, 0, 0, 0.15))');
      // Add text with better styling
      legendGroup.append('text').attr('x', xPos + 30).attr('y', yPos).text((0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getLabelFromGmpConfig)(d.key, gmpConfigs)).style('fill', '#1f2937').style('font-size', 13).style('font-weight', '500').style('font-family', '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif');
    });
    // Add legend for child's growth line
    const childLegendIndex = gmpGroupData.length;
    const childLegendRow = Math.floor(childLegendIndex / legendsPerRow);
    const childLegendCol = childLegendIndex % legendsPerRow;
    const childLegendX = childLegendCol * 180;
    const childLegendY = legendStartY + childLegendRow * legendSpacing;
    const childLegend = chart.append('g').attr('class', 'child-legend');
    // Add background for child legend
    childLegend.append('rect').attr('x', childLegendX - 4).attr('y', childLegendY - 16).attr('width', 135).attr('height', 22).attr('fill', '#EFF6FF').attr('rx', 6).style('opacity', 0.8);
    // Add line indicator
    childLegend.append('line').attr('x1', childLegendX + 2).attr('x2', childLegendX + 22).attr('y1', childLegendY - 5).attr('y2', childLegendY - 5).attr('stroke', '#2563eb').attr('stroke-width', 3).attr('stroke-linecap', 'round');
    // Add circle indicator
    childLegend.append('circle').attr('cx', childLegendX + 12).attr('cy', childLegendY - 5).attr('r', 4).attr('fill', '#2563eb').attr('stroke', '#ffffff').attr('stroke-width', 2);
    // Add text
    childLegend.append('text').attr('x', childLegendX + 30).attr('y', childLegendY).text('Actual Growth').style('fill', '#1e40af').style('font-size', 13).style('font-weight', '600').style('font-family', '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif');
    const sourceData = this.type === 'height' ? this.gmpData.gmp_height_data : this.gmpData.gmp_weight_data;
    // Create plotting data from all measurements (no filtering)
    const myGmpGroupData = sourceData.map(d => {
      const ageInMonths = (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.daysDifference)(new Date(this.gmpData.dob), new Date(d.date)) / 30;
      const value = +d[this.type];
      let color = 'white'; // Default color
      let statusLabel = 'Normal';
      // Find the group the value belongs to
      for (const group of gmpGroupData) {
        const point = group.values.find(v => v.age === Math.round(ageInMonths));
        if (point && value < point.value) {
          color = (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getColorFromGmpConfig)(group.key, this.gmpData.gmpconfigs);
          statusLabel = (0,src_app_util_utility__WEBPACK_IMPORTED_MODULE_4__.getLabelFromGmpConfig)(group.key, this.gmpData.gmpconfigs);
          break;
        }
      }
      return {
        key: ageInMonths,
        z_score: d.z_score,
        value,
        color,
        statusLabel,
        date: d.date,
        weight: d.weight,
        height: d.height,
        muac: d.muac
      };
    });
    // Add the lines connecting child's actual measurements
    const myGmpLine = d3__WEBPACK_IMPORTED_MODULE_5__.line().x(d => x(d.key)).y(d => y(d.value)).curve(d3__WEBPACK_IMPORTED_MODULE_5__.curveMonotoneX); // Smooth curve
    chart.append('path').datum(myGmpGroupData).attr('class', 'child-growth-line').attr('d', myGmpLine).attr('fill', 'none').attr('stroke', '#2563eb') // Blue color for child's line
    .attr('stroke-width', 3).attr('stroke-linejoin', 'round').attr('stroke-linecap', 'round').style('filter', 'drop-shadow(0px 2px 4px rgba(0, 0, 0, 0.2))');
    // Add the data points with better styling
    chart.selectAll('myGmpDots').data(myGmpGroupData).enter().append('circle').attr('class', (d, i) => `child-data-point point-${i}`).attr('cx', d => x(d.key)).attr('cy', d => y(d.value)).attr('r', 4).attr('fill', d => d.color || '#2563eb').attr('stroke', '#ffffff').attr('stroke-width', 2).style('cursor', 'pointer').style('filter', 'drop-shadow(0px 2px 4px rgba(0, 0, 0, 0.3))').on('click', (event, d) => this.circleClick(event, d));
  }
  circleClick(event, gmpData) {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const formattedDate = new Date(gmpData.date).toLocaleDateString('en-GB', {
        day: '2-digit',
        month: 'short',
        year: 'numeric'
      });
      const ageDisplay = `${Math.floor(gmpData.key)} months`;
      const popoverData = {
        formattedDate,
        ageDisplay,
        weight: gmpData.weight,
        height: gmpData.height,
        muac: gmpData.muac,
        z_score: gmpData.z_score,
        statusLabel: gmpData.statusLabel || 'Normal',
        color: gmpData.color || '#4990e2'
      };
      const popover = yield _this4.popoverCtrl.create({
        component: MeasurementPopoverComponent,
        componentProps: {
          data: popoverData
        },
        event,
        translucent: true,
        cssClass: 'measurement-popover',
        showBackdrop: true
      });
      yield popover.present();
    })();
  }
}, _GmpPage.ctorParameters = () => [{
  type: src_app_services_child_api_service__WEBPACK_IMPORTED_MODULE_6__.ChildAPIService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.ActivatedRoute
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_7__.BaseHelper
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.Platform
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ChangeDetectorRef
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_12__.PopoverController
}], _GmpPage);
GmpPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-gmp',
  template: _gmp_page_html_ngResource__WEBPACK_IMPORTED_MODULE_2__,
  styles: [(_gmp_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_3___default())]
})], GmpPage);


/***/ }),

/***/ 70014:
/*!**********************************************!*\
  !*** ./src/app/services/api_base.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   APIBaseService: () => (/* binding */ APIBaseService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ngrx_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngrx/store */ 81383);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./global */ 99328);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/baseHelper */ 76434);
var _APIBaseService;

/* eslint-disable eqeqeq */

/* eslint-disable @typescript-eslint/naming-convention */




let APIBaseService = (_APIBaseService = class APIBaseService {
  constructor(http, g, b, store) {
    this.http = http;
    this.g = g;
    this.b = b;
    this.store = store;
  }
  getHeader(params = {}) {
    // Get token from current user if g.jws is not available
    let token = this.g.jws;
    if (!token) {
      const currentUser = this.b.getCurrentUser();
      token = currentUser === null || currentUser === void 0 ? void 0 : currentUser.token;
    }
    return {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpHeaders({
        Authorization: token
      }),
      params
    };
  }
  errorHandle(err) {
    let message = '';
    let detailedErrors = null;
    // Extract error details from response
    if (err !== null && err !== void 0 && err.error) {
      // Backend error format: {success: false, message: string, data?: object|string}
      message = err.error.message || err.message;
      detailedErrors = err.error.data;
    } else {
      message = err.message;
    }
    // Handle specific HTTP status codes
    switch (err.status) {
      case 0:
        // Network error
        message = 'Failed reaching server!!! Make sure you are connected to internet or camp site network.';
        this.b.errorToast(message);
        break;
      case 400:
        // Bad Request
        message = message || 'Bad request. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 401:
        // Unauthorized - token expired
        message = message || 'Session expired. Please login again.';
        this.b.errorToast(message);
        setTimeout(() => {
          this.b.logout('token_expired');
        }, 3000);
        break;
      case 403:
        // Forbidden
        message = message || 'Access denied. You do not have permission to perform this action.';
        this.b.errorToast(message);
        break;
      case 404:
        // Not Found
        message = message || 'Resource not found.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 422:
        // Validation Error (Unprocessable Entity)
        message = message || 'Validation failed. Please check your input.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
      case 500:
        // Internal Server Error
        message = message || 'Internal server error. Please try again later.';
        this.b.errorToast(message);
        break;
      case 503:
        // Service Unavailable
        message = message || 'Service unavailable. Please try again later.';
        this.b.errorToast(message);
        break;
      default:
        // Other errors
        message = message || 'Unknown error occurred. Make sure you are connected and retry.';
        this.b.errorToast(this.formatErrorMessage(message, detailedErrors));
        break;
    }
    return Promise.resolve({
      message: this.formatErrorMessage(message, detailedErrors),
      success: false,
      data: detailedErrors
    });
  }
  /**
   * Format error message with detailed validation errors or data
   */
  formatErrorMessage(mainMessage, detailedErrors) {
    if (!detailedErrors) {
      return mainMessage;
    }
    // If detailedErrors is a string (like the data field from backend)
    if (typeof detailedErrors === 'string') {
      return `${mainMessage} - ${detailedErrors}`;
    }
    // If detailedErrors is an object with field-specific errors (validation errors)
    if (typeof detailedErrors === 'object' && !Array.isArray(detailedErrors)) {
      const errorMessages = [mainMessage];
      Object.keys(detailedErrors).forEach(field => {
        const fieldErrors = detailedErrors[field];
        if (Array.isArray(fieldErrors)) {
          fieldErrors.forEach(error => errorMessages.push(`• ${error}`));
        } else if (typeof fieldErrors === 'string') {
          errorMessages.push(`• ${fieldErrors}`);
        }
      });
      return errorMessages.join('\n');
    }
    return mainMessage;
  }
}, _APIBaseService.ctorParameters = () => [{
  type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient
}, {
  type: _global__WEBPACK_IMPORTED_MODULE_0__.GlobalProvider
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_1__.BaseHelper
}, {
  type: _ngrx_store__WEBPACK_IMPORTED_MODULE_3__.Store
}], _APIBaseService);
APIBaseService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], APIBaseService);


/***/ }),

/***/ 64350:
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./src/app/pages/gmp/gmp.page.ts.css?ngResource!=!./node_modules/@ngtools/webpack/src/loaders/inline-resource.js?data=CiAgICAubWVhc3VyZW1lbnQtcG9wb3ZlciB7CiAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlvbi1jb2xvci1saWdodCk7CiAgICAgIGJvcmRlci1yYWRpdXM6IDEycHg7CiAgICAgIG92ZXJmbG93OiBoaWRkZW47CiAgICAgIG1pbi13aWR0aDogMjQwcHg7CiAgICAgIGJveC1zaGFkb3c6IDAgNHB4IDEycHggcmdiYSgwLCAwLCAwLCAwLjEpOwogICAgfQoKICAgIC5tZWFzdXJlbWVudC1kZXRhaWxzIHsKICAgICAgcGFkZGluZzogOHB4OwogICAgfQoKICAgIC5kZXRhaWwtcm93IHsKICAgICAgZGlzcGxheTogZmxleDsKICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuOwogICAgICBhbGlnbi1pdGVtczogY2VudGVyOwogICAgICBwYWRkaW5nOiA4cHggMTJweDsKICAgICAgYmFja2dyb3VuZDogd2hpdGU7CiAgICAgIGJvcmRlci1yYWRpdXM6IDZweDsKICAgICAgbWFyZ2luLWJvdHRvbTogNHB4OwoKICAgICAgJjpsYXN0LWNoaWxkIHsKICAgICAgICBtYXJnaW4tYm90dG9tOiAwOwogICAgICB9CiAgICB9CgogICAgLmRldGFpbC1sYWJlbCB7CiAgICAgIGZvbnQtc2l6ZTogMTJweDsKICAgICAgY29sb3I6IHZhcigtLWlvbi1jb2xvci1tZWRpdW0pOwogICAgICBmb250LXdlaWdodDogNTAwOwogICAgfQoKICAgIC5kZXRhaWwtdmFsdWUgewogICAgICBmb250LXNpemU6IDEzcHg7CiAgICAgIGNvbG9yOiB2YXIoLS1pb24tY29sb3ItZGFyayk7CiAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7CiAgICB9CiAg!./src/app/pages/gmp/gmp.page.ts ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `
    .measurement-popover {
      background: var(--ion-color-light);
      border-radius: 12px;
      overflow: hidden;
      min-width: 240px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .measurement-details {
      padding: 8px;
    }

    .detail-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 8px 12px;
      background: white;
      border-radius: 6px;
      margin-bottom: 4px;

      &:last-child {
        margin-bottom: 0;
      }
    }

    .detail-label {
      font-size: 12px;
      color: var(--ion-color-medium);
      font-weight: 500;
    }

    .detail-value {
      font-size: 13px;
      color: var(--ion-color-dark);
      font-weight: 600;
    }
  `, "",{"version":3,"sources":["webpack://./src/app/pages/gmp/gmp.page.ts"],"names":[],"mappings":";IACI;MACE,kCAAkC;MAClC,mBAAmB;MACnB,gBAAgB;MAChB,gBAAgB;MAChB,yCAAyC;IAC3C;;IAEA;MACE,YAAY;IACd;;IAEA;MACE,aAAa;MACb,8BAA8B;MAC9B,mBAAmB;MACnB,iBAAiB;MACjB,iBAAiB;MACjB,kBAAkB;MAClB,kBAAkB;;MAElB;QACE,gBAAgB;MAClB;IACF;;IAEA;MACE,eAAe;MACf,8BAA8B;MAC9B,gBAAgB;IAClB;;IAEA;MACE,eAAe;MACf,4BAA4B;MAC5B,gBAAgB;IAClB","sourcesContent":["\n    .measurement-popover {\n      background: var(--ion-color-light);\n      border-radius: 12px;\n      overflow: hidden;\n      min-width: 240px;\n      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    }\n\n    .measurement-details {\n      padding: 8px;\n    }\n\n    .detail-row {\n      display: flex;\n      justify-content: space-between;\n      align-items: center;\n      padding: 8px 12px;\n      background: white;\n      border-radius: 6px;\n      margin-bottom: 4px;\n\n      &:last-child {\n        margin-bottom: 0;\n      }\n    }\n\n    .detail-label {\n      font-size: 12px;\n      color: var(--ion-color-medium);\n      font-weight: 500;\n    }\n\n    .detail-value {\n      font-size: 13px;\n      color: var(--ion-color-dark);\n      font-weight: 600;\n    }\n  "],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 94099:
/*!****************************************************!*\
  !*** ./src/app/pages/gmp/gmp.page.scss?ngResource ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.graph-svg-component {
  --background: #f4f5f8;
}
.graph-svg-component.landscape-mode .gmp-container {
  max-width: 100%;
}
.graph-svg-component.landscape-mode .graph-card {
  flex: 1;
  display: flex;
  flex-direction: column;
}
.graph-svg-component.landscape-mode .graph-card ion-card-content {
  flex: 1;
}
.graph-svg-component.landscape-mode .graph-card .graph-canvas {
  min-height: 500px;
}

.gmp-container {
  max-width: 1200px;
  margin: 0 auto;
  padding: 16px;
}

.child-info-card {
  border-radius: 16px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  margin-bottom: 16px;
}
.child-info-card ion-card-header {
  padding: 20px;
}

.child-header {
  display: flex;
  flex-direction: column;
  gap: 16px;
}

.child-name-section {
  display: flex;
  align-items: center;
  gap: 12px;
  flex-wrap: wrap;
}

.child-name {
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
}

.gender-badge {
  display: flex;
  align-items: center;
  gap: 6px;
  padding: 6px 12px;
  font-size: 14px;
  font-weight: 600;
}
.gender-badge ion-icon {
  font-size: 16px;
}

.child-info-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
  gap: 16px;
  margin-top: 8px;
}

.info-item {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 12px;
  background: rgba(73, 144, 226, 0.05);
  border-radius: 8px;
  border: 1px solid rgba(73, 144, 226, 0.1);
}
.info-item ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.info-content {
  display: flex;
  flex-direction: column;
  gap: 4px;
  flex: 1;
  min-width: 0;
}

.info-label {
  font-size: 12px;
  color: var(--ion-color-medium);
  font-weight: 500;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}

.info-value {
  font-size: 15px;
  font-weight: 600;
  color: var(--ion-color-dark);
  word-wrap: break-word;
}

.graph-card {
  border-radius: 16px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}
.graph-card ion-card-header {
  padding: 20px 20px 12px 20px;
}
.graph-card ion-card-title {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 20px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.graph-card ion-card-title ion-icon {
  font-size: 24px;
}
.graph-card ion-card-subtitle {
  margin-top: 8px;
  font-size: 14px;
  color: var(--ion-color-medium);
}
.graph-card ion-card-content {
  padding: 0;
}
.landscape-mode .graph-card {
  margin-bottom: 0;
}
.landscape-mode .graph-card .graph-canvas {
  min-height: 500px;
  padding: 16px;
}

.graph-controls {
  display: flex;
  justify-content: flex-end;
  padding: 8px 16px 0;
  position: relative;
  z-index: 10;
}
.graph-controls .area-toggle {
  cursor: pointer;
  -webkit-user-select: none;
          user-select: none;
  font-weight: 600;
  font-size: 14px;
  height: 32px;
}
.graph-controls .area-toggle ion-icon {
  font-size: 18px;
}
.graph-controls .area-toggle:hover {
  opacity: 0.8;
}

.graph-canvas {
  padding: 20px;
  min-height: 400px;
  overflow-x: auto;
  overflow-y: visible;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  min-height: 400px;
  gap: 16px;
}
.loading-container ion-spinner {
  transform: scale(1.5);
}
.loading-container p {
  font-size: 16px;
  color: var(--ion-color-medium);
  margin: 0;
}

@media (max-width: 768px) {
  .gmp-container {
    padding: 12px;
  }
  .child-name {
    font-size: 20px;
  }
  .child-info-grid {
    grid-template-columns: 1fr;
    gap: 12px;
  }
  .graph-card ion-card-title {
    font-size: 18px;
  }
  .graph-card ion-card-title ion-icon {
    font-size: 20px;
  }
  .graph-canvas {
    padding: 12px;
    min-height: 300px;
  }
}
@media (max-width: 480px) {
  .child-name-section {
    flex-direction: column;
    align-items: flex-start;
  }
  .child-name {
    font-size: 18px;
  }
  .graph-card ion-card-title {
    font-size: 16px;
    flex-wrap: wrap;
  }
}
@media (min-width: 768px) and (orientation: landscape) {
  .landscape-mode .gmp-container {
    padding: 12px 20px;
  }
  .landscape-mode .child-info-card {
    margin-bottom: 12px;
  }
  .landscape-mode .child-info-card .child-info-grid {
    grid-template-columns: repeat(3, 1fr);
  }
  .landscape-mode .graph-card .graph-canvas {
    min-height: 550px;
    padding: 24px;
  }
}
@media (min-width: 1024px) and (orientation: landscape) {
  .landscape-mode .graph-card .graph-canvas {
    min-height: 600px;
    padding: 32px;
  }
}
@media (orientation: landscape) {
  .gmp-container .child-info-grid {
    grid-template-columns: repeat(3, 1fr);
  }
  .graph-canvas svg {
    max-width: 100%;
    height: auto;
  }
}
:host ::ng-deep .child-growth-line {
  transition: all 0.3s ease;
}

:host ::ng-deep .child-data-point {
  transition: all 0.2s ease;
}

:host ::ng-deep .axisX line,
:host ::ng-deep .axisY line {
  stroke: #9ca3af;
  stroke-opacity: 0.8;
  stroke-width: 1;
}

:host ::ng-deep .axisX path,
:host ::ng-deep .axisY path {
  stroke: #4b5563;
  stroke-width: 2;
}

:host ::ng-deep .axisX text,
:host ::ng-deep .axisY text {
  fill: #374151;
  font-size: 13px;
  font-weight: 600;
}

:host ::ng-deep path,
:host ::ng-deep circle,
:host ::ng-deep line {
  transition: all 0.3s ease;
}

:host ::ng-deep .legend-item {
  transition: all 0.2s ease;
}
:host ::ng-deep .legend-item rect {
  transition: all 0.2s ease;
}
:host ::ng-deep .legend-item text {
  transition: all 0.2s ease;
}

:host ::ng-deep .child-legend rect {
  transition: all 0.2s ease;
}

:host ::ng-deep .measurement-popover {
  --width: auto;
  --max-width: 300px;
  --backdrop-opacity: 0.2;
}
:host ::ng-deep .measurement-popover .popover-content {
  border-radius: 8px;
  overflow: hidden;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
}`, "",{"version":3,"sources":["webpack://./src/app/pages/gmp/gmp.page.scss"],"names":[],"mappings":"AAAA;EACE,qBAAA;AACF;AAEI;EACE,eAAA;AAAN;AAGI;EACE,OAAA;EACA,aAAA;EACA,sBAAA;AADN;AAGM;EACE,OAAA;AADR;AAIM;EACE,iBAAA;AAFR;;AAQA;EACE,iBAAA;EACA,cAAA;EACA,aAAA;AALF;;AASA;EACE,mBAAA;EACA,yCAAA;EACA,mBAAA;AANF;AAQE;EACE,aAAA;AANJ;;AAUA;EACE,aAAA;EACA,sBAAA;EACA,SAAA;AAPF;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;AAPF;;AAUA;EACE,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAPF;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,iBAAA;EACA,eAAA;EACA,gBAAA;AAPF;AASE;EACE,eAAA;AAPJ;;AAWA;EACE,aAAA;EACA,2DAAA;EACA,SAAA;EACA,eAAA;AARF;;AAWA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,yCAAA;AARF;AAUE;EACE,eAAA;EACA,cAAA;AARJ;;AAYA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;AATF;;AAYA;EACE,eAAA;EACA,8BAAA;EACA,gBAAA;EACA,yBAAA;EACA,qBAAA;AATF;;AAYA;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,qBAAA;AATF;;AAaA;EACE,mBAAA;EACA,yCAAA;AAVF;AAYE;EACE,4BAAA;AAVJ;AAaE;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;AAXJ;AAaI;EACE,eAAA;AAXN;AAeE;EACE,eAAA;EACA,eAAA;EACA,8BAAA;AAbJ;AAgBE;EACE,UAAA;AAdJ;AAkBE;EACE,gBAAA;AAhBJ;AAkBI;EACE,iBAAA;EACA,aAAA;AAhBN;;AAqBA;EACE,aAAA;EACA,yBAAA;EACA,mBAAA;EACA,kBAAA;EACA,WAAA;AAlBF;AAoBE;EACE,eAAA;EACA,yBAAA;UAAA,iBAAA;EACA,gBAAA;EACA,eAAA;EACA,YAAA;AAlBJ;AAoBI;EACE,eAAA;AAlBN;AAqBI;EACE,YAAA;AAnBN;;AAwBA;EACE,aAAA;EACA,iBAAA;EACA,gBAAA;EACA,mBAAA;AArBF;;AAyBA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,iBAAA;EACA,SAAA;AAtBF;AAwBE;EACE,qBAAA;AAtBJ;AAyBE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;AAvBJ;;AA4BA;EACE;IACE,aAAA;EAzBF;EA4BA;IACE,eAAA;EA1BF;EA6BA;IACE,0BAAA;IACA,SAAA;EA3BF;EA8BA;IACE,eAAA;EA5BF;EA8BE;IACE,eAAA;EA5BJ;EAgCA;IACE,aAAA;IACA,iBAAA;EA9BF;AACF;AAiCA;EACE;IACE,sBAAA;IACA,uBAAA;EA/BF;EAkCA;IACE,eAAA;EAhCF;EAmCA;IACE,eAAA;IACA,eAAA;EAjCF;AACF;AAqCA;EAEI;IACE,kBAAA;EApCJ;EAuCE;IACE,mBAAA;EArCJ;EAuCI;IACE,qCAAA;EArCN;EA0CI;IACE,iBAAA;IACA,aAAA;EAxCN;AACF;AA8CA;EAEI;IACE,iBAAA;IACA,aAAA;EA7CJ;AACF;AAkDA;EAEI;IACE,qCAAA;EAjDJ;EAsDE;IACE,eAAA;IACA,YAAA;EApDJ;AACF;AAyDA;EACE,yBAAA;AAvDF;;AA0DA;EACE,yBAAA;AAvDF;;AA2DA;;EAEE,eAAA;EACA,mBAAA;EACA,eAAA;AAxDF;;AA2DA;;EAEE,eAAA;EACA,eAAA;AAxDF;;AA2DA;;EAEE,aAAA;EACA,eAAA;EACA,gBAAA;AAxDF;;AA4DA;;;EAGE,yBAAA;AAzDF;;AA6DA;EACE,yBAAA;AA1DF;AA4DE;EACE,yBAAA;AA1DJ;AA6DE;EACE,yBAAA;AA3DJ;;AAgEE;EACE,yBAAA;AA7DJ;;AAkEA;EACE,aAAA;EACA,kBAAA;EACA,uBAAA;AA/DF;AAiEE;EACE,kBAAA;EACA,gBAAA;EACA,0CAAA;AA/DJ","sourcesContent":[".graph-svg-component {\n  --background: #f4f5f8;\n\n  &.landscape-mode {\n    .gmp-container {\n      max-width: 100%;\n    }\n\n    .graph-card {\n      flex: 1;\n      display: flex;\n      flex-direction: column;\n\n      ion-card-content {\n        flex: 1;\n      }\n\n      .graph-canvas {\n        min-height: 500px;\n      }\n    }\n  }\n}\n\n.gmp-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  padding: 16px;\n}\n\n// Child Info Card\n.child-info-card {\n  border-radius: 16px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n  margin-bottom: 16px;\n\n  ion-card-header {\n    padding: 20px;\n  }\n}\n\n.child-header {\n  display: flex;\n  flex-direction: column;\n  gap: 16px;\n}\n\n.child-name-section {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n  flex-wrap: wrap;\n}\n\n.child-name {\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n}\n\n.gender-badge {\n  display: flex;\n  align-items: center;\n  gap: 6px;\n  padding: 6px 12px;\n  font-size: 14px;\n  font-weight: 600;\n\n  ion-icon {\n    font-size: 16px;\n  }\n}\n\n.child-info-grid {\n  display: grid;\n  grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));\n  gap: 16px;\n  margin-top: 8px;\n}\n\n.info-item {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n  padding: 12px;\n  background: rgba(73, 144, 226, 0.05);\n  border-radius: 8px;\n  border: 1px solid rgba(73, 144, 226, 0.1);\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n.info-content {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n  flex: 1;\n  min-width: 0;\n}\n\n.info-label {\n  font-size: 12px;\n  color: var(--ion-color-medium);\n  font-weight: 500;\n  text-transform: uppercase;\n  letter-spacing: 0.5px;\n}\n\n.info-value {\n  font-size: 15px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  word-wrap: break-word;\n}\n\n// Graph Card\n.graph-card {\n  border-radius: 16px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n\n  ion-card-header {\n    padding: 20px 20px 12px 20px;\n  }\n\n  ion-card-title {\n    display: flex;\n    align-items: center;\n    gap: 10px;\n    font-size: 20px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  ion-card-subtitle {\n    margin-top: 8px;\n    font-size: 14px;\n    color: var(--ion-color-medium);\n  }\n\n  ion-card-content {\n    padding: 0;\n  }\n\n  // Landscape mode adjustments\n  .landscape-mode & {\n    margin-bottom: 0;\n\n    .graph-canvas {\n      min-height: 500px;\n      padding: 16px;\n    }\n  }\n}\n\n.graph-controls {\n  display: flex;\n  justify-content: flex-end;\n  padding: 8px 16px 0;\n  position: relative;\n  z-index: 10;\n\n  .area-toggle {\n    cursor: pointer;\n    user-select: none;\n    font-weight: 600;\n    font-size: 14px;\n    height: 32px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n\n    &:hover {\n      opacity: 0.8;\n    }\n  }\n}\n\n.graph-canvas {\n  padding: 20px;\n  min-height: 400px;\n  overflow-x: auto;\n  overflow-y: visible;\n}\n\n// Loading State\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  min-height: 400px;\n  gap: 16px;\n\n  ion-spinner {\n    transform: scale(1.5);\n  }\n\n  p {\n    font-size: 16px;\n    color: var(--ion-color-medium);\n    margin: 0;\n  }\n}\n\n// Responsive Design\n@media (max-width: 768px) {\n  .gmp-container {\n    padding: 12px;\n  }\n\n  .child-name {\n    font-size: 20px;\n  }\n\n  .child-info-grid {\n    grid-template-columns: 1fr;\n    gap: 12px;\n  }\n\n  .graph-card ion-card-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 20px;\n    }\n  }\n\n  .graph-canvas {\n    padding: 12px;\n    min-height: 300px;\n  }\n}\n\n@media (max-width: 480px) {\n  .child-name-section {\n    flex-direction: column;\n    align-items: flex-start;\n  }\n\n  .child-name {\n    font-size: 18px;\n  }\n\n  .graph-card ion-card-title {\n    font-size: 16px;\n    flex-wrap: wrap;\n  }\n}\n\n// Tablet landscape mode (most common for this app)\n@media (min-width: 768px) and (orientation: landscape) {\n  .landscape-mode {\n    .gmp-container {\n      padding: 12px 20px;\n    }\n\n    .child-info-card {\n      margin-bottom: 12px;\n\n      .child-info-grid {\n        grid-template-columns: repeat(3, 1fr);\n      }\n    }\n\n    .graph-card {\n      .graph-canvas {\n        min-height: 550px;\n        padding: 24px;\n      }\n    }\n  }\n}\n\n// Large tablet/desktop landscape\n@media (min-width: 1024px) and (orientation: landscape) {\n  .landscape-mode {\n    .graph-card .graph-canvas {\n      min-height: 600px;\n      padding: 32px;\n    }\n  }\n}\n\n// Orientation-specific adjustments\n@media (orientation: landscape) {\n  .gmp-container {\n    .child-info-grid {\n      grid-template-columns: repeat(3, 1fr);\n    }\n  }\n\n  .graph-canvas {\n    svg {\n      max-width: 100%;\n      height: auto;\n    }\n  }\n}\n\n// Graph line and point styles\n:host ::ng-deep .child-growth-line {\n  transition: all 0.3s ease;\n}\n\n:host ::ng-deep .child-data-point {\n  transition: all 0.2s ease;\n}\n\n// Improve axis and grid styling\n:host ::ng-deep .axisX line,\n:host ::ng-deep .axisY line {\n  stroke: #9ca3af;\n  stroke-opacity: 0.8;\n  stroke-width: 1;\n}\n\n:host ::ng-deep .axisX path,\n:host ::ng-deep .axisY path {\n  stroke: #4b5563;\n  stroke-width: 2;\n}\n\n:host ::ng-deep .axisX text,\n:host ::ng-deep .axisY text {\n  fill: #374151;\n  font-size: 13px;\n  font-weight: 600;\n}\n\n// Smooth animations for graph elements\n:host ::ng-deep path,\n:host ::ng-deep circle,\n:host ::ng-deep line {\n  transition: all 0.3s ease;\n}\n\n// Legend styling\n:host ::ng-deep .legend-item {\n  transition: all 0.2s ease;\n\n  rect {\n    transition: all 0.2s ease;\n  }\n\n  text {\n    transition: all 0.2s ease;\n  }\n}\n\n:host ::ng-deep .child-legend {\n  rect {\n    transition: all 0.2s ease;\n  }\n}\n\n// Measurement Popover Styles\n:host ::ng-deep .measurement-popover {\n  --width: auto;\n  --max-width: 300px;\n  --backdrop-opacity: 0.2;\n\n  .popover-content {\n    border-radius: 8px;\n    overflow: hidden;\n    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 99063:
/*!****************************************************!*\
  !*** ./src/app/pages/gmp/gmp.page.html?ngResource ***!
  \****************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"'/child-detail/' + id\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>GMP {{ type | titlecase }} Chart</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"graph-svg-component\" [class.landscape-mode]=\"isLandscape\">\n  <ng-container *ngIf=\"childData && gmpData; else loading\">\n    <div class=\"gmp-container\">\n      <!-- Child Info Card -->\n      <ion-card class=\"child-info-card\">\n        <ion-card-header>\n          <div class=\"child-header\">\n            <div class=\"child-name-section\">\n              <h1 class=\"child-name\">{{ childData?.name }}</h1>\n              <ion-badge color=\"primary\" class=\"gender-badge\">\n                <ion-icon [name]=\"childData?.gender === 'Male' ? 'male-outline' : 'female-outline'\"></ion-icon>\n                {{ childData?.gender }}\n              </ion-badge>\n            </div>\n            <div class=\"child-info-grid\">\n              <div class=\"info-item\">\n                <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                <div class=\"info-content\">\n                  <span class=\"info-label\">Date of Birth</span>\n                  <span class=\"info-value\">{{ childData?.date_of_birth | date:'dd MMM yyyy' }}</span>\n                </div>\n              </div>\n              <div class=\"info-item\">\n                <ion-icon name=\"time-outline\" color=\"primary\"></ion-icon>\n                <div class=\"info-content\">\n                  <span class=\"info-label\">Age</span>\n                  <span class=\"info-value\">{{ childData?.age }} months</span>\n                </div>\n              </div>\n              <div class=\"info-item\">\n                <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                <div class=\"info-content\">\n                  <span class=\"info-label\">Progress ID</span>\n                  <span class=\"info-value\">{{ childData?.progress_id || '-' }}</span>\n                </div>\n              </div>\n            </div>\n          </div>\n        </ion-card-header>\n      </ion-card>\n\n      <!-- Graph Card -->\n      <ion-card class=\"graph-card\">\n        <ion-card-header>\n          <ion-card-title>\n            <ion-icon [name]=\"type === 'height' ? 'resize-outline' : 'scale-outline'\" color=\"primary\"></ion-icon>\n            {{ type | titlecase }} Growth Chart\n          </ion-card-title>\n          <ion-card-subtitle>Growth monitoring and promotion chart showing {{ type }} progression</ion-card-subtitle>\n        </ion-card-header>\n        <ion-card-content>\n          <div class=\"graph-controls\">\n            <ion-chip (click)=\"toggleAreaFill()\" [color]=\"showAreaFill ? 'primary' : 'medium'\" class=\"area-toggle\">\n              <ion-icon [name]=\"showAreaFill ? 'layers' : 'layers-outline'\"></ion-icon>\n              <ion-label>{{ showAreaFill ? 'Hide Areas' : 'Show Areas' }}</ion-label>\n            </ion-chip>\n          </div>\n          <div #gmpGraphCanvas id=\"gmpGraphCanvas\" class=\"graph-canvas\"></div>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </ng-container>\n\n  <ng-template #loading>\n    <div class=\"loading-container\">\n      <ion-spinner name=\"crescent\" color=\"primary\"></ion-spinner>\n      <p>Loading GMP data...</p>\n    </div>\n  </ng-template>\n</ion-content>";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_gmp_gmp_module_ts-src_app_services_api_base_service_ts.js.map