(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_facility-supervision-list_facility-supervision-list_module_ts"],{

/***/ 13515:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision-list/facility-supervision-list-routing.module.ts ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionListPageRoutingModule: () => (/* binding */ FacilitySupervisionListPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _facility_supervision_list_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./facility-supervision-list.page */ 54525);




const routes = [{
  path: '',
  component: _facility_supervision_list_page__WEBPACK_IMPORTED_MODULE_0__.FacilitySupervisionListPage
}];
let FacilitySupervisionListPageRoutingModule = class FacilitySupervisionListPageRoutingModule {};
FacilitySupervisionListPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], FacilitySupervisionListPageRoutingModule);


/***/ }),

/***/ 60554:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision-list/facility-supervision-list.module.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionListPageModule: () => (/* binding */ FacilitySupervisionListPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _facility_supervision_list_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./facility-supervision-list-routing.module */ 13515);
/* harmony import */ var _facility_supervision_list_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./facility-supervision-list.page */ 54525);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let FacilitySupervisionListPageModule = class FacilitySupervisionListPageModule {};
FacilitySupervisionListPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _facility_supervision_list_routing_module__WEBPACK_IMPORTED_MODULE_0__.FacilitySupervisionListPageRoutingModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule],
  declarations: [_facility_supervision_list_page__WEBPACK_IMPORTED_MODULE_1__.FacilitySupervisionListPage]
})], FacilitySupervisionListPageModule);


/***/ }),

/***/ 54525:
/*!***********************************************************************************!*\
  !*** ./src/app/pages/facility-supervision-list/facility-supervision-list.page.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FacilitySupervisionListPage: () => (/* binding */ FacilitySupervisionListPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _facility_supervision_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./facility-supervision-list.page.html?ngResource */ 38983);
/* harmony import */ var _facility_supervision_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./facility-supervision-list.page.scss?ngResource */ 73435);
/* harmony import */ var _facility_supervision_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_facility_supervision_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_facility_supervision_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/facility_supervision_api.service */ 73556);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);

var _FacilitySupervisionListPage;







let FacilitySupervisionListPage = (_FacilitySupervisionListPage = class FacilitySupervisionListPage {
  constructor(b, router, api) {
    this.b = b;
    this.router = router;
    this.api = api;
    this.supervisions = [];
    this.filteredSupervisions = [];
    // Loading state
    this.isLoading = false;
    // Pagination
    this.currentPage = 1;
    this.perPage = 20;
    this.totalRecords = 0;
  }
  ngOnInit() {
    this.loadData();
  }
  /**
   * Load facility supervisions
   */
  loadData(event) {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        _this.isLoading = true;
        const params = {
          page: _this.currentPage,
          per_page: _this.perPage
        };
        const response = yield _this.api.getSupervisions(params);
        if (response.data) {
          // Handle paginated response structure
          if (response.data.data) {
            _this.supervisions = response.data.data;
            _this.totalRecords = response.data.total || 0;
          } else {
            // Handle non-paginated response
            _this.supervisions = Array.isArray(response.data) ? response.data : [response.data];
            _this.totalRecords = _this.supervisions.length;
          }
          _this.filteredSupervisions = _this.supervisions;
        }
        if (event) {
          event.target.complete();
        }
      } catch (error) {
        _this.b.errorToast('Failed to load supervisions');
      } finally {
        _this.isLoading = false;
      }
    })();
  }
  /**
   * Navigate to create new supervision
   */
  createNewSupervision() {
    this.router.navigate(['/facility-supervision']);
  }
  /**
   * View supervision details
   */
  viewSupervision(supervision) {
    this.router.navigate(['/facility-supervision-view', supervision.id]);
  }
  /**
   * Edit supervision
   */
  editSupervision(supervision) {
    this.router.navigate(['/facility-supervision', supervision.id], {
      state: {
        edit_mode: true,
        inf_id: supervision.inf_id
      }
    });
  }
  /**
   * Delete supervision
   */
  deleteSupervision(supervision) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.b.loadAlert('Delete Supervision', 'Are you sure you want to delete this facility supervision record?', /*#__PURE__*/(0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        try {
          const response = yield _this2.api.deleteSupervision(supervision.id);
          if (response.success !== false) {
            _this2.b.toast('Supervision deleted successfully');
            _this2.loadData();
          }
          // Error toast already shown by errorHandle in API service
        } catch (error) {
          _this2.b.errorToast('Failed to delete supervision');
        }
      }));
    })();
  }
  /**
   * Format date for display
   */
  formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('en-GB', {
      day: '2-digit',
      month: 'short',
      year: 'numeric'
    });
  }
  /**
   * Get score color based on percentage
   */
  getScoreColor(scoreString) {
    if (!scoreString) return 'medium';
    // Extract percentage from format like "45/51 (88.2% - Good)"
    const match = scoreString.match(/\((\d+\.?\d*)%/);
    if (!match) return 'medium';
    const percentage = parseFloat(match[1]);
    if (percentage >= 90) return 'success';
    if (percentage >= 70) return 'primary';
    if (percentage >= 50) return 'warning';
    return 'danger';
  }
  /**
   * Get sync status color
   */
  getSyncStatusColor(status) {
    switch (status) {
      case 'synced':
        return 'success';
      case 'pending':
        return 'warning';
      case 'failed':
        return 'danger';
      default:
        return 'medium';
    }
  }
  /**
   * Refresh data
   */
  refresh(event) {
    this.currentPage = 1;
    this.loadData(event);
  }
  /**
   * Load more data (infinite scroll)
   */
  loadMore(event) {
    if (this.filteredSupervisions.length < this.totalRecords) {
      this.currentPage++;
      this.loadData(event);
    } else {
      event.target.complete();
    }
  }
  /**
   * Check if supervision can be edited/deleted (only if created today)
   */
  canEditOrDelete(supervision) {
    if (!supervision.created_at) return false;
    const createdDate = new Date(supervision.created_at);
    const today = new Date();
    // Compare only the date part (ignore time)
    return createdDate.getFullYear() === today.getFullYear() && createdDate.getMonth() === today.getMonth() && createdDate.getDate() === today.getDate();
  }
  /**
   * Track by function for ngFor performance
   */
  trackBySupervision(index, item) {
    return item.id || index;
  }
  /**
   * Parse remarks string into structured data
   */
  parseRemarks(remarks) {
    if (!remarks) return [];
    try {
      // Split by comma to get individual items
      const items = remarks.split('|').map(item => item.trim());
      const parsedItems = [];
      items.forEach(item => {
        // Match pattern: "ACRONYM:X/Y (Z% - STATUS)"
        const match = item.match(/^([^:]+):(\d+)\/(\d+)\s*\((\d+\.?\d*)%\s*-\s*([^)]+)\)$/);
        if (match) {
          const [, acronym, achieved, total, percentage, status] = match;
          const percentageNum = parseFloat(percentage);
          parsedItems.push({
            text: item,
            // Keep the full text as-is
            percentage: percentageNum,
            color: this.getColorByPercentage(percentageNum)
          });
        }
      });
      return parsedItems;
    } catch (error) {
      return [];
    }
  }
  /**
   * Get color based on percentage
   */
  getColorByPercentage(percentage) {
    if (percentage >= 90) return 'score-success';
    if (percentage >= 70) return 'score-primary';
    if (percentage >= 50) return 'score-warning';
    return 'score-danger';
  }
  /**
   * Track by function for parsed remarks
   */
  trackByRemark(index, item) {
    return item.acronym + index;
  }
}, _FacilitySupervisionListPage.ctorParameters = () => [{
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.Router
}, {
  type: src_app_services_facility_supervision_api_service__WEBPACK_IMPORTED_MODULE_3__.FacilitySupervisionAPIService
}], _FacilitySupervisionListPage);
FacilitySupervisionListPage = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-facility-supervision-list',
  template: _facility_supervision_list_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_facility_supervision_list_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], FacilitySupervisionListPage);


/***/ }),

/***/ 73435:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision-list/facility-supervision-list.page.scss?ngResource ***!
  \************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-success: #2dd36f;
  --ion-color-success-rgb: 45, 211, 111;
  --ion-color-success-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.supply-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 16px;
  padding: 0 4px;
  flex-wrap: wrap;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 0 1 auto;
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.action-buttons-group {
  display: flex;
  gap: 10px;
  flex-wrap: wrap;
  align-items: center;
  flex: 0 1 auto;
}
.action-buttons-group .action-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
  min-width: 120px;
  transition: all 0.3s ease;
}
.action-buttons-group .action-btn ion-icon {
  font-size: 18px;
  margin-inline-end: 6px !important;
}
.action-buttons-group .action-btn:hover {
  transform: translateY(-2px);
  --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);
}
.action-buttons-group .action-btn:active {
  transform: translateY(0);
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
  flex-wrap: wrap;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.table-container {
  overflow-x: auto;
  border-radius: 8px;
  border: 1px solid var(--ion-color-light);
  margin-top: 1rem;
}

.measurements-table {
  width: 100%;
  border-collapse: collapse;
  min-width: auto;
  table-layout: auto;
}
.measurements-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 8px;
  text-align: center;
  border-bottom: 2px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: nowrap;
}
.measurements-table td {
  padding: 10px 8px;
  border-bottom: 1px solid var(--ion-color-light);
  font-size: 0.85rem;
  text-align: center;
  vertical-align: middle;
}
.measurements-table tbody tr {
  transition: all 0.2s ease;
}
.measurements-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.measurements-table tbody tr:last-child td {
  border-bottom: none;
}

.row-number {
  font-weight: 600;
  color: var(--ion-color-primary);
  text-align: center;
  width: 40px;
  font-size: 15px;
  white-space: nowrap;
}

.actions-cell {
  width: 130px;
  text-align: center;
  white-space: nowrap;
}
.actions-cell ion-button {
  margin: 0 2px;
  --padding-start: 6px;
  --padding-end: 6px;
}
.actions-cell ion-button ion-icon {
  font-size: 18px;
}

.status-cell ion-badge {
  font-size: 12px;
  font-weight: 600;
  padding: 4px 10px;
  border-radius: 6px;
  text-transform: capitalize;
}

.score-cell ion-badge {
  font-size: 13px;
  font-weight: 600;
  padding: 5px 12px;
  border-radius: 6px;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.empty-state ion-icon {
  font-size: 48px;
  margin-bottom: 16px;
}
.empty-state h3 {
  font-size: 18px;
  font-weight: 600;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
}
.empty-state p {
  font-size: 14px;
  color: var(--ion-color-medium);
  margin: 0 0 16px 0;
  max-width: 300px;
}
.empty-state ion-button {
  --border-radius: 12px;
  height: 44px;
  font-size: 14px;
  font-weight: 600;
}
.empty-state ion-button ion-icon {
  font-size: 18px;
}

.filter-item {
  --background: rgba(73, 144, 226, 0.02);
  --border-radius: 8px;
  margin-bottom: 12px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.filter-item ion-label {
  font-size: 12px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin-bottom: 4px;
}

.filter-btn {
  --border-radius: 12px;
  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
  height: 44px;
  font-size: 14px;
  font-weight: 600;
  text-transform: none;
}
.filter-btn ion-icon {
  font-size: 18px;
}

ion-searchbar {
  margin-bottom: 12px;
  --border-radius: 12px;
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
    flex-direction: column;
    align-items: flex-start;
    gap: 12px;
  }
  .section-title-main {
    font-size: 20px;
    width: 100%;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .action-buttons-group {
    width: 100%;
    justify-content: stretch;
  }
  .action-buttons-group .action-btn {
    flex: 1 1 auto;
    height: 42px;
    font-size: 13px;
    min-width: 100px;
  }
  .action-buttons-group .action-btn ion-icon {
    font-size: 16px;
  }
  .section-header {
    padding: 0 4px;
    gap: 12px;
  }
  .section-header .section-title {
    font-size: 18px;
  }
  .section-header .section-title ion-icon {
    font-size: 22px;
  }
  .measurements-table {
    font-size: 0.75rem;
    min-width: auto;
  }
  .measurements-table th, .measurements-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .actions-cell {
    width: 100px;
  }
  .actions-cell ion-button {
    --padding-start: 6px;
    --padding-end: 6px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 16px;
  }
  .status-cell ion-badge,
  .score-cell ion-badge {
    font-size: 11px;
    padding: 3px 8px;
  }
  .filter-item {
    margin-bottom: 8px;
  }
  .filter-item ion-label {
    font-size: 11px;
  }
  .filter-btn {
    height: 40px;
    font-size: 13px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .action-buttons-group {
    flex-direction: column;
    gap: 8px;
  }
  .action-buttons-group .action-btn {
    width: 100%;
    min-width: auto;
    height: 40px;
    font-size: 13px;
  }
  .section-header {
    padding: 0 4px;
    gap: 8px;
  }
  .section-header .section-title {
    font-size: 16px;
  }
  .section-header .section-title ion-icon {
    font-size: 20px;
  }
  .measurements-table {
    font-size: 0.7rem;
    min-width: auto;
  }
  .measurements-table th, .measurements-table td {
    padding: 6px 3px;
    font-size: 0.7rem;
  }
  .actions-cell {
    width: 90px;
  }
  .actions-cell ion-button {
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .actions-cell ion-button ion-icon {
    font-size: 14px;
  }
  .status-cell ion-badge,
  .score-cell ion-badge {
    font-size: 10px;
    padding: 2px 6px;
  }
  .filter-item {
    margin-bottom: 6px;
  }
  .filter-item ion-label {
    font-size: 10px;
  }
  .filter-btn {
    height: 38px;
    font-size: 12px;
  }
  .empty-state {
    padding: 40px 16px;
  }
  .empty-state ion-icon {
    font-size: 40px;
  }
  .empty-state h3 {
    font-size: 16px;
  }
  .empty-state p {
    font-size: 13px;
  }
  .empty-state ion-button {
    height: 40px;
    font-size: 13px;
  }
  .remarks-badges {
    gap: 4px;
  }
  .remark-badge {
    font-size: 10px;
    padding: 4px 6px;
    margin: 1px;
  }
}
.remarks-cell {
  text-align: left !important;
  width: auto;
  padding: 8px !important;
}

.remarks-container {
  width: 100%;
}

.remarks-badges {
  display: flex;
  flex-direction: column;
  gap: 6px;
  align-items: flex-start;
}

.remark-badge {
  display: inline-flex;
  align-items: center;
  font-size: 12px;
  font-weight: 500;
  padding: 6px 10px;
  border-radius: 6px;
  white-space: nowrap;
  margin: 2px;
}
.remark-badge.score-success {
  --background: #09AA4E;
  --color: #ffffff;
  background: #09AA4E;
  color: #ffffff;
}
.remark-badge.score-primary {
  --background: #0EA5E9;
  --color: #ffffff;
  background: #0EA5E9;
  color: #ffffff;
}
.remark-badge.score-warning {
  --background: #FFA500;
  --color: #ffffff;
  background: #FFA500;
  color: #ffffff;
}
.remark-badge.score-danger {
  --background: #BF0A0B;
  --color: #ffffff;
  background: #BF0A0B;
  color: #ffffff;
}

.no-data {
  color: var(--ion-color-medium);
  font-style: italic;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/facility-supervision-list/facility-supervision-list.page.scss"],"names":[],"mappings":"AACA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AAAF;;AAIA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AADF;;AAIA;EACE,gBAAA;EACA,cAAA;AADF;;AAIA;EACE,gBAAA;EACA,wBAAA;AADF;;AAIA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AADF;;AAKA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,SAAA;EACA,cAAA;EACA,eAAA;AAFF;;AAKA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;AAFF;AAIE;EACE,eAAA;EACA,cAAA;AAFJ;;AAMA;EACE,aAAA;EACA,SAAA;EACA,eAAA;EACA,mBAAA;EACA,cAAA;AAHF;AAKE;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;EACA,gBAAA;EACA,yBAAA;AAHJ;AAKI;EACE,eAAA;EACA,iCAAA;AAHN;AAMI;EACE,2BAAA;EACA,4CAAA;AAJN;AAOI;EACE,wBAAA;AALN;;AAWA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;EACA,eAAA;AARF;;AAWA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AARF;AAUE;EACE,eAAA;EACA,cAAA;AARJ;;AAaA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;EACA,gBAAA;AAVF;;AAcA;EACE,WAAA;EACA,yBAAA;EACA,eAAA;EACA,kBAAA;AAXF;AAaE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;AAXJ;AAcE;EACE,iBAAA;EACA,+CAAA;EACA,kBAAA;EACA,kBAAA;EACA,sBAAA;AAZJ;AAeE;EACE,yBAAA;AAbJ;AAeI;EACE,6CAAA;AAbN;AAiBE;EACE,mBAAA;AAfJ;;AAmBA;EACE,gBAAA;EACA,+BAAA;EACA,kBAAA;EACA,WAAA;EACA,eAAA;EACA,mBAAA;AAhBF;;AAmBA;EACE,YAAA;EACA,kBAAA;EACA,mBAAA;AAhBF;AAkBE;EACE,aAAA;EACA,oBAAA;EACA,kBAAA;AAhBJ;AAkBI;EACE,eAAA;AAhBN;;AAsBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,0BAAA;AAnBJ;;AAwBE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;AArBJ;;AA0BA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAvBF;AAyBE;EACE,eAAA;EACA,mBAAA;AAvBJ;AA0BE;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;AAxBJ;AA2BE;EACE,eAAA;EACA,8BAAA;EACA,kBAAA;EACA,gBAAA;AAzBJ;AA4BE;EACE,qBAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;AA1BJ;AA4BI;EACE,eAAA;AA1BN;;AAgCA;EACE,sCAAA;EACA,oBAAA;EACA,mBAAA;EACA,qCAAA;AA7BF;AA+BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AA7BJ;;AAiCA;EACE,qBAAA;EACA,4CAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;EACA,oBAAA;AA9BF;AAgCE;EACE,eAAA;AA9BJ;;AAkCA;EACE,mBAAA;EACA,qBAAA;AA/BF;;AAmCA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EAhCF;EAmCA;IACE,mBAAA;EAjCF;EAoCA;IACE,mBAAA;IACA,sBAAA;IACA,uBAAA;IACA,SAAA;EAlCF;EAqCA;IACE,eAAA;IACA,WAAA;EAnCF;EAqCE;IACE,eAAA;EAnCJ;EAuCA;IACE,WAAA;IACA,wBAAA;EArCF;EAuCE;IACE,cAAA;IACA,YAAA;IACA,eAAA;IACA,gBAAA;EArCJ;EAuCI;IACE,eAAA;EArCN;EA0CA;IACE,cAAA;IACA,SAAA;EAxCF;EA0CE;IACE,eAAA;EAxCJ;EA0CI;IACE,eAAA;EAxCN;EA6CA;IACE,kBAAA;IACA,eAAA;EA3CF;EA6CE;IACE,gBAAA;IACA,kBAAA;EA3CJ;EA+CA;IACE,YAAA;EA7CF;EA+CE;IACE,oBAAA;IACA,kBAAA;EA7CJ;EA+CI;IACE,eAAA;EA7CN;EAkDA;;IAEE,eAAA;IACA,gBAAA;EAhDF;EAmDA;IACE,kBAAA;EAjDF;EAmDE;IACE,eAAA;EAjDJ;EAqDA;IACE,YAAA;IACA,eAAA;EAnDF;AACF;AAsDA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EApDF;EAuDA;IACE,mBAAA;EArDF;EAwDA;IACE,mBAAA;EAtDF;EAyDA;IACE,eAAA;EAvDF;EAyDE;IACE,eAAA;EAvDJ;EA2DA;IACE,sBAAA;IACA,QAAA;EAzDF;EA2DE;IACE,WAAA;IACA,eAAA;IACA,YAAA;IACA,eAAA;EAzDJ;EA6DA;IACE,cAAA;IACA,QAAA;EA3DF;EA6DE;IACE,eAAA;EA3DJ;EA6DI;IACE,eAAA;EA3DN;EAgEA;IACE,iBAAA;IACA,eAAA;EA9DF;EAgEE;IACE,gBAAA;IACA,iBAAA;EA9DJ;EAkEA;IACE,WAAA;EAhEF;EAkEE;IACE,oBAAA;IACA,kBAAA;EAhEJ;EAkEI;IACE,eAAA;EAhEN;EAqEA;;IAEE,eAAA;IACA,gBAAA;EAnEF;EAsEA;IACE,kBAAA;EApEF;EAsEE;IACE,eAAA;EApEJ;EAwEA;IACE,YAAA;IACA,eAAA;EAtEF;EAyEA;IACE,kBAAA;EAvEF;EAyEE;IACE,eAAA;EAvEJ;EA0EE;IACE,eAAA;EAxEJ;EA2EE;IACE,eAAA;EAzEJ;EA4EE;IACE,YAAA;IACA,eAAA;EA1EJ;EA8EA;IACE,QAAA;EA5EF;EA+EA;IACE,eAAA;IACA,gBAAA;IACA,WAAA;EA7EF;AACF;AAiFA;EACE,2BAAA;EACA,WAAA;EACA,uBAAA;AA/EF;;AAkFA;EACE,WAAA;AA/EF;;AAkFA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,uBAAA;AA/EF;;AAkFA;EACE,oBAAA;EACA,mBAAA;EACA,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,mBAAA;EACA,WAAA;AA/EF;AAkFE;EACE,qBAAA;EACA,gBAAA;EACA,mBAAA;EACA,cAAA;AAhFJ;AAmFE;EACE,qBAAA;EACA,gBAAA;EACA,mBAAA;EACA,cAAA;AAjFJ;AAoFE;EACE,qBAAA;EACA,gBAAA;EACA,mBAAA;EACA,cAAA;AAlFJ;AAqFE;EACE,qBAAA;EACA,gBAAA;EACA,mBAAA;EACA,cAAA;AAnFJ;;AAuFA;EACE,8BAAA;EACA,kBAAA;AApFF","sourcesContent":["// Styles matching supply-transaction design\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-success: #2dd36f;\n  --ion-color-success-rgb: 45, 211, 111;\n  --ion-color-success-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main container\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n.supply-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  gap: 16px;\n  padding: 0 4px;\n  flex-wrap: wrap;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 0 1 auto;\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n.action-buttons-group {\n  display: flex;\n  gap: 10px;\n  flex-wrap: wrap;\n  align-items: center;\n  flex: 0 1 auto;\n\n  .action-btn {\n    --border-radius: 12px;\n    --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n    height: 44px;\n    font-size: 14px;\n    font-weight: 600;\n    text-transform: none;\n    min-width: 120px;\n    transition: all 0.3s ease;\n\n    ion-icon {\n      font-size: 18px;\n      margin-inline-end: 6px !important;\n    }\n\n    &:hover {\n      transform: translateY(-2px);\n      --box-shadow: 0 6px 16px rgba(0, 0, 0, 0.18);\n    }\n\n    &:active {\n      transform: translateY(0);\n    }\n  }\n}\n\n// Section Header (inside cards)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n  flex-wrap: wrap;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Table Container\n.table-container {\n  overflow-x: auto;\n  border-radius: 8px;\n  border: 1px solid var(--ion-color-light);\n  margin-top: 1rem;\n}\n\n// Measurements Table Styles\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: auto;\n  table-layout: auto;\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 8px;\n    text-align: center;\n    border-bottom: 2px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: nowrap;\n  }\n\n  td {\n    padding: 10px 8px;\n    border-bottom: 1px solid var(--ion-color-light);\n    font-size: 0.85rem;\n    text-align: center;\n    vertical-align: middle;\n  }\n\n  tbody tr {\n    transition: all 0.2s ease;\n\n    &:hover {\n      background-color: var(--ion-color-light-tint);\n    }\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n.row-number {\n  font-weight: 600;\n  color: var(--ion-color-primary);\n  text-align: center;\n  width: 40px;\n  font-size: 15px;\n  white-space: nowrap;\n}\n\n.actions-cell {\n  width: 130px;\n  text-align: center;\n  white-space: nowrap;\n\n  ion-button {\n    margin: 0 2px;\n    --padding-start: 6px;\n    --padding-end: 6px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n.status-cell {\n  ion-badge {\n    font-size: 12px;\n    font-weight: 600;\n    padding: 4px 10px;\n    border-radius: 6px;\n    text-transform: capitalize;\n  }\n}\n\n.score-cell {\n  ion-badge {\n    font-size: 13px;\n    font-weight: 600;\n    padding: 5px 12px;\n    border-radius: 6px;\n  }\n}\n\n// Empty State\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-icon {\n    font-size: 48px;\n    margin-bottom: 16px;\n  }\n\n  h3 {\n    font-size: 18px;\n    font-weight: 600;\n    margin: 0 0 8px 0;\n    color: var(--ion-color-dark);\n  }\n\n  p {\n    font-size: 14px;\n    color: var(--ion-color-medium);\n    margin: 0 0 16px 0;\n    max-width: 300px;\n  }\n\n  ion-button {\n    --border-radius: 12px;\n    height: 44px;\n    font-size: 14px;\n    font-weight: 600;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n}\n\n// Filter Styles\n.filter-item {\n  --background: rgba(73, 144, 226, 0.02);\n  --border-radius: 8px;\n  margin-bottom: 12px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n\n  ion-label {\n    font-size: 12px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    margin-bottom: 4px;\n  }\n}\n\n.filter-btn {\n  --border-radius: 12px;\n  --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);\n  height: 44px;\n  font-size: 14px;\n  font-weight: 600;\n  text-transform: none;\n\n  ion-icon {\n    font-size: 18px;\n  }\n}\n\nion-searchbar {\n  margin-bottom: 12px;\n  --border-radius: 12px;\n}\n\n// Mobile and Tablet Responsive Design\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 12px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n    width: 100%;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .action-buttons-group {\n    width: 100%;\n    justify-content: stretch;\n\n    .action-btn {\n      flex: 1 1 auto;\n      height: 42px;\n      font-size: 13px;\n      min-width: 100px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 12px;\n\n    .section-title {\n      font-size: 18px;\n\n      ion-icon {\n        font-size: 22px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.75rem;\n    min-width: auto;\n\n    th, td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n    }\n  }\n\n  .actions-cell {\n    width: 100px;\n\n    ion-button {\n      --padding-start: 6px;\n      --padding-end: 6px;\n\n      ion-icon {\n        font-size: 16px;\n      }\n    }\n  }\n\n  .status-cell ion-badge,\n  .score-cell ion-badge {\n    font-size: 11px;\n    padding: 3px 8px;\n  }\n\n  .filter-item {\n    margin-bottom: 8px;\n\n    ion-label {\n      font-size: 11px;\n    }\n  }\n\n  .filter-btn {\n    height: 40px;\n    font-size: 13px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .action-buttons-group {\n    flex-direction: column;\n    gap: 8px;\n\n    .action-btn {\n      width: 100%;\n      min-width: auto;\n      height: 40px;\n      font-size: 13px;\n    }\n  }\n\n  .section-header {\n    padding: 0 4px;\n    gap: 8px;\n\n    .section-title {\n      font-size: 16px;\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n\n  .measurements-table {\n    font-size: 0.7rem;\n    min-width: auto;\n\n    th, td {\n      padding: 6px 3px;\n      font-size: 0.7rem;\n    }\n  }\n\n  .actions-cell {\n    width: 90px;\n\n    ion-button {\n      --padding-start: 4px;\n      --padding-end: 4px;\n\n      ion-icon {\n        font-size: 14px;\n      }\n    }\n  }\n\n  .status-cell ion-badge,\n  .score-cell ion-badge {\n    font-size: 10px;\n    padding: 2px 6px;\n  }\n\n  .filter-item {\n    margin-bottom: 6px;\n\n    ion-label {\n      font-size: 10px;\n    }\n  }\n\n  .filter-btn {\n    height: 38px;\n    font-size: 12px;\n  }\n\n  .empty-state {\n    padding: 40px 16px;\n\n    ion-icon {\n      font-size: 40px;\n    }\n\n    h3 {\n      font-size: 16px;\n    }\n\n    p {\n      font-size: 13px;\n    }\n\n    ion-button {\n      height: 40px;\n      font-size: 13px;\n    }\n  }\n\n  .remarks-badges {\n    gap: 4px;\n  }\n\n  .remark-badge {\n    font-size: 10px;\n    padding: 4px 6px;\n    margin: 1px;\n  }\n}\n\n// Remarks display styles\n.remarks-cell {\n  text-align: left !important;\n  width: auto;\n  padding: 8px !important;\n}\n\n.remarks-container {\n  width: 100%;\n}\n\n.remarks-badges {\n  display: flex;\n  flex-direction: column;\n  gap: 6px;\n  align-items: flex-start;\n}\n\n.remark-badge {\n  display: inline-flex;\n  align-items: center;\n  font-size: 12px;\n  font-weight: 500;\n  padding: 6px 10px;\n  border-radius: 6px;\n  white-space: nowrap;\n  margin: 2px;\n\n  // Custom score colors\n  &.score-success {\n    --background: #09AA4E;\n    --color: #ffffff;\n    background: #09AA4E;\n    color: #ffffff;\n  }\n\n  &.score-primary {\n    --background: #0EA5E9;\n    --color: #ffffff;\n    background: #0EA5E9;\n    color: #ffffff;\n  }\n\n  &.score-warning {\n    --background: #FFA500;\n    --color: #ffffff;\n    background: #FFA500;\n    color: #ffffff;\n  }\n\n  &.score-danger {\n    --background: #BF0A0B;\n    --color: #ffffff;\n    background: #BF0A0B;\n    color: #ffffff;\n  }\n}\n\n.no-data {\n  color: var(--ion-color-medium);\n  font-style: italic;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 38983:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/facility-supervision-list/facility-supervision-list.page.html?ngResource ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Facility Supervisions</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"refresh($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n  <div *ngIf=\"!isLoading || filteredSupervisions.length > 0; else skeleton\" class=\"supply-container\">\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h2 class=\"section-title-main\">\n        <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n        Facility Supervisions\n      </h2>\n      <div class=\"action-buttons-group\">\n        <ion-button (click)=\"createNewSupervision()\" color=\"primary\" class=\"action-btn\">\n          <ion-icon name=\"add\" slot=\"start\"></ion-icon>\n          New Supervision\n        </ion-button>\n      </div>\n    </div>\n\n    <!-- Table Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon name=\"list-outline\" color=\"primary\"></ion-icon>\n            Supervision Records ({{filteredSupervisions?.length || 0}})\n          </h2>\n        </div>\n        <ion-card-content *ngIf=\"filteredSupervisions?.length > 0; else emptyState\">\n          <div class=\"table-container\">\n            <table class=\"measurements-table\">\n              <thead>\n                <tr>\n                  <th>#</th>\n                  <th>Created At</th>\n                  <th>Supervision Scores</th>\n                  <th>Actions</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr *ngFor=\"let supervision of filteredSupervisions; trackBy: trackBySupervision; let i = index\" class=\"supply-row\">\n                  <td class=\"row-number\">{{ i + 1 }}</td>\n                  <td>{{ formatDate(supervision.created_at || '') }}</td>\n                  <td class=\"remarks-cell\">\n                    <div class=\"remarks-container\" *ngIf=\"supervision.remarks; else noRemarks\">\n                      <div class=\"remarks-badges\">\n                        <ion-badge\n                          *ngFor=\"let remark of parseRemarks(supervision.remarks); trackBy: trackByRemark\"\n                          class=\"remark-badge {{remark.color}}\">\n                          {{ remark.text }}\n                        </ion-badge>\n                      </div>\n                    </div>\n                    <ng-template #noRemarks>\n                      <span class=\"no-data\">-</span>\n                    </ng-template>\n                  </td>\n                  <td class=\"actions-cell\">\n                    <ion-button fill=\"clear\" size=\"small\" (click)=\"viewSupervision(supervision)\" color=\"primary\" title=\"View Details\">\n                      <ion-icon name=\"eye-outline\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canEditOrDelete(supervision)\" fill=\"clear\" size=\"small\" (click)=\"editSupervision(supervision)\" color=\"secondary\" title=\"Edit\">\n                      <ion-icon name=\"create-outline\"></ion-icon>\n                    </ion-button>\n                    <ion-button *ngIf=\"canEditOrDelete(supervision)\" fill=\"clear\" size=\"small\" (click)=\"deleteSupervision(supervision)\" color=\"danger\" title=\"Delete\">\n                      <ion-icon name=\"trash-outline\"></ion-icon>\n                    </ion-button>\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n        </ion-card-content>\n\n        <!-- Empty State -->\n        <ng-template #emptyState>\n          <ion-card-content>\n            <div class=\"empty-state\">\n              <ion-icon name=\"document-text-outline\" color=\"medium\"></ion-icon>\n              <h3>No Facility Supervisions</h3>\n              <p>No facility supervision records found.</p>\n            </div>\n          </ion-card-content>\n        </ng-template>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_facility-supervision-list_facility-supervision-list_module_ts.js.map