(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_distribution-create_distribution-create_module_ts"],{

/***/ 53267:
/*!*********************************************************************************!*\
  !*** ./src/app/pages/distribution-create/distribution-create-routing.module.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DistributionCreatePageRoutingModule: () => (/* binding */ DistributionCreatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _distribution_create_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./distribution-create.page */ 86773);




const routes = [{
  path: '',
  component: _distribution_create_page__WEBPACK_IMPORTED_MODULE_0__.DistributionCreatePage
}];
let DistributionCreatePageRoutingModule = class DistributionCreatePageRoutingModule {};
DistributionCreatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], DistributionCreatePageRoutingModule);


/***/ }),

/***/ 85362:
/*!*************************************************************************!*\
  !*** ./src/app/pages/distribution-create/distribution-create.module.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DistributionCreatePageModule: () => (/* binding */ DistributionCreatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _distribution_create_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./distribution-create-routing.module */ 53267);
/* harmony import */ var _distribution_create_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./distribution-create.page */ 86773);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);








let DistributionCreatePageModule = class DistributionCreatePageModule {};
DistributionCreatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _distribution_create_routing_module__WEBPACK_IMPORTED_MODULE_0__.DistributionCreatePageRoutingModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule],
  declarations: [_distribution_create_page__WEBPACK_IMPORTED_MODULE_1__.DistributionCreatePage]
})], DistributionCreatePageModule);


/***/ }),

/***/ 86773:
/*!***********************************************************************!*\
  !*** ./src/app/pages/distribution-create/distribution-create.page.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DistributionCreatePage: () => (/* binding */ DistributionCreatePage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _distribution_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./distribution-create.page.html?ngResource */ 43887);
/* harmony import */ var _distribution_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./distribution-create.page.scss?ngResource */ 56459);
/* harmony import */ var _distribution_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_distribution_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var src_app_services_distribution_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/distribution_api.service */ 51339);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);

var _DistributionCreatePage;



/* eslint-disable @typescript-eslint/naming-convention */





let DistributionCreatePage = (_DistributionCreatePage = class DistributionCreatePage {
  constructor(fb, api, activatedRoute, b, change, router) {
    this.fb = fb;
    this.api = api;
    this.activatedRoute = activatedRoute;
    this.b = b;
    this.change = change;
    this.router = router;
    this.beneficiaryTypeId = 1; // 1 for child, 2 for PLW
    this.availableSurveyForms = [];
    this.selectedSurveyForm = null;
    this.showSurveyItems = false;
    this.showSurveySelector = false;
    this.minDistributionDate = null;
    this.maxDistributionDate = null;
    this.surveyResponseId = null;
    this.visitNo = null;
    // Check for both child and PLW IDs
    const childId = this.activatedRoute.snapshot.paramMap.get('childId');
    const plwId = this.activatedRoute.snapshot.paramMap.get('plwId');
    if (childId) {
      this.beneficiaryId = childId;
      this.beneficiaryTypeId = 1;
    } else if (plwId) {
      this.beneficiaryId = plwId;
      this.beneficiaryTypeId = 2;
    }
    // Set today's date
    this.today = new Date().toISOString().split('T')[0];
    this.setupForm();
    if (this.beneficiaryId) {
      this.distributionForm.get('beneficiary_id').setValue(this.beneficiaryId);
      this.distributionForm.get('beneficiary_type_id').setValue(this.beneficiaryTypeId);
    }
  }
  ngOnInit() {
    this.load();
  }
  setupForm() {
    this.distributionForm = this.fb.group({
      beneficiary_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      beneficiary_type_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      date: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      items: this.fb.array([])
    });
  }
  get itemsFormArray() {
    return this.distributionForm.get('items');
  }
  createItemFormGroup(item = null) {
    return this.fb.group({
      supply_item_id: [(item === null || item === void 0 ? void 0 : item.supply_item_id) || '', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      quantity: [0, [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.min(0)]],
      supply_item_title: [(item === null || item === void 0 ? void 0 : item.supply_item_title) || ''],
      unit_title: [(item === null || item === void 0 ? void 0 : item.unit_title) || ''],
      required_quantity: [(item === null || item === void 0 ? void 0 : item.required_quantity) || 0],
      already_distributed: [(item === null || item === void 0 ? void 0 : item.already_distributed) || 0]
    });
  }
  addItem(item = null) {
    this.itemsFormArray.push(this.createItemFormGroup(item));
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        // Load for creating new distribution
        const response = yield _this.api.getDistributionPreqData(_this.beneficiaryId, _this.beneficiaryTypeId);
        if (response.success) {
          var _response$data$survey;
          _this.distributionPreqData = response.data;
          _this.beneficiary_info = response.data.beneficiary_info;
          // Handle survey forms with items
          if (((_response$data$survey = response.data.survey_forms) === null || _response$data$survey === void 0 ? void 0 : _response$data$survey.length) > 0) {
            _this.availableSurveyForms = response.data.survey_forms;
            // Auto-select if only one survey form
            if (_this.availableSurveyForms.length === 1) {
              _this.selectedSurveyForm = _this.availableSurveyForms[0];
              _this.loadItemsForSelectedSurvey();
            } else if (_this.availableSurveyForms.length > 1) {
              // Show survey selector for multiple surveys
              _this.showSurveySelector = true;
            }
          }
          _this.change.markForCheck();
        }
      } catch (error) {
        _this.b.toast('Failed to load prerequisite data');
      }
    })();
  }
  /**
   * Load items for the selected survey form
   */
  loadItemsForSelectedSurvey() {
    var _this$selectedSurveyF;
    if (!this.selectedSurveyForm) {
      this.showSurveyItems = false;
      this.itemsFormArray.clear();
      this.minDistributionDate = null;
      this.maxDistributionDate = null;
      this.surveyResponseId = null;
      this.visitNo = null;
      this.distributionForm.get('date').setValue('');
      this.change.markForCheck();
      return;
    }
    // Get date constraints and metadata from selected survey form
    this.minDistributionDate = this.selectedSurveyForm.min_distribution_date || null;
    this.maxDistributionDate = this.selectedSurveyForm.max_distribution_date || this.today;
    this.surveyResponseId = this.selectedSurveyForm.survey_response_id;
    this.visitNo = this.selectedSurveyForm.visit_no;
    // Set default date to min date if available, otherwise today
    const defaultDate = this.minDistributionDate || this.today;
    this.distributionForm.get('date').setValue(defaultDate);
    // Auto-fill items from selected survey form
    this.itemsFormArray.clear();
    if (((_this$selectedSurveyF = this.selectedSurveyForm.items) === null || _this$selectedSurveyF === void 0 ? void 0 : _this$selectedSurveyF.length) > 0) {
      this.selectedSurveyForm.items.forEach(item => this.addItem(item));
      this.showSurveyItems = true;
    } else {
      this.showSurveyItems = false;
    }
    this.change.markForCheck();
  }
  /**
   * Called when user selects a survey form from dropdown
   */
  onSurveyFormChange(event) {
    const surveyFormId = event.detail.value;
    this.selectedSurveyForm = this.availableSurveyForms.find(sf => sf.survey_form_id === surveyFormId);
    this.loadItemsForSelectedSurvey();
  }
  onSubmit() {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Check if survey selection is required but not selected
      if (_this2.showSurveySelector && !_this2.selectedSurveyForm) {
        _this2.b.toast('Please select an assessment/programme first');
        return;
      }
      // Only allow submission if we have survey items
      if (!_this2.showSurveyItems || _this2.itemsFormArray.length === 0) {
        _this2.b.toast('Please conduct an assessment first');
        return;
      }
      yield _this2.submitDistributionItems();
    })();
  }
  /**
   * Submit distribution items from survey
   */
  submitDistributionItems() {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this3.itemsFormArray.invalid) {
        _this3.b.toast('Please fill all required fields for all items');
        return;
      }
      try {
        // Filter out items with zero or null quantity
        const itemsToSubmit = _this3.itemsFormArray.value.filter(item => item.quantity && item.quantity > 0).map(item => ({
          survey_form_id: _this3.selectedSurveyForm.survey_form_id,
          survey_form_responses_id: _this3.surveyResponseId,
          visit_no: _this3.visitNo,
          supply_item_id: item.supply_item_id,
          quantity: item.quantity
        }));
        // Check if there are any items to distribute after filtering
        if (itemsToSubmit.length === 0) {
          _this3.b.toast('Please enter quantity for at least one item');
          return;
        }
        const payload = {
          beneficiary_id: _this3.distributionForm.value.beneficiary_id,
          beneficiary_type_id: _this3.distributionForm.value.beneficiary_type_id,
          date: _this3.distributionForm.value.date,
          items: itemsToSubmit
        };
        const result = yield _this3.api.distributionStore(payload);
        if (result.success) {
          _this3.b.toast(result.message || 'Distributions created successfully');
          _this3.navigateToDetailPage();
        } else {
          _this3.b.toast(result.message || 'Failed to create distributions');
        }
      } catch (error) {
        _this3.b.toast('Error creating distributions');
      }
    })();
  }
  /**
   * Navigate to appropriate detail page based on beneficiary type
   */
  navigateToDetailPage() {
    const detailRoute = this.beneficiaryTypeId === 1 ? '/child-detail' : '/woman-detail';
    this.router.navigate([detailRoute, this.beneficiaryId], {
      queryParams: {
        reload: true
      }
    });
  }
  getAgeInMonths(dateOfBirth) {
    if (!dateOfBirth) {
      return 'N/A';
    }
    const dob = new Date(dateOfBirth);
    const today = new Date();
    let years = today.getFullYear() - dob.getFullYear();
    let months = today.getMonth() - dob.getMonth();
    let days = today.getDate() - dob.getDate();
    if (days < 0) {
      months--;
      const lastDayOfPrevMonth = new Date(today.getFullYear(), today.getMonth(), 0).getDate();
      days += lastDayOfPrevMonth;
    }
    if (months < 0) {
      years--;
      months += 12;
    }
    const totalMonths = years * 12 + months;
    let result = '';
    if (totalMonths > 0) {
      result += `${totalMonths} Months`;
    }
    if (days > 0) {
      if (result.length > 0) {
        result += ' ';
      }
      result += `${days} days`;
    }
    return result || '0d';
  }
  isFieldInvalid(fieldName) {
    const field = this.distributionForm.get(fieldName);
    return field && field.invalid && (field.dirty || field.touched);
  }
  get beneficiaryLabel() {
    return this.beneficiaryTypeId === 1 ? 'Child' : 'Mother';
  }
  get detailRoute() {
    return this.beneficiaryTypeId === 1 ? '/child-detail' : '/woman-detail';
  }
  /**
   * Get the title of the currently selected survey form
   */
  getSelectedSurveyFormTitle() {
    var _this$selectedSurveyF2;
    return ((_this$selectedSurveyF2 = this.selectedSurveyForm) === null || _this$selectedSurveyF2 === void 0 ? void 0 : _this$selectedSurveyF2.survey_form_title) || '';
  }
  /**
   * Get distribution period information (date range and visit count)
   */
  getDistributionPeriodInfo() {
    if (!this.selectedSurveyForm) {
      return null;
    }
    return {
      lastDate: this.selectedSurveyForm.last_follow_up_date,
      nextDate: this.selectedSurveyForm.next_follow_up_date,
      visitCount: this.selectedSurveyForm.visit_count || 1,
      isFinalized: this.selectedSurveyForm.is_finalized || false
    };
  }
  /**
   * Fill the quantity field with the remaining quantity
   */
  fillRemainingQuantity(index) {
    var _itemControl$get, _itemControl$get2, _itemControl$get3;
    const itemControl = this.itemsFormArray.at(index);
    const requiredQuantity = ((_itemControl$get = itemControl.get('required_quantity')) === null || _itemControl$get === void 0 ? void 0 : _itemControl$get.value) || 0;
    const alreadyDistributed = ((_itemControl$get2 = itemControl.get('already_distributed')) === null || _itemControl$get2 === void 0 ? void 0 : _itemControl$get2.value) || 0;
    const remainingQuantity = requiredQuantity - alreadyDistributed;
    (_itemControl$get3 = itemControl.get('quantity')) === null || _itemControl$get3 === void 0 || _itemControl$get3.setValue(remainingQuantity);
    this.change.markForCheck();
  }
}, _DistributionCreatePage.ctorParameters = () => [{
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormBuilder
}, {
  type: src_app_services_distribution_api_service__WEBPACK_IMPORTED_MODULE_3__.DistributionAPIService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.ActivatedRoute
}, {
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_4__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectorRef
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.Router
}], _DistributionCreatePage);
DistributionCreatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-distribution-create',
  template: _distribution_create_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectionStrategy.OnPush,
  styles: [(_distribution_create_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], DistributionCreatePage);


/***/ }),

/***/ 51339:
/*!******************************************************!*\
  !*** ./src/app/services/distribution_api.service.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DistributionAPIService: () => (/* binding */ DistributionAPIService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 61318);

/* eslint-disable @typescript-eslint/naming-convention */




let DistributionAPIService = class DistributionAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_0__.APIBaseService {
  constructor() {
    super(...arguments);
    this.namespace = '/distribution';
  }
  getDistributionDetail(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteDistribution(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getDistributionPreqData(beneficiaryId, beneficiaryTypeId = 1) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}-create/${beneficiaryId}/${beneficiaryTypeId}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  distributionStore(body) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/store`;
    return this.http.post(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getDistributionEditPreq(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}/edit`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  distributionUpdate(body, id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.put(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getDistributionList(beneficiaryId, beneficiaryTypeId = 1) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}?beneficiary_id=${beneficiaryId}&beneficiary_type_id=${beneficiaryTypeId}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
};
DistributionAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], DistributionAPIService);


/***/ }),

/***/ 56459:
/*!************************************************************************************!*\
  !*** ./src/app/pages/distribution-create/distribution-create.page.scss?ngResource ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.distribution-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 20px 20px 16px 20px;
  margin-bottom: 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}

.section-title {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.distribution-form .form-section {
  margin-bottom: 32px;
}
.distribution-form .form-section:last-child {
  margin-bottom: 0;
}
.distribution-form .form-section.beneficiary-section {
  padding-bottom: 24px;
  border-bottom: 2px solid rgba(0, 0, 0, 0.05);
}
.distribution-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.distribution-form .section-subtitle ion-icon {
  font-size: 20px;
}
.distribution-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.distribution-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.distribution-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.distribution-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.distribution-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}

.child-info-card {
  margin: 16px 0;
}
.child-info-card .child-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.child-info-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.child-info-card .info-item:last-child {
  margin-bottom: 0;
}
.child-info-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.child-info-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.child-info-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.child-info-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.child-info-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

.empty-state {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 40px;
  text-align: center;
  background: linear-gradient(135deg, rgba(73, 144, 226, 0.03) 0%, rgba(109, 90, 230, 0.03) 100%);
  border-radius: 12px;
  border: 2px dashed rgba(73, 144, 226, 0.2);
  margin: 32px 0;
}
.empty-state ion-icon {
  font-size: 80px;
  margin-bottom: 20px;
  opacity: 0.5;
}
.empty-state h3 {
  font-size: 20px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin: 0 0 12px 0;
}
.empty-state p {
  font-size: 15px;
  color: var(--ion-color-medium);
  margin: 0;
  max-width: 400px;
  line-height: 1.6;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-dark);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime {
  --padding-start: 8px;
  --padding-end: 8px;
}

.unit-label {
  color: var(--ion-color-medium);
  font-size: 0.9em;
  font-weight: 500;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-primary), transparent);
  border-radius: 1px;
}

@media (min-width: 768px) {
  .distribution-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .submit-btn {
    min-width: 200px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
  .child-info-card {
    margin: 12px 0;
  }
  .child-info-card .profile-content {
    padding: 16px;
  }
  .child-info-card .content-grid ion-col {
    padding: 0 3px;
  }
  .child-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .child-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .child-info-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .child-info-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .child-info-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .child-info-card .item-content .value {
    font-size: 13px;
  }
}
@media (prefers-color-scheme: dark) {
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
  .child-card ion-card-header {
    --background: rgba(255, 255, 255, 0.05);
    border-bottom-color: rgba(255, 255, 255, 0.1);
  }
  .info-item {
    background: rgba(255, 255, 255, 0.03);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .info-item:hover {
    background: rgba(73, 144, 226, 0.08);
    border-color: rgba(73, 144, 226, 0.3);
  }
}
@media (prefers-reduced-motion: reduce) {
  * {
    transition: none !important;
    animation: none !important;
  }
}
@media (prefers-contrast: high) {
  .form-item {
    border-width: 2px;
  }
  .section-subtitle {
    border-bottom-width: 3px;
  }
  ion-label {
    font-weight: 600;
  }
}
.survey-items-section {
  margin: 20px 0;
}
.survey-items-section .survey-header {
  margin-bottom: 16px;
}
.survey-items-section .survey-header .survey-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  padding-bottom: 8px;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
  color: var(--ion-color-dark);
}
.survey-items-section .survey-header .survey-title ion-icon {
  font-size: 20px;
}

.distribution-period-info {
  margin: 16px 0;
}
.distribution-period-info .period-card {
  background: linear-gradient(135deg, rgba(73, 144, 226, 0.05) 0%, rgba(109, 90, 230, 0.05) 100%);
  border: 1px solid rgba(73, 144, 226, 0.15);
  border-radius: 12px;
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
  margin: 0;
}
.distribution-period-info .period-card ion-card-content {
  padding: 16px;
}
.distribution-period-info .period-card ion-grid {
  padding: 0;
}
.distribution-period-info .period-card .period-item {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 8px;
}
.distribution-period-info .period-card .period-item ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}
.distribution-period-info .period-card .period-item .period-content {
  display: flex;
  flex-direction: column;
  gap: 4px;
}
.distribution-period-info .period-card .period-item .period-content .period-label {
  font-size: 12px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
}
.distribution-period-info .period-card .period-item .period-content .period-value {
  font-size: 15px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.distribution-period-info .period-card .period-item .period-content .period-value ion-badge {
  font-size: 13px;
  padding: 6px 14px;
}

.table-container {
  overflow-x: auto;
  margin: 16px 0;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.distribution-table,
.measurements-table {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
  background: white;
}
.distribution-table thead,
.measurements-table thead {
  background: rgba(73, 144, 226, 0.08);
}
.distribution-table thead tr th,
.measurements-table thead tr th {
  padding: 12px 16px;
  text-align: left;
  font-weight: 600;
  color: var(--ion-color-dark);
  border-bottom: 2px solid rgba(73, 144, 226, 0.2);
  white-space: nowrap;
  font-size: 13px;
}
.distribution-table thead tr th.clickable-header,
.measurements-table thead tr th.clickable-header {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 6px;
}
.distribution-table thead tr th.clickable-header .click-hint,
.measurements-table thead tr th.clickable-header .click-hint {
  font-size: 16px;
  color: var(--ion-color-primary);
  animation: pulse-hint 2s ease-in-out infinite;
}
@keyframes pulse-hint {
  0%, 100% {
    opacity: 0.6;
    transform: scale(1);
  }
  50% {
    opacity: 1;
    transform: scale(1.1);
  }
}
.distribution-table tbody tr,
.measurements-table tbody tr {
  border-bottom: 1px solid rgba(0, 0, 0, 0.08);
  transition: background-color 0.2s ease;
}
.distribution-table tbody tr:hover,
.measurements-table tbody tr:hover {
  background-color: rgba(73, 144, 226, 0.03);
}
.distribution-table tbody tr:last-child,
.measurements-table tbody tr:last-child {
  border-bottom: none;
}
.distribution-table tbody tr td,
.measurements-table tbody tr td {
  padding: 12px 16px;
  vertical-align: middle;
  color: var(--ion-color-dark);
}
.distribution-table tbody tr td strong,
.measurements-table tbody tr td strong {
  color: var(--ion-color-dark);
  font-weight: 600;
}
.distribution-table tbody tr td small,
.measurements-table tbody tr td small {
  font-size: 12px;
}
.distribution-table tbody tr td.number-cell,
.measurements-table tbody tr td.number-cell {
  text-align: center;
  font-weight: 500;
}
.distribution-table tbody tr td.clickable-cell,
.measurements-table tbody tr td.clickable-cell {
  cursor: pointer;
  transition: background-color 0.2s ease;
}
.distribution-table tbody tr td.clickable-cell .clickable-badge-wrapper,
.measurements-table tbody tr td.clickable-cell .clickable-badge-wrapper {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 6px;
}
.distribution-table tbody tr td.clickable-cell .clickable-badge-wrapper .fill-icon,
.measurements-table tbody tr td.clickable-cell .clickable-badge-wrapper .fill-icon {
  font-size: 16px;
  color: var(--ion-color-success);
  opacity: 0.7;
  transition: all 0.2s ease;
}
.distribution-table tbody tr td.clickable-cell:hover,
.measurements-table tbody tr td.clickable-cell:hover {
  background-color: rgba(73, 144, 226, 0.1);
}
.distribution-table tbody tr td.clickable-cell:hover .clickable-badge-wrapper ion-badge,
.measurements-table tbody tr td.clickable-cell:hover .clickable-badge-wrapper ion-badge {
  transform: scale(1.05);
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
}
.distribution-table tbody tr td.clickable-cell:hover .clickable-badge-wrapper .fill-icon,
.measurements-table tbody tr td.clickable-cell:hover .clickable-badge-wrapper .fill-icon {
  opacity: 1;
  transform: translateX(2px);
  color: var(--ion-color-primary);
}
.distribution-table tbody tr td.clickable-cell ion-badge,
.measurements-table tbody tr td.clickable-cell ion-badge {
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.distribution-table tbody tr td.input-cell,
.measurements-table tbody tr td.input-cell {
  padding: 8px 16px;
}
.distribution-table tbody tr td.input-cell .quantity-input,
.measurements-table tbody tr td.input-cell .quantity-input {
  --background: rgba(73, 144, 226, 0.05);
  --padding-start: 12px;
  --padding-end: 12px;
  border: 1px solid rgba(73, 144, 226, 0.2);
  border-radius: 6px;
  font-weight: 500;
  min-height: 40px;
}
.distribution-table tbody tr td.input-cell .quantity-input.invalid-input,
.measurements-table tbody tr td.input-cell .quantity-input.invalid-input {
  --background: rgba(var(--ion-color-danger-rgb), 0.05);
  border-color: var(--ion-color-danger);
}
.distribution-table tbody tr td.input-cell .quantity-input:focus-within,
.measurements-table tbody tr td.input-cell .quantity-input:focus-within {
  --background: white;
  border-color: var(--ion-color-primary);
  box-shadow: 0 0 0 3px rgba(73, 144, 226, 0.1);
}
.distribution-table tbody tr td.actions-cell,
.measurements-table tbody tr td.actions-cell {
  text-align: center;
}
.distribution-table tbody tr td.actions-cell ion-button,
.measurements-table tbody tr td.actions-cell ion-button {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-badge {
  padding: 6px 12px;
  border-radius: 12px;
  font-weight: 600;
  font-size: 12px;
}

@media (max-width: 767px) {
  .distribution-table,
  .measurements-table {
    font-size: 12px;
  }
  .distribution-table thead tr th,
  .measurements-table thead tr th {
    padding: 8px 12px;
    font-size: 11px;
  }
  .distribution-table tbody tr td,
  .measurements-table tbody tr td {
    padding: 8px 12px;
  }
  .distribution-table tbody tr td.input-cell,
  .measurements-table tbody tr td.input-cell {
    padding: 6px 8px;
  }
  .distribution-table tbody tr td.input-cell .quantity-input,
  .measurements-table tbody tr td.input-cell .quantity-input {
    min-height: 36px;
    --padding-start: 8px;
    --padding-end: 8px;
  }
  .survey-items-section {
    margin: 16px 0;
  }
  .survey-items-section .survey-header .survey-title {
    font-size: 14px;
  }
  .survey-items-section .survey-header .survey-title ion-icon {
    font-size: 18px;
  }
  .distribution-period-info .period-card ion-card-content {
    padding: 12px;
  }
  .distribution-period-info .period-card .period-item {
    padding: 6px;
    gap: 10px;
  }
  .distribution-period-info .period-card .period-item ion-icon {
    font-size: 24px;
  }
  .distribution-period-info .period-card .period-item .period-content .period-label {
    font-size: 11px;
  }
  .distribution-period-info .period-card .period-item .period-content .period-value {
    font-size: 13px;
  }
  .distribution-period-info .period-card .period-item .period-content .period-value ion-badge {
    font-size: 11px;
    padding: 4px 10px;
  }
  ion-badge {
    padding: 4px 8px;
    font-size: 11px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/distribution-create/distribution-create.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,4BAAA;EACA,gBAAA;EACA,gDAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;EACA,cAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAUI;EACE,oBAAA;EACA,4CAAA;AARN;AAYE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AAVJ;AAYI;EACE,eAAA;AAVN;AAcE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAZJ;AAcI;EACE,gBAAA;EACA,4BAAA;AAZN;AAeI;EACE,eAAA;EACA,eAAA;AAbN;AAeM;EACE,8BAAA;AAbR;AAgBM;EACE,8BAAA;AAdR;;AAqBA;EACE,cAAA;AAlBF;AAoBE;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAlBJ;;AAsBA;EACE,aAAA;AAnBF;;AAsBA;EACE,UAAA;EACA,SAAA;AAnBF;AAqBE;EACE,SAAA;AAnBJ;AAsBE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AApBJ;AAsBI;EACE,eAAA;EACA,kBAAA;AApBN;AAuBI;EACE,gBAAA;EACA,iBAAA;AArBN;;AA0BA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAvBF;AAyBE;EACE,gBAAA;AAvBJ;AA0BE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAxBJ;AA2BE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AAzBJ;;AA6BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AA1BF;AA4BE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AA1BJ;AA6BE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AA3BJ;AA6BI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AA3BN;;AAiCA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AA9BF;AAgCE;EACE,gBAAA;AA9BJ;AAgCI;EACE,YAAA;EACA,mBAAA;AA9BN;;AAoCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAjCF;AAmCE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AAjCJ;AAoCE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AAlCJ;;AAuCA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;EACA,+FAAA;EACA,mBAAA;EACA,0CAAA;EACA,cAAA;AApCF;AAsCE;EACE,eAAA;EACA,mBAAA;EACA,YAAA;AApCJ;AAuCE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AArCJ;AAwCE;EACE,eAAA;EACA,8BAAA;EACA,SAAA;EACA,gBAAA;EACA,gBAAA;AAtCJ;;AA2CA;EACE,oBAAA;EACA,kBAAA;AAxCF;AA0CE;EACE,8BAAA;EACA,gBAAA;EACA,eAAA;AAxCJ;;AA4CA;EACE,oBAAA;EACA,kBAAA;AAzCF;;AA6CA;EACE,8BAAA;EACA,gBAAA;EACA,gBAAA;AA1CF;;AA8CA;EACE,qCAAA;AA3CF;AA6CE;EACE,8BAAA;AA3CJ;;AA+CA;EACE,sCAAA;AA5CF;;AAgDA;EACE,gBAAA;AA7CF;AA+CE;EACE,cAAA;EACA,oBAAA;AA7CJ;;AAkDA;EACE,kBAAA;AA/CF;AAiDE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AA/CJ;;AAoDA;EACE;IACE,gBAAA;EAjDF;EAoDA;IACE,gBAAA;EAlDF;EAqDA;IACE,eAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAuDA;IACE,eAAA;EArDF;EAuDE;IACE,eAAA;EArDJ;EAyDA;IACE,gBAAA;EAvDF;EAyDE;IACE,gBAAA;EAvDJ;EA2DA;IACE,kBAAA;EAzDF;EA2DE;IACE,WAAA;IACA,YAAA;EAzDJ;EA4DE;IACE,eAAA;EA1DJ;AACF;AA+DA;EACE;IACE,eAAA;EA7DF;EA+DE;IACE,eAAA;EA7DJ;EAiEA;IACE,eAAA;EA/DF;EAiEE;IACE,eAAA;EA/DJ;EAmEA;IACE,sBAAA;IACA,gBAAA;EAjEF;EAmEE;IACE,WAAA;IACA,eAAA;EAjEJ;EAqEA;IACE,kBAAA;EAnEF;EAqEE;IACE,eAAA;EAnEJ;EAuEA;IACE,cAAA;EArEF;EAuEE;IACE,aAAA;EArEJ;EAyEI;IACE,cAAA;EAvEN;EAyEM;IACE,eAAA;IACA,kBAAA;EAvER;EA0EM;IACE,gBAAA;IACA,iBAAA;EAxER;EA6EE;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EA3EJ;EA6EI;IACE,eAAA;IACA,WAAA;EA3EN;EAgFI;IACE,eAAA;IACA,qBAAA;EA9EN;EAiFI;IACE,eAAA;EA/EN;AACF;AAqFA;EACE;;IAEE,6BAAA;EAnFF;EAuFE;IACE,uCAAA;IACA,6CAAA;EArFJ;EAyFA;IACE,qCAAA;IACA,uCAAA;EAvFF;EAyFE;IACE,oCAAA;IACA,qCAAA;EAvFJ;AACF;AA4FA;EACE;IACE,2BAAA;IACA,0BAAA;EA1FF;AACF;AA8FA;EACE;IACE,iBAAA;EA5FF;EA+FA;IACE,wBAAA;EA7FF;EAgGA;IACE,gBAAA;EA9FF;AACF;AAkGA;EACE,cAAA;AAhGF;AAkGE;EACE,mBAAA;AAhGJ;AAkGI;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,mBAAA;EACA,gDAAA;EACA,4BAAA;AAhGN;AAkGM;EACE,eAAA;AAhGR;;AAuGA;EACE,cAAA;AApGF;AAsGE;EACE,+FAAA;EACA,0CAAA;EACA,mBAAA;EACA,yCAAA;EACA,SAAA;AApGJ;AAsGI;EACE,aAAA;AApGN;AAuGI;EACE,UAAA;AArGN;AAwGI;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,YAAA;AAtGN;AAwGM;EACE,eAAA;EACA,cAAA;AAtGR;AAyGM;EACE,aAAA;EACA,sBAAA;EACA,QAAA;AAvGR;AAyGQ;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;AAvGV;AA0GQ;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;AAxGV;AA0GU;EACE,eAAA;EACA,iBAAA;AAxGZ;;AAiHA;EACE,gBAAA;EACA,cAAA;EACA,kBAAA;EACA,qCAAA;AA9GF;;AAiHA;;EAEE,WAAA;EACA,yBAAA;EACA,eAAA;EACA,iBAAA;AA9GF;AAgHE;;EACE,oCAAA;AA7GJ;AAgHM;;EACE,kBAAA;EACA,gBAAA;EACA,gBAAA;EACA,4BAAA;EACA,gDAAA;EACA,mBAAA;EACA,eAAA;AA7GR;AA+GQ;;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,QAAA;AA5GV;AA8GU;;EACE,eAAA;EACA,+BAAA;EACA,6CAAA;AA3GZ;AAkHE;EACE;IACE,YAAA;IACA,mBAAA;EAhHJ;EAkHE;IACE,UAAA;IACA,qBAAA;EAhHJ;AACF;AAoHI;;EACE,4CAAA;EACA,sCAAA;AAjHN;AAmHM;;EACE,0CAAA;AAhHR;AAmHM;;EACE,mBAAA;AAhHR;AAmHM;;EACE,kBAAA;EACA,sBAAA;EACA,4BAAA;AAhHR;AAkHQ;;EACE,4BAAA;EACA,gBAAA;AA/GV;AAkHQ;;EACE,eAAA;AA/GV;AAkHQ;;EACE,kBAAA;EACA,gBAAA;AA/GV;AAkHQ;;EACE,eAAA;EACA,sCAAA;AA/GV;AAiHU;;EACE,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,QAAA;AA9GZ;AAgHY;;EACE,eAAA;EACA,+BAAA;EACA,YAAA;EACA,yBAAA;AA7Gd;AAiHU;;EACE,yCAAA;AA9GZ;AAiHc;;EACE,sBAAA;EACA,wCAAA;AA9GhB;AAiHc;;EACE,UAAA;EACA,0BAAA;EACA,+BAAA;AA9GhB;AAmHU;;EACE,qDAAA;AAhHZ;AAoHQ;;EACE,iBAAA;AAjHV;AAmHU;;EACE,sCAAA;EACA,qBAAA;EACA,mBAAA;EACA,yCAAA;EACA,kBAAA;EACA,gBAAA;EACA,gBAAA;AAhHZ;AAkHY;;EACE,qDAAA;EACA,qCAAA;AA/Gd;AAkHY;;EACE,mBAAA;EACA,sCAAA;EACA,6CAAA;AA/Gd;AAoHQ;;EACE,kBAAA;AAjHV;AAmHU;;EACE,oBAAA;EACA,kBAAA;AAhHZ;;AAwHA;EACE,iBAAA;EACA,mBAAA;EACA,gBAAA;EACA,eAAA;AArHF;;AAyHA;EACE;;IAEE,eAAA;EAtHF;EAwHE;;IACE,iBAAA;IACA,eAAA;EArHJ;EAwHE;;IACE,iBAAA;EArHJ;EAuHI;;IACE,gBAAA;EApHN;EAsHM;;IACE,gBAAA;IACA,oBAAA;IACA,kBAAA;EAnHR;EAyHA;IACE,cAAA;EAvHF;EAyHE;IACE,eAAA;EAvHJ;EAyHI;IACE,eAAA;EAvHN;EA8HI;IACE,aAAA;EA5HN;EA+HI;IACE,YAAA;IACA,SAAA;EA7HN;EA+HM;IACE,eAAA;EA7HR;EAiIQ;IACE,eAAA;EA/HV;EAkIQ;IACE,eAAA;EAhIV;EAkIU;IACE,eAAA;IACA,iBAAA;EAhIZ;EAwIA;IACE,gBAAA;IACA,eAAA;EAtIF;AACF","sourcesContent":["// Distribution Create Form Styles - Following Measurement Design Patterns\n\n// Container styling\n.distribution-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header (inside card - matching child-detail format)\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 20px 20px 16px 20px;\n  margin-bottom: 0;\n  border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// Form styling\n.distribution-form {\n  .form-section {\n    margin-bottom: 32px;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n\n    &.beneficiary-section {\n      padding-bottom: 24px;\n      border-bottom: 2px solid rgba(0, 0, 0, 0.05);\n    }\n  }\n\n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n\n    ion-icon {\n      font-size: 20px;\n    }\n  }\n\n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n\n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n\n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n\n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n  }\n}\n\n// Child Information Card styling\n.child-info-card {\n  margin: 16px 0;\n\n  .child-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.child-info-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n  }\n}\n\n.child-info-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n\n  .submit-btn {\n    min-width: 180px;\n\n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n\n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Empty State Styling (matching child-detail format)\n.empty-state {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 40px;\n  text-align: center;\n  background: linear-gradient(135deg, rgba(73, 144, 226, 0.03) 0%, rgba(109, 90, 230, 0.03) 100%);\n  border-radius: 12px;\n  border: 2px dashed rgba(73, 144, 226, 0.2);\n  margin: 32px 0;\n\n  ion-icon {\n    font-size: 80px;\n    margin-bottom: 20px;\n    opacity: 0.5;\n  }\n\n  h3 {\n    font-size: 20px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    margin: 0 0 12px 0;\n  }\n\n  p {\n    font-size: 15px;\n    color: var(--ion-color-medium);\n    margin: 0;\n    max-width: 400px;\n    line-height: 1.6;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n\n  &[readonly] {\n    --color: var(--ion-color-dark);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Unit label styling\n.unit-label {\n  color: var(--ion-color-medium);\n  font-size: 0.9em;\n  font-weight: 500;\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n\n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n\n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Enhanced visual indicators for headers\n.section-header .section-title {\n  position: relative;\n\n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-primary), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .distribution-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n\n  .section-title {\n    font-size: 24px;\n\n    ion-icon {\n      font-size: 28px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .form-actions {\n    margin-top: 32px;\n\n    .submit-btn {\n      min-width: 200px;\n    }\n  }\n\n  .loading-container {\n    padding: 80px 40px;\n\n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n\n    p {\n      font-size: 16px;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .section-subtitle {\n    font-size: 14px;\n\n    ion-icon {\n      font-size: 18px;\n    }\n  }\n\n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n\n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n\n  .loading-container {\n    padding: 40px 16px;\n\n    p {\n      font-size: 12px;\n    }\n  }\n\n  .child-info-card {\n    margin: 12px 0;\n\n    .profile-content {\n      padding: 16px;\n    }\n\n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n\n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n\n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n\n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n\n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n\n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n\n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n\n  .child-card {\n    ion-card-header {\n      --background: rgba(255, 255, 255, 0.05);\n      border-bottom-color: rgba(255, 255, 255, 0.1);\n    }\n  }\n\n  .info-item {\n    background: rgba(255, 255, 255, 0.03);\n    border-color: rgba(255, 255, 255, 0.08);\n\n    &:hover {\n      background: rgba(73, 144, 226, 0.08);\n      border-color: rgba(73, 144, 226, 0.3);\n    }\n  }\n}\n\n// Accessibility improvements\n@media (prefers-reduced-motion: reduce) {\n  * {\n    transition: none !important;\n    animation: none !important;\n  }\n}\n\n// High contrast mode\n@media (prefers-contrast: high) {\n  .form-item {\n    border-width: 2px;\n  }\n\n  .section-subtitle {\n    border-bottom-width: 3px;\n  }\n\n  ion-label {\n    font-weight: 600;\n  }\n}\n\n// Survey Items Section Styling\n.survey-items-section {\n  margin: 20px 0;\n\n  .survey-header {\n    margin-bottom: 16px;\n\n    .survey-title {\n      display: flex;\n      align-items: center;\n      gap: 8px;\n      font-size: 16px;\n      font-weight: 600;\n      margin: 0 0 16px 0;\n      padding-bottom: 8px;\n      border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n      color: var(--ion-color-dark);\n\n      ion-icon {\n        font-size: 20px;\n      }\n    }\n  }\n}\n\n// Distribution Period Info Card\n.distribution-period-info {\n  margin: 16px 0;\n\n  .period-card {\n    background: linear-gradient(135deg, rgba(73, 144, 226, 0.05) 0%, rgba(109, 90, 230, 0.05) 100%);\n    border: 1px solid rgba(73, 144, 226, 0.15);\n    border-radius: 12px;\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);\n    margin: 0;\n\n    ion-card-content {\n      padding: 16px;\n    }\n\n    ion-grid {\n      padding: 0;\n    }\n\n    .period-item {\n      display: flex;\n      align-items: center;\n      gap: 12px;\n      padding: 8px;\n\n      ion-icon {\n        font-size: 28px;\n        flex-shrink: 0;\n      }\n\n      .period-content {\n        display: flex;\n        flex-direction: column;\n        gap: 4px;\n\n        .period-label {\n          font-size: 12px;\n          font-weight: 600;\n          color: var(--ion-color-medium);\n          text-transform: uppercase;\n          letter-spacing: 0.5px;\n        }\n\n        .period-value {\n          font-size: 15px;\n          font-weight: 600;\n          color: var(--ion-color-dark);\n\n          ion-badge {\n            font-size: 13px;\n            padding: 6px 14px;\n          }\n        }\n      }\n    }\n  }\n}\n\n// Table Container and Styling (matching child-detail format)\n.table-container {\n  overflow-x: auto;\n  margin: 16px 0;\n  border-radius: 8px;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n}\n\n.distribution-table,\n.measurements-table {\n  width: 100%;\n  border-collapse: collapse;\n  font-size: 14px;\n  background: white;\n\n  thead {\n    background: rgba(73, 144, 226, 0.08);\n\n    tr {\n      th {\n        padding: 12px 16px;\n        text-align: left;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n        border-bottom: 2px solid rgba(73, 144, 226, 0.2);\n        white-space: nowrap;\n        font-size: 13px;\n\n        &.clickable-header {\n          display: flex;\n          align-items: center;\n          justify-content: center;\n          gap: 6px;\n\n          .click-hint {\n            font-size: 16px;\n            color: var(--ion-color-primary);\n            animation: pulse-hint 2s ease-in-out infinite;\n          }\n        }\n      }\n    }\n  }\n\n  @keyframes pulse-hint {\n    0%, 100% {\n      opacity: 0.6;\n      transform: scale(1);\n    }\n    50% {\n      opacity: 1;\n      transform: scale(1.1);\n    }\n  }\n\n  tbody {\n    tr {\n      border-bottom: 1px solid rgba(0, 0, 0, 0.08);\n      transition: background-color 0.2s ease;\n\n      &:hover {\n        background-color: rgba(73, 144, 226, 0.03);\n      }\n\n      &:last-child {\n        border-bottom: none;\n      }\n\n      td {\n        padding: 12px 16px;\n        vertical-align: middle;\n        color: var(--ion-color-dark);\n\n        strong {\n          color: var(--ion-color-dark);\n          font-weight: 600;\n        }\n\n        small {\n          font-size: 12px;\n        }\n\n        &.number-cell {\n          text-align: center;\n          font-weight: 500;\n        }\n\n        &.clickable-cell {\n          cursor: pointer;\n          transition: background-color 0.2s ease;\n\n          .clickable-badge-wrapper {\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            gap: 6px;\n\n            .fill-icon {\n              font-size: 16px;\n              color: var(--ion-color-success);\n              opacity: 0.7;\n              transition: all 0.2s ease;\n            }\n          }\n\n          &:hover {\n            background-color: rgba(73, 144, 226, 0.1);\n\n            .clickable-badge-wrapper {\n              ion-badge {\n                transform: scale(1.05);\n                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);\n              }\n\n              .fill-icon {\n                opacity: 1;\n                transform: translateX(2px);\n                color: var(--ion-color-primary);\n              }\n            }\n          }\n\n          ion-badge {\n            transition: transform 0.2s ease, box-shadow 0.2s ease;\n          }\n        }\n\n        &.input-cell {\n          padding: 8px 16px;\n\n          .quantity-input {\n            --background: rgba(73, 144, 226, 0.05);\n            --padding-start: 12px;\n            --padding-end: 12px;\n            border: 1px solid rgba(73, 144, 226, 0.2);\n            border-radius: 6px;\n            font-weight: 500;\n            min-height: 40px;\n\n            &.invalid-input {\n              --background: rgba(var(--ion-color-danger-rgb), 0.05);\n              border-color: var(--ion-color-danger);\n            }\n\n            &:focus-within {\n              --background: white;\n              border-color: var(--ion-color-primary);\n              box-shadow: 0 0 0 3px rgba(73, 144, 226, 0.1);\n            }\n          }\n        }\n\n        &.actions-cell {\n          text-align: center;\n\n          ion-button {\n            --padding-start: 8px;\n            --padding-end: 8px;\n          }\n        }\n      }\n    }\n  }\n}\n\nion-badge {\n  padding: 6px 12px;\n  border-radius: 12px;\n  font-weight: 600;\n  font-size: 12px;\n}\n\n// Responsive adjustments for survey items and tables\n@media (max-width: 767px) {\n  .distribution-table,\n  .measurements-table {\n    font-size: 12px;\n\n    thead tr th {\n      padding: 8px 12px;\n      font-size: 11px;\n    }\n\n    tbody tr td {\n      padding: 8px 12px;\n\n      &.input-cell {\n        padding: 6px 8px;\n\n        .quantity-input {\n          min-height: 36px;\n          --padding-start: 8px;\n          --padding-end: 8px;\n        }\n      }\n    }\n  }\n\n  .survey-items-section {\n    margin: 16px 0;\n\n    .survey-header .survey-title {\n      font-size: 14px;\n\n      ion-icon {\n        font-size: 18px;\n      }\n    }\n  }\n\n  .distribution-period-info {\n    .period-card {\n      ion-card-content {\n        padding: 12px;\n      }\n\n      .period-item {\n        padding: 6px;\n        gap: 10px;\n\n        ion-icon {\n          font-size: 24px;\n        }\n\n        .period-content {\n          .period-label {\n            font-size: 11px;\n          }\n\n          .period-value {\n            font-size: 13px;\n\n            ion-badge {\n              font-size: 11px;\n              padding: 4px 10px;\n            }\n          }\n        }\n      }\n    }\n  }\n\n  ion-badge {\n    padding: 4px 8px;\n    font-size: 11px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 43887:
/*!************************************************************************************!*\
  !*** ./src/app/pages/distribution-create/distribution-create.page.html?ngResource ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button [defaultHref]=\"detailRoute + '/' + beneficiaryId\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>Add Distribution</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"distributionPreqData && beneficiary_info; else loading\" class=\"distribution-container\">\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <div class=\"section-header\">\n          <h2 class=\"section-title\">\n            <ion-icon name=\"cube-outline\" color=\"secondary\"></ion-icon>\n            Add New Distribution\n          </h2>\n        </div>\n        <ion-card-content>\n          <form [formGroup]=\"distributionForm\" (ngSubmit)=\"onSubmit()\" class=\"distribution-form\">\n\n            <!-- Beneficiary Information Section -->\n            <div class=\"form-section beneficiary-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                {{ beneficiaryLabel }} Information\n              </h3>\n\n              <!-- Beneficiary Information Card -->\n              <div class=\"child-info-card\">\n                <ion-card class=\"child-card\">\n                  <div class=\"profile-content\">\n                    <ion-grid class=\"content-grid\">\n                      <ion-row *ngIf=\"beneficiaryTypeId === 1\">\n                        <!-- Child Information - Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Child Name</span>\n                              <span class=\"value\">{{ beneficiary_info?.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">FCN</span>\n                              <span class=\"value\">{{ beneficiary_info?.fcn || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Progress ID</span>\n                              <span class=\"value\">{{ beneficiary_info?.progress_id || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Date of Birth</span>\n                              <span class=\"value\">{{ beneficiary_info?.date_of_birth || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- Child Information - Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"male-female-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Gender</span>\n                              <span class=\"value\">{{ beneficiary_info?.gender || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"hourglass-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Age</span>\n                              <span class=\"value\">{{ getAgeInMonths(beneficiary_info?.date_of_birth) }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"woman-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Mother</span>\n                              <span class=\"value\">{{ beneficiary_info?.mother || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Father</span>\n                              <span class=\"value\">{{ beneficiary_info?.father || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n\n                      <ion-row *ngIf=\"beneficiaryTypeId === 2\">\n                        <!-- PLW Information - Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Mother Name</span>\n                              <span class=\"value\">{{ beneficiary_info?.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"id-card-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">FCN</span>\n                              <span class=\"value\">{{ beneficiary_info?.fcn || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Progress ID</span>\n                              <span class=\"value\">{{ beneficiary_info?.progress_id || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"call-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Phone</span>\n                              <span class=\"value\">{{ beneficiary_info?.phone || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- PLW Information - Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Husband</span>\n                              <span class=\"value\">{{ beneficiary_info?.husband || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"calendar-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Date of Birth</span>\n                              <span class=\"value\">{{ beneficiary_info?.date_of_birth || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"card-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">MOHA ID</span>\n                              <span class=\"value\">{{ beneficiary_info?.moha_id || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"document-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">MNR No</span>\n                              <span class=\"value\">{{ beneficiary_info?.mnr_no || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n                    </ion-grid>\n                  </div>\n                </ion-card>\n              </div>\n            </div>\n\n            <!-- Distribution Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"cube-outline\" color=\"primary\"></ion-icon>\n                Distribution\n              </h3>\n\n              <!-- Survey Form Selector (shown when multiple surveys exist) -->\n              <ion-item class=\"form-item\" *ngIf=\"showSurveySelector\">\n                <ion-icon slot=\"start\" name=\"document-text-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">Select Assessment/Programme *</ion-label>\n                <ion-select (ionChange)=\"onSurveyFormChange($event)\"\n                            placeholder=\"Choose assessment to distribute items for\"\n                            interface=\"action-sheet\">\n                  <ion-select-option *ngFor=\"let survey of availableSurveyForms\" [value]=\"survey.survey_form_id\">\n                    {{ survey.survey_form_title }}\n                  </ion-select-option>\n                </ion-select>\n                <ion-note slot=\"helper\">\n                  Multiple assessments found. Please select one to view distribution items.\n                </ion-note>\n              </ion-item>\n\n              <!-- No Items to Distribute Message -->\n              <div *ngIf=\"!showSurveySelector && (!showSurveyItems || itemsFormArray.length === 0)\" class=\"empty-state\">\n                <ion-icon name=\"cube-outline\" color=\"medium\"></ion-icon>\n                <h3>Nothing to Distribute</h3>\n                <p>There are no items available for distribution at this time. Please conduct an assessment to generate distribution items.</p>\n              </div>\n\n              <!-- Survey Items Section (if available from today's assessment) -->\n              <div *ngIf=\"showSurveyItems && itemsFormArray.length > 0\" class=\"survey-items-section\">\n                <div class=\"survey-header\">\n                  <h4 class=\"survey-title\">\n                    <ion-icon name=\"document-text-outline\" color=\"success\"></ion-icon>\n                    Items from Assessment\n                    <span *ngIf=\"selectedSurveyForm\">: {{ getSelectedSurveyFormTitle() }}</span>\n                  </h4>\n\n                  <!-- Distribution Period Info -->\n                  <div class=\"distribution-period-info\" *ngIf=\"getDistributionPeriodInfo() as periodInfo\">\n                    <ion-card class=\"period-card\">\n                      <ion-card-content>\n                        <ion-grid>\n                          <ion-row class=\"ion-align-items-center\">\n                            <ion-col size=\"12\" size-md=\"6\">\n                              <div class=\"period-item\">\n                                <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                                <div class=\"period-content\">\n                                  <span class=\"period-label\">Distribution Period</span>\n                                  <span class=\"period-value\" *ngIf=\"periodInfo.lastDate && periodInfo.nextDate\">\n                                    {{ periodInfo.lastDate | date: 'dd MMM yyyy' }} - {{ periodInfo.nextDate | date: 'dd MMM yyyy' }}\n                                  </span>\n                                  <span class=\"period-value\" *ngIf=\"periodInfo.isFinalized\">\n                                    One-time distribution\n                                  </span>\n                                </div>\n                              </div>\n                            </ion-col>\n                            <ion-col size=\"12\" size-md=\"6\">\n                              <div class=\"period-item\">\n                                <ion-icon name=\"repeat-outline\" color=\"secondary\"></ion-icon>\n                                <div class=\"period-content\">\n                                  <span class=\"period-label\">Follow-up Visits</span>\n                                  <span class=\"period-value\">\n                                    <ion-badge color=\"secondary\">{{ periodInfo.visitCount }} {{ periodInfo.visitCount === 1 ? 'visit' : 'visits' }}</ion-badge>\n                                  </span>\n                                </div>\n                              </div>\n                            </ion-col>\n                          </ion-row>\n                        </ion-grid>\n                      </ion-card-content>\n                    </ion-card>\n                  </div>\n\n                  <!-- Distribution Date (shown after program selection) -->\n                  <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('date')\">\n                    <ion-icon slot=\"start\" name=\"calendar\" [color]=\"isFieldInvalid('date') ? 'danger' : 'primary'\"></ion-icon>\n                    <ion-label position=\"stacked\">Distribution Date *</ion-label>\n                    <ion-input formControlName=\"date\" type=\"date\" [min]=\"minDistributionDate\" [max]=\"maxDistributionDate\"></ion-input>\n                    <ion-note slot=\"helper\" *ngIf=\"minDistributionDate && maxDistributionDate\">\n                      Select date between {{ minDistributionDate }} and {{ maxDistributionDate }}\n                    </ion-note>\n                    <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('date')\">Date is required</ion-note>\n                  </ion-item>\n\n                  <ion-text color=\"medium\">\n                    <small>Click on the remaining quantity to auto-fill the distribution amount</small>\n                  </ion-text>\n                </div>\n\n                <div class=\"table-container\" formArrayName=\"items\">\n                  <table class=\"distribution-table\">\n                    <thead>\n                      <tr>\n                        <th>Item Name</th>\n                        <th>Required</th>\n                        <th>Distributed</th>\n                        <th class=\"clickable-header\">\n                          Remaining\n                          <ion-icon name=\"hand-left-outline\" class=\"click-hint\"></ion-icon>\n                        </th>\n                        <th>Quantity to Distribute</th>\n                      </tr>\n                    </thead>\n                    <tbody>\n                      <tr *ngFor=\"let item of itemsFormArray.controls; let i = index\" [formGroupName]=\"i\">\n                        <td>\n                          <strong>{{ item.get('supply_item_title')?.value }}</strong>\n                          <br>\n                          <ion-text color=\"medium\">\n                            <small *ngIf=\"item.get('unit_title')?.value\">({{ item.get('unit_title')?.value }})</small>\n                          </ion-text>\n                        </td>\n                        <td class=\"number-cell\">\n                          <ion-badge color=\"primary\" *ngIf=\"item.get('required_quantity')?.value > 0\">\n                            {{ item.get('required_quantity')?.value }}\n                          </ion-badge>\n                          <span *ngIf=\"!item.get('required_quantity')?.value || item.get('required_quantity')?.value === 0\">-</span>\n                        </td>\n                        <td class=\"number-cell\">\n                          <ion-badge color=\"warning\" *ngIf=\"item.get('already_distributed')?.value > 0\">\n                            {{ item.get('already_distributed')?.value }}\n                          </ion-badge>\n                          <span *ngIf=\"!item.get('already_distributed')?.value || item.get('already_distributed')?.value === 0\">-</span>\n                        </td>\n                        <td class=\"number-cell\"\n                            [class.clickable-cell]=\"(item.get('required_quantity')?.value - item.get('already_distributed')?.value) > 0\"\n                            (click)=\"(item.get('required_quantity')?.value - item.get('already_distributed')?.value) > 0 && fillRemainingQuantity(i)\">\n                          <div class=\"clickable-badge-wrapper\">\n                            <ion-badge [color]=\"(item.get('required_quantity')?.value - item.get('already_distributed')?.value) > 0 ? 'success' : 'medium'\">\n                              {{ item.get('required_quantity')?.value - item.get('already_distributed')?.value }}\n                            </ion-badge>\n                            <ion-icon *ngIf=\"(item.get('required_quantity')?.value - item.get('already_distributed')?.value) > 0\"\n                                      name=\"arrow-forward-outline\"\n                                      class=\"fill-icon\"></ion-icon>\n                          </div>\n                        </td>\n                        <td class=\"input-cell\">\n                          <ion-input\n                            formControlName=\"quantity\"\n                            type=\"number\"\n                            step=\"0.01\"\n                            min=\"0\"\n                            [max]=\"item.get('required_quantity')?.value - item.get('already_distributed')?.value\"\n                            placeholder=\"0\"\n                            class=\"quantity-input\"\n                            [class.invalid-input]=\"item.get('quantity')?.invalid && item.get('quantity')?.touched\">\n                          </ion-input>\n                          <ion-text color=\"danger\" *ngIf=\"item.get('quantity')?.invalid && item.get('quantity')?.touched\">\n                            <small>Required</small>\n                          </ion-text>\n                        </td>\n                      </tr>\n                    </tbody>\n                  </table>\n                </div>\n              </div>\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\" *ngIf=\"showSurveyItems && itemsFormArray.length > 0\">\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\"\n                [disabled]=\"itemsFormArray.invalid || itemsFormArray.length === 0\">\n                <ion-icon name=\"save-outline\" slot=\"start\"></ion-icon>\n                {{ itemsFormArray.length > 1 ? 'Save Distributions' : 'Save Distribution' }}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"distribution-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading distribution form data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_distribution-create_distribution-create_module_ts.js.map