(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_child-add-edit_child-add-edit_module_ts"],{

/***/ 53431:
/*!***********************************************************************!*\
  !*** ./src/app/pages/child-add-edit/child-add-edit-routing.module.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddChildrenPageRoutingModule: () => (/* binding */ AddChildrenPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _child_add_edit_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./child-add-edit.page */ 59257);




const routes = [{
  path: '',
  component: _child_add_edit_page__WEBPACK_IMPORTED_MODULE_0__.ChildAddEditPage
}, {
  path: 'edit/:id',
  component: _child_add_edit_page__WEBPACK_IMPORTED_MODULE_0__.ChildAddEditPage
}];
let AddChildrenPageRoutingModule = class AddChildrenPageRoutingModule {};
AddChildrenPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AddChildrenPageRoutingModule);


/***/ }),

/***/ 63974:
/*!***************************************************************!*\
  !*** ./src/app/pages/child-add-edit/child-add-edit.module.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddChildrenPageModule: () => (/* binding */ AddChildrenPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _child_add_edit_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./child-add-edit-routing.module */ 53431);
/* harmony import */ var _child_add_edit_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./child-add-edit.page */ 59257);
/* harmony import */ var _components_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/shared.module */ 47774);








let AddChildrenPageModule = class AddChildrenPageModule {};
AddChildrenPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _components_shared_module__WEBPACK_IMPORTED_MODULE_2__.SharedModule, _child_add_edit_routing_module__WEBPACK_IMPORTED_MODULE_0__.AddChildrenPageRoutingModule],
  declarations: [_child_add_edit_page__WEBPACK_IMPORTED_MODULE_1__.ChildAddEditPage]
})], AddChildrenPageModule);


/***/ }),

/***/ 59257:
/*!*************************************************************!*\
  !*** ./src/app/pages/child-add-edit/child-add-edit.page.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChildAddEditPage: () => (/* binding */ ChildAddEditPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _child_add_edit_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./child-add-edit.page.html?ngResource */ 49867);
/* harmony import */ var _child_add_edit_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./child-add-edit.page.scss?ngResource */ 22295);
/* harmony import */ var _child_add_edit_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_child_add_edit_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/baseHelper */ 76434);
/* harmony import */ var _services_child_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/child_api.service */ 57571);
/* harmony import */ var _util_utility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/util/utility */ 89999);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 95072);

var _ChildAddEditPage;




/* eslint-disable @typescript-eslint/naming-convention */







let ChildAddEditPage = (_ChildAddEditPage = class ChildAddEditPage {
  constructor(fb, api, b, change, router, activatedRoute) {
    this.fb = fb;
    this.api = api;
    this.b = b;
    this.change = change;
    this.router = router;
    this.activatedRoute = activatedRoute;
    this.today = new Date().toISOString().split('T')[0];
    this.subBlocks = [];
    this.blockMajhis = [];
    this.subBlockMajhis = [];
    this.mothers = [];
    // Edit mode properties
    this.isEditMode = false;
    this.childDataLoaded = false;
    this.regDataLoaded = false;
    // Mother search data
    this.motherInfo = null;
    this.mothersFound = [];
    this.selectedMotherId = null;
    this.showMotherDropdown = false;
    this.fcnSearchLoading = false;
    this.fcnSearchAttempted = false;
    this.noMotherFound = false;
    //construction work
    this.setUpForm();
    if (!this.isEditMode) {
      var _this$b$getCurrentUse;
      this.registerFrom.get('inf_id').setValue((_this$b$getCurrentUse = this.b.getCurrentUser()) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.user) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.profile) === null || _this$b$getCurrentUse === void 0 || (_this$b$getCurrentUse = _this$b$getCurrentUse.default_inf) === null || _this$b$getCurrentUse === void 0 ? void 0 : _this$b$getCurrentUse.id);
    }
  }
  ngOnInit() {
    this.activatedRoute.paramMap.subscribe(paramMap => {
      const id = paramMap.get('id');
      const currentUrl = this.router.url;
      if (id && (currentUrl.includes('child-edit') || currentUrl.includes('/edit/'))) {
        this.isEditMode = true;
        this.childId = id;
        this.loadEditData(id);
      } else {
        this.isEditMode = false;
        this.childDataLoaded = true;
        this.load();
      }
    });
  }
  setUpForm() {
    this.registerFrom = this.fb.group({
      fcn: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      progress_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.idPattern)]],
      date_of_birth: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.datePattern)]],
      birth_weight: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(/^\d+(\.\d{1,2})?$/)]],
      age: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberPattern)]],
      gender: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // mnr_no: ['', [Validators.nullValidator, Validators.pattern(idPattern)]],
      // moha_id: ['', [Validators.nullValidator, Validators.pattern(idPattern)]],
      // scope_no: ['', [Validators.nullValidator, Validators.pattern(idPattern)]],
      mother: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      father: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.requiredPattern)]],
      plw_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      inf_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      block_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      sub_block_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      majhi_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]],
      sub_block_majhi_id: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.nullValidator, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.pattern(_util_utility__WEBPACK_IMPORTED_MODULE_5__.numberIdPattern)]]
      // hh_no: ['', [Validators.nullValidator, Validators.pattern(requiredPattern)]],
    });
    const progressIdControl = this.registerFrom.get('progress_id');
    progressIdControl.valueChanges.subscribe(value => {
      if (value) {
        progressIdControl.setValue(value.toUpperCase(), {
          emitEvent: false
        });
      }
    });
    const dobControl = this.registerFrom.get('date_of_birth');
    const ageControl = this.registerFrom.get('age');
    let isUpdatingFromAge = false;
    dobControl === null || dobControl === void 0 || dobControl.valueChanges.subscribe(dob => {
      if (isUpdatingFromAge) return;
      if (dob) {
        const birthDate = new Date(dob);
        const today = new Date();
        let months = (today.getFullYear() - birthDate.getFullYear()) * 12;
        months += today.getMonth() - birthDate.getMonth();
        if (today.getDate() < birthDate.getDate()) {
          months -= 1;
        }
        months = Math.max(0, months);
        ageControl === null || ageControl === void 0 || ageControl.setValue(months.toString());
      } else {
        ageControl === null || ageControl === void 0 || ageControl.setValue('');
      }
    });
  }
  load() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.beneficiaryRegPreqData = (yield _this.api.childRegistrationData()).data;
      _this.regDataLoaded = true;
      _this.change.markForCheck();
    })();
  }
  loadEditData(id) {
    var _this2 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const response = yield _this2.api.getChild(id);
        const child = response.data;
        // Format date for form
        let formattedDob = '';
        if (child.date_of_birth) {
          formattedDob = new Date(child.date_of_birth).toISOString().split('T')[0];
        }
        // Patch form with child data
        const formData = {
          name: child.name,
          mother: child.mother,
          father: child.father,
          other_caregiver: child.other_caregiver,
          caregiver_relation: child.caregiver_relation,
          date_of_birth: formattedDob,
          birth_weight: child.birth_weight,
          gender: child.gender,
          phone: child.phone,
          fcn: child.fcn,
          progress_id: child.progress_id,
          scope_no: child.scope_no,
          woman_id: child.woman_id,
          mnr_no: child.mnr_no,
          moha_id: child.moha_id
        };
        _this2.registerFrom.patchValue(formData);
        // Trigger age calculation if date of birth is present
        if (formattedDob) {
          _this2.calculateAgeFromDob(formattedDob);
        }
        // Handle location data from current_location
        const locationInfo = child.current_location;
        if (locationInfo) {
          const locationData = {
            block_id: locationInfo.block_id,
            sub_block_id: locationInfo.sub_block_id,
            sub_block_majhi_id: locationInfo.sub_block_majhi_id,
            hh_no: locationInfo.hh_no,
            inf_id: locationInfo.inf_id,
            majhi_id: locationInfo.majhi_id
          };
          _this2.registerFrom.patchValue(locationData);
        }
        _this2.childDataLoaded = true;
        _this2.change.markForCheck();
        // Automatically trigger FCN search in edit mode if FCN exists
        if (child.fcn) {
          yield _this2.searchChildrenByFcn();
          // If mother data exists from API response, auto-select the correct mother
          if (child.my_mother && child.plw_id) {
            // Find the correct mother from search results using plw_id
            const correctMother = _this2.mothersFound.find(mother => mother.id === child.plw_id);
            if (correctMother) {
              _this2.motherInfo = correctMother;
              _this2.selectedMotherId = child.plw_id;
              _this2.showMotherDropdown = false;
            } else {
              // Fallback to child.my_mother if not found in search results
              _this2.motherInfo = child.my_mother;
              _this2.selectedMotherId = child.plw_id;
              _this2.showMotherDropdown = false;
            }
            _this2.fcnSearchAttempted = true;
            _this2.noMotherFound = false;
            // Auto-fill mother data using the selected mother info
            _this2.autoFillMotherData(_this2.motherInfo);
            _this2.change.markForCheck();
          }
        }
      } catch (error) {
        _this2.b.errorToast('Error loading child data');
      }
    })();
  }
  submit(formGroup) {
    var _this3 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Mark all fields as touched to show validation errors
      _this3.markFormGroupTouched(formGroup);
      // Comprehensive validation with detailed error messages
      const validationErrors = _this3.validateFormFields(formGroup);
      if (validationErrors.length > 0) {
        // Show the first validation error
        _this3.b.errorToast(validationErrors[0]);
        return;
      }
      if (formGroup.valid) {
        if (_this3.isEditMode) {
          const result = yield _this3.api.updateChild(formGroup.value, _this3.childId);
          yield _this3.b.responseToast(result);
          if (result.success) {
            _this3.b.navigateWithParam(_this3.b.routesConfig.childList, {
              reload: true
            });
            return;
          }
        } else {
          const result = yield _this3.api.storeChild(formGroup.value);
          yield _this3.b.responseToast(result);
          if (result.success) {
            _this3.router.navigate([_this3.b.routesConfig.beneficiaryAssessment + result.data.id + '/child'], {
              queryParams: {
                from: 'child-add'
              },
              replaceUrl: true // This replaces the child-add page in history
            });
            return;
          }
          yield _this3.b.errorToast(result.message);
        }
      } else {
        // If form is invalid but no custom validation errors were caught
        const formErrors = _this3.getDetailedFormErrors();
        _this3.b.errorToast(formErrors || 'Please fill out all required fields correctly');
      }
    })();
  }
  validateFormFields(formGroup) {
    var _formGroup$get, _formGroup$get4, _formGroup$get5, _formGroup$get6, _formGroup$get7, _formGroup$get8, _formGroup$get9;
    const errors = [];
    // FCN validation for both add and edit modes
    const fcnValue = (_formGroup$get = formGroup.get('fcn')) === null || _formGroup$get === void 0 ? void 0 : _formGroup$get.value;
    if (!fcnValue || fcnValue.trim() === '') {
      errors.push('Family Count Number (FCN) is required');
    } else if (!this.fcnSearchAttempted) {
      errors.push('Please search for mother using FCN first');
    } else if (this.noMotherFound) {
      errors.push('Mother must be found by FCN before proceeding. Please add mother first.');
    } else if (this.showMotherDropdown && !this.selectedMotherId) {
      errors.push('Please select a mother from the dropdown');
    } else if (!this.motherInfo) {
      errors.push('Mother information is required');
    }
    // Additional validations for add mode only
    if (!this.isEditMode) {
      var _formGroup$get2, _formGroup$get3;
      // Block validation for add mode
      if (!((_formGroup$get2 = formGroup.get('block_id')) !== null && _formGroup$get2 !== void 0 && _formGroup$get2.value)) {
        errors.push('Block selection is required');
      }
      // Progress ID validation for add mode
      const progressIdValue = (_formGroup$get3 = formGroup.get('progress_id')) === null || _formGroup$get3 === void 0 ? void 0 : _formGroup$get3.value;
      if (!progressIdValue || progressIdValue.trim() === '') {
        errors.push('Progress ID is required');
      }
    }
    // Child name validation
    const nameValue = (_formGroup$get4 = formGroup.get('name')) === null || _formGroup$get4 === void 0 ? void 0 : _formGroup$get4.value;
    if (!nameValue || nameValue.trim() === '') {
      errors.push('Child name is required');
    }
    // Age/Date of birth validation
    const ageValue = (_formGroup$get5 = formGroup.get('age')) === null || _formGroup$get5 === void 0 ? void 0 : _formGroup$get5.value;
    const dobValue = (_formGroup$get6 = formGroup.get('date_of_birth')) === null || _formGroup$get6 === void 0 ? void 0 : _formGroup$get6.value;
    if ((!ageValue || ageValue.trim() === '') && (!dobValue || dobValue.trim() === '')) {
      errors.push('Either Date of Birth or Age is required');
    }
    // Birth weight validation
    const birthWeightValue = (_formGroup$get7 = formGroup.get('birth_weight')) === null || _formGroup$get7 === void 0 ? void 0 : _formGroup$get7.value;
    if (!birthWeightValue || birthWeightValue.toString().trim() === '') {
      errors.push('Birth weight is required');
    }
    // Gender validation
    const genderValue = (_formGroup$get8 = formGroup.get('gender')) === null || _formGroup$get8 === void 0 ? void 0 : _formGroup$get8.value;
    if (!genderValue || genderValue.trim() === '') {
      errors.push('Gender selection is required');
    }
    // Inf ID validation
    const infIdValue = (_formGroup$get9 = formGroup.get('inf_id')) === null || _formGroup$get9 === void 0 ? void 0 : _formGroup$get9.value;
    if (!infIdValue || infIdValue.toString().trim() === '') {
      errors.push('Infrastructure ID is required');
    }
    // Pattern validations
    this.validatePatterns(formGroup, errors);
    return errors;
  }
  validatePatterns(formGroup, errors) {
    // FCN pattern validation
    const fcnControl = formGroup.get('fcn');
    if (fcnControl !== null && fcnControl !== void 0 && fcnControl.value && fcnControl.hasError('pattern')) {
      errors.push('FCN format is invalid');
    }
    // Progress ID pattern validation
    const progressIdControl = formGroup.get('progress_id');
    if (progressIdControl !== null && progressIdControl !== void 0 && progressIdControl.value && progressIdControl.hasError('pattern')) {
      errors.push('Progress ID format is invalid');
    }
    // Name pattern validation
    const nameControl = formGroup.get('name');
    if (nameControl !== null && nameControl !== void 0 && nameControl.value && nameControl.hasError('pattern')) {
      errors.push('Name contains invalid characters');
    }
    // Date of birth pattern validation
    const dobControl = formGroup.get('date_of_birth');
    if (dobControl !== null && dobControl !== void 0 && dobControl.value && dobControl.hasError('pattern')) {
      errors.push('Date of birth format is invalid');
    }
    // Age pattern validation
    const ageControl = formGroup.get('age');
    if (ageControl !== null && ageControl !== void 0 && ageControl.value && ageControl.hasError('pattern')) {
      errors.push('Age must be a valid number');
    }
    // Birth weight pattern validation
    const birthWeightControl = formGroup.get('birth_weight');
    if (birthWeightControl !== null && birthWeightControl !== void 0 && birthWeightControl.value && birthWeightControl.hasError('pattern')) {
      errors.push('Birth weight must be a valid number with up to 2 decimal places');
    }
    // Number pattern validations for IDs
    const numberFields = ['inf_id', 'block_id', 'sub_block_id', 'majhi_id', 'sub_block_majhi_id', 'hh_no'];
    numberFields.forEach(field => {
      const control = formGroup.get(field);
      if (control !== null && control !== void 0 && control.value && control.hasError('pattern')) {
        const fieldName = this.getFieldDisplayName(field);
        errors.push(`${fieldName} must be a valid number`);
      }
    });
  }
  getFieldDisplayName(fieldName) {
    const displayNames = {
      'fcn': 'Family Count Number (FCN)',
      'name': 'Child Name',
      'progress_id': 'Progress ID',
      'date_of_birth': 'Date of Birth',
      'birth_weight': 'Birth Weight (kg)',
      'age': 'Age',
      'gender': 'Gender',
      'scope_no': 'Scope ID',
      'mnr_no': 'MNR Number',
      'moha_id': 'MOHA ID',
      'mother': 'Mother Name',
      'father': 'Father Name',
      'inf_id': 'Infrastructure ID',
      'block_id': 'Block',
      'sub_block_id': 'Sub Block',
      'majhi_id': 'Majhi',
      'sub_block_majhi_id': 'Sub Block Majhi',
      'hh_no': 'Household Number'
    };
    return displayNames[fieldName] || fieldName;
  }
  getDetailedFormErrors() {
    const errors = [];
    const formErrors = this.getFormErrors();
    for (const [fieldName, fieldErrors] of Object.entries(formErrors)) {
      const displayName = this.getFieldDisplayName(fieldName);
      if (fieldErrors['required']) {
        errors.push(`${displayName} is required`);
      }
      if (fieldErrors['pattern']) {
        errors.push(`${displayName} format is invalid`);
      }
    }
    return errors.length > 0 ? errors[0] : 'Please check all fields and try again';
  }
  markFormGroupTouched(formGroup) {
    Object.keys(formGroup.controls).forEach(key => {
      const control = formGroup.get(key);
      control === null || control === void 0 || control.markAsTouched();
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormGroup) {
        this.markFormGroupTouched(control);
      }
    });
    this.change.markForCheck();
  }
  getFieldErrorMessage(fieldName) {
    const control = this.registerFrom.get(fieldName);
    if (control && control.invalid && control.touched) {
      if (control.hasError('required')) {
        return `${this.getFieldDisplayName(fieldName)} is required`;
      }
      if (control.hasError('pattern')) {
        return `${this.getFieldDisplayName(fieldName)} format is invalid`;
      }
    }
    return '';
  }
  isFieldInvalid(fieldName) {
    const control = this.registerFrom.get(fieldName);
    return !!(control && control.invalid && control.touched);
  }
  onBlockSelected() {
    this.selectedBlock = this.beneficiaryRegPreqData.location.block.find(item => item.block_id === this.getFormFieldValue('block_id'));
    this.subBlocks = this.beneficiaryRegPreqData.location.sub_block.filter(item => item.block_id === this.selectedBlock.block_id && item.camp_id === this.selectedBlock.camp_id);
    this.blockMajhis = this.beneficiaryRegPreqData.location.block_majhi.filter(item => item.block_id === this.selectedBlock.block_id && item.camp_id === this.selectedBlock.camp_id);
    this.resetBlocDependencies();
  }
  onSubBlockSelected() {
    const selectedSubBlockId = this.getFormFieldValue('sub_block_id');
    this.selectedSubBlock = this.beneficiaryRegPreqData.location.sub_block.find(item => item.sub_block_id === selectedSubBlockId);
    this.subBlockMajhis = this.beneficiaryRegPreqData.location.sub_block_majhi.filter(item => {
      var _this$selectedSubBloc, _this$selectedSubBloc2;
      return item.sub_block_id === selectedSubBlockId && item.camp_id === ((_this$selectedSubBloc = this.selectedSubBlock) === null || _this$selectedSubBloc === void 0 ? void 0 : _this$selectedSubBloc.camp_id) && item.block_id === ((_this$selectedSubBloc2 = this.selectedSubBlock) === null || _this$selectedSubBloc2 === void 0 ? void 0 : _this$selectedSubBloc2.block_id);
    });
    this.resetSubBlocDependencies();
  }
  resetBlocDependencies() {
    this.resetFormFieldValue('sub_block_id');
    this.resetFormFieldValue('majhi_id');
    this.resetFormFieldValue('sub_block_majhi_id');
  }
  resetSubBlocDependencies() {
    this.resetFormFieldValue('sub_block_majhi_id');
  }
  /**
   * Value getter
   */
  getFormFieldValue(key) {
    var _this$registerFrom$ge;
    return (_this$registerFrom$ge = this.registerFrom.get(key)) === null || _this$registerFrom$ge === void 0 ? void 0 : _this$registerFrom$ge.value;
  }
  resetFormFieldValue(key) {
    var _this$registerFrom$ge2;
    (_this$registerFrom$ge2 = this.registerFrom.get(key)) === null || _this$registerFrom$ge2 === void 0 || _this$registerFrom$ge2.setValue(null);
  }
  searchChildrenByFcn() {
    var _this4 = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const fcnValue = _this4.getFormFieldValue('fcn');
      if (!fcnValue) {
        _this4.b.errorToast('Please enter FCN first');
        return;
      }
      _this4.fcnSearchLoading = true;
      _this4.motherInfo = null;
      _this4.noMotherFound = false;
      try {
        const result = yield _this4.api.childrenByFcn(fcnValue);
        if (result && result.success && result.data && result.data.exists && result.data.mothers && result.data.mothers.length > 0) {
          _this4.mothersFound = result.data.mothers;
          _this4.fcnSearchAttempted = true;
          _this4.noMotherFound = false;
          if (_this4.mothersFound.length === 1) {
            // Single mother found - auto-select
            _this4.selectedMotherId = _this4.mothersFound[0].id;
            _this4.motherInfo = _this4.mothersFound[0];
            _this4.showMotherDropdown = false;
            _this4.autoFillMotherData(_this4.motherInfo);
            _this4.b.toast(`Mother found with FCN: ${fcnValue}`);
          } else {
            // Multiple mothers found - show dropdown
            _this4.showMotherDropdown = true;
            _this4.motherInfo = null;
            _this4.selectedMotherId = null;
            _this4.b.toast(`${_this4.mothersFound.length} mothers found with FCN: ${fcnValue}. Please select one.`);
          }
          _this4.change.markForCheck();
        } else {
          // Error already handled by errorHandle in api_base.service.ts
          // Just update the UI state
          _this4.fcnSearchAttempted = true;
          _this4.noMotherFound = true;
          _this4.motherInfo = null;
          _this4.mothersFound = [];
          _this4.showMotherDropdown = false;
          _this4.selectedMotherId = null;
        }
      } catch (error) {
        // Error already handled by errorHandle, just update state
        _this4.fcnSearchAttempted = true;
        _this4.noMotherFound = true;
        _this4.motherInfo = null;
        _this4.mothersFound = [];
        _this4.showMotherDropdown = false;
        _this4.selectedMotherId = null;
      } finally {
        _this4.fcnSearchLoading = false;
        _this4.change.markForCheck();
      }
    })();
  }
  onMotherSelected() {
    if (!this.selectedMotherId) {
      this.motherInfo = null;
      return;
    }
    // Convert selectedMotherId to number for comparison (ion-select returns string)
    const selectedId = typeof this.selectedMotherId === 'string' ? parseInt(this.selectedMotherId, 10) : this.selectedMotherId;
    this.motherInfo = this.mothersFound.find(mother => mother.id === selectedId);
    if (this.motherInfo) {
      this.autoFillMotherData(this.motherInfo);
      this.b.toast(`Selected mother: ${this.motherInfo.name}`);
    }
    this.change.markForCheck();
  }
  autoFillMotherData(motherData) {
    const locationData = motherData.current_location;
    const autoFillData = {};
    // Fill mother and father information
    if (motherData.name) {
      autoFillData.mother = motherData.name;
    }
    if (motherData.husband) {
      autoFillData.father = motherData.husband;
    }
    // Fill mother ID (plw_id)
    if (motherData.id) {
      autoFillData.plw_id = motherData.id;
    }
    // Fill location information
    if (locationData) {
      if (locationData.inf_id) {
        autoFillData.inf_id = locationData.inf_id;
      }
      if (locationData.block_id) {
        autoFillData.block_id = locationData.block_id;
      }
      if (locationData.sub_block_id) {
        autoFillData.sub_block_id = locationData.sub_block_id;
      }
      if (locationData.majhi_id) {
        autoFillData.majhi_id = locationData.majhi_id;
      }
      if (locationData.sub_block_majhi_id) {
        autoFillData.sub_block_majhi_id = locationData.sub_block_majhi_id;
      }
      if (locationData.hh_no) {
        autoFillData.hh_no = locationData.hh_no;
      }
    }
    this.registerFrom.patchValue(autoFillData);
  }
  calculateAgeFromDob(dob) {
    if (dob) {
      const birthDate = new Date(dob);
      const today = new Date();
      let months = (today.getFullYear() - birthDate.getFullYear()) * 12;
      months += today.getMonth() - birthDate.getMonth();
      if (today.getDate() < birthDate.getDate()) {
        months -= 1;
      }
      months = Math.max(0, months);
      const ageControl = this.registerFrom.get('age');
      ageControl === null || ageControl === void 0 || ageControl.setValue(months.toString());
    }
  }
  navigateToAddMother() {
    this.router.navigate([this.b.routesConfig.plwAdd], {
      queryParams: {
        returnUrl: this.router.url,
        fcn: this.getFormFieldValue('fcn')
      }
    });
  }
  viewChildDetail(childId) {
    this.router.navigate(['/child-detail', childId]);
  }
  isSubmitDisabled() {
    // Basic form validation
    if (this.registerFrom.invalid) {
      return true;
    }
    // FCN dependency validation for both add and edit modes
    const fcnValue = this.getFormFieldValue('fcn');
    // If FCN is provided but not searched yet
    if (fcnValue && !this.fcnSearchAttempted) {
      return true;
    }
    // If FCN search was attempted but no mother found
    if (this.fcnSearchAttempted && this.noMotherFound) {
      return true;
    }
    // If multiple mothers found but none selected
    if (this.showMotherDropdown && !this.selectedMotherId) {
      return true;
    }
    // If FCN search was attempted but no mother info available
    if (this.fcnSearchAttempted && !this.motherInfo) {
      return true;
    }
    return false;
  }
  getFormErrors() {
    let formErrors = {};
    Object.keys(this.registerFrom.controls).forEach(key => {
      var _this$registerFrom$ge3;
      const controlErrors = (_this$registerFrom$ge3 = this.registerFrom.get(key)) === null || _this$registerFrom$ge3 === void 0 ? void 0 : _this$registerFrom$ge3.errors;
      if (controlErrors) {
        formErrors[key] = controlErrors;
      }
    });
    return formErrors;
  }
}, _ChildAddEditPage.ctorParameters = () => [{
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder
}, {
  type: _services_child_api_service__WEBPACK_IMPORTED_MODULE_4__.ChildAPIService
}, {
  type: _util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectorRef
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.Router
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_8__.ActivatedRoute
}], _ChildAddEditPage);
ChildAddEditPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
  selector: 'app-child-add-edit',
  template: _child_add_edit_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_7__.ChangeDetectionStrategy.OnPush,
  styles: [(_child_add_edit_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ChildAddEditPage);


/***/ }),

/***/ 22295:
/*!**************************************************************************!*\
  !*** ./src/app/pages/child-add-edit/child-add-edit.page.scss?ngResource ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.child-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

.card-container {
  max-width: 1200px;
  margin: 0 auto;
  margin-top: 20px;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title ion-icon {
  font-size: 24px;
}

.child-form .form-section {
  margin-bottom: 32px;
}
.child-form .form-section:last-child {
  margin-bottom: 0;
}
.child-form .section-subtitle {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  margin: 0 0 16px 0;
  color: var(--ion-color-dark);
  padding: 8px 0;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}
.child-form .section-subtitle ion-icon {
  font-size: 20px;
}
.child-form .form-item {
  margin-bottom: 16px;
  border-radius: 8px;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.child-form .form-item ion-label {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.child-form .form-item ion-note {
  font-size: 12px;
  margin-top: 4px;
}
.child-form .form-item ion-note[slot=helper] {
  color: var(--ion-color-medium);
}
.child-form .form-item ion-note[slot=error] {
  color: var(--ion-color-danger);
}
.child-form .form-item.auto-filled-item {
  background: rgba(45, 211, 111, 0.05);
  border-color: rgba(45, 211, 111, 0.2);
}
.child-form .form-item.auto-filled-item .auto-filled-input {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
}
.child-form .form-item.auto-filled-item ion-label {
  color: var(--ion-color-success) !important;
  font-weight: 600;
}

.fcn-search-section {
  display: flex;
  flex-direction: column;
  gap: 12px;
  margin-bottom: 16px;
}
.fcn-search-section ion-button {
  align-self: flex-start;
  margin: 0;
}
.fcn-search-section ion-button[disabled] {
  opacity: 0.5;
}

.mother-selection-section {
  margin: 16px 0;
  padding: 16px;
  background: rgba(73, 144, 226, 0.05);
  border-radius: 12px;
  border: 1px solid rgba(73, 144, 226, 0.2);
}
.mother-selection-section .form-item {
  margin-bottom: 12px;
  border-radius: 8px;
  border: 1px solid rgba(73, 144, 226, 0.3);
  background: rgba(255, 255, 255, 0.8);
}
.mother-selection-section .form-item ion-label {
  color: var(--ion-color-primary);
  font-weight: 600;
}
.mother-selection-section .form-item ion-select {
  --padding-start: 8px;
  --padding-end: 8px;
  color: var(--ion-color-dark);
  font-weight: 500;
}
.mother-selection-section .form-item ion-select[placeholder] {
  color: var(--ion-color-medium);
}
.mother-selection-section .info-tip {
  background: rgba(255, 193, 7, 0.1);
  border-left-color: var(--ion-color-warning);
  margin-bottom: 0;
}
.mother-selection-section .info-tip span {
  color: var(--ion-color-warning-shade);
}

.mother-info-card {
  margin: 16px 0;
}
.mother-info-card .mother-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.mother-info-card .info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.mother-info-card .info-item:last-child {
  margin-bottom: 0;
}
.mother-info-card .info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.mother-info-card .info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
}

.mother-info-card .item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.mother-info-card .item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.mother-info-card .item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
}
.mother-info-card .item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}

.info-tip {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 12px 16px;
  background: rgba(73, 144, 226, 0.1);
  border-radius: 8px;
  margin-bottom: 16px;
  border-left: 4px solid var(--ion-color-primary);
}
.info-tip ion-icon {
  font-size: 18px;
}
.info-tip span {
  color: var(--ion-color-primary-shade);
  font-size: 14px;
  font-weight: 500;
}

.form-actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
  justify-content: flex-end;
  flex-wrap: wrap;
}
.form-actions .submit-btn {
  min-width: 180px;
}
.form-actions .submit-btn[disabled] {
  opacity: 0.5;
  cursor: not-allowed;
}

.loading-container {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 60px 20px;
  text-align: center;
}
.loading-container ion-spinner {
  margin-bottom: 16px;
  width: 32px;
  height: 32px;
}
.loading-container p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
}

ion-input {
  --padding-start: 8px;
  --padding-end: 8px;
}
ion-input[readonly] {
  --color: var(--ion-color-success-shade);
  font-weight: 500;
  cursor: default;
}

ion-select, ion-datetime {
  --padding-start: 8px;
  --padding-end: 8px;
}

ion-item.ng-invalid.ng-touched {
  border-color: var(--ion-color-danger);
}
ion-item.ng-invalid.ng-touched ion-label {
  color: var(--ion-color-danger);
}

ion-item.ng-valid.ng-touched {
  border-color: var(--ion-color-success);
}

ion-button {
  font-weight: 500;
}
ion-button[disabled] {
  --opacity: 0.4;
  pointer-events: none;
}

.section-header .section-title {
  position: relative;
}
.section-header .section-title::after {
  content: "";
  position: absolute;
  bottom: -4px;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, var(--ion-color-primary), transparent);
  border-radius: 1px;
}

.radio-item {
  --padding-start: 0;
  --inner-padding-end: 0;
  margin-bottom: 8px;
}
.radio-item ion-radio {
  margin-right: 12px;
}
.radio-item ion-label {
  font-size: 16px;
  color: var(--ion-color-dark);
}

ion-radio-group {
  display: flex;
  flex-direction: column;
  gap: 4px;
  margin-top: 8px;
}

@media (min-width: 768px) {
  .child-container {
    margin-top: 24px;
  }
  .card-container {
    margin-top: 24px;
  }
  .section-title {
    font-size: 24px;
  }
  .section-title ion-icon {
    font-size: 28px;
  }
  .section-subtitle {
    font-size: 18px;
  }
  .section-subtitle ion-icon {
    font-size: 22px;
  }
  .form-actions {
    margin-top: 32px;
  }
  .form-actions .submit-btn {
    min-width: 200px;
  }
  .loading-container {
    padding: 80px 40px;
  }
  .loading-container ion-spinner {
    width: 40px;
    height: 40px;
  }
  .loading-container p {
    font-size: 16px;
  }
  .fcn-search-section {
    flex-direction: row;
    align-items: flex-end;
    gap: 16px;
  }
  .fcn-search-section .form-item {
    flex: 1;
    margin-bottom: 0;
  }
  .fcn-search-section ion-button {
    margin-bottom: 0;
    white-space: nowrap;
  }
}
@media (max-width: 767px) {
  .section-title {
    font-size: 18px;
  }
  .section-title ion-icon {
    font-size: 22px;
  }
  .section-subtitle {
    font-size: 14px;
  }
  .section-subtitle ion-icon {
    font-size: 18px;
  }
  .form-actions {
    flex-direction: column;
    margin-top: 20px;
  }
  .form-actions .submit-btn {
    width: 100%;
    min-width: auto;
  }
  .loading-container {
    padding: 40px 16px;
  }
  .loading-container p {
    font-size: 12px;
  }
  .info-tip {
    padding: 10px 12px;
  }
  .info-tip span {
    font-size: 13px;
  }
  .fcn-search-section ion-button {
    width: 100%;
    margin-top: 8px;
  }
  .mother-selection-section {
    margin: 12px 0;
    padding: 12px;
  }
  .mother-selection-section .form-item {
    margin-bottom: 10px;
  }
  .mother-selection-section .info-tip {
    padding: 10px 12px;
  }
  .mother-selection-section .info-tip span {
    font-size: 13px;
  }
  .mother-info-card {
    margin: 12px 0;
  }
  .mother-info-card .profile-content {
    padding: 16px;
  }
  .mother-info-card .content-grid ion-col {
    padding: 0 3px;
  }
  .mother-info-card .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .mother-info-card .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .mother-info-card .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .mother-info-card .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .mother-info-card .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .mother-info-card .item-content .value {
    font-size: 13px;
  }
}
@media (prefers-color-scheme: dark) {
  .form-item.auto-filled-item {
    background: rgba(45, 211, 111, 0.08);
    border-color: rgba(45, 211, 111, 0.3);
  }
  .section-title,
  .section-subtitle {
    color: var(--ion-color-light);
  }
  .info-tip {
    background: rgba(73, 144, 226, 0.15);
    border-left-color: var(--ion-color-primary-tint);
  }
  .mother-selection-section {
    background: rgba(73, 144, 226, 0.08);
    border-color: rgba(73, 144, 226, 0.3);
  }
  .mother-selection-section .form-item {
    background: rgba(255, 255, 255, 0.05);
    border-color: rgba(73, 144, 226, 0.4);
  }
  .mother-selection-section .info-tip {
    background: rgba(255, 193, 7, 0.15);
    border-left-color: var(--ion-color-warning-tint);
  }
}
.no-mother-alert,
.fcn-required-alert {
  margin: 16px 0;
}
.no-mother-alert .alert-content,
.fcn-required-alert .alert-content {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  margin-bottom: 16px;
}
.no-mother-alert .alert-content ion-icon,
.fcn-required-alert .alert-content ion-icon {
  font-size: 24px;
  margin-top: 2px;
  flex-shrink: 0;
}
.no-mother-alert .alert-content .alert-text,
.fcn-required-alert .alert-content .alert-text {
  flex: 1;
}
.no-mother-alert .alert-content .alert-text h4,
.fcn-required-alert .alert-content .alert-text h4 {
  margin: 0 0 8px 0;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.no-mother-alert .alert-content .alert-text p,
.fcn-required-alert .alert-content .alert-text p {
  margin: 0;
  font-size: 14px;
  color: var(--ion-color-medium);
  line-height: 1.4;
}
.no-mother-alert .alert-actions,
.fcn-required-alert .alert-actions {
  display: flex;
  justify-content: flex-start;
}
.no-mother-alert .alert-actions ion-button,
.fcn-required-alert .alert-actions ion-button {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 12px;
  --padding-bottom: 12px;
  font-weight: 500;
}

.no-mother-alert ion-card {
  --background: #fff8e1;
  border-left: 4px solid var(--ion-color-warning);
}

.fcn-required-alert ion-card {
  --background: #f8f9fa;
  border-left: 4px solid var(--ion-color-primary);
}

.required-indicator {
  color: var(--ion-color-danger);
  font-weight: bold;
  margin-left: 4px;
}

.dependency-notice {
  margin-bottom: 16px;
}
.dependency-notice ion-card {
  --background: #f8f9fa;
  border-left: 4px solid var(--ion-color-primary);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}
.dependency-notice .notice-content {
  display: flex;
  align-items: flex-start;
  gap: 12px;
}
.dependency-notice .notice-content ion-icon {
  font-size: 20px;
  margin-top: 2px;
  flex-shrink: 0;
}
.dependency-notice .notice-content .notice-text {
  flex: 1;
}
.dependency-notice .notice-content .notice-text strong {
  display: block;
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin-bottom: 4px;
}
.dependency-notice .notice-content .notice-text p {
  margin: 0;
  font-size: 13px;
  color: var(--ion-color-medium);
  line-height: 1.4;
}

@media (prefers-reduced-motion: reduce) {
  * {
    transition: none !important;
    animation: none !important;
  }
}
@media (prefers-contrast: high) {
  .form-item {
    border-width: 2px;
  }
  .section-subtitle {
    border-bottom-width: 3px;
  }
  ion-label {
    font-weight: 600;
  }
}
.siblings-info-card {
  margin: 16px 0;
}
.siblings-info-card .siblings-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}
.siblings-info-card .siblings-card ion-card-header {
  --background: #f8f9fa;
  border-bottom: 1px solid rgba(0, 0, 0, 0.06);
}
.siblings-info-card .siblings-card ion-card-header ion-card-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
}
.siblings-info-card .siblings-card ion-card-header ion-card-title ion-icon {
  font-size: 20px;
}

.siblings-section {
  margin-top: 1rem;
}

.siblings-table-container {
  overflow-x: auto;
  border-radius: 6px;
  border: 1px solid var(--ion-color-light);
}

.siblings-table {
  width: 100%;
  border-collapse: collapse;
  min-width: 550px;
}
.siblings-table th {
  background-color: var(--ion-color-light);
  color: var(--ion-color-primary);
  font-weight: 600;
  padding: 10px 8px;
  text-align: center;
  border-bottom: 1px solid var(--ion-color-medium);
  font-size: 0.85rem;
  white-space: nowrap;
}
.siblings-table td {
  padding: 10px 8px;
  border-bottom: 1px solid var(--ion-color-light-shade);
  font-size: 0.85rem;
  text-align: center;
}
.siblings-table td.sibling-name {
  text-align: left;
}
.siblings-table td.sibling-name .name-content {
  display: flex;
  align-items: center;
  gap: 8px;
}
.siblings-table td.sibling-name .name-content ion-icon {
  font-size: 18px;
  flex-shrink: 0;
}
.siblings-table td.sibling-name .name-content span {
  font-weight: 500;
  color: var(--ion-color-dark);
}
.siblings-table td.sibling-gender .gender-badge {
  font-size: 11px;
  font-weight: 600;
  padding: 4px 8px;
  border-radius: 12px;
}
.siblings-table td.sibling-gender .no-gender {
  color: var(--ion-color-medium);
  font-style: italic;
  font-size: 0.8rem;
}
.siblings-table td.sibling-dob {
  font-weight: 500;
  color: var(--ion-color-dark);
  white-space: nowrap;
}
.siblings-table td.sibling-progress-id {
  font-weight: 500;
  color: var(--ion-color-primary);
}
.siblings-table td.actions-cell ion-button {
  margin: 0;
}
.siblings-table tbody tr:hover {
  background-color: var(--ion-color-light-tint);
}
.siblings-table tbody tr:last-child td {
  border-bottom: none;
}

@media (max-width: 767px) {
  .siblings-info-card {
    margin: 12px 0;
  }
  .siblings-info-card .siblings-card ion-card-header ion-card-title {
    font-size: 14px;
  }
  .siblings-info-card .siblings-card ion-card-header ion-card-title ion-icon {
    font-size: 18px;
  }
  .siblings-table-container {
    border-radius: 4px;
  }
  .siblings-table {
    min-width: 480px;
  }
  .siblings-table th {
    padding: 8px 4px;
    font-size: 0.7rem;
  }
  .siblings-table td {
    padding: 8px 4px;
    font-size: 0.75rem;
  }
  .siblings-table td.sibling-name .name-content {
    gap: 6px;
  }
  .siblings-table td.sibling-name .name-content ion-icon {
    font-size: 16px;
  }
  .siblings-table td.sibling-name .name-content span {
    font-size: 0.7rem;
  }
  .siblings-table td.sibling-gender .gender-badge {
    font-size: 9px;
    padding: 2px 4px;
  }
  .siblings-table td.sibling-gender .no-gender {
    font-size: 0.7rem;
  }
  .siblings-table td.sibling-dob {
    font-size: 0.7rem;
  }
  .siblings-table td.sibling-progress-id {
    font-size: 0.7rem;
  }
  .siblings-table td.actions-cell ion-button {
    --padding-start: 4px;
    --padding-end: 4px;
  }
  .siblings-table td.actions-cell ion-button ion-icon {
    font-size: 14px;
  }
}
.no-siblings-message {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 16px;
  background: rgba(108, 117, 125, 0.1);
  border-radius: 8px;
  text-align: left;
}
.no-siblings-message ion-icon {
  font-size: 24px;
  flex-shrink: 0;
  color: var(--ion-color-medium);
}
.no-siblings-message p {
  margin: 0;
  color: var(--ion-color-medium);
  font-size: 14px;
  line-height: 1.4;
  font-style: italic;
}

@media (prefers-color-scheme: dark) {
  .siblings-card ion-card-header {
    --background: rgba(255, 255, 255, 0.05);
    border-bottom-color: rgba(255, 255, 255, 0.1);
  }
  .sibling-header {
    border-bottom-color: rgba(255, 255, 255, 0.1);
  }
  .sibling-detail-item {
    background: rgba(255, 255, 255, 0.03);
    border-color: rgba(255, 255, 255, 0.08);
  }
  .sibling-detail-item:hover {
    background: rgba(73, 144, 226, 0.08);
    border-color: rgba(73, 144, 226, 0.3);
  }
  .sibling-divider {
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/child-add-edit/child-add-edit.page.scss"],"names":[],"mappings":"AAGA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAKA;EACE,iBAAA;EACA,cAAA;EACA,gBAAA;AAFF;;AAMA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,SAAA;AAHF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;AAJF;;AAOA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AAJF;AAME;EACE,eAAA;AAJJ;;AAUE;EACE,mBAAA;AAPJ;AASI;EACE,gBAAA;AAPN;AAWE;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;EACA,cAAA;EACA,gDAAA;AATJ;AAWI;EACE,eAAA;AATN;AAaE;EACE,mBAAA;EACA,kBAAA;EACA,qCAAA;AAXJ;AAaI;EACE,gBAAA;EACA,4BAAA;AAXN;AAcI;EACE,eAAA;EACA,eAAA;AAZN;AAcM;EACE,8BAAA;AAZR;AAeM;EACE,8BAAA;AAbR;AAkBI;EACE,oCAAA;EACA,qCAAA;AAhBN;AAkBM;EACE,uCAAA;EACA,gBAAA;AAhBR;AAmBM;EACE,0CAAA;EACA,gBAAA;AAjBR;;AAwBA;EACE,aAAA;EACA,sBAAA;EACA,SAAA;EACA,mBAAA;AArBF;AAuBE;EACE,sBAAA;EACA,SAAA;AArBJ;AAuBI;EACE,YAAA;AArBN;;AA2BA;EACE,cAAA;EACA,aAAA;EACA,oCAAA;EACA,mBAAA;EACA,yCAAA;AAxBF;AA0BE;EACE,mBAAA;EACA,kBAAA;EACA,yCAAA;EACA,oCAAA;AAxBJ;AA0BI;EACE,+BAAA;EACA,gBAAA;AAxBN;AA2BI;EACE,oBAAA;EACA,kBAAA;EACA,4BAAA;EACA,gBAAA;AAzBN;AA2BM;EACE,8BAAA;AAzBR;AA8BE;EACE,kCAAA;EACA,2CAAA;EACA,gBAAA;AA5BJ;AA8BI;EACE,qCAAA;AA5BN;;AAkCA;EACE,cAAA;AA/BF;AAiCE;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AA/BJ;;AAmCA;EACE,aAAA;AAhCF;;AAmCA;EACE,UAAA;EACA,SAAA;AAhCF;AAkCE;EACE,SAAA;AAhCJ;AAmCE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAjCJ;AAmCI;EACE,eAAA;EACA,kBAAA;AAjCN;AAoCI;EACE,gBAAA;EACA,iBAAA;AAlCN;;AAwCA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AArCF;AAuCE;EACE,gBAAA;AArCJ;AAwCE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAtCJ;AAyCE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;AAvCJ;;AA2CA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAxCF;AA0CE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AAxCJ;AA2CE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;AAzCJ;AA2CI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AAzCN;;AA+CA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,kBAAA;EACA,mCAAA;EACA,kBAAA;EACA,mBAAA;EACA,+CAAA;AA5CF;AA8CE;EACE,eAAA;AA5CJ;AA+CE;EACE,qCAAA;EACA,eAAA;EACA,gBAAA;AA7CJ;;AAkDA;EACE,aAAA;EACA,SAAA;EACA,gBAAA;EACA,yBAAA;EACA,eAAA;AA/CF;AAiDE;EACE,gBAAA;AA/CJ;AAiDI;EACE,YAAA;EACA,mBAAA;AA/CN;;AAqDA;EACE,aAAA;EACA,sBAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AAlDF;AAoDE;EACE,mBAAA;EACA,WAAA;EACA,YAAA;AAlDJ;AAqDE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;AAnDJ;;AAwDA;EACE,oBAAA;EACA,kBAAA;AArDF;AAuDE;EACE,uCAAA;EACA,gBAAA;EACA,eAAA;AArDJ;;AAyDA;EACE,oBAAA;EACA,kBAAA;AAtDF;;AA0DA;EACE,qCAAA;AAvDF;AAyDE;EACE,8BAAA;AAvDJ;;AA2DA;EACE,sCAAA;AAxDF;;AA4DA;EACE,gBAAA;AAzDF;AA2DE;EACE,cAAA;EACA,oBAAA;AAzDJ;;AA8DA;EACE,kBAAA;AA3DF;AA6DE;EACE,WAAA;EACA,kBAAA;EACA,YAAA;EACA,OAAA;EACA,QAAA;EACA,WAAA;EACA,yEAAA;EACA,kBAAA;AA3DJ;;AAgEA;EACE,kBAAA;EACA,sBAAA;EACA,kBAAA;AA7DF;AA+DE;EACE,kBAAA;AA7DJ;AAgEE;EACE,eAAA;EACA,4BAAA;AA9DJ;;AAkEA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,eAAA;AA/DF;;AAmEA;EACE;IACE,gBAAA;EAhEF;EAmEA;IACE,gBAAA;EAjEF;EAoEA;IACE,eAAA;EAlEF;EAoEE;IACE,eAAA;EAlEJ;EAsEA;IACE,eAAA;EApEF;EAsEE;IACE,eAAA;EApEJ;EAwEA;IACE,gBAAA;EAtEF;EAwEE;IACE,gBAAA;EAtEJ;EA0EA;IACE,kBAAA;EAxEF;EA0EE;IACE,WAAA;IACA,YAAA;EAxEJ;EA2EE;IACE,eAAA;EAzEJ;EA6EA;IACE,mBAAA;IACA,qBAAA;IACA,SAAA;EA3EF;EA6EE;IACE,OAAA;IACA,gBAAA;EA3EJ;EA8EE;IACE,gBAAA;IACA,mBAAA;EA5EJ;AACF;AAiFA;EACE;IACE,eAAA;EA/EF;EAiFE;IACE,eAAA;EA/EJ;EAmFA;IACE,eAAA;EAjFF;EAmFE;IACE,eAAA;EAjFJ;EAqFA;IACE,sBAAA;IACA,gBAAA;EAnFF;EAqFE;IACE,WAAA;IACA,eAAA;EAnFJ;EAuFA;IACE,kBAAA;EArFF;EAuFE;IACE,eAAA;EArFJ;EAyFA;IACE,kBAAA;EAvFF;EAyFE;IACE,eAAA;EAvFJ;EA4FE;IACE,WAAA;IACA,eAAA;EA1FJ;EA+FA;IACE,cAAA;IACA,aAAA;EA7FF;EA+FE;IACE,mBAAA;EA7FJ;EAgGE;IACE,kBAAA;EA9FJ;EAgGI;IACE,eAAA;EA9FN;EAoGA;IACE,cAAA;EAlGF;EAoGE;IACE,aAAA;EAlGJ;EAsGI;IACE,cAAA;EApGN;EAsGM;IACE,eAAA;IACA,kBAAA;EApGR;EAuGM;IACE,gBAAA;IACA,iBAAA;EArGR;EA0GE;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAxGJ;EA0GI;IACE,eAAA;IACA,WAAA;EAxGN;EA6GI;IACE,eAAA;IACA,qBAAA;EA3GN;EA8GI;IACE,eAAA;EA5GN;AACF;AAkHA;EACE;IACE,oCAAA;IACA,qCAAA;EAhHF;EAmHA;;IAEE,6BAAA;EAjHF;EAoHA;IACE,oCAAA;IACA,gDAAA;EAlHF;EAqHA;IACE,oCAAA;IACA,qCAAA;EAnHF;EAqHE;IACE,qCAAA;IACA,qCAAA;EAnHJ;EAsHE;IACE,mCAAA;IACA,gDAAA;EApHJ;AACF;AAyHA;;EAEE,cAAA;AAvHF;AAyHE;;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,mBAAA;AAtHJ;AAwHI;;EACE,eAAA;EACA,eAAA;EACA,cAAA;AArHN;AAwHI;;EACE,OAAA;AArHN;AAuHM;;EACE,iBAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;AApHR;AAuHM;;EACE,SAAA;EACA,eAAA;EACA,8BAAA;EACA,gBAAA;AApHR;AAyHE;;EACE,aAAA;EACA,2BAAA;AAtHJ;AAwHI;;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;EACA,gBAAA;AArHN;;AA2HE;EACE,qBAAA;EACA,+CAAA;AAxHJ;;AA6HE;EACE,qBAAA;EACA,+CAAA;AA1HJ;;AA+HA;EACE,8BAAA;EACA,iBAAA;EACA,gBAAA;AA5HF;;AA+HA;EACE,mBAAA;AA5HF;AA8HE;EACE,qBAAA;EACA,+CAAA;EACA,yCAAA;AA5HJ;AA+HE;EACE,aAAA;EACA,uBAAA;EACA,SAAA;AA7HJ;AA+HI;EACE,eAAA;EACA,eAAA;EACA,cAAA;AA7HN;AAgII;EACE,OAAA;AA9HN;AAgIM;EACE,cAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,kBAAA;AA9HR;AAiIM;EACE,SAAA;EACA,eAAA;EACA,8BAAA;EACA,gBAAA;AA/HR;;AAsIA;EACE;IACE,2BAAA;IACA,0BAAA;EAnIF;AACF;AAuIA;EACE;IACE,iBAAA;EArIF;EAwIA;IACE,wBAAA;EAtIF;EAyIA;IACE,gBAAA;EAvIF;AACF;AA2IA;EACE,cAAA;AAzIF;AA2IE;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AAzIJ;AA2II;EACE,qBAAA;EACA,4CAAA;AAzIN;AA2IM;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;AAzIR;AA2IQ;EACE,eAAA;AAzIV;;AAgJA;EACE,gBAAA;AA7IF;;AAgJA;EACE,gBAAA;EACA,kBAAA;EACA,wCAAA;AA7IF;;AAgJA;EACE,WAAA;EACA,yBAAA;EACA,gBAAA;AA7IF;AA+IE;EACE,wCAAA;EACA,+BAAA;EACA,gBAAA;EACA,iBAAA;EACA,kBAAA;EACA,gDAAA;EACA,kBAAA;EACA,mBAAA;AA7IJ;AAgJE;EACE,iBAAA;EACA,qDAAA;EACA,kBAAA;EACA,kBAAA;AA9IJ;AAgJI;EACE,gBAAA;AA9IN;AAgJM;EACE,aAAA;EACA,mBAAA;EACA,QAAA;AA9IR;AAgJQ;EACE,eAAA;EACA,cAAA;AA9IV;AAiJQ;EACE,gBAAA;EACA,4BAAA;AA/IV;AAqJM;EACE,eAAA;EACA,gBAAA;EACA,gBAAA;EACA,mBAAA;AAnJR;AAsJM;EACE,8BAAA;EACA,kBAAA;EACA,iBAAA;AApJR;AAwJI;EACE,gBAAA;EACA,4BAAA;EACA,mBAAA;AAtJN;AAyJI;EACE,gBAAA;EACA,+BAAA;AAvJN;AA2JM;EACE,SAAA;AAzJR;AA8JE;EACE,6CAAA;AA5JJ;AA+JE;EACE,mBAAA;AA7JJ;;AAkKA;EACE;IACE,cAAA;EA/JF;EAmKM;IACE,eAAA;EAjKR;EAmKQ;IACE,eAAA;EAjKV;EAwKA;IACE,kBAAA;EAtKF;EAyKA;IACE,gBAAA;EAvKF;EAyKE;IACE,gBAAA;IACA,iBAAA;EAvKJ;EA0KE;IACE,gBAAA;IACA,kBAAA;EAxKJ;EA2KM;IACE,QAAA;EAzKR;EA2KQ;IACE,eAAA;EAzKV;EA4KQ;IACE,iBAAA;EA1KV;EAgLM;IACE,cAAA;IACA,gBAAA;EA9KR;EAiLM;IACE,iBAAA;EA/KR;EAmLI;IACE,iBAAA;EAjLN;EAoLI;IACE,iBAAA;EAlLN;EAsLM;IACE,oBAAA;IACA,kBAAA;EApLR;EAsLQ;IACE,eAAA;EApLV;AACF;AA4LA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,aAAA;EACA,oCAAA;EACA,kBAAA;EACA,gBAAA;AA1LF;AA4LE;EACE,eAAA;EACA,cAAA;EACA,8BAAA;AA1LJ;AA6LE;EACE,SAAA;EACA,8BAAA;EACA,eAAA;EACA,gBAAA;EACA,kBAAA;AA3LJ;;AAgMA;EAEI;IACE,uCAAA;IACA,6CAAA;EA9LJ;EAkMA;IACE,6CAAA;EAhMF;EAmMA;IACE,qCAAA;IACA,uCAAA;EAjMF;EAmME;IACE,oCAAA;IACA,qCAAA;EAjMJ;EAqMA;IACE,sFAAA;EAnMF;AACF","sourcesContent":["// Child Add Form Styles - Following Woman Add-Edit Design Patterns\n\n// Container styling\n.child-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n.card-container {\n  max-width: 1200px;\n  margin: 0 auto;\n  margin-top: 20px;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0;\n}\n\n// Section header\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  \n  ion-icon {\n    font-size: 24px;\n  }\n}\n\n// Form styling\n.child-form {\n  .form-section {\n    margin-bottom: 32px;\n    \n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n  \n  .section-subtitle {\n    display: flex;\n    align-items: center;\n    gap: 8px;\n    font-size: 16px;\n    font-weight: 600;\n    margin: 0 0 16px 0;\n    color: var(--ion-color-dark);\n    padding: 8px 0;\n    border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n    \n    ion-icon {\n      font-size: 20px;\n    }\n  }\n  \n  .form-item {\n    margin-bottom: 16px;\n    border-radius: 8px;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n    \n    ion-label {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n    }\n    \n    ion-note {\n      font-size: 12px;\n      margin-top: 4px;\n      \n      &[slot=\"helper\"] {\n        color: var(--ion-color-medium);\n      }\n      \n      &[slot=\"error\"] {\n        color: var(--ion-color-danger);\n      }\n    }\n    \n    // Auto-filled item styling\n    &.auto-filled-item {\n      background: rgba(45, 211, 111, 0.05);\n      border-color: rgba(45, 211, 111, 0.2);\n      \n      .auto-filled-input {\n        --color: var(--ion-color-success-shade);\n        font-weight: 500;\n      }\n      \n      ion-label {\n        color: var(--ion-color-success) !important;\n        font-weight: 600;\n      }\n    }\n  }\n}\n\n// FCN Search Section styling\n.fcn-search-section {\n  display: flex;\n  flex-direction: column;\n  gap: 12px;\n  margin-bottom: 16px;\n\n  ion-button {\n    align-self: flex-start;\n    margin: 0;\n\n    &[disabled] {\n      opacity: 0.5;\n    }\n  }\n}\n\n// Mother Selection Section styling\n.mother-selection-section {\n  margin: 16px 0;\n  padding: 16px;\n  background: rgba(73, 144, 226, 0.05);\n  border-radius: 12px;\n  border: 1px solid rgba(73, 144, 226, 0.2);\n\n  .form-item {\n    margin-bottom: 12px;\n    border-radius: 8px;\n    border: 1px solid rgba(73, 144, 226, 0.3);\n    background: rgba(255, 255, 255, 0.8);\n\n    ion-label {\n      color: var(--ion-color-primary);\n      font-weight: 600;\n    }\n\n    ion-select {\n      --padding-start: 8px;\n      --padding-end: 8px;\n      color: var(--ion-color-dark);\n      font-weight: 500;\n\n      &[placeholder] {\n        color: var(--ion-color-medium);\n      }\n    }\n  }\n\n  .info-tip {\n    background: rgba(255, 193, 7, 0.1);\n    border-left-color: var(--ion-color-warning);\n    margin-bottom: 0;\n\n    span {\n      color: var(--ion-color-warning-shade);\n    }\n  }\n}\n\n// Mother Information Card styling\n.mother-info-card {\n  margin: 16px 0;\n  \n  .mother-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n  }\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n  \n  ion-row {\n    margin: 0;\n  }\n  \n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n    \n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n    \n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n\n.mother-info-card .info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n  \n  &:last-child {\n    margin-bottom: 0;\n  }\n  \n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n  \n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px; // Align with first line of text\n  }\n}\n\n.mother-info-card .item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0; // Prevents text overflow\n  text-align: left;\n  \n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n  \n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n    \n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n  }\n}\n\n// Info tip styling\n.info-tip {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  padding: 12px 16px;\n  background: rgba(73, 144, 226, 0.1);\n  border-radius: 8px;\n  margin-bottom: 16px;\n  border-left: 4px solid var(--ion-color-primary);\n  \n  ion-icon {\n    font-size: 18px;\n  }\n  \n  span {\n    color: var(--ion-color-primary-shade);\n    font-size: 14px;\n    font-weight: 500;\n  }\n}\n\n// Action buttons\n.form-actions {\n  display: flex;\n  gap: 12px;\n  margin-top: 24px;\n  justify-content: flex-end;\n  flex-wrap: wrap;\n  \n  .submit-btn {\n    min-width: 180px;\n    \n    &[disabled] {\n      opacity: 0.5;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Loading container\n.loading-container {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  padding: 60px 20px;\n  text-align: center;\n  \n  ion-spinner {\n    margin-bottom: 16px;\n    width: 32px;\n    height: 32px;\n  }\n  \n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n  }\n}\n\n// Input field enhancements\nion-input {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  \n  &[readonly] {\n    --color: var(--ion-color-success-shade);\n    font-weight: 500;\n    cursor: default;\n  }\n}\n\nion-select, ion-datetime {\n  --padding-start: 8px;\n  --padding-end: 8px;\n}\n\n// Form validation styling\nion-item.ng-invalid.ng-touched {\n  border-color: var(--ion-color-danger);\n  \n  ion-label {\n    color: var(--ion-color-danger);\n  }\n}\n\nion-item.ng-valid.ng-touched {\n  border-color: var(--ion-color-success);\n}\n\n// Button states\nion-button {\n  font-weight: 500;\n  \n  &[disabled] {\n    --opacity: 0.4;\n    pointer-events: none;\n  }\n}\n\n// Enhanced visual indicators for headers\n.section-header .section-title {\n  position: relative;\n  \n  &::after {\n    content: '';\n    position: absolute;\n    bottom: -4px;\n    left: 0;\n    right: 0;\n    height: 2px;\n    background: linear-gradient(90deg, var(--ion-color-primary), transparent);\n    border-radius: 1px;\n  }\n}\n\n// Radio button styling\n.radio-item {\n  --padding-start: 0;\n  --inner-padding-end: 0;\n  margin-bottom: 8px;\n  \n  ion-radio {\n    margin-right: 12px;\n  }\n  \n  ion-label {\n    font-size: 16px;\n    color: var(--ion-color-dark);\n  }\n}\n\nion-radio-group {\n  display: flex;\n  flex-direction: column;\n  gap: 4px;\n  margin-top: 8px;\n}\n\n// Tablet optimized layout\n@media (min-width: 768px) {\n  .child-container {\n    margin-top: 24px;\n  }\n\n  .card-container {\n    margin-top: 24px;\n  }\n  \n  .section-title {\n    font-size: 24px;\n    \n    ion-icon {\n      font-size: 28px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .form-actions {\n    margin-top: 32px;\n    \n    .submit-btn {\n      min-width: 200px;\n    }\n  }\n  \n  .loading-container {\n    padding: 80px 40px;\n    \n    ion-spinner {\n      width: 40px;\n      height: 40px;\n    }\n    \n    p {\n      font-size: 16px;\n    }\n  }\n  \n  .fcn-search-section {\n    flex-direction: row;\n    align-items: flex-end;\n    gap: 16px;\n    \n    .form-item {\n      flex: 1;\n      margin-bottom: 0;\n    }\n    \n    ion-button {\n      margin-bottom: 0;\n      white-space: nowrap;\n    }\n  }\n}\n\n// Mobile responsive design\n@media (max-width: 767px) {\n  .section-title {\n    font-size: 18px;\n    \n    ion-icon {\n      font-size: 22px;\n    }\n  }\n  \n  .section-subtitle {\n    font-size: 14px;\n    \n    ion-icon {\n      font-size: 18px;\n    }\n  }\n  \n  .form-actions {\n    flex-direction: column;\n    margin-top: 20px;\n    \n    .submit-btn {\n      width: 100%;\n      min-width: auto;\n    }\n  }\n  \n  .loading-container {\n    padding: 40px 16px;\n    \n    p {\n      font-size: 12px;\n    }\n  }\n  \n  .info-tip {\n    padding: 10px 12px;\n    \n    span {\n      font-size: 13px;\n    }\n  }\n  \n  .fcn-search-section {\n    ion-button {\n      width: 100%;\n      margin-top: 8px;\n    }\n  }\n\n  // Mother selection mobile adjustments\n  .mother-selection-section {\n    margin: 12px 0;\n    padding: 12px;\n\n    .form-item {\n      margin-bottom: 10px;\n    }\n\n    .info-tip {\n      padding: 10px 12px;\n\n      span {\n        font-size: 13px;\n      }\n    }\n  }\n  \n  // Mother card mobile adjustments\n  .mother-info-card {\n    margin: 12px 0;\n    \n    .profile-content {\n      padding: 16px;\n    }\n    \n    .content-grid {\n      ion-col {\n        padding: 0 3px;\n        \n        &:first-child {\n          padding-left: 0;\n          padding-right: 5px;\n        }\n        \n        &:last-child {\n          padding-right: 0;\n          padding-left: 5px;\n        }\n      }\n    }\n    \n    .info-item {\n      padding: 10px 6px;\n      gap: 10px;\n      margin-bottom: 6px;\n      \n      ion-icon {\n        font-size: 16px;\n        width: 18px;\n      }\n    }\n    \n    .item-content {\n      .label {\n        font-size: 10px;\n        letter-spacing: 0.3px;\n      }\n      \n      .value {\n        font-size: 13px;\n      }\n    }\n  }\n}\n\n// Dark mode support\n@media (prefers-color-scheme: dark) {\n  .form-item.auto-filled-item {\n    background: rgba(45, 211, 111, 0.08);\n    border-color: rgba(45, 211, 111, 0.3);\n  }\n  \n  .section-title,\n  .section-subtitle {\n    color: var(--ion-color-light);\n  }\n  \n  .info-tip {\n    background: rgba(73, 144, 226, 0.15);\n    border-left-color: var(--ion-color-primary-tint);\n  }\n\n  .mother-selection-section {\n    background: rgba(73, 144, 226, 0.08);\n    border-color: rgba(73, 144, 226, 0.3);\n\n    .form-item {\n      background: rgba(255, 255, 255, 0.05);\n      border-color: rgba(73, 144, 226, 0.4);\n    }\n\n    .info-tip {\n      background: rgba(255, 193, 7, 0.15);\n      border-left-color: var(--ion-color-warning-tint);\n    }\n  }\n}\n\n// Alert components styling\n.no-mother-alert,\n.fcn-required-alert {\n  margin: 16px 0;\n  \n  .alert-content {\n    display: flex;\n    align-items: flex-start;\n    gap: 12px;\n    margin-bottom: 16px;\n    \n    ion-icon {\n      font-size: 24px;\n      margin-top: 2px;\n      flex-shrink: 0;\n    }\n    \n    .alert-text {\n      flex: 1;\n      \n      h4 {\n        margin: 0 0 8px 0;\n        font-size: 16px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n      }\n      \n      p {\n        margin: 0;\n        font-size: 14px;\n        color: var(--ion-color-medium);\n        line-height: 1.4;\n      }\n    }\n  }\n  \n  .alert-actions {\n    display: flex;\n    justify-content: flex-start;\n    \n    ion-button {\n      --padding-start: 16px;\n      --padding-end: 16px;\n      --padding-top: 12px;\n      --padding-bottom: 12px;\n      font-weight: 500;\n    }\n  }\n}\n\n.no-mother-alert {\n  ion-card {\n    --background: #fff8e1;\n    border-left: 4px solid var(--ion-color-warning);\n  }\n}\n\n.fcn-required-alert {\n  ion-card {\n    --background: #f8f9fa;\n    border-left: 4px solid var(--ion-color-primary);\n  }\n}\n\n// Required indicator and dependency notice styling\n.required-indicator {\n  color: var(--ion-color-danger);\n  font-weight: bold;\n  margin-left: 4px;\n}\n\n.dependency-notice {\n  margin-bottom: 16px;\n  \n  ion-card {\n    --background: #f8f9fa;\n    border-left: 4px solid var(--ion-color-primary);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);\n  }\n  \n  .notice-content {\n    display: flex;\n    align-items: flex-start;\n    gap: 12px;\n    \n    ion-icon {\n      font-size: 20px;\n      margin-top: 2px;\n      flex-shrink: 0;\n    }\n    \n    .notice-text {\n      flex: 1;\n      \n      strong {\n        display: block;\n        font-size: 14px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n        margin-bottom: 4px;\n      }\n      \n      p {\n        margin: 0;\n        font-size: 13px;\n        color: var(--ion-color-medium);\n        line-height: 1.4;\n      }\n    }\n  }\n}\n\n// Accessibility improvements\n@media (prefers-reduced-motion: reduce) {\n  * {\n    transition: none !important;\n    animation: none !important;\n  }\n}\n\n// High contrast mode\n@media (prefers-contrast: high) {\n  .form-item {\n    border-width: 2px;\n  }\n  \n  .section-subtitle {\n    border-bottom-width: 3px;\n  }\n  \n  ion-label {\n    font-weight: 600;\n  }\n}\n\n// Siblings Information Card styling\n.siblings-info-card {\n  margin: 16px 0;\n\n  .siblings-card {\n    border-radius: 12px;\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n    overflow: hidden;\n    margin: 0;\n    border: 1px solid rgba(0, 0, 0, 0.08);\n\n    ion-card-header {\n      --background: #f8f9fa;\n      border-bottom: 1px solid rgba(0, 0, 0, 0.06);\n\n      ion-card-title {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n        font-size: 16px;\n        font-weight: 600;\n        color: var(--ion-color-dark);\n\n        ion-icon {\n          font-size: 20px;\n        }\n      }\n    }\n  }\n}\n\n.siblings-section {\n  margin-top: 1rem;\n}\n\n.siblings-table-container {\n  overflow-x: auto;\n  border-radius: 6px;\n  border: 1px solid var(--ion-color-light);\n}\n\n.siblings-table {\n  width: 100%;\n  border-collapse: collapse;\n  min-width: 550px;\n\n  th {\n    background-color: var(--ion-color-light);\n    color: var(--ion-color-primary);\n    font-weight: 600;\n    padding: 10px 8px;\n    text-align: center;\n    border-bottom: 1px solid var(--ion-color-medium);\n    font-size: 0.85rem;\n    white-space: nowrap;\n  }\n\n  td {\n    padding: 10px 8px;\n    border-bottom: 1px solid var(--ion-color-light-shade);\n    font-size: 0.85rem;\n    text-align: center;\n\n    &.sibling-name {\n      text-align: left;\n\n      .name-content {\n        display: flex;\n        align-items: center;\n        gap: 8px;\n\n        ion-icon {\n          font-size: 18px;\n          flex-shrink: 0;\n        }\n\n        span {\n          font-weight: 500;\n          color: var(--ion-color-dark);\n        }\n      }\n    }\n\n    &.sibling-gender {\n      .gender-badge {\n        font-size: 11px;\n        font-weight: 600;\n        padding: 4px 8px;\n        border-radius: 12px;\n      }\n\n      .no-gender {\n        color: var(--ion-color-medium);\n        font-style: italic;\n        font-size: 0.8rem;\n      }\n    }\n\n    &.sibling-dob {\n      font-weight: 500;\n      color: var(--ion-color-dark);\n      white-space: nowrap;\n    }\n\n    &.sibling-progress-id {\n      font-weight: 500;\n      color: var(--ion-color-primary);\n    }\n\n    &.actions-cell {\n      ion-button {\n        margin: 0;\n      }\n    }\n  }\n\n  tbody tr:hover {\n    background-color: var(--ion-color-light-tint);\n  }\n\n  tbody tr:last-child td {\n    border-bottom: none;\n  }\n}\n\n// Mobile responsive design for siblings section\n@media (max-width: 767px) {\n  .siblings-info-card {\n    margin: 12px 0;\n\n    .siblings-card {\n      ion-card-header {\n        ion-card-title {\n          font-size: 14px;\n\n          ion-icon {\n            font-size: 18px;\n          }\n        }\n      }\n    }\n  }\n\n  .siblings-table-container {\n    border-radius: 4px;\n  }\n\n  .siblings-table {\n    min-width: 480px;\n\n    th {\n      padding: 8px 4px;\n      font-size: 0.7rem;\n    }\n\n    td {\n      padding: 8px 4px;\n      font-size: 0.75rem;\n\n      &.sibling-name {\n        .name-content {\n          gap: 6px;\n\n          ion-icon {\n            font-size: 16px;\n          }\n\n          span {\n            font-size: 0.7rem;\n          }\n        }\n      }\n\n      &.sibling-gender {\n        .gender-badge {\n          font-size: 9px;\n          padding: 2px 4px;\n        }\n\n        .no-gender {\n          font-size: 0.7rem;\n        }\n      }\n\n      &.sibling-dob {\n        font-size: 0.7rem;\n      }\n\n      &.sibling-progress-id {\n        font-size: 0.7rem;\n      }\n\n      &.actions-cell {\n        ion-button {\n          --padding-start: 4px;\n          --padding-end: 4px;\n\n          ion-icon {\n            font-size: 14px;\n          }\n        }\n      }\n    }\n  }\n}\n\n// No siblings message styling\n.no-siblings-message {\n  display: flex;\n  align-items: center;\n  gap: 12px;\n  padding: 16px;\n  background: rgba(108, 117, 125, 0.1);\n  border-radius: 8px;\n  text-align: left;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n    color: var(--ion-color-medium);\n  }\n\n  p {\n    margin: 0;\n    color: var(--ion-color-medium);\n    font-size: 14px;\n    line-height: 1.4;\n    font-style: italic;\n  }\n}\n\n// Dark mode support for siblings section\n@media (prefers-color-scheme: dark) {\n  .siblings-card {\n    ion-card-header {\n      --background: rgba(255, 255, 255, 0.05);\n      border-bottom-color: rgba(255, 255, 255, 0.1);\n    }\n  }\n  \n  .sibling-header {\n    border-bottom-color: rgba(255, 255, 255, 0.1);\n  }\n  \n  .sibling-detail-item {\n    background: rgba(255, 255, 255, 0.03);\n    border-color: rgba(255, 255, 255, 0.08);\n    \n    &:hover {\n      background: rgba(73, 144, 226, 0.08);\n      border-color: rgba(73, 144, 226, 0.3);\n    }\n  }\n  \n  .sibling-divider {\n    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 49867:
/*!**************************************************************************!*\
  !*** ./src/app/pages/child-add-edit/child-add-edit.page.html?ngResource ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{isEditMode ? 'Edit Child' : 'Add Child'}}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n  <div *ngIf=\"beneficiaryRegPreqData || isEditMode; else loading\" class=\"child-container\">\n    <!-- Header Section -->\n    <div class=\"section-header\">\n      <h2 class=\"section-title\">\n        <ion-icon name=\"{{isEditMode ? 'create-outline' : 'person-add-outline'}}\" color=\"primary\"></ion-icon>\n        {{isEditMode ? 'Edit Child Information' : 'Add New Child'}}\n      </h2>\n    </div>\n\n    <!-- Form Card -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <form [formGroup]=\"registerFrom\" (ngSubmit)=\"submit(registerFrom)\" class=\"child-form\">\n\n            <!-- FCN Search Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"search-outline\" color=\"primary\"></ion-icon>\n                Search Mother Information\n                <span class=\"required-indicator\" *ngIf=\"!isEditMode\">*</span>\n              </h3>\n\n              <!-- FCN Dependency Notice -->\n              <div class=\"dependency-notice\" *ngIf=\"!isEditMode\">\n                <ion-card color=\"light\">\n                  <ion-card-content>\n                    <div class=\"notice-content\">\n                      <ion-icon name=\"link-outline\" color=\"primary\"></ion-icon>\n                      <div class=\"notice-text\">\n                        <strong>Mother Dependency Required</strong>\n                        <p>Child registration requires mother information. Please search using FCN first.</p>\n                      </div>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n\n              <!-- FCN Search Section -->\n              <div class=\"fcn-search-section\">\n                <!-- FCN Input - Read-only in edit mode -->\n                <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('fcn')\">\n                  <ion-icon slot=\"start\" name=\"document-text-outline\" [color]=\"isFieldInvalid('fcn') ? 'danger' : 'primary'\"></ion-icon>\n                  <ion-label position=\"stacked\">Family Count Number (FCN) *</ion-label>\n                  <ion-input formControlName=\"fcn\" placeholder=\"Enter FCN number\"></ion-input>\n                  <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('fcn')\">\n                    {{getFieldErrorMessage('fcn')}}\n                  </ion-note>\n                </ion-item>\n\n                <!-- Search Button - Required in both add and edit modes -->\n                <ion-button fill=\"outline\" color=\"primary\" (click)=\"searchChildrenByFcn()\" [disabled]=\"!registerFrom.get('fcn')?.value || fcnSearchLoading\">\n                  <ion-spinner *ngIf=\"fcnSearchLoading\" name=\"crescent\"></ion-spinner>\n                  <ion-icon *ngIf=\"!fcnSearchLoading\" name=\"search\" slot=\"start\"></ion-icon>\n                  {{fcnSearchLoading ? 'Searching...' : (isEditMode ? 'Search Mother Details' : 'Search Mother by FCN')}}\n                </ion-button>\n              </div>\n\n              <!-- Mother Selection Dropdown - Show when multiple mothers found -->\n              <div class=\"mother-selection-section\" *ngIf=\"showMotherDropdown && mothersFound.length > 1\">\n                <ion-item class=\"form-item\">\n                  <ion-icon slot=\"start\" name=\"people-outline\" color=\"primary\"></ion-icon>\n                  <ion-label position=\"stacked\">Select Mother *</ion-label>\n                  <ion-select [(ngModel)]=\"selectedMotherId\" [ngModelOptions]=\"{standalone: true}\" (ionChange)=\"onMotherSelected()\" interface=\"action-sheet\" placeholder=\"Choose from {{mothersFound.length}} mothers found\">\n                    <ion-select-option *ngFor=\"let mother of mothersFound\" [value]=\"mother.id\">\n                      {{mother.name}} - {{mother.husband}} (Block: {{mother.current_location?.block_majhi?.block?.title || 'N/A'}}, HH: {{mother.current_location?.hh_no || 'N/A'}})\n                    </ion-select-option>\n                  </ion-select>\n                </ion-item>\n\n                <!-- Selection Help Text -->\n                <div class=\"info-tip\" *ngIf=\"!selectedMotherId\">\n                  <ion-icon name=\"information-circle\" color=\"warning\"></ion-icon>\n                  <span>Multiple mothers found with the same FCN. Please select the correct mother to continue.</span>\n                </div>\n              </div>\n\n\n              <!-- Mother Information Card -->\n              <div class=\"mother-info-card\" *ngIf=\"motherInfo\">\n                <ion-card class=\"mother-card\">\n                  <!-- Card Content -->\n                  <div class=\"profile-content\">\n                    <ion-grid class=\"content-grid\">\n                      <ion-row>\n                        <!-- Left Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Mother Name</span>\n                              <span class=\"value\">{{ motherInfo.name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"people-circle-outline\" color=\"secondary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Caregiver</span>\n                              <span class=\"value\">{{ motherInfo.caregiver_name || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"home-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Household</span>\n                              <span class=\"value\">{{ motherInfo.current_location?.hh_no || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\" *ngIf=\"motherInfo.current_location?.sub_block_sub_majhi\">\n                            <ion-icon name=\"grid-outline\" color=\"success\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Sub Block</span>\n                              <span class=\"value\">{{ motherInfo.current_location?.sub_block_sub_majhi?.sub_block_title || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n\n                        <!-- Right Column -->\n                        <ion-col size=\"6\">\n                          <div class=\"info-item\">\n                            <ion-icon name=\"man-outline\" color=\"primary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Father (Husband)</span>\n                              <span class=\"value\">{{ motherInfo.husband || '-' }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"business-outline\" color=\"tertiary\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Block</span>\n                              <span class=\"value\">{{ motherInfo.current_location?.block_majhi?.block?.title }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\">\n                            <ion-icon name=\"person-outline\" color=\"warning\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Block Majhi</span>\n                              <span class=\"value\">{{ motherInfo.current_location?.block_majhi?.majhi_title }}</span>\n                            </div>\n                          </div>\n\n                          <div class=\"info-item\" *ngIf=\"motherInfo.current_location?.sub_block_sub_majhi\">\n                            <ion-icon name=\"person-outline\" color=\"warning\"></ion-icon>\n                            <div class=\"item-content\">\n                              <span class=\"label\">Sub Block Majhi</span>\n                              <span class=\"value\">{{ motherInfo.current_location?.sub_block_sub_majhi?.sub_block_majhi || '-' }}</span>\n                            </div>\n                          </div>\n                        </ion-col>\n                      </ion-row>\n                    </ion-grid>\n                  </div>\n                </ion-card>\n              </div>\n\n              <!-- Siblings Information Card -->\n              <div class=\"siblings-info-card\" *ngIf=\"motherInfo && motherInfo.childrens && motherInfo.childrens.length > 0\">\n                <ion-card class=\"siblings-card\">\n                  <ion-card-header>\n                    <ion-card-title>\n                      <ion-icon name=\"people-outline\" color=\"primary\"></ion-icon>\n                      Siblings Information ({{motherInfo.childrens.length}})\n                    </ion-card-title>\n                  </ion-card-header>\n                  <ion-card-content>\n                    <div class=\"siblings-section\">\n                      <div class=\"siblings-table-container\">\n                        <table class=\"siblings-table\">\n                          <thead>\n                            <tr>\n                              <th>Name</th>\n                              <th>Gender</th>\n                              <th>Date of Birth</th>\n                              <th>Progress ID</th>\n                              <th>Actions</th>\n                            </tr>\n                          </thead>\n                          <tbody>\n                            <tr *ngFor=\"let sibling of motherInfo.childrens\">\n                              <td class=\"sibling-name\">\n                                <div class=\"name-content\">\n                                  <ion-icon name=\"person-circle-outline\" [color]=\"sibling.gender === 'Male' ? 'primary' : sibling.gender === 'Female' ? 'secondary' : 'tertiary'\"></ion-icon>\n                                  <span>{{sibling.name || '-'}}</span>\n                                </div>\n                              </td>\n                              <td class=\"sibling-gender\">\n                                <ion-badge\n                                  *ngIf=\"sibling.gender === 'Male' || sibling.gender === 'Female'\"\n                                  [color]=\"sibling.gender === 'Male' ? 'primary' : 'secondary'\"\n                                  class=\"gender-badge\">\n                                  {{sibling.gender}}\n                                </ion-badge>\n                                <span *ngIf=\"sibling.gender !== 'Male' && sibling.gender !== 'Female'\" class=\"no-gender\">{{sibling.gender || '-'}}</span>\n                              </td>\n                              <td class=\"sibling-dob\">\n                                <span>{{sibling.date_of_birth | date:'dd MMM yyyy' || '-'}}</span>\n                              </td>\n                              <td class=\"sibling-progress-id\">{{sibling.progress_id || '-'}}</td>\n                              <td class=\"actions-cell\">\n                                <ion-button\n                                  fill=\"clear\"\n                                  size=\"small\"\n                                  (click)=\"viewChildDetail(sibling.id)\"\n                                  color=\"primary\"\n                                  title=\"View child details\">\n                                  <ion-icon name=\"eye-outline\" slot=\"icon-only\"></ion-icon>\n                                </ion-button>\n                              </td>\n                            </tr>\n                          </tbody>\n                        </table>\n                      </div>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n\n              <!-- No Siblings Information Card -->\n              <div class=\"siblings-info-card\" *ngIf=\"motherInfo && (!motherInfo.childrens || motherInfo.childrens.length === 0)\">\n                <ion-card class=\"siblings-card\">\n                  <ion-card-header>\n                    <ion-card-title>\n                      <ion-icon name=\"people-outline\" color=\"medium\"></ion-icon>\n                      Siblings Information\n                    </ion-card-title>\n                  </ion-card-header>\n                  <ion-card-content>\n                    <div class=\"no-siblings-message\">\n                      <ion-icon name=\"information-circle-outline\" color=\"medium\"></ion-icon>\n                      <p>No siblings found for this mother. This will be the first child.</p>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n\n              <!-- No Mother Found Alert -->\n              <div class=\"no-mother-alert\" *ngIf=\"!isEditMode && fcnSearchAttempted && noMotherFound\">\n                <ion-card color=\"warning\">\n                  <ion-card-content>\n                    <div class=\"alert-content\">\n                      <ion-icon name=\"warning-outline\" color=\"warning\"></ion-icon>\n                      <div class=\"alert-text\">\n                        <h4>Mother Not Found</h4>\n                        <p>No mother found with the provided FCN. You need to add the mother first before adding a child.</p>\n                      </div>\n                    </div>\n                    <div class=\"alert-actions\">\n                      <ion-button fill=\"solid\" color=\"primary\" (click)=\"navigateToAddMother()\">\n                        <ion-icon name=\"person-add-outline\" slot=\"start\"></ion-icon>\n                        Add Mother First\n                      </ion-button>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n\n              <!-- FCN Search Required Alert -->\n              <div class=\"fcn-required-alert\" *ngIf=\"!isEditMode && !fcnSearchAttempted && registerFrom.get('fcn')?.value\">\n                <ion-card color=\"light\">\n                  <ion-card-content>\n                    <div class=\"alert-content\">\n                      <ion-icon name=\"information-circle-outline\" color=\"primary\"></ion-icon>\n                      <div class=\"alert-text\">\n                        <h4>Search Required</h4>\n                        <p>Please search for mother information using FCN before proceeding.</p>\n                      </div>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n            </div>\n\n            <!-- Family Information Section -->\n            <div class=\"form-section\" *ngIf=\"motherInfo && !isEditMode\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"people-outline\" color=\"primary\"></ion-icon>\n                Family Information\n              </h3>\n\n              <ion-item class=\"form-item auto-filled-item\">\n                <ion-icon slot=\"start\" name=\"woman-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Mother's Name</ion-label>\n                <ion-input formControlName=\"mother\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item auto-filled-item\">\n                <ion-icon slot=\"start\" name=\"man-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Father's Name</ion-label>\n                <ion-input formControlName=\"father\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n            </div>\n\n            <!-- Child Information Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"person-outline\" color=\"primary\"></ion-icon>\n                Child Information\n              </h3>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('name')\">\n                <ion-icon slot=\"start\" name=\"person\" [color]=\"isFieldInvalid('name') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Child Name *</ion-label>\n                <ion-input formControlName=\"name\" placeholder=\"Enter full name\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('name')\">\n                  {{getFieldErrorMessage('name')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('progress_id')\">\n                <ion-icon slot=\"start\" name=\"id-card-outline\" [color]=\"isFieldInvalid('progress_id') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Progress ID *</ion-label>\n                <ion-input formControlName=\"progress_id\" placeholder=\"Enter Progress ID\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('progress_id')\">\n                  {{getFieldErrorMessage('progress_id')}}\n                </ion-note>\n              </ion-item>\n\n              <!-- <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('scope_no')\">\n                <ion-icon slot=\"start\" name=\"document-outline\" [color]=\"isFieldInvalid('scope_no') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Scope ID</ion-label>\n                <ion-input formControlName=\"scope_no\" placeholder=\"Enter Scope ID (optional)\"></ion-input>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('scope_no')\">\n                  {{getFieldErrorMessage('scope_no')}}\n                </ion-note>\n              </ion-item> -->\n            </div>\n\n            <!-- Age & Personal Details Section -->\n            <div class=\"form-section\">\n              <h3 class=\"section-subtitle\">\n                <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                Age & Personal Details\n              </h3>\n\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('date_of_birth')\">\n                <ion-icon slot=\"start\" name=\"calendar\" [color]=\"isFieldInvalid('date_of_birth') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Date of Birth **</ion-label>\n                <ion-input formControlName=\"date_of_birth\" type=\"date\" [max]=\"today\" placeholder=\"Select date\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\">Enter date of birth to calculate age automatically</ion-note>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('date_of_birth')\">\n                  {{getFieldErrorMessage('date_of_birth')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('birth_weight')\">\n                <ion-icon slot=\"start\" name=\"scale-outline\" [color]=\"isFieldInvalid('birth_weight') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Birth Weight (kg) *</ion-label>\n                <ion-input formControlName=\"birth_weight\" type=\"number\" step=\"0.01\" placeholder=\"Enter birth weight (e.g., 3.25)\"></ion-input>\n                <ion-note slot=\"helper\" color=\"medium\">Enter weight in kilograms with up to 2 decimal places</ion-note>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('birth_weight')\">\n                  {{getFieldErrorMessage('birth_weight')}}\n                </ion-note>\n              </ion-item>\n\n              <ion-item class=\"form-item auto-filled-item\" *ngIf=\"getFormFieldValue('age')\">\n                <ion-icon slot=\"start\" name=\"time-outline\" color=\"success\"></ion-icon>\n                <ion-label position=\"stacked\">Calculated Age (in months)</ion-label>\n                <ion-input [value]=\"getFormFieldValue('age')\" readonly=\"true\" class=\"auto-filled-input\"></ion-input>\n              </ion-item>\n\n              <!-- Age/DOB Validation Message -->\n              <div class=\"age-dob-error\" *ngIf=\"isFieldInvalid('date_of_birth') && isFieldInvalid('age')\">\n                <ion-card color=\"danger\">\n                  <ion-card-content>\n                    <div class=\"error-content\">\n                      <ion-icon name=\"warning-outline\" color=\"light\"></ion-icon>\n                      <span>Either Date of Birth or Age is required</span>\n                    </div>\n                  </ion-card-content>\n                </ion-card>\n              </div>\n\n              <!-- Gender Selection -->\n              <ion-item class=\"form-item\" [class.ion-invalid]=\"isFieldInvalid('gender')\">\n                <ion-icon slot=\"start\" name=\"male-female-outline\" [color]=\"isFieldInvalid('gender') ? 'danger' : 'primary'\"></ion-icon>\n                <ion-label position=\"stacked\">Gender *</ion-label>\n                <ion-select interface=\"action-sheet\" formControlName=\"gender\" placeholder=\"Select gender\">\n                  <ion-select-option value=\"Male\">Male</ion-select-option>\n                  <ion-select-option value=\"Female\">Female</ion-select-option>\n                </ion-select>\n                <ion-note slot=\"error\" *ngIf=\"isFieldInvalid('gender')\">\n                  {{getFieldErrorMessage('gender')}}\n                </ion-note>\n              </ion-item>\n\n\n              <!-- <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"card-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">MNR/MRC Number</ion-label>\n                <ion-input formControlName=\"mnr_no\" placeholder=\"Enter MNR/MRC number\"></ion-input>\n              </ion-item>\n\n              <ion-item class=\"form-item\">\n                <ion-icon slot=\"start\" name=\"medical-outline\" color=\"primary\"></ion-icon>\n                <ion-label position=\"stacked\">MOHA ID</ion-label>\n                <ion-input formControlName=\"moha_id\" placeholder=\"Enter MOHA ID\"></ion-input>\n              </ion-item> -->\n            </div>\n\n            <!-- Action Buttons -->\n            <div class=\"form-actions\">\n              <ion-button type=\"submit\" color=\"success\" class=\"submit-btn\">\n                <ion-icon name=\"{{isEditMode ? 'save-outline' : 'save-outline'}}\" slot=\"start\"></ion-icon>\n                {{isEditMode ? 'Update Child Information' : 'Save Child Information'}}\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n  </div>\n\n  <ng-template #loading>\n    <div class=\"child-container\">\n      <div class=\"loading-container\">\n        <ion-spinner color=\"primary\"></ion-spinner>\n        <p>Loading child form data...</p>\n      </div>\n    </div>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_child-add-edit_child-add-edit_module_ts.js.map