(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_account_account_module_ts"],{

/***/ 87191:
/*!*********************************************************!*\
  !*** ./src/app/pages/account/account-routing.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountPageRoutingModule: () => (/* binding */ AccountPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _account_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account.page */ 2585);




const routes = [{
  path: '',
  component: _account_page__WEBPACK_IMPORTED_MODULE_0__.AccountPage
}];
let AccountPageRoutingModule = class AccountPageRoutingModule {};
AccountPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AccountPageRoutingModule);


/***/ }),

/***/ 88422:
/*!*************************************************!*\
  !*** ./src/app/pages/account/account.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountPageModule: () => (/* binding */ AccountPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/components/shared.module */ 47774);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _account_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account-routing.module */ 87191);
/* harmony import */ var _account_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./account.page */ 2585);








let AccountPageModule = class AccountPageModule {};
AccountPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, src_app_components_shared_module__WEBPACK_IMPORTED_MODULE_0__.SharedModule, _account_routing_module__WEBPACK_IMPORTED_MODULE_1__.AccountPageRoutingModule],
  declarations: [_account_page__WEBPACK_IMPORTED_MODULE_2__.AccountPage]
})], AccountPageModule);


/***/ }),

/***/ 2585:
/*!***********************************************!*\
  !*** ./src/app/pages/account/account.page.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountPage: () => (/* binding */ AccountPage)
/* harmony export */ });
/* harmony import */ var _workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _account_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account.page.html?ngResource */ 74699);
/* harmony import */ var _account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./account.page.scss?ngResource */ 43263);
/* harmony import */ var _account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/util/baseHelper */ 76434);
/* harmony import */ var src_app_services_auth_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/services/auth_api.service */ 99723);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);

var _AccountPage;








let AccountPage = (_AccountPage = class AccountPage {
  constructor(b, authService, fb, loadingController) {
    var _this$b$getCurrentUse;
    this.b = b;
    this.authService = authService;
    this.fb = fb;
    this.loadingController = loadingController;
    this.showCurrentPassword = false;
    this.showNewPassword = false;
    this.showConfirmPassword = false;
    this.user = (_this$b$getCurrentUse = this.b.getCurrentUser()) === null || _this$b$getCurrentUse === void 0 ? void 0 : _this$b$getCurrentUse.user;
  }
  ngOnInit() {
    this.initPasswordForm();
  }
  initPasswordForm() {
    this.passwordForm = this.fb.group({
      current_password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      new_password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.minLength(8)]],
      new_password_confirmation: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]]
    }, {
      validators: this.passwordMatchValidator
    });
  }
  passwordMatchValidator(group) {
    var _group$get, _group$get2;
    const newPassword = (_group$get = group.get('new_password')) === null || _group$get === void 0 ? void 0 : _group$get.value;
    const confirmPassword = (_group$get2 = group.get('new_password_confirmation')) === null || _group$get2 === void 0 ? void 0 : _group$get2.value;
    return newPassword === confirmPassword ? null : {
      passwordMismatch: true
    };
  }
  onSubmitPasswordChange() {
    var _this = this;
    return (0,_workdir_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.passwordForm.invalid) {
        _this.b.errorToast('Please fill all fields correctly');
        return;
      }
      const loading = yield _this.loadingController.create({
        message: 'Changing password...'
      });
      yield loading.present();
      try {
        const result = yield _this.authService.changePassword(_this.passwordForm.value);
        if (result.success) {
          _this.b.toast(result.message || 'Password changed successfully', 5000, 'success');
          _this.passwordForm.reset();
        } else {
          _this.b.errorToast(result.message || 'Failed to change password');
        }
      } catch (error) {
        var _error$error;
        _this.b.errorToast((error === null || error === void 0 || (_error$error = error.error) === null || _error$error === void 0 ? void 0 : _error$error.message) || 'An error occurred');
      } finally {
        loading.dismiss();
      }
    })();
  }
}, _AccountPage.ctorParameters = () => [{
  type: src_app_util_baseHelper__WEBPACK_IMPORTED_MODULE_3__.BaseHelper
}, {
  type: src_app_services_auth_api_service__WEBPACK_IMPORTED_MODULE_4__.AuthAPIService
}, {
  type: _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormBuilder
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.LoadingController
}], _AccountPage);
AccountPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-account',
  template: _account_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AccountPage);


/***/ }),

/***/ 43263:
/*!************************************************************!*\
  !*** ./src/app/pages/account/account.page.scss?ngResource ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:root {
  --ion-color-primary: #4990E2;
  --ion-color-primary-rgb: 73, 144, 226;
  --ion-color-primary-contrast: #ffffff;
  --ion-color-secondary: #6D5AE6;
  --ion-color-secondary-rgb: 109, 90, 230;
  --ion-color-secondary-contrast: #ffffff;
  --ion-color-tertiary: #FF8A65;
  --ion-color-tertiary-rgb: 255, 138, 101;
  --ion-color-tertiary-contrast: #ffffff;
  --ion-color-light: #f4f5f8;
  --ion-color-medium: #92949c;
  --ion-color-dark: #222428;
}

ion-content {
  --padding-start: 16px;
  --padding-end: 16px;
  --padding-top: 20px;
  --padding-bottom: 20px;
}

.account-container {
  max-width: 800px;
  margin: 0 auto;
}

.card-container {
  max-width: 800px;
  margin: 0 auto 20px auto;
}

ion-card {
  border-radius: 16px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
  overflow: hidden;
  margin: 0 0 16px 0;
}

.section-header-main {
  max-width: 800px;
  margin: 0 auto 24px auto;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 16px;
  padding: 0 4px;
}

.section-title-main {
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  color: var(--ion-color-dark);
}
.section-title-main ion-icon {
  font-size: 28px;
  flex-shrink: 0;
}

.section-header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 16px;
  padding: 0 4px;
  gap: 16px;
}

.section-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 20px;
  font-weight: 600;
  margin: 0;
  color: var(--ion-color-dark);
  flex: 1 1 auto;
  min-width: 0;
}
.section-title ion-icon {
  font-size: 24px;
  flex-shrink: 0;
}

.user-info-card {
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
  overflow: hidden;
  margin: 0;
  border: 1px solid rgba(0, 0, 0, 0.08);
}

.profile-content {
  padding: 20px;
}

.profile-header {
  display: flex;
  align-items: center;
  gap: 16px;
  margin-bottom: 24px;
  padding-bottom: 20px;
  border-bottom: 2px solid rgba(73, 144, 226, 0.1);
}

.profile-avatar {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  overflow: hidden;
  display: flex;
  justify-content: center;
  align-items: center;
  background-color: var(--ion-color-light);
}
.profile-avatar ion-icon {
  font-size: 80px; /* Adjust size as needed */
  color: var(--ion-color-primary);
}

.profile-info {
  flex: 1;
  min-width: 0;
}

.user-name {
  font-size: 24px;
  font-weight: 700;
  margin: 0 0 8px 0;
  color: var(--ion-color-dark);
  word-wrap: break-word;
}

.user-role {
  margin: 0;
}
.user-role ion-badge {
  font-size: 13px;
  padding: 6px 12px;
  font-weight: 600;
}

.content-grid {
  padding: 0;
  margin: 0;
}
.content-grid ion-row {
  margin: 0;
}
.content-grid ion-col {
  padding: 0 6px;
  display: flex;
  flex-direction: column;
}
.content-grid ion-col:first-child {
  padding-left: 0;
  padding-right: 8px;
}
.content-grid ion-col:last-child {
  padding-right: 0;
  padding-left: 8px;
}

.info-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  padding: 12px 8px;
  background: rgba(255, 255, 255, 0.8);
  border-radius: 6px;
  border: 1px solid rgba(0, 0, 0, 0.06);
  margin-bottom: 8px;
  transition: all 0.2s ease;
}
.info-item:last-child {
  margin-bottom: 0;
}
.info-item:hover {
  background: rgba(73, 144, 226, 0.04);
  border-color: rgba(73, 144, 226, 0.2);
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
}
.info-item ion-icon {
  font-size: 18px;
  flex-shrink: 0;
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 2px;
  margin-inline-end: 0 !important;
}

.item-content {
  display: flex;
  flex-direction: column;
  gap: 3px;
  flex: 1;
  min-width: 0;
  text-align: left;
}
.item-content .label {
  font-size: 11px;
  font-weight: 600;
  color: var(--ion-color-medium);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  line-height: 1.2;
  margin: 0;
  text-align: left;
}
.item-content .value {
  font-size: 14px;
  font-weight: 600;
  color: var(--ion-color-dark);
  line-height: 1.4;
  word-wrap: break-word;
  word-break: break-word;
  margin: 0;
  text-align: left;
  display: flex;
  align-items: center;
  flex-wrap: wrap;
  gap: 6px;
}
.item-content .value:empty::after {
  content: "-";
  color: var(--ion-color-medium);
  font-style: italic;
}
.item-content .value ion-badge {
  font-size: 11px;
  padding: 3px 8px;
}

.facility-list {
  padding: 0;
}

.facility-item {
  padding: 16px 0;
  border-bottom: 1px solid rgba(0, 0, 0, 0.08);
}
.facility-item:last-child, .facility-item.last-item {
  border-bottom: none;
  padding-bottom: 0;
}
.facility-item:first-child {
  padding-top: 0;
}

.facility-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 12px;
  gap: 12px;
}

.facility-title {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 16px;
  font-weight: 600;
  color: var(--ion-color-dark);
  margin: 0;
  flex: 1;
  min-width: 0;
}
.facility-title ion-icon {
  font-size: 18px;
  flex-shrink: 0;
}

.facility-details {
  display: flex;
  flex-direction: column;
  gap: 8px;
  padding-left: 26px;
}

.facility-detail {
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 13px;
  color: var(--ion-color-medium);
}
.facility-detail ion-icon {
  font-size: 16px;
  flex-shrink: 0;
}
.facility-detail span {
  color: var(--ion-color-dark);
}

@media (max-width: 768px) {
  ion-content {
    --padding-start: 12px;
    --padding-end: 12px;
    --padding-top: 16px;
    --padding-bottom: 16px;
  }
  .section-header-main {
    margin-bottom: 20px;
  }
  .section-title-main {
    font-size: 20px;
  }
  .section-title-main ion-icon {
    font-size: 24px;
  }
  .card-container {
    margin-bottom: 16px;
  }
  .profile-content {
    padding: 16px;
  }
  .content-grid ion-col {
    padding: 0 3px;
  }
  .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 5px;
  }
  .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 5px;
  }
  .info-item {
    padding: 10px 6px;
    gap: 10px;
    margin-bottom: 6px;
  }
  .info-item ion-icon {
    font-size: 16px;
    width: 18px;
  }
  .item-content .label {
    font-size: 10px;
    letter-spacing: 0.3px;
  }
  .item-content .value {
    font-size: 13px;
  }
  .user-name {
    font-size: 20px;
  }
  .profile-avatar {
    width: 70px;
    height: 70px;
  }
}
@media (max-width: 480px) {
  ion-content {
    --padding-start: 8px;
    --padding-end: 8px;
    --padding-top: 12px;
    --padding-bottom: 12px;
  }
  .section-header-main {
    margin-bottom: 16px;
  }
  .section-title-main {
    font-size: 18px;
  }
  .section-title-main ion-icon {
    font-size: 22px;
  }
  .card-container {
    margin-bottom: 12px;
  }
  .profile-content {
    padding: 12px;
  }
  .profile-header {
    flex-direction: column;
    text-align: center;
    align-items: center;
    margin-bottom: 16px;
    padding-bottom: 16px;
  }
  .profile-avatar {
    width: 60px;
    height: 60px;
  }
  .user-name {
    font-size: 18px;
    text-align: center;
  }
  .content-grid ion-col {
    padding: 0 2px;
  }
  .content-grid ion-col:first-child {
    padding-left: 0;
    padding-right: 4px;
  }
  .content-grid ion-col:last-child {
    padding-right: 0;
    padding-left: 4px;
  }
  .info-item {
    padding: 8px 4px;
    gap: 8px;
    margin-bottom: 5px;
  }
  .info-item ion-icon {
    font-size: 14px;
    width: 16px;
  }
  .item-content .label {
    font-size: 9px;
    letter-spacing: 0.2px;
  }
  .item-content .value {
    font-size: 12px;
  }
  .facility-header {
    flex-direction: column;
    align-items: flex-start;
    gap: 8px;
  }
  .facility-details {
    padding-left: 0;
    gap: 6px;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/account/account.page.scss"],"names":[],"mappings":"AAEA;EACE,4BAAA;EACA,qCAAA;EACA,qCAAA;EACA,8BAAA;EACA,uCAAA;EACA,uCAAA;EACA,6BAAA;EACA,uCAAA;EACA,sCAAA;EACA,0BAAA;EACA,2BAAA;EACA,yBAAA;AADF;;AAKA;EACE,qBAAA;EACA,mBAAA;EACA,mBAAA;EACA,sBAAA;AAFF;;AAMA;EACE,gBAAA;EACA,cAAA;AAHF;;AAMA;EACE,gBAAA;EACA,wBAAA;AAHF;;AAOA;EACE,mBAAA;EACA,2CAAA;EACA,gBAAA;EACA,kBAAA;AAJF;;AAQA;EACE,gBAAA;EACA,wBAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,SAAA;EACA,cAAA;AALF;;AAQA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;AALF;AAOE;EACE,eAAA;EACA,cAAA;AALJ;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,cAAA;EACA,SAAA;AAPF;;AAUA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,SAAA;EACA,4BAAA;EACA,cAAA;EACA,YAAA;AAPF;AASE;EACE,eAAA;EACA,cAAA;AAPJ;;AAYA;EACE,mBAAA;EACA,yCAAA;EACA,gBAAA;EACA,SAAA;EACA,qCAAA;AATF;;AAYA;EACE,aAAA;AATF;;AAYA;EACE,aAAA;EACA,mBAAA;EACA,SAAA;EACA,mBAAA;EACA,oBAAA;EACA,gDAAA;AATF;;AAYA;EACE,WAAA;EACA,YAAA;EACA,kBAAA;EACA,gBAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,wCAAA;AATF;AAWE;EACE,eAAA,EAAA,0BAAA;EACA,+BAAA;AATJ;;AAaA;EACE,OAAA;EACA,YAAA;AAVF;;AAaA;EACE,eAAA;EACA,gBAAA;EACA,iBAAA;EACA,4BAAA;EACA,qBAAA;AAVF;;AAaA;EACE,SAAA;AAVF;AAYE;EACE,eAAA;EACA,iBAAA;EACA,gBAAA;AAVJ;;AAcA;EACE,UAAA;EACA,SAAA;AAXF;AAaE;EACE,SAAA;AAXJ;AAcE;EACE,cAAA;EACA,aAAA;EACA,sBAAA;AAZJ;AAcI;EACE,eAAA;EACA,kBAAA;AAZN;AAeI;EACE,gBAAA;EACA,iBAAA;AAbN;;AAkBA;EACE,aAAA;EACA,uBAAA;EACA,SAAA;EACA,iBAAA;EACA,oCAAA;EACA,kBAAA;EACA,qCAAA;EACA,kBAAA;EACA,yBAAA;AAfF;AAiBE;EACE,gBAAA;AAfJ;AAkBE;EACE,oCAAA;EACA,qCAAA;EACA,2BAAA;EACA,yCAAA;AAhBJ;AAmBE;EACE,eAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;EACA,+BAAA;AAjBJ;;AAqBA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,OAAA;EACA,YAAA;EACA,gBAAA;AAlBF;AAoBE;EACE,eAAA;EACA,gBAAA;EACA,8BAAA;EACA,yBAAA;EACA,qBAAA;EACA,gBAAA;EACA,SAAA;EACA,gBAAA;AAlBJ;AAqBE;EACE,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,gBAAA;EACA,qBAAA;EACA,sBAAA;EACA,SAAA;EACA,gBAAA;EACA,aAAA;EACA,mBAAA;EACA,eAAA;EACA,QAAA;AAnBJ;AAqBI;EACE,YAAA;EACA,8BAAA;EACA,kBAAA;AAnBN;AAsBI;EACE,eAAA;EACA,gBAAA;AApBN;;AA0BA;EACE,UAAA;AAvBF;;AA0BA;EACE,eAAA;EACA,4CAAA;AAvBF;AAyBE;EAEE,mBAAA;EACA,iBAAA;AAxBJ;AA2BE;EACE,cAAA;AAzBJ;;AA6BA;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;EACA,SAAA;AA1BF;;AA6BA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,gBAAA;EACA,4BAAA;EACA,SAAA;EACA,OAAA;EACA,YAAA;AA1BF;AA4BE;EACE,eAAA;EACA,cAAA;AA1BJ;;AA8BA;EACE,aAAA;EACA,sBAAA;EACA,QAAA;EACA,kBAAA;AA3BF;;AA8BA;EACE,aAAA;EACA,mBAAA;EACA,QAAA;EACA,eAAA;EACA,8BAAA;AA3BF;AA6BE;EACE,eAAA;EACA,cAAA;AA3BJ;AA8BE;EACE,4BAAA;AA5BJ;;AAiCA;EACE;IACE,qBAAA;IACA,mBAAA;IACA,mBAAA;IACA,sBAAA;EA9BF;EAiCA;IACE,mBAAA;EA/BF;EAkCA;IACE,eAAA;EAhCF;EAkCE;IACE,eAAA;EAhCJ;EAoCA;IACE,mBAAA;EAlCF;EAqCA;IACE,aAAA;EAnCF;EAuCE;IACE,cAAA;EArCJ;EAuCI;IACE,eAAA;IACA,kBAAA;EArCN;EAwCI;IACE,gBAAA;IACA,iBAAA;EAtCN;EA2CA;IACE,iBAAA;IACA,SAAA;IACA,kBAAA;EAzCF;EA2CE;IACE,eAAA;IACA,WAAA;EAzCJ;EA8CE;IACE,eAAA;IACA,qBAAA;EA5CJ;EA+CE;IACE,eAAA;EA7CJ;EAiDA;IACE,eAAA;EA/CF;EAkDA;IACE,WAAA;IACA,YAAA;EAhDF;AACF;AAmDA;EACE;IACE,oBAAA;IACA,kBAAA;IACA,mBAAA;IACA,sBAAA;EAjDF;EAoDA;IACE,mBAAA;EAlDF;EAqDA;IACE,eAAA;EAnDF;EAqDE;IACE,eAAA;EAnDJ;EAuDA;IACE,mBAAA;EArDF;EAwDA;IACE,aAAA;EAtDF;EAyDA;IACE,sBAAA;IACA,kBAAA;IACA,mBAAA;IACA,mBAAA;IACA,oBAAA;EAvDF;EA0DA;IACE,WAAA;IACA,YAAA;EAxDF;EA2DA;IACE,eAAA;IACA,kBAAA;EAzDF;EA6DE;IACE,cAAA;EA3DJ;EA6DI;IACE,eAAA;IACA,kBAAA;EA3DN;EA8DI;IACE,gBAAA;IACA,iBAAA;EA5DN;EAiEA;IACE,gBAAA;IACA,QAAA;IACA,kBAAA;EA/DF;EAiEE;IACE,eAAA;IACA,WAAA;EA/DJ;EAoEE;IACE,cAAA;IACA,qBAAA;EAlEJ;EAqEE;IACE,eAAA;EAnEJ;EAuEA;IACE,sBAAA;IACA,uBAAA;IACA,QAAA;EArEF;EAwEA;IACE,eAAA;IACA,QAAA;EAtEF;AACF","sourcesContent":["// Account Page Styles - Following Child Detail Design Patterns\n\n:root {\n  --ion-color-primary: #4990E2;\n  --ion-color-primary-rgb: 73, 144, 226;\n  --ion-color-primary-contrast: #ffffff;\n  --ion-color-secondary: #6D5AE6;\n  --ion-color-secondary-rgb: 109, 90, 230;\n  --ion-color-secondary-contrast: #ffffff;\n  --ion-color-tertiary: #FF8A65;\n  --ion-color-tertiary-rgb: 255, 138, 101;\n  --ion-color-tertiary-contrast: #ffffff;\n  --ion-color-light: #f4f5f8;\n  --ion-color-medium: #92949c;\n  --ion-color-dark: #222428;\n}\n\n// Main content\nion-content {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\n// Account container\n.account-container {\n  max-width: 800px;\n  margin: 0 auto;\n}\n\n.card-container {\n  max-width: 800px;\n  margin: 0 auto 20px auto;\n}\n\n// Card styling\nion-card {\n  border-radius: 16px;\n  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);\n  overflow: hidden;\n  margin: 0 0 16px 0;\n}\n\n// Main Section Header\n.section-header-main {\n  max-width: 800px;\n  margin: 0 auto 24px auto;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  gap: 16px;\n  padding: 0 4px;\n}\n\n.section-title-main {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0;\n  color: var(--ion-color-dark);\n\n  ion-icon {\n    font-size: 28px;\n    flex-shrink: 0;\n  }\n}\n\n// Section header for cards\n.section-header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  margin-bottom: 16px;\n  padding: 0 4px;\n  gap: 16px;\n}\n\n.section-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 20px;\n  font-weight: 600;\n  margin: 0;\n  color: var(--ion-color-dark);\n  flex: 1 1 auto;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 24px;\n    flex-shrink: 0;\n  }\n}\n\n// User Information Card\n.user-info-card {\n  border-radius: 12px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);\n  overflow: hidden;\n  margin: 0;\n  border: 1px solid rgba(0, 0, 0, 0.08);\n}\n\n.profile-content {\n  padding: 20px;\n}\n\n.profile-header {\n  display: flex;\n  align-items: center;\n  gap: 16px;\n  margin-bottom: 24px;\n  padding-bottom: 20px;\n  border-bottom: 2px solid rgba(73, 144, 226, 0.1);\n}\n\n.profile-avatar {\n  width: 80px;\n  height: 80px;\n  border-radius: 50%;\n  overflow: hidden;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--ion-color-light);\n\n  ion-icon {\n    font-size: 80px; /* Adjust size as needed */\n    color: var(--ion-color-primary);\n  }\n}\n\n.profile-info {\n  flex: 1;\n  min-width: 0;\n}\n\n.user-name {\n  font-size: 24px;\n  font-weight: 700;\n  margin: 0 0 8px 0;\n  color: var(--ion-color-dark);\n  word-wrap: break-word;\n}\n\n.user-role {\n  margin: 0;\n\n  ion-badge {\n    font-size: 13px;\n    padding: 6px 12px;\n    font-weight: 600;\n  }\n}\n\n.content-grid {\n  padding: 0;\n  margin: 0;\n\n  ion-row {\n    margin: 0;\n  }\n\n  ion-col {\n    padding: 0 6px;\n    display: flex;\n    flex-direction: column;\n\n    &:first-child {\n      padding-left: 0;\n      padding-right: 8px;\n    }\n\n    &:last-child {\n      padding-right: 0;\n      padding-left: 8px;\n    }\n  }\n}\n\n.info-item {\n  display: flex;\n  align-items: flex-start;\n  gap: 12px;\n  padding: 12px 8px;\n  background: rgba(255, 255, 255, 0.8);\n  border-radius: 6px;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  margin-bottom: 8px;\n  transition: all 0.2s ease;\n\n  &:last-child {\n    margin-bottom: 0;\n  }\n\n  &:hover {\n    background: rgba(73, 144, 226, 0.04);\n    border-color: rgba(73, 144, 226, 0.2);\n    transform: translateY(-1px);\n    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);\n  }\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n    width: 20px;\n    height: 20px;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    margin-top: 2px;\n    margin-inline-end: 0 !important;\n  }\n}\n\n.item-content {\n  display: flex;\n  flex-direction: column;\n  gap: 3px;\n  flex: 1;\n  min-width: 0;\n  text-align: left;\n\n  .label {\n    font-size: 11px;\n    font-weight: 600;\n    color: var(--ion-color-medium);\n    text-transform: uppercase;\n    letter-spacing: 0.5px;\n    line-height: 1.2;\n    margin: 0;\n    text-align: left;\n  }\n\n  .value {\n    font-size: 14px;\n    font-weight: 600;\n    color: var(--ion-color-dark);\n    line-height: 1.4;\n    word-wrap: break-word;\n    word-break: break-word;\n    margin: 0;\n    text-align: left;\n    display: flex;\n    align-items: center;\n    flex-wrap: wrap;\n    gap: 6px;\n\n    &:empty::after {\n      content: '-';\n      color: var(--ion-color-medium);\n      font-style: italic;\n    }\n\n    ion-badge {\n      font-size: 11px;\n      padding: 3px 8px;\n    }\n  }\n}\n\n// Facility List\n.facility-list {\n  padding: 0;\n}\n\n.facility-item {\n  padding: 16px 0;\n  border-bottom: 1px solid rgba(0, 0, 0, 0.08);\n\n  &:last-child,\n  &.last-item {\n    border-bottom: none;\n    padding-bottom: 0;\n  }\n\n  &:first-child {\n    padding-top: 0;\n  }\n}\n\n.facility-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: 12px;\n  gap: 12px;\n}\n\n.facility-title {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 16px;\n  font-weight: 600;\n  color: var(--ion-color-dark);\n  margin: 0;\n  flex: 1;\n  min-width: 0;\n\n  ion-icon {\n    font-size: 18px;\n    flex-shrink: 0;\n  }\n}\n\n.facility-details {\n  display: flex;\n  flex-direction: column;\n  gap: 8px;\n  padding-left: 26px;\n}\n\n.facility-detail {\n  display: flex;\n  align-items: center;\n  gap: 8px;\n  font-size: 13px;\n  color: var(--ion-color-medium);\n\n  ion-icon {\n    font-size: 16px;\n    flex-shrink: 0;\n  }\n\n  span {\n    color: var(--ion-color-dark);\n  }\n}\n\n// Responsive Design\n@media (max-width: 768px) {\n  ion-content {\n    --padding-start: 12px;\n    --padding-end: 12px;\n    --padding-top: 16px;\n    --padding-bottom: 16px;\n  }\n\n  .section-header-main {\n    margin-bottom: 20px;\n  }\n\n  .section-title-main {\n    font-size: 20px;\n\n    ion-icon {\n      font-size: 24px;\n    }\n  }\n\n  .card-container {\n    margin-bottom: 16px;\n  }\n\n  .profile-content {\n    padding: 16px;\n  }\n\n  .content-grid {\n    ion-col {\n      padding: 0 3px;\n\n      &:first-child {\n        padding-left: 0;\n        padding-right: 5px;\n      }\n\n      &:last-child {\n        padding-right: 0;\n        padding-left: 5px;\n      }\n    }\n  }\n\n  .info-item {\n    padding: 10px 6px;\n    gap: 10px;\n    margin-bottom: 6px;\n\n    ion-icon {\n      font-size: 16px;\n      width: 18px;\n    }\n  }\n\n  .item-content {\n    .label {\n      font-size: 10px;\n      letter-spacing: 0.3px;\n    }\n\n    .value {\n      font-size: 13px;\n    }\n  }\n\n  .user-name {\n    font-size: 20px;\n  }\n\n  .profile-avatar {\n    width: 70px;\n    height: 70px;\n  }\n}\n\n@media (max-width: 480px) {\n  ion-content {\n    --padding-start: 8px;\n    --padding-end: 8px;\n    --padding-top: 12px;\n    --padding-bottom: 12px;\n  }\n\n  .section-header-main {\n    margin-bottom: 16px;\n  }\n\n  .section-title-main {\n    font-size: 18px;\n\n    ion-icon {\n      font-size: 22px;\n    }\n  }\n\n  .card-container {\n    margin-bottom: 12px;\n  }\n\n  .profile-content {\n    padding: 12px;\n  }\n\n  .profile-header {\n    flex-direction: column;\n    text-align: center;\n    align-items: center;\n    margin-bottom: 16px;\n    padding-bottom: 16px;\n  }\n\n  .profile-avatar {\n    width: 60px;\n    height: 60px;\n  }\n\n  .user-name {\n    font-size: 18px;\n    text-align: center;\n  }\n\n  .content-grid {\n    ion-col {\n      padding: 0 2px;\n\n      &:first-child {\n        padding-left: 0;\n        padding-right: 4px;\n      }\n\n      &:last-child {\n        padding-right: 0;\n        padding-left: 4px;\n      }\n    }\n  }\n\n  .info-item {\n    padding: 8px 4px;\n    gap: 8px;\n    margin-bottom: 5px;\n\n    ion-icon {\n      font-size: 14px;\n      width: 16px;\n    }\n  }\n\n  .item-content {\n    .label {\n      font-size: 9px;\n      letter-spacing: 0.2px;\n    }\n\n    .value {\n      font-size: 12px;\n    }\n  }\n\n  .facility-header {\n    flex-direction: column;\n    align-items: flex-start;\n    gap: 8px;\n  }\n\n  .facility-details {\n    padding-left: 0;\n    gap: 6px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 74699:
/*!************************************************************!*\
  !*** ./src/app/pages/account/account.page.html?ngResource ***!
  \************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>Account</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <div *ngIf=\"user; else skeleton\" class=\"account-container\">\n\n    <!-- Header Section -->\n    <div class=\"section-header-main\">\n      <h1 class=\"section-title-main\">\n        <ion-icon name=\"person-circle-outline\" color=\"primary\"></ion-icon>\n        User Profile\n      </h1>\n    </div>\n\n    <!-- User Information Card -->\n    <div class=\"card-container\">\n      <ion-card class=\"user-info-card\">\n        <div class=\"profile-content\">\n          <div class=\"profile-header\">\n            <ion-avatar class=\"profile-avatar\">\n              <ion-icon name=\"person-circle-outline\"></ion-icon>\n            </ion-avatar>\n            <div class=\"profile-info\">\n              <h2 class=\"user-name\">{{user.name || '-'}}</h2>\n              <p class=\"user-role\">\n                <ion-badge color=\"primary\">{{user.user_type || '-'}}</ion-badge>\n              </p>\n            </div>\n          </div>\n\n          <ion-grid class=\"content-grid\">\n            <ion-row>\n              <ion-col size=\"12\" size-md=\"6\">\n                <div class=\"info-item\">\n                  <ion-icon name=\"call-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Phone</span>\n                    <span class=\"value\">{{user.cell_phone || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"mail-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Email</span>\n                    <span class=\"value\">{{user.email || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"location-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Address</span>\n                    <span class=\"value\">{{user.profile?.address || '-'}}</span>\n                  </div>\n                </div>\n              </ion-col>\n\n              <ion-col size=\"12\" size-md=\"6\">\n                <div class=\"info-item\">\n                  <ion-icon name=\"calendar-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Date of Birth</span>\n                    <span class=\"value\">{{(user?.profile?.date_of_birth | date: 'mediumDate') || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"male-female-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Gender</span>\n                    <span class=\"value\">{{user?.profile?.gender || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"card-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">NID</span>\n                    <span class=\"value\">{{user?.profile?.nid || '-'}}</span>\n                  </div>\n                </div>\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </div>\n      </ion-card>\n    </div>\n\n    <!-- Work Information -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <div class=\"section-header\">\n            <h2 class=\"section-title\">\n              <ion-icon name=\"business-outline\" color=\"primary\"></ion-icon>\n              Work Information\n            </h2>\n          </div>\n\n          <ion-grid class=\"content-grid\">\n            <ion-row>\n              <ion-col size=\"12\" size-md=\"6\">\n                <div class=\"info-item\">\n                  <ion-icon name=\"business\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Facility</span>\n                    <span class=\"value\">{{user.profile?.default_inf?.title || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"code-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Facility Code</span>\n                    <span class=\"value\">{{user.profile?.default_inf?.facility_code || '-'}}</span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"location\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Camp ID</span>\n                    <span class=\"value\">{{user.profile?.default_inf?.camp_id || '-'}}</span>\n                  </div>\n                </div>\n              </ion-col>\n\n              <ion-col size=\"12\" size-md=\"6\">\n                <div class=\"info-item\">\n                  <ion-icon name=\"server-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Mode</span>\n                    <span class=\"value\">\n                      <ion-badge color=\"primary\" *ngIf=\"user.profile?.default_inf?.mode; else modeDash\">{{user.profile.default_inf.mode}}</ion-badge>\n                      <ng-template #modeDash>-</ng-template>\n                    </span>\n                  </div>\n                </div>\n\n                <div class=\"info-item\">\n                  <ion-icon name=\"checkmark-circle-outline\" color=\"primary\"></ion-icon>\n                  <div class=\"item-content\">\n                    <span class=\"label\">Status</span>\n                    <span class=\"value\">\n                      <ion-badge color=\"success\" *ngIf=\"user.profile?.default_inf?.status; else statusDash\">{{user.profile.default_inf.status}}</ion-badge>\n                      <ng-template #statusDash>-</ng-template>\n                    </span>\n                  </div>\n                </div>\n\n              </ion-col>\n            </ion-row>\n          </ion-grid>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n    <!-- Password Change Section -->\n    <div class=\"card-container\">\n      <ion-card>\n        <ion-card-content>\n          <div class=\"section-header\">\n            <h2 class=\"section-title\">\n              <ion-icon name=\"key-outline\" color=\"primary\"></ion-icon>\n              Change Password\n            </h2>\n          </div>\n\n          <form [formGroup]=\"passwordForm\" (ngSubmit)=\"onSubmitPasswordChange()\">\n            <ion-list>\n              <ion-item>\n                <ion-label position=\"stacked\">Current Password <ion-text color=\"danger\">*</ion-text></ion-label>\n                <ion-input\n                  [type]=\"showCurrentPassword ? 'text' : 'password'\"\n                  formControlName=\"current_password\"\n                  placeholder=\"Enter current password\">\n                </ion-input>\n                <ion-icon\n                  slot=\"end\"\n                  [name]=\"showCurrentPassword ? 'eye-off-outline' : 'eye-outline'\"\n                  (click)=\"showCurrentPassword = !showCurrentPassword\"\n                  style=\"cursor: pointer;\">\n                </ion-icon>\n              </ion-item>\n              <ion-text color=\"danger\" *ngIf=\"passwordForm.get('current_password')?.touched && passwordForm.get('current_password')?.hasError('required')\">\n                <p class=\"ion-padding-start\">Current password is required</p>\n              </ion-text>\n\n              <ion-item>\n                <ion-label position=\"stacked\">New Password <ion-text color=\"danger\">*</ion-text></ion-label>\n                <ion-input\n                  [type]=\"showNewPassword ? 'text' : 'password'\"\n                  formControlName=\"new_password\"\n                  placeholder=\"Enter new password (min 8 characters)\">\n                </ion-input>\n                <ion-icon\n                  slot=\"end\"\n                  [name]=\"showNewPassword ? 'eye-off-outline' : 'eye-outline'\"\n                  (click)=\"showNewPassword = !showNewPassword\"\n                  style=\"cursor: pointer;\">\n                </ion-icon>\n              </ion-item>\n              <ion-text color=\"danger\" *ngIf=\"passwordForm.get('new_password')?.touched && passwordForm.get('new_password')?.hasError('required')\">\n                <p class=\"ion-padding-start\">New password is required</p>\n              </ion-text>\n              <ion-text color=\"danger\" *ngIf=\"passwordForm.get('new_password')?.touched && passwordForm.get('new_password')?.hasError('minlength')\">\n                <p class=\"ion-padding-start\">Password must be at least 8 characters</p>\n              </ion-text>\n\n              <ion-item>\n                <ion-label position=\"stacked\">Confirm New Password <ion-text color=\"danger\">*</ion-text></ion-label>\n                <ion-input\n                  [type]=\"showConfirmPassword ? 'text' : 'password'\"\n                  formControlName=\"new_password_confirmation\"\n                  placeholder=\"Confirm new password\">\n                </ion-input>\n                <ion-icon\n                  slot=\"end\"\n                  [name]=\"showConfirmPassword ? 'eye-off-outline' : 'eye-outline'\"\n                  (click)=\"showConfirmPassword = !showConfirmPassword\"\n                  style=\"cursor: pointer;\">\n                </ion-icon>\n              </ion-item>\n              <ion-text color=\"danger\" *ngIf=\"passwordForm.get('new_password_confirmation')?.touched && passwordForm.get('new_password_confirmation')?.hasError('required')\">\n                <p class=\"ion-padding-start\">Please confirm your new password</p>\n              </ion-text>\n              <ion-text color=\"danger\" *ngIf=\"passwordForm.touched && passwordForm.hasError('passwordMismatch')\">\n                <p class=\"ion-padding-start\">Passwords do not match</p>\n              </ion-text>\n            </ion-list>\n\n            <div class=\"ion-padding-top\">\n              <ion-button expand=\"block\" type=\"submit\" [disabled]=\"passwordForm.invalid\">\n                <ion-icon name=\"checkmark-circle-outline\" slot=\"start\"></ion-icon>\n                Change Password\n              </ion-button>\n            </div>\n          </form>\n        </ion-card-content>\n      </ion-card>\n    </div>\n\n  </div>\n\n  <ng-template #skeleton>\n    <app-skeleton></app-skeleton>\n  </ng-template>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_account_account_module_ts.js.map