"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["default-src_app_services_survey_form_api_service_ts-node_modules_ngx-formly_core_fesm2022_ngx-d1e201"],{

/***/ 55856:
/*!*****************************************************!*\
  !*** ./src/app/services/survey_form_api.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveyFormAPIService: () => (/* binding */ SurveyFormAPIService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _api_base_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./api_base.service */ 70014);
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/environments/environment */ 45312);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 61318);

/* eslint-disable @typescript-eslint/naming-convention */




let SurveyFormAPIService = class SurveyFormAPIService extends _api_base_service__WEBPACK_IMPORTED_MODULE_0__.APIBaseService {
  constructor() {
    super(...arguments);
    this.namespace = '/survey-forms/responses';
    this.formsNamespace = '/survey-forms';
  }
  getSurveyResponseData(id, type) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${type}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  displayForms(id, beneficiaryType, beneficiaryId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.formsNamespace}/${id}`;
    // Add query parameters if provided
    const queryParams = [];
    if (beneficiaryType) {
      queryParams.push(`beneficiary_type=${encodeURIComponent(beneficiaryType)}`);
    }
    if (beneficiaryId) {
      queryParams.push(`beneficiary_id=${encodeURIComponent(beneficiaryId)}`);
    }
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  storeSurvey(body) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}`;
    return this.http.post(url, body).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  viewForm(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteForm(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  deleteSurvey(id) {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}${this.namespace}/${id}`;
    return this.http.delete(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  // ===== OFFLINE ASSESSMENT APIs =====
  getAssessmentForms(tags, tagMatch = 'all') {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/survey-forms/list`;
    const queryParams = [];
    if (tags) {
      queryParams.push(`tags=${encodeURIComponent(tags)}`);
    }
    queryParams.push(`tag_match=${encodeURIComponent(tagMatch)}`);
    if (queryParams.length > 0) {
      url += `?${queryParams.join('&')}`;
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getLocationData() {
    const url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/location-data`;
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
  getBeneficiariesByLocation(blockCampId, subBlockIds, assessmentId) {
    let url = `${src_environments_environment__WEBPACK_IMPORTED_MODULE_1__.domain}/offline-assessment/beneficiaries?block_id=${blockCampId}&survey_form_id=${assessmentId}`;
    if (subBlockIds !== null && subBlockIds !== undefined) {
      if (Array.isArray(subBlockIds)) {
        const commaSeparatedIds = subBlockIds.join(',');
        url += `&sub_block_ids=${commaSeparatedIds}`;
      }
    }
    return this.http.get(url).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(results => results), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.catchError)(error => this.errorHandle(error))).toPromise();
  }
};
SurveyFormAPIService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], SurveyFormAPIService);


/***/ }),

/***/ 63617:
/*!*****************************************************************!*\
  !*** ./node_modules/rxjs/dist/esm/internal/observable/merge.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   merge: () => (/* binding */ merge)
/* harmony export */ });
/* harmony import */ var _operators_mergeAll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../operators/mergeAll */ 23222);
/* harmony import */ var _innerFrom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./innerFrom */ 82645);
/* harmony import */ var _empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./empty */ 59400);
/* harmony import */ var _util_args__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/args */ 4083);
/* harmony import */ var _from__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./from */ 95429);





function merge(...args) {
  const scheduler = (0,_util_args__WEBPACK_IMPORTED_MODULE_0__.popScheduler)(args);
  const concurrent = (0,_util_args__WEBPACK_IMPORTED_MODULE_0__.popNumber)(args, Infinity);
  const sources = args;
  return !sources.length ? _empty__WEBPACK_IMPORTED_MODULE_1__.EMPTY : sources.length === 1 ? (0,_innerFrom__WEBPACK_IMPORTED_MODULE_2__.innerFrom)(sources[0]) : (0,_operators_mergeAll__WEBPACK_IMPORTED_MODULE_3__.mergeAll)(concurrent)((0,_from__WEBPACK_IMPORTED_MODULE_4__.from)(sources, scheduler));
}

/***/ }),

/***/ 52575:
/*!***********************************************************************!*\
  !*** ./node_modules/rxjs/dist/esm/internal/operators/debounceTime.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounceTime: () => (/* binding */ debounceTime)
/* harmony export */ });
/* harmony import */ var _scheduler_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scheduler/async */ 18473);
/* harmony import */ var _util_lift__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/lift */ 50819);
/* harmony import */ var _OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OperatorSubscriber */ 91687);



function debounceTime(dueTime, scheduler = _scheduler_async__WEBPACK_IMPORTED_MODULE_0__.asyncScheduler) {
  return (0,_util_lift__WEBPACK_IMPORTED_MODULE_1__.operate)((source, subscriber) => {
    let activeTask = null;
    let lastValue = null;
    let lastTime = null;
    const emit = () => {
      if (activeTask) {
        activeTask.unsubscribe();
        activeTask = null;
        const value = lastValue;
        lastValue = null;
        subscriber.next(value);
      }
    };
    function emitWhenIdle() {
      const targetTime = lastTime + dueTime;
      const now = scheduler.now();
      if (now < targetTime) {
        activeTask = this.schedule(undefined, targetTime - now);
        subscriber.add(activeTask);
        return;
      }
      emit();
    }
    source.subscribe((0,_OperatorSubscriber__WEBPACK_IMPORTED_MODULE_2__.createOperatorSubscriber)(subscriber, value => {
      lastValue = value;
      lastTime = scheduler.now();
      if (!activeTask) {
        activeTask = scheduler.schedule(emitWhenIdle, dueTime);
        subscriber.add(activeTask);
      }
    }, () => {
      emit();
      subscriber.complete();
    }, undefined, () => {
      lastValue = activeTask = null;
    }));
  });
}

/***/ }),

/***/ 10535:
/*!********************************************************************!*\
  !*** ./node_modules/@ngx-formly/core/fesm2022/ngx-formly-core.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FORMLY_CONFIG: () => (/* binding */ FORMLY_CONFIG),
/* harmony export */   FieldArrayType: () => (/* binding */ FieldArrayType),
/* harmony export */   FieldType: () => (/* binding */ FieldType),
/* harmony export */   FieldWrapper: () => (/* binding */ FieldWrapper),
/* harmony export */   FormlyAttributes: () => (/* binding */ FormlyAttributes),
/* harmony export */   FormlyConfig: () => (/* binding */ FormlyConfig),
/* harmony export */   FormlyField: () => (/* binding */ FormlyField),
/* harmony export */   FormlyForm: () => (/* binding */ FormlyForm),
/* harmony export */   FormlyFormBuilder: () => (/* binding */ FormlyFormBuilder),
/* harmony export */   FormlyModule: () => (/* binding */ FormlyModule),
/* harmony export */   FormlyValidationMessage: () => (/* binding */ FormlyValidationMessage),
/* harmony export */   LegacyFormlyAttributes: () => (/* binding */ LegacyFormlyAttributes),
/* harmony export */   LegacyFormlyField: () => (/* binding */ LegacyFormlyField),
/* harmony export */   LegacyFormlyForm: () => (/* binding */ LegacyFormlyForm),
/* harmony export */   LegacyFormlyValidationMessage: () => (/* binding */ LegacyFormlyValidationMessage),
/* harmony export */   provideFormlyConfig: () => (/* binding */ provideFormlyConfig),
/* harmony export */   provideFormlyCore: () => (/* binding */ provideFormlyCore),
/* harmony export */   "ɵFormlyGroup": () => (/* binding */ FormlyGroup),
/* harmony export */   "ɵFormlyTemplate": () => (/* binding */ FormlyTemplate),
/* harmony export */   "ɵclone": () => (/* binding */ clone),
/* harmony export */   "ɵdefineHiddenProp": () => (/* binding */ defineHiddenProp),
/* harmony export */   "ɵgetFieldValue": () => (/* binding */ getFieldValue),
/* harmony export */   "ɵhasKey": () => (/* binding */ hasKey),
/* harmony export */   "ɵobserve": () => (/* binding */ observe),
/* harmony export */   "ɵreverseDeepMerge": () => (/* binding */ reverseDeepMerge)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 72551);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 43942);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 10819);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 63617);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 98764);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs/operators */ 91817);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 63037);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs/operators */ 52575);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs/operators */ 36647);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs/operators */ 64334);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/platform-browser */ 80436);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common */ 60316);
var _FieldType, _FormlyTemplateType, _FormlyConfig, _FormlyTemplate, _FormlyFieldTemplates, _FormlyField, _LegacyFormlyField, _FormlyGroup, _FormlyFormBuilder, _FormlyForm, _LegacyFormlyForm, _FormlyAttributes, _LegacyFormlyAttributes, _FormlyValidationMessage, _LegacyFormlyValidationMessage, _FieldArrayType, _FieldWrapper, _FormlyModule;
const _c0 = ["container"];
function _FormlyField_ng_template_0_Template(rf, ctx) {}
function _LegacyFormlyField_ng_template_0_Template(rf, ctx) {}
const _c1 = ["*"];
function _FormlyGroup_For_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "formly-field", 0);
  }
  if (rf & 2) {
    const f_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("field", f_r1);
  }
}
const _c2 = ["fieldComponent"];









function disableTreeValidityCall(form, callback) {
  const _updateTreeValidity = form._updateTreeValidity.bind(form);
  form._updateTreeValidity = () => {};
  callback();
  form._updateTreeValidity = _updateTreeValidity;
}
function getFieldId(formId, field, index) {
  if (field.id) {
    return field.id;
  }
  let type = field.type;
  if (!type && field.template) {
    type = 'template';
  }
  if (type instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.Type) {
    type = type.prototype.constructor.name;
  }
  return [formId, type, field.key, index].join('_');
}
function hasKey(field) {
  return !isNil(field.key) && field.key !== '' && (!Array.isArray(field.key) || field.key.length > 0);
}
function getKeyPath(field) {
  var _field$_keyPath;
  if (!hasKey(field)) {
    return [];
  }
  /* We store the keyPath in the field for performance reasons. This function will be called frequently. */
  if (((_field$_keyPath = field._keyPath) === null || _field$_keyPath === void 0 ? void 0 : _field$_keyPath.key) !== field.key) {
    let path = [];
    if (typeof field.key === 'string') {
      const key = field.key.indexOf('[') === -1 ? field.key : field.key.replace(/\[(\w+)\]/g, '.$1');
      path = key.indexOf('.') !== -1 ? key.split('.') : [key];
    } else if (Array.isArray(field.key)) {
      path = field.key.slice(0);
    } else {
      path = [`${field.key}`];
    }
    defineHiddenProp(field, '_keyPath', {
      key: field.key,
      path
    });
  }
  return field._keyPath.path.slice(0);
}
const FORMLY_VALIDATORS = ['required', 'pattern', 'minLength', 'maxLength', 'min', 'max'];
function assignFieldValue(field, value) {
  let paths = getKeyPath(field);
  if (paths.length === 0) {
    return;
  }
  let root = field;
  while (root.parent) {
    root = root.parent;
    paths = [...getKeyPath(root), ...paths];
  }
  if (value === undefined && field.resetOnHide) {
    const k = paths.pop();
    const m = paths.reduce((model, path) => model[path] || {}, root.model);
    delete m[k];
    return;
  }
  assignModelValue(root.model, paths, value);
}
function assignModelValue(model, paths, value) {
  for (let i = 0; i < paths.length - 1; i++) {
    const path = paths[i];
    if (!model[path] || !isObject(model[path])) {
      model[path] = /^\d+$/.test(paths[i + 1]) ? [] : {};
    }
    model = model[path];
  }
  model[paths[paths.length - 1]] = clone(value);
}
function getFieldValue(field) {
  let model = field.parent ? field.parent.model : field.model;
  for (const path of getKeyPath(field)) {
    if (!model) {
      return model;
    }
    model = model[path];
  }
  return model;
}
function reverseDeepMerge(dest, ...args) {
  args.forEach(src => {
    for (const srcArg in src) {
      if (isNil(dest[srcArg]) || isBlankString(dest[srcArg])) {
        dest[srcArg] = clone(src[srcArg]);
      } else if (objAndSameType(dest[srcArg], src[srcArg])) {
        reverseDeepMerge(dest[srcArg], src[srcArg]);
      }
    }
  });
  return dest;
}
// check a value is null or undefined
function isNil(value) {
  return value == null;
}
function isUndefined(value) {
  return value === undefined;
}
function isBlankString(value) {
  return value === '';
}
function isFunction(value) {
  return typeof value === 'function';
}
function objAndSameType(obj1, obj2) {
  return isObject(obj1) && isObject(obj2) && Object.getPrototypeOf(obj1) === Object.getPrototypeOf(obj2) && !(Array.isArray(obj1) || Array.isArray(obj2));
}
function isObject(x) {
  return x != null && typeof x === 'object';
}
function isPromise(obj) {
  return !!obj && typeof obj.then === 'function';
}
function clone(value) {
  var _value$constructor;
  if (!isObject(value) || (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(value) || value instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef || /* instanceof SafeHtmlImpl */value.changingThisBreaksApplicationSecurity || ['RegExp', 'FileList', 'File', 'Blob'].indexOf((_value$constructor = value.constructor) === null || _value$constructor === void 0 ? void 0 : _value$constructor.name) !== -1) {
    return value;
  }
  if (value instanceof Set) {
    return new Set(value);
  }
  if (value instanceof Map) {
    return new Map(value);
  }
  if (value instanceof Uint8Array) {
    return new Uint8Array(value);
  }
  if (value instanceof Uint16Array) {
    return new Uint16Array(value);
  }
  if (value instanceof Uint32Array) {
    return new Uint32Array(value);
  }
  // https://github.com/moment/moment/blob/master/moment.js#L252
  if (value._isAMomentObject && isFunction(value.clone)) {
    return value.clone();
  }
  if (value instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.AbstractControl) {
    return null;
  }
  if (value instanceof Date) {
    return new Date(value.getTime());
  }
  if (Array.isArray(value)) {
    return value.slice(0).map(v => clone(v));
  }
  // best way to clone a js object maybe
  // https://stackoverflow.com/questions/41474986/how-to-clone-a-javascript-es6-class-instance
  const proto = Object.getPrototypeOf(value);
  let c = Object.create(proto);
  c = Object.setPrototypeOf(c, proto);
  // need to make a deep copy so we dont use Object.assign
  // also Object.assign wont copy property descriptor exactly
  return Object.keys(value).reduce((newVal, prop) => {
    const propDesc = Object.getOwnPropertyDescriptor(value, prop);
    if (propDesc.get) {
      Object.defineProperty(newVal, prop, propDesc);
    } else {
      newVal[prop] = clone(value[prop]);
    }
    return newVal;
  }, c);
}
function defineHiddenProp(field, prop, defaultValue) {
  Object.defineProperty(field, prop, {
    enumerable: false,
    writable: true,
    configurable: true
  });
  field[prop] = defaultValue;
}
function observeDeep(source, paths, setFn) {
  let observers = [];
  const unsubscribe = () => {
    observers.forEach(observer => observer());
    observers = [];
  };
  const observer = observe(source, paths, ({
    firstChange,
    currentValue
  }) => {
    !firstChange && setFn();
    unsubscribe();
    if (isObject(currentValue) && currentValue.constructor.name === 'Object') {
      Object.keys(currentValue).forEach(prop => {
        observers.push(observeDeep(source, [...paths, prop], setFn));
      });
    }
  });
  return () => {
    observer.unsubscribe();
    unsubscribe();
  };
}
function observe(o, paths, setFn) {
  if (!o._observers) {
    defineHiddenProp(o, '_observers', {});
  }
  let target = o;
  for (let i = 0; i < paths.length - 1; i++) {
    if (!target[paths[i]] || !isObject(target[paths[i]])) {
      target[paths[i]] = /^\d+$/.test(paths[i + 1]) ? [] : {};
    }
    target = target[paths[i]];
  }
  const key = paths[paths.length - 1];
  const prop = paths.join('.');
  if (!o._observers[prop]) {
    o._observers[prop] = {
      value: target[key],
      onChange: []
    };
  }
  const state = o._observers[prop];
  if (target[key] !== state.value) {
    state.value = target[key];
  }
  if (setFn && state.onChange.indexOf(setFn) === -1) {
    state.onChange.push(setFn);
    setFn({
      currentValue: state.value,
      firstChange: true
    });
    if (state.onChange.length >= 1 && isObject(target)) {
      const {
        enumerable
      } = Object.getOwnPropertyDescriptor(target, key) || {
        enumerable: true
      };
      Object.defineProperty(target, key, {
        enumerable,
        configurable: true,
        get: () => state.value,
        set: currentValue => {
          if (currentValue !== state.value) {
            const previousValue = state.value;
            state.value = currentValue;
            state.onChange.forEach(changeFn => changeFn({
              previousValue,
              currentValue,
              firstChange: false
            }));
          }
        }
      });
    }
  }
  return {
    setValue(currentValue, emitEvent = true) {
      if (currentValue === state.value) {
        return;
      }
      const previousValue = state.value;
      state.value = currentValue;
      state.onChange.forEach(changeFn => {
        if (changeFn !== setFn && emitEvent) {
          changeFn({
            previousValue,
            currentValue,
            firstChange: false
          });
        }
      });
    },
    unsubscribe() {
      state.onChange = state.onChange.filter(changeFn => changeFn !== setFn);
      if (state.onChange.length === 0) {
        delete o._observers[prop];
      }
    }
  };
}
function getField(f, key) {
  key = Array.isArray(key) ? key.join('.') : key;
  if (!f.fieldGroup) {
    return undefined;
  }
  for (let i = 0, len = f.fieldGroup.length; i < len; i++) {
    const c = f.fieldGroup[i];
    const k = Array.isArray(c.key) ? c.key.join('.') : c.key;
    if (k === key) {
      return c;
    }
    if (c.fieldGroup && (isNil(k) || key.indexOf(`${k}.`) === 0)) {
      const field = getField(c, isNil(k) ? key : key.slice(k.length + 1));
      if (field) {
        return field;
      }
    }
  }
  return undefined;
}
function markFieldForCheck(field) {
  var _field$_componentRefs;
  (_field$_componentRefs = field._componentRefs) === null || _field$_componentRefs === void 0 || _field$_componentRefs.forEach(ref => {
    // NOTE: we cannot use ref.changeDetectorRef, see https://github.com/ngx-formly/ngx-formly/issues/2191
    if (ref instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentRef) {
      const changeDetectorRef = ref.injector.get(_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef);
      changeDetectorRef.markForCheck();
    } else {
      ref.markForCheck();
    }
  });
}
function isNoopNgZone(ngZone) {
  return ngZone instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵNoopNgZone"];
}
function isHiddenField(field) {
  const isHidden = f => {
    var _f$expressions;
    return f.hide || ((_f$expressions = f.expressions) === null || _f$expressions === void 0 ? void 0 : _f$expressions.hide) || f.hideExpression;
  };
  let setDefaultValue = !field.resetOnHide || !isHidden(field);
  if (!isHidden(field) && field.resetOnHide) {
    let parent = field.parent;
    while (parent && !isHidden(parent)) {
      parent = parent.parent;
    }
    setDefaultValue = !parent || !isHidden(parent);
  }
  return !setDefaultValue;
}
function isSignalRequired() {
  return +_angular_core__WEBPACK_IMPORTED_MODULE_0__.VERSION.major > 18 || +_angular_core__WEBPACK_IMPORTED_MODULE_0__.VERSION.major >= 18 && +_angular_core__WEBPACK_IMPORTED_MODULE_0__.VERSION.minor >= 1;
}
function evalStringExpression(expression, argNames) {
  try {
    return Function(...argNames, `return ${expression};`);
  } catch (error) {
    console.error(error);
  }
}
function evalExpression(expression, thisArg, argVal) {
  if (typeof expression === 'function') {
    return expression.apply(thisArg, argVal);
  } else {
    return expression ? true : false;
  }
}
function unregisterControl(field, emitEvent = false) {
  const control = field.formControl;
  const fieldIndex = control._fields ? control._fields.indexOf(field) : -1;
  if (fieldIndex !== -1) {
    control._fields.splice(fieldIndex, 1);
  }
  const form = control.parent;
  if (!form) {
    return;
  }
  const opts = {
    emitEvent
  };
  if (form instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormArray) {
    const key = form.controls.findIndex(c => c === control);
    if (key !== -1) {
      form.removeAt(key, opts);
    }
  } else if (form instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormGroup) {
    const paths = getKeyPath(field);
    const key = paths[paths.length - 1];
    if (form.get([key]) === control) {
      form.removeControl(key, opts);
    }
  }
  control.setParent(null);
}
function findControl(field) {
  var _field$form;
  if (field.formControl) {
    return field.formControl;
  }
  if (field.shareFormControl === false) {
    return null;
  }
  return (_field$form = field.form) === null || _field$form === void 0 ? void 0 : _field$form.get(getKeyPath(field));
}
function registerControl(field, control, emitEvent = false) {
  control = control || field.formControl;
  if (!control._fields) {
    defineHiddenProp(control, '_fields', []);
  }
  if (control._fields.indexOf(field) === -1) {
    control._fields.push(field);
  }
  if (!field.formControl && control) {
    defineHiddenProp(field, 'formControl', control);
    control.setValidators(null);
    control.setAsyncValidators(null);
    field.props.disabled = !!field.props.disabled;
    const disabledObserver = observe(field, ['props', 'disabled'], ({
      firstChange,
      currentValue
    }) => {
      if (!firstChange) {
        currentValue ? field.formControl.disable() : field.formControl.enable();
      }
    });
    if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl) {
      control.registerOnDisabledChange(disabledObserver.setValue);
    }
  }
  if (!field.form || !hasKey(field)) {
    return;
  }
  let form = field.form;
  const paths = getKeyPath(field);
  const value = getFieldValue(field);
  if (!(isNil(control.value) && isNil(value)) && control.value !== value && control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl) {
    control.patchValue(value);
  }
  for (let i = 0; i < paths.length - 1; i++) {
    const path = paths[i];
    if (!form.get([path])) {
      form.setControl(path, new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormGroup({}), {
        emitEvent
      });
    }
    form = form.get([path]);
  }
  const key = paths[paths.length - 1];
  if (!field._hide && form.get([key]) !== control) {
    form.setControl(key, control, {
      emitEvent
    });
  }
}
function updateValidity(c, onlySelf = false) {
  const status = c.status;
  const value = c.value;
  c.updateValueAndValidity({
    emitEvent: false,
    onlySelf
  });
  if (status !== c.status) {
    c.statusChanges.emit(c.status);
  }
  if (value !== c.value) {
    c.valueChanges.emit(c.value);
  }
}
function clearControl(form) {
  form === null || form === void 0 || delete form._fields;
  form.setValidators(null);
  form.setAsyncValidators(null);
  if (form instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormGroup || form instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormArray) {
    Object.values(form.controls).forEach(c => clearControl(c));
  }
}
class FieldExpressionExtension {
  onPopulate(field) {
    if (field._expressions) {
      return;
    }
    // cache built expression
    defineHiddenProp(field, '_expressions', {});
    observe(field, ['hide'], ({
      currentValue,
      firstChange
    }) => {
      defineHiddenProp(field, '_hide', !!currentValue);
      if (!firstChange || firstChange && currentValue === true) {
        field.props.hidden = currentValue;
        field.options._hiddenFieldsForCheck.push({
          field
        });
      }
    });
    if (field.hideExpression) {
      observe(field, ['hideExpression'], ({
        currentValue: expr
      }) => {
        field._expressions.hide = this.parseExpressions(field, 'hide', typeof expr === 'boolean' ? () => expr : expr);
      });
    }
    const evalExpr = (key, expr) => {
      if (typeof expr === 'string' || isFunction(expr)) {
        field._expressions[key] = this.parseExpressions(field, key, expr);
      } else if (expr instanceof rxjs__WEBPACK_IMPORTED_MODULE_3__.Observable) {
        field._expressions[key] = {
          value$: expr.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.tap)(v => {
            this.evalExpr(field, key, v);
            field.options._detectChanges(field);
          }))
        };
      }
    };
    field.expressions = field.expressions || {};
    for (const key of Object.keys(field.expressions)) {
      observe(field, ['expressions', key], ({
        currentValue: expr
      }) => {
        evalExpr(key, isFunction(expr) ? (...args) => expr(field, args[3]) : expr);
      });
    }
    field.expressionProperties = field.expressionProperties || {};
    for (const key of Object.keys(field.expressionProperties)) {
      observe(field, ['expressionProperties', key], ({
        currentValue
      }) => evalExpr(key, currentValue));
    }
  }
  postPopulate(field) {
    if (field.parent) {
      return;
    }
    if (!field.options.checkExpressions) {
      let checkLocked = false;
      field.options.checkExpressions = (f, ignoreCache) => {
        if (checkLocked) {
          return;
        }
        checkLocked = true;
        const fieldChanged = this.checkExpressions(f, ignoreCache);
        const options = field.options;
        options._hiddenFieldsForCheck.sort(f => f.field.hide ? -1 : 1).forEach(f => {
          var _f$field$hide;
          return this.changeHideState(f.field, (_f$field$hide = f.field.hide) !== null && _f$field$hide !== void 0 ? _f$field$hide : f.default, !ignoreCache);
        });
        options._hiddenFieldsForCheck = [];
        if (fieldChanged) {
          this.checkExpressions(field);
        }
        checkLocked = false;
      };
    }
  }
  parseExpressions(field, path, expr) {
    let parentExpression;
    if (field.parent && ['hide', 'props.disabled'].includes(path)) {
      const rootValue = f => {
        return path === 'hide' ? f.hide : f.props.disabled;
      };
      parentExpression = () => {
        let root = field.parent;
        while (root.parent && !rootValue(root)) {
          root = root.parent;
        }
        return rootValue(root);
      };
    }
    expr = expr || (() => false);
    if (typeof expr === 'string') {
      expr = evalStringExpression(expr, ['model', 'formState', 'field']);
    }
    let currentValue;
    return {
      callback: ignoreCache => {
        try {
          const exprValue = evalExpression(parentExpression ? (...args) => parentExpression(field) || expr(...args) : expr, {
            field
          }, [field.model, field.options.formState, field, ignoreCache]);
          if (ignoreCache || currentValue !== exprValue && (!isObject(exprValue) || (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(exprValue) || JSON.stringify(exprValue) !== JSON.stringify(currentValue))) {
            currentValue = exprValue;
            this.evalExpr(field, path, exprValue);
            return true;
          }
          return false;
        } catch (error) {
          error.message = `[Formly Error] [Expression "${path}"] ${error.message}`;
          throw error;
        }
      }
    };
  }
  checkExpressions(field, ignoreCache = false) {
    var _field$fieldGroup;
    if (!field) {
      return false;
    }
    let fieldChanged = false;
    if (field._expressions) {
      for (const key of Object.keys(field._expressions)) {
        var _field$_expressions$k, _field$_expressions$k2;
        ((_field$_expressions$k = (_field$_expressions$k2 = field._expressions[key]).callback) === null || _field$_expressions$k === void 0 ? void 0 : _field$_expressions$k.call(_field$_expressions$k2, ignoreCache)) && (fieldChanged = true);
      }
    }
    (_field$fieldGroup = field.fieldGroup) === null || _field$fieldGroup === void 0 || _field$fieldGroup.forEach(f => this.checkExpressions(f, ignoreCache) && (fieldChanged = true));
    return fieldChanged;
  }
  changeDisabledState(field, value) {
    if (field.fieldGroup) {
      field.fieldGroup.filter(f => !f._expressions.hasOwnProperty('props.disabled')).forEach(f => this.changeDisabledState(f, value));
    }
    if (hasKey(field) && field.props.disabled !== value) {
      field.props.disabled = value;
    }
  }
  changeHideState(field, hide, resetOnHide) {
    if (field.fieldGroup) {
      field.fieldGroup.filter(f => f && !f._expressions.hide).forEach(f => this.changeHideState(f, hide, resetOnHide));
    }
    if (field.formControl && hasKey(field)) {
      var _c$_fields;
      defineHiddenProp(field, '_hide', !!(hide || field.hide));
      const c = field.formControl;
      if (((_c$_fields = c._fields) === null || _c$_fields === void 0 ? void 0 : _c$_fields.length) > 1) {
        updateValidity(c);
      }
      if (hide === true && (!c._fields || c._fields.every(f => !!f._hide))) {
        unregisterControl(field, true);
        if (resetOnHide && field.resetOnHide) {
          assignFieldValue(field, undefined);
          field.formControl.reset({
            value: undefined,
            disabled: field.formControl.disabled
          });
          field.options.fieldChanges.next({
            value: undefined,
            field,
            type: 'valueChanges'
          });
          if (field.fieldGroup && field.formControl instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormArray) {
            field.fieldGroup.length = 0;
          }
        }
      } else if (hide === false) {
        var _field$fieldGroup2, _field$model;
        if (field.resetOnHide && !isUndefined(field.defaultValue) && isUndefined(getFieldValue(field))) {
          assignFieldValue(field, field.defaultValue);
        }
        registerControl(field, undefined, true);
        if (field.resetOnHide && field.fieldArray && ((_field$fieldGroup2 = field.fieldGroup) === null || _field$fieldGroup2 === void 0 ? void 0 : _field$fieldGroup2.length) !== ((_field$model = field.model) === null || _field$model === void 0 ? void 0 : _field$model.length)) {
          field.options.build(field);
        }
      }
    }
    if (field.options.fieldChanges) {
      field.options.fieldChanges.next({
        field,
        type: 'hidden',
        value: hide
      });
    }
  }
  evalExpr(field, prop, value) {
    if (prop.indexOf('model.') === 0) {
      const key = prop.replace(/^model\./, ''),
        parent = field.fieldGroup ? field : field.parent;
      let control = (field === null || field === void 0 ? void 0 : field.key) === key ? field.formControl : field.form.get(key);
      if (!control && field.get(key)) {
        control = field.get(key).formControl;
      }
      assignFieldValue({
        key,
        parent,
        model: field.model
      }, value);
      if (control && !(isNil(control.value) && isNil(value)) && control.value !== value) {
        control.patchValue(value);
      }
    } else {
      try {
        let target = field;
        const paths = this._evalExpressionPath(field, prop);
        const lastIndex = paths.length - 1;
        for (let i = 0; i < lastIndex; i++) {
          target = target[paths[i]];
        }
        target[paths[lastIndex]] = value;
      } catch (error) {
        error.message = `[Formly Error] [Expression "${prop}"] ${error.message}`;
        throw error;
      }
      if (['templateOptions.disabled', 'props.disabled'].includes(prop) && hasKey(field)) {
        this.changeDisabledState(field, value);
      }
    }
    this.emitExpressionChanges(field, prop, value);
  }
  emitExpressionChanges(field, property, value) {
    if (!field.options.fieldChanges) {
      return;
    }
    field.options.fieldChanges.next({
      field,
      type: 'expressionChanges',
      property,
      value
    });
  }
  _evalExpressionPath(field, prop) {
    if (field._expressions[prop] && field._expressions[prop].paths) {
      return field._expressions[prop].paths;
    }
    let paths = [];
    if (prop.indexOf('[') === -1) {
      paths = prop.split('.');
    } else {
      prop.split(/[[\]]{1,2}/) // https://stackoverflow.com/a/20198206
      .filter(p => p).forEach(path => {
        const arrayPath = path.match(/['|"](.*?)['|"]/);
        if (arrayPath) {
          paths.push(arrayPath[1]);
        } else {
          paths.push(...path.split('.').filter(p => p));
        }
      });
    }
    if (field._expressions[prop]) {
      field._expressions[prop].paths = paths;
    }
    return paths;
  }
}
class CoreExtension {
  constructor(config) {
    this.config = config;
    this.formId = 0;
  }
  prePopulate(field) {
    var _this$getFieldCompone, _this$getFieldCompone2;
    const root = field.parent;
    this.initRootOptions(field);
    this.initFieldProps(field);
    if (root) {
      Object.defineProperty(field, 'options', {
        get: () => root.options,
        configurable: true
      });
      Object.defineProperty(field, 'model', {
        get: () => hasKey(field) && field.fieldGroup ? getFieldValue(field) : root.model,
        configurable: true
      });
    }
    Object.defineProperty(field, 'get', {
      value: key => getField(field, key),
      configurable: true
    });
    (_this$getFieldCompone = (_this$getFieldCompone2 = this.getFieldComponentInstance(field)).prePopulate) === null || _this$getFieldCompone === void 0 || _this$getFieldCompone.call(_this$getFieldCompone2, field);
  }
  onPopulate(field) {
    var _this$getFieldCompone3, _this$getFieldCompone4;
    this.initFieldOptions(field);
    (_this$getFieldCompone3 = (_this$getFieldCompone4 = this.getFieldComponentInstance(field)).onPopulate) === null || _this$getFieldCompone3 === void 0 || _this$getFieldCompone3.call(_this$getFieldCompone4, field);
    if (field.fieldGroup) {
      field.fieldGroup.forEach((f, index) => {
        if (f) {
          Object.defineProperty(f, 'parent', {
            get: () => field,
            configurable: true
          });
          Object.defineProperty(f, 'index', {
            get: () => index,
            configurable: true
          });
        }
        this.formId++;
      });
    }
  }
  postPopulate(field) {
    var _this$getFieldCompone5, _this$getFieldCompone6;
    (_this$getFieldCompone5 = (_this$getFieldCompone6 = this.getFieldComponentInstance(field)).postPopulate) === null || _this$getFieldCompone5 === void 0 || _this$getFieldCompone5.call(_this$getFieldCompone6, field);
  }
  initFieldProps(field) {
    var _field$props;
    (_field$props = field.props) !== null && _field$props !== void 0 ? _field$props : field.props = field.templateOptions;
    Object.defineProperty(field, 'templateOptions', {
      get: () => field.props,
      set: props => field.props = props,
      configurable: true
    });
  }
  initRootOptions(field) {
    if (field.parent) {
      return;
    }
    const options = field.options;
    field.options.formState = field.options.formState || {};
    if (!options.showError) {
      options.showError = this.config.extras.showError;
    }
    if (!options.fieldChanges) {
      defineHiddenProp(options, 'fieldChanges', new rxjs__WEBPACK_IMPORTED_MODULE_5__.Subject());
    }
    if (!options._hiddenFieldsForCheck) {
      options._hiddenFieldsForCheck = [];
    }
    options._detectChanges = f => {
      var _f$fieldGroup;
      if (f._componentRefs) {
        markFieldForCheck(f);
      }
      (_f$fieldGroup = f.fieldGroup) === null || _f$fieldGroup === void 0 || _f$fieldGroup.forEach(f => f && options._detectChanges(f));
    };
    options.detectChanges = f => {
      var _f$options$checkExpre, _f$options;
      (_f$options$checkExpre = (_f$options = f.options).checkExpressions) === null || _f$options$checkExpre === void 0 || _f$options$checkExpre.call(_f$options, f);
      options._detectChanges(f);
    };
    options.resetModel = model => {
      model = clone(model !== null && model !== void 0 ? model : options._initialModel);
      if (field.model) {
        Object.keys(field.model).forEach(k => delete field.model[k]);
        Object.assign(field.model, model || {});
      }
      if (!isSignalRequired()) {
        observe(options, ['parentForm', 'submitted']).setValue(false, false);
      }
      options.build(field);
      field.form.reset(field.model);
    };
    options.updateInitialValue = model => options._initialModel = clone(model !== null && model !== void 0 ? model : field.model);
    field.options.updateInitialValue();
  }
  initFieldOptions(field) {
    var _field$expressions, _field$expressionProp;
    reverseDeepMerge(field, {
      id: getFieldId(`formly_${this.formId}`, field, field.index),
      hooks: {},
      modelOptions: {},
      validation: {
        messages: {}
      },
      props: !field.type || !hasKey(field) ? {} : {
        label: '',
        placeholder: '',
        disabled: false
      }
    });
    if (this.config.extras.resetFieldOnHide && field.resetOnHide !== false) {
      field.resetOnHide = true;
    }
    if (field.type !== 'formly-template' && (field.template || (_field$expressions = field.expressions) !== null && _field$expressions !== void 0 && _field$expressions.template || (_field$expressionProp = field.expressionProperties) !== null && _field$expressionProp !== void 0 && _field$expressionProp.template)) {
      field.type = 'formly-template';
    }
    if (!field.type && field.fieldGroup) {
      field.type = 'formly-group';
    }
    if (field.type) {
      this.config.getMergedField(field);
    }
    if (hasKey(field) && !isUndefined(field.defaultValue) && isUndefined(getFieldValue(field)) && !isHiddenField(field)) {
      assignFieldValue(field, field.defaultValue);
    }
    field.wrappers = field.wrappers || [];
  }
  getFieldComponentInstance(field) {
    const componentRefInstance = () => {
      var _field$_componentRefs2, _componentRef, _componentRef2;
      let componentRef = this.config.resolveFieldTypeRef(field);
      const fieldComponentRef = (_field$_componentRefs2 = field._componentRefs) === null || _field$_componentRefs2 === void 0 ? void 0 : _field$_componentRefs2.slice(-1)[0];
      if (fieldComponentRef instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentRef && (fieldComponentRef === null || fieldComponentRef === void 0 ? void 0 : fieldComponentRef.componentType) === ((_componentRef = componentRef) === null || _componentRef === void 0 ? void 0 : _componentRef.componentType)) {
        componentRef = fieldComponentRef;
      }
      return (_componentRef2 = componentRef) === null || _componentRef2 === void 0 ? void 0 : _componentRef2.instance;
    };
    if (!field._proxyInstance) {
      defineHiddenProp(field, '_proxyInstance', new Proxy({}, {
        get: (_, prop) => {
          var _componentRefInstance;
          return (_componentRefInstance = componentRefInstance()) === null || _componentRefInstance === void 0 ? void 0 : _componentRefInstance[prop];
        },
        set: (_, prop, value) => componentRefInstance()[prop] = value
      }));
    }
    return field._proxyInstance;
  }
}
class FieldFormExtension {
  prePopulate(field) {
    if (!this.root) {
      this.root = field;
    }
    if (field.parent) {
      Object.defineProperty(field, 'form', {
        get: () => field.parent.formControl,
        configurable: true
      });
    }
  }
  onPopulate(field) {
    if (field.hasOwnProperty('fieldGroup') && !hasKey(field)) {
      defineHiddenProp(field, 'formControl', field.form);
    } else {
      this.addFormControl(field);
    }
  }
  postPopulate(field) {
    if (this.root !== field) {
      return;
    }
    this.root = null;
    const markForCheck = this.setValidators(field);
    if (markForCheck && field.parent) {
      let parent = field.parent;
      while (parent) {
        if (hasKey(parent) || !parent.parent) {
          updateValidity(parent.formControl, true);
        }
        parent = parent.parent;
      }
    }
  }
  addFormControl(field) {
    let control = findControl(field);
    if (field.fieldArray) {
      return;
    }
    if (!control) {
      const controlOptions = {
        updateOn: field.modelOptions.updateOn
      };
      if (field.fieldGroup) {
        control = new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormGroup({}, controlOptions);
      } else {
        const value = hasKey(field) ? getFieldValue(field) : field.defaultValue;
        control = new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormControl({
          value,
          disabled: !!field.props.disabled
        }, {
          ...controlOptions,
          initialValueIsDefault: true
        });
      }
    } else {
      if (control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl) {
        const value = hasKey(field) ? getFieldValue(field) : field.defaultValue;
        control.defaultValue = value;
      }
    }
    registerControl(field, control);
  }
  setValidators(field, disabled = false) {
    var _field$props2, _field$fieldGroup3;
    if (disabled === false && hasKey(field) && (_field$props2 = field.props) !== null && _field$props2 !== void 0 && _field$props2.disabled) {
      disabled = true;
    }
    let markForCheck = false;
    (_field$fieldGroup3 = field.fieldGroup) === null || _field$fieldGroup3 === void 0 || _field$fieldGroup3.forEach(f => f && this.setValidators(f, disabled) && (markForCheck = true));
    if (hasKey(field) || !field.parent || !hasKey(field) && !field.fieldGroup) {
      const {
        formControl: c
      } = field;
      if (c) {
        if (hasKey(field) && c instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl) {
          if (disabled && c.enabled) {
            c.disable({
              emitEvent: false,
              onlySelf: true
            });
            markForCheck = true;
          }
          if (!disabled && c.disabled) {
            c.enable({
              emitEvent: false,
              onlySelf: true
            });
            markForCheck = true;
          }
        }
        if (null === c.validator && this.hasValidators(field, '_validators')) {
          c.setValidators(() => {
            const v = _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.compose(this.mergeValidators(field, '_validators'));
            return v ? v(c) : null;
          });
          markForCheck = true;
        }
        if (null === c.asyncValidator && this.hasValidators(field, '_asyncValidators')) {
          c.setAsyncValidators(() => {
            const v = _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.composeAsync(this.mergeValidators(field, '_asyncValidators'));
            return v ? v(c) : (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.of)(null);
          });
          markForCheck = true;
        }
        if (markForCheck) {
          updateValidity(c, true);
          // update validity of `FormGroup` instance created by field with nested key.
          let parent = c.parent;
          for (let i = 1; i < getKeyPath(field).length; i++) {
            if (parent) {
              updateValidity(parent, true);
              parent = parent.parent;
            }
          }
        }
      }
    }
    return markForCheck;
  }
  hasValidators(field, type) {
    var _c$_fields2, _field$fieldGroup4;
    const c = field.formControl;
    if ((c === null || c === void 0 || (_c$_fields2 = c._fields) === null || _c$_fields2 === void 0 ? void 0 : _c$_fields2.length) > 1 && c._fields.some(f => f[type].length > 0)) {
      return true;
    } else if (field[type].length > 0) {
      return true;
    }
    return (_field$fieldGroup4 = field.fieldGroup) === null || _field$fieldGroup4 === void 0 ? void 0 : _field$fieldGroup4.some(f => (f === null || f === void 0 ? void 0 : f.fieldGroup) && !hasKey(f) && this.hasValidators(f, type));
  }
  mergeValidators(field, type) {
    var _c$_fields3;
    const validators = [];
    const c = field.formControl;
    if ((c === null || c === void 0 || (_c$_fields3 = c._fields) === null || _c$_fields3 === void 0 ? void 0 : _c$_fields3.length) > 1) {
      c._fields.filter(f => !f._hide).forEach(f => validators.push(...f[type]));
    } else if (field[type]) {
      validators.push(...field[type]);
    }
    if (field.fieldGroup) {
      field.fieldGroup.filter(f => (f === null || f === void 0 ? void 0 : f.fieldGroup) && !hasKey(f)).forEach(f => validators.push(...this.mergeValidators(f, type)));
    }
    return validators;
  }
}
class FieldValidationExtension {
  constructor(config) {
    this.config = config;
  }
  onPopulate(field) {
    this.initFieldValidation(field, 'validators');
    this.initFieldValidation(field, 'asyncValidators');
  }
  initFieldValidation(field, type) {
    const validators = [];
    if (type === 'validators' && !(field.hasOwnProperty('fieldGroup') && !hasKey(field))) {
      validators.push(this.getPredefinedFieldValidation(field));
    }
    if (field[type]) {
      for (const validatorName of Object.keys(field[type])) {
        validatorName === 'validation' ? validators.push(...field[type].validation.map(v => this.wrapNgValidatorFn(field, v))) : validators.push(this.wrapNgValidatorFn(field, field[type][validatorName], validatorName));
      }
    }
    defineHiddenProp(field, '_' + type, validators);
  }
  getPredefinedFieldValidation(field) {
    let VALIDATORS = [];
    FORMLY_VALIDATORS.forEach(opt => observe(field, ['props', opt], ({
      currentValue,
      firstChange
    }) => {
      VALIDATORS = VALIDATORS.filter(o => o !== opt);
      if (opt === 'required' && currentValue != null && typeof currentValue !== 'boolean') {
        console.warn(`Formly: Invalid prop 'required' of type '${typeof currentValue}', expected 'boolean' (Field:${field.key}).`);
      }
      if (currentValue != null && currentValue !== false) {
        VALIDATORS.push(opt);
      }
      if (!firstChange && field.formControl) {
        updateValidity(field.formControl);
      }
    }));
    return control => {
      if (VALIDATORS.length === 0) {
        return null;
      }
      return _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.compose(VALIDATORS.map(opt => () => {
        var _field$validation, _field$validation2;
        const value = field.props[opt];
        switch (opt) {
          case 'required':
            return _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.required(control);
          case 'pattern':
            return _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.pattern(value)(control);
          case 'minLength':
            const minLengthResult = _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.minLength(value)(control);
            const minLengthKey = this.config.getValidatorMessage('minlength') || (_field$validation = field.validation) !== null && _field$validation !== void 0 && (_field$validation = _field$validation.messages) !== null && _field$validation !== void 0 && _field$validation.minlength ? 'minlength' : 'minLength';
            return minLengthResult ? {
              [minLengthKey]: minLengthResult.minlength
            } : null;
          case 'maxLength':
            const maxLengthResult = _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.maxLength(value)(control);
            const maxLengthKey = this.config.getValidatorMessage('maxlength') || (_field$validation2 = field.validation) !== null && _field$validation2 !== void 0 && (_field$validation2 = _field$validation2.messages) !== null && _field$validation2 !== void 0 && _field$validation2.maxlength ? 'maxlength' : 'maxLength';
            return maxLengthResult ? {
              [maxLengthKey]: maxLengthResult.maxlength
            } : null;
          case 'min':
            return _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.min(value)(control);
          case 'max':
            return _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.max(value)(control);
          default:
            return null;
        }
      }))(control);
    };
  }
  wrapNgValidatorFn(field, validator, validatorName) {
    let validatorOption;
    if (typeof validator === 'string') {
      validatorOption = clone(this.config.getValidator(validator));
    }
    if (typeof validator === 'object' && validator.name) {
      validatorOption = clone(this.config.getValidator(validator.name));
      if (validator.options) {
        validatorOption.options = validator.options;
      }
    }
    if (typeof validator === 'object' && validator.expression) {
      const {
        expression,
        ...options
      } = validator;
      validatorOption = {
        name: validatorName,
        validation: expression,
        options: Object.keys(options).length > 0 ? options : null
      };
    }
    if (typeof validator === 'function') {
      validatorOption = {
        name: validatorName,
        validation: validator
      };
    }
    return control => {
      const errors = validatorOption.validation(control, field, validatorOption.options);
      if (isPromise(errors)) {
        return errors.then(v => this.handleResult(field, validatorName ? !!v : v, validatorOption));
      }
      if ((0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(errors)) {
        return errors.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.map)(v => this.handleResult(field, validatorName ? !!v : v, validatorOption)));
      }
      return this.handleResult(field, validatorName ? !!errors : errors, validatorOption);
    };
  }
  handleResult(field, errors, {
    name,
    options
  }) {
    var _ctrl$_childrenErrors, _ctrl$_childrenErrors2;
    if (typeof errors === 'boolean') {
      errors = errors ? null : {
        [name]: options ? options : true
      };
    }
    const ctrl = field.formControl;
    ctrl === null || ctrl === void 0 || (_ctrl$_childrenErrors = ctrl._childrenErrors) === null || _ctrl$_childrenErrors === void 0 || (_ctrl$_childrenErrors2 = _ctrl$_childrenErrors[name]) === null || _ctrl$_childrenErrors2 === void 0 || _ctrl$_childrenErrors2.call(_ctrl$_childrenErrors);
    if (isObject(errors)) {
      Object.keys(errors).forEach(name => {
        const errorPath = errors[name].errorPath ? errors[name].errorPath : options === null || options === void 0 ? void 0 : options.errorPath;
        const childCtrl = errorPath ? field.formControl.get(errorPath) : null;
        if (childCtrl) {
          const {
            errorPath: _errorPath,
            ...opts
          } = errors[name];
          childCtrl.setErrors({
            ...(childCtrl.errors || {}),
            [name]: opts
          });
          !ctrl._childrenErrors && defineHiddenProp(ctrl, '_childrenErrors', {});
          ctrl._childrenErrors[name] = () => {
            const {
              [name]: _toDelete,
              ...childErrors
            } = childCtrl.errors || {};
            childCtrl.setErrors(Object.keys(childErrors).length === 0 ? null : childErrors);
          };
        }
      });
    }
    return errors;
  }
}
class FieldType {
  constructor() {
    this.field = {};
  }
  set _formlyControls(controls) {
    const f = this.field;
    f._localFields = controls.map(c => c.control._fields || []).flat().filter(f => f.formControl !== this.field.formControl);
  }
  get model() {
    return this.field.model;
  }
  get form() {
    return this.field.form;
  }
  get options() {
    return this.field.options;
  }
  get key() {
    return this.field.key;
  }
  get formControl() {
    return this.field.formControl;
  }
  get props() {
    return this.field.props || {};
  }
  /** @deprecated Use `props` instead. */
  get to() {
    return this.props;
  }
  get showError() {
    return this.options.showError(this);
  }
  get id() {
    return this.field.id;
  }
  get formState() {
    var _this$options;
    return ((_this$options = this.options) === null || _this$options === void 0 ? void 0 : _this$options.formState) || {};
  }
}
_FieldType = FieldType;
_FieldType.ɵfac = function _FieldType_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FieldType)();
};
_FieldType.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _FieldType,
  viewQuery: function _FieldType_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControl, 5);
    }
    if (rf & 2) {
      let _t;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._formlyControls = _t);
    }
  },
  inputs: {
    field: "field"
  }
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FieldType, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive
  }], null, {
    _formlyControls: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChildren,
      args: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.NgControl]
    }],
    field: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }]
  });
})();

/** @ignore */
class FormlyTemplateType extends FieldType {
  get template() {
    if (this.field && this.field.template !== this.innerHtml.template) {
      this.innerHtml = {
        template: this.field.template,
        content: this.props.safeHtml ? this.sanitizer.bypassSecurityTrustHtml(this.field.template) : this.field.template
      };
    }
    return this.innerHtml.content;
  }
  constructor(sanitizer) {
    super();
    this.sanitizer = sanitizer;
    this.innerHtml = {};
  }
}
_FormlyTemplateType = FormlyTemplateType;
_FormlyTemplateType.ɵfac = function _FormlyTemplateType_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyTemplateType)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_platform_browser__WEBPACK_IMPORTED_MODULE_8__.DomSanitizer));
};
_FormlyTemplateType.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyTemplateType,
  selectors: [["formly-template"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 1,
  vars: 1,
  consts: [[3, "innerHtml"]],
  template: function _FormlyTemplateType_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("innerHtml", ctx.template, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeHtml"]);
    }
  },
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyTemplateType, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-template',
      template: `<div [innerHtml]="template"></div>`,
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush
    }]
  }], () => [{
    type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_8__.DomSanitizer
  }], null);
})();

/**
 * Maintains list of formly config options. This can be used to register new field type.
 */
class FormlyConfig {
  constructor() {
    this.types = {};
    this.validators = {};
    this.wrappers = {};
    this.messages = {};
    this.extras = {
      checkExpressionOn: 'modelChange',
      lazyRender: true,
      resetFieldOnHide: true,
      renderFormlyFieldElement: true,
      showError(field) {
        var _field$formControl, _field$formControl2, _field$options$parent, _field$field$validati;
        return ((_field$formControl = field.formControl) === null || _field$formControl === void 0 ? void 0 : _field$formControl.invalid) && (((_field$formControl2 = field.formControl) === null || _field$formControl2 === void 0 ? void 0 : _field$formControl2.touched) || ((_field$options$parent = field.options.parentForm) === null || _field$options$parent === void 0 ? void 0 : _field$options$parent.submitted) || !!((_field$field$validati = field.field.validation) !== null && _field$field$validati !== void 0 && _field$field$validati.show));
      }
    };
    this.extensions = {};
    this.presets = {};
    this.extensionsByPriority = {};
    this.componentRefs = {};
  }
  addConfig(config) {
    if (Array.isArray(config)) {
      config.forEach(c => this.addConfig(c));
      return;
    }
    if (config.types) {
      config.types.forEach(type => this.setType(type));
    }
    if (config.validators) {
      config.validators.forEach(validator => this.setValidator(validator));
    }
    if (config.wrappers) {
      config.wrappers.forEach(wrapper => this.setWrapper(wrapper));
    }
    if (config.validationMessages) {
      config.validationMessages.forEach(validation => this.addValidatorMessage(validation.name, validation.message));
    }
    if (config.extensions) {
      this.setSortedExtensions(config.extensions);
    }
    if (config.extras) {
      this.extras = {
        ...this.extras,
        ...config.extras
      };
    }
    if (config.presets) {
      this.presets = {
        ...this.presets,
        ...config.presets.reduce((acc, curr) => ({
          ...acc,
          [curr.name]: curr.config
        }), {})
      };
    }
  }
  /**
   * Allows you to specify a custom type which you can use in your field configuration.
   * You can pass an object of options, or an array of objects of options.
   */
  setType(options) {
    if (Array.isArray(options)) {
      options.forEach(option => this.setType(option));
    } else {
      if (!this.types[options.name]) {
        this.types[options.name] = {
          name: options.name
        };
      }
      ['component', 'extends', 'defaultOptions', 'wrappers'].forEach(prop => {
        if (options.hasOwnProperty(prop)) {
          this.types[options.name][prop] = options[prop];
        }
      });
    }
  }
  getType(name, throwIfNotFound = false) {
    if (name instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.Type) {
      return {
        component: name,
        name: name.prototype.constructor.name
      };
    }
    if (!this.types[name]) {
      if (throwIfNotFound) {
        throw new Error(`[Formly Error] The type "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
      }
      return null;
    }
    this.mergeExtendedType(name);
    return this.types[name];
  }
  /** @ignore */
  getMergedField(field = {}) {
    var _componentRef$instanc;
    const type = this.getType(field.type);
    if (!type) {
      return;
    }
    if (type.defaultOptions) {
      reverseDeepMerge(field, type.defaultOptions);
    }
    const extendDefaults = type.extends && this.getType(type.extends).defaultOptions;
    if (extendDefaults) {
      reverseDeepMerge(field, extendDefaults);
    }
    if (field !== null && field !== void 0 && field.optionsTypes) {
      field.optionsTypes.forEach(option => {
        const defaultOptions = this.getType(option).defaultOptions;
        if (defaultOptions) {
          reverseDeepMerge(field, defaultOptions);
        }
      });
    }
    const componentRef = this.resolveFieldTypeRef(field);
    if (componentRef !== null && componentRef !== void 0 && (_componentRef$instanc = componentRef.instance) !== null && _componentRef$instanc !== void 0 && _componentRef$instanc.defaultOptions) {
      reverseDeepMerge(field, componentRef.instance.defaultOptions);
    }
    if (!field.wrappers && type.wrappers) {
      field.wrappers = [...type.wrappers];
    }
  }
  /** @ignore @internal */
  resolveFieldTypeRef(field = {}) {
    const type = this.getType(field.type);
    if (!type) {
      return null;
    }
    if (!type.component) {
      return null;
    }
    if (!this.componentRefs[type.name]) {
      const {
        _viewContainerRef,
        _injector
      } = field.options;
      if (!_viewContainerRef || !_injector) {
        return null;
      }
      const componentRef = _viewContainerRef.createComponent(type.component, {
        injector: _injector
      });
      this.componentRefs[type.name] = componentRef;
      try {
        componentRef.destroy();
      } catch (e) {
        console.error(`An error occurred while destroying the Formly component type "${field.type}"`, e);
      }
    }
    return this.componentRefs[type.name];
  }
  /** @ignore @internal */
  clearRefs() {
    this.componentRefs = {};
  }
  setWrapper(options) {
    this.wrappers[options.name] = options;
    if (options.types) {
      options.types.forEach(type => {
        this.setTypeWrapper(type, options.name);
      });
    }
  }
  getWrapper(name) {
    if (name instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.Type) {
      return {
        component: name,
        name: name.prototype.constructor.name
      };
    }
    if (!this.wrappers[name]) {
      throw new Error(`[Formly Error] The wrapper "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
    }
    return this.wrappers[name];
  }
  /** @ignore */
  setTypeWrapper(type, name) {
    if (!this.types[type]) {
      this.types[type] = {};
    }
    if (!this.types[type].wrappers) {
      this.types[type].wrappers = [];
    }
    if (this.types[type].wrappers.indexOf(name) === -1) {
      this.types[type].wrappers.push(name);
    }
  }
  setValidator(options) {
    this.validators[options.name] = options;
  }
  getValidator(name) {
    if (!this.validators[name]) {
      throw new Error(`[Formly Error] The validator "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
    }
    return this.validators[name];
  }
  addValidatorMessage(name, message) {
    this.messages[name] = message;
    if (typeof ngDevMode === 'undefined' || ngDevMode) {
      const deprecated = {
        minlength: 'minLength',
        maxlength: 'maxLength'
      };
      if (deprecated[name]) {
        console.warn(`Formly deprecation: passing validation messages key '${name}' is deprecated since v6.0, use '${deprecated[name]}' instead.`);
        this.messages[deprecated[name]] = message;
      }
    }
  }
  getValidatorMessage(name) {
    return this.messages[name];
  }
  setSortedExtensions(extensionOptions) {
    // insert new extensions, grouped by priority
    extensionOptions.forEach(extensionOption => {
      var _extensionOption$prio;
      const priority = (_extensionOption$prio = extensionOption.priority) !== null && _extensionOption$prio !== void 0 ? _extensionOption$prio : 1;
      this.extensionsByPriority[priority] = {
        ...this.extensionsByPriority[priority],
        [extensionOption.name]: extensionOption.extension
      };
    });
    // flatten extensions object with sorted keys
    this.extensions = Object.keys(this.extensionsByPriority).map(Number).sort((a, b) => a - b).reduce((acc, prio) => ({
      ...acc,
      ...this.extensionsByPriority[prio]
    }), {});
  }
  mergeExtendedType(name) {
    if (!this.types[name].extends) {
      return;
    }
    const extendedType = this.getType(this.types[name].extends);
    if (!this.types[name].component) {
      this.types[name].component = extendedType.component;
    }
    if (!this.types[name].wrappers) {
      this.types[name].wrappers = extendedType.wrappers;
    }
  }
}
_FormlyConfig = FormlyConfig;
_FormlyConfig.ɵfac = function _FormlyConfig_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyConfig)();
};
_FormlyConfig.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
  token: _FormlyConfig,
  factory: _FormlyConfig.ɵfac,
  providedIn: 'root'
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyConfig, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], null, null);
})();
class FormlyTemplate {
  constructor(ref) {
    this.ref = ref;
  }
  ngOnChanges() {
    this.name = this.name || 'formly-group';
  }
}
_FormlyTemplate = FormlyTemplate;
_FormlyTemplate.ɵfac = function _FormlyTemplate_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyTemplate)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
};
_FormlyTemplate.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _FormlyTemplate,
  selectors: [["", "formlyTemplate", ""]],
  inputs: {
    name: [0, "formlyTemplate", "name"]
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyTemplate, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      selector: '[formlyTemplate]'
    }]
  }], () => [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef
  }], {
    name: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['formlyTemplate']
    }]
  });
})();
// workarround for https://github.com/angular/angular/issues/43227#issuecomment-904173738
class FormlyFieldTemplates {}
_FormlyFieldTemplates = FormlyFieldTemplates;
_FormlyFieldTemplates.ɵfac = function _FormlyFieldTemplates_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyFieldTemplates)();
};
_FormlyFieldTemplates.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
  token: _FormlyFieldTemplates,
  factory: _FormlyFieldTemplates.ɵfac
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFieldTemplates, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Injectable
  }], null, null);
})();

/**
 * The `<formly-field>` component is used to render the UI widget (layout + type) of a given `field`.
 */
class FormlyField {
  get containerRef() {
    return this.config.extras.renderFormlyFieldElement ? this.viewContainerRef : this.hostContainerRef;
  }
  get elementRef() {
    var _this$componentRefs;
    if (this.config.extras.renderFormlyFieldElement) {
      return this._elementRef;
    }
    if (((_this$componentRefs = this.componentRefs) === null || _this$componentRefs === void 0 ? void 0 : _this$componentRefs[0]) instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentRef) {
      return this.componentRefs[0].location;
    }
    return null;
  }
  constructor(config, renderer, _elementRef, hostContainerRef, form) {
    this.config = config;
    this.renderer = renderer;
    this._elementRef = _elementRef;
    this.hostContainerRef = hostContainerRef;
    this.form = form;
    this.hostObservers = [];
    this.componentRefs = [];
    this.hooksObservers = [];
    this.detectFieldBuild = false;
    this.valueChangesUnsubscribe = () => {};
  }
  ngAfterContentInit() {
    this.triggerHook('afterContentInit');
  }
  ngAfterViewInit() {
    this.triggerHook('afterViewInit');
  }
  ngDoCheck() {
    if (this.detectFieldBuild && this.field && this.field.options) {
      this.render();
    }
  }
  ngOnInit() {
    this.triggerHook('onInit');
  }
  ngOnChanges(changes) {
    this.triggerHook('onChanges', changes);
  }
  ngOnDestroy() {
    this.resetRefs(this.field);
    this.hostObservers.forEach(hostObserver => hostObserver.unsubscribe());
    this.hooksObservers.forEach(unsubscribe => unsubscribe());
    this.valueChangesUnsubscribe();
    this.triggerHook('onDestroy');
  }
  renderField(containerRef, f, wrappers = []) {
    var _wrappers;
    if (this.containerRef === containerRef) {
      var _this$field;
      this.resetRefs(this.field);
      this.containerRef.clear();
      wrappers = (_this$field = this.field) === null || _this$field === void 0 ? void 0 : _this$field.wrappers;
    }
    if (((_wrappers = wrappers) === null || _wrappers === void 0 ? void 0 : _wrappers.length) > 0) {
      const [wrapper, ...wps] = wrappers;
      const {
        component
      } = this.config.getWrapper(wrapper);
      const ref = containerRef.createComponent(component);
      this.attachComponentRef(ref, f);
      observe(ref.instance, ['fieldComponent'], ({
        currentValue,
        previousValue,
        firstChange
      }) => {
        if (currentValue) {
          if (previousValue && previousValue._lContainer === currentValue._lContainer) {
            return;
          }
          const viewRef = previousValue ? previousValue.detach() : null;
          if (viewRef && !viewRef.destroyed) {
            currentValue.insert(viewRef);
          } else {
            this.renderField(currentValue, f, wps);
          }
          !firstChange && ref.changeDetectorRef.detectChanges();
        }
      });
    } else if (f !== null && f !== void 0 && f.type) {
      var _this$form;
      const inlineType = (_this$form = this.form) === null || _this$form === void 0 || (_this$form = _this$form.templates) === null || _this$form === void 0 ? void 0 : _this$form.find(ref => ref.name === f.type);
      let ref;
      if (inlineType) {
        ref = containerRef.createEmbeddedView(inlineType.ref, {
          $implicit: f
        });
      } else {
        const {
          component
        } = this.config.getType(f.type, true);
        ref = containerRef.createComponent(component);
      }
      this.attachComponentRef(ref, f);
    }
  }
  triggerHook(name, changes) {
    var _this$field2;
    if (name === 'onInit' || name === 'onChanges' && changes.field && !changes.field.firstChange) {
      this.valueChangesUnsubscribe();
      this.valueChangesUnsubscribe = this.fieldChanges(this.field);
    }
    if ((_this$field2 = this.field) !== null && _this$field2 !== void 0 && (_this$field2 = _this$field2.hooks) !== null && _this$field2 !== void 0 && _this$field2[name]) {
      if (!changes || changes.field) {
        const r = this.field.hooks[name](this.field);
        if ((0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(r) && ['onInit', 'afterContentInit', 'afterViewInit'].indexOf(name) !== -1) {
          const sub = r.subscribe();
          this.hooksObservers.push(() => sub.unsubscribe());
        }
      }
    }
    if (name === 'onChanges' && changes.field) {
      this.resetRefs(changes.field.previousValue);
      this.render();
    }
  }
  attachComponentRef(ref, field) {
    this.componentRefs.push(ref);
    field._componentRefs.push(ref);
    if (ref instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentRef) {
      Object.assign(ref.instance, {
        field
      });
    }
  }
  render() {
    if (!this.field) {
      return;
    }
    // require Formly build
    if (!this.field.options) {
      this.detectFieldBuild = true;
      return;
    }
    this.detectFieldBuild = false;
    this.hostObservers.forEach(hostObserver => hostObserver.unsubscribe());
    this.hostObservers = [observe(this.field, ['hide'], ({
      firstChange,
      currentValue
    }) => {
      const containerRef = this.containerRef;
      if (this.config.extras.lazyRender === false) {
        firstChange && this.renderField(containerRef, this.field);
        if (!firstChange || firstChange && currentValue) {
          this.elementRef && this.renderer.setStyle(this.elementRef.nativeElement, 'display', currentValue ? 'none' : '');
        }
      } else {
        if (currentValue) {
          containerRef.clear();
          if (this.field.className) {
            this.renderer.removeAttribute(this.elementRef.nativeElement, 'class');
          }
        } else {
          this.renderField(containerRef, this.field);
          if (this.field.className) {
            this.renderer.setAttribute(this.elementRef.nativeElement, 'class', this.field.className);
          }
        }
      }
      !firstChange && this.field.options.detectChanges(this.field);
    }), observe(this.field, ['className'], ({
      firstChange,
      currentValue
    }) => {
      if ((!firstChange || firstChange && currentValue) && (!this.config.extras.lazyRender || this.field.hide !== true)) {
        this.elementRef && this.renderer.setAttribute(this.elementRef.nativeElement, 'class', currentValue);
      }
    })];
    if (!isSignalRequired()) {
      ['touched', 'pristine', 'status'].forEach(prop => this.hostObservers.push(observe(this.field, ['formControl', prop], ({
        firstChange
      }) => !firstChange && markFieldForCheck(this.field))));
    } else if (this.field.formControl) {
      const events = this.field.formControl.events.subscribe(() => markFieldForCheck(this.field));
      this.hostObservers.push(events);
    }
  }
  resetRefs(field) {
    if (field) {
      if (field._localFields) {
        field._localFields = [];
      } else {
        defineHiddenProp(this.field, '_localFields', []);
      }
      if (field._componentRefs) {
        field._componentRefs = field._componentRefs.filter(ref => this.componentRefs.indexOf(ref) === -1);
      } else {
        defineHiddenProp(this.field, '_componentRefs', []);
      }
    }
    this.componentRefs = [];
  }
  fieldChanges(field) {
    if (!field) {
      return () => {};
    }
    const propsObserver = observeDeep(field, ['props'], () => field.options.detectChanges(field));
    const subscribes = [() => {
      propsObserver();
    }];
    for (const key of Object.keys(field._expressions || {})) {
      const expressionObserver = observe(field, ['_expressions', key], ({
        currentValue,
        previousValue
      }) => {
        if (previousValue !== null && previousValue !== void 0 && previousValue.subscription) {
          previousValue.subscription.unsubscribe();
          previousValue.subscription = null;
        }
        if ((0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(currentValue.value$)) {
          currentValue.subscription = currentValue.value$.subscribe();
        }
      });
      subscribes.push(() => {
        var _field$_expressions$k3;
        if ((_field$_expressions$k3 = field._expressions[key]) !== null && _field$_expressions$k3 !== void 0 && _field$_expressions$k3.subscription) {
          field._expressions[key].subscription.unsubscribe();
        }
        expressionObserver.unsubscribe();
      });
    }
    for (const path of [['focus'], ['template'], ['fieldGroupClassName'], ['validation', 'show']]) {
      const fieldObserver = observe(field, path, ({
        firstChange
      }) => !firstChange && field.options.detectChanges(field));
      subscribes.push(() => fieldObserver.unsubscribe());
    }
    if (field.formControl && !field.fieldGroup) {
      const control = field.formControl;
      let valueChanges = control.valueChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.map)(value => {
        var _field$parsers;
        (_field$parsers = field.parsers) === null || _field$parsers === void 0 || _field$parsers.map(parserFn => value = parserFn(value, field));
        if (!Object.is(value, field.formControl.value)) {
          field.formControl.setValue(value);
        }
        return value;
      }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.distinctUntilChanged)((x, y) => {
        if (x !== y || Array.isArray(x) || isObject(x)) {
          return false;
        }
        return true;
      }));
      if (control.value !== getFieldValue(field)) {
        valueChanges = valueChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.startWith)(control.value));
      }
      const {
        updateOn,
        debounce
      } = field.modelOptions;
      if ((!updateOn || updateOn === 'change') && (debounce === null || debounce === void 0 ? void 0 : debounce.default) > 0) {
        valueChanges = valueChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.debounceTime)(debounce.default));
      }
      const sub = valueChanges.subscribe(value => {
        var _control$_fields;
        // workaround for https://github.com/angular/angular/issues/13792
        if (((_control$_fields = control._fields) === null || _control$_fields === void 0 ? void 0 : _control$_fields.length) > 1 && control instanceof _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl) {
          control.patchValue(value, {
            emitEvent: false,
            onlySelf: true
          });
        }
        if (hasKey(field)) {
          assignFieldValue(field, value);
        }
        field.options.fieldChanges.next({
          value,
          field,
          type: 'valueChanges'
        });
      });
      subscribes.push(() => sub.unsubscribe());
    }
    let templateFieldsSubs = [];
    observe(field, ['_localFields'], ({
      currentValue
    }) => {
      templateFieldsSubs.forEach(unsubscribe => unsubscribe());
      templateFieldsSubs = (currentValue || []).map(f => this.fieldChanges(f));
    });
    return () => {
      subscribes.forEach(unsubscribe => unsubscribe());
      templateFieldsSubs.forEach(unsubscribe => unsubscribe());
    };
  }
}
_FormlyField = FormlyField;
_FormlyField.ɵfac = function _FormlyField_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyField)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyFieldTemplates, 8));
};
_FormlyField.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyField,
  selectors: [["formly-field"]],
  viewQuery: function _FormlyField_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c0, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef);
    }
    if (rf & 2) {
      let _t;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.viewContainerRef = _t.first);
    }
  },
  inputs: {
    field: "field"
  },
  standalone: true,
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵStandaloneFeature"]],
  decls: 2,
  vars: 0,
  consts: [["container", ""]],
  template: function _FormlyField_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, _FormlyField_ng_template_0_Template, 0, 0, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    }
  },
  styles: ["[_nghost-%COMP%]:empty{display:none}"]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyField, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field',
      template: '<ng-template #container></ng-template>',
      standalone: true,
      styles: [":host:empty{display:none}\n"]
    }]
  }], () => [{
    type: FormlyConfig
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef
  }, {
    type: FormlyFieldTemplates,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
    }]
  }], {
    field: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    viewContainerRef: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild,
      args: ['container', {
        read: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef,
        static: true
      }]
    }]
  });
})();
class LegacyFormlyField extends FormlyField {}
_LegacyFormlyField = LegacyFormlyField;
_LegacyFormlyField.ɵfac = /* @__PURE__ */(() => {
  let ɵ_LegacyFormlyField_BaseFactory;
  return function _LegacyFormlyField_Factory(__ngFactoryType__) {
    return (ɵ_LegacyFormlyField_BaseFactory || (ɵ_LegacyFormlyField_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_LegacyFormlyField)))(__ngFactoryType__ || _LegacyFormlyField);
  };
})();
_LegacyFormlyField.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _LegacyFormlyField,
  selectors: [["formly-field"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 2,
  vars: 0,
  consts: [["container", ""]],
  template: function _LegacyFormlyField_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, _LegacyFormlyField_ng_template_0_Template, 0, 0, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    }
  },
  styles: ["[_nghost-%COMP%]:empty{display:none}"]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](LegacyFormlyField, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-field',
      template: '<ng-template #container></ng-template>',
      standalone: false,
      styles: [":host:empty{display:none}\n"]
    }]
  }], null, null);
})();

/** @ignore */
class FormlyGroup extends FieldType {}
_FormlyGroup = FormlyGroup;
_FormlyGroup.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FormlyGroup_BaseFactory;
  return function _FormlyGroup_Factory(__ngFactoryType__) {
    return (ɵ_FormlyGroup_BaseFactory || (ɵ_FormlyGroup_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FormlyGroup)))(__ngFactoryType__ || _FormlyGroup);
  };
})();
_FormlyGroup.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyGroup,
  selectors: [["formly-group"]],
  hostVars: 2,
  hostBindings: function _FormlyGroup_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"](ctx.field.fieldGroupClassName || "");
    }
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  ngContentSelectors: _c1,
  decls: 3,
  vars: 0,
  consts: [[3, "field"]],
  template: function _FormlyGroup_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrepeaterCreate"](0, _FormlyGroup_For_1_Template, 1, 1, "formly-field", 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrepeaterTrackByIndex"]);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](2);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrepeater"](ctx.field.fieldGroup);
    }
  },
  dependencies: [LegacyFormlyField],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyGroup, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-group',
      template: `
    @for (f of field.fieldGroup; track $index) {
      <formly-field [field]="f"></formly-field>
    }
    <ng-content></ng-content>
  `,
      host: {
        '[class]': 'field.fieldGroupClassName || ""'
      },
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();

/**
 * An InjectionToken for registering additional formly config options (types, wrappers ...).
 */
const FORMLY_CONFIG = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('FORMLY_CONFIG');
function withDefaultConfig(config) {
  return {
    types: [{
      name: 'formly-group',
      component: FormlyGroup
    }, {
      name: 'formly-template',
      component: FormlyTemplateType
    }],
    extensions: [{
      name: 'core',
      extension: new CoreExtension(config),
      priority: -250
    }, {
      name: 'field-validation',
      extension: new FieldValidationExtension(config),
      priority: -200
    }, {
      name: 'field-form',
      extension: new FieldFormExtension(),
      priority: -150
    }, {
      name: 'field-expression',
      extension: new FieldExpressionExtension(),
      priority: -100
    }]
  };
}
const provideFormlyCore = (configs = []) => {
  return [{
    provide: FORMLY_CONFIG,
    multi: true,
    useFactory: withDefaultConfig,
    deps: [FormlyConfig]
  }, provideFormlyConfig(configs)];
};
const provideFormlyConfig = (configs = []) => {
  return [{
    provide: FORMLY_CONFIG,
    multi: true,
    useValue: configs
  }];
};
class FormlyFormBuilder {
  constructor(config, injector, viewContainerRef, parentForm, configs = []) {
    this.config = config;
    this.injector = injector;
    this.viewContainerRef = viewContainerRef;
    this.parentForm = parentForm;
    if (configs) {
      configs.forEach(c => config.addConfig(c));
    }
  }
  buildForm(form, fieldGroup = [], model, options) {
    this.build({
      fieldGroup,
      model,
      form,
      options
    });
  }
  build(field) {
    if (!this.config.extensions.core) {
      throw new Error('NgxFormly: missing `forRoot()` call. use `forRoot()` when registering the `FormlyModule`.');
    }
    if (!field.parent) {
      this._setOptions(field);
    }
    disableTreeValidityCall(field.form, () => {
      this._build(field);
      // TODO: add test for https://github.com/ngx-formly/ngx-formly/issues/3910
      if (!field.parent || field.fieldArray) {
        var _options$checkExpress, _options$_detectChang;
        // detect changes early to avoid reset value by hidden fields
        const options = field.options;
        if (field.parent && isHiddenField(field)) {
          var _options$_hiddenField;
          // when hide is used in expression set defaul value will not be set until detect hide changes
          // which causes default value not set on new item is added
          (_options$_hiddenField = options._hiddenFieldsForCheck) === null || _options$_hiddenField === void 0 || _options$_hiddenField.push({
            field,
            default: false
          });
        }
        (_options$checkExpress = options.checkExpressions) === null || _options$checkExpress === void 0 || _options$checkExpress.call(options, field, true);
        (_options$_detectChang = options._detectChanges) === null || _options$_detectChang === void 0 || _options$_detectChang.call(options, field);
      }
    });
  }
  _build(field) {
    var _field$fieldGroup5;
    if (!field) {
      return;
    }
    const extensions = Object.values(this.config.extensions);
    extensions.forEach(extension => {
      var _extension$prePopulat;
      return (_extension$prePopulat = extension.prePopulate) === null || _extension$prePopulat === void 0 ? void 0 : _extension$prePopulat.call(extension, field);
    });
    extensions.forEach(extension => {
      var _extension$onPopulate;
      return (_extension$onPopulate = extension.onPopulate) === null || _extension$onPopulate === void 0 ? void 0 : _extension$onPopulate.call(extension, field);
    });
    (_field$fieldGroup5 = field.fieldGroup) === null || _field$fieldGroup5 === void 0 || _field$fieldGroup5.forEach(f => this._build(f));
    extensions.forEach(extension => {
      var _extension$postPopula;
      return (_extension$postPopula = extension.postPopulate) === null || _extension$postPopula === void 0 ? void 0 : _extension$postPopula.call(extension, field);
    });
  }
  _setOptions(field) {
    field.form = field.form || new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormGroup({});
    field.model = field.model || {};
    field.options = field.options || {};
    const options = field.options;
    if (!options._viewContainerRef) {
      defineHiddenProp(options, '_viewContainerRef', this.viewContainerRef);
    }
    if (!options._injector) {
      defineHiddenProp(options, '_injector', this.injector);
    }
    if (!options.build) {
      options.build = (f = field) => {
        this.build(f);
        return f;
      };
    }
    if (!options.parentForm && this.parentForm) {
      defineHiddenProp(options, 'parentForm', this.parentForm);
      if (!isSignalRequired()) {
        observe(options, ['parentForm', 'submitted'], ({
          firstChange
        }) => {
          if (!firstChange) {
            options.detectChanges(field);
          }
        });
      }
    }
  }
}
_FormlyFormBuilder = FormlyFormBuilder;
_FormlyFormBuilder.ɵfac = function _FormlyFormBuilder_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyFormBuilder)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](FormlyConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormGroupDirective, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](FORMLY_CONFIG, 8));
};
_FormlyFormBuilder.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
  token: _FormlyFormBuilder,
  factory: _FormlyFormBuilder.ɵfac,
  providedIn: 'root'
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyFormBuilder, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], () => [{
    type: FormlyConfig
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
    }]
  }, {
    type: _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormGroupDirective,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
    }]
  }, {
    type: undefined,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject,
      args: [FORMLY_CONFIG]
    }]
  }], null);
})();

/**
 * The `<form-form>` component is the main container of the form,
 * which takes care of managing the form state
 * and delegates the rendering of each field to `<formly-field>` component.
 */
class FormlyForm {
  /** The form instance which allow to track model value and validation status. */
  set form(form) {
    this.field.form = form;
  }
  get form() {
    return this.field.form;
  }
  /** The model to be represented by the form. */
  set model(model) {
    if (this.config.extras.immutable && this._modelChangeValue === model) {
      return;
    }
    this.setField({
      model
    });
  }
  get model() {
    return this.field.model;
  }
  /** The field configurations for building the form. */
  set fields(fieldGroup) {
    this.setField({
      fieldGroup
    });
  }
  get fields() {
    return this.field.fieldGroup;
  }
  /** Options for the form. */
  set options(options) {
    this.setField({
      options
    });
  }
  get options() {
    return this.field.options;
  }
  set templates(templates) {
    this.fieldTemplates.templates = templates;
  }
  constructor(builder, config, ngZone, fieldTemplates) {
    this.builder = builder;
    this.config = config;
    this.ngZone = ngZone;
    this.fieldTemplates = fieldTemplates;
    /** Event that is emitted when the model value is changed */
    this.modelChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this.field = {
      type: 'formly-group'
    };
    this._modelChangeValue = {};
    this.valueChangesUnsubscribe = () => {};
  }
  ngDoCheck() {
    if (this.config.extras.checkExpressionOn === 'changeDetectionCheck') {
      this.checkExpressionChange();
    }
  }
  ngOnChanges(changes) {
    if (changes.fields && this.form) {
      clearControl(this.form);
    }
    if (changes.fields || changes.form || changes.model && this._modelChangeValue !== changes.model.currentValue) {
      this.valueChangesUnsubscribe();
      this.builder.build(this.field);
      this.valueChangesUnsubscribe = this.valueChanges();
    }
  }
  ngOnDestroy() {
    this.valueChangesUnsubscribe();
    this.config.clearRefs();
  }
  checkExpressionChange() {
    var _this$field$options$c, _this$field$options;
    (_this$field$options$c = (_this$field$options = this.field.options).checkExpressions) === null || _this$field$options$c === void 0 || _this$field$options$c.call(_this$field$options, this.field);
  }
  valueChanges() {
    this.valueChangesUnsubscribe();
    let formEvents = null;
    if (isSignalRequired()) {
      var _this$options2;
      let submitted = (_this$options2 = this.options) === null || _this$options2 === void 0 || (_this$options2 = _this$options2.parentForm) === null || _this$options2 === void 0 ? void 0 : _this$options2.submitted;
      formEvents = this.form.events.subscribe(() => {
        var _this$options3;
        if (submitted !== ((_this$options3 = this.options) === null || _this$options3 === void 0 || (_this$options3 = _this$options3.parentForm) === null || _this$options3 === void 0 ? void 0 : _this$options3.submitted)) {
          var _this$options4;
          this.options.detectChanges(this.field);
          submitted = (_this$options4 = this.options) === null || _this$options4 === void 0 || (_this$options4 = _this$options4.parentForm) === null || _this$options4 === void 0 ? void 0 : _this$options4.submitted;
        }
      });
    }
    const fieldChangesDetection = [observeDeep(this.field.options, ['formState'], () => this.field.options.detectChanges(this.field))];
    const valueChanges = this.field.options.fieldChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.filter)(({
      field,
      type
    }) => hasKey(field) && type === 'valueChanges'), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.switchMap)(() => isNoopNgZone(this.ngZone) ? (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.of)(null) : this.ngZone.onStable.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.take)(1)))).subscribe(() => this.ngZone.runGuarded(() => {
      // runGuarded is used to keep in sync the expression changes
      // https://github.com/ngx-formly/ngx-formly/issues/2095
      this.checkExpressionChange();
      this.modelChange.emit(this._modelChangeValue = clone(this.model));
    }));
    return () => {
      var _formEvents;
      fieldChangesDetection.forEach(fnc => fnc());
      (_formEvents = formEvents) === null || _formEvents === void 0 || _formEvents.unsubscribe();
      valueChanges.unsubscribe();
    };
  }
  setField(field) {
    if (this.config.extras.immutable) {
      this.field = {
        ...this.field,
        ...clone(field)
      };
    } else {
      Object.keys(field).forEach(p => this.field[p] = field[p]);
    }
  }
}
_FormlyForm = FormlyForm;
_FormlyForm.ɵfac = function _FormlyForm_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyForm)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyFormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyFieldTemplates));
};
_FormlyForm.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyForm,
  selectors: [["formly-form"]],
  contentQueries: function _FormlyForm_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, FormlyTemplate, 4);
    }
    if (rf & 2) {
      let _t;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.templates = _t);
    }
  },
  inputs: {
    form: "form",
    model: "model",
    fields: "fields",
    options: "options"
  },
  outputs: {
    modelChange: "modelChange"
  },
  standalone: true,
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([FormlyFormBuilder, FormlyFieldTemplates]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵStandaloneFeature"]],
  decls: 1,
  vars: 1,
  consts: [[3, "field"]],
  template: function _FormlyForm_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "formly-field", 0);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("field", ctx.field);
    }
  },
  dependencies: [FormlyField],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyForm, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-form',
      template: '<formly-field [field]="field"></formly-field>',
      providers: [FormlyFormBuilder, FormlyFieldTemplates],
      imports: [FormlyField],
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      standalone: true
    }]
  }], () => [{
    type: FormlyFormBuilder
  }, {
    type: FormlyConfig
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone
  }, {
    type: FormlyFieldTemplates
  }], {
    form: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    model: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    fields: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    options: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }],
    modelChange: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Output
    }],
    templates: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ContentChildren,
      args: [FormlyTemplate]
    }]
  });
})();
class LegacyFormlyForm extends FormlyForm {}
_LegacyFormlyForm = LegacyFormlyForm;
_LegacyFormlyForm.ɵfac = /* @__PURE__ */(() => {
  let ɵ_LegacyFormlyForm_BaseFactory;
  return function _LegacyFormlyForm_Factory(__ngFactoryType__) {
    return (ɵ_LegacyFormlyForm_BaseFactory || (ɵ_LegacyFormlyForm_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_LegacyFormlyForm)))(__ngFactoryType__ || _LegacyFormlyForm);
  };
})();
_LegacyFormlyForm.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _LegacyFormlyForm,
  selectors: [["formly-form"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([FormlyFormBuilder, FormlyFieldTemplates]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 1,
  vars: 1,
  consts: [[3, "field"]],
  template: function _LegacyFormlyForm_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "formly-field", 0);
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("field", ctx.field);
    }
  },
  dependencies: [LegacyFormlyField],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](LegacyFormlyForm, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-form',
      template: '<formly-field [field]="field"></formly-field>',
      providers: [FormlyFormBuilder, FormlyFieldTemplates],
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      standalone: false
    }]
  }], null, null);
})();

/**
 * Allow to link the `field` HTML attributes (`id`, `name` ...) and Event attributes (`focus`, `blur` ...) to an element in the DOM.
 */
class FormlyAttributes {
  get props() {
    return this.field.props || {};
  }
  get fieldAttrElements() {
    var _this$field3;
    return ((_this$field3 = this.field) === null || _this$field3 === void 0 ? void 0 : _this$field3['_elementRefs']) || [];
  }
  constructor(renderer, elementRef, _document) {
    this.renderer = renderer;
    this.elementRef = elementRef;
    this.uiAttributesCache = {};
    /**
     * HostBinding doesn't register listeners conditionally which may produce some perf issues.
     *
     * Formly issue: https://github.com/ngx-formly/ngx-formly/issues/1991
     */
    this.uiEvents = {
      listeners: [],
      events: ['click', 'keyup', 'keydown', 'keypress', 'focus', 'blur', 'change', 'wheel'],
      callback: (eventName, $event) => {
        switch (eventName) {
          case 'focus':
            return this.onFocus($event);
          case 'blur':
            return this.onBlur($event);
          case 'change':
            return this.onChange($event);
          default:
            return this.props[eventName](this.field, $event);
        }
      }
    };
    this.document = _document;
  }
  ngOnChanges(changes) {
    if (changes.field) {
      var _this$props2;
      this.field.name && this.setAttribute('name', this.field.name);
      this.uiEvents.listeners.forEach(listener => listener());
      this.uiEvents.events.forEach(eventName => {
        var _this$props;
        if ((_this$props = this.props) !== null && _this$props !== void 0 && _this$props[eventName] || ['focus', 'blur', 'change'].indexOf(eventName) !== -1) {
          this.uiEvents.listeners.push(this.renderer.listen(this.elementRef.nativeElement, eventName, e => this.uiEvents.callback(eventName, e)));
        }
      });
      if ((_this$props2 = this.props) !== null && _this$props2 !== void 0 && _this$props2.attributes) {
        observe(this.field, ['props', 'attributes'], ({
          currentValue,
          previousValue
        }) => {
          if (previousValue) {
            Object.keys(previousValue).forEach(attr => this.removeAttribute(attr));
          }
          if (currentValue) {
            Object.keys(currentValue).forEach(attr => {
              if (currentValue[attr] != null) {
                this.setAttribute(attr, currentValue[attr]);
              }
            });
          }
        });
      }
      this.detachElementRef(changes.field.previousValue);
      this.attachElementRef(changes.field.currentValue);
      if (this.fieldAttrElements.length === 1) {
        !this.id && this.field.id && this.setAttribute('id', this.field.id);
        this.focusObserver = observe(this.field, ['focus'], ({
          currentValue
        }) => {
          this.toggleFocus(currentValue);
        });
      }
    }
    if (changes.id) {
      this.setAttribute('id', this.id);
    }
  }
  /**
   * We need to re-evaluate all the attributes on every change detection cycle, because
   * by using a HostBinding we run into certain edge cases. This means that whatever logic
   * is in here has to be super lean or we risk seriously damaging or destroying the performance.
   *
   * Formly issue: https://github.com/ngx-formly/ngx-formly/issues/1317
   * Material issue: https://github.com/angular/components/issues/14024
   */
  ngDoCheck() {
    if (!this.uiAttributes) {
      const element = this.elementRef.nativeElement;
      this.uiAttributes = [...FORMLY_VALIDATORS, 'tabindex', 'placeholder', 'readonly', 'disabled', 'step'].filter(attr => !element.hasAttribute || !element.hasAttribute(attr));
    }
    for (let i = 0; i < this.uiAttributes.length; i++) {
      const attr = this.uiAttributes[i];
      const value = this.props[attr];
      if (this.uiAttributesCache[attr] !== value && (!this.props.attributes || !this.props.attributes.hasOwnProperty(attr.toLowerCase()))) {
        this.uiAttributesCache[attr] = value;
        if (value || value === 0) {
          this.setAttribute(attr, value === true ? attr : `${value}`);
        } else {
          this.removeAttribute(attr);
        }
      }
    }
  }
  ngOnDestroy() {
    var _this$focusObserver;
    this.uiEvents.listeners.forEach(listener => listener());
    this.detachElementRef(this.field);
    (_this$focusObserver = this.focusObserver) === null || _this$focusObserver === void 0 || _this$focusObserver.unsubscribe();
  }
  toggleFocus(value) {
    const element = this.fieldAttrElements ? this.fieldAttrElements[0] : null;
    if (!element || !element.nativeElement.focus) {
      return;
    }
    const isFocused = !!this.document.activeElement && this.fieldAttrElements.some(({
      nativeElement
    }) => this.document.activeElement === nativeElement || nativeElement.contains(this.document.activeElement));
    if (value && !isFocused) {
      Promise.resolve().then(() => element.nativeElement.focus());
    } else if (!value && isFocused) {
      Promise.resolve().then(() => element.nativeElement.blur());
    }
  }
  onFocus($event) {
    var _this$focusObserver2, _this$props$focus, _this$props3;
    (_this$focusObserver2 = this.focusObserver) === null || _this$focusObserver2 === void 0 || _this$focusObserver2.setValue(true);
    (_this$props$focus = (_this$props3 = this.props).focus) === null || _this$props$focus === void 0 || _this$props$focus.call(_this$props3, this.field, $event);
  }
  onBlur($event) {
    var _this$focusObserver3, _this$props$blur, _this$props4;
    (_this$focusObserver3 = this.focusObserver) === null || _this$focusObserver3 === void 0 || _this$focusObserver3.setValue(false);
    (_this$props$blur = (_this$props4 = this.props).blur) === null || _this$props$blur === void 0 || _this$props$blur.call(_this$props4, this.field, $event);
  }
  // handle custom `change` event, for regular ones rely on DOM listener
  onHostChange($event) {
    if ($event instanceof Event) {
      return;
    }
    this.onChange($event);
  }
  onChange($event) {
    var _this$props$change, _this$props5, _this$field$formContr;
    (_this$props$change = (_this$props5 = this.props).change) === null || _this$props$change === void 0 || _this$props$change.call(_this$props5, this.field, $event);
    (_this$field$formContr = this.field.formControl) === null || _this$field$formContr === void 0 || _this$field$formContr.markAsDirty();
  }
  attachElementRef(f) {
    var _f$_elementRefs;
    if (!f) {
      return;
    }
    if (((_f$_elementRefs = f['_elementRefs']) === null || _f$_elementRefs === void 0 ? void 0 : _f$_elementRefs.indexOf(this.elementRef)) === -1) {
      f['_elementRefs'].push(this.elementRef);
    } else {
      defineHiddenProp(f, '_elementRefs', [this.elementRef]);
    }
  }
  detachElementRef(f) {
    const index = f !== null && f !== void 0 && f['_elementRefs'] ? this.fieldAttrElements.indexOf(this.elementRef) : -1;
    if (index !== -1) {
      f['_elementRefs'].splice(index, 1);
    }
  }
  setAttribute(attr, value) {
    this.renderer.setAttribute(this.elementRef.nativeElement, attr, value);
  }
  removeAttribute(attr) {
    this.renderer.removeAttribute(this.elementRef.nativeElement, attr);
  }
}
_FormlyAttributes = FormlyAttributes;
_FormlyAttributes.ɵfac = function _FormlyAttributes_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyAttributes)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_15__.DOCUMENT));
};
_FormlyAttributes.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _FormlyAttributes,
  selectors: [["", "formlyAttributes", ""]],
  hostBindings: function _FormlyAttributes_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function _FormlyAttributes_change_HostBindingHandler($event) {
        return ctx.onHostChange($event);
      });
    }
  },
  inputs: {
    field: [0, "formlyAttributes", "field"],
    id: "id"
  },
  standalone: true,
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyAttributes, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      selector: '[formlyAttributes]',
      standalone: true,
      host: {
        '(change)': 'onHostChange($event)'
      }
    }]
  }], () => [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2
  }, {
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
  }, {
    type: undefined,
    decorators: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject,
      args: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.DOCUMENT]
    }]
  }], {
    field: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input,
      args: ['formlyAttributes']
    }],
    id: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }]
  });
})();
class LegacyFormlyAttributes extends FormlyAttributes {}
_LegacyFormlyAttributes = LegacyFormlyAttributes;
_LegacyFormlyAttributes.ɵfac = /* @__PURE__ */(() => {
  let ɵ_LegacyFormlyAttributes_BaseFactory;
  return function _LegacyFormlyAttributes_Factory(__ngFactoryType__) {
    return (ɵ_LegacyFormlyAttributes_BaseFactory || (ɵ_LegacyFormlyAttributes_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_LegacyFormlyAttributes)))(__ngFactoryType__ || _LegacyFormlyAttributes);
  };
})();
_LegacyFormlyAttributes.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _LegacyFormlyAttributes,
  selectors: [["", "formlyAttributes", ""]],
  hostBindings: function _LegacyFormlyAttributes_HostBindings(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function _LegacyFormlyAttributes_change_HostBindingHandler($event) {
        return ctx.onHostChange($event);
      });
    }
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](LegacyFormlyAttributes, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive,
    args: [{
      selector: '[formlyAttributes]',
      host: {
        '(change)': 'onHostChange($event)'
      }
    }]
  }], null, null);
})();

/**
 * The `<formly-validation-message>` component renders the error message of a given `field`.
 */
class FormlyValidationMessage {
  constructor(config) {
    this.config = config;
  }
  ngOnChanges() {
    const EXPR_VALIDATORS = FORMLY_VALIDATORS.map(v => `templateOptions.${v}`);
    this.errorMessage$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.merge)(this.field.formControl.statusChanges, !this.field.options ? (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.of)(null) : this.field.options.fieldChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.filter)(({
      field,
      type,
      property
    }) => {
      return field === this.field && type === 'expressionChanges' && (property.indexOf('validation') !== -1 || EXPR_VALIDATORS.indexOf(property) !== -1);
    }))).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.startWith)(null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.switchMap)(() => (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.isObservable)(this.errorMessage) ? this.errorMessage : (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.of)(this.errorMessage)));
  }
  get errorMessage() {
    const fieldForm = this.field.formControl;
    for (const error in fieldForm.errors) {
      if (fieldForm.errors.hasOwnProperty(error)) {
        var _this$field$validatio, _this$field$validator, _this$field$asyncVali;
        let message = this.config.getValidatorMessage(error);
        if (isObject(fieldForm.errors[error])) {
          if (fieldForm.errors[error].errorPath) {
            return undefined;
          }
          if (fieldForm.errors[error].message) {
            message = fieldForm.errors[error].message;
          }
        }
        if ((_this$field$validatio = this.field.validation) !== null && _this$field$validatio !== void 0 && (_this$field$validatio = _this$field$validatio.messages) !== null && _this$field$validatio !== void 0 && _this$field$validatio[error]) {
          message = this.field.validation.messages[error];
        }
        if ((_this$field$validator = this.field.validators) !== null && _this$field$validator !== void 0 && (_this$field$validator = _this$field$validator[error]) !== null && _this$field$validator !== void 0 && _this$field$validator.message) {
          message = this.field.validators[error].message;
        }
        if ((_this$field$asyncVali = this.field.asyncValidators) !== null && _this$field$asyncVali !== void 0 && (_this$field$asyncVali = _this$field$asyncVali[error]) !== null && _this$field$asyncVali !== void 0 && _this$field$asyncVali.message) {
          message = this.field.asyncValidators[error].message;
        }
        if (typeof message === 'function') {
          return message(fieldForm.errors[error], this.field);
        }
        return message;
      }
    }
    return undefined;
  }
}
_FormlyValidationMessage = FormlyValidationMessage;
_FormlyValidationMessage.ɵfac = function _FormlyValidationMessage_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyValidationMessage)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FormlyConfig));
};
_FormlyValidationMessage.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _FormlyValidationMessage,
  selectors: [["formly-validation-message"]],
  inputs: {
    field: "field"
  },
  standalone: true,
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵStandaloneFeature"]],
  decls: 2,
  vars: 3,
  template: function _FormlyValidationMessage_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "async");
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 1, ctx.errorMessage$));
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.AsyncPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyValidationMessage, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-validation-message',
      template: '{{ errorMessage$ | async }}',
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush,
      standalone: true,
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.AsyncPipe]
    }]
  }], () => [{
    type: FormlyConfig
  }], {
    field: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Input
    }]
  });
})();
class LegacyFormlyValidationMessage extends FormlyValidationMessage {}
_LegacyFormlyValidationMessage = LegacyFormlyValidationMessage;
_LegacyFormlyValidationMessage.ɵfac = /* @__PURE__ */(() => {
  let ɵ_LegacyFormlyValidationMessage_BaseFactory;
  return function _LegacyFormlyValidationMessage_Factory(__ngFactoryType__) {
    return (ɵ_LegacyFormlyValidationMessage_BaseFactory || (ɵ_LegacyFormlyValidationMessage_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_LegacyFormlyValidationMessage)))(__ngFactoryType__ || _LegacyFormlyValidationMessage);
  };
})();
_LegacyFormlyValidationMessage.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: _LegacyFormlyValidationMessage,
  selectors: [["formly-validation-message"]],
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]],
  decls: 2,
  vars: 3,
  template: function _LegacyFormlyValidationMessage_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "async");
    }
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 1, ctx.errorMessage$));
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.AsyncPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](LegacyFormlyValidationMessage, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Component,
    args: [{
      selector: 'formly-validation-message',
      template: '{{ errorMessage$ | async }}',
      changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
class FieldArrayType extends FieldType {
  onPopulate(field) {
    if (hasKey(field)) {
      const control = findControl(field);
      registerControl(field, control ? control : new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.UntypedFormArray([], {
        updateOn: field.modelOptions.updateOn
      }));
    }
    field.fieldGroup = field.fieldGroup || [];
    const length = Array.isArray(field.model) ? field.model.length : 0;
    if (field.fieldGroup.length > length) {
      for (let i = field.fieldGroup.length - 1; i >= length; --i) {
        unregisterControl(field.fieldGroup[i], true);
        field.fieldGroup.splice(i, 1);
      }
    }
    for (let i = field.fieldGroup.length; i < length; i++) {
      const f = {
        ...clone(typeof field.fieldArray === 'function' ? field.fieldArray(field) : field.fieldArray)
      };
      if (f.key !== null) {
        f.key = `${i}`;
      }
      field.fieldGroup.push(f);
    }
  }
  add(i, initialModel, {
    markAsDirty
  } = {
    markAsDirty: true
  }) {
    markAsDirty && this.formControl.markAsDirty();
    i = i == null ? this.field.fieldGroup.length : i;
    if (!this.model) {
      assignFieldValue(this.field, []);
    }
    this.model.splice(i, 0, initialModel ? clone(initialModel) : undefined);
    this.markFieldForCheck(this.field.fieldGroup[i]);
    this._build();
  }
  remove(i, {
    markAsDirty
  } = {
    markAsDirty: true
  }) {
    markAsDirty && this.formControl.markAsDirty();
    this.model.splice(i, 1);
    const field = this.field.fieldGroup[i];
    this.field.fieldGroup.splice(i, 1);
    this.field.fieldGroup.forEach((f, key) => this.updateArrayElementKey(f, `${key}`));
    unregisterControl(field, true);
    this._build();
  }
  _build() {
    var _this$field$formContr2;
    const fields = (_this$field$formContr2 = this.field.formControl._fields) !== null && _this$field$formContr2 !== void 0 ? _this$field$formContr2 : [this.field];
    fields.forEach(f => this.options.build(f));
    this.options.fieldChanges.next({
      field: this.field,
      value: getFieldValue(this.field),
      type: 'valueChanges'
    });
  }
  updateArrayElementKey(f, newKey) {
    var _f$fieldGroup2;
    if (hasKey(f)) {
      f.key = newKey;
      return;
    }
    if (!((_f$fieldGroup2 = f.fieldGroup) !== null && _f$fieldGroup2 !== void 0 && _f$fieldGroup2.length)) {
      return;
    }
    for (let i = 0; i < f.fieldGroup.length; i++) {
      this.updateArrayElementKey(f.fieldGroup[i], newKey);
    }
  }
  markFieldForCheck(f) {
    var _f$fieldGroup3;
    if (!f) {
      return;
    }
    (_f$fieldGroup3 = f.fieldGroup) === null || _f$fieldGroup3 === void 0 || _f$fieldGroup3.forEach(c => this.markFieldForCheck(c));
    if (f.hide === false) {
      this.options._hiddenFieldsForCheck.push({
        field: f
      });
    }
  }
}
_FieldArrayType = FieldArrayType;
_FieldArrayType.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FieldArrayType_BaseFactory;
  return function _FieldArrayType_Factory(__ngFactoryType__) {
    return (ɵ_FieldArrayType_BaseFactory || (ɵ_FieldArrayType_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FieldArrayType)))(__ngFactoryType__ || _FieldArrayType);
  };
})();
_FieldArrayType.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _FieldArrayType,
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FieldArrayType, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive
  }], null, null);
})();
class FieldWrapper extends FieldType {
  set _formlyControls(_) {}
  set _staticContent(content) {
    this.fieldComponent = content;
  }
}
_FieldWrapper = FieldWrapper;
_FieldWrapper.ɵfac = /* @__PURE__ */(() => {
  let ɵ_FieldWrapper_BaseFactory;
  return function _FieldWrapper_Factory(__ngFactoryType__) {
    return (ɵ_FieldWrapper_BaseFactory || (ɵ_FieldWrapper_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](_FieldWrapper)))(__ngFactoryType__ || _FieldWrapper);
  };
})();
_FieldWrapper.ɵdir = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: _FieldWrapper,
  viewQuery: function _FieldWrapper_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c2, 5, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c2, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef);
    }
    if (rf & 2) {
      let _t;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.fieldComponent = _t.first);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._staticContent = _t.first);
    }
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FieldWrapper, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Directive
  }], null, {
    fieldComponent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild,
      args: ['fieldComponent', {
        read: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef
      }]
    }],
    _staticContent: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewChild,
      args: ['fieldComponent', {
        read: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef,
        static: true
      }]
    }]
  });
})();
class FormlyModule {
  static forRoot(config = {}) {
    return {
      ngModule: FormlyModule,
      providers: [{
        provide: FORMLY_CONFIG,
        multi: true,
        useFactory: withDefaultConfig,
        deps: [FormlyConfig]
      }, {
        provide: FORMLY_CONFIG,
        useValue: config,
        multi: true
      }, FormlyConfig, FormlyFormBuilder]
    };
  }
  static forChild(config = {}) {
    return {
      ngModule: FormlyModule,
      providers: [{
        provide: FORMLY_CONFIG,
        multi: true,
        useFactory: withDefaultConfig,
        deps: [FormlyConfig]
      }, {
        provide: FORMLY_CONFIG,
        useValue: config,
        multi: true
      }, FormlyFormBuilder]
    };
  }
}
_FormlyModule = FormlyModule;
_FormlyModule.ɵfac = function _FormlyModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FormlyModule)();
};
_FormlyModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: _FormlyModule,
  declarations: [FormlyTemplate, LegacyFormlyForm, LegacyFormlyField, LegacyFormlyAttributes, LegacyFormlyValidationMessage, FormlyGroup, FormlyTemplateType],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.CommonModule],
  exports: [FormlyTemplate, LegacyFormlyForm, LegacyFormlyField, LegacyFormlyAttributes, LegacyFormlyValidationMessage, FormlyGroup]
});
_FormlyModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.CommonModule]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FormlyModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgModule,
    args: [{
      declarations: [FormlyTemplate, LegacyFormlyForm, LegacyFormlyField, LegacyFormlyAttributes, LegacyFormlyValidationMessage, FormlyGroup, FormlyTemplateType],
      exports: [FormlyTemplate, LegacyFormlyForm, LegacyFormlyField, LegacyFormlyAttributes, LegacyFormlyValidationMessage, FormlyGroup],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.CommonModule]
    }]
  }], null, null);
})();

/*
 * Public API Surface of core
 */

/**
 * Generated bundle index. Do not edit.
 */



/***/ })

}]);
//# sourceMappingURL=default-src_app_services_survey_form_api_service_ts-node_modules_ngx-formly_core_fesm2022_ngx-d1e201.js.map